/**
 * vec - a tiny SIMD vector library in C99
 * 
 * Copyright (c) 2024 Paper
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
**/

#ifndef VEC_IMPL_X86_SSE41_H_
#define VEC_IMPL_X86_SSE41_H_

#define VEC_SSE41_OP(NAME, SIGN, BITS, SIZE, INTLSIGN, OP) \
	VEC_FUNC_IMPL v##SIGN##int##BITS##x##SIZE v##SIGN##int##BITS##x##SIZE##_##NAME(v##SIGN##int##BITS##x##SIZE vec1, v##SIGN##int##BITS##x##SIZE vec2) \
	{ \
		vec1.sse = _mm_##OP##_ep##INTLSIGN##BITS(vec1.sse, vec2.sse); \
		return vec1; \
	}

/* vint8x16 */

#ifndef VINT8x16_MIN_DEFINED
VEC_SSE41_OP(min, /* nothing */, 8, 16, i, min)
# define VINT8x16_MIN_DEFINED
#endif

#ifndef VINT8x16_MAX_DEFINED
VEC_SSE41_OP(max, /* nothing */, 8, 16, i, max)
# define VINT8x16_MAX_DEFINED
#endif

/* vuint8x16 */

#ifndef VUINT8x16_MIN_DEFINED
VEC_SSE41_OP(min, u, 8, 16, u, min)
# define VUINT8x16_MIN_DEFINED
#endif

#ifndef VUINT8x16_MAX_DEFINED
VEC_SSE41_OP(max, u, 8, 16, u, max)
# define VUINT8x16_MAX_DEFINED
#endif

/* vint16x8 */

#ifndef VINT16x8_MIN_DEFINED
VEC_SSE41_OP(min, /* nothing */, 16, 8, i, min)
# define VINT16x8_MIN_DEFINED
#endif

#ifndef VINT16x8_MAX_DEFINED
VEC_SSE41_OP(max, /* nothing */, 16, 8, i, max)
# define VINT16x8_MAX_DEFINED
#endif

/* vuint8x16 */

#ifndef VUINT16x8_MIN_DEFINED
VEC_SSE41_OP(min, u, 16, 8, u, min)
# define VUINT16x8_MIN_DEFINED
#endif

#ifndef VUINT16x8_MAX_DEFINED
VEC_SSE41_OP(max, u, 16, 8, u, max)
# define VUINT16x8_MAX_DEFINED
#endif

/* vint32x4 */

#ifndef VINT32x4_MUL_DEFINED
VEC_SSE41_OP(mul, /* nothing */, 32, 4, i, mullo)
# define VINT32x4_MUL_DEFINED
#endif

#ifndef VINT32x4_MIN_DEFINED
VEC_SSE41_OP(min, /* nothing */, 32, 4, i, min)
# define VINT32x4_MIN_DEFINED
#endif

#ifndef VINT32x4_MAX_DEFINED
VEC_SSE41_OP(max, /* nothing */, 32, 4, i, max)
# define VINT32x4_MAX_DEFINED
#endif

/* vuint32x4 */

#ifndef VUINT32x4_MUL_DEFINED
VEC_SSE41_OP(mul, u, 32, 4, i, mullo)
# define VUINT32x4_MUL_DEFINED
#endif

#ifndef VUINT32x4_MIN_DEFINED
VEC_SSE41_OP(min, u, 32, 4, u, min)
# define VUINT32x4_MIN_DEFINED
#endif

#ifndef VUINT32x4_MAX_DEFINED
VEC_SSE41_OP(max, u, 32, 4, u, max)
# define VUINT32x4_MAX_DEFINED
#endif

/* vint64x2 */

#ifndef VINT64x2_CMPEQ_DEFINED
VEC_SSE41_OP(cmpeq, /* nothing */, 64, 2, i, cmpeq)
# define VINT64x2_CMPEQ_DEFINED
#endif

/* vuint64x2 */

#ifndef VUINT64x2_CMPEQ_DEFINED
VEC_SSE41_OP(cmpeq, u, 64, 2, i, cmpeq)
# define VUINT64x2_CMPEQ_DEFINED
#endif

#endif /* VEC_IMPL_X86_SSE41_H_ */
