
/* ------------------------------------------------------------------------ */
/* simple benchmark for getting the min/max range of an audio sample. */

extern void test_benchmark_sample_minmax_simple_impl(int16_t *smpl, uint32_t length, int32_t *pmin, int32_t *pmax);
extern void test_benchmark_sample_minmax_vec_impl(int16_t *smpl, uint32_t length, int32_t *pmin, int32_t *pmax);

VEC_FUNC_IMPL void test_benchmark_sample_minmax(void)
{
	int32_t min, max;
	clock_t start, end;
	int i;
	int16_t *q = vec_malloc(16000001u * 2u);

	printf("\nsigned 16-bit audio sample min/max - 1 thousand passes - 16000001 samples\n\n");

	/* generate random sample values */
	for (i = 0; i < 16000001; i++)
		q[i] = rand();

	start = clock();
	for (i = 0; i < 1000; i++) {
		min = INT32_MAX;
		max = INT32_MIN;
		test_benchmark_sample_minmax_vec_impl(q, 16000001u, &min, &max);
	}
	end = clock();

	printf("- vec: took %f secs\n", (double)(end - start) / CLOCKS_PER_SEC);

	start = clock();
	for (i = 0; i < 1000; i++) {
		min = INT32_MAX;
		max = INT32_MIN;
		test_benchmark_sample_minmax_simple_impl(q, 16000001u, &min, &max);
	}
	end = clock();

	printf("- simple: took %f secs\n", (double)(end - start) / CLOCKS_PER_SEC);

	printf("\n");

	vec_free(q);
}

static void test_benchmark(void)
{
	printf("------- BENCHMARK --------\n");
	test_benchmark_sample_minmax();
}
