#define CREATE_TEST(sign, psign, bits, size, op, equiv) \
	static int test_compare_v##sign##int##bits##x##size##_##op(v##sign##int##bits##x##size a, v##sign##int##bits##x##size b) \
	{ \
		sign##int##bits##_t orig_a[size], orig_b[size], orig_c[size]; \
	\
		v##sign##int##bits##x##size c = v##sign##int##bits##x##size##_##op(a, b); \
	\
		v##sign##int##bits##x##size##_store(a, orig_a); \
		v##sign##int##bits##x##size##_store(b, orig_b); \
		v##sign##int##bits##x##size##_store(c, orig_c); \
	\
		for (int i = 0; i < size; i++) { \
			if ((sign##int##bits##_t)(((equiv) ? UINT##bits##_MAX : 0)) != orig_c[i]) { \
				fprintf(stderr, "v" #sign "int" #bits "x" #size "_" #op " test FAILED at index %d: (" #equiv ") [%" PRI ## psign ## bits "] does not equal result [%" PRI ## psign ## bits "]!\n", i, equiv, orig_c[i]); \
				print_v##sign##int##bits##x##size(stderr,a); \
				print_v##sign##int##bits##x##size(stderr,b); \
				print_v##sign##int##bits##x##size(stderr,c); \
				fprintf(stderr, "\n"); \
				return 1; \
			} \
		} \
	\
		return 0; \
	}

#define CREATE_TESTS_SIGN(sign, psign, bits, size) \
	CREATE_TEST(sign, psign, bits, size, cmplt, orig_a[i] < orig_b[i]) \
	CREATE_TEST(sign, psign, bits, size, cmpgt, orig_a[i] > orig_b[i]) \
	CREATE_TEST(sign, psign, bits, size, cmpeq, orig_a[i] == orig_b[i]) \
	CREATE_TEST(sign, psign, bits, size, cmple, orig_a[i] <= orig_b[i]) \
	CREATE_TEST(sign, psign, bits, size, cmpge, orig_a[i] >= orig_b[i])

#define CREATE_TESTS(bits, size) CREATE_TESTS_SIGN(, d, bits, size) CREATE_TESTS_SIGN(u, u, bits, size)

CREATE_TESTS(8, 16)
CREATE_TESTS(16, 8)
CREATE_TESTS(32, 4)
CREATE_TESTS(64, 2)

CREATE_TESTS(8, 32)
CREATE_TESTS(16, 16)
CREATE_TESTS(32, 8)
CREATE_TESTS(64, 4)

CREATE_TESTS(8, 64)
CREATE_TESTS(16, 32)
CREATE_TESTS(32, 16)
CREATE_TESTS(64, 8)

#undef CREATE_TESTS_SIGN
#undef CREATE_TESTS
#undef CREATE_TEST

static int test_compare(void)
{
	int ret = 0;

#define RUN_TESTS_SIGN(sign, bits, size) \
	for (size_t i = 0U; i < ARRAY_SIZE(testval##sign##bits); i++) { \
		const v##sign##int##bits##x##size a = vtest##sign##bits##x##size(i); \
		for (size_t j = 0U; j < ARRAY_SIZE(testval##sign##bits); j++) { \
			const v##sign##int##bits##x##size b = vtest##sign##bits##x##size(j); \
			ret |= test_compare_v##sign##int##bits##x##size##_cmplt(a, b); \
			ret |= test_compare_v##sign##int##bits##x##size##_cmpgt(a, b); \
			ret |= test_compare_v##sign##int##bits##x##size##_cmpeq(a, b); \
			ret |= test_compare_v##sign##int##bits##x##size##_cmple(a, b); \
			ret |= test_compare_v##sign##int##bits##x##size##_cmpge(a, b); \
		} \
	}

#define RUN_TESTS(bits, size) \
	RUN_TESTS_SIGN( , bits, size) \
	RUN_TESTS_SIGN(u, bits, size)

	RUN_TESTS(8, 16)
	RUN_TESTS(16, 8)
	RUN_TESTS(32, 4)
	RUN_TESTS(64, 2)

	RUN_TESTS(8, 32)
	RUN_TESTS(16, 16)
	RUN_TESTS(32, 8)
	RUN_TESTS(64, 4)

	RUN_TESTS(8, 64)
	RUN_TESTS(16, 32)
	RUN_TESTS(32, 16)
	RUN_TESTS(64, 8)

#undef RUN_TESTS_SIGN
#undef RUN_TESTS

	return ret;
}