/**
 * vec - a tiny SIMD vector library in C99
 * 
 * Copyright (c) 2024-2025 Paper
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
**/

/* This file is automatically generated! Do not edit it directly!
 * Edit the code that generates it in utils/gengeneric.c  --paper */

/* ------------------------------------------------------------------------ */
/* PREPROCESSOR HELL INCOMING */

#if !defined(VINT8x2_SPLAT_DEFINED)
VEC_FUNC_IMPL vint8x2 vint8x2_splat(vec_int8 x)
{
	vint8x2 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	return vec;
}
# define VINT8x2_SPLAT_DEFINED
#endif
#if !defined(VINT8x2_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vint8x2 vint8x2_load_aligned(const vec_int8 x[2])
{
	vint8x2 vec;
	memcpy(vec.generic, x, 2);
	return vec;
}
# define VINT8x2_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VINT8x2_LOAD_DEFINED)
VEC_FUNC_IMPL vint8x2 vint8x2_load(const vec_int8 x[2])
{
	vint8x2 vec;
	memcpy(vec.generic, x, 2);
	return vec;
}
# define VINT8x2_LOAD_DEFINED
#endif
#if !defined(VINT8x2_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vint8x2_store_aligned(vint8x2 vec, vec_int8 x[2])
{
	memcpy(x, vec.generic, 2);
}
# define VINT8x2_STORE_ALIGNED_DEFINED
#endif
#if !defined(VINT8x2_STORE_DEFINED)
VEC_FUNC_IMPL void vint8x2_store(vint8x2 vec, vec_int8 x[2])
{
	memcpy(x, vec.generic, 2);
}
# define VINT8x2_STORE_DEFINED
#endif
#if !defined(VINT8x2_ADD_DEFINED)
VEC_FUNC_IMPL vint8x2 vint8x2_add(vint8x2 vec1, vint8x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	return vec1;
}
# define VINT8x2_ADD_DEFINED
#endif
#if !defined(VINT8x2_SUB_DEFINED)
VEC_FUNC_IMPL vint8x2 vint8x2_sub(vint8x2 vec1, vint8x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	return vec1;
}
# define VINT8x2_SUB_DEFINED
#endif
#if !defined(VINT8x2_MUL_DEFINED)
VEC_FUNC_IMPL vint8x2 vint8x2_mul(vint8x2 vec1, vint8x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	return vec1;
}
# define VINT8x2_MUL_DEFINED
#endif
#if !defined(VINT8x2_DIV_DEFINED)
VEC_FUNC_IMPL vint8x2 vint8x2_div(vint8x2 vec1, vint8x2 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	return vec1;
}
# define VINT8x2_DIV_DEFINED
#endif
#if !defined(VINT8x2_MOD_DEFINED)
VEC_FUNC_IMPL vint8x2 vint8x2_mod(vint8x2 vec1, vint8x2 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	return vec1;
}
# define VINT8x2_MOD_DEFINED
#endif
#if !defined(VINT8x2_AVG_DEFINED)
VEC_FUNC_IMPL vint8x2 vint8x2_avg(vint8x2 vec1, vint8x2 vec2)
{
	vec_int8 x_d_rem, y_d_rem, rem_d_quot, rem_d_rem;
	x_d_rem = (vec1.generic[0] % 2);
	y_d_rem = (vec2.generic[0] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[0] = ((vec1.generic[0] / 2) + (vec2.generic[0] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[1] % 2);
	y_d_rem = (vec2.generic[1] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[1] = ((vec1.generic[1] / 2) + (vec2.generic[1] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	return vec1;
}
# define VINT8x2_AVG_DEFINED
#endif
#if !defined(VINT8x2_AND_DEFINED)
VEC_FUNC_IMPL vint8x2 vint8x2_and(vint8x2 vec1, vint8x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	return vec1;
}
# define VINT8x2_AND_DEFINED
#endif
#if !defined(VINT8x2_OR_DEFINED)
VEC_FUNC_IMPL vint8x2 vint8x2_or(vint8x2 vec1, vint8x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	return vec1;
}
# define VINT8x2_OR_DEFINED
#endif
#if !defined(VINT8x2_XOR_DEFINED)
VEC_FUNC_IMPL vint8x2 vint8x2_xor(vint8x2 vec1, vint8x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	return vec1;
}
# define VINT8x2_XOR_DEFINED
#endif
#if !defined(VINT8x2_NOT_DEFINED)
VEC_FUNC_IMPL vint8x2 vint8x2_not(vint8x2 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	return vec;
}
# define VINT8x2_NOT_DEFINED
#endif
#if !defined(VINT8x2_CMPLT_DEFINED)
VEC_FUNC_IMPL vint8x2 vint8x2_cmplt(vint8x2 vec1, vint8x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x2_CMPLT_DEFINED
#endif
#if !defined(VINT8x2_CMPEQ_DEFINED)
VEC_FUNC_IMPL vint8x2 vint8x2_cmpeq(vint8x2 vec1, vint8x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x2_CMPEQ_DEFINED
#endif
#if !defined(VINT8x2_CMPGT_DEFINED)
VEC_FUNC_IMPL vint8x2 vint8x2_cmpgt(vint8x2 vec1, vint8x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x2_CMPGT_DEFINED
#endif
#if !defined(VINT8x2_CMPLE_DEFINED)
VEC_FUNC_IMPL vint8x2 vint8x2_cmple(vint8x2 vec1, vint8x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x2_CMPLE_DEFINED
#endif
#if !defined(VINT8x2_CMPGE_DEFINED)
VEC_FUNC_IMPL vint8x2 vint8x2_cmpge(vint8x2 vec1, vint8x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x2_CMPGE_DEFINED
#endif
#if !defined(VINT8x2_MIN_DEFINED)
VEC_FUNC_IMPL vint8x2 vint8x2_min(vint8x2 vec1, vint8x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	return vec1;
}
# define VINT8x2_MIN_DEFINED
#endif
#if !defined(VINT8x2_MAX_DEFINED)
VEC_FUNC_IMPL vint8x2 vint8x2_max(vint8x2 vec1, vint8x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	return vec1;
}
# define VINT8x2_MAX_DEFINED
#endif
#if !defined(VINT8x2_RSHIFT_DEFINED)
VEC_FUNC_IMPL vint8x2 vint8x2_rshift(vint8x2 vec1, vuint8x2 vec2)
{
vec1.generic[0] = ((~vec1.generic[0]) >> vec2.generic[0]);
vec1.generic[1] = ((~vec1.generic[1]) >> vec2.generic[1]);
	return vec1;
}
# define VINT8x2_RSHIFT_DEFINED
#endif
#if !defined(VINT8x2_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vint8x2 vint8x2_lrshift(vint8x2 vec1, vuint8x2 vec2)
{
	union { vec_uint8 u; vec_int8 s; } x;

	x.s = vec1.generic[0];
	x.u >>= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u >>= vec2.generic[1];
	vec1.generic[1] = x.s;
	return vec1;
}
# define VINT8x2_LRSHIFT_DEFINED
#endif
#if !defined(VINT8x2_LSHIFT_DEFINED)
VEC_FUNC_IMPL vint8x2 vint8x2_lshift(vint8x2 vec1, vuint8x2 vec2)
{
	union { vec_uint8 u; vec_int8 s; } x;

	x.s = vec1.generic[0];
	x.u <<= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u <<= vec2.generic[1];
	vec1.generic[1] = x.s;
	return vec1;
}
# define VINT8x2_LSHIFT_DEFINED
#endif
#if !defined(VUINT8x2_SPLAT_DEFINED)
VEC_FUNC_IMPL vuint8x2 vuint8x2_splat(vec_uint8 x)
{
	vuint8x2 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	return vec;
}
# define VUINT8x2_SPLAT_DEFINED
#endif
#if !defined(VUINT8x2_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vuint8x2 vuint8x2_load_aligned(const vec_uint8 x[2])
{
	vuint8x2 vec;
	memcpy(vec.generic, x, 2);
	return vec;
}
# define VUINT8x2_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VUINT8x2_LOAD_DEFINED)
VEC_FUNC_IMPL vuint8x2 vuint8x2_load(const vec_uint8 x[2])
{
	vuint8x2 vec;
	memcpy(vec.generic, x, 2);
	return vec;
}
# define VUINT8x2_LOAD_DEFINED
#endif
#if !defined(VUINT8x2_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vuint8x2_store_aligned(vuint8x2 vec, vec_uint8 x[2])
{
	memcpy(x, vec.generic, 2);
}
# define VUINT8x2_STORE_ALIGNED_DEFINED
#endif
#if !defined(VUINT8x2_STORE_DEFINED)
VEC_FUNC_IMPL void vuint8x2_store(vuint8x2 vec, vec_uint8 x[2])
{
	memcpy(x, vec.generic, 2);
}
# define VUINT8x2_STORE_DEFINED
#endif
#if !defined(VUINT8x2_ADD_DEFINED)
VEC_FUNC_IMPL vuint8x2 vuint8x2_add(vuint8x2 vec1, vuint8x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	return vec1;
}
# define VUINT8x2_ADD_DEFINED
#endif
#if !defined(VUINT8x2_SUB_DEFINED)
VEC_FUNC_IMPL vuint8x2 vuint8x2_sub(vuint8x2 vec1, vuint8x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	return vec1;
}
# define VUINT8x2_SUB_DEFINED
#endif
#if !defined(VUINT8x2_MUL_DEFINED)
VEC_FUNC_IMPL vuint8x2 vuint8x2_mul(vuint8x2 vec1, vuint8x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	return vec1;
}
# define VUINT8x2_MUL_DEFINED
#endif
#if !defined(VUINT8x2_DIV_DEFINED)
VEC_FUNC_IMPL vuint8x2 vuint8x2_div(vuint8x2 vec1, vuint8x2 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	return vec1;
}
# define VUINT8x2_DIV_DEFINED
#endif
#if !defined(VUINT8x2_MOD_DEFINED)
VEC_FUNC_IMPL vuint8x2 vuint8x2_mod(vuint8x2 vec1, vuint8x2 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	return vec1;
}
# define VUINT8x2_MOD_DEFINED
#endif
#if !defined(VUINT8x2_AVG_DEFINED)
VEC_FUNC_IMPL vuint8x2 vuint8x2_avg(vuint8x2 vec1, vuint8x2 vec2)
{
vec1.generic[0] = (vec1.generic[0] >> 1) + (vec2.generic[0] >> 1) + ((vec1.generic[0] | vec2.generic[0]) & 1);
vec1.generic[1] = (vec1.generic[1] >> 1) + (vec2.generic[1] >> 1) + ((vec1.generic[1] | vec2.generic[1]) & 1);
	return vec1;
}
# define VUINT8x2_AVG_DEFINED
#endif
#if !defined(VUINT8x2_AND_DEFINED)
VEC_FUNC_IMPL vuint8x2 vuint8x2_and(vuint8x2 vec1, vuint8x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	return vec1;
}
# define VUINT8x2_AND_DEFINED
#endif
#if !defined(VUINT8x2_OR_DEFINED)
VEC_FUNC_IMPL vuint8x2 vuint8x2_or(vuint8x2 vec1, vuint8x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	return vec1;
}
# define VUINT8x2_OR_DEFINED
#endif
#if !defined(VUINT8x2_XOR_DEFINED)
VEC_FUNC_IMPL vuint8x2 vuint8x2_xor(vuint8x2 vec1, vuint8x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	return vec1;
}
# define VUINT8x2_XOR_DEFINED
#endif
#if !defined(VUINT8x2_NOT_DEFINED)
VEC_FUNC_IMPL vuint8x2 vuint8x2_not(vuint8x2 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	return vec;
}
# define VUINT8x2_NOT_DEFINED
#endif
#if !defined(VUINT8x2_CMPLT_DEFINED)
VEC_FUNC_IMPL vuint8x2 vuint8x2_cmplt(vuint8x2 vec1, vuint8x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x2_CMPLT_DEFINED
#endif
#if !defined(VUINT8x2_CMPEQ_DEFINED)
VEC_FUNC_IMPL vuint8x2 vuint8x2_cmpeq(vuint8x2 vec1, vuint8x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x2_CMPEQ_DEFINED
#endif
#if !defined(VUINT8x2_CMPGT_DEFINED)
VEC_FUNC_IMPL vuint8x2 vuint8x2_cmpgt(vuint8x2 vec1, vuint8x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x2_CMPGT_DEFINED
#endif
#if !defined(VUINT8x2_CMPLE_DEFINED)
VEC_FUNC_IMPL vuint8x2 vuint8x2_cmple(vuint8x2 vec1, vuint8x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x2_CMPLE_DEFINED
#endif
#if !defined(VUINT8x2_CMPGE_DEFINED)
VEC_FUNC_IMPL vuint8x2 vuint8x2_cmpge(vuint8x2 vec1, vuint8x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x2_CMPGE_DEFINED
#endif
#if !defined(VUINT8x2_MIN_DEFINED)
VEC_FUNC_IMPL vuint8x2 vuint8x2_min(vuint8x2 vec1, vuint8x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	return vec1;
}
# define VUINT8x2_MIN_DEFINED
#endif
#if !defined(VUINT8x2_MAX_DEFINED)
VEC_FUNC_IMPL vuint8x2 vuint8x2_max(vuint8x2 vec1, vuint8x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	return vec1;
}
# define VUINT8x2_MAX_DEFINED
#endif
#if !defined(VUINT8x2_RSHIFT_DEFINED)
VEC_FUNC_IMPL vuint8x2 vuint8x2_rshift(vuint8x2 vec1, vuint8x2 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	return vec1;
}
# define VUINT8x2_RSHIFT_DEFINED
#endif
#if !defined(VUINT8x2_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vuint8x2 vuint8x2_lrshift(vuint8x2 vec1, vuint8x2 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	return vec1;
}
# define VUINT8x2_LRSHIFT_DEFINED
#endif
#if !defined(VUINT8x2_LSHIFT_DEFINED)
VEC_FUNC_IMPL vuint8x2 vuint8x2_lshift(vuint8x2 vec1, vuint8x2 vec2)
{
	vec1.generic[0] <<= vec2.generic[0];
	vec1.generic[1] <<= vec2.generic[0];
	return vec1;
}
# define VUINT8x2_LSHIFT_DEFINED
#endif
#if !defined(VINT8x4_SPLAT_DEFINED)
VEC_FUNC_IMPL vint8x4 vint8x4_splat(vec_int8 x)
{
	vint8x4 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	return vec;
}
# define VINT8x4_SPLAT_DEFINED
#endif
#if !defined(VINT8x4_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vint8x4 vint8x4_load_aligned(const vec_int8 x[4])
{
	vint8x4 vec;
	memcpy(vec.generic, x, 4);
	return vec;
}
# define VINT8x4_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VINT8x4_LOAD_DEFINED)
VEC_FUNC_IMPL vint8x4 vint8x4_load(const vec_int8 x[4])
{
	vint8x4 vec;
	memcpy(vec.generic, x, 4);
	return vec;
}
# define VINT8x4_LOAD_DEFINED
#endif
#if !defined(VINT8x4_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vint8x4_store_aligned(vint8x4 vec, vec_int8 x[4])
{
	memcpy(x, vec.generic, 4);
}
# define VINT8x4_STORE_ALIGNED_DEFINED
#endif
#if !defined(VINT8x4_STORE_DEFINED)
VEC_FUNC_IMPL void vint8x4_store(vint8x4 vec, vec_int8 x[4])
{
	memcpy(x, vec.generic, 4);
}
# define VINT8x4_STORE_DEFINED
#endif
#if !defined(VINT8x4_ADD_DEFINED)
VEC_FUNC_IMPL vint8x4 vint8x4_add(vint8x4 vec1, vint8x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	return vec1;
}
# define VINT8x4_ADD_DEFINED
#endif
#if !defined(VINT8x4_SUB_DEFINED)
VEC_FUNC_IMPL vint8x4 vint8x4_sub(vint8x4 vec1, vint8x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	return vec1;
}
# define VINT8x4_SUB_DEFINED
#endif
#if !defined(VINT8x4_MUL_DEFINED)
VEC_FUNC_IMPL vint8x4 vint8x4_mul(vint8x4 vec1, vint8x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	return vec1;
}
# define VINT8x4_MUL_DEFINED
#endif
#if !defined(VINT8x4_DIV_DEFINED)
VEC_FUNC_IMPL vint8x4 vint8x4_div(vint8x4 vec1, vint8x4 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	return vec1;
}
# define VINT8x4_DIV_DEFINED
#endif
#if !defined(VINT8x4_MOD_DEFINED)
VEC_FUNC_IMPL vint8x4 vint8x4_mod(vint8x4 vec1, vint8x4 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	return vec1;
}
# define VINT8x4_MOD_DEFINED
#endif
#if !defined(VINT8x4_AVG_DEFINED)
VEC_FUNC_IMPL vint8x4 vint8x4_avg(vint8x4 vec1, vint8x4 vec2)
{
	vec_int8 x_d_rem, y_d_rem, rem_d_quot, rem_d_rem;
	x_d_rem = (vec1.generic[0] % 2);
	y_d_rem = (vec2.generic[0] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[0] = ((vec1.generic[0] / 2) + (vec2.generic[0] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[1] % 2);
	y_d_rem = (vec2.generic[1] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[1] = ((vec1.generic[1] / 2) + (vec2.generic[1] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[2] % 2);
	y_d_rem = (vec2.generic[2] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[2] = ((vec1.generic[2] / 2) + (vec2.generic[2] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[3] % 2);
	y_d_rem = (vec2.generic[3] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[3] = ((vec1.generic[3] / 2) + (vec2.generic[3] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	return vec1;
}
# define VINT8x4_AVG_DEFINED
#endif
#if !defined(VINT8x4_AND_DEFINED)
VEC_FUNC_IMPL vint8x4 vint8x4_and(vint8x4 vec1, vint8x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	return vec1;
}
# define VINT8x4_AND_DEFINED
#endif
#if !defined(VINT8x4_OR_DEFINED)
VEC_FUNC_IMPL vint8x4 vint8x4_or(vint8x4 vec1, vint8x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	return vec1;
}
# define VINT8x4_OR_DEFINED
#endif
#if !defined(VINT8x4_XOR_DEFINED)
VEC_FUNC_IMPL vint8x4 vint8x4_xor(vint8x4 vec1, vint8x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	return vec1;
}
# define VINT8x4_XOR_DEFINED
#endif
#if !defined(VINT8x4_NOT_DEFINED)
VEC_FUNC_IMPL vint8x4 vint8x4_not(vint8x4 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	return vec;
}
# define VINT8x4_NOT_DEFINED
#endif
#if !defined(VINT8x4_CMPLT_DEFINED)
VEC_FUNC_IMPL vint8x4 vint8x4_cmplt(vint8x4 vec1, vint8x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x4_CMPLT_DEFINED
#endif
#if !defined(VINT8x4_CMPEQ_DEFINED)
VEC_FUNC_IMPL vint8x4 vint8x4_cmpeq(vint8x4 vec1, vint8x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x4_CMPEQ_DEFINED
#endif
#if !defined(VINT8x4_CMPGT_DEFINED)
VEC_FUNC_IMPL vint8x4 vint8x4_cmpgt(vint8x4 vec1, vint8x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x4_CMPGT_DEFINED
#endif
#if !defined(VINT8x4_CMPLE_DEFINED)
VEC_FUNC_IMPL vint8x4 vint8x4_cmple(vint8x4 vec1, vint8x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x4_CMPLE_DEFINED
#endif
#if !defined(VINT8x4_CMPGE_DEFINED)
VEC_FUNC_IMPL vint8x4 vint8x4_cmpge(vint8x4 vec1, vint8x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x4_CMPGE_DEFINED
#endif
#if !defined(VINT8x4_MIN_DEFINED)
VEC_FUNC_IMPL vint8x4 vint8x4_min(vint8x4 vec1, vint8x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	return vec1;
}
# define VINT8x4_MIN_DEFINED
#endif
#if !defined(VINT8x4_MAX_DEFINED)
VEC_FUNC_IMPL vint8x4 vint8x4_max(vint8x4 vec1, vint8x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	return vec1;
}
# define VINT8x4_MAX_DEFINED
#endif
#if !defined(VINT8x4_RSHIFT_DEFINED)
VEC_FUNC_IMPL vint8x4 vint8x4_rshift(vint8x4 vec1, vuint8x4 vec2)
{
vec1.generic[0] = ((~vec1.generic[0]) >> vec2.generic[0]);
vec1.generic[1] = ((~vec1.generic[1]) >> vec2.generic[1]);
vec1.generic[2] = ((~vec1.generic[2]) >> vec2.generic[2]);
vec1.generic[3] = ((~vec1.generic[3]) >> vec2.generic[3]);
	return vec1;
}
# define VINT8x4_RSHIFT_DEFINED
#endif
#if !defined(VINT8x4_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vint8x4 vint8x4_lrshift(vint8x4 vec1, vuint8x4 vec2)
{
	union { vec_uint8 u; vec_int8 s; } x;

	x.s = vec1.generic[0];
	x.u >>= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u >>= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u >>= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u >>= vec2.generic[3];
	vec1.generic[3] = x.s;
	return vec1;
}
# define VINT8x4_LRSHIFT_DEFINED
#endif
#if !defined(VINT8x4_LSHIFT_DEFINED)
VEC_FUNC_IMPL vint8x4 vint8x4_lshift(vint8x4 vec1, vuint8x4 vec2)
{
	union { vec_uint8 u; vec_int8 s; } x;

	x.s = vec1.generic[0];
	x.u <<= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u <<= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u <<= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u <<= vec2.generic[3];
	vec1.generic[3] = x.s;
	return vec1;
}
# define VINT8x4_LSHIFT_DEFINED
#endif
#if !defined(VUINT8x4_SPLAT_DEFINED)
VEC_FUNC_IMPL vuint8x4 vuint8x4_splat(vec_uint8 x)
{
	vuint8x4 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	return vec;
}
# define VUINT8x4_SPLAT_DEFINED
#endif
#if !defined(VUINT8x4_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vuint8x4 vuint8x4_load_aligned(const vec_uint8 x[4])
{
	vuint8x4 vec;
	memcpy(vec.generic, x, 4);
	return vec;
}
# define VUINT8x4_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VUINT8x4_LOAD_DEFINED)
VEC_FUNC_IMPL vuint8x4 vuint8x4_load(const vec_uint8 x[4])
{
	vuint8x4 vec;
	memcpy(vec.generic, x, 4);
	return vec;
}
# define VUINT8x4_LOAD_DEFINED
#endif
#if !defined(VUINT8x4_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vuint8x4_store_aligned(vuint8x4 vec, vec_uint8 x[4])
{
	memcpy(x, vec.generic, 4);
}
# define VUINT8x4_STORE_ALIGNED_DEFINED
#endif
#if !defined(VUINT8x4_STORE_DEFINED)
VEC_FUNC_IMPL void vuint8x4_store(vuint8x4 vec, vec_uint8 x[4])
{
	memcpy(x, vec.generic, 4);
}
# define VUINT8x4_STORE_DEFINED
#endif
#if !defined(VUINT8x4_ADD_DEFINED)
VEC_FUNC_IMPL vuint8x4 vuint8x4_add(vuint8x4 vec1, vuint8x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	return vec1;
}
# define VUINT8x4_ADD_DEFINED
#endif
#if !defined(VUINT8x4_SUB_DEFINED)
VEC_FUNC_IMPL vuint8x4 vuint8x4_sub(vuint8x4 vec1, vuint8x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	return vec1;
}
# define VUINT8x4_SUB_DEFINED
#endif
#if !defined(VUINT8x4_MUL_DEFINED)
VEC_FUNC_IMPL vuint8x4 vuint8x4_mul(vuint8x4 vec1, vuint8x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	return vec1;
}
# define VUINT8x4_MUL_DEFINED
#endif
#if !defined(VUINT8x4_DIV_DEFINED)
VEC_FUNC_IMPL vuint8x4 vuint8x4_div(vuint8x4 vec1, vuint8x4 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	return vec1;
}
# define VUINT8x4_DIV_DEFINED
#endif
#if !defined(VUINT8x4_MOD_DEFINED)
VEC_FUNC_IMPL vuint8x4 vuint8x4_mod(vuint8x4 vec1, vuint8x4 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	return vec1;
}
# define VUINT8x4_MOD_DEFINED
#endif
#if !defined(VUINT8x4_AVG_DEFINED)
VEC_FUNC_IMPL vuint8x4 vuint8x4_avg(vuint8x4 vec1, vuint8x4 vec2)
{
vec1.generic[0] = (vec1.generic[0] >> 1) + (vec2.generic[0] >> 1) + ((vec1.generic[0] | vec2.generic[0]) & 1);
vec1.generic[1] = (vec1.generic[1] >> 1) + (vec2.generic[1] >> 1) + ((vec1.generic[1] | vec2.generic[1]) & 1);
vec1.generic[2] = (vec1.generic[2] >> 1) + (vec2.generic[2] >> 1) + ((vec1.generic[2] | vec2.generic[2]) & 1);
vec1.generic[3] = (vec1.generic[3] >> 1) + (vec2.generic[3] >> 1) + ((vec1.generic[3] | vec2.generic[3]) & 1);
	return vec1;
}
# define VUINT8x4_AVG_DEFINED
#endif
#if !defined(VUINT8x4_AND_DEFINED)
VEC_FUNC_IMPL vuint8x4 vuint8x4_and(vuint8x4 vec1, vuint8x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	return vec1;
}
# define VUINT8x4_AND_DEFINED
#endif
#if !defined(VUINT8x4_OR_DEFINED)
VEC_FUNC_IMPL vuint8x4 vuint8x4_or(vuint8x4 vec1, vuint8x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	return vec1;
}
# define VUINT8x4_OR_DEFINED
#endif
#if !defined(VUINT8x4_XOR_DEFINED)
VEC_FUNC_IMPL vuint8x4 vuint8x4_xor(vuint8x4 vec1, vuint8x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	return vec1;
}
# define VUINT8x4_XOR_DEFINED
#endif
#if !defined(VUINT8x4_NOT_DEFINED)
VEC_FUNC_IMPL vuint8x4 vuint8x4_not(vuint8x4 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	return vec;
}
# define VUINT8x4_NOT_DEFINED
#endif
#if !defined(VUINT8x4_CMPLT_DEFINED)
VEC_FUNC_IMPL vuint8x4 vuint8x4_cmplt(vuint8x4 vec1, vuint8x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x4_CMPLT_DEFINED
#endif
#if !defined(VUINT8x4_CMPEQ_DEFINED)
VEC_FUNC_IMPL vuint8x4 vuint8x4_cmpeq(vuint8x4 vec1, vuint8x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x4_CMPEQ_DEFINED
#endif
#if !defined(VUINT8x4_CMPGT_DEFINED)
VEC_FUNC_IMPL vuint8x4 vuint8x4_cmpgt(vuint8x4 vec1, vuint8x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x4_CMPGT_DEFINED
#endif
#if !defined(VUINT8x4_CMPLE_DEFINED)
VEC_FUNC_IMPL vuint8x4 vuint8x4_cmple(vuint8x4 vec1, vuint8x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x4_CMPLE_DEFINED
#endif
#if !defined(VUINT8x4_CMPGE_DEFINED)
VEC_FUNC_IMPL vuint8x4 vuint8x4_cmpge(vuint8x4 vec1, vuint8x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x4_CMPGE_DEFINED
#endif
#if !defined(VUINT8x4_MIN_DEFINED)
VEC_FUNC_IMPL vuint8x4 vuint8x4_min(vuint8x4 vec1, vuint8x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	return vec1;
}
# define VUINT8x4_MIN_DEFINED
#endif
#if !defined(VUINT8x4_MAX_DEFINED)
VEC_FUNC_IMPL vuint8x4 vuint8x4_max(vuint8x4 vec1, vuint8x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	return vec1;
}
# define VUINT8x4_MAX_DEFINED
#endif
#if !defined(VUINT8x4_RSHIFT_DEFINED)
VEC_FUNC_IMPL vuint8x4 vuint8x4_rshift(vuint8x4 vec1, vuint8x4 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	return vec1;
}
# define VUINT8x4_RSHIFT_DEFINED
#endif
#if !defined(VUINT8x4_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vuint8x4 vuint8x4_lrshift(vuint8x4 vec1, vuint8x4 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	return vec1;
}
# define VUINT8x4_LRSHIFT_DEFINED
#endif
#if !defined(VUINT8x4_LSHIFT_DEFINED)
VEC_FUNC_IMPL vuint8x4 vuint8x4_lshift(vuint8x4 vec1, vuint8x4 vec2)
{
	vec1.generic[0] <<= vec2.generic[0];
	vec1.generic[1] <<= vec2.generic[0];
	vec1.generic[2] <<= vec2.generic[0];
	vec1.generic[3] <<= vec2.generic[0];
	return vec1;
}
# define VUINT8x4_LSHIFT_DEFINED
#endif
#if !defined(VINT8x8_SPLAT_DEFINED)
VEC_FUNC_IMPL vint8x8 vint8x8_splat(vec_int8 x)
{
	vint8x8 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	vec.generic[4] = x;
	vec.generic[5] = x;
	vec.generic[6] = x;
	vec.generic[7] = x;
	return vec;
}
# define VINT8x8_SPLAT_DEFINED
#endif
#if !defined(VINT8x8_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vint8x8 vint8x8_load_aligned(const vec_int8 x[8])
{
	vint8x8 vec;
	memcpy(vec.generic, x, 8);
	return vec;
}
# define VINT8x8_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VINT8x8_LOAD_DEFINED)
VEC_FUNC_IMPL vint8x8 vint8x8_load(const vec_int8 x[8])
{
	vint8x8 vec;
	memcpy(vec.generic, x, 8);
	return vec;
}
# define VINT8x8_LOAD_DEFINED
#endif
#if !defined(VINT8x8_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vint8x8_store_aligned(vint8x8 vec, vec_int8 x[8])
{
	memcpy(x, vec.generic, 8);
}
# define VINT8x8_STORE_ALIGNED_DEFINED
#endif
#if !defined(VINT8x8_STORE_DEFINED)
VEC_FUNC_IMPL void vint8x8_store(vint8x8 vec, vec_int8 x[8])
{
	memcpy(x, vec.generic, 8);
}
# define VINT8x8_STORE_DEFINED
#endif
#if !defined(VINT8x8_ADD_DEFINED)
VEC_FUNC_IMPL vint8x8 vint8x8_add(vint8x8 vec1, vint8x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]);
	return vec1;
}
# define VINT8x8_ADD_DEFINED
#endif
#if !defined(VINT8x8_SUB_DEFINED)
VEC_FUNC_IMPL vint8x8 vint8x8_sub(vint8x8 vec1, vint8x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] - vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] - vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] - vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] - vec2.generic[7]);
	return vec1;
}
# define VINT8x8_SUB_DEFINED
#endif
#if !defined(VINT8x8_MUL_DEFINED)
VEC_FUNC_IMPL vint8x8 vint8x8_mul(vint8x8 vec1, vint8x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] * vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] * vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] * vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] * vec2.generic[7]);
	return vec1;
}
# define VINT8x8_MUL_DEFINED
#endif
#if !defined(VINT8x8_DIV_DEFINED)
VEC_FUNC_IMPL vint8x8 vint8x8_div(vint8x8 vec1, vint8x8 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] / vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] / vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] / vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] / vec2.generic[7]) : 0);
	return vec1;
}
# define VINT8x8_DIV_DEFINED
#endif
#if !defined(VINT8x8_MOD_DEFINED)
VEC_FUNC_IMPL vint8x8 vint8x8_mod(vint8x8 vec1, vint8x8 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] % vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] % vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] % vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] % vec2.generic[7]) : 0);
	return vec1;
}
# define VINT8x8_MOD_DEFINED
#endif
#if !defined(VINT8x8_AVG_DEFINED)
VEC_FUNC_IMPL vint8x8 vint8x8_avg(vint8x8 vec1, vint8x8 vec2)
{
	vec_int8 x_d_rem, y_d_rem, rem_d_quot, rem_d_rem;
	x_d_rem = (vec1.generic[0] % 2);
	y_d_rem = (vec2.generic[0] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[0] = ((vec1.generic[0] / 2) + (vec2.generic[0] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[1] % 2);
	y_d_rem = (vec2.generic[1] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[1] = ((vec1.generic[1] / 2) + (vec2.generic[1] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[2] % 2);
	y_d_rem = (vec2.generic[2] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[2] = ((vec1.generic[2] / 2) + (vec2.generic[2] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[3] % 2);
	y_d_rem = (vec2.generic[3] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[3] = ((vec1.generic[3] / 2) + (vec2.generic[3] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[4] % 2);
	y_d_rem = (vec2.generic[4] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[4] = ((vec1.generic[4] / 2) + (vec2.generic[4] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[5] % 2);
	y_d_rem = (vec2.generic[5] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[5] = ((vec1.generic[5] / 2) + (vec2.generic[5] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[6] % 2);
	y_d_rem = (vec2.generic[6] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[6] = ((vec1.generic[6] / 2) + (vec2.generic[6] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[7] % 2);
	y_d_rem = (vec2.generic[7] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[7] = ((vec1.generic[7] / 2) + (vec2.generic[7] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	return vec1;
}
# define VINT8x8_AVG_DEFINED
#endif
#if !defined(VINT8x8_AND_DEFINED)
VEC_FUNC_IMPL vint8x8 vint8x8_and(vint8x8 vec1, vint8x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] & vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] & vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] & vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] & vec2.generic[7]);
	return vec1;
}
# define VINT8x8_AND_DEFINED
#endif
#if !defined(VINT8x8_OR_DEFINED)
VEC_FUNC_IMPL vint8x8 vint8x8_or(vint8x8 vec1, vint8x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] | vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] | vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] | vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] | vec2.generic[7]);
	return vec1;
}
# define VINT8x8_OR_DEFINED
#endif
#if !defined(VINT8x8_XOR_DEFINED)
VEC_FUNC_IMPL vint8x8 vint8x8_xor(vint8x8 vec1, vint8x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] ^ vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] ^ vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] ^ vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] ^ vec2.generic[7]);
	return vec1;
}
# define VINT8x8_XOR_DEFINED
#endif
#if !defined(VINT8x8_NOT_DEFINED)
VEC_FUNC_IMPL vint8x8 vint8x8_not(vint8x8 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	vec.generic[4] = ~vec.generic[4];
	vec.generic[5] = ~vec.generic[5];
	vec.generic[6] = ~vec.generic[6];
	vec.generic[7] = ~vec.generic[7];
	return vec;
}
# define VINT8x8_NOT_DEFINED
#endif
#if !defined(VINT8x8_CMPLT_DEFINED)
VEC_FUNC_IMPL vint8x8 vint8x8_cmplt(vint8x8 vec1, vint8x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] < vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] < vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] < vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] < vec2.generic[7]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x8_CMPLT_DEFINED
#endif
#if !defined(VINT8x8_CMPEQ_DEFINED)
VEC_FUNC_IMPL vint8x8 vint8x8_cmpeq(vint8x8 vec1, vint8x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] == vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] == vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] == vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] == vec2.generic[7]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x8_CMPEQ_DEFINED
#endif
#if !defined(VINT8x8_CMPGT_DEFINED)
VEC_FUNC_IMPL vint8x8 vint8x8_cmpgt(vint8x8 vec1, vint8x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] > vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] > vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] > vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] > vec2.generic[7]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x8_CMPGT_DEFINED
#endif
#if !defined(VINT8x8_CMPLE_DEFINED)
VEC_FUNC_IMPL vint8x8 vint8x8_cmple(vint8x8 vec1, vint8x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] <= vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] <= vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] <= vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] <= vec2.generic[7]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x8_CMPLE_DEFINED
#endif
#if !defined(VINT8x8_CMPGE_DEFINED)
VEC_FUNC_IMPL vint8x8 vint8x8_cmpge(vint8x8 vec1, vint8x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] >= vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] >= vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] >= vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] >= vec2.generic[7]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x8_CMPGE_DEFINED
#endif
#if !defined(VINT8x8_MIN_DEFINED)
VEC_FUNC_IMPL vint8x8 vint8x8_min(vint8x8 vec1, vint8x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] < vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] < vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] < vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] < vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	return vec1;
}
# define VINT8x8_MIN_DEFINED
#endif
#if !defined(VINT8x8_MAX_DEFINED)
VEC_FUNC_IMPL vint8x8 vint8x8_max(vint8x8 vec1, vint8x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] > vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] > vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] > vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] > vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	return vec1;
}
# define VINT8x8_MAX_DEFINED
#endif
#if !defined(VINT8x8_RSHIFT_DEFINED)
VEC_FUNC_IMPL vint8x8 vint8x8_rshift(vint8x8 vec1, vuint8x8 vec2)
{
vec1.generic[0] = ((~vec1.generic[0]) >> vec2.generic[0]);
vec1.generic[1] = ((~vec1.generic[1]) >> vec2.generic[1]);
vec1.generic[2] = ((~vec1.generic[2]) >> vec2.generic[2]);
vec1.generic[3] = ((~vec1.generic[3]) >> vec2.generic[3]);
vec1.generic[4] = ((~vec1.generic[4]) >> vec2.generic[4]);
vec1.generic[5] = ((~vec1.generic[5]) >> vec2.generic[5]);
vec1.generic[6] = ((~vec1.generic[6]) >> vec2.generic[6]);
vec1.generic[7] = ((~vec1.generic[7]) >> vec2.generic[7]);
	return vec1;
}
# define VINT8x8_RSHIFT_DEFINED
#endif
#if !defined(VINT8x8_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vint8x8 vint8x8_lrshift(vint8x8 vec1, vuint8x8 vec2)
{
	union { vec_uint8 u; vec_int8 s; } x;

	x.s = vec1.generic[0];
	x.u >>= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u >>= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u >>= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u >>= vec2.generic[3];
	vec1.generic[3] = x.s;
	x.s = vec1.generic[4];
	x.u >>= vec2.generic[4];
	vec1.generic[4] = x.s;
	x.s = vec1.generic[5];
	x.u >>= vec2.generic[5];
	vec1.generic[5] = x.s;
	x.s = vec1.generic[6];
	x.u >>= vec2.generic[6];
	vec1.generic[6] = x.s;
	x.s = vec1.generic[7];
	x.u >>= vec2.generic[7];
	vec1.generic[7] = x.s;
	return vec1;
}
# define VINT8x8_LRSHIFT_DEFINED
#endif
#if !defined(VINT8x8_LSHIFT_DEFINED)
VEC_FUNC_IMPL vint8x8 vint8x8_lshift(vint8x8 vec1, vuint8x8 vec2)
{
	union { vec_uint8 u; vec_int8 s; } x;

	x.s = vec1.generic[0];
	x.u <<= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u <<= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u <<= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u <<= vec2.generic[3];
	vec1.generic[3] = x.s;
	x.s = vec1.generic[4];
	x.u <<= vec2.generic[4];
	vec1.generic[4] = x.s;
	x.s = vec1.generic[5];
	x.u <<= vec2.generic[5];
	vec1.generic[5] = x.s;
	x.s = vec1.generic[6];
	x.u <<= vec2.generic[6];
	vec1.generic[6] = x.s;
	x.s = vec1.generic[7];
	x.u <<= vec2.generic[7];
	vec1.generic[7] = x.s;
	return vec1;
}
# define VINT8x8_LSHIFT_DEFINED
#endif
#if !defined(VUINT8x8_SPLAT_DEFINED)
VEC_FUNC_IMPL vuint8x8 vuint8x8_splat(vec_uint8 x)
{
	vuint8x8 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	vec.generic[4] = x;
	vec.generic[5] = x;
	vec.generic[6] = x;
	vec.generic[7] = x;
	return vec;
}
# define VUINT8x8_SPLAT_DEFINED
#endif
#if !defined(VUINT8x8_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vuint8x8 vuint8x8_load_aligned(const vec_uint8 x[8])
{
	vuint8x8 vec;
	memcpy(vec.generic, x, 8);
	return vec;
}
# define VUINT8x8_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VUINT8x8_LOAD_DEFINED)
VEC_FUNC_IMPL vuint8x8 vuint8x8_load(const vec_uint8 x[8])
{
	vuint8x8 vec;
	memcpy(vec.generic, x, 8);
	return vec;
}
# define VUINT8x8_LOAD_DEFINED
#endif
#if !defined(VUINT8x8_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vuint8x8_store_aligned(vuint8x8 vec, vec_uint8 x[8])
{
	memcpy(x, vec.generic, 8);
}
# define VUINT8x8_STORE_ALIGNED_DEFINED
#endif
#if !defined(VUINT8x8_STORE_DEFINED)
VEC_FUNC_IMPL void vuint8x8_store(vuint8x8 vec, vec_uint8 x[8])
{
	memcpy(x, vec.generic, 8);
}
# define VUINT8x8_STORE_DEFINED
#endif
#if !defined(VUINT8x8_ADD_DEFINED)
VEC_FUNC_IMPL vuint8x8 vuint8x8_add(vuint8x8 vec1, vuint8x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]);
	return vec1;
}
# define VUINT8x8_ADD_DEFINED
#endif
#if !defined(VUINT8x8_SUB_DEFINED)
VEC_FUNC_IMPL vuint8x8 vuint8x8_sub(vuint8x8 vec1, vuint8x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] - vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] - vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] - vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] - vec2.generic[7]);
	return vec1;
}
# define VUINT8x8_SUB_DEFINED
#endif
#if !defined(VUINT8x8_MUL_DEFINED)
VEC_FUNC_IMPL vuint8x8 vuint8x8_mul(vuint8x8 vec1, vuint8x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] * vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] * vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] * vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] * vec2.generic[7]);
	return vec1;
}
# define VUINT8x8_MUL_DEFINED
#endif
#if !defined(VUINT8x8_DIV_DEFINED)
VEC_FUNC_IMPL vuint8x8 vuint8x8_div(vuint8x8 vec1, vuint8x8 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] / vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] / vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] / vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] / vec2.generic[7]) : 0);
	return vec1;
}
# define VUINT8x8_DIV_DEFINED
#endif
#if !defined(VUINT8x8_MOD_DEFINED)
VEC_FUNC_IMPL vuint8x8 vuint8x8_mod(vuint8x8 vec1, vuint8x8 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] % vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] % vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] % vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] % vec2.generic[7]) : 0);
	return vec1;
}
# define VUINT8x8_MOD_DEFINED
#endif
#if !defined(VUINT8x8_AVG_DEFINED)
VEC_FUNC_IMPL vuint8x8 vuint8x8_avg(vuint8x8 vec1, vuint8x8 vec2)
{
vec1.generic[0] = (vec1.generic[0] >> 1) + (vec2.generic[0] >> 1) + ((vec1.generic[0] | vec2.generic[0]) & 1);
vec1.generic[1] = (vec1.generic[1] >> 1) + (vec2.generic[1] >> 1) + ((vec1.generic[1] | vec2.generic[1]) & 1);
vec1.generic[2] = (vec1.generic[2] >> 1) + (vec2.generic[2] >> 1) + ((vec1.generic[2] | vec2.generic[2]) & 1);
vec1.generic[3] = (vec1.generic[3] >> 1) + (vec2.generic[3] >> 1) + ((vec1.generic[3] | vec2.generic[3]) & 1);
vec1.generic[4] = (vec1.generic[4] >> 1) + (vec2.generic[4] >> 1) + ((vec1.generic[4] | vec2.generic[4]) & 1);
vec1.generic[5] = (vec1.generic[5] >> 1) + (vec2.generic[5] >> 1) + ((vec1.generic[5] | vec2.generic[5]) & 1);
vec1.generic[6] = (vec1.generic[6] >> 1) + (vec2.generic[6] >> 1) + ((vec1.generic[6] | vec2.generic[6]) & 1);
vec1.generic[7] = (vec1.generic[7] >> 1) + (vec2.generic[7] >> 1) + ((vec1.generic[7] | vec2.generic[7]) & 1);
	return vec1;
}
# define VUINT8x8_AVG_DEFINED
#endif
#if !defined(VUINT8x8_AND_DEFINED)
VEC_FUNC_IMPL vuint8x8 vuint8x8_and(vuint8x8 vec1, vuint8x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] & vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] & vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] & vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] & vec2.generic[7]);
	return vec1;
}
# define VUINT8x8_AND_DEFINED
#endif
#if !defined(VUINT8x8_OR_DEFINED)
VEC_FUNC_IMPL vuint8x8 vuint8x8_or(vuint8x8 vec1, vuint8x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] | vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] | vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] | vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] | vec2.generic[7]);
	return vec1;
}
# define VUINT8x8_OR_DEFINED
#endif
#if !defined(VUINT8x8_XOR_DEFINED)
VEC_FUNC_IMPL vuint8x8 vuint8x8_xor(vuint8x8 vec1, vuint8x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] ^ vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] ^ vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] ^ vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] ^ vec2.generic[7]);
	return vec1;
}
# define VUINT8x8_XOR_DEFINED
#endif
#if !defined(VUINT8x8_NOT_DEFINED)
VEC_FUNC_IMPL vuint8x8 vuint8x8_not(vuint8x8 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	vec.generic[4] = ~vec.generic[4];
	vec.generic[5] = ~vec.generic[5];
	vec.generic[6] = ~vec.generic[6];
	vec.generic[7] = ~vec.generic[7];
	return vec;
}
# define VUINT8x8_NOT_DEFINED
#endif
#if !defined(VUINT8x8_CMPLT_DEFINED)
VEC_FUNC_IMPL vuint8x8 vuint8x8_cmplt(vuint8x8 vec1, vuint8x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] < vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] < vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] < vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] < vec2.generic[7]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x8_CMPLT_DEFINED
#endif
#if !defined(VUINT8x8_CMPEQ_DEFINED)
VEC_FUNC_IMPL vuint8x8 vuint8x8_cmpeq(vuint8x8 vec1, vuint8x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] == vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] == vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] == vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] == vec2.generic[7]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x8_CMPEQ_DEFINED
#endif
#if !defined(VUINT8x8_CMPGT_DEFINED)
VEC_FUNC_IMPL vuint8x8 vuint8x8_cmpgt(vuint8x8 vec1, vuint8x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] > vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] > vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] > vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] > vec2.generic[7]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x8_CMPGT_DEFINED
#endif
#if !defined(VUINT8x8_CMPLE_DEFINED)
VEC_FUNC_IMPL vuint8x8 vuint8x8_cmple(vuint8x8 vec1, vuint8x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] <= vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] <= vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] <= vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] <= vec2.generic[7]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x8_CMPLE_DEFINED
#endif
#if !defined(VUINT8x8_CMPGE_DEFINED)
VEC_FUNC_IMPL vuint8x8 vuint8x8_cmpge(vuint8x8 vec1, vuint8x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] >= vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] >= vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] >= vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] >= vec2.generic[7]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x8_CMPGE_DEFINED
#endif
#if !defined(VUINT8x8_MIN_DEFINED)
VEC_FUNC_IMPL vuint8x8 vuint8x8_min(vuint8x8 vec1, vuint8x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] < vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] < vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] < vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] < vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	return vec1;
}
# define VUINT8x8_MIN_DEFINED
#endif
#if !defined(VUINT8x8_MAX_DEFINED)
VEC_FUNC_IMPL vuint8x8 vuint8x8_max(vuint8x8 vec1, vuint8x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] > vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] > vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] > vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] > vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	return vec1;
}
# define VUINT8x8_MAX_DEFINED
#endif
#if !defined(VUINT8x8_RSHIFT_DEFINED)
VEC_FUNC_IMPL vuint8x8 vuint8x8_rshift(vuint8x8 vec1, vuint8x8 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	vec1.generic[4] >>= vec2.generic[0];
	vec1.generic[5] >>= vec2.generic[0];
	vec1.generic[6] >>= vec2.generic[0];
	vec1.generic[7] >>= vec2.generic[0];
	return vec1;
}
# define VUINT8x8_RSHIFT_DEFINED
#endif
#if !defined(VUINT8x8_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vuint8x8 vuint8x8_lrshift(vuint8x8 vec1, vuint8x8 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	vec1.generic[4] >>= vec2.generic[0];
	vec1.generic[5] >>= vec2.generic[0];
	vec1.generic[6] >>= vec2.generic[0];
	vec1.generic[7] >>= vec2.generic[0];
	return vec1;
}
# define VUINT8x8_LRSHIFT_DEFINED
#endif
#if !defined(VUINT8x8_LSHIFT_DEFINED)
VEC_FUNC_IMPL vuint8x8 vuint8x8_lshift(vuint8x8 vec1, vuint8x8 vec2)
{
	vec1.generic[0] <<= vec2.generic[0];
	vec1.generic[1] <<= vec2.generic[0];
	vec1.generic[2] <<= vec2.generic[0];
	vec1.generic[3] <<= vec2.generic[0];
	vec1.generic[4] <<= vec2.generic[0];
	vec1.generic[5] <<= vec2.generic[0];
	vec1.generic[6] <<= vec2.generic[0];
	vec1.generic[7] <<= vec2.generic[0];
	return vec1;
}
# define VUINT8x8_LSHIFT_DEFINED
#endif
#if !defined(VINT8x16_SPLAT_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_splat(vec_int8 x)
{
	vint8x16 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	vec.generic[4] = x;
	vec.generic[5] = x;
	vec.generic[6] = x;
	vec.generic[7] = x;
	vec.generic[8] = x;
	vec.generic[9] = x;
	vec.generic[10] = x;
	vec.generic[11] = x;
	vec.generic[12] = x;
	vec.generic[13] = x;
	vec.generic[14] = x;
	vec.generic[15] = x;
	return vec;
}
# define VINT8x16_SPLAT_DEFINED
#endif
#if !defined(VINT8x16_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_load_aligned(const vec_int8 x[16])
{
	vint8x16 vec;
	memcpy(vec.generic, x, 16);
	return vec;
}
# define VINT8x16_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VINT8x16_LOAD_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_load(const vec_int8 x[16])
{
	vint8x16 vec;
	memcpy(vec.generic, x, 16);
	return vec;
}
# define VINT8x16_LOAD_DEFINED
#endif
#if !defined(VINT8x16_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vint8x16_store_aligned(vint8x16 vec, vec_int8 x[16])
{
	memcpy(x, vec.generic, 16);
}
# define VINT8x16_STORE_ALIGNED_DEFINED
#endif
#if !defined(VINT8x16_STORE_DEFINED)
VEC_FUNC_IMPL void vint8x16_store(vint8x16 vec, vec_int8 x[16])
{
	memcpy(x, vec.generic, 16);
}
# define VINT8x16_STORE_DEFINED
#endif
#if !defined(VINT8x16_ADD_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_add(vint8x16 vec1, vint8x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] + vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] + vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] + vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] + vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] + vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] + vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] + vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] + vec2.generic[15]);
	return vec1;
}
# define VINT8x16_ADD_DEFINED
#endif
#if !defined(VINT8x16_SUB_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_sub(vint8x16 vec1, vint8x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] - vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] - vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] - vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] - vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] - vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] - vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] - vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] - vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] - vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] - vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] - vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] - vec2.generic[15]);
	return vec1;
}
# define VINT8x16_SUB_DEFINED
#endif
#if !defined(VINT8x16_MUL_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_mul(vint8x16 vec1, vint8x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] * vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] * vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] * vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] * vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] * vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] * vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] * vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] * vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] * vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] * vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] * vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] * vec2.generic[15]);
	return vec1;
}
# define VINT8x16_MUL_DEFINED
#endif
#if !defined(VINT8x16_DIV_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_div(vint8x16 vec1, vint8x16 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] / vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] / vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] / vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] / vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? (vec1.generic[8] / vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? (vec1.generic[9] / vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? (vec1.generic[10] / vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? (vec1.generic[11] / vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? (vec1.generic[12] / vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? (vec1.generic[13] / vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? (vec1.generic[14] / vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? (vec1.generic[15] / vec2.generic[15]) : 0);
	return vec1;
}
# define VINT8x16_DIV_DEFINED
#endif
#if !defined(VINT8x16_MOD_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_mod(vint8x16 vec1, vint8x16 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] % vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] % vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] % vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] % vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? (vec1.generic[8] % vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? (vec1.generic[9] % vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? (vec1.generic[10] % vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? (vec1.generic[11] % vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? (vec1.generic[12] % vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? (vec1.generic[13] % vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? (vec1.generic[14] % vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? (vec1.generic[15] % vec2.generic[15]) : 0);
	return vec1;
}
# define VINT8x16_MOD_DEFINED
#endif
#if !defined(VINT8x16_AVG_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_avg(vint8x16 vec1, vint8x16 vec2)
{
	vec_int8 x_d_rem, y_d_rem, rem_d_quot, rem_d_rem;
	x_d_rem = (vec1.generic[0] % 2);
	y_d_rem = (vec2.generic[0] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[0] = ((vec1.generic[0] / 2) + (vec2.generic[0] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[1] % 2);
	y_d_rem = (vec2.generic[1] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[1] = ((vec1.generic[1] / 2) + (vec2.generic[1] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[2] % 2);
	y_d_rem = (vec2.generic[2] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[2] = ((vec1.generic[2] / 2) + (vec2.generic[2] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[3] % 2);
	y_d_rem = (vec2.generic[3] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[3] = ((vec1.generic[3] / 2) + (vec2.generic[3] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[4] % 2);
	y_d_rem = (vec2.generic[4] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[4] = ((vec1.generic[4] / 2) + (vec2.generic[4] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[5] % 2);
	y_d_rem = (vec2.generic[5] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[5] = ((vec1.generic[5] / 2) + (vec2.generic[5] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[6] % 2);
	y_d_rem = (vec2.generic[6] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[6] = ((vec1.generic[6] / 2) + (vec2.generic[6] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[7] % 2);
	y_d_rem = (vec2.generic[7] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[7] = ((vec1.generic[7] / 2) + (vec2.generic[7] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[8] % 2);
	y_d_rem = (vec2.generic[8] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[8] = ((vec1.generic[8] / 2) + (vec2.generic[8] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[9] % 2);
	y_d_rem = (vec2.generic[9] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[9] = ((vec1.generic[9] / 2) + (vec2.generic[9] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[10] % 2);
	y_d_rem = (vec2.generic[10] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[10] = ((vec1.generic[10] / 2) + (vec2.generic[10] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[11] % 2);
	y_d_rem = (vec2.generic[11] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[11] = ((vec1.generic[11] / 2) + (vec2.generic[11] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[12] % 2);
	y_d_rem = (vec2.generic[12] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[12] = ((vec1.generic[12] / 2) + (vec2.generic[12] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[13] % 2);
	y_d_rem = (vec2.generic[13] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[13] = ((vec1.generic[13] / 2) + (vec2.generic[13] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[14] % 2);
	y_d_rem = (vec2.generic[14] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[14] = ((vec1.generic[14] / 2) + (vec2.generic[14] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[15] % 2);
	y_d_rem = (vec2.generic[15] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[15] = ((vec1.generic[15] / 2) + (vec2.generic[15] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	return vec1;
}
# define VINT8x16_AVG_DEFINED
#endif
#if !defined(VINT8x16_AND_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_and(vint8x16 vec1, vint8x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] & vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] & vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] & vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] & vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] & vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] & vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] & vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] & vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] & vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] & vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] & vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] & vec2.generic[15]);
	return vec1;
}
# define VINT8x16_AND_DEFINED
#endif
#if !defined(VINT8x16_OR_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_or(vint8x16 vec1, vint8x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] | vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] | vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] | vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] | vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] | vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] | vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] | vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] | vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] | vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] | vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] | vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] | vec2.generic[15]);
	return vec1;
}
# define VINT8x16_OR_DEFINED
#endif
#if !defined(VINT8x16_XOR_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_xor(vint8x16 vec1, vint8x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] ^ vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] ^ vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] ^ vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] ^ vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] ^ vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] ^ vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] ^ vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] ^ vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] ^ vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] ^ vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] ^ vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] ^ vec2.generic[15]);
	return vec1;
}
# define VINT8x16_XOR_DEFINED
#endif
#if !defined(VINT8x16_NOT_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_not(vint8x16 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	vec.generic[4] = ~vec.generic[4];
	vec.generic[5] = ~vec.generic[5];
	vec.generic[6] = ~vec.generic[6];
	vec.generic[7] = ~vec.generic[7];
	vec.generic[8] = ~vec.generic[8];
	vec.generic[9] = ~vec.generic[9];
	vec.generic[10] = ~vec.generic[10];
	vec.generic[11] = ~vec.generic[11];
	vec.generic[12] = ~vec.generic[12];
	vec.generic[13] = ~vec.generic[13];
	vec.generic[14] = ~vec.generic[14];
	vec.generic[15] = ~vec.generic[15];
	return vec;
}
# define VINT8x16_NOT_DEFINED
#endif
#if !defined(VINT8x16_CMPLT_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_cmplt(vint8x16 vec1, vint8x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] < vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] < vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] < vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] < vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] < vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] < vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] < vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] < vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] < vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] < vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] < vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] < vec2.generic[15]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x16_CMPLT_DEFINED
#endif
#if !defined(VINT8x16_CMPEQ_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_cmpeq(vint8x16 vec1, vint8x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] == vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] == vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] == vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] == vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] == vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] == vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] == vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] == vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] == vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] == vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] == vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] == vec2.generic[15]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x16_CMPEQ_DEFINED
#endif
#if !defined(VINT8x16_CMPGT_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_cmpgt(vint8x16 vec1, vint8x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] > vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] > vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] > vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] > vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] > vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] > vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] > vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] > vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] > vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] > vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] > vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] > vec2.generic[15]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x16_CMPGT_DEFINED
#endif
#if !defined(VINT8x16_CMPLE_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_cmple(vint8x16 vec1, vint8x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] <= vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] <= vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] <= vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] <= vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] <= vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] <= vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] <= vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] <= vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] <= vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] <= vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] <= vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] <= vec2.generic[15]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x16_CMPLE_DEFINED
#endif
#if !defined(VINT8x16_CMPGE_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_cmpge(vint8x16 vec1, vint8x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] >= vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] >= vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] >= vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] >= vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] >= vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] >= vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] >= vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] >= vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] >= vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] >= vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] >= vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] >= vec2.generic[15]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x16_CMPGE_DEFINED
#endif
#if !defined(VINT8x16_MIN_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_min(vint8x16 vec1, vint8x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] < vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] < vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] < vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] < vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] < vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] < vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] < vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] < vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] < vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] < vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] < vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] < vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	return vec1;
}
# define VINT8x16_MIN_DEFINED
#endif
#if !defined(VINT8x16_MAX_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_max(vint8x16 vec1, vint8x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] > vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] > vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] > vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] > vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] > vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] > vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] > vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] > vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] > vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] > vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] > vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] > vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	return vec1;
}
# define VINT8x16_MAX_DEFINED
#endif
#if !defined(VINT8x16_RSHIFT_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_rshift(vint8x16 vec1, vuint8x16 vec2)
{
vec1.generic[0] = ((~vec1.generic[0]) >> vec2.generic[0]);
vec1.generic[1] = ((~vec1.generic[1]) >> vec2.generic[1]);
vec1.generic[2] = ((~vec1.generic[2]) >> vec2.generic[2]);
vec1.generic[3] = ((~vec1.generic[3]) >> vec2.generic[3]);
vec1.generic[4] = ((~vec1.generic[4]) >> vec2.generic[4]);
vec1.generic[5] = ((~vec1.generic[5]) >> vec2.generic[5]);
vec1.generic[6] = ((~vec1.generic[6]) >> vec2.generic[6]);
vec1.generic[7] = ((~vec1.generic[7]) >> vec2.generic[7]);
vec1.generic[8] = ((~vec1.generic[8]) >> vec2.generic[8]);
vec1.generic[9] = ((~vec1.generic[9]) >> vec2.generic[9]);
vec1.generic[10] = ((~vec1.generic[10]) >> vec2.generic[10]);
vec1.generic[11] = ((~vec1.generic[11]) >> vec2.generic[11]);
vec1.generic[12] = ((~vec1.generic[12]) >> vec2.generic[12]);
vec1.generic[13] = ((~vec1.generic[13]) >> vec2.generic[13]);
vec1.generic[14] = ((~vec1.generic[14]) >> vec2.generic[14]);
vec1.generic[15] = ((~vec1.generic[15]) >> vec2.generic[15]);
	return vec1;
}
# define VINT8x16_RSHIFT_DEFINED
#endif
#if !defined(VINT8x16_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_lrshift(vint8x16 vec1, vuint8x16 vec2)
{
	union { vec_uint8 u; vec_int8 s; } x;

	x.s = vec1.generic[0];
	x.u >>= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u >>= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u >>= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u >>= vec2.generic[3];
	vec1.generic[3] = x.s;
	x.s = vec1.generic[4];
	x.u >>= vec2.generic[4];
	vec1.generic[4] = x.s;
	x.s = vec1.generic[5];
	x.u >>= vec2.generic[5];
	vec1.generic[5] = x.s;
	x.s = vec1.generic[6];
	x.u >>= vec2.generic[6];
	vec1.generic[6] = x.s;
	x.s = vec1.generic[7];
	x.u >>= vec2.generic[7];
	vec1.generic[7] = x.s;
	x.s = vec1.generic[8];
	x.u >>= vec2.generic[8];
	vec1.generic[8] = x.s;
	x.s = vec1.generic[9];
	x.u >>= vec2.generic[9];
	vec1.generic[9] = x.s;
	x.s = vec1.generic[10];
	x.u >>= vec2.generic[10];
	vec1.generic[10] = x.s;
	x.s = vec1.generic[11];
	x.u >>= vec2.generic[11];
	vec1.generic[11] = x.s;
	x.s = vec1.generic[12];
	x.u >>= vec2.generic[12];
	vec1.generic[12] = x.s;
	x.s = vec1.generic[13];
	x.u >>= vec2.generic[13];
	vec1.generic[13] = x.s;
	x.s = vec1.generic[14];
	x.u >>= vec2.generic[14];
	vec1.generic[14] = x.s;
	x.s = vec1.generic[15];
	x.u >>= vec2.generic[15];
	vec1.generic[15] = x.s;
	return vec1;
}
# define VINT8x16_LRSHIFT_DEFINED
#endif
#if !defined(VINT8x16_LSHIFT_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_lshift(vint8x16 vec1, vuint8x16 vec2)
{
	union { vec_uint8 u; vec_int8 s; } x;

	x.s = vec1.generic[0];
	x.u <<= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u <<= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u <<= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u <<= vec2.generic[3];
	vec1.generic[3] = x.s;
	x.s = vec1.generic[4];
	x.u <<= vec2.generic[4];
	vec1.generic[4] = x.s;
	x.s = vec1.generic[5];
	x.u <<= vec2.generic[5];
	vec1.generic[5] = x.s;
	x.s = vec1.generic[6];
	x.u <<= vec2.generic[6];
	vec1.generic[6] = x.s;
	x.s = vec1.generic[7];
	x.u <<= vec2.generic[7];
	vec1.generic[7] = x.s;
	x.s = vec1.generic[8];
	x.u <<= vec2.generic[8];
	vec1.generic[8] = x.s;
	x.s = vec1.generic[9];
	x.u <<= vec2.generic[9];
	vec1.generic[9] = x.s;
	x.s = vec1.generic[10];
	x.u <<= vec2.generic[10];
	vec1.generic[10] = x.s;
	x.s = vec1.generic[11];
	x.u <<= vec2.generic[11];
	vec1.generic[11] = x.s;
	x.s = vec1.generic[12];
	x.u <<= vec2.generic[12];
	vec1.generic[12] = x.s;
	x.s = vec1.generic[13];
	x.u <<= vec2.generic[13];
	vec1.generic[13] = x.s;
	x.s = vec1.generic[14];
	x.u <<= vec2.generic[14];
	vec1.generic[14] = x.s;
	x.s = vec1.generic[15];
	x.u <<= vec2.generic[15];
	vec1.generic[15] = x.s;
	return vec1;
}
# define VINT8x16_LSHIFT_DEFINED
#endif
#if !defined(VUINT8x16_SPLAT_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_splat(vec_uint8 x)
{
	vuint8x16 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	vec.generic[4] = x;
	vec.generic[5] = x;
	vec.generic[6] = x;
	vec.generic[7] = x;
	vec.generic[8] = x;
	vec.generic[9] = x;
	vec.generic[10] = x;
	vec.generic[11] = x;
	vec.generic[12] = x;
	vec.generic[13] = x;
	vec.generic[14] = x;
	vec.generic[15] = x;
	return vec;
}
# define VUINT8x16_SPLAT_DEFINED
#endif
#if !defined(VUINT8x16_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_load_aligned(const vec_uint8 x[16])
{
	vuint8x16 vec;
	memcpy(vec.generic, x, 16);
	return vec;
}
# define VUINT8x16_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VUINT8x16_LOAD_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_load(const vec_uint8 x[16])
{
	vuint8x16 vec;
	memcpy(vec.generic, x, 16);
	return vec;
}
# define VUINT8x16_LOAD_DEFINED
#endif
#if !defined(VUINT8x16_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vuint8x16_store_aligned(vuint8x16 vec, vec_uint8 x[16])
{
	memcpy(x, vec.generic, 16);
}
# define VUINT8x16_STORE_ALIGNED_DEFINED
#endif
#if !defined(VUINT8x16_STORE_DEFINED)
VEC_FUNC_IMPL void vuint8x16_store(vuint8x16 vec, vec_uint8 x[16])
{
	memcpy(x, vec.generic, 16);
}
# define VUINT8x16_STORE_DEFINED
#endif
#if !defined(VUINT8x16_ADD_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_add(vuint8x16 vec1, vuint8x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] + vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] + vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] + vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] + vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] + vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] + vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] + vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] + vec2.generic[15]);
	return vec1;
}
# define VUINT8x16_ADD_DEFINED
#endif
#if !defined(VUINT8x16_SUB_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_sub(vuint8x16 vec1, vuint8x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] - vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] - vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] - vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] - vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] - vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] - vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] - vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] - vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] - vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] - vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] - vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] - vec2.generic[15]);
	return vec1;
}
# define VUINT8x16_SUB_DEFINED
#endif
#if !defined(VUINT8x16_MUL_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_mul(vuint8x16 vec1, vuint8x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] * vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] * vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] * vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] * vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] * vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] * vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] * vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] * vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] * vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] * vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] * vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] * vec2.generic[15]);
	return vec1;
}
# define VUINT8x16_MUL_DEFINED
#endif
#if !defined(VUINT8x16_DIV_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_div(vuint8x16 vec1, vuint8x16 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] / vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] / vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] / vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] / vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? (vec1.generic[8] / vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? (vec1.generic[9] / vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? (vec1.generic[10] / vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? (vec1.generic[11] / vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? (vec1.generic[12] / vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? (vec1.generic[13] / vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? (vec1.generic[14] / vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? (vec1.generic[15] / vec2.generic[15]) : 0);
	return vec1;
}
# define VUINT8x16_DIV_DEFINED
#endif
#if !defined(VUINT8x16_MOD_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_mod(vuint8x16 vec1, vuint8x16 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] % vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] % vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] % vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] % vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? (vec1.generic[8] % vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? (vec1.generic[9] % vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? (vec1.generic[10] % vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? (vec1.generic[11] % vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? (vec1.generic[12] % vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? (vec1.generic[13] % vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? (vec1.generic[14] % vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? (vec1.generic[15] % vec2.generic[15]) : 0);
	return vec1;
}
# define VUINT8x16_MOD_DEFINED
#endif
#if !defined(VUINT8x16_AVG_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_avg(vuint8x16 vec1, vuint8x16 vec2)
{
vec1.generic[0] = (vec1.generic[0] >> 1) + (vec2.generic[0] >> 1) + ((vec1.generic[0] | vec2.generic[0]) & 1);
vec1.generic[1] = (vec1.generic[1] >> 1) + (vec2.generic[1] >> 1) + ((vec1.generic[1] | vec2.generic[1]) & 1);
vec1.generic[2] = (vec1.generic[2] >> 1) + (vec2.generic[2] >> 1) + ((vec1.generic[2] | vec2.generic[2]) & 1);
vec1.generic[3] = (vec1.generic[3] >> 1) + (vec2.generic[3] >> 1) + ((vec1.generic[3] | vec2.generic[3]) & 1);
vec1.generic[4] = (vec1.generic[4] >> 1) + (vec2.generic[4] >> 1) + ((vec1.generic[4] | vec2.generic[4]) & 1);
vec1.generic[5] = (vec1.generic[5] >> 1) + (vec2.generic[5] >> 1) + ((vec1.generic[5] | vec2.generic[5]) & 1);
vec1.generic[6] = (vec1.generic[6] >> 1) + (vec2.generic[6] >> 1) + ((vec1.generic[6] | vec2.generic[6]) & 1);
vec1.generic[7] = (vec1.generic[7] >> 1) + (vec2.generic[7] >> 1) + ((vec1.generic[7] | vec2.generic[7]) & 1);
vec1.generic[8] = (vec1.generic[8] >> 1) + (vec2.generic[8] >> 1) + ((vec1.generic[8] | vec2.generic[8]) & 1);
vec1.generic[9] = (vec1.generic[9] >> 1) + (vec2.generic[9] >> 1) + ((vec1.generic[9] | vec2.generic[9]) & 1);
vec1.generic[10] = (vec1.generic[10] >> 1) + (vec2.generic[10] >> 1) + ((vec1.generic[10] | vec2.generic[10]) & 1);
vec1.generic[11] = (vec1.generic[11] >> 1) + (vec2.generic[11] >> 1) + ((vec1.generic[11] | vec2.generic[11]) & 1);
vec1.generic[12] = (vec1.generic[12] >> 1) + (vec2.generic[12] >> 1) + ((vec1.generic[12] | vec2.generic[12]) & 1);
vec1.generic[13] = (vec1.generic[13] >> 1) + (vec2.generic[13] >> 1) + ((vec1.generic[13] | vec2.generic[13]) & 1);
vec1.generic[14] = (vec1.generic[14] >> 1) + (vec2.generic[14] >> 1) + ((vec1.generic[14] | vec2.generic[14]) & 1);
vec1.generic[15] = (vec1.generic[15] >> 1) + (vec2.generic[15] >> 1) + ((vec1.generic[15] | vec2.generic[15]) & 1);
	return vec1;
}
# define VUINT8x16_AVG_DEFINED
#endif
#if !defined(VUINT8x16_AND_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_and(vuint8x16 vec1, vuint8x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] & vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] & vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] & vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] & vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] & vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] & vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] & vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] & vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] & vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] & vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] & vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] & vec2.generic[15]);
	return vec1;
}
# define VUINT8x16_AND_DEFINED
#endif
#if !defined(VUINT8x16_OR_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_or(vuint8x16 vec1, vuint8x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] | vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] | vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] | vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] | vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] | vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] | vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] | vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] | vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] | vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] | vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] | vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] | vec2.generic[15]);
	return vec1;
}
# define VUINT8x16_OR_DEFINED
#endif
#if !defined(VUINT8x16_XOR_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_xor(vuint8x16 vec1, vuint8x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] ^ vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] ^ vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] ^ vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] ^ vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] ^ vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] ^ vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] ^ vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] ^ vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] ^ vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] ^ vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] ^ vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] ^ vec2.generic[15]);
	return vec1;
}
# define VUINT8x16_XOR_DEFINED
#endif
#if !defined(VUINT8x16_NOT_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_not(vuint8x16 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	vec.generic[4] = ~vec.generic[4];
	vec.generic[5] = ~vec.generic[5];
	vec.generic[6] = ~vec.generic[6];
	vec.generic[7] = ~vec.generic[7];
	vec.generic[8] = ~vec.generic[8];
	vec.generic[9] = ~vec.generic[9];
	vec.generic[10] = ~vec.generic[10];
	vec.generic[11] = ~vec.generic[11];
	vec.generic[12] = ~vec.generic[12];
	vec.generic[13] = ~vec.generic[13];
	vec.generic[14] = ~vec.generic[14];
	vec.generic[15] = ~vec.generic[15];
	return vec;
}
# define VUINT8x16_NOT_DEFINED
#endif
#if !defined(VUINT8x16_CMPLT_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_cmplt(vuint8x16 vec1, vuint8x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] < vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] < vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] < vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] < vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] < vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] < vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] < vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] < vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] < vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] < vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] < vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] < vec2.generic[15]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x16_CMPLT_DEFINED
#endif
#if !defined(VUINT8x16_CMPEQ_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_cmpeq(vuint8x16 vec1, vuint8x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] == vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] == vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] == vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] == vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] == vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] == vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] == vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] == vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] == vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] == vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] == vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] == vec2.generic[15]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x16_CMPEQ_DEFINED
#endif
#if !defined(VUINT8x16_CMPGT_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_cmpgt(vuint8x16 vec1, vuint8x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] > vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] > vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] > vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] > vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] > vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] > vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] > vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] > vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] > vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] > vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] > vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] > vec2.generic[15]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x16_CMPGT_DEFINED
#endif
#if !defined(VUINT8x16_CMPLE_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_cmple(vuint8x16 vec1, vuint8x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] <= vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] <= vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] <= vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] <= vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] <= vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] <= vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] <= vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] <= vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] <= vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] <= vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] <= vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] <= vec2.generic[15]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x16_CMPLE_DEFINED
#endif
#if !defined(VUINT8x16_CMPGE_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_cmpge(vuint8x16 vec1, vuint8x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] >= vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] >= vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] >= vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] >= vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] >= vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] >= vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] >= vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] >= vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] >= vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] >= vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] >= vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] >= vec2.generic[15]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x16_CMPGE_DEFINED
#endif
#if !defined(VUINT8x16_MIN_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_min(vuint8x16 vec1, vuint8x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] < vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] < vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] < vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] < vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] < vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] < vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] < vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] < vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] < vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] < vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] < vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] < vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	return vec1;
}
# define VUINT8x16_MIN_DEFINED
#endif
#if !defined(VUINT8x16_MAX_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_max(vuint8x16 vec1, vuint8x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] > vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] > vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] > vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] > vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] > vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] > vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] > vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] > vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] > vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] > vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] > vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] > vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	return vec1;
}
# define VUINT8x16_MAX_DEFINED
#endif
#if !defined(VUINT8x16_RSHIFT_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_rshift(vuint8x16 vec1, vuint8x16 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	vec1.generic[4] >>= vec2.generic[0];
	vec1.generic[5] >>= vec2.generic[0];
	vec1.generic[6] >>= vec2.generic[0];
	vec1.generic[7] >>= vec2.generic[0];
	vec1.generic[8] >>= vec2.generic[0];
	vec1.generic[9] >>= vec2.generic[0];
	vec1.generic[10] >>= vec2.generic[0];
	vec1.generic[11] >>= vec2.generic[0];
	vec1.generic[12] >>= vec2.generic[0];
	vec1.generic[13] >>= vec2.generic[0];
	vec1.generic[14] >>= vec2.generic[0];
	vec1.generic[15] >>= vec2.generic[0];
	return vec1;
}
# define VUINT8x16_RSHIFT_DEFINED
#endif
#if !defined(VUINT8x16_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_lrshift(vuint8x16 vec1, vuint8x16 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	vec1.generic[4] >>= vec2.generic[0];
	vec1.generic[5] >>= vec2.generic[0];
	vec1.generic[6] >>= vec2.generic[0];
	vec1.generic[7] >>= vec2.generic[0];
	vec1.generic[8] >>= vec2.generic[0];
	vec1.generic[9] >>= vec2.generic[0];
	vec1.generic[10] >>= vec2.generic[0];
	vec1.generic[11] >>= vec2.generic[0];
	vec1.generic[12] >>= vec2.generic[0];
	vec1.generic[13] >>= vec2.generic[0];
	vec1.generic[14] >>= vec2.generic[0];
	vec1.generic[15] >>= vec2.generic[0];
	return vec1;
}
# define VUINT8x16_LRSHIFT_DEFINED
#endif
#if !defined(VUINT8x16_LSHIFT_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_lshift(vuint8x16 vec1, vuint8x16 vec2)
{
	vec1.generic[0] <<= vec2.generic[0];
	vec1.generic[1] <<= vec2.generic[0];
	vec1.generic[2] <<= vec2.generic[0];
	vec1.generic[3] <<= vec2.generic[0];
	vec1.generic[4] <<= vec2.generic[0];
	vec1.generic[5] <<= vec2.generic[0];
	vec1.generic[6] <<= vec2.generic[0];
	vec1.generic[7] <<= vec2.generic[0];
	vec1.generic[8] <<= vec2.generic[0];
	vec1.generic[9] <<= vec2.generic[0];
	vec1.generic[10] <<= vec2.generic[0];
	vec1.generic[11] <<= vec2.generic[0];
	vec1.generic[12] <<= vec2.generic[0];
	vec1.generic[13] <<= vec2.generic[0];
	vec1.generic[14] <<= vec2.generic[0];
	vec1.generic[15] <<= vec2.generic[0];
	return vec1;
}
# define VUINT8x16_LSHIFT_DEFINED
#endif
#if !defined(VINT8x32_SPLAT_DEFINED)
VEC_FUNC_IMPL vint8x32 vint8x32_splat(vec_int8 x)
{
	vint8x32 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	vec.generic[4] = x;
	vec.generic[5] = x;
	vec.generic[6] = x;
	vec.generic[7] = x;
	vec.generic[8] = x;
	vec.generic[9] = x;
	vec.generic[10] = x;
	vec.generic[11] = x;
	vec.generic[12] = x;
	vec.generic[13] = x;
	vec.generic[14] = x;
	vec.generic[15] = x;
	vec.generic[16] = x;
	vec.generic[17] = x;
	vec.generic[18] = x;
	vec.generic[19] = x;
	vec.generic[20] = x;
	vec.generic[21] = x;
	vec.generic[22] = x;
	vec.generic[23] = x;
	vec.generic[24] = x;
	vec.generic[25] = x;
	vec.generic[26] = x;
	vec.generic[27] = x;
	vec.generic[28] = x;
	vec.generic[29] = x;
	vec.generic[30] = x;
	vec.generic[31] = x;
	return vec;
}
# define VINT8x32_SPLAT_DEFINED
#endif
#if !defined(VINT8x32_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vint8x32 vint8x32_load_aligned(const vec_int8 x[32])
{
	vint8x32 vec;
	memcpy(vec.generic, x, 32);
	return vec;
}
# define VINT8x32_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VINT8x32_LOAD_DEFINED)
VEC_FUNC_IMPL vint8x32 vint8x32_load(const vec_int8 x[32])
{
	vint8x32 vec;
	memcpy(vec.generic, x, 32);
	return vec;
}
# define VINT8x32_LOAD_DEFINED
#endif
#if !defined(VINT8x32_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vint8x32_store_aligned(vint8x32 vec, vec_int8 x[32])
{
	memcpy(x, vec.generic, 32);
}
# define VINT8x32_STORE_ALIGNED_DEFINED
#endif
#if !defined(VINT8x32_STORE_DEFINED)
VEC_FUNC_IMPL void vint8x32_store(vint8x32 vec, vec_int8 x[32])
{
	memcpy(x, vec.generic, 32);
}
# define VINT8x32_STORE_DEFINED
#endif
#if !defined(VINT8x32_ADD_DEFINED)
VEC_FUNC_IMPL vint8x32 vint8x32_add(vint8x32 vec1, vint8x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] + vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] + vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] + vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] + vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] + vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] + vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] + vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] + vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] + vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] + vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] + vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] + vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] + vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] + vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] + vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] + vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] + vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] + vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] + vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] + vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] + vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] + vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] + vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] + vec2.generic[31]);
	return vec1;
}
# define VINT8x32_ADD_DEFINED
#endif
#if !defined(VINT8x32_SUB_DEFINED)
VEC_FUNC_IMPL vint8x32 vint8x32_sub(vint8x32 vec1, vint8x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] - vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] - vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] - vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] - vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] - vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] - vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] - vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] - vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] - vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] - vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] - vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] - vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] - vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] - vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] - vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] - vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] - vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] - vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] - vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] - vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] - vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] - vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] - vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] - vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] - vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] - vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] - vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] - vec2.generic[31]);
	return vec1;
}
# define VINT8x32_SUB_DEFINED
#endif
#if !defined(VINT8x32_MUL_DEFINED)
VEC_FUNC_IMPL vint8x32 vint8x32_mul(vint8x32 vec1, vint8x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] * vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] * vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] * vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] * vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] * vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] * vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] * vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] * vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] * vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] * vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] * vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] * vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] * vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] * vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] * vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] * vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] * vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] * vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] * vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] * vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] * vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] * vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] * vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] * vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] * vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] * vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] * vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] * vec2.generic[31]);
	return vec1;
}
# define VINT8x32_MUL_DEFINED
#endif
#if !defined(VINT8x32_DIV_DEFINED)
VEC_FUNC_IMPL vint8x32 vint8x32_div(vint8x32 vec1, vint8x32 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] / vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] / vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] / vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] / vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? (vec1.generic[8] / vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? (vec1.generic[9] / vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? (vec1.generic[10] / vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? (vec1.generic[11] / vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? (vec1.generic[12] / vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? (vec1.generic[13] / vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? (vec1.generic[14] / vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? (vec1.generic[15] / vec2.generic[15]) : 0);
	vec1.generic[16] = (vec2.generic[16] ? (vec1.generic[16] / vec2.generic[16]) : 0);
	vec1.generic[17] = (vec2.generic[17] ? (vec1.generic[17] / vec2.generic[17]) : 0);
	vec1.generic[18] = (vec2.generic[18] ? (vec1.generic[18] / vec2.generic[18]) : 0);
	vec1.generic[19] = (vec2.generic[19] ? (vec1.generic[19] / vec2.generic[19]) : 0);
	vec1.generic[20] = (vec2.generic[20] ? (vec1.generic[20] / vec2.generic[20]) : 0);
	vec1.generic[21] = (vec2.generic[21] ? (vec1.generic[21] / vec2.generic[21]) : 0);
	vec1.generic[22] = (vec2.generic[22] ? (vec1.generic[22] / vec2.generic[22]) : 0);
	vec1.generic[23] = (vec2.generic[23] ? (vec1.generic[23] / vec2.generic[23]) : 0);
	vec1.generic[24] = (vec2.generic[24] ? (vec1.generic[24] / vec2.generic[24]) : 0);
	vec1.generic[25] = (vec2.generic[25] ? (vec1.generic[25] / vec2.generic[25]) : 0);
	vec1.generic[26] = (vec2.generic[26] ? (vec1.generic[26] / vec2.generic[26]) : 0);
	vec1.generic[27] = (vec2.generic[27] ? (vec1.generic[27] / vec2.generic[27]) : 0);
	vec1.generic[28] = (vec2.generic[28] ? (vec1.generic[28] / vec2.generic[28]) : 0);
	vec1.generic[29] = (vec2.generic[29] ? (vec1.generic[29] / vec2.generic[29]) : 0);
	vec1.generic[30] = (vec2.generic[30] ? (vec1.generic[30] / vec2.generic[30]) : 0);
	vec1.generic[31] = (vec2.generic[31] ? (vec1.generic[31] / vec2.generic[31]) : 0);
	return vec1;
}
# define VINT8x32_DIV_DEFINED
#endif
#if !defined(VINT8x32_MOD_DEFINED)
VEC_FUNC_IMPL vint8x32 vint8x32_mod(vint8x32 vec1, vint8x32 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] % vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] % vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] % vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] % vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? (vec1.generic[8] % vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? (vec1.generic[9] % vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? (vec1.generic[10] % vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? (vec1.generic[11] % vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? (vec1.generic[12] % vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? (vec1.generic[13] % vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? (vec1.generic[14] % vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? (vec1.generic[15] % vec2.generic[15]) : 0);
	vec1.generic[16] = (vec2.generic[16] ? (vec1.generic[16] % vec2.generic[16]) : 0);
	vec1.generic[17] = (vec2.generic[17] ? (vec1.generic[17] % vec2.generic[17]) : 0);
	vec1.generic[18] = (vec2.generic[18] ? (vec1.generic[18] % vec2.generic[18]) : 0);
	vec1.generic[19] = (vec2.generic[19] ? (vec1.generic[19] % vec2.generic[19]) : 0);
	vec1.generic[20] = (vec2.generic[20] ? (vec1.generic[20] % vec2.generic[20]) : 0);
	vec1.generic[21] = (vec2.generic[21] ? (vec1.generic[21] % vec2.generic[21]) : 0);
	vec1.generic[22] = (vec2.generic[22] ? (vec1.generic[22] % vec2.generic[22]) : 0);
	vec1.generic[23] = (vec2.generic[23] ? (vec1.generic[23] % vec2.generic[23]) : 0);
	vec1.generic[24] = (vec2.generic[24] ? (vec1.generic[24] % vec2.generic[24]) : 0);
	vec1.generic[25] = (vec2.generic[25] ? (vec1.generic[25] % vec2.generic[25]) : 0);
	vec1.generic[26] = (vec2.generic[26] ? (vec1.generic[26] % vec2.generic[26]) : 0);
	vec1.generic[27] = (vec2.generic[27] ? (vec1.generic[27] % vec2.generic[27]) : 0);
	vec1.generic[28] = (vec2.generic[28] ? (vec1.generic[28] % vec2.generic[28]) : 0);
	vec1.generic[29] = (vec2.generic[29] ? (vec1.generic[29] % vec2.generic[29]) : 0);
	vec1.generic[30] = (vec2.generic[30] ? (vec1.generic[30] % vec2.generic[30]) : 0);
	vec1.generic[31] = (vec2.generic[31] ? (vec1.generic[31] % vec2.generic[31]) : 0);
	return vec1;
}
# define VINT8x32_MOD_DEFINED
#endif
#if !defined(VINT8x32_AVG_DEFINED)
VEC_FUNC_IMPL vint8x32 vint8x32_avg(vint8x32 vec1, vint8x32 vec2)
{
	vec_int8 x_d_rem, y_d_rem, rem_d_quot, rem_d_rem;
	x_d_rem = (vec1.generic[0] % 2);
	y_d_rem = (vec2.generic[0] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[0] = ((vec1.generic[0] / 2) + (vec2.generic[0] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[1] % 2);
	y_d_rem = (vec2.generic[1] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[1] = ((vec1.generic[1] / 2) + (vec2.generic[1] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[2] % 2);
	y_d_rem = (vec2.generic[2] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[2] = ((vec1.generic[2] / 2) + (vec2.generic[2] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[3] % 2);
	y_d_rem = (vec2.generic[3] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[3] = ((vec1.generic[3] / 2) + (vec2.generic[3] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[4] % 2);
	y_d_rem = (vec2.generic[4] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[4] = ((vec1.generic[4] / 2) + (vec2.generic[4] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[5] % 2);
	y_d_rem = (vec2.generic[5] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[5] = ((vec1.generic[5] / 2) + (vec2.generic[5] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[6] % 2);
	y_d_rem = (vec2.generic[6] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[6] = ((vec1.generic[6] / 2) + (vec2.generic[6] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[7] % 2);
	y_d_rem = (vec2.generic[7] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[7] = ((vec1.generic[7] / 2) + (vec2.generic[7] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[8] % 2);
	y_d_rem = (vec2.generic[8] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[8] = ((vec1.generic[8] / 2) + (vec2.generic[8] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[9] % 2);
	y_d_rem = (vec2.generic[9] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[9] = ((vec1.generic[9] / 2) + (vec2.generic[9] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[10] % 2);
	y_d_rem = (vec2.generic[10] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[10] = ((vec1.generic[10] / 2) + (vec2.generic[10] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[11] % 2);
	y_d_rem = (vec2.generic[11] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[11] = ((vec1.generic[11] / 2) + (vec2.generic[11] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[12] % 2);
	y_d_rem = (vec2.generic[12] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[12] = ((vec1.generic[12] / 2) + (vec2.generic[12] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[13] % 2);
	y_d_rem = (vec2.generic[13] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[13] = ((vec1.generic[13] / 2) + (vec2.generic[13] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[14] % 2);
	y_d_rem = (vec2.generic[14] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[14] = ((vec1.generic[14] / 2) + (vec2.generic[14] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[15] % 2);
	y_d_rem = (vec2.generic[15] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[15] = ((vec1.generic[15] / 2) + (vec2.generic[15] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[16] % 2);
	y_d_rem = (vec2.generic[16] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[16] = ((vec1.generic[16] / 2) + (vec2.generic[16] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[17] % 2);
	y_d_rem = (vec2.generic[17] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[17] = ((vec1.generic[17] / 2) + (vec2.generic[17] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[18] % 2);
	y_d_rem = (vec2.generic[18] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[18] = ((vec1.generic[18] / 2) + (vec2.generic[18] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[19] % 2);
	y_d_rem = (vec2.generic[19] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[19] = ((vec1.generic[19] / 2) + (vec2.generic[19] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[20] % 2);
	y_d_rem = (vec2.generic[20] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[20] = ((vec1.generic[20] / 2) + (vec2.generic[20] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[21] % 2);
	y_d_rem = (vec2.generic[21] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[21] = ((vec1.generic[21] / 2) + (vec2.generic[21] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[22] % 2);
	y_d_rem = (vec2.generic[22] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[22] = ((vec1.generic[22] / 2) + (vec2.generic[22] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[23] % 2);
	y_d_rem = (vec2.generic[23] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[23] = ((vec1.generic[23] / 2) + (vec2.generic[23] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[24] % 2);
	y_d_rem = (vec2.generic[24] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[24] = ((vec1.generic[24] / 2) + (vec2.generic[24] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[25] % 2);
	y_d_rem = (vec2.generic[25] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[25] = ((vec1.generic[25] / 2) + (vec2.generic[25] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[26] % 2);
	y_d_rem = (vec2.generic[26] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[26] = ((vec1.generic[26] / 2) + (vec2.generic[26] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[27] % 2);
	y_d_rem = (vec2.generic[27] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[27] = ((vec1.generic[27] / 2) + (vec2.generic[27] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[28] % 2);
	y_d_rem = (vec2.generic[28] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[28] = ((vec1.generic[28] / 2) + (vec2.generic[28] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[29] % 2);
	y_d_rem = (vec2.generic[29] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[29] = ((vec1.generic[29] / 2) + (vec2.generic[29] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[30] % 2);
	y_d_rem = (vec2.generic[30] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[30] = ((vec1.generic[30] / 2) + (vec2.generic[30] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[31] % 2);
	y_d_rem = (vec2.generic[31] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[31] = ((vec1.generic[31] / 2) + (vec2.generic[31] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	return vec1;
}
# define VINT8x32_AVG_DEFINED
#endif
#if !defined(VINT8x32_AND_DEFINED)
VEC_FUNC_IMPL vint8x32 vint8x32_and(vint8x32 vec1, vint8x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] & vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] & vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] & vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] & vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] & vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] & vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] & vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] & vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] & vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] & vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] & vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] & vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] & vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] & vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] & vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] & vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] & vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] & vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] & vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] & vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] & vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] & vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] & vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] & vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] & vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] & vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] & vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] & vec2.generic[31]);
	return vec1;
}
# define VINT8x32_AND_DEFINED
#endif
#if !defined(VINT8x32_OR_DEFINED)
VEC_FUNC_IMPL vint8x32 vint8x32_or(vint8x32 vec1, vint8x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] | vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] | vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] | vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] | vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] | vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] | vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] | vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] | vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] | vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] | vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] | vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] | vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] | vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] | vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] | vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] | vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] | vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] | vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] | vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] | vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] | vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] | vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] | vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] | vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] | vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] | vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] | vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] | vec2.generic[31]);
	return vec1;
}
# define VINT8x32_OR_DEFINED
#endif
#if !defined(VINT8x32_XOR_DEFINED)
VEC_FUNC_IMPL vint8x32 vint8x32_xor(vint8x32 vec1, vint8x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] ^ vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] ^ vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] ^ vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] ^ vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] ^ vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] ^ vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] ^ vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] ^ vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] ^ vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] ^ vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] ^ vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] ^ vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] ^ vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] ^ vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] ^ vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] ^ vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] ^ vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] ^ vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] ^ vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] ^ vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] ^ vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] ^ vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] ^ vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] ^ vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] ^ vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] ^ vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] ^ vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] ^ vec2.generic[31]);
	return vec1;
}
# define VINT8x32_XOR_DEFINED
#endif
#if !defined(VINT8x32_NOT_DEFINED)
VEC_FUNC_IMPL vint8x32 vint8x32_not(vint8x32 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	vec.generic[4] = ~vec.generic[4];
	vec.generic[5] = ~vec.generic[5];
	vec.generic[6] = ~vec.generic[6];
	vec.generic[7] = ~vec.generic[7];
	vec.generic[8] = ~vec.generic[8];
	vec.generic[9] = ~vec.generic[9];
	vec.generic[10] = ~vec.generic[10];
	vec.generic[11] = ~vec.generic[11];
	vec.generic[12] = ~vec.generic[12];
	vec.generic[13] = ~vec.generic[13];
	vec.generic[14] = ~vec.generic[14];
	vec.generic[15] = ~vec.generic[15];
	vec.generic[16] = ~vec.generic[16];
	vec.generic[17] = ~vec.generic[17];
	vec.generic[18] = ~vec.generic[18];
	vec.generic[19] = ~vec.generic[19];
	vec.generic[20] = ~vec.generic[20];
	vec.generic[21] = ~vec.generic[21];
	vec.generic[22] = ~vec.generic[22];
	vec.generic[23] = ~vec.generic[23];
	vec.generic[24] = ~vec.generic[24];
	vec.generic[25] = ~vec.generic[25];
	vec.generic[26] = ~vec.generic[26];
	vec.generic[27] = ~vec.generic[27];
	vec.generic[28] = ~vec.generic[28];
	vec.generic[29] = ~vec.generic[29];
	vec.generic[30] = ~vec.generic[30];
	vec.generic[31] = ~vec.generic[31];
	return vec;
}
# define VINT8x32_NOT_DEFINED
#endif
#if !defined(VINT8x32_CMPLT_DEFINED)
VEC_FUNC_IMPL vint8x32 vint8x32_cmplt(vint8x32 vec1, vint8x32 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] < vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] < vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] < vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] < vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] < vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] < vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] < vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] < vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] < vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] < vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] < vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] < vec2.generic[15]) ? 0xFF : 0, 1);
	memset(&vec1.generic[16], (vec1.generic[16] < vec2.generic[16]) ? 0xFF : 0, 1);
	memset(&vec1.generic[17], (vec1.generic[17] < vec2.generic[17]) ? 0xFF : 0, 1);
	memset(&vec1.generic[18], (vec1.generic[18] < vec2.generic[18]) ? 0xFF : 0, 1);
	memset(&vec1.generic[19], (vec1.generic[19] < vec2.generic[19]) ? 0xFF : 0, 1);
	memset(&vec1.generic[20], (vec1.generic[20] < vec2.generic[20]) ? 0xFF : 0, 1);
	memset(&vec1.generic[21], (vec1.generic[21] < vec2.generic[21]) ? 0xFF : 0, 1);
	memset(&vec1.generic[22], (vec1.generic[22] < vec2.generic[22]) ? 0xFF : 0, 1);
	memset(&vec1.generic[23], (vec1.generic[23] < vec2.generic[23]) ? 0xFF : 0, 1);
	memset(&vec1.generic[24], (vec1.generic[24] < vec2.generic[24]) ? 0xFF : 0, 1);
	memset(&vec1.generic[25], (vec1.generic[25] < vec2.generic[25]) ? 0xFF : 0, 1);
	memset(&vec1.generic[26], (vec1.generic[26] < vec2.generic[26]) ? 0xFF : 0, 1);
	memset(&vec1.generic[27], (vec1.generic[27] < vec2.generic[27]) ? 0xFF : 0, 1);
	memset(&vec1.generic[28], (vec1.generic[28] < vec2.generic[28]) ? 0xFF : 0, 1);
	memset(&vec1.generic[29], (vec1.generic[29] < vec2.generic[29]) ? 0xFF : 0, 1);
	memset(&vec1.generic[30], (vec1.generic[30] < vec2.generic[30]) ? 0xFF : 0, 1);
	memset(&vec1.generic[31], (vec1.generic[31] < vec2.generic[31]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x32_CMPLT_DEFINED
#endif
#if !defined(VINT8x32_CMPEQ_DEFINED)
VEC_FUNC_IMPL vint8x32 vint8x32_cmpeq(vint8x32 vec1, vint8x32 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] == vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] == vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] == vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] == vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] == vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] == vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] == vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] == vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] == vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] == vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] == vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] == vec2.generic[15]) ? 0xFF : 0, 1);
	memset(&vec1.generic[16], (vec1.generic[16] == vec2.generic[16]) ? 0xFF : 0, 1);
	memset(&vec1.generic[17], (vec1.generic[17] == vec2.generic[17]) ? 0xFF : 0, 1);
	memset(&vec1.generic[18], (vec1.generic[18] == vec2.generic[18]) ? 0xFF : 0, 1);
	memset(&vec1.generic[19], (vec1.generic[19] == vec2.generic[19]) ? 0xFF : 0, 1);
	memset(&vec1.generic[20], (vec1.generic[20] == vec2.generic[20]) ? 0xFF : 0, 1);
	memset(&vec1.generic[21], (vec1.generic[21] == vec2.generic[21]) ? 0xFF : 0, 1);
	memset(&vec1.generic[22], (vec1.generic[22] == vec2.generic[22]) ? 0xFF : 0, 1);
	memset(&vec1.generic[23], (vec1.generic[23] == vec2.generic[23]) ? 0xFF : 0, 1);
	memset(&vec1.generic[24], (vec1.generic[24] == vec2.generic[24]) ? 0xFF : 0, 1);
	memset(&vec1.generic[25], (vec1.generic[25] == vec2.generic[25]) ? 0xFF : 0, 1);
	memset(&vec1.generic[26], (vec1.generic[26] == vec2.generic[26]) ? 0xFF : 0, 1);
	memset(&vec1.generic[27], (vec1.generic[27] == vec2.generic[27]) ? 0xFF : 0, 1);
	memset(&vec1.generic[28], (vec1.generic[28] == vec2.generic[28]) ? 0xFF : 0, 1);
	memset(&vec1.generic[29], (vec1.generic[29] == vec2.generic[29]) ? 0xFF : 0, 1);
	memset(&vec1.generic[30], (vec1.generic[30] == vec2.generic[30]) ? 0xFF : 0, 1);
	memset(&vec1.generic[31], (vec1.generic[31] == vec2.generic[31]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x32_CMPEQ_DEFINED
#endif
#if !defined(VINT8x32_CMPGT_DEFINED)
VEC_FUNC_IMPL vint8x32 vint8x32_cmpgt(vint8x32 vec1, vint8x32 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] > vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] > vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] > vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] > vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] > vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] > vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] > vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] > vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] > vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] > vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] > vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] > vec2.generic[15]) ? 0xFF : 0, 1);
	memset(&vec1.generic[16], (vec1.generic[16] > vec2.generic[16]) ? 0xFF : 0, 1);
	memset(&vec1.generic[17], (vec1.generic[17] > vec2.generic[17]) ? 0xFF : 0, 1);
	memset(&vec1.generic[18], (vec1.generic[18] > vec2.generic[18]) ? 0xFF : 0, 1);
	memset(&vec1.generic[19], (vec1.generic[19] > vec2.generic[19]) ? 0xFF : 0, 1);
	memset(&vec1.generic[20], (vec1.generic[20] > vec2.generic[20]) ? 0xFF : 0, 1);
	memset(&vec1.generic[21], (vec1.generic[21] > vec2.generic[21]) ? 0xFF : 0, 1);
	memset(&vec1.generic[22], (vec1.generic[22] > vec2.generic[22]) ? 0xFF : 0, 1);
	memset(&vec1.generic[23], (vec1.generic[23] > vec2.generic[23]) ? 0xFF : 0, 1);
	memset(&vec1.generic[24], (vec1.generic[24] > vec2.generic[24]) ? 0xFF : 0, 1);
	memset(&vec1.generic[25], (vec1.generic[25] > vec2.generic[25]) ? 0xFF : 0, 1);
	memset(&vec1.generic[26], (vec1.generic[26] > vec2.generic[26]) ? 0xFF : 0, 1);
	memset(&vec1.generic[27], (vec1.generic[27] > vec2.generic[27]) ? 0xFF : 0, 1);
	memset(&vec1.generic[28], (vec1.generic[28] > vec2.generic[28]) ? 0xFF : 0, 1);
	memset(&vec1.generic[29], (vec1.generic[29] > vec2.generic[29]) ? 0xFF : 0, 1);
	memset(&vec1.generic[30], (vec1.generic[30] > vec2.generic[30]) ? 0xFF : 0, 1);
	memset(&vec1.generic[31], (vec1.generic[31] > vec2.generic[31]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x32_CMPGT_DEFINED
#endif
#if !defined(VINT8x32_CMPLE_DEFINED)
VEC_FUNC_IMPL vint8x32 vint8x32_cmple(vint8x32 vec1, vint8x32 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] <= vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] <= vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] <= vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] <= vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] <= vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] <= vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] <= vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] <= vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] <= vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] <= vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] <= vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] <= vec2.generic[15]) ? 0xFF : 0, 1);
	memset(&vec1.generic[16], (vec1.generic[16] <= vec2.generic[16]) ? 0xFF : 0, 1);
	memset(&vec1.generic[17], (vec1.generic[17] <= vec2.generic[17]) ? 0xFF : 0, 1);
	memset(&vec1.generic[18], (vec1.generic[18] <= vec2.generic[18]) ? 0xFF : 0, 1);
	memset(&vec1.generic[19], (vec1.generic[19] <= vec2.generic[19]) ? 0xFF : 0, 1);
	memset(&vec1.generic[20], (vec1.generic[20] <= vec2.generic[20]) ? 0xFF : 0, 1);
	memset(&vec1.generic[21], (vec1.generic[21] <= vec2.generic[21]) ? 0xFF : 0, 1);
	memset(&vec1.generic[22], (vec1.generic[22] <= vec2.generic[22]) ? 0xFF : 0, 1);
	memset(&vec1.generic[23], (vec1.generic[23] <= vec2.generic[23]) ? 0xFF : 0, 1);
	memset(&vec1.generic[24], (vec1.generic[24] <= vec2.generic[24]) ? 0xFF : 0, 1);
	memset(&vec1.generic[25], (vec1.generic[25] <= vec2.generic[25]) ? 0xFF : 0, 1);
	memset(&vec1.generic[26], (vec1.generic[26] <= vec2.generic[26]) ? 0xFF : 0, 1);
	memset(&vec1.generic[27], (vec1.generic[27] <= vec2.generic[27]) ? 0xFF : 0, 1);
	memset(&vec1.generic[28], (vec1.generic[28] <= vec2.generic[28]) ? 0xFF : 0, 1);
	memset(&vec1.generic[29], (vec1.generic[29] <= vec2.generic[29]) ? 0xFF : 0, 1);
	memset(&vec1.generic[30], (vec1.generic[30] <= vec2.generic[30]) ? 0xFF : 0, 1);
	memset(&vec1.generic[31], (vec1.generic[31] <= vec2.generic[31]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x32_CMPLE_DEFINED
#endif
#if !defined(VINT8x32_CMPGE_DEFINED)
VEC_FUNC_IMPL vint8x32 vint8x32_cmpge(vint8x32 vec1, vint8x32 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] >= vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] >= vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] >= vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] >= vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] >= vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] >= vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] >= vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] >= vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] >= vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] >= vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] >= vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] >= vec2.generic[15]) ? 0xFF : 0, 1);
	memset(&vec1.generic[16], (vec1.generic[16] >= vec2.generic[16]) ? 0xFF : 0, 1);
	memset(&vec1.generic[17], (vec1.generic[17] >= vec2.generic[17]) ? 0xFF : 0, 1);
	memset(&vec1.generic[18], (vec1.generic[18] >= vec2.generic[18]) ? 0xFF : 0, 1);
	memset(&vec1.generic[19], (vec1.generic[19] >= vec2.generic[19]) ? 0xFF : 0, 1);
	memset(&vec1.generic[20], (vec1.generic[20] >= vec2.generic[20]) ? 0xFF : 0, 1);
	memset(&vec1.generic[21], (vec1.generic[21] >= vec2.generic[21]) ? 0xFF : 0, 1);
	memset(&vec1.generic[22], (vec1.generic[22] >= vec2.generic[22]) ? 0xFF : 0, 1);
	memset(&vec1.generic[23], (vec1.generic[23] >= vec2.generic[23]) ? 0xFF : 0, 1);
	memset(&vec1.generic[24], (vec1.generic[24] >= vec2.generic[24]) ? 0xFF : 0, 1);
	memset(&vec1.generic[25], (vec1.generic[25] >= vec2.generic[25]) ? 0xFF : 0, 1);
	memset(&vec1.generic[26], (vec1.generic[26] >= vec2.generic[26]) ? 0xFF : 0, 1);
	memset(&vec1.generic[27], (vec1.generic[27] >= vec2.generic[27]) ? 0xFF : 0, 1);
	memset(&vec1.generic[28], (vec1.generic[28] >= vec2.generic[28]) ? 0xFF : 0, 1);
	memset(&vec1.generic[29], (vec1.generic[29] >= vec2.generic[29]) ? 0xFF : 0, 1);
	memset(&vec1.generic[30], (vec1.generic[30] >= vec2.generic[30]) ? 0xFF : 0, 1);
	memset(&vec1.generic[31], (vec1.generic[31] >= vec2.generic[31]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x32_CMPGE_DEFINED
#endif
#if !defined(VINT8x32_MIN_DEFINED)
VEC_FUNC_IMPL vint8x32 vint8x32_min(vint8x32 vec1, vint8x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] < vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] < vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] < vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] < vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] < vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] < vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] < vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] < vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] < vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] < vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] < vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] < vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] < vec2.generic[16]) ? (vec1.generic[16]) : (vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] < vec2.generic[17]) ? (vec1.generic[17]) : (vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] < vec2.generic[18]) ? (vec1.generic[18]) : (vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] < vec2.generic[19]) ? (vec1.generic[19]) : (vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] < vec2.generic[20]) ? (vec1.generic[20]) : (vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] < vec2.generic[21]) ? (vec1.generic[21]) : (vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] < vec2.generic[22]) ? (vec1.generic[22]) : (vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] < vec2.generic[23]) ? (vec1.generic[23]) : (vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] < vec2.generic[24]) ? (vec1.generic[24]) : (vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] < vec2.generic[25]) ? (vec1.generic[25]) : (vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] < vec2.generic[26]) ? (vec1.generic[26]) : (vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] < vec2.generic[27]) ? (vec1.generic[27]) : (vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] < vec2.generic[28]) ? (vec1.generic[28]) : (vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] < vec2.generic[29]) ? (vec1.generic[29]) : (vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] < vec2.generic[30]) ? (vec1.generic[30]) : (vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] < vec2.generic[31]) ? (vec1.generic[31]) : (vec2.generic[31]);
	return vec1;
}
# define VINT8x32_MIN_DEFINED
#endif
#if !defined(VINT8x32_MAX_DEFINED)
VEC_FUNC_IMPL vint8x32 vint8x32_max(vint8x32 vec1, vint8x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] > vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] > vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] > vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] > vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] > vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] > vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] > vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] > vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] > vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] > vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] > vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] > vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] > vec2.generic[16]) ? (vec1.generic[16]) : (vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] > vec2.generic[17]) ? (vec1.generic[17]) : (vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] > vec2.generic[18]) ? (vec1.generic[18]) : (vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] > vec2.generic[19]) ? (vec1.generic[19]) : (vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] > vec2.generic[20]) ? (vec1.generic[20]) : (vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] > vec2.generic[21]) ? (vec1.generic[21]) : (vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] > vec2.generic[22]) ? (vec1.generic[22]) : (vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] > vec2.generic[23]) ? (vec1.generic[23]) : (vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] > vec2.generic[24]) ? (vec1.generic[24]) : (vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] > vec2.generic[25]) ? (vec1.generic[25]) : (vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] > vec2.generic[26]) ? (vec1.generic[26]) : (vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] > vec2.generic[27]) ? (vec1.generic[27]) : (vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] > vec2.generic[28]) ? (vec1.generic[28]) : (vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] > vec2.generic[29]) ? (vec1.generic[29]) : (vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] > vec2.generic[30]) ? (vec1.generic[30]) : (vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] > vec2.generic[31]) ? (vec1.generic[31]) : (vec2.generic[31]);
	return vec1;
}
# define VINT8x32_MAX_DEFINED
#endif
#if !defined(VINT8x32_RSHIFT_DEFINED)
VEC_FUNC_IMPL vint8x32 vint8x32_rshift(vint8x32 vec1, vuint8x32 vec2)
{
vec1.generic[0] = ((~vec1.generic[0]) >> vec2.generic[0]);
vec1.generic[1] = ((~vec1.generic[1]) >> vec2.generic[1]);
vec1.generic[2] = ((~vec1.generic[2]) >> vec2.generic[2]);
vec1.generic[3] = ((~vec1.generic[3]) >> vec2.generic[3]);
vec1.generic[4] = ((~vec1.generic[4]) >> vec2.generic[4]);
vec1.generic[5] = ((~vec1.generic[5]) >> vec2.generic[5]);
vec1.generic[6] = ((~vec1.generic[6]) >> vec2.generic[6]);
vec1.generic[7] = ((~vec1.generic[7]) >> vec2.generic[7]);
vec1.generic[8] = ((~vec1.generic[8]) >> vec2.generic[8]);
vec1.generic[9] = ((~vec1.generic[9]) >> vec2.generic[9]);
vec1.generic[10] = ((~vec1.generic[10]) >> vec2.generic[10]);
vec1.generic[11] = ((~vec1.generic[11]) >> vec2.generic[11]);
vec1.generic[12] = ((~vec1.generic[12]) >> vec2.generic[12]);
vec1.generic[13] = ((~vec1.generic[13]) >> vec2.generic[13]);
vec1.generic[14] = ((~vec1.generic[14]) >> vec2.generic[14]);
vec1.generic[15] = ((~vec1.generic[15]) >> vec2.generic[15]);
vec1.generic[16] = ((~vec1.generic[16]) >> vec2.generic[16]);
vec1.generic[17] = ((~vec1.generic[17]) >> vec2.generic[17]);
vec1.generic[18] = ((~vec1.generic[18]) >> vec2.generic[18]);
vec1.generic[19] = ((~vec1.generic[19]) >> vec2.generic[19]);
vec1.generic[20] = ((~vec1.generic[20]) >> vec2.generic[20]);
vec1.generic[21] = ((~vec1.generic[21]) >> vec2.generic[21]);
vec1.generic[22] = ((~vec1.generic[22]) >> vec2.generic[22]);
vec1.generic[23] = ((~vec1.generic[23]) >> vec2.generic[23]);
vec1.generic[24] = ((~vec1.generic[24]) >> vec2.generic[24]);
vec1.generic[25] = ((~vec1.generic[25]) >> vec2.generic[25]);
vec1.generic[26] = ((~vec1.generic[26]) >> vec2.generic[26]);
vec1.generic[27] = ((~vec1.generic[27]) >> vec2.generic[27]);
vec1.generic[28] = ((~vec1.generic[28]) >> vec2.generic[28]);
vec1.generic[29] = ((~vec1.generic[29]) >> vec2.generic[29]);
vec1.generic[30] = ((~vec1.generic[30]) >> vec2.generic[30]);
vec1.generic[31] = ((~vec1.generic[31]) >> vec2.generic[31]);
	return vec1;
}
# define VINT8x32_RSHIFT_DEFINED
#endif
#if !defined(VINT8x32_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vint8x32 vint8x32_lrshift(vint8x32 vec1, vuint8x32 vec2)
{
	union { vec_uint8 u; vec_int8 s; } x;

	x.s = vec1.generic[0];
	x.u >>= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u >>= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u >>= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u >>= vec2.generic[3];
	vec1.generic[3] = x.s;
	x.s = vec1.generic[4];
	x.u >>= vec2.generic[4];
	vec1.generic[4] = x.s;
	x.s = vec1.generic[5];
	x.u >>= vec2.generic[5];
	vec1.generic[5] = x.s;
	x.s = vec1.generic[6];
	x.u >>= vec2.generic[6];
	vec1.generic[6] = x.s;
	x.s = vec1.generic[7];
	x.u >>= vec2.generic[7];
	vec1.generic[7] = x.s;
	x.s = vec1.generic[8];
	x.u >>= vec2.generic[8];
	vec1.generic[8] = x.s;
	x.s = vec1.generic[9];
	x.u >>= vec2.generic[9];
	vec1.generic[9] = x.s;
	x.s = vec1.generic[10];
	x.u >>= vec2.generic[10];
	vec1.generic[10] = x.s;
	x.s = vec1.generic[11];
	x.u >>= vec2.generic[11];
	vec1.generic[11] = x.s;
	x.s = vec1.generic[12];
	x.u >>= vec2.generic[12];
	vec1.generic[12] = x.s;
	x.s = vec1.generic[13];
	x.u >>= vec2.generic[13];
	vec1.generic[13] = x.s;
	x.s = vec1.generic[14];
	x.u >>= vec2.generic[14];
	vec1.generic[14] = x.s;
	x.s = vec1.generic[15];
	x.u >>= vec2.generic[15];
	vec1.generic[15] = x.s;
	x.s = vec1.generic[16];
	x.u >>= vec2.generic[16];
	vec1.generic[16] = x.s;
	x.s = vec1.generic[17];
	x.u >>= vec2.generic[17];
	vec1.generic[17] = x.s;
	x.s = vec1.generic[18];
	x.u >>= vec2.generic[18];
	vec1.generic[18] = x.s;
	x.s = vec1.generic[19];
	x.u >>= vec2.generic[19];
	vec1.generic[19] = x.s;
	x.s = vec1.generic[20];
	x.u >>= vec2.generic[20];
	vec1.generic[20] = x.s;
	x.s = vec1.generic[21];
	x.u >>= vec2.generic[21];
	vec1.generic[21] = x.s;
	x.s = vec1.generic[22];
	x.u >>= vec2.generic[22];
	vec1.generic[22] = x.s;
	x.s = vec1.generic[23];
	x.u >>= vec2.generic[23];
	vec1.generic[23] = x.s;
	x.s = vec1.generic[24];
	x.u >>= vec2.generic[24];
	vec1.generic[24] = x.s;
	x.s = vec1.generic[25];
	x.u >>= vec2.generic[25];
	vec1.generic[25] = x.s;
	x.s = vec1.generic[26];
	x.u >>= vec2.generic[26];
	vec1.generic[26] = x.s;
	x.s = vec1.generic[27];
	x.u >>= vec2.generic[27];
	vec1.generic[27] = x.s;
	x.s = vec1.generic[28];
	x.u >>= vec2.generic[28];
	vec1.generic[28] = x.s;
	x.s = vec1.generic[29];
	x.u >>= vec2.generic[29];
	vec1.generic[29] = x.s;
	x.s = vec1.generic[30];
	x.u >>= vec2.generic[30];
	vec1.generic[30] = x.s;
	x.s = vec1.generic[31];
	x.u >>= vec2.generic[31];
	vec1.generic[31] = x.s;
	return vec1;
}
# define VINT8x32_LRSHIFT_DEFINED
#endif
#if !defined(VINT8x32_LSHIFT_DEFINED)
VEC_FUNC_IMPL vint8x32 vint8x32_lshift(vint8x32 vec1, vuint8x32 vec2)
{
	union { vec_uint8 u; vec_int8 s; } x;

	x.s = vec1.generic[0];
	x.u <<= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u <<= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u <<= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u <<= vec2.generic[3];
	vec1.generic[3] = x.s;
	x.s = vec1.generic[4];
	x.u <<= vec2.generic[4];
	vec1.generic[4] = x.s;
	x.s = vec1.generic[5];
	x.u <<= vec2.generic[5];
	vec1.generic[5] = x.s;
	x.s = vec1.generic[6];
	x.u <<= vec2.generic[6];
	vec1.generic[6] = x.s;
	x.s = vec1.generic[7];
	x.u <<= vec2.generic[7];
	vec1.generic[7] = x.s;
	x.s = vec1.generic[8];
	x.u <<= vec2.generic[8];
	vec1.generic[8] = x.s;
	x.s = vec1.generic[9];
	x.u <<= vec2.generic[9];
	vec1.generic[9] = x.s;
	x.s = vec1.generic[10];
	x.u <<= vec2.generic[10];
	vec1.generic[10] = x.s;
	x.s = vec1.generic[11];
	x.u <<= vec2.generic[11];
	vec1.generic[11] = x.s;
	x.s = vec1.generic[12];
	x.u <<= vec2.generic[12];
	vec1.generic[12] = x.s;
	x.s = vec1.generic[13];
	x.u <<= vec2.generic[13];
	vec1.generic[13] = x.s;
	x.s = vec1.generic[14];
	x.u <<= vec2.generic[14];
	vec1.generic[14] = x.s;
	x.s = vec1.generic[15];
	x.u <<= vec2.generic[15];
	vec1.generic[15] = x.s;
	x.s = vec1.generic[16];
	x.u <<= vec2.generic[16];
	vec1.generic[16] = x.s;
	x.s = vec1.generic[17];
	x.u <<= vec2.generic[17];
	vec1.generic[17] = x.s;
	x.s = vec1.generic[18];
	x.u <<= vec2.generic[18];
	vec1.generic[18] = x.s;
	x.s = vec1.generic[19];
	x.u <<= vec2.generic[19];
	vec1.generic[19] = x.s;
	x.s = vec1.generic[20];
	x.u <<= vec2.generic[20];
	vec1.generic[20] = x.s;
	x.s = vec1.generic[21];
	x.u <<= vec2.generic[21];
	vec1.generic[21] = x.s;
	x.s = vec1.generic[22];
	x.u <<= vec2.generic[22];
	vec1.generic[22] = x.s;
	x.s = vec1.generic[23];
	x.u <<= vec2.generic[23];
	vec1.generic[23] = x.s;
	x.s = vec1.generic[24];
	x.u <<= vec2.generic[24];
	vec1.generic[24] = x.s;
	x.s = vec1.generic[25];
	x.u <<= vec2.generic[25];
	vec1.generic[25] = x.s;
	x.s = vec1.generic[26];
	x.u <<= vec2.generic[26];
	vec1.generic[26] = x.s;
	x.s = vec1.generic[27];
	x.u <<= vec2.generic[27];
	vec1.generic[27] = x.s;
	x.s = vec1.generic[28];
	x.u <<= vec2.generic[28];
	vec1.generic[28] = x.s;
	x.s = vec1.generic[29];
	x.u <<= vec2.generic[29];
	vec1.generic[29] = x.s;
	x.s = vec1.generic[30];
	x.u <<= vec2.generic[30];
	vec1.generic[30] = x.s;
	x.s = vec1.generic[31];
	x.u <<= vec2.generic[31];
	vec1.generic[31] = x.s;
	return vec1;
}
# define VINT8x32_LSHIFT_DEFINED
#endif
#if !defined(VUINT8x32_SPLAT_DEFINED)
VEC_FUNC_IMPL vuint8x32 vuint8x32_splat(vec_uint8 x)
{
	vuint8x32 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	vec.generic[4] = x;
	vec.generic[5] = x;
	vec.generic[6] = x;
	vec.generic[7] = x;
	vec.generic[8] = x;
	vec.generic[9] = x;
	vec.generic[10] = x;
	vec.generic[11] = x;
	vec.generic[12] = x;
	vec.generic[13] = x;
	vec.generic[14] = x;
	vec.generic[15] = x;
	vec.generic[16] = x;
	vec.generic[17] = x;
	vec.generic[18] = x;
	vec.generic[19] = x;
	vec.generic[20] = x;
	vec.generic[21] = x;
	vec.generic[22] = x;
	vec.generic[23] = x;
	vec.generic[24] = x;
	vec.generic[25] = x;
	vec.generic[26] = x;
	vec.generic[27] = x;
	vec.generic[28] = x;
	vec.generic[29] = x;
	vec.generic[30] = x;
	vec.generic[31] = x;
	return vec;
}
# define VUINT8x32_SPLAT_DEFINED
#endif
#if !defined(VUINT8x32_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vuint8x32 vuint8x32_load_aligned(const vec_uint8 x[32])
{
	vuint8x32 vec;
	memcpy(vec.generic, x, 32);
	return vec;
}
# define VUINT8x32_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VUINT8x32_LOAD_DEFINED)
VEC_FUNC_IMPL vuint8x32 vuint8x32_load(const vec_uint8 x[32])
{
	vuint8x32 vec;
	memcpy(vec.generic, x, 32);
	return vec;
}
# define VUINT8x32_LOAD_DEFINED
#endif
#if !defined(VUINT8x32_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vuint8x32_store_aligned(vuint8x32 vec, vec_uint8 x[32])
{
	memcpy(x, vec.generic, 32);
}
# define VUINT8x32_STORE_ALIGNED_DEFINED
#endif
#if !defined(VUINT8x32_STORE_DEFINED)
VEC_FUNC_IMPL void vuint8x32_store(vuint8x32 vec, vec_uint8 x[32])
{
	memcpy(x, vec.generic, 32);
}
# define VUINT8x32_STORE_DEFINED
#endif
#if !defined(VUINT8x32_ADD_DEFINED)
VEC_FUNC_IMPL vuint8x32 vuint8x32_add(vuint8x32 vec1, vuint8x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] + vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] + vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] + vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] + vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] + vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] + vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] + vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] + vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] + vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] + vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] + vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] + vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] + vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] + vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] + vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] + vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] + vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] + vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] + vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] + vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] + vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] + vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] + vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] + vec2.generic[31]);
	return vec1;
}
# define VUINT8x32_ADD_DEFINED
#endif
#if !defined(VUINT8x32_SUB_DEFINED)
VEC_FUNC_IMPL vuint8x32 vuint8x32_sub(vuint8x32 vec1, vuint8x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] - vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] - vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] - vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] - vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] - vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] - vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] - vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] - vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] - vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] - vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] - vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] - vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] - vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] - vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] - vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] - vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] - vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] - vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] - vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] - vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] - vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] - vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] - vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] - vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] - vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] - vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] - vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] - vec2.generic[31]);
	return vec1;
}
# define VUINT8x32_SUB_DEFINED
#endif
#if !defined(VUINT8x32_MUL_DEFINED)
VEC_FUNC_IMPL vuint8x32 vuint8x32_mul(vuint8x32 vec1, vuint8x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] * vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] * vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] * vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] * vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] * vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] * vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] * vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] * vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] * vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] * vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] * vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] * vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] * vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] * vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] * vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] * vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] * vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] * vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] * vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] * vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] * vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] * vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] * vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] * vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] * vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] * vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] * vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] * vec2.generic[31]);
	return vec1;
}
# define VUINT8x32_MUL_DEFINED
#endif
#if !defined(VUINT8x32_DIV_DEFINED)
VEC_FUNC_IMPL vuint8x32 vuint8x32_div(vuint8x32 vec1, vuint8x32 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] / vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] / vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] / vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] / vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? (vec1.generic[8] / vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? (vec1.generic[9] / vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? (vec1.generic[10] / vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? (vec1.generic[11] / vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? (vec1.generic[12] / vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? (vec1.generic[13] / vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? (vec1.generic[14] / vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? (vec1.generic[15] / vec2.generic[15]) : 0);
	vec1.generic[16] = (vec2.generic[16] ? (vec1.generic[16] / vec2.generic[16]) : 0);
	vec1.generic[17] = (vec2.generic[17] ? (vec1.generic[17] / vec2.generic[17]) : 0);
	vec1.generic[18] = (vec2.generic[18] ? (vec1.generic[18] / vec2.generic[18]) : 0);
	vec1.generic[19] = (vec2.generic[19] ? (vec1.generic[19] / vec2.generic[19]) : 0);
	vec1.generic[20] = (vec2.generic[20] ? (vec1.generic[20] / vec2.generic[20]) : 0);
	vec1.generic[21] = (vec2.generic[21] ? (vec1.generic[21] / vec2.generic[21]) : 0);
	vec1.generic[22] = (vec2.generic[22] ? (vec1.generic[22] / vec2.generic[22]) : 0);
	vec1.generic[23] = (vec2.generic[23] ? (vec1.generic[23] / vec2.generic[23]) : 0);
	vec1.generic[24] = (vec2.generic[24] ? (vec1.generic[24] / vec2.generic[24]) : 0);
	vec1.generic[25] = (vec2.generic[25] ? (vec1.generic[25] / vec2.generic[25]) : 0);
	vec1.generic[26] = (vec2.generic[26] ? (vec1.generic[26] / vec2.generic[26]) : 0);
	vec1.generic[27] = (vec2.generic[27] ? (vec1.generic[27] / vec2.generic[27]) : 0);
	vec1.generic[28] = (vec2.generic[28] ? (vec1.generic[28] / vec2.generic[28]) : 0);
	vec1.generic[29] = (vec2.generic[29] ? (vec1.generic[29] / vec2.generic[29]) : 0);
	vec1.generic[30] = (vec2.generic[30] ? (vec1.generic[30] / vec2.generic[30]) : 0);
	vec1.generic[31] = (vec2.generic[31] ? (vec1.generic[31] / vec2.generic[31]) : 0);
	return vec1;
}
# define VUINT8x32_DIV_DEFINED
#endif
#if !defined(VUINT8x32_MOD_DEFINED)
VEC_FUNC_IMPL vuint8x32 vuint8x32_mod(vuint8x32 vec1, vuint8x32 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] % vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] % vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] % vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] % vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? (vec1.generic[8] % vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? (vec1.generic[9] % vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? (vec1.generic[10] % vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? (vec1.generic[11] % vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? (vec1.generic[12] % vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? (vec1.generic[13] % vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? (vec1.generic[14] % vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? (vec1.generic[15] % vec2.generic[15]) : 0);
	vec1.generic[16] = (vec2.generic[16] ? (vec1.generic[16] % vec2.generic[16]) : 0);
	vec1.generic[17] = (vec2.generic[17] ? (vec1.generic[17] % vec2.generic[17]) : 0);
	vec1.generic[18] = (vec2.generic[18] ? (vec1.generic[18] % vec2.generic[18]) : 0);
	vec1.generic[19] = (vec2.generic[19] ? (vec1.generic[19] % vec2.generic[19]) : 0);
	vec1.generic[20] = (vec2.generic[20] ? (vec1.generic[20] % vec2.generic[20]) : 0);
	vec1.generic[21] = (vec2.generic[21] ? (vec1.generic[21] % vec2.generic[21]) : 0);
	vec1.generic[22] = (vec2.generic[22] ? (vec1.generic[22] % vec2.generic[22]) : 0);
	vec1.generic[23] = (vec2.generic[23] ? (vec1.generic[23] % vec2.generic[23]) : 0);
	vec1.generic[24] = (vec2.generic[24] ? (vec1.generic[24] % vec2.generic[24]) : 0);
	vec1.generic[25] = (vec2.generic[25] ? (vec1.generic[25] % vec2.generic[25]) : 0);
	vec1.generic[26] = (vec2.generic[26] ? (vec1.generic[26] % vec2.generic[26]) : 0);
	vec1.generic[27] = (vec2.generic[27] ? (vec1.generic[27] % vec2.generic[27]) : 0);
	vec1.generic[28] = (vec2.generic[28] ? (vec1.generic[28] % vec2.generic[28]) : 0);
	vec1.generic[29] = (vec2.generic[29] ? (vec1.generic[29] % vec2.generic[29]) : 0);
	vec1.generic[30] = (vec2.generic[30] ? (vec1.generic[30] % vec2.generic[30]) : 0);
	vec1.generic[31] = (vec2.generic[31] ? (vec1.generic[31] % vec2.generic[31]) : 0);
	return vec1;
}
# define VUINT8x32_MOD_DEFINED
#endif
#if !defined(VUINT8x32_AVG_DEFINED)
VEC_FUNC_IMPL vuint8x32 vuint8x32_avg(vuint8x32 vec1, vuint8x32 vec2)
{
vec1.generic[0] = (vec1.generic[0] >> 1) + (vec2.generic[0] >> 1) + ((vec1.generic[0] | vec2.generic[0]) & 1);
vec1.generic[1] = (vec1.generic[1] >> 1) + (vec2.generic[1] >> 1) + ((vec1.generic[1] | vec2.generic[1]) & 1);
vec1.generic[2] = (vec1.generic[2] >> 1) + (vec2.generic[2] >> 1) + ((vec1.generic[2] | vec2.generic[2]) & 1);
vec1.generic[3] = (vec1.generic[3] >> 1) + (vec2.generic[3] >> 1) + ((vec1.generic[3] | vec2.generic[3]) & 1);
vec1.generic[4] = (vec1.generic[4] >> 1) + (vec2.generic[4] >> 1) + ((vec1.generic[4] | vec2.generic[4]) & 1);
vec1.generic[5] = (vec1.generic[5] >> 1) + (vec2.generic[5] >> 1) + ((vec1.generic[5] | vec2.generic[5]) & 1);
vec1.generic[6] = (vec1.generic[6] >> 1) + (vec2.generic[6] >> 1) + ((vec1.generic[6] | vec2.generic[6]) & 1);
vec1.generic[7] = (vec1.generic[7] >> 1) + (vec2.generic[7] >> 1) + ((vec1.generic[7] | vec2.generic[7]) & 1);
vec1.generic[8] = (vec1.generic[8] >> 1) + (vec2.generic[8] >> 1) + ((vec1.generic[8] | vec2.generic[8]) & 1);
vec1.generic[9] = (vec1.generic[9] >> 1) + (vec2.generic[9] >> 1) + ((vec1.generic[9] | vec2.generic[9]) & 1);
vec1.generic[10] = (vec1.generic[10] >> 1) + (vec2.generic[10] >> 1) + ((vec1.generic[10] | vec2.generic[10]) & 1);
vec1.generic[11] = (vec1.generic[11] >> 1) + (vec2.generic[11] >> 1) + ((vec1.generic[11] | vec2.generic[11]) & 1);
vec1.generic[12] = (vec1.generic[12] >> 1) + (vec2.generic[12] >> 1) + ((vec1.generic[12] | vec2.generic[12]) & 1);
vec1.generic[13] = (vec1.generic[13] >> 1) + (vec2.generic[13] >> 1) + ((vec1.generic[13] | vec2.generic[13]) & 1);
vec1.generic[14] = (vec1.generic[14] >> 1) + (vec2.generic[14] >> 1) + ((vec1.generic[14] | vec2.generic[14]) & 1);
vec1.generic[15] = (vec1.generic[15] >> 1) + (vec2.generic[15] >> 1) + ((vec1.generic[15] | vec2.generic[15]) & 1);
vec1.generic[16] = (vec1.generic[16] >> 1) + (vec2.generic[16] >> 1) + ((vec1.generic[16] | vec2.generic[16]) & 1);
vec1.generic[17] = (vec1.generic[17] >> 1) + (vec2.generic[17] >> 1) + ((vec1.generic[17] | vec2.generic[17]) & 1);
vec1.generic[18] = (vec1.generic[18] >> 1) + (vec2.generic[18] >> 1) + ((vec1.generic[18] | vec2.generic[18]) & 1);
vec1.generic[19] = (vec1.generic[19] >> 1) + (vec2.generic[19] >> 1) + ((vec1.generic[19] | vec2.generic[19]) & 1);
vec1.generic[20] = (vec1.generic[20] >> 1) + (vec2.generic[20] >> 1) + ((vec1.generic[20] | vec2.generic[20]) & 1);
vec1.generic[21] = (vec1.generic[21] >> 1) + (vec2.generic[21] >> 1) + ((vec1.generic[21] | vec2.generic[21]) & 1);
vec1.generic[22] = (vec1.generic[22] >> 1) + (vec2.generic[22] >> 1) + ((vec1.generic[22] | vec2.generic[22]) & 1);
vec1.generic[23] = (vec1.generic[23] >> 1) + (vec2.generic[23] >> 1) + ((vec1.generic[23] | vec2.generic[23]) & 1);
vec1.generic[24] = (vec1.generic[24] >> 1) + (vec2.generic[24] >> 1) + ((vec1.generic[24] | vec2.generic[24]) & 1);
vec1.generic[25] = (vec1.generic[25] >> 1) + (vec2.generic[25] >> 1) + ((vec1.generic[25] | vec2.generic[25]) & 1);
vec1.generic[26] = (vec1.generic[26] >> 1) + (vec2.generic[26] >> 1) + ((vec1.generic[26] | vec2.generic[26]) & 1);
vec1.generic[27] = (vec1.generic[27] >> 1) + (vec2.generic[27] >> 1) + ((vec1.generic[27] | vec2.generic[27]) & 1);
vec1.generic[28] = (vec1.generic[28] >> 1) + (vec2.generic[28] >> 1) + ((vec1.generic[28] | vec2.generic[28]) & 1);
vec1.generic[29] = (vec1.generic[29] >> 1) + (vec2.generic[29] >> 1) + ((vec1.generic[29] | vec2.generic[29]) & 1);
vec1.generic[30] = (vec1.generic[30] >> 1) + (vec2.generic[30] >> 1) + ((vec1.generic[30] | vec2.generic[30]) & 1);
vec1.generic[31] = (vec1.generic[31] >> 1) + (vec2.generic[31] >> 1) + ((vec1.generic[31] | vec2.generic[31]) & 1);
	return vec1;
}
# define VUINT8x32_AVG_DEFINED
#endif
#if !defined(VUINT8x32_AND_DEFINED)
VEC_FUNC_IMPL vuint8x32 vuint8x32_and(vuint8x32 vec1, vuint8x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] & vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] & vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] & vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] & vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] & vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] & vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] & vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] & vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] & vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] & vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] & vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] & vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] & vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] & vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] & vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] & vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] & vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] & vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] & vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] & vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] & vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] & vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] & vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] & vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] & vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] & vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] & vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] & vec2.generic[31]);
	return vec1;
}
# define VUINT8x32_AND_DEFINED
#endif
#if !defined(VUINT8x32_OR_DEFINED)
VEC_FUNC_IMPL vuint8x32 vuint8x32_or(vuint8x32 vec1, vuint8x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] | vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] | vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] | vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] | vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] | vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] | vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] | vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] | vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] | vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] | vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] | vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] | vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] | vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] | vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] | vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] | vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] | vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] | vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] | vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] | vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] | vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] | vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] | vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] | vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] | vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] | vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] | vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] | vec2.generic[31]);
	return vec1;
}
# define VUINT8x32_OR_DEFINED
#endif
#if !defined(VUINT8x32_XOR_DEFINED)
VEC_FUNC_IMPL vuint8x32 vuint8x32_xor(vuint8x32 vec1, vuint8x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] ^ vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] ^ vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] ^ vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] ^ vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] ^ vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] ^ vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] ^ vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] ^ vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] ^ vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] ^ vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] ^ vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] ^ vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] ^ vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] ^ vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] ^ vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] ^ vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] ^ vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] ^ vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] ^ vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] ^ vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] ^ vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] ^ vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] ^ vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] ^ vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] ^ vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] ^ vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] ^ vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] ^ vec2.generic[31]);
	return vec1;
}
# define VUINT8x32_XOR_DEFINED
#endif
#if !defined(VUINT8x32_NOT_DEFINED)
VEC_FUNC_IMPL vuint8x32 vuint8x32_not(vuint8x32 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	vec.generic[4] = ~vec.generic[4];
	vec.generic[5] = ~vec.generic[5];
	vec.generic[6] = ~vec.generic[6];
	vec.generic[7] = ~vec.generic[7];
	vec.generic[8] = ~vec.generic[8];
	vec.generic[9] = ~vec.generic[9];
	vec.generic[10] = ~vec.generic[10];
	vec.generic[11] = ~vec.generic[11];
	vec.generic[12] = ~vec.generic[12];
	vec.generic[13] = ~vec.generic[13];
	vec.generic[14] = ~vec.generic[14];
	vec.generic[15] = ~vec.generic[15];
	vec.generic[16] = ~vec.generic[16];
	vec.generic[17] = ~vec.generic[17];
	vec.generic[18] = ~vec.generic[18];
	vec.generic[19] = ~vec.generic[19];
	vec.generic[20] = ~vec.generic[20];
	vec.generic[21] = ~vec.generic[21];
	vec.generic[22] = ~vec.generic[22];
	vec.generic[23] = ~vec.generic[23];
	vec.generic[24] = ~vec.generic[24];
	vec.generic[25] = ~vec.generic[25];
	vec.generic[26] = ~vec.generic[26];
	vec.generic[27] = ~vec.generic[27];
	vec.generic[28] = ~vec.generic[28];
	vec.generic[29] = ~vec.generic[29];
	vec.generic[30] = ~vec.generic[30];
	vec.generic[31] = ~vec.generic[31];
	return vec;
}
# define VUINT8x32_NOT_DEFINED
#endif
#if !defined(VUINT8x32_CMPLT_DEFINED)
VEC_FUNC_IMPL vuint8x32 vuint8x32_cmplt(vuint8x32 vec1, vuint8x32 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] < vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] < vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] < vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] < vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] < vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] < vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] < vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] < vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] < vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] < vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] < vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] < vec2.generic[15]) ? 0xFF : 0, 1);
	memset(&vec1.generic[16], (vec1.generic[16] < vec2.generic[16]) ? 0xFF : 0, 1);
	memset(&vec1.generic[17], (vec1.generic[17] < vec2.generic[17]) ? 0xFF : 0, 1);
	memset(&vec1.generic[18], (vec1.generic[18] < vec2.generic[18]) ? 0xFF : 0, 1);
	memset(&vec1.generic[19], (vec1.generic[19] < vec2.generic[19]) ? 0xFF : 0, 1);
	memset(&vec1.generic[20], (vec1.generic[20] < vec2.generic[20]) ? 0xFF : 0, 1);
	memset(&vec1.generic[21], (vec1.generic[21] < vec2.generic[21]) ? 0xFF : 0, 1);
	memset(&vec1.generic[22], (vec1.generic[22] < vec2.generic[22]) ? 0xFF : 0, 1);
	memset(&vec1.generic[23], (vec1.generic[23] < vec2.generic[23]) ? 0xFF : 0, 1);
	memset(&vec1.generic[24], (vec1.generic[24] < vec2.generic[24]) ? 0xFF : 0, 1);
	memset(&vec1.generic[25], (vec1.generic[25] < vec2.generic[25]) ? 0xFF : 0, 1);
	memset(&vec1.generic[26], (vec1.generic[26] < vec2.generic[26]) ? 0xFF : 0, 1);
	memset(&vec1.generic[27], (vec1.generic[27] < vec2.generic[27]) ? 0xFF : 0, 1);
	memset(&vec1.generic[28], (vec1.generic[28] < vec2.generic[28]) ? 0xFF : 0, 1);
	memset(&vec1.generic[29], (vec1.generic[29] < vec2.generic[29]) ? 0xFF : 0, 1);
	memset(&vec1.generic[30], (vec1.generic[30] < vec2.generic[30]) ? 0xFF : 0, 1);
	memset(&vec1.generic[31], (vec1.generic[31] < vec2.generic[31]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x32_CMPLT_DEFINED
#endif
#if !defined(VUINT8x32_CMPEQ_DEFINED)
VEC_FUNC_IMPL vuint8x32 vuint8x32_cmpeq(vuint8x32 vec1, vuint8x32 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] == vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] == vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] == vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] == vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] == vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] == vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] == vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] == vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] == vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] == vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] == vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] == vec2.generic[15]) ? 0xFF : 0, 1);
	memset(&vec1.generic[16], (vec1.generic[16] == vec2.generic[16]) ? 0xFF : 0, 1);
	memset(&vec1.generic[17], (vec1.generic[17] == vec2.generic[17]) ? 0xFF : 0, 1);
	memset(&vec1.generic[18], (vec1.generic[18] == vec2.generic[18]) ? 0xFF : 0, 1);
	memset(&vec1.generic[19], (vec1.generic[19] == vec2.generic[19]) ? 0xFF : 0, 1);
	memset(&vec1.generic[20], (vec1.generic[20] == vec2.generic[20]) ? 0xFF : 0, 1);
	memset(&vec1.generic[21], (vec1.generic[21] == vec2.generic[21]) ? 0xFF : 0, 1);
	memset(&vec1.generic[22], (vec1.generic[22] == vec2.generic[22]) ? 0xFF : 0, 1);
	memset(&vec1.generic[23], (vec1.generic[23] == vec2.generic[23]) ? 0xFF : 0, 1);
	memset(&vec1.generic[24], (vec1.generic[24] == vec2.generic[24]) ? 0xFF : 0, 1);
	memset(&vec1.generic[25], (vec1.generic[25] == vec2.generic[25]) ? 0xFF : 0, 1);
	memset(&vec1.generic[26], (vec1.generic[26] == vec2.generic[26]) ? 0xFF : 0, 1);
	memset(&vec1.generic[27], (vec1.generic[27] == vec2.generic[27]) ? 0xFF : 0, 1);
	memset(&vec1.generic[28], (vec1.generic[28] == vec2.generic[28]) ? 0xFF : 0, 1);
	memset(&vec1.generic[29], (vec1.generic[29] == vec2.generic[29]) ? 0xFF : 0, 1);
	memset(&vec1.generic[30], (vec1.generic[30] == vec2.generic[30]) ? 0xFF : 0, 1);
	memset(&vec1.generic[31], (vec1.generic[31] == vec2.generic[31]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x32_CMPEQ_DEFINED
#endif
#if !defined(VUINT8x32_CMPGT_DEFINED)
VEC_FUNC_IMPL vuint8x32 vuint8x32_cmpgt(vuint8x32 vec1, vuint8x32 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] > vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] > vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] > vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] > vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] > vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] > vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] > vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] > vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] > vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] > vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] > vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] > vec2.generic[15]) ? 0xFF : 0, 1);
	memset(&vec1.generic[16], (vec1.generic[16] > vec2.generic[16]) ? 0xFF : 0, 1);
	memset(&vec1.generic[17], (vec1.generic[17] > vec2.generic[17]) ? 0xFF : 0, 1);
	memset(&vec1.generic[18], (vec1.generic[18] > vec2.generic[18]) ? 0xFF : 0, 1);
	memset(&vec1.generic[19], (vec1.generic[19] > vec2.generic[19]) ? 0xFF : 0, 1);
	memset(&vec1.generic[20], (vec1.generic[20] > vec2.generic[20]) ? 0xFF : 0, 1);
	memset(&vec1.generic[21], (vec1.generic[21] > vec2.generic[21]) ? 0xFF : 0, 1);
	memset(&vec1.generic[22], (vec1.generic[22] > vec2.generic[22]) ? 0xFF : 0, 1);
	memset(&vec1.generic[23], (vec1.generic[23] > vec2.generic[23]) ? 0xFF : 0, 1);
	memset(&vec1.generic[24], (vec1.generic[24] > vec2.generic[24]) ? 0xFF : 0, 1);
	memset(&vec1.generic[25], (vec1.generic[25] > vec2.generic[25]) ? 0xFF : 0, 1);
	memset(&vec1.generic[26], (vec1.generic[26] > vec2.generic[26]) ? 0xFF : 0, 1);
	memset(&vec1.generic[27], (vec1.generic[27] > vec2.generic[27]) ? 0xFF : 0, 1);
	memset(&vec1.generic[28], (vec1.generic[28] > vec2.generic[28]) ? 0xFF : 0, 1);
	memset(&vec1.generic[29], (vec1.generic[29] > vec2.generic[29]) ? 0xFF : 0, 1);
	memset(&vec1.generic[30], (vec1.generic[30] > vec2.generic[30]) ? 0xFF : 0, 1);
	memset(&vec1.generic[31], (vec1.generic[31] > vec2.generic[31]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x32_CMPGT_DEFINED
#endif
#if !defined(VUINT8x32_CMPLE_DEFINED)
VEC_FUNC_IMPL vuint8x32 vuint8x32_cmple(vuint8x32 vec1, vuint8x32 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] <= vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] <= vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] <= vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] <= vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] <= vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] <= vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] <= vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] <= vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] <= vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] <= vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] <= vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] <= vec2.generic[15]) ? 0xFF : 0, 1);
	memset(&vec1.generic[16], (vec1.generic[16] <= vec2.generic[16]) ? 0xFF : 0, 1);
	memset(&vec1.generic[17], (vec1.generic[17] <= vec2.generic[17]) ? 0xFF : 0, 1);
	memset(&vec1.generic[18], (vec1.generic[18] <= vec2.generic[18]) ? 0xFF : 0, 1);
	memset(&vec1.generic[19], (vec1.generic[19] <= vec2.generic[19]) ? 0xFF : 0, 1);
	memset(&vec1.generic[20], (vec1.generic[20] <= vec2.generic[20]) ? 0xFF : 0, 1);
	memset(&vec1.generic[21], (vec1.generic[21] <= vec2.generic[21]) ? 0xFF : 0, 1);
	memset(&vec1.generic[22], (vec1.generic[22] <= vec2.generic[22]) ? 0xFF : 0, 1);
	memset(&vec1.generic[23], (vec1.generic[23] <= vec2.generic[23]) ? 0xFF : 0, 1);
	memset(&vec1.generic[24], (vec1.generic[24] <= vec2.generic[24]) ? 0xFF : 0, 1);
	memset(&vec1.generic[25], (vec1.generic[25] <= vec2.generic[25]) ? 0xFF : 0, 1);
	memset(&vec1.generic[26], (vec1.generic[26] <= vec2.generic[26]) ? 0xFF : 0, 1);
	memset(&vec1.generic[27], (vec1.generic[27] <= vec2.generic[27]) ? 0xFF : 0, 1);
	memset(&vec1.generic[28], (vec1.generic[28] <= vec2.generic[28]) ? 0xFF : 0, 1);
	memset(&vec1.generic[29], (vec1.generic[29] <= vec2.generic[29]) ? 0xFF : 0, 1);
	memset(&vec1.generic[30], (vec1.generic[30] <= vec2.generic[30]) ? 0xFF : 0, 1);
	memset(&vec1.generic[31], (vec1.generic[31] <= vec2.generic[31]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x32_CMPLE_DEFINED
#endif
#if !defined(VUINT8x32_CMPGE_DEFINED)
VEC_FUNC_IMPL vuint8x32 vuint8x32_cmpge(vuint8x32 vec1, vuint8x32 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] >= vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] >= vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] >= vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] >= vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] >= vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] >= vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] >= vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] >= vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] >= vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] >= vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] >= vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] >= vec2.generic[15]) ? 0xFF : 0, 1);
	memset(&vec1.generic[16], (vec1.generic[16] >= vec2.generic[16]) ? 0xFF : 0, 1);
	memset(&vec1.generic[17], (vec1.generic[17] >= vec2.generic[17]) ? 0xFF : 0, 1);
	memset(&vec1.generic[18], (vec1.generic[18] >= vec2.generic[18]) ? 0xFF : 0, 1);
	memset(&vec1.generic[19], (vec1.generic[19] >= vec2.generic[19]) ? 0xFF : 0, 1);
	memset(&vec1.generic[20], (vec1.generic[20] >= vec2.generic[20]) ? 0xFF : 0, 1);
	memset(&vec1.generic[21], (vec1.generic[21] >= vec2.generic[21]) ? 0xFF : 0, 1);
	memset(&vec1.generic[22], (vec1.generic[22] >= vec2.generic[22]) ? 0xFF : 0, 1);
	memset(&vec1.generic[23], (vec1.generic[23] >= vec2.generic[23]) ? 0xFF : 0, 1);
	memset(&vec1.generic[24], (vec1.generic[24] >= vec2.generic[24]) ? 0xFF : 0, 1);
	memset(&vec1.generic[25], (vec1.generic[25] >= vec2.generic[25]) ? 0xFF : 0, 1);
	memset(&vec1.generic[26], (vec1.generic[26] >= vec2.generic[26]) ? 0xFF : 0, 1);
	memset(&vec1.generic[27], (vec1.generic[27] >= vec2.generic[27]) ? 0xFF : 0, 1);
	memset(&vec1.generic[28], (vec1.generic[28] >= vec2.generic[28]) ? 0xFF : 0, 1);
	memset(&vec1.generic[29], (vec1.generic[29] >= vec2.generic[29]) ? 0xFF : 0, 1);
	memset(&vec1.generic[30], (vec1.generic[30] >= vec2.generic[30]) ? 0xFF : 0, 1);
	memset(&vec1.generic[31], (vec1.generic[31] >= vec2.generic[31]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x32_CMPGE_DEFINED
#endif
#if !defined(VUINT8x32_MIN_DEFINED)
VEC_FUNC_IMPL vuint8x32 vuint8x32_min(vuint8x32 vec1, vuint8x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] < vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] < vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] < vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] < vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] < vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] < vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] < vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] < vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] < vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] < vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] < vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] < vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] < vec2.generic[16]) ? (vec1.generic[16]) : (vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] < vec2.generic[17]) ? (vec1.generic[17]) : (vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] < vec2.generic[18]) ? (vec1.generic[18]) : (vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] < vec2.generic[19]) ? (vec1.generic[19]) : (vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] < vec2.generic[20]) ? (vec1.generic[20]) : (vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] < vec2.generic[21]) ? (vec1.generic[21]) : (vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] < vec2.generic[22]) ? (vec1.generic[22]) : (vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] < vec2.generic[23]) ? (vec1.generic[23]) : (vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] < vec2.generic[24]) ? (vec1.generic[24]) : (vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] < vec2.generic[25]) ? (vec1.generic[25]) : (vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] < vec2.generic[26]) ? (vec1.generic[26]) : (vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] < vec2.generic[27]) ? (vec1.generic[27]) : (vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] < vec2.generic[28]) ? (vec1.generic[28]) : (vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] < vec2.generic[29]) ? (vec1.generic[29]) : (vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] < vec2.generic[30]) ? (vec1.generic[30]) : (vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] < vec2.generic[31]) ? (vec1.generic[31]) : (vec2.generic[31]);
	return vec1;
}
# define VUINT8x32_MIN_DEFINED
#endif
#if !defined(VUINT8x32_MAX_DEFINED)
VEC_FUNC_IMPL vuint8x32 vuint8x32_max(vuint8x32 vec1, vuint8x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] > vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] > vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] > vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] > vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] > vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] > vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] > vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] > vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] > vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] > vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] > vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] > vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] > vec2.generic[16]) ? (vec1.generic[16]) : (vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] > vec2.generic[17]) ? (vec1.generic[17]) : (vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] > vec2.generic[18]) ? (vec1.generic[18]) : (vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] > vec2.generic[19]) ? (vec1.generic[19]) : (vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] > vec2.generic[20]) ? (vec1.generic[20]) : (vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] > vec2.generic[21]) ? (vec1.generic[21]) : (vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] > vec2.generic[22]) ? (vec1.generic[22]) : (vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] > vec2.generic[23]) ? (vec1.generic[23]) : (vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] > vec2.generic[24]) ? (vec1.generic[24]) : (vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] > vec2.generic[25]) ? (vec1.generic[25]) : (vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] > vec2.generic[26]) ? (vec1.generic[26]) : (vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] > vec2.generic[27]) ? (vec1.generic[27]) : (vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] > vec2.generic[28]) ? (vec1.generic[28]) : (vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] > vec2.generic[29]) ? (vec1.generic[29]) : (vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] > vec2.generic[30]) ? (vec1.generic[30]) : (vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] > vec2.generic[31]) ? (vec1.generic[31]) : (vec2.generic[31]);
	return vec1;
}
# define VUINT8x32_MAX_DEFINED
#endif
#if !defined(VUINT8x32_RSHIFT_DEFINED)
VEC_FUNC_IMPL vuint8x32 vuint8x32_rshift(vuint8x32 vec1, vuint8x32 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	vec1.generic[4] >>= vec2.generic[0];
	vec1.generic[5] >>= vec2.generic[0];
	vec1.generic[6] >>= vec2.generic[0];
	vec1.generic[7] >>= vec2.generic[0];
	vec1.generic[8] >>= vec2.generic[0];
	vec1.generic[9] >>= vec2.generic[0];
	vec1.generic[10] >>= vec2.generic[0];
	vec1.generic[11] >>= vec2.generic[0];
	vec1.generic[12] >>= vec2.generic[0];
	vec1.generic[13] >>= vec2.generic[0];
	vec1.generic[14] >>= vec2.generic[0];
	vec1.generic[15] >>= vec2.generic[0];
	vec1.generic[16] >>= vec2.generic[0];
	vec1.generic[17] >>= vec2.generic[0];
	vec1.generic[18] >>= vec2.generic[0];
	vec1.generic[19] >>= vec2.generic[0];
	vec1.generic[20] >>= vec2.generic[0];
	vec1.generic[21] >>= vec2.generic[0];
	vec1.generic[22] >>= vec2.generic[0];
	vec1.generic[23] >>= vec2.generic[0];
	vec1.generic[24] >>= vec2.generic[0];
	vec1.generic[25] >>= vec2.generic[0];
	vec1.generic[26] >>= vec2.generic[0];
	vec1.generic[27] >>= vec2.generic[0];
	vec1.generic[28] >>= vec2.generic[0];
	vec1.generic[29] >>= vec2.generic[0];
	vec1.generic[30] >>= vec2.generic[0];
	vec1.generic[31] >>= vec2.generic[0];
	return vec1;
}
# define VUINT8x32_RSHIFT_DEFINED
#endif
#if !defined(VUINT8x32_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vuint8x32 vuint8x32_lrshift(vuint8x32 vec1, vuint8x32 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	vec1.generic[4] >>= vec2.generic[0];
	vec1.generic[5] >>= vec2.generic[0];
	vec1.generic[6] >>= vec2.generic[0];
	vec1.generic[7] >>= vec2.generic[0];
	vec1.generic[8] >>= vec2.generic[0];
	vec1.generic[9] >>= vec2.generic[0];
	vec1.generic[10] >>= vec2.generic[0];
	vec1.generic[11] >>= vec2.generic[0];
	vec1.generic[12] >>= vec2.generic[0];
	vec1.generic[13] >>= vec2.generic[0];
	vec1.generic[14] >>= vec2.generic[0];
	vec1.generic[15] >>= vec2.generic[0];
	vec1.generic[16] >>= vec2.generic[0];
	vec1.generic[17] >>= vec2.generic[0];
	vec1.generic[18] >>= vec2.generic[0];
	vec1.generic[19] >>= vec2.generic[0];
	vec1.generic[20] >>= vec2.generic[0];
	vec1.generic[21] >>= vec2.generic[0];
	vec1.generic[22] >>= vec2.generic[0];
	vec1.generic[23] >>= vec2.generic[0];
	vec1.generic[24] >>= vec2.generic[0];
	vec1.generic[25] >>= vec2.generic[0];
	vec1.generic[26] >>= vec2.generic[0];
	vec1.generic[27] >>= vec2.generic[0];
	vec1.generic[28] >>= vec2.generic[0];
	vec1.generic[29] >>= vec2.generic[0];
	vec1.generic[30] >>= vec2.generic[0];
	vec1.generic[31] >>= vec2.generic[0];
	return vec1;
}
# define VUINT8x32_LRSHIFT_DEFINED
#endif
#if !defined(VUINT8x32_LSHIFT_DEFINED)
VEC_FUNC_IMPL vuint8x32 vuint8x32_lshift(vuint8x32 vec1, vuint8x32 vec2)
{
	vec1.generic[0] <<= vec2.generic[0];
	vec1.generic[1] <<= vec2.generic[0];
	vec1.generic[2] <<= vec2.generic[0];
	vec1.generic[3] <<= vec2.generic[0];
	vec1.generic[4] <<= vec2.generic[0];
	vec1.generic[5] <<= vec2.generic[0];
	vec1.generic[6] <<= vec2.generic[0];
	vec1.generic[7] <<= vec2.generic[0];
	vec1.generic[8] <<= vec2.generic[0];
	vec1.generic[9] <<= vec2.generic[0];
	vec1.generic[10] <<= vec2.generic[0];
	vec1.generic[11] <<= vec2.generic[0];
	vec1.generic[12] <<= vec2.generic[0];
	vec1.generic[13] <<= vec2.generic[0];
	vec1.generic[14] <<= vec2.generic[0];
	vec1.generic[15] <<= vec2.generic[0];
	vec1.generic[16] <<= vec2.generic[0];
	vec1.generic[17] <<= vec2.generic[0];
	vec1.generic[18] <<= vec2.generic[0];
	vec1.generic[19] <<= vec2.generic[0];
	vec1.generic[20] <<= vec2.generic[0];
	vec1.generic[21] <<= vec2.generic[0];
	vec1.generic[22] <<= vec2.generic[0];
	vec1.generic[23] <<= vec2.generic[0];
	vec1.generic[24] <<= vec2.generic[0];
	vec1.generic[25] <<= vec2.generic[0];
	vec1.generic[26] <<= vec2.generic[0];
	vec1.generic[27] <<= vec2.generic[0];
	vec1.generic[28] <<= vec2.generic[0];
	vec1.generic[29] <<= vec2.generic[0];
	vec1.generic[30] <<= vec2.generic[0];
	vec1.generic[31] <<= vec2.generic[0];
	return vec1;
}
# define VUINT8x32_LSHIFT_DEFINED
#endif
#if !defined(VINT8x64_SPLAT_DEFINED)
VEC_FUNC_IMPL vint8x64 vint8x64_splat(vec_int8 x)
{
	vint8x64 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	vec.generic[4] = x;
	vec.generic[5] = x;
	vec.generic[6] = x;
	vec.generic[7] = x;
	vec.generic[8] = x;
	vec.generic[9] = x;
	vec.generic[10] = x;
	vec.generic[11] = x;
	vec.generic[12] = x;
	vec.generic[13] = x;
	vec.generic[14] = x;
	vec.generic[15] = x;
	vec.generic[16] = x;
	vec.generic[17] = x;
	vec.generic[18] = x;
	vec.generic[19] = x;
	vec.generic[20] = x;
	vec.generic[21] = x;
	vec.generic[22] = x;
	vec.generic[23] = x;
	vec.generic[24] = x;
	vec.generic[25] = x;
	vec.generic[26] = x;
	vec.generic[27] = x;
	vec.generic[28] = x;
	vec.generic[29] = x;
	vec.generic[30] = x;
	vec.generic[31] = x;
	vec.generic[32] = x;
	vec.generic[33] = x;
	vec.generic[34] = x;
	vec.generic[35] = x;
	vec.generic[36] = x;
	vec.generic[37] = x;
	vec.generic[38] = x;
	vec.generic[39] = x;
	vec.generic[40] = x;
	vec.generic[41] = x;
	vec.generic[42] = x;
	vec.generic[43] = x;
	vec.generic[44] = x;
	vec.generic[45] = x;
	vec.generic[46] = x;
	vec.generic[47] = x;
	vec.generic[48] = x;
	vec.generic[49] = x;
	vec.generic[50] = x;
	vec.generic[51] = x;
	vec.generic[52] = x;
	vec.generic[53] = x;
	vec.generic[54] = x;
	vec.generic[55] = x;
	vec.generic[56] = x;
	vec.generic[57] = x;
	vec.generic[58] = x;
	vec.generic[59] = x;
	vec.generic[60] = x;
	vec.generic[61] = x;
	vec.generic[62] = x;
	vec.generic[63] = x;
	return vec;
}
# define VINT8x64_SPLAT_DEFINED
#endif
#if !defined(VINT8x64_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vint8x64 vint8x64_load_aligned(const vec_int8 x[64])
{
	vint8x64 vec;
	memcpy(vec.generic, x, 64);
	return vec;
}
# define VINT8x64_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VINT8x64_LOAD_DEFINED)
VEC_FUNC_IMPL vint8x64 vint8x64_load(const vec_int8 x[64])
{
	vint8x64 vec;
	memcpy(vec.generic, x, 64);
	return vec;
}
# define VINT8x64_LOAD_DEFINED
#endif
#if !defined(VINT8x64_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vint8x64_store_aligned(vint8x64 vec, vec_int8 x[64])
{
	memcpy(x, vec.generic, 64);
}
# define VINT8x64_STORE_ALIGNED_DEFINED
#endif
#if !defined(VINT8x64_STORE_DEFINED)
VEC_FUNC_IMPL void vint8x64_store(vint8x64 vec, vec_int8 x[64])
{
	memcpy(x, vec.generic, 64);
}
# define VINT8x64_STORE_DEFINED
#endif
#if !defined(VINT8x64_ADD_DEFINED)
VEC_FUNC_IMPL vint8x64 vint8x64_add(vint8x64 vec1, vint8x64 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] + vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] + vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] + vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] + vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] + vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] + vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] + vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] + vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] + vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] + vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] + vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] + vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] + vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] + vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] + vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] + vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] + vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] + vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] + vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] + vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] + vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] + vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] + vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] + vec2.generic[31]);
	vec1.generic[32] = (vec1.generic[32] + vec2.generic[32]);
	vec1.generic[33] = (vec1.generic[33] + vec2.generic[33]);
	vec1.generic[34] = (vec1.generic[34] + vec2.generic[34]);
	vec1.generic[35] = (vec1.generic[35] + vec2.generic[35]);
	vec1.generic[36] = (vec1.generic[36] + vec2.generic[36]);
	vec1.generic[37] = (vec1.generic[37] + vec2.generic[37]);
	vec1.generic[38] = (vec1.generic[38] + vec2.generic[38]);
	vec1.generic[39] = (vec1.generic[39] + vec2.generic[39]);
	vec1.generic[40] = (vec1.generic[40] + vec2.generic[40]);
	vec1.generic[41] = (vec1.generic[41] + vec2.generic[41]);
	vec1.generic[42] = (vec1.generic[42] + vec2.generic[42]);
	vec1.generic[43] = (vec1.generic[43] + vec2.generic[43]);
	vec1.generic[44] = (vec1.generic[44] + vec2.generic[44]);
	vec1.generic[45] = (vec1.generic[45] + vec2.generic[45]);
	vec1.generic[46] = (vec1.generic[46] + vec2.generic[46]);
	vec1.generic[47] = (vec1.generic[47] + vec2.generic[47]);
	vec1.generic[48] = (vec1.generic[48] + vec2.generic[48]);
	vec1.generic[49] = (vec1.generic[49] + vec2.generic[49]);
	vec1.generic[50] = (vec1.generic[50] + vec2.generic[50]);
	vec1.generic[51] = (vec1.generic[51] + vec2.generic[51]);
	vec1.generic[52] = (vec1.generic[52] + vec2.generic[52]);
	vec1.generic[53] = (vec1.generic[53] + vec2.generic[53]);
	vec1.generic[54] = (vec1.generic[54] + vec2.generic[54]);
	vec1.generic[55] = (vec1.generic[55] + vec2.generic[55]);
	vec1.generic[56] = (vec1.generic[56] + vec2.generic[56]);
	vec1.generic[57] = (vec1.generic[57] + vec2.generic[57]);
	vec1.generic[58] = (vec1.generic[58] + vec2.generic[58]);
	vec1.generic[59] = (vec1.generic[59] + vec2.generic[59]);
	vec1.generic[60] = (vec1.generic[60] + vec2.generic[60]);
	vec1.generic[61] = (vec1.generic[61] + vec2.generic[61]);
	vec1.generic[62] = (vec1.generic[62] + vec2.generic[62]);
	vec1.generic[63] = (vec1.generic[63] + vec2.generic[63]);
	return vec1;
}
# define VINT8x64_ADD_DEFINED
#endif
#if !defined(VINT8x64_SUB_DEFINED)
VEC_FUNC_IMPL vint8x64 vint8x64_sub(vint8x64 vec1, vint8x64 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] - vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] - vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] - vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] - vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] - vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] - vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] - vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] - vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] - vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] - vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] - vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] - vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] - vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] - vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] - vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] - vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] - vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] - vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] - vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] - vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] - vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] - vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] - vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] - vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] - vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] - vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] - vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] - vec2.generic[31]);
	vec1.generic[32] = (vec1.generic[32] - vec2.generic[32]);
	vec1.generic[33] = (vec1.generic[33] - vec2.generic[33]);
	vec1.generic[34] = (vec1.generic[34] - vec2.generic[34]);
	vec1.generic[35] = (vec1.generic[35] - vec2.generic[35]);
	vec1.generic[36] = (vec1.generic[36] - vec2.generic[36]);
	vec1.generic[37] = (vec1.generic[37] - vec2.generic[37]);
	vec1.generic[38] = (vec1.generic[38] - vec2.generic[38]);
	vec1.generic[39] = (vec1.generic[39] - vec2.generic[39]);
	vec1.generic[40] = (vec1.generic[40] - vec2.generic[40]);
	vec1.generic[41] = (vec1.generic[41] - vec2.generic[41]);
	vec1.generic[42] = (vec1.generic[42] - vec2.generic[42]);
	vec1.generic[43] = (vec1.generic[43] - vec2.generic[43]);
	vec1.generic[44] = (vec1.generic[44] - vec2.generic[44]);
	vec1.generic[45] = (vec1.generic[45] - vec2.generic[45]);
	vec1.generic[46] = (vec1.generic[46] - vec2.generic[46]);
	vec1.generic[47] = (vec1.generic[47] - vec2.generic[47]);
	vec1.generic[48] = (vec1.generic[48] - vec2.generic[48]);
	vec1.generic[49] = (vec1.generic[49] - vec2.generic[49]);
	vec1.generic[50] = (vec1.generic[50] - vec2.generic[50]);
	vec1.generic[51] = (vec1.generic[51] - vec2.generic[51]);
	vec1.generic[52] = (vec1.generic[52] - vec2.generic[52]);
	vec1.generic[53] = (vec1.generic[53] - vec2.generic[53]);
	vec1.generic[54] = (vec1.generic[54] - vec2.generic[54]);
	vec1.generic[55] = (vec1.generic[55] - vec2.generic[55]);
	vec1.generic[56] = (vec1.generic[56] - vec2.generic[56]);
	vec1.generic[57] = (vec1.generic[57] - vec2.generic[57]);
	vec1.generic[58] = (vec1.generic[58] - vec2.generic[58]);
	vec1.generic[59] = (vec1.generic[59] - vec2.generic[59]);
	vec1.generic[60] = (vec1.generic[60] - vec2.generic[60]);
	vec1.generic[61] = (vec1.generic[61] - vec2.generic[61]);
	vec1.generic[62] = (vec1.generic[62] - vec2.generic[62]);
	vec1.generic[63] = (vec1.generic[63] - vec2.generic[63]);
	return vec1;
}
# define VINT8x64_SUB_DEFINED
#endif
#if !defined(VINT8x64_MUL_DEFINED)
VEC_FUNC_IMPL vint8x64 vint8x64_mul(vint8x64 vec1, vint8x64 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] * vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] * vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] * vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] * vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] * vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] * vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] * vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] * vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] * vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] * vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] * vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] * vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] * vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] * vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] * vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] * vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] * vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] * vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] * vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] * vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] * vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] * vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] * vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] * vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] * vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] * vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] * vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] * vec2.generic[31]);
	vec1.generic[32] = (vec1.generic[32] * vec2.generic[32]);
	vec1.generic[33] = (vec1.generic[33] * vec2.generic[33]);
	vec1.generic[34] = (vec1.generic[34] * vec2.generic[34]);
	vec1.generic[35] = (vec1.generic[35] * vec2.generic[35]);
	vec1.generic[36] = (vec1.generic[36] * vec2.generic[36]);
	vec1.generic[37] = (vec1.generic[37] * vec2.generic[37]);
	vec1.generic[38] = (vec1.generic[38] * vec2.generic[38]);
	vec1.generic[39] = (vec1.generic[39] * vec2.generic[39]);
	vec1.generic[40] = (vec1.generic[40] * vec2.generic[40]);
	vec1.generic[41] = (vec1.generic[41] * vec2.generic[41]);
	vec1.generic[42] = (vec1.generic[42] * vec2.generic[42]);
	vec1.generic[43] = (vec1.generic[43] * vec2.generic[43]);
	vec1.generic[44] = (vec1.generic[44] * vec2.generic[44]);
	vec1.generic[45] = (vec1.generic[45] * vec2.generic[45]);
	vec1.generic[46] = (vec1.generic[46] * vec2.generic[46]);
	vec1.generic[47] = (vec1.generic[47] * vec2.generic[47]);
	vec1.generic[48] = (vec1.generic[48] * vec2.generic[48]);
	vec1.generic[49] = (vec1.generic[49] * vec2.generic[49]);
	vec1.generic[50] = (vec1.generic[50] * vec2.generic[50]);
	vec1.generic[51] = (vec1.generic[51] * vec2.generic[51]);
	vec1.generic[52] = (vec1.generic[52] * vec2.generic[52]);
	vec1.generic[53] = (vec1.generic[53] * vec2.generic[53]);
	vec1.generic[54] = (vec1.generic[54] * vec2.generic[54]);
	vec1.generic[55] = (vec1.generic[55] * vec2.generic[55]);
	vec1.generic[56] = (vec1.generic[56] * vec2.generic[56]);
	vec1.generic[57] = (vec1.generic[57] * vec2.generic[57]);
	vec1.generic[58] = (vec1.generic[58] * vec2.generic[58]);
	vec1.generic[59] = (vec1.generic[59] * vec2.generic[59]);
	vec1.generic[60] = (vec1.generic[60] * vec2.generic[60]);
	vec1.generic[61] = (vec1.generic[61] * vec2.generic[61]);
	vec1.generic[62] = (vec1.generic[62] * vec2.generic[62]);
	vec1.generic[63] = (vec1.generic[63] * vec2.generic[63]);
	return vec1;
}
# define VINT8x64_MUL_DEFINED
#endif
#if !defined(VINT8x64_DIV_DEFINED)
VEC_FUNC_IMPL vint8x64 vint8x64_div(vint8x64 vec1, vint8x64 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] / vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] / vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] / vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] / vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? (vec1.generic[8] / vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? (vec1.generic[9] / vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? (vec1.generic[10] / vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? (vec1.generic[11] / vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? (vec1.generic[12] / vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? (vec1.generic[13] / vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? (vec1.generic[14] / vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? (vec1.generic[15] / vec2.generic[15]) : 0);
	vec1.generic[16] = (vec2.generic[16] ? (vec1.generic[16] / vec2.generic[16]) : 0);
	vec1.generic[17] = (vec2.generic[17] ? (vec1.generic[17] / vec2.generic[17]) : 0);
	vec1.generic[18] = (vec2.generic[18] ? (vec1.generic[18] / vec2.generic[18]) : 0);
	vec1.generic[19] = (vec2.generic[19] ? (vec1.generic[19] / vec2.generic[19]) : 0);
	vec1.generic[20] = (vec2.generic[20] ? (vec1.generic[20] / vec2.generic[20]) : 0);
	vec1.generic[21] = (vec2.generic[21] ? (vec1.generic[21] / vec2.generic[21]) : 0);
	vec1.generic[22] = (vec2.generic[22] ? (vec1.generic[22] / vec2.generic[22]) : 0);
	vec1.generic[23] = (vec2.generic[23] ? (vec1.generic[23] / vec2.generic[23]) : 0);
	vec1.generic[24] = (vec2.generic[24] ? (vec1.generic[24] / vec2.generic[24]) : 0);
	vec1.generic[25] = (vec2.generic[25] ? (vec1.generic[25] / vec2.generic[25]) : 0);
	vec1.generic[26] = (vec2.generic[26] ? (vec1.generic[26] / vec2.generic[26]) : 0);
	vec1.generic[27] = (vec2.generic[27] ? (vec1.generic[27] / vec2.generic[27]) : 0);
	vec1.generic[28] = (vec2.generic[28] ? (vec1.generic[28] / vec2.generic[28]) : 0);
	vec1.generic[29] = (vec2.generic[29] ? (vec1.generic[29] / vec2.generic[29]) : 0);
	vec1.generic[30] = (vec2.generic[30] ? (vec1.generic[30] / vec2.generic[30]) : 0);
	vec1.generic[31] = (vec2.generic[31] ? (vec1.generic[31] / vec2.generic[31]) : 0);
	vec1.generic[32] = (vec2.generic[32] ? (vec1.generic[32] / vec2.generic[32]) : 0);
	vec1.generic[33] = (vec2.generic[33] ? (vec1.generic[33] / vec2.generic[33]) : 0);
	vec1.generic[34] = (vec2.generic[34] ? (vec1.generic[34] / vec2.generic[34]) : 0);
	vec1.generic[35] = (vec2.generic[35] ? (vec1.generic[35] / vec2.generic[35]) : 0);
	vec1.generic[36] = (vec2.generic[36] ? (vec1.generic[36] / vec2.generic[36]) : 0);
	vec1.generic[37] = (vec2.generic[37] ? (vec1.generic[37] / vec2.generic[37]) : 0);
	vec1.generic[38] = (vec2.generic[38] ? (vec1.generic[38] / vec2.generic[38]) : 0);
	vec1.generic[39] = (vec2.generic[39] ? (vec1.generic[39] / vec2.generic[39]) : 0);
	vec1.generic[40] = (vec2.generic[40] ? (vec1.generic[40] / vec2.generic[40]) : 0);
	vec1.generic[41] = (vec2.generic[41] ? (vec1.generic[41] / vec2.generic[41]) : 0);
	vec1.generic[42] = (vec2.generic[42] ? (vec1.generic[42] / vec2.generic[42]) : 0);
	vec1.generic[43] = (vec2.generic[43] ? (vec1.generic[43] / vec2.generic[43]) : 0);
	vec1.generic[44] = (vec2.generic[44] ? (vec1.generic[44] / vec2.generic[44]) : 0);
	vec1.generic[45] = (vec2.generic[45] ? (vec1.generic[45] / vec2.generic[45]) : 0);
	vec1.generic[46] = (vec2.generic[46] ? (vec1.generic[46] / vec2.generic[46]) : 0);
	vec1.generic[47] = (vec2.generic[47] ? (vec1.generic[47] / vec2.generic[47]) : 0);
	vec1.generic[48] = (vec2.generic[48] ? (vec1.generic[48] / vec2.generic[48]) : 0);
	vec1.generic[49] = (vec2.generic[49] ? (vec1.generic[49] / vec2.generic[49]) : 0);
	vec1.generic[50] = (vec2.generic[50] ? (vec1.generic[50] / vec2.generic[50]) : 0);
	vec1.generic[51] = (vec2.generic[51] ? (vec1.generic[51] / vec2.generic[51]) : 0);
	vec1.generic[52] = (vec2.generic[52] ? (vec1.generic[52] / vec2.generic[52]) : 0);
	vec1.generic[53] = (vec2.generic[53] ? (vec1.generic[53] / vec2.generic[53]) : 0);
	vec1.generic[54] = (vec2.generic[54] ? (vec1.generic[54] / vec2.generic[54]) : 0);
	vec1.generic[55] = (vec2.generic[55] ? (vec1.generic[55] / vec2.generic[55]) : 0);
	vec1.generic[56] = (vec2.generic[56] ? (vec1.generic[56] / vec2.generic[56]) : 0);
	vec1.generic[57] = (vec2.generic[57] ? (vec1.generic[57] / vec2.generic[57]) : 0);
	vec1.generic[58] = (vec2.generic[58] ? (vec1.generic[58] / vec2.generic[58]) : 0);
	vec1.generic[59] = (vec2.generic[59] ? (vec1.generic[59] / vec2.generic[59]) : 0);
	vec1.generic[60] = (vec2.generic[60] ? (vec1.generic[60] / vec2.generic[60]) : 0);
	vec1.generic[61] = (vec2.generic[61] ? (vec1.generic[61] / vec2.generic[61]) : 0);
	vec1.generic[62] = (vec2.generic[62] ? (vec1.generic[62] / vec2.generic[62]) : 0);
	vec1.generic[63] = (vec2.generic[63] ? (vec1.generic[63] / vec2.generic[63]) : 0);
	return vec1;
}
# define VINT8x64_DIV_DEFINED
#endif
#if !defined(VINT8x64_MOD_DEFINED)
VEC_FUNC_IMPL vint8x64 vint8x64_mod(vint8x64 vec1, vint8x64 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] % vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] % vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] % vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] % vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? (vec1.generic[8] % vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? (vec1.generic[9] % vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? (vec1.generic[10] % vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? (vec1.generic[11] % vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? (vec1.generic[12] % vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? (vec1.generic[13] % vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? (vec1.generic[14] % vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? (vec1.generic[15] % vec2.generic[15]) : 0);
	vec1.generic[16] = (vec2.generic[16] ? (vec1.generic[16] % vec2.generic[16]) : 0);
	vec1.generic[17] = (vec2.generic[17] ? (vec1.generic[17] % vec2.generic[17]) : 0);
	vec1.generic[18] = (vec2.generic[18] ? (vec1.generic[18] % vec2.generic[18]) : 0);
	vec1.generic[19] = (vec2.generic[19] ? (vec1.generic[19] % vec2.generic[19]) : 0);
	vec1.generic[20] = (vec2.generic[20] ? (vec1.generic[20] % vec2.generic[20]) : 0);
	vec1.generic[21] = (vec2.generic[21] ? (vec1.generic[21] % vec2.generic[21]) : 0);
	vec1.generic[22] = (vec2.generic[22] ? (vec1.generic[22] % vec2.generic[22]) : 0);
	vec1.generic[23] = (vec2.generic[23] ? (vec1.generic[23] % vec2.generic[23]) : 0);
	vec1.generic[24] = (vec2.generic[24] ? (vec1.generic[24] % vec2.generic[24]) : 0);
	vec1.generic[25] = (vec2.generic[25] ? (vec1.generic[25] % vec2.generic[25]) : 0);
	vec1.generic[26] = (vec2.generic[26] ? (vec1.generic[26] % vec2.generic[26]) : 0);
	vec1.generic[27] = (vec2.generic[27] ? (vec1.generic[27] % vec2.generic[27]) : 0);
	vec1.generic[28] = (vec2.generic[28] ? (vec1.generic[28] % vec2.generic[28]) : 0);
	vec1.generic[29] = (vec2.generic[29] ? (vec1.generic[29] % vec2.generic[29]) : 0);
	vec1.generic[30] = (vec2.generic[30] ? (vec1.generic[30] % vec2.generic[30]) : 0);
	vec1.generic[31] = (vec2.generic[31] ? (vec1.generic[31] % vec2.generic[31]) : 0);
	vec1.generic[32] = (vec2.generic[32] ? (vec1.generic[32] % vec2.generic[32]) : 0);
	vec1.generic[33] = (vec2.generic[33] ? (vec1.generic[33] % vec2.generic[33]) : 0);
	vec1.generic[34] = (vec2.generic[34] ? (vec1.generic[34] % vec2.generic[34]) : 0);
	vec1.generic[35] = (vec2.generic[35] ? (vec1.generic[35] % vec2.generic[35]) : 0);
	vec1.generic[36] = (vec2.generic[36] ? (vec1.generic[36] % vec2.generic[36]) : 0);
	vec1.generic[37] = (vec2.generic[37] ? (vec1.generic[37] % vec2.generic[37]) : 0);
	vec1.generic[38] = (vec2.generic[38] ? (vec1.generic[38] % vec2.generic[38]) : 0);
	vec1.generic[39] = (vec2.generic[39] ? (vec1.generic[39] % vec2.generic[39]) : 0);
	vec1.generic[40] = (vec2.generic[40] ? (vec1.generic[40] % vec2.generic[40]) : 0);
	vec1.generic[41] = (vec2.generic[41] ? (vec1.generic[41] % vec2.generic[41]) : 0);
	vec1.generic[42] = (vec2.generic[42] ? (vec1.generic[42] % vec2.generic[42]) : 0);
	vec1.generic[43] = (vec2.generic[43] ? (vec1.generic[43] % vec2.generic[43]) : 0);
	vec1.generic[44] = (vec2.generic[44] ? (vec1.generic[44] % vec2.generic[44]) : 0);
	vec1.generic[45] = (vec2.generic[45] ? (vec1.generic[45] % vec2.generic[45]) : 0);
	vec1.generic[46] = (vec2.generic[46] ? (vec1.generic[46] % vec2.generic[46]) : 0);
	vec1.generic[47] = (vec2.generic[47] ? (vec1.generic[47] % vec2.generic[47]) : 0);
	vec1.generic[48] = (vec2.generic[48] ? (vec1.generic[48] % vec2.generic[48]) : 0);
	vec1.generic[49] = (vec2.generic[49] ? (vec1.generic[49] % vec2.generic[49]) : 0);
	vec1.generic[50] = (vec2.generic[50] ? (vec1.generic[50] % vec2.generic[50]) : 0);
	vec1.generic[51] = (vec2.generic[51] ? (vec1.generic[51] % vec2.generic[51]) : 0);
	vec1.generic[52] = (vec2.generic[52] ? (vec1.generic[52] % vec2.generic[52]) : 0);
	vec1.generic[53] = (vec2.generic[53] ? (vec1.generic[53] % vec2.generic[53]) : 0);
	vec1.generic[54] = (vec2.generic[54] ? (vec1.generic[54] % vec2.generic[54]) : 0);
	vec1.generic[55] = (vec2.generic[55] ? (vec1.generic[55] % vec2.generic[55]) : 0);
	vec1.generic[56] = (vec2.generic[56] ? (vec1.generic[56] % vec2.generic[56]) : 0);
	vec1.generic[57] = (vec2.generic[57] ? (vec1.generic[57] % vec2.generic[57]) : 0);
	vec1.generic[58] = (vec2.generic[58] ? (vec1.generic[58] % vec2.generic[58]) : 0);
	vec1.generic[59] = (vec2.generic[59] ? (vec1.generic[59] % vec2.generic[59]) : 0);
	vec1.generic[60] = (vec2.generic[60] ? (vec1.generic[60] % vec2.generic[60]) : 0);
	vec1.generic[61] = (vec2.generic[61] ? (vec1.generic[61] % vec2.generic[61]) : 0);
	vec1.generic[62] = (vec2.generic[62] ? (vec1.generic[62] % vec2.generic[62]) : 0);
	vec1.generic[63] = (vec2.generic[63] ? (vec1.generic[63] % vec2.generic[63]) : 0);
	return vec1;
}
# define VINT8x64_MOD_DEFINED
#endif
#if !defined(VINT8x64_AVG_DEFINED)
VEC_FUNC_IMPL vint8x64 vint8x64_avg(vint8x64 vec1, vint8x64 vec2)
{
	vec_int8 x_d_rem, y_d_rem, rem_d_quot, rem_d_rem;
	x_d_rem = (vec1.generic[0] % 2);
	y_d_rem = (vec2.generic[0] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[0] = ((vec1.generic[0] / 2) + (vec2.generic[0] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[1] % 2);
	y_d_rem = (vec2.generic[1] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[1] = ((vec1.generic[1] / 2) + (vec2.generic[1] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[2] % 2);
	y_d_rem = (vec2.generic[2] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[2] = ((vec1.generic[2] / 2) + (vec2.generic[2] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[3] % 2);
	y_d_rem = (vec2.generic[3] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[3] = ((vec1.generic[3] / 2) + (vec2.generic[3] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[4] % 2);
	y_d_rem = (vec2.generic[4] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[4] = ((vec1.generic[4] / 2) + (vec2.generic[4] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[5] % 2);
	y_d_rem = (vec2.generic[5] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[5] = ((vec1.generic[5] / 2) + (vec2.generic[5] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[6] % 2);
	y_d_rem = (vec2.generic[6] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[6] = ((vec1.generic[6] / 2) + (vec2.generic[6] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[7] % 2);
	y_d_rem = (vec2.generic[7] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[7] = ((vec1.generic[7] / 2) + (vec2.generic[7] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[8] % 2);
	y_d_rem = (vec2.generic[8] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[8] = ((vec1.generic[8] / 2) + (vec2.generic[8] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[9] % 2);
	y_d_rem = (vec2.generic[9] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[9] = ((vec1.generic[9] / 2) + (vec2.generic[9] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[10] % 2);
	y_d_rem = (vec2.generic[10] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[10] = ((vec1.generic[10] / 2) + (vec2.generic[10] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[11] % 2);
	y_d_rem = (vec2.generic[11] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[11] = ((vec1.generic[11] / 2) + (vec2.generic[11] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[12] % 2);
	y_d_rem = (vec2.generic[12] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[12] = ((vec1.generic[12] / 2) + (vec2.generic[12] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[13] % 2);
	y_d_rem = (vec2.generic[13] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[13] = ((vec1.generic[13] / 2) + (vec2.generic[13] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[14] % 2);
	y_d_rem = (vec2.generic[14] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[14] = ((vec1.generic[14] / 2) + (vec2.generic[14] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[15] % 2);
	y_d_rem = (vec2.generic[15] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[15] = ((vec1.generic[15] / 2) + (vec2.generic[15] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[16] % 2);
	y_d_rem = (vec2.generic[16] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[16] = ((vec1.generic[16] / 2) + (vec2.generic[16] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[17] % 2);
	y_d_rem = (vec2.generic[17] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[17] = ((vec1.generic[17] / 2) + (vec2.generic[17] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[18] % 2);
	y_d_rem = (vec2.generic[18] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[18] = ((vec1.generic[18] / 2) + (vec2.generic[18] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[19] % 2);
	y_d_rem = (vec2.generic[19] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[19] = ((vec1.generic[19] / 2) + (vec2.generic[19] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[20] % 2);
	y_d_rem = (vec2.generic[20] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[20] = ((vec1.generic[20] / 2) + (vec2.generic[20] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[21] % 2);
	y_d_rem = (vec2.generic[21] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[21] = ((vec1.generic[21] / 2) + (vec2.generic[21] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[22] % 2);
	y_d_rem = (vec2.generic[22] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[22] = ((vec1.generic[22] / 2) + (vec2.generic[22] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[23] % 2);
	y_d_rem = (vec2.generic[23] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[23] = ((vec1.generic[23] / 2) + (vec2.generic[23] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[24] % 2);
	y_d_rem = (vec2.generic[24] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[24] = ((vec1.generic[24] / 2) + (vec2.generic[24] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[25] % 2);
	y_d_rem = (vec2.generic[25] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[25] = ((vec1.generic[25] / 2) + (vec2.generic[25] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[26] % 2);
	y_d_rem = (vec2.generic[26] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[26] = ((vec1.generic[26] / 2) + (vec2.generic[26] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[27] % 2);
	y_d_rem = (vec2.generic[27] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[27] = ((vec1.generic[27] / 2) + (vec2.generic[27] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[28] % 2);
	y_d_rem = (vec2.generic[28] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[28] = ((vec1.generic[28] / 2) + (vec2.generic[28] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[29] % 2);
	y_d_rem = (vec2.generic[29] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[29] = ((vec1.generic[29] / 2) + (vec2.generic[29] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[30] % 2);
	y_d_rem = (vec2.generic[30] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[30] = ((vec1.generic[30] / 2) + (vec2.generic[30] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[31] % 2);
	y_d_rem = (vec2.generic[31] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[31] = ((vec1.generic[31] / 2) + (vec2.generic[31] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[32] % 2);
	y_d_rem = (vec2.generic[32] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[32] = ((vec1.generic[32] / 2) + (vec2.generic[32] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[33] % 2);
	y_d_rem = (vec2.generic[33] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[33] = ((vec1.generic[33] / 2) + (vec2.generic[33] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[34] % 2);
	y_d_rem = (vec2.generic[34] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[34] = ((vec1.generic[34] / 2) + (vec2.generic[34] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[35] % 2);
	y_d_rem = (vec2.generic[35] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[35] = ((vec1.generic[35] / 2) + (vec2.generic[35] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[36] % 2);
	y_d_rem = (vec2.generic[36] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[36] = ((vec1.generic[36] / 2) + (vec2.generic[36] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[37] % 2);
	y_d_rem = (vec2.generic[37] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[37] = ((vec1.generic[37] / 2) + (vec2.generic[37] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[38] % 2);
	y_d_rem = (vec2.generic[38] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[38] = ((vec1.generic[38] / 2) + (vec2.generic[38] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[39] % 2);
	y_d_rem = (vec2.generic[39] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[39] = ((vec1.generic[39] / 2) + (vec2.generic[39] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[40] % 2);
	y_d_rem = (vec2.generic[40] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[40] = ((vec1.generic[40] / 2) + (vec2.generic[40] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[41] % 2);
	y_d_rem = (vec2.generic[41] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[41] = ((vec1.generic[41] / 2) + (vec2.generic[41] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[42] % 2);
	y_d_rem = (vec2.generic[42] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[42] = ((vec1.generic[42] / 2) + (vec2.generic[42] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[43] % 2);
	y_d_rem = (vec2.generic[43] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[43] = ((vec1.generic[43] / 2) + (vec2.generic[43] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[44] % 2);
	y_d_rem = (vec2.generic[44] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[44] = ((vec1.generic[44] / 2) + (vec2.generic[44] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[45] % 2);
	y_d_rem = (vec2.generic[45] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[45] = ((vec1.generic[45] / 2) + (vec2.generic[45] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[46] % 2);
	y_d_rem = (vec2.generic[46] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[46] = ((vec1.generic[46] / 2) + (vec2.generic[46] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[47] % 2);
	y_d_rem = (vec2.generic[47] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[47] = ((vec1.generic[47] / 2) + (vec2.generic[47] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[48] % 2);
	y_d_rem = (vec2.generic[48] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[48] = ((vec1.generic[48] / 2) + (vec2.generic[48] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[49] % 2);
	y_d_rem = (vec2.generic[49] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[49] = ((vec1.generic[49] / 2) + (vec2.generic[49] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[50] % 2);
	y_d_rem = (vec2.generic[50] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[50] = ((vec1.generic[50] / 2) + (vec2.generic[50] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[51] % 2);
	y_d_rem = (vec2.generic[51] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[51] = ((vec1.generic[51] / 2) + (vec2.generic[51] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[52] % 2);
	y_d_rem = (vec2.generic[52] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[52] = ((vec1.generic[52] / 2) + (vec2.generic[52] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[53] % 2);
	y_d_rem = (vec2.generic[53] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[53] = ((vec1.generic[53] / 2) + (vec2.generic[53] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[54] % 2);
	y_d_rem = (vec2.generic[54] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[54] = ((vec1.generic[54] / 2) + (vec2.generic[54] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[55] % 2);
	y_d_rem = (vec2.generic[55] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[55] = ((vec1.generic[55] / 2) + (vec2.generic[55] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[56] % 2);
	y_d_rem = (vec2.generic[56] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[56] = ((vec1.generic[56] / 2) + (vec2.generic[56] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[57] % 2);
	y_d_rem = (vec2.generic[57] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[57] = ((vec1.generic[57] / 2) + (vec2.generic[57] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[58] % 2);
	y_d_rem = (vec2.generic[58] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[58] = ((vec1.generic[58] / 2) + (vec2.generic[58] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[59] % 2);
	y_d_rem = (vec2.generic[59] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[59] = ((vec1.generic[59] / 2) + (vec2.generic[59] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[60] % 2);
	y_d_rem = (vec2.generic[60] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[60] = ((vec1.generic[60] / 2) + (vec2.generic[60] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[61] % 2);
	y_d_rem = (vec2.generic[61] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[61] = ((vec1.generic[61] / 2) + (vec2.generic[61] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[62] % 2);
	y_d_rem = (vec2.generic[62] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[62] = ((vec1.generic[62] / 2) + (vec2.generic[62] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[63] % 2);
	y_d_rem = (vec2.generic[63] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[63] = ((vec1.generic[63] / 2) + (vec2.generic[63] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	return vec1;
}
# define VINT8x64_AVG_DEFINED
#endif
#if !defined(VINT8x64_AND_DEFINED)
VEC_FUNC_IMPL vint8x64 vint8x64_and(vint8x64 vec1, vint8x64 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] & vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] & vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] & vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] & vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] & vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] & vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] & vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] & vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] & vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] & vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] & vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] & vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] & vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] & vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] & vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] & vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] & vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] & vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] & vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] & vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] & vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] & vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] & vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] & vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] & vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] & vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] & vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] & vec2.generic[31]);
	vec1.generic[32] = (vec1.generic[32] & vec2.generic[32]);
	vec1.generic[33] = (vec1.generic[33] & vec2.generic[33]);
	vec1.generic[34] = (vec1.generic[34] & vec2.generic[34]);
	vec1.generic[35] = (vec1.generic[35] & vec2.generic[35]);
	vec1.generic[36] = (vec1.generic[36] & vec2.generic[36]);
	vec1.generic[37] = (vec1.generic[37] & vec2.generic[37]);
	vec1.generic[38] = (vec1.generic[38] & vec2.generic[38]);
	vec1.generic[39] = (vec1.generic[39] & vec2.generic[39]);
	vec1.generic[40] = (vec1.generic[40] & vec2.generic[40]);
	vec1.generic[41] = (vec1.generic[41] & vec2.generic[41]);
	vec1.generic[42] = (vec1.generic[42] & vec2.generic[42]);
	vec1.generic[43] = (vec1.generic[43] & vec2.generic[43]);
	vec1.generic[44] = (vec1.generic[44] & vec2.generic[44]);
	vec1.generic[45] = (vec1.generic[45] & vec2.generic[45]);
	vec1.generic[46] = (vec1.generic[46] & vec2.generic[46]);
	vec1.generic[47] = (vec1.generic[47] & vec2.generic[47]);
	vec1.generic[48] = (vec1.generic[48] & vec2.generic[48]);
	vec1.generic[49] = (vec1.generic[49] & vec2.generic[49]);
	vec1.generic[50] = (vec1.generic[50] & vec2.generic[50]);
	vec1.generic[51] = (vec1.generic[51] & vec2.generic[51]);
	vec1.generic[52] = (vec1.generic[52] & vec2.generic[52]);
	vec1.generic[53] = (vec1.generic[53] & vec2.generic[53]);
	vec1.generic[54] = (vec1.generic[54] & vec2.generic[54]);
	vec1.generic[55] = (vec1.generic[55] & vec2.generic[55]);
	vec1.generic[56] = (vec1.generic[56] & vec2.generic[56]);
	vec1.generic[57] = (vec1.generic[57] & vec2.generic[57]);
	vec1.generic[58] = (vec1.generic[58] & vec2.generic[58]);
	vec1.generic[59] = (vec1.generic[59] & vec2.generic[59]);
	vec1.generic[60] = (vec1.generic[60] & vec2.generic[60]);
	vec1.generic[61] = (vec1.generic[61] & vec2.generic[61]);
	vec1.generic[62] = (vec1.generic[62] & vec2.generic[62]);
	vec1.generic[63] = (vec1.generic[63] & vec2.generic[63]);
	return vec1;
}
# define VINT8x64_AND_DEFINED
#endif
#if !defined(VINT8x64_OR_DEFINED)
VEC_FUNC_IMPL vint8x64 vint8x64_or(vint8x64 vec1, vint8x64 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] | vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] | vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] | vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] | vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] | vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] | vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] | vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] | vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] | vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] | vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] | vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] | vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] | vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] | vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] | vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] | vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] | vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] | vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] | vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] | vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] | vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] | vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] | vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] | vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] | vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] | vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] | vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] | vec2.generic[31]);
	vec1.generic[32] = (vec1.generic[32] | vec2.generic[32]);
	vec1.generic[33] = (vec1.generic[33] | vec2.generic[33]);
	vec1.generic[34] = (vec1.generic[34] | vec2.generic[34]);
	vec1.generic[35] = (vec1.generic[35] | vec2.generic[35]);
	vec1.generic[36] = (vec1.generic[36] | vec2.generic[36]);
	vec1.generic[37] = (vec1.generic[37] | vec2.generic[37]);
	vec1.generic[38] = (vec1.generic[38] | vec2.generic[38]);
	vec1.generic[39] = (vec1.generic[39] | vec2.generic[39]);
	vec1.generic[40] = (vec1.generic[40] | vec2.generic[40]);
	vec1.generic[41] = (vec1.generic[41] | vec2.generic[41]);
	vec1.generic[42] = (vec1.generic[42] | vec2.generic[42]);
	vec1.generic[43] = (vec1.generic[43] | vec2.generic[43]);
	vec1.generic[44] = (vec1.generic[44] | vec2.generic[44]);
	vec1.generic[45] = (vec1.generic[45] | vec2.generic[45]);
	vec1.generic[46] = (vec1.generic[46] | vec2.generic[46]);
	vec1.generic[47] = (vec1.generic[47] | vec2.generic[47]);
	vec1.generic[48] = (vec1.generic[48] | vec2.generic[48]);
	vec1.generic[49] = (vec1.generic[49] | vec2.generic[49]);
	vec1.generic[50] = (vec1.generic[50] | vec2.generic[50]);
	vec1.generic[51] = (vec1.generic[51] | vec2.generic[51]);
	vec1.generic[52] = (vec1.generic[52] | vec2.generic[52]);
	vec1.generic[53] = (vec1.generic[53] | vec2.generic[53]);
	vec1.generic[54] = (vec1.generic[54] | vec2.generic[54]);
	vec1.generic[55] = (vec1.generic[55] | vec2.generic[55]);
	vec1.generic[56] = (vec1.generic[56] | vec2.generic[56]);
	vec1.generic[57] = (vec1.generic[57] | vec2.generic[57]);
	vec1.generic[58] = (vec1.generic[58] | vec2.generic[58]);
	vec1.generic[59] = (vec1.generic[59] | vec2.generic[59]);
	vec1.generic[60] = (vec1.generic[60] | vec2.generic[60]);
	vec1.generic[61] = (vec1.generic[61] | vec2.generic[61]);
	vec1.generic[62] = (vec1.generic[62] | vec2.generic[62]);
	vec1.generic[63] = (vec1.generic[63] | vec2.generic[63]);
	return vec1;
}
# define VINT8x64_OR_DEFINED
#endif
#if !defined(VINT8x64_XOR_DEFINED)
VEC_FUNC_IMPL vint8x64 vint8x64_xor(vint8x64 vec1, vint8x64 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] ^ vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] ^ vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] ^ vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] ^ vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] ^ vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] ^ vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] ^ vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] ^ vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] ^ vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] ^ vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] ^ vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] ^ vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] ^ vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] ^ vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] ^ vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] ^ vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] ^ vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] ^ vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] ^ vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] ^ vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] ^ vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] ^ vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] ^ vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] ^ vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] ^ vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] ^ vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] ^ vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] ^ vec2.generic[31]);
	vec1.generic[32] = (vec1.generic[32] ^ vec2.generic[32]);
	vec1.generic[33] = (vec1.generic[33] ^ vec2.generic[33]);
	vec1.generic[34] = (vec1.generic[34] ^ vec2.generic[34]);
	vec1.generic[35] = (vec1.generic[35] ^ vec2.generic[35]);
	vec1.generic[36] = (vec1.generic[36] ^ vec2.generic[36]);
	vec1.generic[37] = (vec1.generic[37] ^ vec2.generic[37]);
	vec1.generic[38] = (vec1.generic[38] ^ vec2.generic[38]);
	vec1.generic[39] = (vec1.generic[39] ^ vec2.generic[39]);
	vec1.generic[40] = (vec1.generic[40] ^ vec2.generic[40]);
	vec1.generic[41] = (vec1.generic[41] ^ vec2.generic[41]);
	vec1.generic[42] = (vec1.generic[42] ^ vec2.generic[42]);
	vec1.generic[43] = (vec1.generic[43] ^ vec2.generic[43]);
	vec1.generic[44] = (vec1.generic[44] ^ vec2.generic[44]);
	vec1.generic[45] = (vec1.generic[45] ^ vec2.generic[45]);
	vec1.generic[46] = (vec1.generic[46] ^ vec2.generic[46]);
	vec1.generic[47] = (vec1.generic[47] ^ vec2.generic[47]);
	vec1.generic[48] = (vec1.generic[48] ^ vec2.generic[48]);
	vec1.generic[49] = (vec1.generic[49] ^ vec2.generic[49]);
	vec1.generic[50] = (vec1.generic[50] ^ vec2.generic[50]);
	vec1.generic[51] = (vec1.generic[51] ^ vec2.generic[51]);
	vec1.generic[52] = (vec1.generic[52] ^ vec2.generic[52]);
	vec1.generic[53] = (vec1.generic[53] ^ vec2.generic[53]);
	vec1.generic[54] = (vec1.generic[54] ^ vec2.generic[54]);
	vec1.generic[55] = (vec1.generic[55] ^ vec2.generic[55]);
	vec1.generic[56] = (vec1.generic[56] ^ vec2.generic[56]);
	vec1.generic[57] = (vec1.generic[57] ^ vec2.generic[57]);
	vec1.generic[58] = (vec1.generic[58] ^ vec2.generic[58]);
	vec1.generic[59] = (vec1.generic[59] ^ vec2.generic[59]);
	vec1.generic[60] = (vec1.generic[60] ^ vec2.generic[60]);
	vec1.generic[61] = (vec1.generic[61] ^ vec2.generic[61]);
	vec1.generic[62] = (vec1.generic[62] ^ vec2.generic[62]);
	vec1.generic[63] = (vec1.generic[63] ^ vec2.generic[63]);
	return vec1;
}
# define VINT8x64_XOR_DEFINED
#endif
#if !defined(VINT8x64_NOT_DEFINED)
VEC_FUNC_IMPL vint8x64 vint8x64_not(vint8x64 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	vec.generic[4] = ~vec.generic[4];
	vec.generic[5] = ~vec.generic[5];
	vec.generic[6] = ~vec.generic[6];
	vec.generic[7] = ~vec.generic[7];
	vec.generic[8] = ~vec.generic[8];
	vec.generic[9] = ~vec.generic[9];
	vec.generic[10] = ~vec.generic[10];
	vec.generic[11] = ~vec.generic[11];
	vec.generic[12] = ~vec.generic[12];
	vec.generic[13] = ~vec.generic[13];
	vec.generic[14] = ~vec.generic[14];
	vec.generic[15] = ~vec.generic[15];
	vec.generic[16] = ~vec.generic[16];
	vec.generic[17] = ~vec.generic[17];
	vec.generic[18] = ~vec.generic[18];
	vec.generic[19] = ~vec.generic[19];
	vec.generic[20] = ~vec.generic[20];
	vec.generic[21] = ~vec.generic[21];
	vec.generic[22] = ~vec.generic[22];
	vec.generic[23] = ~vec.generic[23];
	vec.generic[24] = ~vec.generic[24];
	vec.generic[25] = ~vec.generic[25];
	vec.generic[26] = ~vec.generic[26];
	vec.generic[27] = ~vec.generic[27];
	vec.generic[28] = ~vec.generic[28];
	vec.generic[29] = ~vec.generic[29];
	vec.generic[30] = ~vec.generic[30];
	vec.generic[31] = ~vec.generic[31];
	vec.generic[32] = ~vec.generic[32];
	vec.generic[33] = ~vec.generic[33];
	vec.generic[34] = ~vec.generic[34];
	vec.generic[35] = ~vec.generic[35];
	vec.generic[36] = ~vec.generic[36];
	vec.generic[37] = ~vec.generic[37];
	vec.generic[38] = ~vec.generic[38];
	vec.generic[39] = ~vec.generic[39];
	vec.generic[40] = ~vec.generic[40];
	vec.generic[41] = ~vec.generic[41];
	vec.generic[42] = ~vec.generic[42];
	vec.generic[43] = ~vec.generic[43];
	vec.generic[44] = ~vec.generic[44];
	vec.generic[45] = ~vec.generic[45];
	vec.generic[46] = ~vec.generic[46];
	vec.generic[47] = ~vec.generic[47];
	vec.generic[48] = ~vec.generic[48];
	vec.generic[49] = ~vec.generic[49];
	vec.generic[50] = ~vec.generic[50];
	vec.generic[51] = ~vec.generic[51];
	vec.generic[52] = ~vec.generic[52];
	vec.generic[53] = ~vec.generic[53];
	vec.generic[54] = ~vec.generic[54];
	vec.generic[55] = ~vec.generic[55];
	vec.generic[56] = ~vec.generic[56];
	vec.generic[57] = ~vec.generic[57];
	vec.generic[58] = ~vec.generic[58];
	vec.generic[59] = ~vec.generic[59];
	vec.generic[60] = ~vec.generic[60];
	vec.generic[61] = ~vec.generic[61];
	vec.generic[62] = ~vec.generic[62];
	vec.generic[63] = ~vec.generic[63];
	return vec;
}
# define VINT8x64_NOT_DEFINED
#endif
#if !defined(VINT8x64_CMPLT_DEFINED)
VEC_FUNC_IMPL vint8x64 vint8x64_cmplt(vint8x64 vec1, vint8x64 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] < vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] < vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] < vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] < vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] < vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] < vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] < vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] < vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] < vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] < vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] < vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] < vec2.generic[15]) ? 0xFF : 0, 1);
	memset(&vec1.generic[16], (vec1.generic[16] < vec2.generic[16]) ? 0xFF : 0, 1);
	memset(&vec1.generic[17], (vec1.generic[17] < vec2.generic[17]) ? 0xFF : 0, 1);
	memset(&vec1.generic[18], (vec1.generic[18] < vec2.generic[18]) ? 0xFF : 0, 1);
	memset(&vec1.generic[19], (vec1.generic[19] < vec2.generic[19]) ? 0xFF : 0, 1);
	memset(&vec1.generic[20], (vec1.generic[20] < vec2.generic[20]) ? 0xFF : 0, 1);
	memset(&vec1.generic[21], (vec1.generic[21] < vec2.generic[21]) ? 0xFF : 0, 1);
	memset(&vec1.generic[22], (vec1.generic[22] < vec2.generic[22]) ? 0xFF : 0, 1);
	memset(&vec1.generic[23], (vec1.generic[23] < vec2.generic[23]) ? 0xFF : 0, 1);
	memset(&vec1.generic[24], (vec1.generic[24] < vec2.generic[24]) ? 0xFF : 0, 1);
	memset(&vec1.generic[25], (vec1.generic[25] < vec2.generic[25]) ? 0xFF : 0, 1);
	memset(&vec1.generic[26], (vec1.generic[26] < vec2.generic[26]) ? 0xFF : 0, 1);
	memset(&vec1.generic[27], (vec1.generic[27] < vec2.generic[27]) ? 0xFF : 0, 1);
	memset(&vec1.generic[28], (vec1.generic[28] < vec2.generic[28]) ? 0xFF : 0, 1);
	memset(&vec1.generic[29], (vec1.generic[29] < vec2.generic[29]) ? 0xFF : 0, 1);
	memset(&vec1.generic[30], (vec1.generic[30] < vec2.generic[30]) ? 0xFF : 0, 1);
	memset(&vec1.generic[31], (vec1.generic[31] < vec2.generic[31]) ? 0xFF : 0, 1);
	memset(&vec1.generic[32], (vec1.generic[32] < vec2.generic[32]) ? 0xFF : 0, 1);
	memset(&vec1.generic[33], (vec1.generic[33] < vec2.generic[33]) ? 0xFF : 0, 1);
	memset(&vec1.generic[34], (vec1.generic[34] < vec2.generic[34]) ? 0xFF : 0, 1);
	memset(&vec1.generic[35], (vec1.generic[35] < vec2.generic[35]) ? 0xFF : 0, 1);
	memset(&vec1.generic[36], (vec1.generic[36] < vec2.generic[36]) ? 0xFF : 0, 1);
	memset(&vec1.generic[37], (vec1.generic[37] < vec2.generic[37]) ? 0xFF : 0, 1);
	memset(&vec1.generic[38], (vec1.generic[38] < vec2.generic[38]) ? 0xFF : 0, 1);
	memset(&vec1.generic[39], (vec1.generic[39] < vec2.generic[39]) ? 0xFF : 0, 1);
	memset(&vec1.generic[40], (vec1.generic[40] < vec2.generic[40]) ? 0xFF : 0, 1);
	memset(&vec1.generic[41], (vec1.generic[41] < vec2.generic[41]) ? 0xFF : 0, 1);
	memset(&vec1.generic[42], (vec1.generic[42] < vec2.generic[42]) ? 0xFF : 0, 1);
	memset(&vec1.generic[43], (vec1.generic[43] < vec2.generic[43]) ? 0xFF : 0, 1);
	memset(&vec1.generic[44], (vec1.generic[44] < vec2.generic[44]) ? 0xFF : 0, 1);
	memset(&vec1.generic[45], (vec1.generic[45] < vec2.generic[45]) ? 0xFF : 0, 1);
	memset(&vec1.generic[46], (vec1.generic[46] < vec2.generic[46]) ? 0xFF : 0, 1);
	memset(&vec1.generic[47], (vec1.generic[47] < vec2.generic[47]) ? 0xFF : 0, 1);
	memset(&vec1.generic[48], (vec1.generic[48] < vec2.generic[48]) ? 0xFF : 0, 1);
	memset(&vec1.generic[49], (vec1.generic[49] < vec2.generic[49]) ? 0xFF : 0, 1);
	memset(&vec1.generic[50], (vec1.generic[50] < vec2.generic[50]) ? 0xFF : 0, 1);
	memset(&vec1.generic[51], (vec1.generic[51] < vec2.generic[51]) ? 0xFF : 0, 1);
	memset(&vec1.generic[52], (vec1.generic[52] < vec2.generic[52]) ? 0xFF : 0, 1);
	memset(&vec1.generic[53], (vec1.generic[53] < vec2.generic[53]) ? 0xFF : 0, 1);
	memset(&vec1.generic[54], (vec1.generic[54] < vec2.generic[54]) ? 0xFF : 0, 1);
	memset(&vec1.generic[55], (vec1.generic[55] < vec2.generic[55]) ? 0xFF : 0, 1);
	memset(&vec1.generic[56], (vec1.generic[56] < vec2.generic[56]) ? 0xFF : 0, 1);
	memset(&vec1.generic[57], (vec1.generic[57] < vec2.generic[57]) ? 0xFF : 0, 1);
	memset(&vec1.generic[58], (vec1.generic[58] < vec2.generic[58]) ? 0xFF : 0, 1);
	memset(&vec1.generic[59], (vec1.generic[59] < vec2.generic[59]) ? 0xFF : 0, 1);
	memset(&vec1.generic[60], (vec1.generic[60] < vec2.generic[60]) ? 0xFF : 0, 1);
	memset(&vec1.generic[61], (vec1.generic[61] < vec2.generic[61]) ? 0xFF : 0, 1);
	memset(&vec1.generic[62], (vec1.generic[62] < vec2.generic[62]) ? 0xFF : 0, 1);
	memset(&vec1.generic[63], (vec1.generic[63] < vec2.generic[63]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x64_CMPLT_DEFINED
#endif
#if !defined(VINT8x64_CMPEQ_DEFINED)
VEC_FUNC_IMPL vint8x64 vint8x64_cmpeq(vint8x64 vec1, vint8x64 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] == vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] == vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] == vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] == vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] == vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] == vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] == vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] == vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] == vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] == vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] == vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] == vec2.generic[15]) ? 0xFF : 0, 1);
	memset(&vec1.generic[16], (vec1.generic[16] == vec2.generic[16]) ? 0xFF : 0, 1);
	memset(&vec1.generic[17], (vec1.generic[17] == vec2.generic[17]) ? 0xFF : 0, 1);
	memset(&vec1.generic[18], (vec1.generic[18] == vec2.generic[18]) ? 0xFF : 0, 1);
	memset(&vec1.generic[19], (vec1.generic[19] == vec2.generic[19]) ? 0xFF : 0, 1);
	memset(&vec1.generic[20], (vec1.generic[20] == vec2.generic[20]) ? 0xFF : 0, 1);
	memset(&vec1.generic[21], (vec1.generic[21] == vec2.generic[21]) ? 0xFF : 0, 1);
	memset(&vec1.generic[22], (vec1.generic[22] == vec2.generic[22]) ? 0xFF : 0, 1);
	memset(&vec1.generic[23], (vec1.generic[23] == vec2.generic[23]) ? 0xFF : 0, 1);
	memset(&vec1.generic[24], (vec1.generic[24] == vec2.generic[24]) ? 0xFF : 0, 1);
	memset(&vec1.generic[25], (vec1.generic[25] == vec2.generic[25]) ? 0xFF : 0, 1);
	memset(&vec1.generic[26], (vec1.generic[26] == vec2.generic[26]) ? 0xFF : 0, 1);
	memset(&vec1.generic[27], (vec1.generic[27] == vec2.generic[27]) ? 0xFF : 0, 1);
	memset(&vec1.generic[28], (vec1.generic[28] == vec2.generic[28]) ? 0xFF : 0, 1);
	memset(&vec1.generic[29], (vec1.generic[29] == vec2.generic[29]) ? 0xFF : 0, 1);
	memset(&vec1.generic[30], (vec1.generic[30] == vec2.generic[30]) ? 0xFF : 0, 1);
	memset(&vec1.generic[31], (vec1.generic[31] == vec2.generic[31]) ? 0xFF : 0, 1);
	memset(&vec1.generic[32], (vec1.generic[32] == vec2.generic[32]) ? 0xFF : 0, 1);
	memset(&vec1.generic[33], (vec1.generic[33] == vec2.generic[33]) ? 0xFF : 0, 1);
	memset(&vec1.generic[34], (vec1.generic[34] == vec2.generic[34]) ? 0xFF : 0, 1);
	memset(&vec1.generic[35], (vec1.generic[35] == vec2.generic[35]) ? 0xFF : 0, 1);
	memset(&vec1.generic[36], (vec1.generic[36] == vec2.generic[36]) ? 0xFF : 0, 1);
	memset(&vec1.generic[37], (vec1.generic[37] == vec2.generic[37]) ? 0xFF : 0, 1);
	memset(&vec1.generic[38], (vec1.generic[38] == vec2.generic[38]) ? 0xFF : 0, 1);
	memset(&vec1.generic[39], (vec1.generic[39] == vec2.generic[39]) ? 0xFF : 0, 1);
	memset(&vec1.generic[40], (vec1.generic[40] == vec2.generic[40]) ? 0xFF : 0, 1);
	memset(&vec1.generic[41], (vec1.generic[41] == vec2.generic[41]) ? 0xFF : 0, 1);
	memset(&vec1.generic[42], (vec1.generic[42] == vec2.generic[42]) ? 0xFF : 0, 1);
	memset(&vec1.generic[43], (vec1.generic[43] == vec2.generic[43]) ? 0xFF : 0, 1);
	memset(&vec1.generic[44], (vec1.generic[44] == vec2.generic[44]) ? 0xFF : 0, 1);
	memset(&vec1.generic[45], (vec1.generic[45] == vec2.generic[45]) ? 0xFF : 0, 1);
	memset(&vec1.generic[46], (vec1.generic[46] == vec2.generic[46]) ? 0xFF : 0, 1);
	memset(&vec1.generic[47], (vec1.generic[47] == vec2.generic[47]) ? 0xFF : 0, 1);
	memset(&vec1.generic[48], (vec1.generic[48] == vec2.generic[48]) ? 0xFF : 0, 1);
	memset(&vec1.generic[49], (vec1.generic[49] == vec2.generic[49]) ? 0xFF : 0, 1);
	memset(&vec1.generic[50], (vec1.generic[50] == vec2.generic[50]) ? 0xFF : 0, 1);
	memset(&vec1.generic[51], (vec1.generic[51] == vec2.generic[51]) ? 0xFF : 0, 1);
	memset(&vec1.generic[52], (vec1.generic[52] == vec2.generic[52]) ? 0xFF : 0, 1);
	memset(&vec1.generic[53], (vec1.generic[53] == vec2.generic[53]) ? 0xFF : 0, 1);
	memset(&vec1.generic[54], (vec1.generic[54] == vec2.generic[54]) ? 0xFF : 0, 1);
	memset(&vec1.generic[55], (vec1.generic[55] == vec2.generic[55]) ? 0xFF : 0, 1);
	memset(&vec1.generic[56], (vec1.generic[56] == vec2.generic[56]) ? 0xFF : 0, 1);
	memset(&vec1.generic[57], (vec1.generic[57] == vec2.generic[57]) ? 0xFF : 0, 1);
	memset(&vec1.generic[58], (vec1.generic[58] == vec2.generic[58]) ? 0xFF : 0, 1);
	memset(&vec1.generic[59], (vec1.generic[59] == vec2.generic[59]) ? 0xFF : 0, 1);
	memset(&vec1.generic[60], (vec1.generic[60] == vec2.generic[60]) ? 0xFF : 0, 1);
	memset(&vec1.generic[61], (vec1.generic[61] == vec2.generic[61]) ? 0xFF : 0, 1);
	memset(&vec1.generic[62], (vec1.generic[62] == vec2.generic[62]) ? 0xFF : 0, 1);
	memset(&vec1.generic[63], (vec1.generic[63] == vec2.generic[63]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x64_CMPEQ_DEFINED
#endif
#if !defined(VINT8x64_CMPGT_DEFINED)
VEC_FUNC_IMPL vint8x64 vint8x64_cmpgt(vint8x64 vec1, vint8x64 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] > vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] > vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] > vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] > vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] > vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] > vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] > vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] > vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] > vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] > vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] > vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] > vec2.generic[15]) ? 0xFF : 0, 1);
	memset(&vec1.generic[16], (vec1.generic[16] > vec2.generic[16]) ? 0xFF : 0, 1);
	memset(&vec1.generic[17], (vec1.generic[17] > vec2.generic[17]) ? 0xFF : 0, 1);
	memset(&vec1.generic[18], (vec1.generic[18] > vec2.generic[18]) ? 0xFF : 0, 1);
	memset(&vec1.generic[19], (vec1.generic[19] > vec2.generic[19]) ? 0xFF : 0, 1);
	memset(&vec1.generic[20], (vec1.generic[20] > vec2.generic[20]) ? 0xFF : 0, 1);
	memset(&vec1.generic[21], (vec1.generic[21] > vec2.generic[21]) ? 0xFF : 0, 1);
	memset(&vec1.generic[22], (vec1.generic[22] > vec2.generic[22]) ? 0xFF : 0, 1);
	memset(&vec1.generic[23], (vec1.generic[23] > vec2.generic[23]) ? 0xFF : 0, 1);
	memset(&vec1.generic[24], (vec1.generic[24] > vec2.generic[24]) ? 0xFF : 0, 1);
	memset(&vec1.generic[25], (vec1.generic[25] > vec2.generic[25]) ? 0xFF : 0, 1);
	memset(&vec1.generic[26], (vec1.generic[26] > vec2.generic[26]) ? 0xFF : 0, 1);
	memset(&vec1.generic[27], (vec1.generic[27] > vec2.generic[27]) ? 0xFF : 0, 1);
	memset(&vec1.generic[28], (vec1.generic[28] > vec2.generic[28]) ? 0xFF : 0, 1);
	memset(&vec1.generic[29], (vec1.generic[29] > vec2.generic[29]) ? 0xFF : 0, 1);
	memset(&vec1.generic[30], (vec1.generic[30] > vec2.generic[30]) ? 0xFF : 0, 1);
	memset(&vec1.generic[31], (vec1.generic[31] > vec2.generic[31]) ? 0xFF : 0, 1);
	memset(&vec1.generic[32], (vec1.generic[32] > vec2.generic[32]) ? 0xFF : 0, 1);
	memset(&vec1.generic[33], (vec1.generic[33] > vec2.generic[33]) ? 0xFF : 0, 1);
	memset(&vec1.generic[34], (vec1.generic[34] > vec2.generic[34]) ? 0xFF : 0, 1);
	memset(&vec1.generic[35], (vec1.generic[35] > vec2.generic[35]) ? 0xFF : 0, 1);
	memset(&vec1.generic[36], (vec1.generic[36] > vec2.generic[36]) ? 0xFF : 0, 1);
	memset(&vec1.generic[37], (vec1.generic[37] > vec2.generic[37]) ? 0xFF : 0, 1);
	memset(&vec1.generic[38], (vec1.generic[38] > vec2.generic[38]) ? 0xFF : 0, 1);
	memset(&vec1.generic[39], (vec1.generic[39] > vec2.generic[39]) ? 0xFF : 0, 1);
	memset(&vec1.generic[40], (vec1.generic[40] > vec2.generic[40]) ? 0xFF : 0, 1);
	memset(&vec1.generic[41], (vec1.generic[41] > vec2.generic[41]) ? 0xFF : 0, 1);
	memset(&vec1.generic[42], (vec1.generic[42] > vec2.generic[42]) ? 0xFF : 0, 1);
	memset(&vec1.generic[43], (vec1.generic[43] > vec2.generic[43]) ? 0xFF : 0, 1);
	memset(&vec1.generic[44], (vec1.generic[44] > vec2.generic[44]) ? 0xFF : 0, 1);
	memset(&vec1.generic[45], (vec1.generic[45] > vec2.generic[45]) ? 0xFF : 0, 1);
	memset(&vec1.generic[46], (vec1.generic[46] > vec2.generic[46]) ? 0xFF : 0, 1);
	memset(&vec1.generic[47], (vec1.generic[47] > vec2.generic[47]) ? 0xFF : 0, 1);
	memset(&vec1.generic[48], (vec1.generic[48] > vec2.generic[48]) ? 0xFF : 0, 1);
	memset(&vec1.generic[49], (vec1.generic[49] > vec2.generic[49]) ? 0xFF : 0, 1);
	memset(&vec1.generic[50], (vec1.generic[50] > vec2.generic[50]) ? 0xFF : 0, 1);
	memset(&vec1.generic[51], (vec1.generic[51] > vec2.generic[51]) ? 0xFF : 0, 1);
	memset(&vec1.generic[52], (vec1.generic[52] > vec2.generic[52]) ? 0xFF : 0, 1);
	memset(&vec1.generic[53], (vec1.generic[53] > vec2.generic[53]) ? 0xFF : 0, 1);
	memset(&vec1.generic[54], (vec1.generic[54] > vec2.generic[54]) ? 0xFF : 0, 1);
	memset(&vec1.generic[55], (vec1.generic[55] > vec2.generic[55]) ? 0xFF : 0, 1);
	memset(&vec1.generic[56], (vec1.generic[56] > vec2.generic[56]) ? 0xFF : 0, 1);
	memset(&vec1.generic[57], (vec1.generic[57] > vec2.generic[57]) ? 0xFF : 0, 1);
	memset(&vec1.generic[58], (vec1.generic[58] > vec2.generic[58]) ? 0xFF : 0, 1);
	memset(&vec1.generic[59], (vec1.generic[59] > vec2.generic[59]) ? 0xFF : 0, 1);
	memset(&vec1.generic[60], (vec1.generic[60] > vec2.generic[60]) ? 0xFF : 0, 1);
	memset(&vec1.generic[61], (vec1.generic[61] > vec2.generic[61]) ? 0xFF : 0, 1);
	memset(&vec1.generic[62], (vec1.generic[62] > vec2.generic[62]) ? 0xFF : 0, 1);
	memset(&vec1.generic[63], (vec1.generic[63] > vec2.generic[63]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x64_CMPGT_DEFINED
#endif
#if !defined(VINT8x64_CMPLE_DEFINED)
VEC_FUNC_IMPL vint8x64 vint8x64_cmple(vint8x64 vec1, vint8x64 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] <= vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] <= vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] <= vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] <= vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] <= vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] <= vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] <= vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] <= vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] <= vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] <= vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] <= vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] <= vec2.generic[15]) ? 0xFF : 0, 1);
	memset(&vec1.generic[16], (vec1.generic[16] <= vec2.generic[16]) ? 0xFF : 0, 1);
	memset(&vec1.generic[17], (vec1.generic[17] <= vec2.generic[17]) ? 0xFF : 0, 1);
	memset(&vec1.generic[18], (vec1.generic[18] <= vec2.generic[18]) ? 0xFF : 0, 1);
	memset(&vec1.generic[19], (vec1.generic[19] <= vec2.generic[19]) ? 0xFF : 0, 1);
	memset(&vec1.generic[20], (vec1.generic[20] <= vec2.generic[20]) ? 0xFF : 0, 1);
	memset(&vec1.generic[21], (vec1.generic[21] <= vec2.generic[21]) ? 0xFF : 0, 1);
	memset(&vec1.generic[22], (vec1.generic[22] <= vec2.generic[22]) ? 0xFF : 0, 1);
	memset(&vec1.generic[23], (vec1.generic[23] <= vec2.generic[23]) ? 0xFF : 0, 1);
	memset(&vec1.generic[24], (vec1.generic[24] <= vec2.generic[24]) ? 0xFF : 0, 1);
	memset(&vec1.generic[25], (vec1.generic[25] <= vec2.generic[25]) ? 0xFF : 0, 1);
	memset(&vec1.generic[26], (vec1.generic[26] <= vec2.generic[26]) ? 0xFF : 0, 1);
	memset(&vec1.generic[27], (vec1.generic[27] <= vec2.generic[27]) ? 0xFF : 0, 1);
	memset(&vec1.generic[28], (vec1.generic[28] <= vec2.generic[28]) ? 0xFF : 0, 1);
	memset(&vec1.generic[29], (vec1.generic[29] <= vec2.generic[29]) ? 0xFF : 0, 1);
	memset(&vec1.generic[30], (vec1.generic[30] <= vec2.generic[30]) ? 0xFF : 0, 1);
	memset(&vec1.generic[31], (vec1.generic[31] <= vec2.generic[31]) ? 0xFF : 0, 1);
	memset(&vec1.generic[32], (vec1.generic[32] <= vec2.generic[32]) ? 0xFF : 0, 1);
	memset(&vec1.generic[33], (vec1.generic[33] <= vec2.generic[33]) ? 0xFF : 0, 1);
	memset(&vec1.generic[34], (vec1.generic[34] <= vec2.generic[34]) ? 0xFF : 0, 1);
	memset(&vec1.generic[35], (vec1.generic[35] <= vec2.generic[35]) ? 0xFF : 0, 1);
	memset(&vec1.generic[36], (vec1.generic[36] <= vec2.generic[36]) ? 0xFF : 0, 1);
	memset(&vec1.generic[37], (vec1.generic[37] <= vec2.generic[37]) ? 0xFF : 0, 1);
	memset(&vec1.generic[38], (vec1.generic[38] <= vec2.generic[38]) ? 0xFF : 0, 1);
	memset(&vec1.generic[39], (vec1.generic[39] <= vec2.generic[39]) ? 0xFF : 0, 1);
	memset(&vec1.generic[40], (vec1.generic[40] <= vec2.generic[40]) ? 0xFF : 0, 1);
	memset(&vec1.generic[41], (vec1.generic[41] <= vec2.generic[41]) ? 0xFF : 0, 1);
	memset(&vec1.generic[42], (vec1.generic[42] <= vec2.generic[42]) ? 0xFF : 0, 1);
	memset(&vec1.generic[43], (vec1.generic[43] <= vec2.generic[43]) ? 0xFF : 0, 1);
	memset(&vec1.generic[44], (vec1.generic[44] <= vec2.generic[44]) ? 0xFF : 0, 1);
	memset(&vec1.generic[45], (vec1.generic[45] <= vec2.generic[45]) ? 0xFF : 0, 1);
	memset(&vec1.generic[46], (vec1.generic[46] <= vec2.generic[46]) ? 0xFF : 0, 1);
	memset(&vec1.generic[47], (vec1.generic[47] <= vec2.generic[47]) ? 0xFF : 0, 1);
	memset(&vec1.generic[48], (vec1.generic[48] <= vec2.generic[48]) ? 0xFF : 0, 1);
	memset(&vec1.generic[49], (vec1.generic[49] <= vec2.generic[49]) ? 0xFF : 0, 1);
	memset(&vec1.generic[50], (vec1.generic[50] <= vec2.generic[50]) ? 0xFF : 0, 1);
	memset(&vec1.generic[51], (vec1.generic[51] <= vec2.generic[51]) ? 0xFF : 0, 1);
	memset(&vec1.generic[52], (vec1.generic[52] <= vec2.generic[52]) ? 0xFF : 0, 1);
	memset(&vec1.generic[53], (vec1.generic[53] <= vec2.generic[53]) ? 0xFF : 0, 1);
	memset(&vec1.generic[54], (vec1.generic[54] <= vec2.generic[54]) ? 0xFF : 0, 1);
	memset(&vec1.generic[55], (vec1.generic[55] <= vec2.generic[55]) ? 0xFF : 0, 1);
	memset(&vec1.generic[56], (vec1.generic[56] <= vec2.generic[56]) ? 0xFF : 0, 1);
	memset(&vec1.generic[57], (vec1.generic[57] <= vec2.generic[57]) ? 0xFF : 0, 1);
	memset(&vec1.generic[58], (vec1.generic[58] <= vec2.generic[58]) ? 0xFF : 0, 1);
	memset(&vec1.generic[59], (vec1.generic[59] <= vec2.generic[59]) ? 0xFF : 0, 1);
	memset(&vec1.generic[60], (vec1.generic[60] <= vec2.generic[60]) ? 0xFF : 0, 1);
	memset(&vec1.generic[61], (vec1.generic[61] <= vec2.generic[61]) ? 0xFF : 0, 1);
	memset(&vec1.generic[62], (vec1.generic[62] <= vec2.generic[62]) ? 0xFF : 0, 1);
	memset(&vec1.generic[63], (vec1.generic[63] <= vec2.generic[63]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x64_CMPLE_DEFINED
#endif
#if !defined(VINT8x64_CMPGE_DEFINED)
VEC_FUNC_IMPL vint8x64 vint8x64_cmpge(vint8x64 vec1, vint8x64 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] >= vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] >= vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] >= vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] >= vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] >= vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] >= vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] >= vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] >= vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] >= vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] >= vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] >= vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] >= vec2.generic[15]) ? 0xFF : 0, 1);
	memset(&vec1.generic[16], (vec1.generic[16] >= vec2.generic[16]) ? 0xFF : 0, 1);
	memset(&vec1.generic[17], (vec1.generic[17] >= vec2.generic[17]) ? 0xFF : 0, 1);
	memset(&vec1.generic[18], (vec1.generic[18] >= vec2.generic[18]) ? 0xFF : 0, 1);
	memset(&vec1.generic[19], (vec1.generic[19] >= vec2.generic[19]) ? 0xFF : 0, 1);
	memset(&vec1.generic[20], (vec1.generic[20] >= vec2.generic[20]) ? 0xFF : 0, 1);
	memset(&vec1.generic[21], (vec1.generic[21] >= vec2.generic[21]) ? 0xFF : 0, 1);
	memset(&vec1.generic[22], (vec1.generic[22] >= vec2.generic[22]) ? 0xFF : 0, 1);
	memset(&vec1.generic[23], (vec1.generic[23] >= vec2.generic[23]) ? 0xFF : 0, 1);
	memset(&vec1.generic[24], (vec1.generic[24] >= vec2.generic[24]) ? 0xFF : 0, 1);
	memset(&vec1.generic[25], (vec1.generic[25] >= vec2.generic[25]) ? 0xFF : 0, 1);
	memset(&vec1.generic[26], (vec1.generic[26] >= vec2.generic[26]) ? 0xFF : 0, 1);
	memset(&vec1.generic[27], (vec1.generic[27] >= vec2.generic[27]) ? 0xFF : 0, 1);
	memset(&vec1.generic[28], (vec1.generic[28] >= vec2.generic[28]) ? 0xFF : 0, 1);
	memset(&vec1.generic[29], (vec1.generic[29] >= vec2.generic[29]) ? 0xFF : 0, 1);
	memset(&vec1.generic[30], (vec1.generic[30] >= vec2.generic[30]) ? 0xFF : 0, 1);
	memset(&vec1.generic[31], (vec1.generic[31] >= vec2.generic[31]) ? 0xFF : 0, 1);
	memset(&vec1.generic[32], (vec1.generic[32] >= vec2.generic[32]) ? 0xFF : 0, 1);
	memset(&vec1.generic[33], (vec1.generic[33] >= vec2.generic[33]) ? 0xFF : 0, 1);
	memset(&vec1.generic[34], (vec1.generic[34] >= vec2.generic[34]) ? 0xFF : 0, 1);
	memset(&vec1.generic[35], (vec1.generic[35] >= vec2.generic[35]) ? 0xFF : 0, 1);
	memset(&vec1.generic[36], (vec1.generic[36] >= vec2.generic[36]) ? 0xFF : 0, 1);
	memset(&vec1.generic[37], (vec1.generic[37] >= vec2.generic[37]) ? 0xFF : 0, 1);
	memset(&vec1.generic[38], (vec1.generic[38] >= vec2.generic[38]) ? 0xFF : 0, 1);
	memset(&vec1.generic[39], (vec1.generic[39] >= vec2.generic[39]) ? 0xFF : 0, 1);
	memset(&vec1.generic[40], (vec1.generic[40] >= vec2.generic[40]) ? 0xFF : 0, 1);
	memset(&vec1.generic[41], (vec1.generic[41] >= vec2.generic[41]) ? 0xFF : 0, 1);
	memset(&vec1.generic[42], (vec1.generic[42] >= vec2.generic[42]) ? 0xFF : 0, 1);
	memset(&vec1.generic[43], (vec1.generic[43] >= vec2.generic[43]) ? 0xFF : 0, 1);
	memset(&vec1.generic[44], (vec1.generic[44] >= vec2.generic[44]) ? 0xFF : 0, 1);
	memset(&vec1.generic[45], (vec1.generic[45] >= vec2.generic[45]) ? 0xFF : 0, 1);
	memset(&vec1.generic[46], (vec1.generic[46] >= vec2.generic[46]) ? 0xFF : 0, 1);
	memset(&vec1.generic[47], (vec1.generic[47] >= vec2.generic[47]) ? 0xFF : 0, 1);
	memset(&vec1.generic[48], (vec1.generic[48] >= vec2.generic[48]) ? 0xFF : 0, 1);
	memset(&vec1.generic[49], (vec1.generic[49] >= vec2.generic[49]) ? 0xFF : 0, 1);
	memset(&vec1.generic[50], (vec1.generic[50] >= vec2.generic[50]) ? 0xFF : 0, 1);
	memset(&vec1.generic[51], (vec1.generic[51] >= vec2.generic[51]) ? 0xFF : 0, 1);
	memset(&vec1.generic[52], (vec1.generic[52] >= vec2.generic[52]) ? 0xFF : 0, 1);
	memset(&vec1.generic[53], (vec1.generic[53] >= vec2.generic[53]) ? 0xFF : 0, 1);
	memset(&vec1.generic[54], (vec1.generic[54] >= vec2.generic[54]) ? 0xFF : 0, 1);
	memset(&vec1.generic[55], (vec1.generic[55] >= vec2.generic[55]) ? 0xFF : 0, 1);
	memset(&vec1.generic[56], (vec1.generic[56] >= vec2.generic[56]) ? 0xFF : 0, 1);
	memset(&vec1.generic[57], (vec1.generic[57] >= vec2.generic[57]) ? 0xFF : 0, 1);
	memset(&vec1.generic[58], (vec1.generic[58] >= vec2.generic[58]) ? 0xFF : 0, 1);
	memset(&vec1.generic[59], (vec1.generic[59] >= vec2.generic[59]) ? 0xFF : 0, 1);
	memset(&vec1.generic[60], (vec1.generic[60] >= vec2.generic[60]) ? 0xFF : 0, 1);
	memset(&vec1.generic[61], (vec1.generic[61] >= vec2.generic[61]) ? 0xFF : 0, 1);
	memset(&vec1.generic[62], (vec1.generic[62] >= vec2.generic[62]) ? 0xFF : 0, 1);
	memset(&vec1.generic[63], (vec1.generic[63] >= vec2.generic[63]) ? 0xFF : 0, 1);
	return vec1;
}
# define VINT8x64_CMPGE_DEFINED
#endif
#if !defined(VINT8x64_MIN_DEFINED)
VEC_FUNC_IMPL vint8x64 vint8x64_min(vint8x64 vec1, vint8x64 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] < vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] < vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] < vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] < vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] < vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] < vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] < vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] < vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] < vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] < vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] < vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] < vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] < vec2.generic[16]) ? (vec1.generic[16]) : (vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] < vec2.generic[17]) ? (vec1.generic[17]) : (vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] < vec2.generic[18]) ? (vec1.generic[18]) : (vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] < vec2.generic[19]) ? (vec1.generic[19]) : (vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] < vec2.generic[20]) ? (vec1.generic[20]) : (vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] < vec2.generic[21]) ? (vec1.generic[21]) : (vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] < vec2.generic[22]) ? (vec1.generic[22]) : (vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] < vec2.generic[23]) ? (vec1.generic[23]) : (vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] < vec2.generic[24]) ? (vec1.generic[24]) : (vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] < vec2.generic[25]) ? (vec1.generic[25]) : (vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] < vec2.generic[26]) ? (vec1.generic[26]) : (vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] < vec2.generic[27]) ? (vec1.generic[27]) : (vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] < vec2.generic[28]) ? (vec1.generic[28]) : (vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] < vec2.generic[29]) ? (vec1.generic[29]) : (vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] < vec2.generic[30]) ? (vec1.generic[30]) : (vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] < vec2.generic[31]) ? (vec1.generic[31]) : (vec2.generic[31]);
	vec1.generic[32] = (vec1.generic[32] < vec2.generic[32]) ? (vec1.generic[32]) : (vec2.generic[32]);
	vec1.generic[33] = (vec1.generic[33] < vec2.generic[33]) ? (vec1.generic[33]) : (vec2.generic[33]);
	vec1.generic[34] = (vec1.generic[34] < vec2.generic[34]) ? (vec1.generic[34]) : (vec2.generic[34]);
	vec1.generic[35] = (vec1.generic[35] < vec2.generic[35]) ? (vec1.generic[35]) : (vec2.generic[35]);
	vec1.generic[36] = (vec1.generic[36] < vec2.generic[36]) ? (vec1.generic[36]) : (vec2.generic[36]);
	vec1.generic[37] = (vec1.generic[37] < vec2.generic[37]) ? (vec1.generic[37]) : (vec2.generic[37]);
	vec1.generic[38] = (vec1.generic[38] < vec2.generic[38]) ? (vec1.generic[38]) : (vec2.generic[38]);
	vec1.generic[39] = (vec1.generic[39] < vec2.generic[39]) ? (vec1.generic[39]) : (vec2.generic[39]);
	vec1.generic[40] = (vec1.generic[40] < vec2.generic[40]) ? (vec1.generic[40]) : (vec2.generic[40]);
	vec1.generic[41] = (vec1.generic[41] < vec2.generic[41]) ? (vec1.generic[41]) : (vec2.generic[41]);
	vec1.generic[42] = (vec1.generic[42] < vec2.generic[42]) ? (vec1.generic[42]) : (vec2.generic[42]);
	vec1.generic[43] = (vec1.generic[43] < vec2.generic[43]) ? (vec1.generic[43]) : (vec2.generic[43]);
	vec1.generic[44] = (vec1.generic[44] < vec2.generic[44]) ? (vec1.generic[44]) : (vec2.generic[44]);
	vec1.generic[45] = (vec1.generic[45] < vec2.generic[45]) ? (vec1.generic[45]) : (vec2.generic[45]);
	vec1.generic[46] = (vec1.generic[46] < vec2.generic[46]) ? (vec1.generic[46]) : (vec2.generic[46]);
	vec1.generic[47] = (vec1.generic[47] < vec2.generic[47]) ? (vec1.generic[47]) : (vec2.generic[47]);
	vec1.generic[48] = (vec1.generic[48] < vec2.generic[48]) ? (vec1.generic[48]) : (vec2.generic[48]);
	vec1.generic[49] = (vec1.generic[49] < vec2.generic[49]) ? (vec1.generic[49]) : (vec2.generic[49]);
	vec1.generic[50] = (vec1.generic[50] < vec2.generic[50]) ? (vec1.generic[50]) : (vec2.generic[50]);
	vec1.generic[51] = (vec1.generic[51] < vec2.generic[51]) ? (vec1.generic[51]) : (vec2.generic[51]);
	vec1.generic[52] = (vec1.generic[52] < vec2.generic[52]) ? (vec1.generic[52]) : (vec2.generic[52]);
	vec1.generic[53] = (vec1.generic[53] < vec2.generic[53]) ? (vec1.generic[53]) : (vec2.generic[53]);
	vec1.generic[54] = (vec1.generic[54] < vec2.generic[54]) ? (vec1.generic[54]) : (vec2.generic[54]);
	vec1.generic[55] = (vec1.generic[55] < vec2.generic[55]) ? (vec1.generic[55]) : (vec2.generic[55]);
	vec1.generic[56] = (vec1.generic[56] < vec2.generic[56]) ? (vec1.generic[56]) : (vec2.generic[56]);
	vec1.generic[57] = (vec1.generic[57] < vec2.generic[57]) ? (vec1.generic[57]) : (vec2.generic[57]);
	vec1.generic[58] = (vec1.generic[58] < vec2.generic[58]) ? (vec1.generic[58]) : (vec2.generic[58]);
	vec1.generic[59] = (vec1.generic[59] < vec2.generic[59]) ? (vec1.generic[59]) : (vec2.generic[59]);
	vec1.generic[60] = (vec1.generic[60] < vec2.generic[60]) ? (vec1.generic[60]) : (vec2.generic[60]);
	vec1.generic[61] = (vec1.generic[61] < vec2.generic[61]) ? (vec1.generic[61]) : (vec2.generic[61]);
	vec1.generic[62] = (vec1.generic[62] < vec2.generic[62]) ? (vec1.generic[62]) : (vec2.generic[62]);
	vec1.generic[63] = (vec1.generic[63] < vec2.generic[63]) ? (vec1.generic[63]) : (vec2.generic[63]);
	return vec1;
}
# define VINT8x64_MIN_DEFINED
#endif
#if !defined(VINT8x64_MAX_DEFINED)
VEC_FUNC_IMPL vint8x64 vint8x64_max(vint8x64 vec1, vint8x64 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] > vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] > vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] > vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] > vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] > vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] > vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] > vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] > vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] > vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] > vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] > vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] > vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] > vec2.generic[16]) ? (vec1.generic[16]) : (vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] > vec2.generic[17]) ? (vec1.generic[17]) : (vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] > vec2.generic[18]) ? (vec1.generic[18]) : (vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] > vec2.generic[19]) ? (vec1.generic[19]) : (vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] > vec2.generic[20]) ? (vec1.generic[20]) : (vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] > vec2.generic[21]) ? (vec1.generic[21]) : (vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] > vec2.generic[22]) ? (vec1.generic[22]) : (vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] > vec2.generic[23]) ? (vec1.generic[23]) : (vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] > vec2.generic[24]) ? (vec1.generic[24]) : (vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] > vec2.generic[25]) ? (vec1.generic[25]) : (vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] > vec2.generic[26]) ? (vec1.generic[26]) : (vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] > vec2.generic[27]) ? (vec1.generic[27]) : (vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] > vec2.generic[28]) ? (vec1.generic[28]) : (vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] > vec2.generic[29]) ? (vec1.generic[29]) : (vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] > vec2.generic[30]) ? (vec1.generic[30]) : (vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] > vec2.generic[31]) ? (vec1.generic[31]) : (vec2.generic[31]);
	vec1.generic[32] = (vec1.generic[32] > vec2.generic[32]) ? (vec1.generic[32]) : (vec2.generic[32]);
	vec1.generic[33] = (vec1.generic[33] > vec2.generic[33]) ? (vec1.generic[33]) : (vec2.generic[33]);
	vec1.generic[34] = (vec1.generic[34] > vec2.generic[34]) ? (vec1.generic[34]) : (vec2.generic[34]);
	vec1.generic[35] = (vec1.generic[35] > vec2.generic[35]) ? (vec1.generic[35]) : (vec2.generic[35]);
	vec1.generic[36] = (vec1.generic[36] > vec2.generic[36]) ? (vec1.generic[36]) : (vec2.generic[36]);
	vec1.generic[37] = (vec1.generic[37] > vec2.generic[37]) ? (vec1.generic[37]) : (vec2.generic[37]);
	vec1.generic[38] = (vec1.generic[38] > vec2.generic[38]) ? (vec1.generic[38]) : (vec2.generic[38]);
	vec1.generic[39] = (vec1.generic[39] > vec2.generic[39]) ? (vec1.generic[39]) : (vec2.generic[39]);
	vec1.generic[40] = (vec1.generic[40] > vec2.generic[40]) ? (vec1.generic[40]) : (vec2.generic[40]);
	vec1.generic[41] = (vec1.generic[41] > vec2.generic[41]) ? (vec1.generic[41]) : (vec2.generic[41]);
	vec1.generic[42] = (vec1.generic[42] > vec2.generic[42]) ? (vec1.generic[42]) : (vec2.generic[42]);
	vec1.generic[43] = (vec1.generic[43] > vec2.generic[43]) ? (vec1.generic[43]) : (vec2.generic[43]);
	vec1.generic[44] = (vec1.generic[44] > vec2.generic[44]) ? (vec1.generic[44]) : (vec2.generic[44]);
	vec1.generic[45] = (vec1.generic[45] > vec2.generic[45]) ? (vec1.generic[45]) : (vec2.generic[45]);
	vec1.generic[46] = (vec1.generic[46] > vec2.generic[46]) ? (vec1.generic[46]) : (vec2.generic[46]);
	vec1.generic[47] = (vec1.generic[47] > vec2.generic[47]) ? (vec1.generic[47]) : (vec2.generic[47]);
	vec1.generic[48] = (vec1.generic[48] > vec2.generic[48]) ? (vec1.generic[48]) : (vec2.generic[48]);
	vec1.generic[49] = (vec1.generic[49] > vec2.generic[49]) ? (vec1.generic[49]) : (vec2.generic[49]);
	vec1.generic[50] = (vec1.generic[50] > vec2.generic[50]) ? (vec1.generic[50]) : (vec2.generic[50]);
	vec1.generic[51] = (vec1.generic[51] > vec2.generic[51]) ? (vec1.generic[51]) : (vec2.generic[51]);
	vec1.generic[52] = (vec1.generic[52] > vec2.generic[52]) ? (vec1.generic[52]) : (vec2.generic[52]);
	vec1.generic[53] = (vec1.generic[53] > vec2.generic[53]) ? (vec1.generic[53]) : (vec2.generic[53]);
	vec1.generic[54] = (vec1.generic[54] > vec2.generic[54]) ? (vec1.generic[54]) : (vec2.generic[54]);
	vec1.generic[55] = (vec1.generic[55] > vec2.generic[55]) ? (vec1.generic[55]) : (vec2.generic[55]);
	vec1.generic[56] = (vec1.generic[56] > vec2.generic[56]) ? (vec1.generic[56]) : (vec2.generic[56]);
	vec1.generic[57] = (vec1.generic[57] > vec2.generic[57]) ? (vec1.generic[57]) : (vec2.generic[57]);
	vec1.generic[58] = (vec1.generic[58] > vec2.generic[58]) ? (vec1.generic[58]) : (vec2.generic[58]);
	vec1.generic[59] = (vec1.generic[59] > vec2.generic[59]) ? (vec1.generic[59]) : (vec2.generic[59]);
	vec1.generic[60] = (vec1.generic[60] > vec2.generic[60]) ? (vec1.generic[60]) : (vec2.generic[60]);
	vec1.generic[61] = (vec1.generic[61] > vec2.generic[61]) ? (vec1.generic[61]) : (vec2.generic[61]);
	vec1.generic[62] = (vec1.generic[62] > vec2.generic[62]) ? (vec1.generic[62]) : (vec2.generic[62]);
	vec1.generic[63] = (vec1.generic[63] > vec2.generic[63]) ? (vec1.generic[63]) : (vec2.generic[63]);
	return vec1;
}
# define VINT8x64_MAX_DEFINED
#endif
#if !defined(VINT8x64_RSHIFT_DEFINED)
VEC_FUNC_IMPL vint8x64 vint8x64_rshift(vint8x64 vec1, vuint8x64 vec2)
{
vec1.generic[0] = ((~vec1.generic[0]) >> vec2.generic[0]);
vec1.generic[1] = ((~vec1.generic[1]) >> vec2.generic[1]);
vec1.generic[2] = ((~vec1.generic[2]) >> vec2.generic[2]);
vec1.generic[3] = ((~vec1.generic[3]) >> vec2.generic[3]);
vec1.generic[4] = ((~vec1.generic[4]) >> vec2.generic[4]);
vec1.generic[5] = ((~vec1.generic[5]) >> vec2.generic[5]);
vec1.generic[6] = ((~vec1.generic[6]) >> vec2.generic[6]);
vec1.generic[7] = ((~vec1.generic[7]) >> vec2.generic[7]);
vec1.generic[8] = ((~vec1.generic[8]) >> vec2.generic[8]);
vec1.generic[9] = ((~vec1.generic[9]) >> vec2.generic[9]);
vec1.generic[10] = ((~vec1.generic[10]) >> vec2.generic[10]);
vec1.generic[11] = ((~vec1.generic[11]) >> vec2.generic[11]);
vec1.generic[12] = ((~vec1.generic[12]) >> vec2.generic[12]);
vec1.generic[13] = ((~vec1.generic[13]) >> vec2.generic[13]);
vec1.generic[14] = ((~vec1.generic[14]) >> vec2.generic[14]);
vec1.generic[15] = ((~vec1.generic[15]) >> vec2.generic[15]);
vec1.generic[16] = ((~vec1.generic[16]) >> vec2.generic[16]);
vec1.generic[17] = ((~vec1.generic[17]) >> vec2.generic[17]);
vec1.generic[18] = ((~vec1.generic[18]) >> vec2.generic[18]);
vec1.generic[19] = ((~vec1.generic[19]) >> vec2.generic[19]);
vec1.generic[20] = ((~vec1.generic[20]) >> vec2.generic[20]);
vec1.generic[21] = ((~vec1.generic[21]) >> vec2.generic[21]);
vec1.generic[22] = ((~vec1.generic[22]) >> vec2.generic[22]);
vec1.generic[23] = ((~vec1.generic[23]) >> vec2.generic[23]);
vec1.generic[24] = ((~vec1.generic[24]) >> vec2.generic[24]);
vec1.generic[25] = ((~vec1.generic[25]) >> vec2.generic[25]);
vec1.generic[26] = ((~vec1.generic[26]) >> vec2.generic[26]);
vec1.generic[27] = ((~vec1.generic[27]) >> vec2.generic[27]);
vec1.generic[28] = ((~vec1.generic[28]) >> vec2.generic[28]);
vec1.generic[29] = ((~vec1.generic[29]) >> vec2.generic[29]);
vec1.generic[30] = ((~vec1.generic[30]) >> vec2.generic[30]);
vec1.generic[31] = ((~vec1.generic[31]) >> vec2.generic[31]);
vec1.generic[32] = ((~vec1.generic[32]) >> vec2.generic[32]);
vec1.generic[33] = ((~vec1.generic[33]) >> vec2.generic[33]);
vec1.generic[34] = ((~vec1.generic[34]) >> vec2.generic[34]);
vec1.generic[35] = ((~vec1.generic[35]) >> vec2.generic[35]);
vec1.generic[36] = ((~vec1.generic[36]) >> vec2.generic[36]);
vec1.generic[37] = ((~vec1.generic[37]) >> vec2.generic[37]);
vec1.generic[38] = ((~vec1.generic[38]) >> vec2.generic[38]);
vec1.generic[39] = ((~vec1.generic[39]) >> vec2.generic[39]);
vec1.generic[40] = ((~vec1.generic[40]) >> vec2.generic[40]);
vec1.generic[41] = ((~vec1.generic[41]) >> vec2.generic[41]);
vec1.generic[42] = ((~vec1.generic[42]) >> vec2.generic[42]);
vec1.generic[43] = ((~vec1.generic[43]) >> vec2.generic[43]);
vec1.generic[44] = ((~vec1.generic[44]) >> vec2.generic[44]);
vec1.generic[45] = ((~vec1.generic[45]) >> vec2.generic[45]);
vec1.generic[46] = ((~vec1.generic[46]) >> vec2.generic[46]);
vec1.generic[47] = ((~vec1.generic[47]) >> vec2.generic[47]);
vec1.generic[48] = ((~vec1.generic[48]) >> vec2.generic[48]);
vec1.generic[49] = ((~vec1.generic[49]) >> vec2.generic[49]);
vec1.generic[50] = ((~vec1.generic[50]) >> vec2.generic[50]);
vec1.generic[51] = ((~vec1.generic[51]) >> vec2.generic[51]);
vec1.generic[52] = ((~vec1.generic[52]) >> vec2.generic[52]);
vec1.generic[53] = ((~vec1.generic[53]) >> vec2.generic[53]);
vec1.generic[54] = ((~vec1.generic[54]) >> vec2.generic[54]);
vec1.generic[55] = ((~vec1.generic[55]) >> vec2.generic[55]);
vec1.generic[56] = ((~vec1.generic[56]) >> vec2.generic[56]);
vec1.generic[57] = ((~vec1.generic[57]) >> vec2.generic[57]);
vec1.generic[58] = ((~vec1.generic[58]) >> vec2.generic[58]);
vec1.generic[59] = ((~vec1.generic[59]) >> vec2.generic[59]);
vec1.generic[60] = ((~vec1.generic[60]) >> vec2.generic[60]);
vec1.generic[61] = ((~vec1.generic[61]) >> vec2.generic[61]);
vec1.generic[62] = ((~vec1.generic[62]) >> vec2.generic[62]);
vec1.generic[63] = ((~vec1.generic[63]) >> vec2.generic[63]);
	return vec1;
}
# define VINT8x64_RSHIFT_DEFINED
#endif
#if !defined(VINT8x64_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vint8x64 vint8x64_lrshift(vint8x64 vec1, vuint8x64 vec2)
{
	union { vec_uint8 u; vec_int8 s; } x;

	x.s = vec1.generic[0];
	x.u >>= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u >>= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u >>= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u >>= vec2.generic[3];
	vec1.generic[3] = x.s;
	x.s = vec1.generic[4];
	x.u >>= vec2.generic[4];
	vec1.generic[4] = x.s;
	x.s = vec1.generic[5];
	x.u >>= vec2.generic[5];
	vec1.generic[5] = x.s;
	x.s = vec1.generic[6];
	x.u >>= vec2.generic[6];
	vec1.generic[6] = x.s;
	x.s = vec1.generic[7];
	x.u >>= vec2.generic[7];
	vec1.generic[7] = x.s;
	x.s = vec1.generic[8];
	x.u >>= vec2.generic[8];
	vec1.generic[8] = x.s;
	x.s = vec1.generic[9];
	x.u >>= vec2.generic[9];
	vec1.generic[9] = x.s;
	x.s = vec1.generic[10];
	x.u >>= vec2.generic[10];
	vec1.generic[10] = x.s;
	x.s = vec1.generic[11];
	x.u >>= vec2.generic[11];
	vec1.generic[11] = x.s;
	x.s = vec1.generic[12];
	x.u >>= vec2.generic[12];
	vec1.generic[12] = x.s;
	x.s = vec1.generic[13];
	x.u >>= vec2.generic[13];
	vec1.generic[13] = x.s;
	x.s = vec1.generic[14];
	x.u >>= vec2.generic[14];
	vec1.generic[14] = x.s;
	x.s = vec1.generic[15];
	x.u >>= vec2.generic[15];
	vec1.generic[15] = x.s;
	x.s = vec1.generic[16];
	x.u >>= vec2.generic[16];
	vec1.generic[16] = x.s;
	x.s = vec1.generic[17];
	x.u >>= vec2.generic[17];
	vec1.generic[17] = x.s;
	x.s = vec1.generic[18];
	x.u >>= vec2.generic[18];
	vec1.generic[18] = x.s;
	x.s = vec1.generic[19];
	x.u >>= vec2.generic[19];
	vec1.generic[19] = x.s;
	x.s = vec1.generic[20];
	x.u >>= vec2.generic[20];
	vec1.generic[20] = x.s;
	x.s = vec1.generic[21];
	x.u >>= vec2.generic[21];
	vec1.generic[21] = x.s;
	x.s = vec1.generic[22];
	x.u >>= vec2.generic[22];
	vec1.generic[22] = x.s;
	x.s = vec1.generic[23];
	x.u >>= vec2.generic[23];
	vec1.generic[23] = x.s;
	x.s = vec1.generic[24];
	x.u >>= vec2.generic[24];
	vec1.generic[24] = x.s;
	x.s = vec1.generic[25];
	x.u >>= vec2.generic[25];
	vec1.generic[25] = x.s;
	x.s = vec1.generic[26];
	x.u >>= vec2.generic[26];
	vec1.generic[26] = x.s;
	x.s = vec1.generic[27];
	x.u >>= vec2.generic[27];
	vec1.generic[27] = x.s;
	x.s = vec1.generic[28];
	x.u >>= vec2.generic[28];
	vec1.generic[28] = x.s;
	x.s = vec1.generic[29];
	x.u >>= vec2.generic[29];
	vec1.generic[29] = x.s;
	x.s = vec1.generic[30];
	x.u >>= vec2.generic[30];
	vec1.generic[30] = x.s;
	x.s = vec1.generic[31];
	x.u >>= vec2.generic[31];
	vec1.generic[31] = x.s;
	x.s = vec1.generic[32];
	x.u >>= vec2.generic[32];
	vec1.generic[32] = x.s;
	x.s = vec1.generic[33];
	x.u >>= vec2.generic[33];
	vec1.generic[33] = x.s;
	x.s = vec1.generic[34];
	x.u >>= vec2.generic[34];
	vec1.generic[34] = x.s;
	x.s = vec1.generic[35];
	x.u >>= vec2.generic[35];
	vec1.generic[35] = x.s;
	x.s = vec1.generic[36];
	x.u >>= vec2.generic[36];
	vec1.generic[36] = x.s;
	x.s = vec1.generic[37];
	x.u >>= vec2.generic[37];
	vec1.generic[37] = x.s;
	x.s = vec1.generic[38];
	x.u >>= vec2.generic[38];
	vec1.generic[38] = x.s;
	x.s = vec1.generic[39];
	x.u >>= vec2.generic[39];
	vec1.generic[39] = x.s;
	x.s = vec1.generic[40];
	x.u >>= vec2.generic[40];
	vec1.generic[40] = x.s;
	x.s = vec1.generic[41];
	x.u >>= vec2.generic[41];
	vec1.generic[41] = x.s;
	x.s = vec1.generic[42];
	x.u >>= vec2.generic[42];
	vec1.generic[42] = x.s;
	x.s = vec1.generic[43];
	x.u >>= vec2.generic[43];
	vec1.generic[43] = x.s;
	x.s = vec1.generic[44];
	x.u >>= vec2.generic[44];
	vec1.generic[44] = x.s;
	x.s = vec1.generic[45];
	x.u >>= vec2.generic[45];
	vec1.generic[45] = x.s;
	x.s = vec1.generic[46];
	x.u >>= vec2.generic[46];
	vec1.generic[46] = x.s;
	x.s = vec1.generic[47];
	x.u >>= vec2.generic[47];
	vec1.generic[47] = x.s;
	x.s = vec1.generic[48];
	x.u >>= vec2.generic[48];
	vec1.generic[48] = x.s;
	x.s = vec1.generic[49];
	x.u >>= vec2.generic[49];
	vec1.generic[49] = x.s;
	x.s = vec1.generic[50];
	x.u >>= vec2.generic[50];
	vec1.generic[50] = x.s;
	x.s = vec1.generic[51];
	x.u >>= vec2.generic[51];
	vec1.generic[51] = x.s;
	x.s = vec1.generic[52];
	x.u >>= vec2.generic[52];
	vec1.generic[52] = x.s;
	x.s = vec1.generic[53];
	x.u >>= vec2.generic[53];
	vec1.generic[53] = x.s;
	x.s = vec1.generic[54];
	x.u >>= vec2.generic[54];
	vec1.generic[54] = x.s;
	x.s = vec1.generic[55];
	x.u >>= vec2.generic[55];
	vec1.generic[55] = x.s;
	x.s = vec1.generic[56];
	x.u >>= vec2.generic[56];
	vec1.generic[56] = x.s;
	x.s = vec1.generic[57];
	x.u >>= vec2.generic[57];
	vec1.generic[57] = x.s;
	x.s = vec1.generic[58];
	x.u >>= vec2.generic[58];
	vec1.generic[58] = x.s;
	x.s = vec1.generic[59];
	x.u >>= vec2.generic[59];
	vec1.generic[59] = x.s;
	x.s = vec1.generic[60];
	x.u >>= vec2.generic[60];
	vec1.generic[60] = x.s;
	x.s = vec1.generic[61];
	x.u >>= vec2.generic[61];
	vec1.generic[61] = x.s;
	x.s = vec1.generic[62];
	x.u >>= vec2.generic[62];
	vec1.generic[62] = x.s;
	x.s = vec1.generic[63];
	x.u >>= vec2.generic[63];
	vec1.generic[63] = x.s;
	return vec1;
}
# define VINT8x64_LRSHIFT_DEFINED
#endif
#if !defined(VINT8x64_LSHIFT_DEFINED)
VEC_FUNC_IMPL vint8x64 vint8x64_lshift(vint8x64 vec1, vuint8x64 vec2)
{
	union { vec_uint8 u; vec_int8 s; } x;

	x.s = vec1.generic[0];
	x.u <<= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u <<= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u <<= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u <<= vec2.generic[3];
	vec1.generic[3] = x.s;
	x.s = vec1.generic[4];
	x.u <<= vec2.generic[4];
	vec1.generic[4] = x.s;
	x.s = vec1.generic[5];
	x.u <<= vec2.generic[5];
	vec1.generic[5] = x.s;
	x.s = vec1.generic[6];
	x.u <<= vec2.generic[6];
	vec1.generic[6] = x.s;
	x.s = vec1.generic[7];
	x.u <<= vec2.generic[7];
	vec1.generic[7] = x.s;
	x.s = vec1.generic[8];
	x.u <<= vec2.generic[8];
	vec1.generic[8] = x.s;
	x.s = vec1.generic[9];
	x.u <<= vec2.generic[9];
	vec1.generic[9] = x.s;
	x.s = vec1.generic[10];
	x.u <<= vec2.generic[10];
	vec1.generic[10] = x.s;
	x.s = vec1.generic[11];
	x.u <<= vec2.generic[11];
	vec1.generic[11] = x.s;
	x.s = vec1.generic[12];
	x.u <<= vec2.generic[12];
	vec1.generic[12] = x.s;
	x.s = vec1.generic[13];
	x.u <<= vec2.generic[13];
	vec1.generic[13] = x.s;
	x.s = vec1.generic[14];
	x.u <<= vec2.generic[14];
	vec1.generic[14] = x.s;
	x.s = vec1.generic[15];
	x.u <<= vec2.generic[15];
	vec1.generic[15] = x.s;
	x.s = vec1.generic[16];
	x.u <<= vec2.generic[16];
	vec1.generic[16] = x.s;
	x.s = vec1.generic[17];
	x.u <<= vec2.generic[17];
	vec1.generic[17] = x.s;
	x.s = vec1.generic[18];
	x.u <<= vec2.generic[18];
	vec1.generic[18] = x.s;
	x.s = vec1.generic[19];
	x.u <<= vec2.generic[19];
	vec1.generic[19] = x.s;
	x.s = vec1.generic[20];
	x.u <<= vec2.generic[20];
	vec1.generic[20] = x.s;
	x.s = vec1.generic[21];
	x.u <<= vec2.generic[21];
	vec1.generic[21] = x.s;
	x.s = vec1.generic[22];
	x.u <<= vec2.generic[22];
	vec1.generic[22] = x.s;
	x.s = vec1.generic[23];
	x.u <<= vec2.generic[23];
	vec1.generic[23] = x.s;
	x.s = vec1.generic[24];
	x.u <<= vec2.generic[24];
	vec1.generic[24] = x.s;
	x.s = vec1.generic[25];
	x.u <<= vec2.generic[25];
	vec1.generic[25] = x.s;
	x.s = vec1.generic[26];
	x.u <<= vec2.generic[26];
	vec1.generic[26] = x.s;
	x.s = vec1.generic[27];
	x.u <<= vec2.generic[27];
	vec1.generic[27] = x.s;
	x.s = vec1.generic[28];
	x.u <<= vec2.generic[28];
	vec1.generic[28] = x.s;
	x.s = vec1.generic[29];
	x.u <<= vec2.generic[29];
	vec1.generic[29] = x.s;
	x.s = vec1.generic[30];
	x.u <<= vec2.generic[30];
	vec1.generic[30] = x.s;
	x.s = vec1.generic[31];
	x.u <<= vec2.generic[31];
	vec1.generic[31] = x.s;
	x.s = vec1.generic[32];
	x.u <<= vec2.generic[32];
	vec1.generic[32] = x.s;
	x.s = vec1.generic[33];
	x.u <<= vec2.generic[33];
	vec1.generic[33] = x.s;
	x.s = vec1.generic[34];
	x.u <<= vec2.generic[34];
	vec1.generic[34] = x.s;
	x.s = vec1.generic[35];
	x.u <<= vec2.generic[35];
	vec1.generic[35] = x.s;
	x.s = vec1.generic[36];
	x.u <<= vec2.generic[36];
	vec1.generic[36] = x.s;
	x.s = vec1.generic[37];
	x.u <<= vec2.generic[37];
	vec1.generic[37] = x.s;
	x.s = vec1.generic[38];
	x.u <<= vec2.generic[38];
	vec1.generic[38] = x.s;
	x.s = vec1.generic[39];
	x.u <<= vec2.generic[39];
	vec1.generic[39] = x.s;
	x.s = vec1.generic[40];
	x.u <<= vec2.generic[40];
	vec1.generic[40] = x.s;
	x.s = vec1.generic[41];
	x.u <<= vec2.generic[41];
	vec1.generic[41] = x.s;
	x.s = vec1.generic[42];
	x.u <<= vec2.generic[42];
	vec1.generic[42] = x.s;
	x.s = vec1.generic[43];
	x.u <<= vec2.generic[43];
	vec1.generic[43] = x.s;
	x.s = vec1.generic[44];
	x.u <<= vec2.generic[44];
	vec1.generic[44] = x.s;
	x.s = vec1.generic[45];
	x.u <<= vec2.generic[45];
	vec1.generic[45] = x.s;
	x.s = vec1.generic[46];
	x.u <<= vec2.generic[46];
	vec1.generic[46] = x.s;
	x.s = vec1.generic[47];
	x.u <<= vec2.generic[47];
	vec1.generic[47] = x.s;
	x.s = vec1.generic[48];
	x.u <<= vec2.generic[48];
	vec1.generic[48] = x.s;
	x.s = vec1.generic[49];
	x.u <<= vec2.generic[49];
	vec1.generic[49] = x.s;
	x.s = vec1.generic[50];
	x.u <<= vec2.generic[50];
	vec1.generic[50] = x.s;
	x.s = vec1.generic[51];
	x.u <<= vec2.generic[51];
	vec1.generic[51] = x.s;
	x.s = vec1.generic[52];
	x.u <<= vec2.generic[52];
	vec1.generic[52] = x.s;
	x.s = vec1.generic[53];
	x.u <<= vec2.generic[53];
	vec1.generic[53] = x.s;
	x.s = vec1.generic[54];
	x.u <<= vec2.generic[54];
	vec1.generic[54] = x.s;
	x.s = vec1.generic[55];
	x.u <<= vec2.generic[55];
	vec1.generic[55] = x.s;
	x.s = vec1.generic[56];
	x.u <<= vec2.generic[56];
	vec1.generic[56] = x.s;
	x.s = vec1.generic[57];
	x.u <<= vec2.generic[57];
	vec1.generic[57] = x.s;
	x.s = vec1.generic[58];
	x.u <<= vec2.generic[58];
	vec1.generic[58] = x.s;
	x.s = vec1.generic[59];
	x.u <<= vec2.generic[59];
	vec1.generic[59] = x.s;
	x.s = vec1.generic[60];
	x.u <<= vec2.generic[60];
	vec1.generic[60] = x.s;
	x.s = vec1.generic[61];
	x.u <<= vec2.generic[61];
	vec1.generic[61] = x.s;
	x.s = vec1.generic[62];
	x.u <<= vec2.generic[62];
	vec1.generic[62] = x.s;
	x.s = vec1.generic[63];
	x.u <<= vec2.generic[63];
	vec1.generic[63] = x.s;
	return vec1;
}
# define VINT8x64_LSHIFT_DEFINED
#endif
#if !defined(VUINT8x64_SPLAT_DEFINED)
VEC_FUNC_IMPL vuint8x64 vuint8x64_splat(vec_uint8 x)
{
	vuint8x64 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	vec.generic[4] = x;
	vec.generic[5] = x;
	vec.generic[6] = x;
	vec.generic[7] = x;
	vec.generic[8] = x;
	vec.generic[9] = x;
	vec.generic[10] = x;
	vec.generic[11] = x;
	vec.generic[12] = x;
	vec.generic[13] = x;
	vec.generic[14] = x;
	vec.generic[15] = x;
	vec.generic[16] = x;
	vec.generic[17] = x;
	vec.generic[18] = x;
	vec.generic[19] = x;
	vec.generic[20] = x;
	vec.generic[21] = x;
	vec.generic[22] = x;
	vec.generic[23] = x;
	vec.generic[24] = x;
	vec.generic[25] = x;
	vec.generic[26] = x;
	vec.generic[27] = x;
	vec.generic[28] = x;
	vec.generic[29] = x;
	vec.generic[30] = x;
	vec.generic[31] = x;
	vec.generic[32] = x;
	vec.generic[33] = x;
	vec.generic[34] = x;
	vec.generic[35] = x;
	vec.generic[36] = x;
	vec.generic[37] = x;
	vec.generic[38] = x;
	vec.generic[39] = x;
	vec.generic[40] = x;
	vec.generic[41] = x;
	vec.generic[42] = x;
	vec.generic[43] = x;
	vec.generic[44] = x;
	vec.generic[45] = x;
	vec.generic[46] = x;
	vec.generic[47] = x;
	vec.generic[48] = x;
	vec.generic[49] = x;
	vec.generic[50] = x;
	vec.generic[51] = x;
	vec.generic[52] = x;
	vec.generic[53] = x;
	vec.generic[54] = x;
	vec.generic[55] = x;
	vec.generic[56] = x;
	vec.generic[57] = x;
	vec.generic[58] = x;
	vec.generic[59] = x;
	vec.generic[60] = x;
	vec.generic[61] = x;
	vec.generic[62] = x;
	vec.generic[63] = x;
	return vec;
}
# define VUINT8x64_SPLAT_DEFINED
#endif
#if !defined(VUINT8x64_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vuint8x64 vuint8x64_load_aligned(const vec_uint8 x[64])
{
	vuint8x64 vec;
	memcpy(vec.generic, x, 64);
	return vec;
}
# define VUINT8x64_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VUINT8x64_LOAD_DEFINED)
VEC_FUNC_IMPL vuint8x64 vuint8x64_load(const vec_uint8 x[64])
{
	vuint8x64 vec;
	memcpy(vec.generic, x, 64);
	return vec;
}
# define VUINT8x64_LOAD_DEFINED
#endif
#if !defined(VUINT8x64_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vuint8x64_store_aligned(vuint8x64 vec, vec_uint8 x[64])
{
	memcpy(x, vec.generic, 64);
}
# define VUINT8x64_STORE_ALIGNED_DEFINED
#endif
#if !defined(VUINT8x64_STORE_DEFINED)
VEC_FUNC_IMPL void vuint8x64_store(vuint8x64 vec, vec_uint8 x[64])
{
	memcpy(x, vec.generic, 64);
}
# define VUINT8x64_STORE_DEFINED
#endif
#if !defined(VUINT8x64_ADD_DEFINED)
VEC_FUNC_IMPL vuint8x64 vuint8x64_add(vuint8x64 vec1, vuint8x64 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] + vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] + vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] + vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] + vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] + vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] + vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] + vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] + vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] + vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] + vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] + vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] + vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] + vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] + vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] + vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] + vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] + vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] + vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] + vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] + vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] + vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] + vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] + vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] + vec2.generic[31]);
	vec1.generic[32] = (vec1.generic[32] + vec2.generic[32]);
	vec1.generic[33] = (vec1.generic[33] + vec2.generic[33]);
	vec1.generic[34] = (vec1.generic[34] + vec2.generic[34]);
	vec1.generic[35] = (vec1.generic[35] + vec2.generic[35]);
	vec1.generic[36] = (vec1.generic[36] + vec2.generic[36]);
	vec1.generic[37] = (vec1.generic[37] + vec2.generic[37]);
	vec1.generic[38] = (vec1.generic[38] + vec2.generic[38]);
	vec1.generic[39] = (vec1.generic[39] + vec2.generic[39]);
	vec1.generic[40] = (vec1.generic[40] + vec2.generic[40]);
	vec1.generic[41] = (vec1.generic[41] + vec2.generic[41]);
	vec1.generic[42] = (vec1.generic[42] + vec2.generic[42]);
	vec1.generic[43] = (vec1.generic[43] + vec2.generic[43]);
	vec1.generic[44] = (vec1.generic[44] + vec2.generic[44]);
	vec1.generic[45] = (vec1.generic[45] + vec2.generic[45]);
	vec1.generic[46] = (vec1.generic[46] + vec2.generic[46]);
	vec1.generic[47] = (vec1.generic[47] + vec2.generic[47]);
	vec1.generic[48] = (vec1.generic[48] + vec2.generic[48]);
	vec1.generic[49] = (vec1.generic[49] + vec2.generic[49]);
	vec1.generic[50] = (vec1.generic[50] + vec2.generic[50]);
	vec1.generic[51] = (vec1.generic[51] + vec2.generic[51]);
	vec1.generic[52] = (vec1.generic[52] + vec2.generic[52]);
	vec1.generic[53] = (vec1.generic[53] + vec2.generic[53]);
	vec1.generic[54] = (vec1.generic[54] + vec2.generic[54]);
	vec1.generic[55] = (vec1.generic[55] + vec2.generic[55]);
	vec1.generic[56] = (vec1.generic[56] + vec2.generic[56]);
	vec1.generic[57] = (vec1.generic[57] + vec2.generic[57]);
	vec1.generic[58] = (vec1.generic[58] + vec2.generic[58]);
	vec1.generic[59] = (vec1.generic[59] + vec2.generic[59]);
	vec1.generic[60] = (vec1.generic[60] + vec2.generic[60]);
	vec1.generic[61] = (vec1.generic[61] + vec2.generic[61]);
	vec1.generic[62] = (vec1.generic[62] + vec2.generic[62]);
	vec1.generic[63] = (vec1.generic[63] + vec2.generic[63]);
	return vec1;
}
# define VUINT8x64_ADD_DEFINED
#endif
#if !defined(VUINT8x64_SUB_DEFINED)
VEC_FUNC_IMPL vuint8x64 vuint8x64_sub(vuint8x64 vec1, vuint8x64 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] - vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] - vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] - vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] - vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] - vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] - vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] - vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] - vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] - vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] - vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] - vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] - vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] - vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] - vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] - vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] - vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] - vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] - vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] - vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] - vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] - vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] - vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] - vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] - vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] - vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] - vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] - vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] - vec2.generic[31]);
	vec1.generic[32] = (vec1.generic[32] - vec2.generic[32]);
	vec1.generic[33] = (vec1.generic[33] - vec2.generic[33]);
	vec1.generic[34] = (vec1.generic[34] - vec2.generic[34]);
	vec1.generic[35] = (vec1.generic[35] - vec2.generic[35]);
	vec1.generic[36] = (vec1.generic[36] - vec2.generic[36]);
	vec1.generic[37] = (vec1.generic[37] - vec2.generic[37]);
	vec1.generic[38] = (vec1.generic[38] - vec2.generic[38]);
	vec1.generic[39] = (vec1.generic[39] - vec2.generic[39]);
	vec1.generic[40] = (vec1.generic[40] - vec2.generic[40]);
	vec1.generic[41] = (vec1.generic[41] - vec2.generic[41]);
	vec1.generic[42] = (vec1.generic[42] - vec2.generic[42]);
	vec1.generic[43] = (vec1.generic[43] - vec2.generic[43]);
	vec1.generic[44] = (vec1.generic[44] - vec2.generic[44]);
	vec1.generic[45] = (vec1.generic[45] - vec2.generic[45]);
	vec1.generic[46] = (vec1.generic[46] - vec2.generic[46]);
	vec1.generic[47] = (vec1.generic[47] - vec2.generic[47]);
	vec1.generic[48] = (vec1.generic[48] - vec2.generic[48]);
	vec1.generic[49] = (vec1.generic[49] - vec2.generic[49]);
	vec1.generic[50] = (vec1.generic[50] - vec2.generic[50]);
	vec1.generic[51] = (vec1.generic[51] - vec2.generic[51]);
	vec1.generic[52] = (vec1.generic[52] - vec2.generic[52]);
	vec1.generic[53] = (vec1.generic[53] - vec2.generic[53]);
	vec1.generic[54] = (vec1.generic[54] - vec2.generic[54]);
	vec1.generic[55] = (vec1.generic[55] - vec2.generic[55]);
	vec1.generic[56] = (vec1.generic[56] - vec2.generic[56]);
	vec1.generic[57] = (vec1.generic[57] - vec2.generic[57]);
	vec1.generic[58] = (vec1.generic[58] - vec2.generic[58]);
	vec1.generic[59] = (vec1.generic[59] - vec2.generic[59]);
	vec1.generic[60] = (vec1.generic[60] - vec2.generic[60]);
	vec1.generic[61] = (vec1.generic[61] - vec2.generic[61]);
	vec1.generic[62] = (vec1.generic[62] - vec2.generic[62]);
	vec1.generic[63] = (vec1.generic[63] - vec2.generic[63]);
	return vec1;
}
# define VUINT8x64_SUB_DEFINED
#endif
#if !defined(VUINT8x64_MUL_DEFINED)
VEC_FUNC_IMPL vuint8x64 vuint8x64_mul(vuint8x64 vec1, vuint8x64 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] * vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] * vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] * vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] * vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] * vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] * vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] * vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] * vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] * vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] * vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] * vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] * vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] * vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] * vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] * vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] * vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] * vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] * vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] * vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] * vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] * vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] * vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] * vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] * vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] * vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] * vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] * vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] * vec2.generic[31]);
	vec1.generic[32] = (vec1.generic[32] * vec2.generic[32]);
	vec1.generic[33] = (vec1.generic[33] * vec2.generic[33]);
	vec1.generic[34] = (vec1.generic[34] * vec2.generic[34]);
	vec1.generic[35] = (vec1.generic[35] * vec2.generic[35]);
	vec1.generic[36] = (vec1.generic[36] * vec2.generic[36]);
	vec1.generic[37] = (vec1.generic[37] * vec2.generic[37]);
	vec1.generic[38] = (vec1.generic[38] * vec2.generic[38]);
	vec1.generic[39] = (vec1.generic[39] * vec2.generic[39]);
	vec1.generic[40] = (vec1.generic[40] * vec2.generic[40]);
	vec1.generic[41] = (vec1.generic[41] * vec2.generic[41]);
	vec1.generic[42] = (vec1.generic[42] * vec2.generic[42]);
	vec1.generic[43] = (vec1.generic[43] * vec2.generic[43]);
	vec1.generic[44] = (vec1.generic[44] * vec2.generic[44]);
	vec1.generic[45] = (vec1.generic[45] * vec2.generic[45]);
	vec1.generic[46] = (vec1.generic[46] * vec2.generic[46]);
	vec1.generic[47] = (vec1.generic[47] * vec2.generic[47]);
	vec1.generic[48] = (vec1.generic[48] * vec2.generic[48]);
	vec1.generic[49] = (vec1.generic[49] * vec2.generic[49]);
	vec1.generic[50] = (vec1.generic[50] * vec2.generic[50]);
	vec1.generic[51] = (vec1.generic[51] * vec2.generic[51]);
	vec1.generic[52] = (vec1.generic[52] * vec2.generic[52]);
	vec1.generic[53] = (vec1.generic[53] * vec2.generic[53]);
	vec1.generic[54] = (vec1.generic[54] * vec2.generic[54]);
	vec1.generic[55] = (vec1.generic[55] * vec2.generic[55]);
	vec1.generic[56] = (vec1.generic[56] * vec2.generic[56]);
	vec1.generic[57] = (vec1.generic[57] * vec2.generic[57]);
	vec1.generic[58] = (vec1.generic[58] * vec2.generic[58]);
	vec1.generic[59] = (vec1.generic[59] * vec2.generic[59]);
	vec1.generic[60] = (vec1.generic[60] * vec2.generic[60]);
	vec1.generic[61] = (vec1.generic[61] * vec2.generic[61]);
	vec1.generic[62] = (vec1.generic[62] * vec2.generic[62]);
	vec1.generic[63] = (vec1.generic[63] * vec2.generic[63]);
	return vec1;
}
# define VUINT8x64_MUL_DEFINED
#endif
#if !defined(VUINT8x64_DIV_DEFINED)
VEC_FUNC_IMPL vuint8x64 vuint8x64_div(vuint8x64 vec1, vuint8x64 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] / vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] / vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] / vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] / vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? (vec1.generic[8] / vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? (vec1.generic[9] / vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? (vec1.generic[10] / vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? (vec1.generic[11] / vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? (vec1.generic[12] / vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? (vec1.generic[13] / vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? (vec1.generic[14] / vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? (vec1.generic[15] / vec2.generic[15]) : 0);
	vec1.generic[16] = (vec2.generic[16] ? (vec1.generic[16] / vec2.generic[16]) : 0);
	vec1.generic[17] = (vec2.generic[17] ? (vec1.generic[17] / vec2.generic[17]) : 0);
	vec1.generic[18] = (vec2.generic[18] ? (vec1.generic[18] / vec2.generic[18]) : 0);
	vec1.generic[19] = (vec2.generic[19] ? (vec1.generic[19] / vec2.generic[19]) : 0);
	vec1.generic[20] = (vec2.generic[20] ? (vec1.generic[20] / vec2.generic[20]) : 0);
	vec1.generic[21] = (vec2.generic[21] ? (vec1.generic[21] / vec2.generic[21]) : 0);
	vec1.generic[22] = (vec2.generic[22] ? (vec1.generic[22] / vec2.generic[22]) : 0);
	vec1.generic[23] = (vec2.generic[23] ? (vec1.generic[23] / vec2.generic[23]) : 0);
	vec1.generic[24] = (vec2.generic[24] ? (vec1.generic[24] / vec2.generic[24]) : 0);
	vec1.generic[25] = (vec2.generic[25] ? (vec1.generic[25] / vec2.generic[25]) : 0);
	vec1.generic[26] = (vec2.generic[26] ? (vec1.generic[26] / vec2.generic[26]) : 0);
	vec1.generic[27] = (vec2.generic[27] ? (vec1.generic[27] / vec2.generic[27]) : 0);
	vec1.generic[28] = (vec2.generic[28] ? (vec1.generic[28] / vec2.generic[28]) : 0);
	vec1.generic[29] = (vec2.generic[29] ? (vec1.generic[29] / vec2.generic[29]) : 0);
	vec1.generic[30] = (vec2.generic[30] ? (vec1.generic[30] / vec2.generic[30]) : 0);
	vec1.generic[31] = (vec2.generic[31] ? (vec1.generic[31] / vec2.generic[31]) : 0);
	vec1.generic[32] = (vec2.generic[32] ? (vec1.generic[32] / vec2.generic[32]) : 0);
	vec1.generic[33] = (vec2.generic[33] ? (vec1.generic[33] / vec2.generic[33]) : 0);
	vec1.generic[34] = (vec2.generic[34] ? (vec1.generic[34] / vec2.generic[34]) : 0);
	vec1.generic[35] = (vec2.generic[35] ? (vec1.generic[35] / vec2.generic[35]) : 0);
	vec1.generic[36] = (vec2.generic[36] ? (vec1.generic[36] / vec2.generic[36]) : 0);
	vec1.generic[37] = (vec2.generic[37] ? (vec1.generic[37] / vec2.generic[37]) : 0);
	vec1.generic[38] = (vec2.generic[38] ? (vec1.generic[38] / vec2.generic[38]) : 0);
	vec1.generic[39] = (vec2.generic[39] ? (vec1.generic[39] / vec2.generic[39]) : 0);
	vec1.generic[40] = (vec2.generic[40] ? (vec1.generic[40] / vec2.generic[40]) : 0);
	vec1.generic[41] = (vec2.generic[41] ? (vec1.generic[41] / vec2.generic[41]) : 0);
	vec1.generic[42] = (vec2.generic[42] ? (vec1.generic[42] / vec2.generic[42]) : 0);
	vec1.generic[43] = (vec2.generic[43] ? (vec1.generic[43] / vec2.generic[43]) : 0);
	vec1.generic[44] = (vec2.generic[44] ? (vec1.generic[44] / vec2.generic[44]) : 0);
	vec1.generic[45] = (vec2.generic[45] ? (vec1.generic[45] / vec2.generic[45]) : 0);
	vec1.generic[46] = (vec2.generic[46] ? (vec1.generic[46] / vec2.generic[46]) : 0);
	vec1.generic[47] = (vec2.generic[47] ? (vec1.generic[47] / vec2.generic[47]) : 0);
	vec1.generic[48] = (vec2.generic[48] ? (vec1.generic[48] / vec2.generic[48]) : 0);
	vec1.generic[49] = (vec2.generic[49] ? (vec1.generic[49] / vec2.generic[49]) : 0);
	vec1.generic[50] = (vec2.generic[50] ? (vec1.generic[50] / vec2.generic[50]) : 0);
	vec1.generic[51] = (vec2.generic[51] ? (vec1.generic[51] / vec2.generic[51]) : 0);
	vec1.generic[52] = (vec2.generic[52] ? (vec1.generic[52] / vec2.generic[52]) : 0);
	vec1.generic[53] = (vec2.generic[53] ? (vec1.generic[53] / vec2.generic[53]) : 0);
	vec1.generic[54] = (vec2.generic[54] ? (vec1.generic[54] / vec2.generic[54]) : 0);
	vec1.generic[55] = (vec2.generic[55] ? (vec1.generic[55] / vec2.generic[55]) : 0);
	vec1.generic[56] = (vec2.generic[56] ? (vec1.generic[56] / vec2.generic[56]) : 0);
	vec1.generic[57] = (vec2.generic[57] ? (vec1.generic[57] / vec2.generic[57]) : 0);
	vec1.generic[58] = (vec2.generic[58] ? (vec1.generic[58] / vec2.generic[58]) : 0);
	vec1.generic[59] = (vec2.generic[59] ? (vec1.generic[59] / vec2.generic[59]) : 0);
	vec1.generic[60] = (vec2.generic[60] ? (vec1.generic[60] / vec2.generic[60]) : 0);
	vec1.generic[61] = (vec2.generic[61] ? (vec1.generic[61] / vec2.generic[61]) : 0);
	vec1.generic[62] = (vec2.generic[62] ? (vec1.generic[62] / vec2.generic[62]) : 0);
	vec1.generic[63] = (vec2.generic[63] ? (vec1.generic[63] / vec2.generic[63]) : 0);
	return vec1;
}
# define VUINT8x64_DIV_DEFINED
#endif
#if !defined(VUINT8x64_MOD_DEFINED)
VEC_FUNC_IMPL vuint8x64 vuint8x64_mod(vuint8x64 vec1, vuint8x64 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] % vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] % vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] % vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] % vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? (vec1.generic[8] % vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? (vec1.generic[9] % vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? (vec1.generic[10] % vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? (vec1.generic[11] % vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? (vec1.generic[12] % vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? (vec1.generic[13] % vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? (vec1.generic[14] % vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? (vec1.generic[15] % vec2.generic[15]) : 0);
	vec1.generic[16] = (vec2.generic[16] ? (vec1.generic[16] % vec2.generic[16]) : 0);
	vec1.generic[17] = (vec2.generic[17] ? (vec1.generic[17] % vec2.generic[17]) : 0);
	vec1.generic[18] = (vec2.generic[18] ? (vec1.generic[18] % vec2.generic[18]) : 0);
	vec1.generic[19] = (vec2.generic[19] ? (vec1.generic[19] % vec2.generic[19]) : 0);
	vec1.generic[20] = (vec2.generic[20] ? (vec1.generic[20] % vec2.generic[20]) : 0);
	vec1.generic[21] = (vec2.generic[21] ? (vec1.generic[21] % vec2.generic[21]) : 0);
	vec1.generic[22] = (vec2.generic[22] ? (vec1.generic[22] % vec2.generic[22]) : 0);
	vec1.generic[23] = (vec2.generic[23] ? (vec1.generic[23] % vec2.generic[23]) : 0);
	vec1.generic[24] = (vec2.generic[24] ? (vec1.generic[24] % vec2.generic[24]) : 0);
	vec1.generic[25] = (vec2.generic[25] ? (vec1.generic[25] % vec2.generic[25]) : 0);
	vec1.generic[26] = (vec2.generic[26] ? (vec1.generic[26] % vec2.generic[26]) : 0);
	vec1.generic[27] = (vec2.generic[27] ? (vec1.generic[27] % vec2.generic[27]) : 0);
	vec1.generic[28] = (vec2.generic[28] ? (vec1.generic[28] % vec2.generic[28]) : 0);
	vec1.generic[29] = (vec2.generic[29] ? (vec1.generic[29] % vec2.generic[29]) : 0);
	vec1.generic[30] = (vec2.generic[30] ? (vec1.generic[30] % vec2.generic[30]) : 0);
	vec1.generic[31] = (vec2.generic[31] ? (vec1.generic[31] % vec2.generic[31]) : 0);
	vec1.generic[32] = (vec2.generic[32] ? (vec1.generic[32] % vec2.generic[32]) : 0);
	vec1.generic[33] = (vec2.generic[33] ? (vec1.generic[33] % vec2.generic[33]) : 0);
	vec1.generic[34] = (vec2.generic[34] ? (vec1.generic[34] % vec2.generic[34]) : 0);
	vec1.generic[35] = (vec2.generic[35] ? (vec1.generic[35] % vec2.generic[35]) : 0);
	vec1.generic[36] = (vec2.generic[36] ? (vec1.generic[36] % vec2.generic[36]) : 0);
	vec1.generic[37] = (vec2.generic[37] ? (vec1.generic[37] % vec2.generic[37]) : 0);
	vec1.generic[38] = (vec2.generic[38] ? (vec1.generic[38] % vec2.generic[38]) : 0);
	vec1.generic[39] = (vec2.generic[39] ? (vec1.generic[39] % vec2.generic[39]) : 0);
	vec1.generic[40] = (vec2.generic[40] ? (vec1.generic[40] % vec2.generic[40]) : 0);
	vec1.generic[41] = (vec2.generic[41] ? (vec1.generic[41] % vec2.generic[41]) : 0);
	vec1.generic[42] = (vec2.generic[42] ? (vec1.generic[42] % vec2.generic[42]) : 0);
	vec1.generic[43] = (vec2.generic[43] ? (vec1.generic[43] % vec2.generic[43]) : 0);
	vec1.generic[44] = (vec2.generic[44] ? (vec1.generic[44] % vec2.generic[44]) : 0);
	vec1.generic[45] = (vec2.generic[45] ? (vec1.generic[45] % vec2.generic[45]) : 0);
	vec1.generic[46] = (vec2.generic[46] ? (vec1.generic[46] % vec2.generic[46]) : 0);
	vec1.generic[47] = (vec2.generic[47] ? (vec1.generic[47] % vec2.generic[47]) : 0);
	vec1.generic[48] = (vec2.generic[48] ? (vec1.generic[48] % vec2.generic[48]) : 0);
	vec1.generic[49] = (vec2.generic[49] ? (vec1.generic[49] % vec2.generic[49]) : 0);
	vec1.generic[50] = (vec2.generic[50] ? (vec1.generic[50] % vec2.generic[50]) : 0);
	vec1.generic[51] = (vec2.generic[51] ? (vec1.generic[51] % vec2.generic[51]) : 0);
	vec1.generic[52] = (vec2.generic[52] ? (vec1.generic[52] % vec2.generic[52]) : 0);
	vec1.generic[53] = (vec2.generic[53] ? (vec1.generic[53] % vec2.generic[53]) : 0);
	vec1.generic[54] = (vec2.generic[54] ? (vec1.generic[54] % vec2.generic[54]) : 0);
	vec1.generic[55] = (vec2.generic[55] ? (vec1.generic[55] % vec2.generic[55]) : 0);
	vec1.generic[56] = (vec2.generic[56] ? (vec1.generic[56] % vec2.generic[56]) : 0);
	vec1.generic[57] = (vec2.generic[57] ? (vec1.generic[57] % vec2.generic[57]) : 0);
	vec1.generic[58] = (vec2.generic[58] ? (vec1.generic[58] % vec2.generic[58]) : 0);
	vec1.generic[59] = (vec2.generic[59] ? (vec1.generic[59] % vec2.generic[59]) : 0);
	vec1.generic[60] = (vec2.generic[60] ? (vec1.generic[60] % vec2.generic[60]) : 0);
	vec1.generic[61] = (vec2.generic[61] ? (vec1.generic[61] % vec2.generic[61]) : 0);
	vec1.generic[62] = (vec2.generic[62] ? (vec1.generic[62] % vec2.generic[62]) : 0);
	vec1.generic[63] = (vec2.generic[63] ? (vec1.generic[63] % vec2.generic[63]) : 0);
	return vec1;
}
# define VUINT8x64_MOD_DEFINED
#endif
#if !defined(VUINT8x64_AVG_DEFINED)
VEC_FUNC_IMPL vuint8x64 vuint8x64_avg(vuint8x64 vec1, vuint8x64 vec2)
{
vec1.generic[0] = (vec1.generic[0] >> 1) + (vec2.generic[0] >> 1) + ((vec1.generic[0] | vec2.generic[0]) & 1);
vec1.generic[1] = (vec1.generic[1] >> 1) + (vec2.generic[1] >> 1) + ((vec1.generic[1] | vec2.generic[1]) & 1);
vec1.generic[2] = (vec1.generic[2] >> 1) + (vec2.generic[2] >> 1) + ((vec1.generic[2] | vec2.generic[2]) & 1);
vec1.generic[3] = (vec1.generic[3] >> 1) + (vec2.generic[3] >> 1) + ((vec1.generic[3] | vec2.generic[3]) & 1);
vec1.generic[4] = (vec1.generic[4] >> 1) + (vec2.generic[4] >> 1) + ((vec1.generic[4] | vec2.generic[4]) & 1);
vec1.generic[5] = (vec1.generic[5] >> 1) + (vec2.generic[5] >> 1) + ((vec1.generic[5] | vec2.generic[5]) & 1);
vec1.generic[6] = (vec1.generic[6] >> 1) + (vec2.generic[6] >> 1) + ((vec1.generic[6] | vec2.generic[6]) & 1);
vec1.generic[7] = (vec1.generic[7] >> 1) + (vec2.generic[7] >> 1) + ((vec1.generic[7] | vec2.generic[7]) & 1);
vec1.generic[8] = (vec1.generic[8] >> 1) + (vec2.generic[8] >> 1) + ((vec1.generic[8] | vec2.generic[8]) & 1);
vec1.generic[9] = (vec1.generic[9] >> 1) + (vec2.generic[9] >> 1) + ((vec1.generic[9] | vec2.generic[9]) & 1);
vec1.generic[10] = (vec1.generic[10] >> 1) + (vec2.generic[10] >> 1) + ((vec1.generic[10] | vec2.generic[10]) & 1);
vec1.generic[11] = (vec1.generic[11] >> 1) + (vec2.generic[11] >> 1) + ((vec1.generic[11] | vec2.generic[11]) & 1);
vec1.generic[12] = (vec1.generic[12] >> 1) + (vec2.generic[12] >> 1) + ((vec1.generic[12] | vec2.generic[12]) & 1);
vec1.generic[13] = (vec1.generic[13] >> 1) + (vec2.generic[13] >> 1) + ((vec1.generic[13] | vec2.generic[13]) & 1);
vec1.generic[14] = (vec1.generic[14] >> 1) + (vec2.generic[14] >> 1) + ((vec1.generic[14] | vec2.generic[14]) & 1);
vec1.generic[15] = (vec1.generic[15] >> 1) + (vec2.generic[15] >> 1) + ((vec1.generic[15] | vec2.generic[15]) & 1);
vec1.generic[16] = (vec1.generic[16] >> 1) + (vec2.generic[16] >> 1) + ((vec1.generic[16] | vec2.generic[16]) & 1);
vec1.generic[17] = (vec1.generic[17] >> 1) + (vec2.generic[17] >> 1) + ((vec1.generic[17] | vec2.generic[17]) & 1);
vec1.generic[18] = (vec1.generic[18] >> 1) + (vec2.generic[18] >> 1) + ((vec1.generic[18] | vec2.generic[18]) & 1);
vec1.generic[19] = (vec1.generic[19] >> 1) + (vec2.generic[19] >> 1) + ((vec1.generic[19] | vec2.generic[19]) & 1);
vec1.generic[20] = (vec1.generic[20] >> 1) + (vec2.generic[20] >> 1) + ((vec1.generic[20] | vec2.generic[20]) & 1);
vec1.generic[21] = (vec1.generic[21] >> 1) + (vec2.generic[21] >> 1) + ((vec1.generic[21] | vec2.generic[21]) & 1);
vec1.generic[22] = (vec1.generic[22] >> 1) + (vec2.generic[22] >> 1) + ((vec1.generic[22] | vec2.generic[22]) & 1);
vec1.generic[23] = (vec1.generic[23] >> 1) + (vec2.generic[23] >> 1) + ((vec1.generic[23] | vec2.generic[23]) & 1);
vec1.generic[24] = (vec1.generic[24] >> 1) + (vec2.generic[24] >> 1) + ((vec1.generic[24] | vec2.generic[24]) & 1);
vec1.generic[25] = (vec1.generic[25] >> 1) + (vec2.generic[25] >> 1) + ((vec1.generic[25] | vec2.generic[25]) & 1);
vec1.generic[26] = (vec1.generic[26] >> 1) + (vec2.generic[26] >> 1) + ((vec1.generic[26] | vec2.generic[26]) & 1);
vec1.generic[27] = (vec1.generic[27] >> 1) + (vec2.generic[27] >> 1) + ((vec1.generic[27] | vec2.generic[27]) & 1);
vec1.generic[28] = (vec1.generic[28] >> 1) + (vec2.generic[28] >> 1) + ((vec1.generic[28] | vec2.generic[28]) & 1);
vec1.generic[29] = (vec1.generic[29] >> 1) + (vec2.generic[29] >> 1) + ((vec1.generic[29] | vec2.generic[29]) & 1);
vec1.generic[30] = (vec1.generic[30] >> 1) + (vec2.generic[30] >> 1) + ((vec1.generic[30] | vec2.generic[30]) & 1);
vec1.generic[31] = (vec1.generic[31] >> 1) + (vec2.generic[31] >> 1) + ((vec1.generic[31] | vec2.generic[31]) & 1);
vec1.generic[32] = (vec1.generic[32] >> 1) + (vec2.generic[32] >> 1) + ((vec1.generic[32] | vec2.generic[32]) & 1);
vec1.generic[33] = (vec1.generic[33] >> 1) + (vec2.generic[33] >> 1) + ((vec1.generic[33] | vec2.generic[33]) & 1);
vec1.generic[34] = (vec1.generic[34] >> 1) + (vec2.generic[34] >> 1) + ((vec1.generic[34] | vec2.generic[34]) & 1);
vec1.generic[35] = (vec1.generic[35] >> 1) + (vec2.generic[35] >> 1) + ((vec1.generic[35] | vec2.generic[35]) & 1);
vec1.generic[36] = (vec1.generic[36] >> 1) + (vec2.generic[36] >> 1) + ((vec1.generic[36] | vec2.generic[36]) & 1);
vec1.generic[37] = (vec1.generic[37] >> 1) + (vec2.generic[37] >> 1) + ((vec1.generic[37] | vec2.generic[37]) & 1);
vec1.generic[38] = (vec1.generic[38] >> 1) + (vec2.generic[38] >> 1) + ((vec1.generic[38] | vec2.generic[38]) & 1);
vec1.generic[39] = (vec1.generic[39] >> 1) + (vec2.generic[39] >> 1) + ((vec1.generic[39] | vec2.generic[39]) & 1);
vec1.generic[40] = (vec1.generic[40] >> 1) + (vec2.generic[40] >> 1) + ((vec1.generic[40] | vec2.generic[40]) & 1);
vec1.generic[41] = (vec1.generic[41] >> 1) + (vec2.generic[41] >> 1) + ((vec1.generic[41] | vec2.generic[41]) & 1);
vec1.generic[42] = (vec1.generic[42] >> 1) + (vec2.generic[42] >> 1) + ((vec1.generic[42] | vec2.generic[42]) & 1);
vec1.generic[43] = (vec1.generic[43] >> 1) + (vec2.generic[43] >> 1) + ((vec1.generic[43] | vec2.generic[43]) & 1);
vec1.generic[44] = (vec1.generic[44] >> 1) + (vec2.generic[44] >> 1) + ((vec1.generic[44] | vec2.generic[44]) & 1);
vec1.generic[45] = (vec1.generic[45] >> 1) + (vec2.generic[45] >> 1) + ((vec1.generic[45] | vec2.generic[45]) & 1);
vec1.generic[46] = (vec1.generic[46] >> 1) + (vec2.generic[46] >> 1) + ((vec1.generic[46] | vec2.generic[46]) & 1);
vec1.generic[47] = (vec1.generic[47] >> 1) + (vec2.generic[47] >> 1) + ((vec1.generic[47] | vec2.generic[47]) & 1);
vec1.generic[48] = (vec1.generic[48] >> 1) + (vec2.generic[48] >> 1) + ((vec1.generic[48] | vec2.generic[48]) & 1);
vec1.generic[49] = (vec1.generic[49] >> 1) + (vec2.generic[49] >> 1) + ((vec1.generic[49] | vec2.generic[49]) & 1);
vec1.generic[50] = (vec1.generic[50] >> 1) + (vec2.generic[50] >> 1) + ((vec1.generic[50] | vec2.generic[50]) & 1);
vec1.generic[51] = (vec1.generic[51] >> 1) + (vec2.generic[51] >> 1) + ((vec1.generic[51] | vec2.generic[51]) & 1);
vec1.generic[52] = (vec1.generic[52] >> 1) + (vec2.generic[52] >> 1) + ((vec1.generic[52] | vec2.generic[52]) & 1);
vec1.generic[53] = (vec1.generic[53] >> 1) + (vec2.generic[53] >> 1) + ((vec1.generic[53] | vec2.generic[53]) & 1);
vec1.generic[54] = (vec1.generic[54] >> 1) + (vec2.generic[54] >> 1) + ((vec1.generic[54] | vec2.generic[54]) & 1);
vec1.generic[55] = (vec1.generic[55] >> 1) + (vec2.generic[55] >> 1) + ((vec1.generic[55] | vec2.generic[55]) & 1);
vec1.generic[56] = (vec1.generic[56] >> 1) + (vec2.generic[56] >> 1) + ((vec1.generic[56] | vec2.generic[56]) & 1);
vec1.generic[57] = (vec1.generic[57] >> 1) + (vec2.generic[57] >> 1) + ((vec1.generic[57] | vec2.generic[57]) & 1);
vec1.generic[58] = (vec1.generic[58] >> 1) + (vec2.generic[58] >> 1) + ((vec1.generic[58] | vec2.generic[58]) & 1);
vec1.generic[59] = (vec1.generic[59] >> 1) + (vec2.generic[59] >> 1) + ((vec1.generic[59] | vec2.generic[59]) & 1);
vec1.generic[60] = (vec1.generic[60] >> 1) + (vec2.generic[60] >> 1) + ((vec1.generic[60] | vec2.generic[60]) & 1);
vec1.generic[61] = (vec1.generic[61] >> 1) + (vec2.generic[61] >> 1) + ((vec1.generic[61] | vec2.generic[61]) & 1);
vec1.generic[62] = (vec1.generic[62] >> 1) + (vec2.generic[62] >> 1) + ((vec1.generic[62] | vec2.generic[62]) & 1);
vec1.generic[63] = (vec1.generic[63] >> 1) + (vec2.generic[63] >> 1) + ((vec1.generic[63] | vec2.generic[63]) & 1);
	return vec1;
}
# define VUINT8x64_AVG_DEFINED
#endif
#if !defined(VUINT8x64_AND_DEFINED)
VEC_FUNC_IMPL vuint8x64 vuint8x64_and(vuint8x64 vec1, vuint8x64 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] & vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] & vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] & vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] & vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] & vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] & vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] & vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] & vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] & vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] & vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] & vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] & vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] & vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] & vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] & vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] & vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] & vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] & vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] & vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] & vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] & vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] & vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] & vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] & vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] & vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] & vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] & vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] & vec2.generic[31]);
	vec1.generic[32] = (vec1.generic[32] & vec2.generic[32]);
	vec1.generic[33] = (vec1.generic[33] & vec2.generic[33]);
	vec1.generic[34] = (vec1.generic[34] & vec2.generic[34]);
	vec1.generic[35] = (vec1.generic[35] & vec2.generic[35]);
	vec1.generic[36] = (vec1.generic[36] & vec2.generic[36]);
	vec1.generic[37] = (vec1.generic[37] & vec2.generic[37]);
	vec1.generic[38] = (vec1.generic[38] & vec2.generic[38]);
	vec1.generic[39] = (vec1.generic[39] & vec2.generic[39]);
	vec1.generic[40] = (vec1.generic[40] & vec2.generic[40]);
	vec1.generic[41] = (vec1.generic[41] & vec2.generic[41]);
	vec1.generic[42] = (vec1.generic[42] & vec2.generic[42]);
	vec1.generic[43] = (vec1.generic[43] & vec2.generic[43]);
	vec1.generic[44] = (vec1.generic[44] & vec2.generic[44]);
	vec1.generic[45] = (vec1.generic[45] & vec2.generic[45]);
	vec1.generic[46] = (vec1.generic[46] & vec2.generic[46]);
	vec1.generic[47] = (vec1.generic[47] & vec2.generic[47]);
	vec1.generic[48] = (vec1.generic[48] & vec2.generic[48]);
	vec1.generic[49] = (vec1.generic[49] & vec2.generic[49]);
	vec1.generic[50] = (vec1.generic[50] & vec2.generic[50]);
	vec1.generic[51] = (vec1.generic[51] & vec2.generic[51]);
	vec1.generic[52] = (vec1.generic[52] & vec2.generic[52]);
	vec1.generic[53] = (vec1.generic[53] & vec2.generic[53]);
	vec1.generic[54] = (vec1.generic[54] & vec2.generic[54]);
	vec1.generic[55] = (vec1.generic[55] & vec2.generic[55]);
	vec1.generic[56] = (vec1.generic[56] & vec2.generic[56]);
	vec1.generic[57] = (vec1.generic[57] & vec2.generic[57]);
	vec1.generic[58] = (vec1.generic[58] & vec2.generic[58]);
	vec1.generic[59] = (vec1.generic[59] & vec2.generic[59]);
	vec1.generic[60] = (vec1.generic[60] & vec2.generic[60]);
	vec1.generic[61] = (vec1.generic[61] & vec2.generic[61]);
	vec1.generic[62] = (vec1.generic[62] & vec2.generic[62]);
	vec1.generic[63] = (vec1.generic[63] & vec2.generic[63]);
	return vec1;
}
# define VUINT8x64_AND_DEFINED
#endif
#if !defined(VUINT8x64_OR_DEFINED)
VEC_FUNC_IMPL vuint8x64 vuint8x64_or(vuint8x64 vec1, vuint8x64 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] | vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] | vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] | vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] | vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] | vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] | vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] | vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] | vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] | vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] | vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] | vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] | vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] | vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] | vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] | vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] | vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] | vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] | vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] | vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] | vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] | vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] | vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] | vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] | vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] | vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] | vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] | vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] | vec2.generic[31]);
	vec1.generic[32] = (vec1.generic[32] | vec2.generic[32]);
	vec1.generic[33] = (vec1.generic[33] | vec2.generic[33]);
	vec1.generic[34] = (vec1.generic[34] | vec2.generic[34]);
	vec1.generic[35] = (vec1.generic[35] | vec2.generic[35]);
	vec1.generic[36] = (vec1.generic[36] | vec2.generic[36]);
	vec1.generic[37] = (vec1.generic[37] | vec2.generic[37]);
	vec1.generic[38] = (vec1.generic[38] | vec2.generic[38]);
	vec1.generic[39] = (vec1.generic[39] | vec2.generic[39]);
	vec1.generic[40] = (vec1.generic[40] | vec2.generic[40]);
	vec1.generic[41] = (vec1.generic[41] | vec2.generic[41]);
	vec1.generic[42] = (vec1.generic[42] | vec2.generic[42]);
	vec1.generic[43] = (vec1.generic[43] | vec2.generic[43]);
	vec1.generic[44] = (vec1.generic[44] | vec2.generic[44]);
	vec1.generic[45] = (vec1.generic[45] | vec2.generic[45]);
	vec1.generic[46] = (vec1.generic[46] | vec2.generic[46]);
	vec1.generic[47] = (vec1.generic[47] | vec2.generic[47]);
	vec1.generic[48] = (vec1.generic[48] | vec2.generic[48]);
	vec1.generic[49] = (vec1.generic[49] | vec2.generic[49]);
	vec1.generic[50] = (vec1.generic[50] | vec2.generic[50]);
	vec1.generic[51] = (vec1.generic[51] | vec2.generic[51]);
	vec1.generic[52] = (vec1.generic[52] | vec2.generic[52]);
	vec1.generic[53] = (vec1.generic[53] | vec2.generic[53]);
	vec1.generic[54] = (vec1.generic[54] | vec2.generic[54]);
	vec1.generic[55] = (vec1.generic[55] | vec2.generic[55]);
	vec1.generic[56] = (vec1.generic[56] | vec2.generic[56]);
	vec1.generic[57] = (vec1.generic[57] | vec2.generic[57]);
	vec1.generic[58] = (vec1.generic[58] | vec2.generic[58]);
	vec1.generic[59] = (vec1.generic[59] | vec2.generic[59]);
	vec1.generic[60] = (vec1.generic[60] | vec2.generic[60]);
	vec1.generic[61] = (vec1.generic[61] | vec2.generic[61]);
	vec1.generic[62] = (vec1.generic[62] | vec2.generic[62]);
	vec1.generic[63] = (vec1.generic[63] | vec2.generic[63]);
	return vec1;
}
# define VUINT8x64_OR_DEFINED
#endif
#if !defined(VUINT8x64_XOR_DEFINED)
VEC_FUNC_IMPL vuint8x64 vuint8x64_xor(vuint8x64 vec1, vuint8x64 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] ^ vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] ^ vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] ^ vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] ^ vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] ^ vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] ^ vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] ^ vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] ^ vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] ^ vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] ^ vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] ^ vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] ^ vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] ^ vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] ^ vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] ^ vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] ^ vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] ^ vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] ^ vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] ^ vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] ^ vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] ^ vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] ^ vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] ^ vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] ^ vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] ^ vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] ^ vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] ^ vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] ^ vec2.generic[31]);
	vec1.generic[32] = (vec1.generic[32] ^ vec2.generic[32]);
	vec1.generic[33] = (vec1.generic[33] ^ vec2.generic[33]);
	vec1.generic[34] = (vec1.generic[34] ^ vec2.generic[34]);
	vec1.generic[35] = (vec1.generic[35] ^ vec2.generic[35]);
	vec1.generic[36] = (vec1.generic[36] ^ vec2.generic[36]);
	vec1.generic[37] = (vec1.generic[37] ^ vec2.generic[37]);
	vec1.generic[38] = (vec1.generic[38] ^ vec2.generic[38]);
	vec1.generic[39] = (vec1.generic[39] ^ vec2.generic[39]);
	vec1.generic[40] = (vec1.generic[40] ^ vec2.generic[40]);
	vec1.generic[41] = (vec1.generic[41] ^ vec2.generic[41]);
	vec1.generic[42] = (vec1.generic[42] ^ vec2.generic[42]);
	vec1.generic[43] = (vec1.generic[43] ^ vec2.generic[43]);
	vec1.generic[44] = (vec1.generic[44] ^ vec2.generic[44]);
	vec1.generic[45] = (vec1.generic[45] ^ vec2.generic[45]);
	vec1.generic[46] = (vec1.generic[46] ^ vec2.generic[46]);
	vec1.generic[47] = (vec1.generic[47] ^ vec2.generic[47]);
	vec1.generic[48] = (vec1.generic[48] ^ vec2.generic[48]);
	vec1.generic[49] = (vec1.generic[49] ^ vec2.generic[49]);
	vec1.generic[50] = (vec1.generic[50] ^ vec2.generic[50]);
	vec1.generic[51] = (vec1.generic[51] ^ vec2.generic[51]);
	vec1.generic[52] = (vec1.generic[52] ^ vec2.generic[52]);
	vec1.generic[53] = (vec1.generic[53] ^ vec2.generic[53]);
	vec1.generic[54] = (vec1.generic[54] ^ vec2.generic[54]);
	vec1.generic[55] = (vec1.generic[55] ^ vec2.generic[55]);
	vec1.generic[56] = (vec1.generic[56] ^ vec2.generic[56]);
	vec1.generic[57] = (vec1.generic[57] ^ vec2.generic[57]);
	vec1.generic[58] = (vec1.generic[58] ^ vec2.generic[58]);
	vec1.generic[59] = (vec1.generic[59] ^ vec2.generic[59]);
	vec1.generic[60] = (vec1.generic[60] ^ vec2.generic[60]);
	vec1.generic[61] = (vec1.generic[61] ^ vec2.generic[61]);
	vec1.generic[62] = (vec1.generic[62] ^ vec2.generic[62]);
	vec1.generic[63] = (vec1.generic[63] ^ vec2.generic[63]);
	return vec1;
}
# define VUINT8x64_XOR_DEFINED
#endif
#if !defined(VUINT8x64_NOT_DEFINED)
VEC_FUNC_IMPL vuint8x64 vuint8x64_not(vuint8x64 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	vec.generic[4] = ~vec.generic[4];
	vec.generic[5] = ~vec.generic[5];
	vec.generic[6] = ~vec.generic[6];
	vec.generic[7] = ~vec.generic[7];
	vec.generic[8] = ~vec.generic[8];
	vec.generic[9] = ~vec.generic[9];
	vec.generic[10] = ~vec.generic[10];
	vec.generic[11] = ~vec.generic[11];
	vec.generic[12] = ~vec.generic[12];
	vec.generic[13] = ~vec.generic[13];
	vec.generic[14] = ~vec.generic[14];
	vec.generic[15] = ~vec.generic[15];
	vec.generic[16] = ~vec.generic[16];
	vec.generic[17] = ~vec.generic[17];
	vec.generic[18] = ~vec.generic[18];
	vec.generic[19] = ~vec.generic[19];
	vec.generic[20] = ~vec.generic[20];
	vec.generic[21] = ~vec.generic[21];
	vec.generic[22] = ~vec.generic[22];
	vec.generic[23] = ~vec.generic[23];
	vec.generic[24] = ~vec.generic[24];
	vec.generic[25] = ~vec.generic[25];
	vec.generic[26] = ~vec.generic[26];
	vec.generic[27] = ~vec.generic[27];
	vec.generic[28] = ~vec.generic[28];
	vec.generic[29] = ~vec.generic[29];
	vec.generic[30] = ~vec.generic[30];
	vec.generic[31] = ~vec.generic[31];
	vec.generic[32] = ~vec.generic[32];
	vec.generic[33] = ~vec.generic[33];
	vec.generic[34] = ~vec.generic[34];
	vec.generic[35] = ~vec.generic[35];
	vec.generic[36] = ~vec.generic[36];
	vec.generic[37] = ~vec.generic[37];
	vec.generic[38] = ~vec.generic[38];
	vec.generic[39] = ~vec.generic[39];
	vec.generic[40] = ~vec.generic[40];
	vec.generic[41] = ~vec.generic[41];
	vec.generic[42] = ~vec.generic[42];
	vec.generic[43] = ~vec.generic[43];
	vec.generic[44] = ~vec.generic[44];
	vec.generic[45] = ~vec.generic[45];
	vec.generic[46] = ~vec.generic[46];
	vec.generic[47] = ~vec.generic[47];
	vec.generic[48] = ~vec.generic[48];
	vec.generic[49] = ~vec.generic[49];
	vec.generic[50] = ~vec.generic[50];
	vec.generic[51] = ~vec.generic[51];
	vec.generic[52] = ~vec.generic[52];
	vec.generic[53] = ~vec.generic[53];
	vec.generic[54] = ~vec.generic[54];
	vec.generic[55] = ~vec.generic[55];
	vec.generic[56] = ~vec.generic[56];
	vec.generic[57] = ~vec.generic[57];
	vec.generic[58] = ~vec.generic[58];
	vec.generic[59] = ~vec.generic[59];
	vec.generic[60] = ~vec.generic[60];
	vec.generic[61] = ~vec.generic[61];
	vec.generic[62] = ~vec.generic[62];
	vec.generic[63] = ~vec.generic[63];
	return vec;
}
# define VUINT8x64_NOT_DEFINED
#endif
#if !defined(VUINT8x64_CMPLT_DEFINED)
VEC_FUNC_IMPL vuint8x64 vuint8x64_cmplt(vuint8x64 vec1, vuint8x64 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] < vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] < vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] < vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] < vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] < vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] < vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] < vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] < vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] < vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] < vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] < vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] < vec2.generic[15]) ? 0xFF : 0, 1);
	memset(&vec1.generic[16], (vec1.generic[16] < vec2.generic[16]) ? 0xFF : 0, 1);
	memset(&vec1.generic[17], (vec1.generic[17] < vec2.generic[17]) ? 0xFF : 0, 1);
	memset(&vec1.generic[18], (vec1.generic[18] < vec2.generic[18]) ? 0xFF : 0, 1);
	memset(&vec1.generic[19], (vec1.generic[19] < vec2.generic[19]) ? 0xFF : 0, 1);
	memset(&vec1.generic[20], (vec1.generic[20] < vec2.generic[20]) ? 0xFF : 0, 1);
	memset(&vec1.generic[21], (vec1.generic[21] < vec2.generic[21]) ? 0xFF : 0, 1);
	memset(&vec1.generic[22], (vec1.generic[22] < vec2.generic[22]) ? 0xFF : 0, 1);
	memset(&vec1.generic[23], (vec1.generic[23] < vec2.generic[23]) ? 0xFF : 0, 1);
	memset(&vec1.generic[24], (vec1.generic[24] < vec2.generic[24]) ? 0xFF : 0, 1);
	memset(&vec1.generic[25], (vec1.generic[25] < vec2.generic[25]) ? 0xFF : 0, 1);
	memset(&vec1.generic[26], (vec1.generic[26] < vec2.generic[26]) ? 0xFF : 0, 1);
	memset(&vec1.generic[27], (vec1.generic[27] < vec2.generic[27]) ? 0xFF : 0, 1);
	memset(&vec1.generic[28], (vec1.generic[28] < vec2.generic[28]) ? 0xFF : 0, 1);
	memset(&vec1.generic[29], (vec1.generic[29] < vec2.generic[29]) ? 0xFF : 0, 1);
	memset(&vec1.generic[30], (vec1.generic[30] < vec2.generic[30]) ? 0xFF : 0, 1);
	memset(&vec1.generic[31], (vec1.generic[31] < vec2.generic[31]) ? 0xFF : 0, 1);
	memset(&vec1.generic[32], (vec1.generic[32] < vec2.generic[32]) ? 0xFF : 0, 1);
	memset(&vec1.generic[33], (vec1.generic[33] < vec2.generic[33]) ? 0xFF : 0, 1);
	memset(&vec1.generic[34], (vec1.generic[34] < vec2.generic[34]) ? 0xFF : 0, 1);
	memset(&vec1.generic[35], (vec1.generic[35] < vec2.generic[35]) ? 0xFF : 0, 1);
	memset(&vec1.generic[36], (vec1.generic[36] < vec2.generic[36]) ? 0xFF : 0, 1);
	memset(&vec1.generic[37], (vec1.generic[37] < vec2.generic[37]) ? 0xFF : 0, 1);
	memset(&vec1.generic[38], (vec1.generic[38] < vec2.generic[38]) ? 0xFF : 0, 1);
	memset(&vec1.generic[39], (vec1.generic[39] < vec2.generic[39]) ? 0xFF : 0, 1);
	memset(&vec1.generic[40], (vec1.generic[40] < vec2.generic[40]) ? 0xFF : 0, 1);
	memset(&vec1.generic[41], (vec1.generic[41] < vec2.generic[41]) ? 0xFF : 0, 1);
	memset(&vec1.generic[42], (vec1.generic[42] < vec2.generic[42]) ? 0xFF : 0, 1);
	memset(&vec1.generic[43], (vec1.generic[43] < vec2.generic[43]) ? 0xFF : 0, 1);
	memset(&vec1.generic[44], (vec1.generic[44] < vec2.generic[44]) ? 0xFF : 0, 1);
	memset(&vec1.generic[45], (vec1.generic[45] < vec2.generic[45]) ? 0xFF : 0, 1);
	memset(&vec1.generic[46], (vec1.generic[46] < vec2.generic[46]) ? 0xFF : 0, 1);
	memset(&vec1.generic[47], (vec1.generic[47] < vec2.generic[47]) ? 0xFF : 0, 1);
	memset(&vec1.generic[48], (vec1.generic[48] < vec2.generic[48]) ? 0xFF : 0, 1);
	memset(&vec1.generic[49], (vec1.generic[49] < vec2.generic[49]) ? 0xFF : 0, 1);
	memset(&vec1.generic[50], (vec1.generic[50] < vec2.generic[50]) ? 0xFF : 0, 1);
	memset(&vec1.generic[51], (vec1.generic[51] < vec2.generic[51]) ? 0xFF : 0, 1);
	memset(&vec1.generic[52], (vec1.generic[52] < vec2.generic[52]) ? 0xFF : 0, 1);
	memset(&vec1.generic[53], (vec1.generic[53] < vec2.generic[53]) ? 0xFF : 0, 1);
	memset(&vec1.generic[54], (vec1.generic[54] < vec2.generic[54]) ? 0xFF : 0, 1);
	memset(&vec1.generic[55], (vec1.generic[55] < vec2.generic[55]) ? 0xFF : 0, 1);
	memset(&vec1.generic[56], (vec1.generic[56] < vec2.generic[56]) ? 0xFF : 0, 1);
	memset(&vec1.generic[57], (vec1.generic[57] < vec2.generic[57]) ? 0xFF : 0, 1);
	memset(&vec1.generic[58], (vec1.generic[58] < vec2.generic[58]) ? 0xFF : 0, 1);
	memset(&vec1.generic[59], (vec1.generic[59] < vec2.generic[59]) ? 0xFF : 0, 1);
	memset(&vec1.generic[60], (vec1.generic[60] < vec2.generic[60]) ? 0xFF : 0, 1);
	memset(&vec1.generic[61], (vec1.generic[61] < vec2.generic[61]) ? 0xFF : 0, 1);
	memset(&vec1.generic[62], (vec1.generic[62] < vec2.generic[62]) ? 0xFF : 0, 1);
	memset(&vec1.generic[63], (vec1.generic[63] < vec2.generic[63]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x64_CMPLT_DEFINED
#endif
#if !defined(VUINT8x64_CMPEQ_DEFINED)
VEC_FUNC_IMPL vuint8x64 vuint8x64_cmpeq(vuint8x64 vec1, vuint8x64 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] == vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] == vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] == vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] == vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] == vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] == vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] == vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] == vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] == vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] == vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] == vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] == vec2.generic[15]) ? 0xFF : 0, 1);
	memset(&vec1.generic[16], (vec1.generic[16] == vec2.generic[16]) ? 0xFF : 0, 1);
	memset(&vec1.generic[17], (vec1.generic[17] == vec2.generic[17]) ? 0xFF : 0, 1);
	memset(&vec1.generic[18], (vec1.generic[18] == vec2.generic[18]) ? 0xFF : 0, 1);
	memset(&vec1.generic[19], (vec1.generic[19] == vec2.generic[19]) ? 0xFF : 0, 1);
	memset(&vec1.generic[20], (vec1.generic[20] == vec2.generic[20]) ? 0xFF : 0, 1);
	memset(&vec1.generic[21], (vec1.generic[21] == vec2.generic[21]) ? 0xFF : 0, 1);
	memset(&vec1.generic[22], (vec1.generic[22] == vec2.generic[22]) ? 0xFF : 0, 1);
	memset(&vec1.generic[23], (vec1.generic[23] == vec2.generic[23]) ? 0xFF : 0, 1);
	memset(&vec1.generic[24], (vec1.generic[24] == vec2.generic[24]) ? 0xFF : 0, 1);
	memset(&vec1.generic[25], (vec1.generic[25] == vec2.generic[25]) ? 0xFF : 0, 1);
	memset(&vec1.generic[26], (vec1.generic[26] == vec2.generic[26]) ? 0xFF : 0, 1);
	memset(&vec1.generic[27], (vec1.generic[27] == vec2.generic[27]) ? 0xFF : 0, 1);
	memset(&vec1.generic[28], (vec1.generic[28] == vec2.generic[28]) ? 0xFF : 0, 1);
	memset(&vec1.generic[29], (vec1.generic[29] == vec2.generic[29]) ? 0xFF : 0, 1);
	memset(&vec1.generic[30], (vec1.generic[30] == vec2.generic[30]) ? 0xFF : 0, 1);
	memset(&vec1.generic[31], (vec1.generic[31] == vec2.generic[31]) ? 0xFF : 0, 1);
	memset(&vec1.generic[32], (vec1.generic[32] == vec2.generic[32]) ? 0xFF : 0, 1);
	memset(&vec1.generic[33], (vec1.generic[33] == vec2.generic[33]) ? 0xFF : 0, 1);
	memset(&vec1.generic[34], (vec1.generic[34] == vec2.generic[34]) ? 0xFF : 0, 1);
	memset(&vec1.generic[35], (vec1.generic[35] == vec2.generic[35]) ? 0xFF : 0, 1);
	memset(&vec1.generic[36], (vec1.generic[36] == vec2.generic[36]) ? 0xFF : 0, 1);
	memset(&vec1.generic[37], (vec1.generic[37] == vec2.generic[37]) ? 0xFF : 0, 1);
	memset(&vec1.generic[38], (vec1.generic[38] == vec2.generic[38]) ? 0xFF : 0, 1);
	memset(&vec1.generic[39], (vec1.generic[39] == vec2.generic[39]) ? 0xFF : 0, 1);
	memset(&vec1.generic[40], (vec1.generic[40] == vec2.generic[40]) ? 0xFF : 0, 1);
	memset(&vec1.generic[41], (vec1.generic[41] == vec2.generic[41]) ? 0xFF : 0, 1);
	memset(&vec1.generic[42], (vec1.generic[42] == vec2.generic[42]) ? 0xFF : 0, 1);
	memset(&vec1.generic[43], (vec1.generic[43] == vec2.generic[43]) ? 0xFF : 0, 1);
	memset(&vec1.generic[44], (vec1.generic[44] == vec2.generic[44]) ? 0xFF : 0, 1);
	memset(&vec1.generic[45], (vec1.generic[45] == vec2.generic[45]) ? 0xFF : 0, 1);
	memset(&vec1.generic[46], (vec1.generic[46] == vec2.generic[46]) ? 0xFF : 0, 1);
	memset(&vec1.generic[47], (vec1.generic[47] == vec2.generic[47]) ? 0xFF : 0, 1);
	memset(&vec1.generic[48], (vec1.generic[48] == vec2.generic[48]) ? 0xFF : 0, 1);
	memset(&vec1.generic[49], (vec1.generic[49] == vec2.generic[49]) ? 0xFF : 0, 1);
	memset(&vec1.generic[50], (vec1.generic[50] == vec2.generic[50]) ? 0xFF : 0, 1);
	memset(&vec1.generic[51], (vec1.generic[51] == vec2.generic[51]) ? 0xFF : 0, 1);
	memset(&vec1.generic[52], (vec1.generic[52] == vec2.generic[52]) ? 0xFF : 0, 1);
	memset(&vec1.generic[53], (vec1.generic[53] == vec2.generic[53]) ? 0xFF : 0, 1);
	memset(&vec1.generic[54], (vec1.generic[54] == vec2.generic[54]) ? 0xFF : 0, 1);
	memset(&vec1.generic[55], (vec1.generic[55] == vec2.generic[55]) ? 0xFF : 0, 1);
	memset(&vec1.generic[56], (vec1.generic[56] == vec2.generic[56]) ? 0xFF : 0, 1);
	memset(&vec1.generic[57], (vec1.generic[57] == vec2.generic[57]) ? 0xFF : 0, 1);
	memset(&vec1.generic[58], (vec1.generic[58] == vec2.generic[58]) ? 0xFF : 0, 1);
	memset(&vec1.generic[59], (vec1.generic[59] == vec2.generic[59]) ? 0xFF : 0, 1);
	memset(&vec1.generic[60], (vec1.generic[60] == vec2.generic[60]) ? 0xFF : 0, 1);
	memset(&vec1.generic[61], (vec1.generic[61] == vec2.generic[61]) ? 0xFF : 0, 1);
	memset(&vec1.generic[62], (vec1.generic[62] == vec2.generic[62]) ? 0xFF : 0, 1);
	memset(&vec1.generic[63], (vec1.generic[63] == vec2.generic[63]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x64_CMPEQ_DEFINED
#endif
#if !defined(VUINT8x64_CMPGT_DEFINED)
VEC_FUNC_IMPL vuint8x64 vuint8x64_cmpgt(vuint8x64 vec1, vuint8x64 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] > vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] > vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] > vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] > vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] > vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] > vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] > vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] > vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] > vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] > vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] > vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] > vec2.generic[15]) ? 0xFF : 0, 1);
	memset(&vec1.generic[16], (vec1.generic[16] > vec2.generic[16]) ? 0xFF : 0, 1);
	memset(&vec1.generic[17], (vec1.generic[17] > vec2.generic[17]) ? 0xFF : 0, 1);
	memset(&vec1.generic[18], (vec1.generic[18] > vec2.generic[18]) ? 0xFF : 0, 1);
	memset(&vec1.generic[19], (vec1.generic[19] > vec2.generic[19]) ? 0xFF : 0, 1);
	memset(&vec1.generic[20], (vec1.generic[20] > vec2.generic[20]) ? 0xFF : 0, 1);
	memset(&vec1.generic[21], (vec1.generic[21] > vec2.generic[21]) ? 0xFF : 0, 1);
	memset(&vec1.generic[22], (vec1.generic[22] > vec2.generic[22]) ? 0xFF : 0, 1);
	memset(&vec1.generic[23], (vec1.generic[23] > vec2.generic[23]) ? 0xFF : 0, 1);
	memset(&vec1.generic[24], (vec1.generic[24] > vec2.generic[24]) ? 0xFF : 0, 1);
	memset(&vec1.generic[25], (vec1.generic[25] > vec2.generic[25]) ? 0xFF : 0, 1);
	memset(&vec1.generic[26], (vec1.generic[26] > vec2.generic[26]) ? 0xFF : 0, 1);
	memset(&vec1.generic[27], (vec1.generic[27] > vec2.generic[27]) ? 0xFF : 0, 1);
	memset(&vec1.generic[28], (vec1.generic[28] > vec2.generic[28]) ? 0xFF : 0, 1);
	memset(&vec1.generic[29], (vec1.generic[29] > vec2.generic[29]) ? 0xFF : 0, 1);
	memset(&vec1.generic[30], (vec1.generic[30] > vec2.generic[30]) ? 0xFF : 0, 1);
	memset(&vec1.generic[31], (vec1.generic[31] > vec2.generic[31]) ? 0xFF : 0, 1);
	memset(&vec1.generic[32], (vec1.generic[32] > vec2.generic[32]) ? 0xFF : 0, 1);
	memset(&vec1.generic[33], (vec1.generic[33] > vec2.generic[33]) ? 0xFF : 0, 1);
	memset(&vec1.generic[34], (vec1.generic[34] > vec2.generic[34]) ? 0xFF : 0, 1);
	memset(&vec1.generic[35], (vec1.generic[35] > vec2.generic[35]) ? 0xFF : 0, 1);
	memset(&vec1.generic[36], (vec1.generic[36] > vec2.generic[36]) ? 0xFF : 0, 1);
	memset(&vec1.generic[37], (vec1.generic[37] > vec2.generic[37]) ? 0xFF : 0, 1);
	memset(&vec1.generic[38], (vec1.generic[38] > vec2.generic[38]) ? 0xFF : 0, 1);
	memset(&vec1.generic[39], (vec1.generic[39] > vec2.generic[39]) ? 0xFF : 0, 1);
	memset(&vec1.generic[40], (vec1.generic[40] > vec2.generic[40]) ? 0xFF : 0, 1);
	memset(&vec1.generic[41], (vec1.generic[41] > vec2.generic[41]) ? 0xFF : 0, 1);
	memset(&vec1.generic[42], (vec1.generic[42] > vec2.generic[42]) ? 0xFF : 0, 1);
	memset(&vec1.generic[43], (vec1.generic[43] > vec2.generic[43]) ? 0xFF : 0, 1);
	memset(&vec1.generic[44], (vec1.generic[44] > vec2.generic[44]) ? 0xFF : 0, 1);
	memset(&vec1.generic[45], (vec1.generic[45] > vec2.generic[45]) ? 0xFF : 0, 1);
	memset(&vec1.generic[46], (vec1.generic[46] > vec2.generic[46]) ? 0xFF : 0, 1);
	memset(&vec1.generic[47], (vec1.generic[47] > vec2.generic[47]) ? 0xFF : 0, 1);
	memset(&vec1.generic[48], (vec1.generic[48] > vec2.generic[48]) ? 0xFF : 0, 1);
	memset(&vec1.generic[49], (vec1.generic[49] > vec2.generic[49]) ? 0xFF : 0, 1);
	memset(&vec1.generic[50], (vec1.generic[50] > vec2.generic[50]) ? 0xFF : 0, 1);
	memset(&vec1.generic[51], (vec1.generic[51] > vec2.generic[51]) ? 0xFF : 0, 1);
	memset(&vec1.generic[52], (vec1.generic[52] > vec2.generic[52]) ? 0xFF : 0, 1);
	memset(&vec1.generic[53], (vec1.generic[53] > vec2.generic[53]) ? 0xFF : 0, 1);
	memset(&vec1.generic[54], (vec1.generic[54] > vec2.generic[54]) ? 0xFF : 0, 1);
	memset(&vec1.generic[55], (vec1.generic[55] > vec2.generic[55]) ? 0xFF : 0, 1);
	memset(&vec1.generic[56], (vec1.generic[56] > vec2.generic[56]) ? 0xFF : 0, 1);
	memset(&vec1.generic[57], (vec1.generic[57] > vec2.generic[57]) ? 0xFF : 0, 1);
	memset(&vec1.generic[58], (vec1.generic[58] > vec2.generic[58]) ? 0xFF : 0, 1);
	memset(&vec1.generic[59], (vec1.generic[59] > vec2.generic[59]) ? 0xFF : 0, 1);
	memset(&vec1.generic[60], (vec1.generic[60] > vec2.generic[60]) ? 0xFF : 0, 1);
	memset(&vec1.generic[61], (vec1.generic[61] > vec2.generic[61]) ? 0xFF : 0, 1);
	memset(&vec1.generic[62], (vec1.generic[62] > vec2.generic[62]) ? 0xFF : 0, 1);
	memset(&vec1.generic[63], (vec1.generic[63] > vec2.generic[63]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x64_CMPGT_DEFINED
#endif
#if !defined(VUINT8x64_CMPLE_DEFINED)
VEC_FUNC_IMPL vuint8x64 vuint8x64_cmple(vuint8x64 vec1, vuint8x64 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] <= vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] <= vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] <= vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] <= vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] <= vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] <= vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] <= vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] <= vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] <= vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] <= vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] <= vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] <= vec2.generic[15]) ? 0xFF : 0, 1);
	memset(&vec1.generic[16], (vec1.generic[16] <= vec2.generic[16]) ? 0xFF : 0, 1);
	memset(&vec1.generic[17], (vec1.generic[17] <= vec2.generic[17]) ? 0xFF : 0, 1);
	memset(&vec1.generic[18], (vec1.generic[18] <= vec2.generic[18]) ? 0xFF : 0, 1);
	memset(&vec1.generic[19], (vec1.generic[19] <= vec2.generic[19]) ? 0xFF : 0, 1);
	memset(&vec1.generic[20], (vec1.generic[20] <= vec2.generic[20]) ? 0xFF : 0, 1);
	memset(&vec1.generic[21], (vec1.generic[21] <= vec2.generic[21]) ? 0xFF : 0, 1);
	memset(&vec1.generic[22], (vec1.generic[22] <= vec2.generic[22]) ? 0xFF : 0, 1);
	memset(&vec1.generic[23], (vec1.generic[23] <= vec2.generic[23]) ? 0xFF : 0, 1);
	memset(&vec1.generic[24], (vec1.generic[24] <= vec2.generic[24]) ? 0xFF : 0, 1);
	memset(&vec1.generic[25], (vec1.generic[25] <= vec2.generic[25]) ? 0xFF : 0, 1);
	memset(&vec1.generic[26], (vec1.generic[26] <= vec2.generic[26]) ? 0xFF : 0, 1);
	memset(&vec1.generic[27], (vec1.generic[27] <= vec2.generic[27]) ? 0xFF : 0, 1);
	memset(&vec1.generic[28], (vec1.generic[28] <= vec2.generic[28]) ? 0xFF : 0, 1);
	memset(&vec1.generic[29], (vec1.generic[29] <= vec2.generic[29]) ? 0xFF : 0, 1);
	memset(&vec1.generic[30], (vec1.generic[30] <= vec2.generic[30]) ? 0xFF : 0, 1);
	memset(&vec1.generic[31], (vec1.generic[31] <= vec2.generic[31]) ? 0xFF : 0, 1);
	memset(&vec1.generic[32], (vec1.generic[32] <= vec2.generic[32]) ? 0xFF : 0, 1);
	memset(&vec1.generic[33], (vec1.generic[33] <= vec2.generic[33]) ? 0xFF : 0, 1);
	memset(&vec1.generic[34], (vec1.generic[34] <= vec2.generic[34]) ? 0xFF : 0, 1);
	memset(&vec1.generic[35], (vec1.generic[35] <= vec2.generic[35]) ? 0xFF : 0, 1);
	memset(&vec1.generic[36], (vec1.generic[36] <= vec2.generic[36]) ? 0xFF : 0, 1);
	memset(&vec1.generic[37], (vec1.generic[37] <= vec2.generic[37]) ? 0xFF : 0, 1);
	memset(&vec1.generic[38], (vec1.generic[38] <= vec2.generic[38]) ? 0xFF : 0, 1);
	memset(&vec1.generic[39], (vec1.generic[39] <= vec2.generic[39]) ? 0xFF : 0, 1);
	memset(&vec1.generic[40], (vec1.generic[40] <= vec2.generic[40]) ? 0xFF : 0, 1);
	memset(&vec1.generic[41], (vec1.generic[41] <= vec2.generic[41]) ? 0xFF : 0, 1);
	memset(&vec1.generic[42], (vec1.generic[42] <= vec2.generic[42]) ? 0xFF : 0, 1);
	memset(&vec1.generic[43], (vec1.generic[43] <= vec2.generic[43]) ? 0xFF : 0, 1);
	memset(&vec1.generic[44], (vec1.generic[44] <= vec2.generic[44]) ? 0xFF : 0, 1);
	memset(&vec1.generic[45], (vec1.generic[45] <= vec2.generic[45]) ? 0xFF : 0, 1);
	memset(&vec1.generic[46], (vec1.generic[46] <= vec2.generic[46]) ? 0xFF : 0, 1);
	memset(&vec1.generic[47], (vec1.generic[47] <= vec2.generic[47]) ? 0xFF : 0, 1);
	memset(&vec1.generic[48], (vec1.generic[48] <= vec2.generic[48]) ? 0xFF : 0, 1);
	memset(&vec1.generic[49], (vec1.generic[49] <= vec2.generic[49]) ? 0xFF : 0, 1);
	memset(&vec1.generic[50], (vec1.generic[50] <= vec2.generic[50]) ? 0xFF : 0, 1);
	memset(&vec1.generic[51], (vec1.generic[51] <= vec2.generic[51]) ? 0xFF : 0, 1);
	memset(&vec1.generic[52], (vec1.generic[52] <= vec2.generic[52]) ? 0xFF : 0, 1);
	memset(&vec1.generic[53], (vec1.generic[53] <= vec2.generic[53]) ? 0xFF : 0, 1);
	memset(&vec1.generic[54], (vec1.generic[54] <= vec2.generic[54]) ? 0xFF : 0, 1);
	memset(&vec1.generic[55], (vec1.generic[55] <= vec2.generic[55]) ? 0xFF : 0, 1);
	memset(&vec1.generic[56], (vec1.generic[56] <= vec2.generic[56]) ? 0xFF : 0, 1);
	memset(&vec1.generic[57], (vec1.generic[57] <= vec2.generic[57]) ? 0xFF : 0, 1);
	memset(&vec1.generic[58], (vec1.generic[58] <= vec2.generic[58]) ? 0xFF : 0, 1);
	memset(&vec1.generic[59], (vec1.generic[59] <= vec2.generic[59]) ? 0xFF : 0, 1);
	memset(&vec1.generic[60], (vec1.generic[60] <= vec2.generic[60]) ? 0xFF : 0, 1);
	memset(&vec1.generic[61], (vec1.generic[61] <= vec2.generic[61]) ? 0xFF : 0, 1);
	memset(&vec1.generic[62], (vec1.generic[62] <= vec2.generic[62]) ? 0xFF : 0, 1);
	memset(&vec1.generic[63], (vec1.generic[63] <= vec2.generic[63]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x64_CMPLE_DEFINED
#endif
#if !defined(VUINT8x64_CMPGE_DEFINED)
VEC_FUNC_IMPL vuint8x64 vuint8x64_cmpge(vuint8x64 vec1, vuint8x64 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 1);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 1);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 1);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 1);
	memset(&vec1.generic[4], (vec1.generic[4] >= vec2.generic[4]) ? 0xFF : 0, 1);
	memset(&vec1.generic[5], (vec1.generic[5] >= vec2.generic[5]) ? 0xFF : 0, 1);
	memset(&vec1.generic[6], (vec1.generic[6] >= vec2.generic[6]) ? 0xFF : 0, 1);
	memset(&vec1.generic[7], (vec1.generic[7] >= vec2.generic[7]) ? 0xFF : 0, 1);
	memset(&vec1.generic[8], (vec1.generic[8] >= vec2.generic[8]) ? 0xFF : 0, 1);
	memset(&vec1.generic[9], (vec1.generic[9] >= vec2.generic[9]) ? 0xFF : 0, 1);
	memset(&vec1.generic[10], (vec1.generic[10] >= vec2.generic[10]) ? 0xFF : 0, 1);
	memset(&vec1.generic[11], (vec1.generic[11] >= vec2.generic[11]) ? 0xFF : 0, 1);
	memset(&vec1.generic[12], (vec1.generic[12] >= vec2.generic[12]) ? 0xFF : 0, 1);
	memset(&vec1.generic[13], (vec1.generic[13] >= vec2.generic[13]) ? 0xFF : 0, 1);
	memset(&vec1.generic[14], (vec1.generic[14] >= vec2.generic[14]) ? 0xFF : 0, 1);
	memset(&vec1.generic[15], (vec1.generic[15] >= vec2.generic[15]) ? 0xFF : 0, 1);
	memset(&vec1.generic[16], (vec1.generic[16] >= vec2.generic[16]) ? 0xFF : 0, 1);
	memset(&vec1.generic[17], (vec1.generic[17] >= vec2.generic[17]) ? 0xFF : 0, 1);
	memset(&vec1.generic[18], (vec1.generic[18] >= vec2.generic[18]) ? 0xFF : 0, 1);
	memset(&vec1.generic[19], (vec1.generic[19] >= vec2.generic[19]) ? 0xFF : 0, 1);
	memset(&vec1.generic[20], (vec1.generic[20] >= vec2.generic[20]) ? 0xFF : 0, 1);
	memset(&vec1.generic[21], (vec1.generic[21] >= vec2.generic[21]) ? 0xFF : 0, 1);
	memset(&vec1.generic[22], (vec1.generic[22] >= vec2.generic[22]) ? 0xFF : 0, 1);
	memset(&vec1.generic[23], (vec1.generic[23] >= vec2.generic[23]) ? 0xFF : 0, 1);
	memset(&vec1.generic[24], (vec1.generic[24] >= vec2.generic[24]) ? 0xFF : 0, 1);
	memset(&vec1.generic[25], (vec1.generic[25] >= vec2.generic[25]) ? 0xFF : 0, 1);
	memset(&vec1.generic[26], (vec1.generic[26] >= vec2.generic[26]) ? 0xFF : 0, 1);
	memset(&vec1.generic[27], (vec1.generic[27] >= vec2.generic[27]) ? 0xFF : 0, 1);
	memset(&vec1.generic[28], (vec1.generic[28] >= vec2.generic[28]) ? 0xFF : 0, 1);
	memset(&vec1.generic[29], (vec1.generic[29] >= vec2.generic[29]) ? 0xFF : 0, 1);
	memset(&vec1.generic[30], (vec1.generic[30] >= vec2.generic[30]) ? 0xFF : 0, 1);
	memset(&vec1.generic[31], (vec1.generic[31] >= vec2.generic[31]) ? 0xFF : 0, 1);
	memset(&vec1.generic[32], (vec1.generic[32] >= vec2.generic[32]) ? 0xFF : 0, 1);
	memset(&vec1.generic[33], (vec1.generic[33] >= vec2.generic[33]) ? 0xFF : 0, 1);
	memset(&vec1.generic[34], (vec1.generic[34] >= vec2.generic[34]) ? 0xFF : 0, 1);
	memset(&vec1.generic[35], (vec1.generic[35] >= vec2.generic[35]) ? 0xFF : 0, 1);
	memset(&vec1.generic[36], (vec1.generic[36] >= vec2.generic[36]) ? 0xFF : 0, 1);
	memset(&vec1.generic[37], (vec1.generic[37] >= vec2.generic[37]) ? 0xFF : 0, 1);
	memset(&vec1.generic[38], (vec1.generic[38] >= vec2.generic[38]) ? 0xFF : 0, 1);
	memset(&vec1.generic[39], (vec1.generic[39] >= vec2.generic[39]) ? 0xFF : 0, 1);
	memset(&vec1.generic[40], (vec1.generic[40] >= vec2.generic[40]) ? 0xFF : 0, 1);
	memset(&vec1.generic[41], (vec1.generic[41] >= vec2.generic[41]) ? 0xFF : 0, 1);
	memset(&vec1.generic[42], (vec1.generic[42] >= vec2.generic[42]) ? 0xFF : 0, 1);
	memset(&vec1.generic[43], (vec1.generic[43] >= vec2.generic[43]) ? 0xFF : 0, 1);
	memset(&vec1.generic[44], (vec1.generic[44] >= vec2.generic[44]) ? 0xFF : 0, 1);
	memset(&vec1.generic[45], (vec1.generic[45] >= vec2.generic[45]) ? 0xFF : 0, 1);
	memset(&vec1.generic[46], (vec1.generic[46] >= vec2.generic[46]) ? 0xFF : 0, 1);
	memset(&vec1.generic[47], (vec1.generic[47] >= vec2.generic[47]) ? 0xFF : 0, 1);
	memset(&vec1.generic[48], (vec1.generic[48] >= vec2.generic[48]) ? 0xFF : 0, 1);
	memset(&vec1.generic[49], (vec1.generic[49] >= vec2.generic[49]) ? 0xFF : 0, 1);
	memset(&vec1.generic[50], (vec1.generic[50] >= vec2.generic[50]) ? 0xFF : 0, 1);
	memset(&vec1.generic[51], (vec1.generic[51] >= vec2.generic[51]) ? 0xFF : 0, 1);
	memset(&vec1.generic[52], (vec1.generic[52] >= vec2.generic[52]) ? 0xFF : 0, 1);
	memset(&vec1.generic[53], (vec1.generic[53] >= vec2.generic[53]) ? 0xFF : 0, 1);
	memset(&vec1.generic[54], (vec1.generic[54] >= vec2.generic[54]) ? 0xFF : 0, 1);
	memset(&vec1.generic[55], (vec1.generic[55] >= vec2.generic[55]) ? 0xFF : 0, 1);
	memset(&vec1.generic[56], (vec1.generic[56] >= vec2.generic[56]) ? 0xFF : 0, 1);
	memset(&vec1.generic[57], (vec1.generic[57] >= vec2.generic[57]) ? 0xFF : 0, 1);
	memset(&vec1.generic[58], (vec1.generic[58] >= vec2.generic[58]) ? 0xFF : 0, 1);
	memset(&vec1.generic[59], (vec1.generic[59] >= vec2.generic[59]) ? 0xFF : 0, 1);
	memset(&vec1.generic[60], (vec1.generic[60] >= vec2.generic[60]) ? 0xFF : 0, 1);
	memset(&vec1.generic[61], (vec1.generic[61] >= vec2.generic[61]) ? 0xFF : 0, 1);
	memset(&vec1.generic[62], (vec1.generic[62] >= vec2.generic[62]) ? 0xFF : 0, 1);
	memset(&vec1.generic[63], (vec1.generic[63] >= vec2.generic[63]) ? 0xFF : 0, 1);
	return vec1;
}
# define VUINT8x64_CMPGE_DEFINED
#endif
#if !defined(VUINT8x64_MIN_DEFINED)
VEC_FUNC_IMPL vuint8x64 vuint8x64_min(vuint8x64 vec1, vuint8x64 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] < vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] < vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] < vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] < vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] < vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] < vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] < vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] < vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] < vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] < vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] < vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] < vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] < vec2.generic[16]) ? (vec1.generic[16]) : (vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] < vec2.generic[17]) ? (vec1.generic[17]) : (vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] < vec2.generic[18]) ? (vec1.generic[18]) : (vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] < vec2.generic[19]) ? (vec1.generic[19]) : (vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] < vec2.generic[20]) ? (vec1.generic[20]) : (vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] < vec2.generic[21]) ? (vec1.generic[21]) : (vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] < vec2.generic[22]) ? (vec1.generic[22]) : (vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] < vec2.generic[23]) ? (vec1.generic[23]) : (vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] < vec2.generic[24]) ? (vec1.generic[24]) : (vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] < vec2.generic[25]) ? (vec1.generic[25]) : (vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] < vec2.generic[26]) ? (vec1.generic[26]) : (vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] < vec2.generic[27]) ? (vec1.generic[27]) : (vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] < vec2.generic[28]) ? (vec1.generic[28]) : (vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] < vec2.generic[29]) ? (vec1.generic[29]) : (vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] < vec2.generic[30]) ? (vec1.generic[30]) : (vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] < vec2.generic[31]) ? (vec1.generic[31]) : (vec2.generic[31]);
	vec1.generic[32] = (vec1.generic[32] < vec2.generic[32]) ? (vec1.generic[32]) : (vec2.generic[32]);
	vec1.generic[33] = (vec1.generic[33] < vec2.generic[33]) ? (vec1.generic[33]) : (vec2.generic[33]);
	vec1.generic[34] = (vec1.generic[34] < vec2.generic[34]) ? (vec1.generic[34]) : (vec2.generic[34]);
	vec1.generic[35] = (vec1.generic[35] < vec2.generic[35]) ? (vec1.generic[35]) : (vec2.generic[35]);
	vec1.generic[36] = (vec1.generic[36] < vec2.generic[36]) ? (vec1.generic[36]) : (vec2.generic[36]);
	vec1.generic[37] = (vec1.generic[37] < vec2.generic[37]) ? (vec1.generic[37]) : (vec2.generic[37]);
	vec1.generic[38] = (vec1.generic[38] < vec2.generic[38]) ? (vec1.generic[38]) : (vec2.generic[38]);
	vec1.generic[39] = (vec1.generic[39] < vec2.generic[39]) ? (vec1.generic[39]) : (vec2.generic[39]);
	vec1.generic[40] = (vec1.generic[40] < vec2.generic[40]) ? (vec1.generic[40]) : (vec2.generic[40]);
	vec1.generic[41] = (vec1.generic[41] < vec2.generic[41]) ? (vec1.generic[41]) : (vec2.generic[41]);
	vec1.generic[42] = (vec1.generic[42] < vec2.generic[42]) ? (vec1.generic[42]) : (vec2.generic[42]);
	vec1.generic[43] = (vec1.generic[43] < vec2.generic[43]) ? (vec1.generic[43]) : (vec2.generic[43]);
	vec1.generic[44] = (vec1.generic[44] < vec2.generic[44]) ? (vec1.generic[44]) : (vec2.generic[44]);
	vec1.generic[45] = (vec1.generic[45] < vec2.generic[45]) ? (vec1.generic[45]) : (vec2.generic[45]);
	vec1.generic[46] = (vec1.generic[46] < vec2.generic[46]) ? (vec1.generic[46]) : (vec2.generic[46]);
	vec1.generic[47] = (vec1.generic[47] < vec2.generic[47]) ? (vec1.generic[47]) : (vec2.generic[47]);
	vec1.generic[48] = (vec1.generic[48] < vec2.generic[48]) ? (vec1.generic[48]) : (vec2.generic[48]);
	vec1.generic[49] = (vec1.generic[49] < vec2.generic[49]) ? (vec1.generic[49]) : (vec2.generic[49]);
	vec1.generic[50] = (vec1.generic[50] < vec2.generic[50]) ? (vec1.generic[50]) : (vec2.generic[50]);
	vec1.generic[51] = (vec1.generic[51] < vec2.generic[51]) ? (vec1.generic[51]) : (vec2.generic[51]);
	vec1.generic[52] = (vec1.generic[52] < vec2.generic[52]) ? (vec1.generic[52]) : (vec2.generic[52]);
	vec1.generic[53] = (vec1.generic[53] < vec2.generic[53]) ? (vec1.generic[53]) : (vec2.generic[53]);
	vec1.generic[54] = (vec1.generic[54] < vec2.generic[54]) ? (vec1.generic[54]) : (vec2.generic[54]);
	vec1.generic[55] = (vec1.generic[55] < vec2.generic[55]) ? (vec1.generic[55]) : (vec2.generic[55]);
	vec1.generic[56] = (vec1.generic[56] < vec2.generic[56]) ? (vec1.generic[56]) : (vec2.generic[56]);
	vec1.generic[57] = (vec1.generic[57] < vec2.generic[57]) ? (vec1.generic[57]) : (vec2.generic[57]);
	vec1.generic[58] = (vec1.generic[58] < vec2.generic[58]) ? (vec1.generic[58]) : (vec2.generic[58]);
	vec1.generic[59] = (vec1.generic[59] < vec2.generic[59]) ? (vec1.generic[59]) : (vec2.generic[59]);
	vec1.generic[60] = (vec1.generic[60] < vec2.generic[60]) ? (vec1.generic[60]) : (vec2.generic[60]);
	vec1.generic[61] = (vec1.generic[61] < vec2.generic[61]) ? (vec1.generic[61]) : (vec2.generic[61]);
	vec1.generic[62] = (vec1.generic[62] < vec2.generic[62]) ? (vec1.generic[62]) : (vec2.generic[62]);
	vec1.generic[63] = (vec1.generic[63] < vec2.generic[63]) ? (vec1.generic[63]) : (vec2.generic[63]);
	return vec1;
}
# define VUINT8x64_MIN_DEFINED
#endif
#if !defined(VUINT8x64_MAX_DEFINED)
VEC_FUNC_IMPL vuint8x64 vuint8x64_max(vuint8x64 vec1, vuint8x64 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] > vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] > vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] > vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] > vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] > vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] > vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] > vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] > vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] > vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] > vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] > vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] > vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] > vec2.generic[16]) ? (vec1.generic[16]) : (vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] > vec2.generic[17]) ? (vec1.generic[17]) : (vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] > vec2.generic[18]) ? (vec1.generic[18]) : (vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] > vec2.generic[19]) ? (vec1.generic[19]) : (vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] > vec2.generic[20]) ? (vec1.generic[20]) : (vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] > vec2.generic[21]) ? (vec1.generic[21]) : (vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] > vec2.generic[22]) ? (vec1.generic[22]) : (vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] > vec2.generic[23]) ? (vec1.generic[23]) : (vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] > vec2.generic[24]) ? (vec1.generic[24]) : (vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] > vec2.generic[25]) ? (vec1.generic[25]) : (vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] > vec2.generic[26]) ? (vec1.generic[26]) : (vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] > vec2.generic[27]) ? (vec1.generic[27]) : (vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] > vec2.generic[28]) ? (vec1.generic[28]) : (vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] > vec2.generic[29]) ? (vec1.generic[29]) : (vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] > vec2.generic[30]) ? (vec1.generic[30]) : (vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] > vec2.generic[31]) ? (vec1.generic[31]) : (vec2.generic[31]);
	vec1.generic[32] = (vec1.generic[32] > vec2.generic[32]) ? (vec1.generic[32]) : (vec2.generic[32]);
	vec1.generic[33] = (vec1.generic[33] > vec2.generic[33]) ? (vec1.generic[33]) : (vec2.generic[33]);
	vec1.generic[34] = (vec1.generic[34] > vec2.generic[34]) ? (vec1.generic[34]) : (vec2.generic[34]);
	vec1.generic[35] = (vec1.generic[35] > vec2.generic[35]) ? (vec1.generic[35]) : (vec2.generic[35]);
	vec1.generic[36] = (vec1.generic[36] > vec2.generic[36]) ? (vec1.generic[36]) : (vec2.generic[36]);
	vec1.generic[37] = (vec1.generic[37] > vec2.generic[37]) ? (vec1.generic[37]) : (vec2.generic[37]);
	vec1.generic[38] = (vec1.generic[38] > vec2.generic[38]) ? (vec1.generic[38]) : (vec2.generic[38]);
	vec1.generic[39] = (vec1.generic[39] > vec2.generic[39]) ? (vec1.generic[39]) : (vec2.generic[39]);
	vec1.generic[40] = (vec1.generic[40] > vec2.generic[40]) ? (vec1.generic[40]) : (vec2.generic[40]);
	vec1.generic[41] = (vec1.generic[41] > vec2.generic[41]) ? (vec1.generic[41]) : (vec2.generic[41]);
	vec1.generic[42] = (vec1.generic[42] > vec2.generic[42]) ? (vec1.generic[42]) : (vec2.generic[42]);
	vec1.generic[43] = (vec1.generic[43] > vec2.generic[43]) ? (vec1.generic[43]) : (vec2.generic[43]);
	vec1.generic[44] = (vec1.generic[44] > vec2.generic[44]) ? (vec1.generic[44]) : (vec2.generic[44]);
	vec1.generic[45] = (vec1.generic[45] > vec2.generic[45]) ? (vec1.generic[45]) : (vec2.generic[45]);
	vec1.generic[46] = (vec1.generic[46] > vec2.generic[46]) ? (vec1.generic[46]) : (vec2.generic[46]);
	vec1.generic[47] = (vec1.generic[47] > vec2.generic[47]) ? (vec1.generic[47]) : (vec2.generic[47]);
	vec1.generic[48] = (vec1.generic[48] > vec2.generic[48]) ? (vec1.generic[48]) : (vec2.generic[48]);
	vec1.generic[49] = (vec1.generic[49] > vec2.generic[49]) ? (vec1.generic[49]) : (vec2.generic[49]);
	vec1.generic[50] = (vec1.generic[50] > vec2.generic[50]) ? (vec1.generic[50]) : (vec2.generic[50]);
	vec1.generic[51] = (vec1.generic[51] > vec2.generic[51]) ? (vec1.generic[51]) : (vec2.generic[51]);
	vec1.generic[52] = (vec1.generic[52] > vec2.generic[52]) ? (vec1.generic[52]) : (vec2.generic[52]);
	vec1.generic[53] = (vec1.generic[53] > vec2.generic[53]) ? (vec1.generic[53]) : (vec2.generic[53]);
	vec1.generic[54] = (vec1.generic[54] > vec2.generic[54]) ? (vec1.generic[54]) : (vec2.generic[54]);
	vec1.generic[55] = (vec1.generic[55] > vec2.generic[55]) ? (vec1.generic[55]) : (vec2.generic[55]);
	vec1.generic[56] = (vec1.generic[56] > vec2.generic[56]) ? (vec1.generic[56]) : (vec2.generic[56]);
	vec1.generic[57] = (vec1.generic[57] > vec2.generic[57]) ? (vec1.generic[57]) : (vec2.generic[57]);
	vec1.generic[58] = (vec1.generic[58] > vec2.generic[58]) ? (vec1.generic[58]) : (vec2.generic[58]);
	vec1.generic[59] = (vec1.generic[59] > vec2.generic[59]) ? (vec1.generic[59]) : (vec2.generic[59]);
	vec1.generic[60] = (vec1.generic[60] > vec2.generic[60]) ? (vec1.generic[60]) : (vec2.generic[60]);
	vec1.generic[61] = (vec1.generic[61] > vec2.generic[61]) ? (vec1.generic[61]) : (vec2.generic[61]);
	vec1.generic[62] = (vec1.generic[62] > vec2.generic[62]) ? (vec1.generic[62]) : (vec2.generic[62]);
	vec1.generic[63] = (vec1.generic[63] > vec2.generic[63]) ? (vec1.generic[63]) : (vec2.generic[63]);
	return vec1;
}
# define VUINT8x64_MAX_DEFINED
#endif
#if !defined(VUINT8x64_RSHIFT_DEFINED)
VEC_FUNC_IMPL vuint8x64 vuint8x64_rshift(vuint8x64 vec1, vuint8x64 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	vec1.generic[4] >>= vec2.generic[0];
	vec1.generic[5] >>= vec2.generic[0];
	vec1.generic[6] >>= vec2.generic[0];
	vec1.generic[7] >>= vec2.generic[0];
	vec1.generic[8] >>= vec2.generic[0];
	vec1.generic[9] >>= vec2.generic[0];
	vec1.generic[10] >>= vec2.generic[0];
	vec1.generic[11] >>= vec2.generic[0];
	vec1.generic[12] >>= vec2.generic[0];
	vec1.generic[13] >>= vec2.generic[0];
	vec1.generic[14] >>= vec2.generic[0];
	vec1.generic[15] >>= vec2.generic[0];
	vec1.generic[16] >>= vec2.generic[0];
	vec1.generic[17] >>= vec2.generic[0];
	vec1.generic[18] >>= vec2.generic[0];
	vec1.generic[19] >>= vec2.generic[0];
	vec1.generic[20] >>= vec2.generic[0];
	vec1.generic[21] >>= vec2.generic[0];
	vec1.generic[22] >>= vec2.generic[0];
	vec1.generic[23] >>= vec2.generic[0];
	vec1.generic[24] >>= vec2.generic[0];
	vec1.generic[25] >>= vec2.generic[0];
	vec1.generic[26] >>= vec2.generic[0];
	vec1.generic[27] >>= vec2.generic[0];
	vec1.generic[28] >>= vec2.generic[0];
	vec1.generic[29] >>= vec2.generic[0];
	vec1.generic[30] >>= vec2.generic[0];
	vec1.generic[31] >>= vec2.generic[0];
	vec1.generic[32] >>= vec2.generic[0];
	vec1.generic[33] >>= vec2.generic[0];
	vec1.generic[34] >>= vec2.generic[0];
	vec1.generic[35] >>= vec2.generic[0];
	vec1.generic[36] >>= vec2.generic[0];
	vec1.generic[37] >>= vec2.generic[0];
	vec1.generic[38] >>= vec2.generic[0];
	vec1.generic[39] >>= vec2.generic[0];
	vec1.generic[40] >>= vec2.generic[0];
	vec1.generic[41] >>= vec2.generic[0];
	vec1.generic[42] >>= vec2.generic[0];
	vec1.generic[43] >>= vec2.generic[0];
	vec1.generic[44] >>= vec2.generic[0];
	vec1.generic[45] >>= vec2.generic[0];
	vec1.generic[46] >>= vec2.generic[0];
	vec1.generic[47] >>= vec2.generic[0];
	vec1.generic[48] >>= vec2.generic[0];
	vec1.generic[49] >>= vec2.generic[0];
	vec1.generic[50] >>= vec2.generic[0];
	vec1.generic[51] >>= vec2.generic[0];
	vec1.generic[52] >>= vec2.generic[0];
	vec1.generic[53] >>= vec2.generic[0];
	vec1.generic[54] >>= vec2.generic[0];
	vec1.generic[55] >>= vec2.generic[0];
	vec1.generic[56] >>= vec2.generic[0];
	vec1.generic[57] >>= vec2.generic[0];
	vec1.generic[58] >>= vec2.generic[0];
	vec1.generic[59] >>= vec2.generic[0];
	vec1.generic[60] >>= vec2.generic[0];
	vec1.generic[61] >>= vec2.generic[0];
	vec1.generic[62] >>= vec2.generic[0];
	vec1.generic[63] >>= vec2.generic[0];
	return vec1;
}
# define VUINT8x64_RSHIFT_DEFINED
#endif
#if !defined(VUINT8x64_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vuint8x64 vuint8x64_lrshift(vuint8x64 vec1, vuint8x64 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	vec1.generic[4] >>= vec2.generic[0];
	vec1.generic[5] >>= vec2.generic[0];
	vec1.generic[6] >>= vec2.generic[0];
	vec1.generic[7] >>= vec2.generic[0];
	vec1.generic[8] >>= vec2.generic[0];
	vec1.generic[9] >>= vec2.generic[0];
	vec1.generic[10] >>= vec2.generic[0];
	vec1.generic[11] >>= vec2.generic[0];
	vec1.generic[12] >>= vec2.generic[0];
	vec1.generic[13] >>= vec2.generic[0];
	vec1.generic[14] >>= vec2.generic[0];
	vec1.generic[15] >>= vec2.generic[0];
	vec1.generic[16] >>= vec2.generic[0];
	vec1.generic[17] >>= vec2.generic[0];
	vec1.generic[18] >>= vec2.generic[0];
	vec1.generic[19] >>= vec2.generic[0];
	vec1.generic[20] >>= vec2.generic[0];
	vec1.generic[21] >>= vec2.generic[0];
	vec1.generic[22] >>= vec2.generic[0];
	vec1.generic[23] >>= vec2.generic[0];
	vec1.generic[24] >>= vec2.generic[0];
	vec1.generic[25] >>= vec2.generic[0];
	vec1.generic[26] >>= vec2.generic[0];
	vec1.generic[27] >>= vec2.generic[0];
	vec1.generic[28] >>= vec2.generic[0];
	vec1.generic[29] >>= vec2.generic[0];
	vec1.generic[30] >>= vec2.generic[0];
	vec1.generic[31] >>= vec2.generic[0];
	vec1.generic[32] >>= vec2.generic[0];
	vec1.generic[33] >>= vec2.generic[0];
	vec1.generic[34] >>= vec2.generic[0];
	vec1.generic[35] >>= vec2.generic[0];
	vec1.generic[36] >>= vec2.generic[0];
	vec1.generic[37] >>= vec2.generic[0];
	vec1.generic[38] >>= vec2.generic[0];
	vec1.generic[39] >>= vec2.generic[0];
	vec1.generic[40] >>= vec2.generic[0];
	vec1.generic[41] >>= vec2.generic[0];
	vec1.generic[42] >>= vec2.generic[0];
	vec1.generic[43] >>= vec2.generic[0];
	vec1.generic[44] >>= vec2.generic[0];
	vec1.generic[45] >>= vec2.generic[0];
	vec1.generic[46] >>= vec2.generic[0];
	vec1.generic[47] >>= vec2.generic[0];
	vec1.generic[48] >>= vec2.generic[0];
	vec1.generic[49] >>= vec2.generic[0];
	vec1.generic[50] >>= vec2.generic[0];
	vec1.generic[51] >>= vec2.generic[0];
	vec1.generic[52] >>= vec2.generic[0];
	vec1.generic[53] >>= vec2.generic[0];
	vec1.generic[54] >>= vec2.generic[0];
	vec1.generic[55] >>= vec2.generic[0];
	vec1.generic[56] >>= vec2.generic[0];
	vec1.generic[57] >>= vec2.generic[0];
	vec1.generic[58] >>= vec2.generic[0];
	vec1.generic[59] >>= vec2.generic[0];
	vec1.generic[60] >>= vec2.generic[0];
	vec1.generic[61] >>= vec2.generic[0];
	vec1.generic[62] >>= vec2.generic[0];
	vec1.generic[63] >>= vec2.generic[0];
	return vec1;
}
# define VUINT8x64_LRSHIFT_DEFINED
#endif
#if !defined(VUINT8x64_LSHIFT_DEFINED)
VEC_FUNC_IMPL vuint8x64 vuint8x64_lshift(vuint8x64 vec1, vuint8x64 vec2)
{
	vec1.generic[0] <<= vec2.generic[0];
	vec1.generic[1] <<= vec2.generic[0];
	vec1.generic[2] <<= vec2.generic[0];
	vec1.generic[3] <<= vec2.generic[0];
	vec1.generic[4] <<= vec2.generic[0];
	vec1.generic[5] <<= vec2.generic[0];
	vec1.generic[6] <<= vec2.generic[0];
	vec1.generic[7] <<= vec2.generic[0];
	vec1.generic[8] <<= vec2.generic[0];
	vec1.generic[9] <<= vec2.generic[0];
	vec1.generic[10] <<= vec2.generic[0];
	vec1.generic[11] <<= vec2.generic[0];
	vec1.generic[12] <<= vec2.generic[0];
	vec1.generic[13] <<= vec2.generic[0];
	vec1.generic[14] <<= vec2.generic[0];
	vec1.generic[15] <<= vec2.generic[0];
	vec1.generic[16] <<= vec2.generic[0];
	vec1.generic[17] <<= vec2.generic[0];
	vec1.generic[18] <<= vec2.generic[0];
	vec1.generic[19] <<= vec2.generic[0];
	vec1.generic[20] <<= vec2.generic[0];
	vec1.generic[21] <<= vec2.generic[0];
	vec1.generic[22] <<= vec2.generic[0];
	vec1.generic[23] <<= vec2.generic[0];
	vec1.generic[24] <<= vec2.generic[0];
	vec1.generic[25] <<= vec2.generic[0];
	vec1.generic[26] <<= vec2.generic[0];
	vec1.generic[27] <<= vec2.generic[0];
	vec1.generic[28] <<= vec2.generic[0];
	vec1.generic[29] <<= vec2.generic[0];
	vec1.generic[30] <<= vec2.generic[0];
	vec1.generic[31] <<= vec2.generic[0];
	vec1.generic[32] <<= vec2.generic[0];
	vec1.generic[33] <<= vec2.generic[0];
	vec1.generic[34] <<= vec2.generic[0];
	vec1.generic[35] <<= vec2.generic[0];
	vec1.generic[36] <<= vec2.generic[0];
	vec1.generic[37] <<= vec2.generic[0];
	vec1.generic[38] <<= vec2.generic[0];
	vec1.generic[39] <<= vec2.generic[0];
	vec1.generic[40] <<= vec2.generic[0];
	vec1.generic[41] <<= vec2.generic[0];
	vec1.generic[42] <<= vec2.generic[0];
	vec1.generic[43] <<= vec2.generic[0];
	vec1.generic[44] <<= vec2.generic[0];
	vec1.generic[45] <<= vec2.generic[0];
	vec1.generic[46] <<= vec2.generic[0];
	vec1.generic[47] <<= vec2.generic[0];
	vec1.generic[48] <<= vec2.generic[0];
	vec1.generic[49] <<= vec2.generic[0];
	vec1.generic[50] <<= vec2.generic[0];
	vec1.generic[51] <<= vec2.generic[0];
	vec1.generic[52] <<= vec2.generic[0];
	vec1.generic[53] <<= vec2.generic[0];
	vec1.generic[54] <<= vec2.generic[0];
	vec1.generic[55] <<= vec2.generic[0];
	vec1.generic[56] <<= vec2.generic[0];
	vec1.generic[57] <<= vec2.generic[0];
	vec1.generic[58] <<= vec2.generic[0];
	vec1.generic[59] <<= vec2.generic[0];
	vec1.generic[60] <<= vec2.generic[0];
	vec1.generic[61] <<= vec2.generic[0];
	vec1.generic[62] <<= vec2.generic[0];
	vec1.generic[63] <<= vec2.generic[0];
	return vec1;
}
# define VUINT8x64_LSHIFT_DEFINED
#endif
#if !defined(VINT16x2_SPLAT_DEFINED)
VEC_FUNC_IMPL vint16x2 vint16x2_splat(vec_int16 x)
{
	vint16x2 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	return vec;
}
# define VINT16x2_SPLAT_DEFINED
#endif
#if !defined(VINT16x2_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vint16x2 vint16x2_load_aligned(const vec_int16 x[2])
{
	vint16x2 vec;
	memcpy(vec.generic, x, 4);
	return vec;
}
# define VINT16x2_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VINT16x2_LOAD_DEFINED)
VEC_FUNC_IMPL vint16x2 vint16x2_load(const vec_int16 x[2])
{
	vint16x2 vec;
	memcpy(vec.generic, x, 4);
	return vec;
}
# define VINT16x2_LOAD_DEFINED
#endif
#if !defined(VINT16x2_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vint16x2_store_aligned(vint16x2 vec, vec_int16 x[2])
{
	memcpy(x, vec.generic, 4);
}
# define VINT16x2_STORE_ALIGNED_DEFINED
#endif
#if !defined(VINT16x2_STORE_DEFINED)
VEC_FUNC_IMPL void vint16x2_store(vint16x2 vec, vec_int16 x[2])
{
	memcpy(x, vec.generic, 4);
}
# define VINT16x2_STORE_DEFINED
#endif
#if !defined(VINT16x2_ADD_DEFINED)
VEC_FUNC_IMPL vint16x2 vint16x2_add(vint16x2 vec1, vint16x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	return vec1;
}
# define VINT16x2_ADD_DEFINED
#endif
#if !defined(VINT16x2_SUB_DEFINED)
VEC_FUNC_IMPL vint16x2 vint16x2_sub(vint16x2 vec1, vint16x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	return vec1;
}
# define VINT16x2_SUB_DEFINED
#endif
#if !defined(VINT16x2_MUL_DEFINED)
VEC_FUNC_IMPL vint16x2 vint16x2_mul(vint16x2 vec1, vint16x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	return vec1;
}
# define VINT16x2_MUL_DEFINED
#endif
#if !defined(VINT16x2_DIV_DEFINED)
VEC_FUNC_IMPL vint16x2 vint16x2_div(vint16x2 vec1, vint16x2 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	return vec1;
}
# define VINT16x2_DIV_DEFINED
#endif
#if !defined(VINT16x2_MOD_DEFINED)
VEC_FUNC_IMPL vint16x2 vint16x2_mod(vint16x2 vec1, vint16x2 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	return vec1;
}
# define VINT16x2_MOD_DEFINED
#endif
#if !defined(VINT16x2_AVG_DEFINED)
VEC_FUNC_IMPL vint16x2 vint16x2_avg(vint16x2 vec1, vint16x2 vec2)
{
	vec_int16 x_d_rem, y_d_rem, rem_d_quot, rem_d_rem;
	x_d_rem = (vec1.generic[0] % 2);
	y_d_rem = (vec2.generic[0] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[0] = ((vec1.generic[0] / 2) + (vec2.generic[0] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[1] % 2);
	y_d_rem = (vec2.generic[1] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[1] = ((vec1.generic[1] / 2) + (vec2.generic[1] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	return vec1;
}
# define VINT16x2_AVG_DEFINED
#endif
#if !defined(VINT16x2_AND_DEFINED)
VEC_FUNC_IMPL vint16x2 vint16x2_and(vint16x2 vec1, vint16x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	return vec1;
}
# define VINT16x2_AND_DEFINED
#endif
#if !defined(VINT16x2_OR_DEFINED)
VEC_FUNC_IMPL vint16x2 vint16x2_or(vint16x2 vec1, vint16x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	return vec1;
}
# define VINT16x2_OR_DEFINED
#endif
#if !defined(VINT16x2_XOR_DEFINED)
VEC_FUNC_IMPL vint16x2 vint16x2_xor(vint16x2 vec1, vint16x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	return vec1;
}
# define VINT16x2_XOR_DEFINED
#endif
#if !defined(VINT16x2_NOT_DEFINED)
VEC_FUNC_IMPL vint16x2 vint16x2_not(vint16x2 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	return vec;
}
# define VINT16x2_NOT_DEFINED
#endif
#if !defined(VINT16x2_CMPLT_DEFINED)
VEC_FUNC_IMPL vint16x2 vint16x2_cmplt(vint16x2 vec1, vint16x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 2);
	return vec1;
}
# define VINT16x2_CMPLT_DEFINED
#endif
#if !defined(VINT16x2_CMPEQ_DEFINED)
VEC_FUNC_IMPL vint16x2 vint16x2_cmpeq(vint16x2 vec1, vint16x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 2);
	return vec1;
}
# define VINT16x2_CMPEQ_DEFINED
#endif
#if !defined(VINT16x2_CMPGT_DEFINED)
VEC_FUNC_IMPL vint16x2 vint16x2_cmpgt(vint16x2 vec1, vint16x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 2);
	return vec1;
}
# define VINT16x2_CMPGT_DEFINED
#endif
#if !defined(VINT16x2_CMPLE_DEFINED)
VEC_FUNC_IMPL vint16x2 vint16x2_cmple(vint16x2 vec1, vint16x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 2);
	return vec1;
}
# define VINT16x2_CMPLE_DEFINED
#endif
#if !defined(VINT16x2_CMPGE_DEFINED)
VEC_FUNC_IMPL vint16x2 vint16x2_cmpge(vint16x2 vec1, vint16x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 2);
	return vec1;
}
# define VINT16x2_CMPGE_DEFINED
#endif
#if !defined(VINT16x2_MIN_DEFINED)
VEC_FUNC_IMPL vint16x2 vint16x2_min(vint16x2 vec1, vint16x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	return vec1;
}
# define VINT16x2_MIN_DEFINED
#endif
#if !defined(VINT16x2_MAX_DEFINED)
VEC_FUNC_IMPL vint16x2 vint16x2_max(vint16x2 vec1, vint16x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	return vec1;
}
# define VINT16x2_MAX_DEFINED
#endif
#if !defined(VINT16x2_RSHIFT_DEFINED)
VEC_FUNC_IMPL vint16x2 vint16x2_rshift(vint16x2 vec1, vuint16x2 vec2)
{
vec1.generic[0] = ((~vec1.generic[0]) >> vec2.generic[0]);
vec1.generic[1] = ((~vec1.generic[1]) >> vec2.generic[1]);
	return vec1;
}
# define VINT16x2_RSHIFT_DEFINED
#endif
#if !defined(VINT16x2_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vint16x2 vint16x2_lrshift(vint16x2 vec1, vuint16x2 vec2)
{
	union { vec_uint16 u; vec_int16 s; } x;

	x.s = vec1.generic[0];
	x.u >>= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u >>= vec2.generic[1];
	vec1.generic[1] = x.s;
	return vec1;
}
# define VINT16x2_LRSHIFT_DEFINED
#endif
#if !defined(VINT16x2_LSHIFT_DEFINED)
VEC_FUNC_IMPL vint16x2 vint16x2_lshift(vint16x2 vec1, vuint16x2 vec2)
{
	union { vec_uint16 u; vec_int16 s; } x;

	x.s = vec1.generic[0];
	x.u <<= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u <<= vec2.generic[1];
	vec1.generic[1] = x.s;
	return vec1;
}
# define VINT16x2_LSHIFT_DEFINED
#endif
#if !defined(VUINT16x2_SPLAT_DEFINED)
VEC_FUNC_IMPL vuint16x2 vuint16x2_splat(vec_uint16 x)
{
	vuint16x2 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	return vec;
}
# define VUINT16x2_SPLAT_DEFINED
#endif
#if !defined(VUINT16x2_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vuint16x2 vuint16x2_load_aligned(const vec_uint16 x[2])
{
	vuint16x2 vec;
	memcpy(vec.generic, x, 4);
	return vec;
}
# define VUINT16x2_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VUINT16x2_LOAD_DEFINED)
VEC_FUNC_IMPL vuint16x2 vuint16x2_load(const vec_uint16 x[2])
{
	vuint16x2 vec;
	memcpy(vec.generic, x, 4);
	return vec;
}
# define VUINT16x2_LOAD_DEFINED
#endif
#if !defined(VUINT16x2_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vuint16x2_store_aligned(vuint16x2 vec, vec_uint16 x[2])
{
	memcpy(x, vec.generic, 4);
}
# define VUINT16x2_STORE_ALIGNED_DEFINED
#endif
#if !defined(VUINT16x2_STORE_DEFINED)
VEC_FUNC_IMPL void vuint16x2_store(vuint16x2 vec, vec_uint16 x[2])
{
	memcpy(x, vec.generic, 4);
}
# define VUINT16x2_STORE_DEFINED
#endif
#if !defined(VUINT16x2_ADD_DEFINED)
VEC_FUNC_IMPL vuint16x2 vuint16x2_add(vuint16x2 vec1, vuint16x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	return vec1;
}
# define VUINT16x2_ADD_DEFINED
#endif
#if !defined(VUINT16x2_SUB_DEFINED)
VEC_FUNC_IMPL vuint16x2 vuint16x2_sub(vuint16x2 vec1, vuint16x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	return vec1;
}
# define VUINT16x2_SUB_DEFINED
#endif
#if !defined(VUINT16x2_MUL_DEFINED)
VEC_FUNC_IMPL vuint16x2 vuint16x2_mul(vuint16x2 vec1, vuint16x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	return vec1;
}
# define VUINT16x2_MUL_DEFINED
#endif
#if !defined(VUINT16x2_DIV_DEFINED)
VEC_FUNC_IMPL vuint16x2 vuint16x2_div(vuint16x2 vec1, vuint16x2 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	return vec1;
}
# define VUINT16x2_DIV_DEFINED
#endif
#if !defined(VUINT16x2_MOD_DEFINED)
VEC_FUNC_IMPL vuint16x2 vuint16x2_mod(vuint16x2 vec1, vuint16x2 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	return vec1;
}
# define VUINT16x2_MOD_DEFINED
#endif
#if !defined(VUINT16x2_AVG_DEFINED)
VEC_FUNC_IMPL vuint16x2 vuint16x2_avg(vuint16x2 vec1, vuint16x2 vec2)
{
vec1.generic[0] = (vec1.generic[0] >> 1) + (vec2.generic[0] >> 1) + ((vec1.generic[0] | vec2.generic[0]) & 1);
vec1.generic[1] = (vec1.generic[1] >> 1) + (vec2.generic[1] >> 1) + ((vec1.generic[1] | vec2.generic[1]) & 1);
	return vec1;
}
# define VUINT16x2_AVG_DEFINED
#endif
#if !defined(VUINT16x2_AND_DEFINED)
VEC_FUNC_IMPL vuint16x2 vuint16x2_and(vuint16x2 vec1, vuint16x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	return vec1;
}
# define VUINT16x2_AND_DEFINED
#endif
#if !defined(VUINT16x2_OR_DEFINED)
VEC_FUNC_IMPL vuint16x2 vuint16x2_or(vuint16x2 vec1, vuint16x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	return vec1;
}
# define VUINT16x2_OR_DEFINED
#endif
#if !defined(VUINT16x2_XOR_DEFINED)
VEC_FUNC_IMPL vuint16x2 vuint16x2_xor(vuint16x2 vec1, vuint16x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	return vec1;
}
# define VUINT16x2_XOR_DEFINED
#endif
#if !defined(VUINT16x2_NOT_DEFINED)
VEC_FUNC_IMPL vuint16x2 vuint16x2_not(vuint16x2 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	return vec;
}
# define VUINT16x2_NOT_DEFINED
#endif
#if !defined(VUINT16x2_CMPLT_DEFINED)
VEC_FUNC_IMPL vuint16x2 vuint16x2_cmplt(vuint16x2 vec1, vuint16x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 2);
	return vec1;
}
# define VUINT16x2_CMPLT_DEFINED
#endif
#if !defined(VUINT16x2_CMPEQ_DEFINED)
VEC_FUNC_IMPL vuint16x2 vuint16x2_cmpeq(vuint16x2 vec1, vuint16x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 2);
	return vec1;
}
# define VUINT16x2_CMPEQ_DEFINED
#endif
#if !defined(VUINT16x2_CMPGT_DEFINED)
VEC_FUNC_IMPL vuint16x2 vuint16x2_cmpgt(vuint16x2 vec1, vuint16x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 2);
	return vec1;
}
# define VUINT16x2_CMPGT_DEFINED
#endif
#if !defined(VUINT16x2_CMPLE_DEFINED)
VEC_FUNC_IMPL vuint16x2 vuint16x2_cmple(vuint16x2 vec1, vuint16x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 2);
	return vec1;
}
# define VUINT16x2_CMPLE_DEFINED
#endif
#if !defined(VUINT16x2_CMPGE_DEFINED)
VEC_FUNC_IMPL vuint16x2 vuint16x2_cmpge(vuint16x2 vec1, vuint16x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 2);
	return vec1;
}
# define VUINT16x2_CMPGE_DEFINED
#endif
#if !defined(VUINT16x2_MIN_DEFINED)
VEC_FUNC_IMPL vuint16x2 vuint16x2_min(vuint16x2 vec1, vuint16x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	return vec1;
}
# define VUINT16x2_MIN_DEFINED
#endif
#if !defined(VUINT16x2_MAX_DEFINED)
VEC_FUNC_IMPL vuint16x2 vuint16x2_max(vuint16x2 vec1, vuint16x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	return vec1;
}
# define VUINT16x2_MAX_DEFINED
#endif
#if !defined(VUINT16x2_RSHIFT_DEFINED)
VEC_FUNC_IMPL vuint16x2 vuint16x2_rshift(vuint16x2 vec1, vuint16x2 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	return vec1;
}
# define VUINT16x2_RSHIFT_DEFINED
#endif
#if !defined(VUINT16x2_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vuint16x2 vuint16x2_lrshift(vuint16x2 vec1, vuint16x2 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	return vec1;
}
# define VUINT16x2_LRSHIFT_DEFINED
#endif
#if !defined(VUINT16x2_LSHIFT_DEFINED)
VEC_FUNC_IMPL vuint16x2 vuint16x2_lshift(vuint16x2 vec1, vuint16x2 vec2)
{
	vec1.generic[0] <<= vec2.generic[0];
	vec1.generic[1] <<= vec2.generic[0];
	return vec1;
}
# define VUINT16x2_LSHIFT_DEFINED
#endif
#if !defined(VINT16x4_SPLAT_DEFINED)
VEC_FUNC_IMPL vint16x4 vint16x4_splat(vec_int16 x)
{
	vint16x4 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	return vec;
}
# define VINT16x4_SPLAT_DEFINED
#endif
#if !defined(VINT16x4_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vint16x4 vint16x4_load_aligned(const vec_int16 x[4])
{
	vint16x4 vec;
	memcpy(vec.generic, x, 8);
	return vec;
}
# define VINT16x4_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VINT16x4_LOAD_DEFINED)
VEC_FUNC_IMPL vint16x4 vint16x4_load(const vec_int16 x[4])
{
	vint16x4 vec;
	memcpy(vec.generic, x, 8);
	return vec;
}
# define VINT16x4_LOAD_DEFINED
#endif
#if !defined(VINT16x4_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vint16x4_store_aligned(vint16x4 vec, vec_int16 x[4])
{
	memcpy(x, vec.generic, 8);
}
# define VINT16x4_STORE_ALIGNED_DEFINED
#endif
#if !defined(VINT16x4_STORE_DEFINED)
VEC_FUNC_IMPL void vint16x4_store(vint16x4 vec, vec_int16 x[4])
{
	memcpy(x, vec.generic, 8);
}
# define VINT16x4_STORE_DEFINED
#endif
#if !defined(VINT16x4_ADD_DEFINED)
VEC_FUNC_IMPL vint16x4 vint16x4_add(vint16x4 vec1, vint16x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	return vec1;
}
# define VINT16x4_ADD_DEFINED
#endif
#if !defined(VINT16x4_SUB_DEFINED)
VEC_FUNC_IMPL vint16x4 vint16x4_sub(vint16x4 vec1, vint16x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	return vec1;
}
# define VINT16x4_SUB_DEFINED
#endif
#if !defined(VINT16x4_MUL_DEFINED)
VEC_FUNC_IMPL vint16x4 vint16x4_mul(vint16x4 vec1, vint16x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	return vec1;
}
# define VINT16x4_MUL_DEFINED
#endif
#if !defined(VINT16x4_DIV_DEFINED)
VEC_FUNC_IMPL vint16x4 vint16x4_div(vint16x4 vec1, vint16x4 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	return vec1;
}
# define VINT16x4_DIV_DEFINED
#endif
#if !defined(VINT16x4_MOD_DEFINED)
VEC_FUNC_IMPL vint16x4 vint16x4_mod(vint16x4 vec1, vint16x4 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	return vec1;
}
# define VINT16x4_MOD_DEFINED
#endif
#if !defined(VINT16x4_AVG_DEFINED)
VEC_FUNC_IMPL vint16x4 vint16x4_avg(vint16x4 vec1, vint16x4 vec2)
{
	vec_int16 x_d_rem, y_d_rem, rem_d_quot, rem_d_rem;
	x_d_rem = (vec1.generic[0] % 2);
	y_d_rem = (vec2.generic[0] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[0] = ((vec1.generic[0] / 2) + (vec2.generic[0] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[1] % 2);
	y_d_rem = (vec2.generic[1] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[1] = ((vec1.generic[1] / 2) + (vec2.generic[1] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[2] % 2);
	y_d_rem = (vec2.generic[2] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[2] = ((vec1.generic[2] / 2) + (vec2.generic[2] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[3] % 2);
	y_d_rem = (vec2.generic[3] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[3] = ((vec1.generic[3] / 2) + (vec2.generic[3] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	return vec1;
}
# define VINT16x4_AVG_DEFINED
#endif
#if !defined(VINT16x4_AND_DEFINED)
VEC_FUNC_IMPL vint16x4 vint16x4_and(vint16x4 vec1, vint16x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	return vec1;
}
# define VINT16x4_AND_DEFINED
#endif
#if !defined(VINT16x4_OR_DEFINED)
VEC_FUNC_IMPL vint16x4 vint16x4_or(vint16x4 vec1, vint16x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	return vec1;
}
# define VINT16x4_OR_DEFINED
#endif
#if !defined(VINT16x4_XOR_DEFINED)
VEC_FUNC_IMPL vint16x4 vint16x4_xor(vint16x4 vec1, vint16x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	return vec1;
}
# define VINT16x4_XOR_DEFINED
#endif
#if !defined(VINT16x4_NOT_DEFINED)
VEC_FUNC_IMPL vint16x4 vint16x4_not(vint16x4 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	return vec;
}
# define VINT16x4_NOT_DEFINED
#endif
#if !defined(VINT16x4_CMPLT_DEFINED)
VEC_FUNC_IMPL vint16x4 vint16x4_cmplt(vint16x4 vec1, vint16x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 2);
	return vec1;
}
# define VINT16x4_CMPLT_DEFINED
#endif
#if !defined(VINT16x4_CMPEQ_DEFINED)
VEC_FUNC_IMPL vint16x4 vint16x4_cmpeq(vint16x4 vec1, vint16x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 2);
	return vec1;
}
# define VINT16x4_CMPEQ_DEFINED
#endif
#if !defined(VINT16x4_CMPGT_DEFINED)
VEC_FUNC_IMPL vint16x4 vint16x4_cmpgt(vint16x4 vec1, vint16x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 2);
	return vec1;
}
# define VINT16x4_CMPGT_DEFINED
#endif
#if !defined(VINT16x4_CMPLE_DEFINED)
VEC_FUNC_IMPL vint16x4 vint16x4_cmple(vint16x4 vec1, vint16x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 2);
	return vec1;
}
# define VINT16x4_CMPLE_DEFINED
#endif
#if !defined(VINT16x4_CMPGE_DEFINED)
VEC_FUNC_IMPL vint16x4 vint16x4_cmpge(vint16x4 vec1, vint16x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 2);
	return vec1;
}
# define VINT16x4_CMPGE_DEFINED
#endif
#if !defined(VINT16x4_MIN_DEFINED)
VEC_FUNC_IMPL vint16x4 vint16x4_min(vint16x4 vec1, vint16x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	return vec1;
}
# define VINT16x4_MIN_DEFINED
#endif
#if !defined(VINT16x4_MAX_DEFINED)
VEC_FUNC_IMPL vint16x4 vint16x4_max(vint16x4 vec1, vint16x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	return vec1;
}
# define VINT16x4_MAX_DEFINED
#endif
#if !defined(VINT16x4_RSHIFT_DEFINED)
VEC_FUNC_IMPL vint16x4 vint16x4_rshift(vint16x4 vec1, vuint16x4 vec2)
{
vec1.generic[0] = ((~vec1.generic[0]) >> vec2.generic[0]);
vec1.generic[1] = ((~vec1.generic[1]) >> vec2.generic[1]);
vec1.generic[2] = ((~vec1.generic[2]) >> vec2.generic[2]);
vec1.generic[3] = ((~vec1.generic[3]) >> vec2.generic[3]);
	return vec1;
}
# define VINT16x4_RSHIFT_DEFINED
#endif
#if !defined(VINT16x4_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vint16x4 vint16x4_lrshift(vint16x4 vec1, vuint16x4 vec2)
{
	union { vec_uint16 u; vec_int16 s; } x;

	x.s = vec1.generic[0];
	x.u >>= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u >>= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u >>= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u >>= vec2.generic[3];
	vec1.generic[3] = x.s;
	return vec1;
}
# define VINT16x4_LRSHIFT_DEFINED
#endif
#if !defined(VINT16x4_LSHIFT_DEFINED)
VEC_FUNC_IMPL vint16x4 vint16x4_lshift(vint16x4 vec1, vuint16x4 vec2)
{
	union { vec_uint16 u; vec_int16 s; } x;

	x.s = vec1.generic[0];
	x.u <<= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u <<= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u <<= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u <<= vec2.generic[3];
	vec1.generic[3] = x.s;
	return vec1;
}
# define VINT16x4_LSHIFT_DEFINED
#endif
#if !defined(VUINT16x4_SPLAT_DEFINED)
VEC_FUNC_IMPL vuint16x4 vuint16x4_splat(vec_uint16 x)
{
	vuint16x4 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	return vec;
}
# define VUINT16x4_SPLAT_DEFINED
#endif
#if !defined(VUINT16x4_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vuint16x4 vuint16x4_load_aligned(const vec_uint16 x[4])
{
	vuint16x4 vec;
	memcpy(vec.generic, x, 8);
	return vec;
}
# define VUINT16x4_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VUINT16x4_LOAD_DEFINED)
VEC_FUNC_IMPL vuint16x4 vuint16x4_load(const vec_uint16 x[4])
{
	vuint16x4 vec;
	memcpy(vec.generic, x, 8);
	return vec;
}
# define VUINT16x4_LOAD_DEFINED
#endif
#if !defined(VUINT16x4_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vuint16x4_store_aligned(vuint16x4 vec, vec_uint16 x[4])
{
	memcpy(x, vec.generic, 8);
}
# define VUINT16x4_STORE_ALIGNED_DEFINED
#endif
#if !defined(VUINT16x4_STORE_DEFINED)
VEC_FUNC_IMPL void vuint16x4_store(vuint16x4 vec, vec_uint16 x[4])
{
	memcpy(x, vec.generic, 8);
}
# define VUINT16x4_STORE_DEFINED
#endif
#if !defined(VUINT16x4_ADD_DEFINED)
VEC_FUNC_IMPL vuint16x4 vuint16x4_add(vuint16x4 vec1, vuint16x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	return vec1;
}
# define VUINT16x4_ADD_DEFINED
#endif
#if !defined(VUINT16x4_SUB_DEFINED)
VEC_FUNC_IMPL vuint16x4 vuint16x4_sub(vuint16x4 vec1, vuint16x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	return vec1;
}
# define VUINT16x4_SUB_DEFINED
#endif
#if !defined(VUINT16x4_MUL_DEFINED)
VEC_FUNC_IMPL vuint16x4 vuint16x4_mul(vuint16x4 vec1, vuint16x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	return vec1;
}
# define VUINT16x4_MUL_DEFINED
#endif
#if !defined(VUINT16x4_DIV_DEFINED)
VEC_FUNC_IMPL vuint16x4 vuint16x4_div(vuint16x4 vec1, vuint16x4 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	return vec1;
}
# define VUINT16x4_DIV_DEFINED
#endif
#if !defined(VUINT16x4_MOD_DEFINED)
VEC_FUNC_IMPL vuint16x4 vuint16x4_mod(vuint16x4 vec1, vuint16x4 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	return vec1;
}
# define VUINT16x4_MOD_DEFINED
#endif
#if !defined(VUINT16x4_AVG_DEFINED)
VEC_FUNC_IMPL vuint16x4 vuint16x4_avg(vuint16x4 vec1, vuint16x4 vec2)
{
vec1.generic[0] = (vec1.generic[0] >> 1) + (vec2.generic[0] >> 1) + ((vec1.generic[0] | vec2.generic[0]) & 1);
vec1.generic[1] = (vec1.generic[1] >> 1) + (vec2.generic[1] >> 1) + ((vec1.generic[1] | vec2.generic[1]) & 1);
vec1.generic[2] = (vec1.generic[2] >> 1) + (vec2.generic[2] >> 1) + ((vec1.generic[2] | vec2.generic[2]) & 1);
vec1.generic[3] = (vec1.generic[3] >> 1) + (vec2.generic[3] >> 1) + ((vec1.generic[3] | vec2.generic[3]) & 1);
	return vec1;
}
# define VUINT16x4_AVG_DEFINED
#endif
#if !defined(VUINT16x4_AND_DEFINED)
VEC_FUNC_IMPL vuint16x4 vuint16x4_and(vuint16x4 vec1, vuint16x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	return vec1;
}
# define VUINT16x4_AND_DEFINED
#endif
#if !defined(VUINT16x4_OR_DEFINED)
VEC_FUNC_IMPL vuint16x4 vuint16x4_or(vuint16x4 vec1, vuint16x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	return vec1;
}
# define VUINT16x4_OR_DEFINED
#endif
#if !defined(VUINT16x4_XOR_DEFINED)
VEC_FUNC_IMPL vuint16x4 vuint16x4_xor(vuint16x4 vec1, vuint16x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	return vec1;
}
# define VUINT16x4_XOR_DEFINED
#endif
#if !defined(VUINT16x4_NOT_DEFINED)
VEC_FUNC_IMPL vuint16x4 vuint16x4_not(vuint16x4 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	return vec;
}
# define VUINT16x4_NOT_DEFINED
#endif
#if !defined(VUINT16x4_CMPLT_DEFINED)
VEC_FUNC_IMPL vuint16x4 vuint16x4_cmplt(vuint16x4 vec1, vuint16x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 2);
	return vec1;
}
# define VUINT16x4_CMPLT_DEFINED
#endif
#if !defined(VUINT16x4_CMPEQ_DEFINED)
VEC_FUNC_IMPL vuint16x4 vuint16x4_cmpeq(vuint16x4 vec1, vuint16x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 2);
	return vec1;
}
# define VUINT16x4_CMPEQ_DEFINED
#endif
#if !defined(VUINT16x4_CMPGT_DEFINED)
VEC_FUNC_IMPL vuint16x4 vuint16x4_cmpgt(vuint16x4 vec1, vuint16x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 2);
	return vec1;
}
# define VUINT16x4_CMPGT_DEFINED
#endif
#if !defined(VUINT16x4_CMPLE_DEFINED)
VEC_FUNC_IMPL vuint16x4 vuint16x4_cmple(vuint16x4 vec1, vuint16x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 2);
	return vec1;
}
# define VUINT16x4_CMPLE_DEFINED
#endif
#if !defined(VUINT16x4_CMPGE_DEFINED)
VEC_FUNC_IMPL vuint16x4 vuint16x4_cmpge(vuint16x4 vec1, vuint16x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 2);
	return vec1;
}
# define VUINT16x4_CMPGE_DEFINED
#endif
#if !defined(VUINT16x4_MIN_DEFINED)
VEC_FUNC_IMPL vuint16x4 vuint16x4_min(vuint16x4 vec1, vuint16x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	return vec1;
}
# define VUINT16x4_MIN_DEFINED
#endif
#if !defined(VUINT16x4_MAX_DEFINED)
VEC_FUNC_IMPL vuint16x4 vuint16x4_max(vuint16x4 vec1, vuint16x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	return vec1;
}
# define VUINT16x4_MAX_DEFINED
#endif
#if !defined(VUINT16x4_RSHIFT_DEFINED)
VEC_FUNC_IMPL vuint16x4 vuint16x4_rshift(vuint16x4 vec1, vuint16x4 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	return vec1;
}
# define VUINT16x4_RSHIFT_DEFINED
#endif
#if !defined(VUINT16x4_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vuint16x4 vuint16x4_lrshift(vuint16x4 vec1, vuint16x4 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	return vec1;
}
# define VUINT16x4_LRSHIFT_DEFINED
#endif
#if !defined(VUINT16x4_LSHIFT_DEFINED)
VEC_FUNC_IMPL vuint16x4 vuint16x4_lshift(vuint16x4 vec1, vuint16x4 vec2)
{
	vec1.generic[0] <<= vec2.generic[0];
	vec1.generic[1] <<= vec2.generic[0];
	vec1.generic[2] <<= vec2.generic[0];
	vec1.generic[3] <<= vec2.generic[0];
	return vec1;
}
# define VUINT16x4_LSHIFT_DEFINED
#endif
#if !defined(VINT16x8_SPLAT_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_splat(vec_int16 x)
{
	vint16x8 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	vec.generic[4] = x;
	vec.generic[5] = x;
	vec.generic[6] = x;
	vec.generic[7] = x;
	return vec;
}
# define VINT16x8_SPLAT_DEFINED
#endif
#if !defined(VINT16x8_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_load_aligned(const vec_int16 x[8])
{
	vint16x8 vec;
	memcpy(vec.generic, x, 16);
	return vec;
}
# define VINT16x8_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VINT16x8_LOAD_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_load(const vec_int16 x[8])
{
	vint16x8 vec;
	memcpy(vec.generic, x, 16);
	return vec;
}
# define VINT16x8_LOAD_DEFINED
#endif
#if !defined(VINT16x8_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vint16x8_store_aligned(vint16x8 vec, vec_int16 x[8])
{
	memcpy(x, vec.generic, 16);
}
# define VINT16x8_STORE_ALIGNED_DEFINED
#endif
#if !defined(VINT16x8_STORE_DEFINED)
VEC_FUNC_IMPL void vint16x8_store(vint16x8 vec, vec_int16 x[8])
{
	memcpy(x, vec.generic, 16);
}
# define VINT16x8_STORE_DEFINED
#endif
#if !defined(VINT16x8_ADD_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_add(vint16x8 vec1, vint16x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]);
	return vec1;
}
# define VINT16x8_ADD_DEFINED
#endif
#if !defined(VINT16x8_SUB_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_sub(vint16x8 vec1, vint16x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] - vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] - vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] - vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] - vec2.generic[7]);
	return vec1;
}
# define VINT16x8_SUB_DEFINED
#endif
#if !defined(VINT16x8_MUL_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_mul(vint16x8 vec1, vint16x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] * vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] * vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] * vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] * vec2.generic[7]);
	return vec1;
}
# define VINT16x8_MUL_DEFINED
#endif
#if !defined(VINT16x8_DIV_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_div(vint16x8 vec1, vint16x8 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] / vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] / vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] / vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] / vec2.generic[7]) : 0);
	return vec1;
}
# define VINT16x8_DIV_DEFINED
#endif
#if !defined(VINT16x8_MOD_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_mod(vint16x8 vec1, vint16x8 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] % vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] % vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] % vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] % vec2.generic[7]) : 0);
	return vec1;
}
# define VINT16x8_MOD_DEFINED
#endif
#if !defined(VINT16x8_AVG_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_avg(vint16x8 vec1, vint16x8 vec2)
{
	vec_int16 x_d_rem, y_d_rem, rem_d_quot, rem_d_rem;
	x_d_rem = (vec1.generic[0] % 2);
	y_d_rem = (vec2.generic[0] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[0] = ((vec1.generic[0] / 2) + (vec2.generic[0] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[1] % 2);
	y_d_rem = (vec2.generic[1] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[1] = ((vec1.generic[1] / 2) + (vec2.generic[1] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[2] % 2);
	y_d_rem = (vec2.generic[2] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[2] = ((vec1.generic[2] / 2) + (vec2.generic[2] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[3] % 2);
	y_d_rem = (vec2.generic[3] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[3] = ((vec1.generic[3] / 2) + (vec2.generic[3] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[4] % 2);
	y_d_rem = (vec2.generic[4] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[4] = ((vec1.generic[4] / 2) + (vec2.generic[4] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[5] % 2);
	y_d_rem = (vec2.generic[5] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[5] = ((vec1.generic[5] / 2) + (vec2.generic[5] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[6] % 2);
	y_d_rem = (vec2.generic[6] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[6] = ((vec1.generic[6] / 2) + (vec2.generic[6] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[7] % 2);
	y_d_rem = (vec2.generic[7] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[7] = ((vec1.generic[7] / 2) + (vec2.generic[7] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	return vec1;
}
# define VINT16x8_AVG_DEFINED
#endif
#if !defined(VINT16x8_AND_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_and(vint16x8 vec1, vint16x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] & vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] & vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] & vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] & vec2.generic[7]);
	return vec1;
}
# define VINT16x8_AND_DEFINED
#endif
#if !defined(VINT16x8_OR_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_or(vint16x8 vec1, vint16x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] | vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] | vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] | vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] | vec2.generic[7]);
	return vec1;
}
# define VINT16x8_OR_DEFINED
#endif
#if !defined(VINT16x8_XOR_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_xor(vint16x8 vec1, vint16x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] ^ vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] ^ vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] ^ vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] ^ vec2.generic[7]);
	return vec1;
}
# define VINT16x8_XOR_DEFINED
#endif
#if !defined(VINT16x8_NOT_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_not(vint16x8 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	vec.generic[4] = ~vec.generic[4];
	vec.generic[5] = ~vec.generic[5];
	vec.generic[6] = ~vec.generic[6];
	vec.generic[7] = ~vec.generic[7];
	return vec;
}
# define VINT16x8_NOT_DEFINED
#endif
#if !defined(VINT16x8_CMPLT_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_cmplt(vint16x8 vec1, vint16x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] < vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] < vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] < vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] < vec2.generic[7]) ? 0xFF : 0, 2);
	return vec1;
}
# define VINT16x8_CMPLT_DEFINED
#endif
#if !defined(VINT16x8_CMPEQ_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_cmpeq(vint16x8 vec1, vint16x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] == vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] == vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] == vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] == vec2.generic[7]) ? 0xFF : 0, 2);
	return vec1;
}
# define VINT16x8_CMPEQ_DEFINED
#endif
#if !defined(VINT16x8_CMPGT_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_cmpgt(vint16x8 vec1, vint16x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] > vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] > vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] > vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] > vec2.generic[7]) ? 0xFF : 0, 2);
	return vec1;
}
# define VINT16x8_CMPGT_DEFINED
#endif
#if !defined(VINT16x8_CMPLE_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_cmple(vint16x8 vec1, vint16x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] <= vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] <= vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] <= vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] <= vec2.generic[7]) ? 0xFF : 0, 2);
	return vec1;
}
# define VINT16x8_CMPLE_DEFINED
#endif
#if !defined(VINT16x8_CMPGE_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_cmpge(vint16x8 vec1, vint16x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] >= vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] >= vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] >= vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] >= vec2.generic[7]) ? 0xFF : 0, 2);
	return vec1;
}
# define VINT16x8_CMPGE_DEFINED
#endif
#if !defined(VINT16x8_MIN_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_min(vint16x8 vec1, vint16x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] < vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] < vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] < vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] < vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	return vec1;
}
# define VINT16x8_MIN_DEFINED
#endif
#if !defined(VINT16x8_MAX_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_max(vint16x8 vec1, vint16x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] > vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] > vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] > vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] > vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	return vec1;
}
# define VINT16x8_MAX_DEFINED
#endif
#if !defined(VINT16x8_RSHIFT_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_rshift(vint16x8 vec1, vuint16x8 vec2)
{
vec1.generic[0] = ((~vec1.generic[0]) >> vec2.generic[0]);
vec1.generic[1] = ((~vec1.generic[1]) >> vec2.generic[1]);
vec1.generic[2] = ((~vec1.generic[2]) >> vec2.generic[2]);
vec1.generic[3] = ((~vec1.generic[3]) >> vec2.generic[3]);
vec1.generic[4] = ((~vec1.generic[4]) >> vec2.generic[4]);
vec1.generic[5] = ((~vec1.generic[5]) >> vec2.generic[5]);
vec1.generic[6] = ((~vec1.generic[6]) >> vec2.generic[6]);
vec1.generic[7] = ((~vec1.generic[7]) >> vec2.generic[7]);
	return vec1;
}
# define VINT16x8_RSHIFT_DEFINED
#endif
#if !defined(VINT16x8_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_lrshift(vint16x8 vec1, vuint16x8 vec2)
{
	union { vec_uint16 u; vec_int16 s; } x;

	x.s = vec1.generic[0];
	x.u >>= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u >>= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u >>= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u >>= vec2.generic[3];
	vec1.generic[3] = x.s;
	x.s = vec1.generic[4];
	x.u >>= vec2.generic[4];
	vec1.generic[4] = x.s;
	x.s = vec1.generic[5];
	x.u >>= vec2.generic[5];
	vec1.generic[5] = x.s;
	x.s = vec1.generic[6];
	x.u >>= vec2.generic[6];
	vec1.generic[6] = x.s;
	x.s = vec1.generic[7];
	x.u >>= vec2.generic[7];
	vec1.generic[7] = x.s;
	return vec1;
}
# define VINT16x8_LRSHIFT_DEFINED
#endif
#if !defined(VINT16x8_LSHIFT_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_lshift(vint16x8 vec1, vuint16x8 vec2)
{
	union { vec_uint16 u; vec_int16 s; } x;

	x.s = vec1.generic[0];
	x.u <<= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u <<= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u <<= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u <<= vec2.generic[3];
	vec1.generic[3] = x.s;
	x.s = vec1.generic[4];
	x.u <<= vec2.generic[4];
	vec1.generic[4] = x.s;
	x.s = vec1.generic[5];
	x.u <<= vec2.generic[5];
	vec1.generic[5] = x.s;
	x.s = vec1.generic[6];
	x.u <<= vec2.generic[6];
	vec1.generic[6] = x.s;
	x.s = vec1.generic[7];
	x.u <<= vec2.generic[7];
	vec1.generic[7] = x.s;
	return vec1;
}
# define VINT16x8_LSHIFT_DEFINED
#endif
#if !defined(VUINT16x8_SPLAT_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_splat(vec_uint16 x)
{
	vuint16x8 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	vec.generic[4] = x;
	vec.generic[5] = x;
	vec.generic[6] = x;
	vec.generic[7] = x;
	return vec;
}
# define VUINT16x8_SPLAT_DEFINED
#endif
#if !defined(VUINT16x8_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_load_aligned(const vec_uint16 x[8])
{
	vuint16x8 vec;
	memcpy(vec.generic, x, 16);
	return vec;
}
# define VUINT16x8_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VUINT16x8_LOAD_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_load(const vec_uint16 x[8])
{
	vuint16x8 vec;
	memcpy(vec.generic, x, 16);
	return vec;
}
# define VUINT16x8_LOAD_DEFINED
#endif
#if !defined(VUINT16x8_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vuint16x8_store_aligned(vuint16x8 vec, vec_uint16 x[8])
{
	memcpy(x, vec.generic, 16);
}
# define VUINT16x8_STORE_ALIGNED_DEFINED
#endif
#if !defined(VUINT16x8_STORE_DEFINED)
VEC_FUNC_IMPL void vuint16x8_store(vuint16x8 vec, vec_uint16 x[8])
{
	memcpy(x, vec.generic, 16);
}
# define VUINT16x8_STORE_DEFINED
#endif
#if !defined(VUINT16x8_ADD_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_add(vuint16x8 vec1, vuint16x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]);
	return vec1;
}
# define VUINT16x8_ADD_DEFINED
#endif
#if !defined(VUINT16x8_SUB_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_sub(vuint16x8 vec1, vuint16x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] - vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] - vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] - vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] - vec2.generic[7]);
	return vec1;
}
# define VUINT16x8_SUB_DEFINED
#endif
#if !defined(VUINT16x8_MUL_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_mul(vuint16x8 vec1, vuint16x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] * vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] * vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] * vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] * vec2.generic[7]);
	return vec1;
}
# define VUINT16x8_MUL_DEFINED
#endif
#if !defined(VUINT16x8_DIV_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_div(vuint16x8 vec1, vuint16x8 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] / vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] / vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] / vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] / vec2.generic[7]) : 0);
	return vec1;
}
# define VUINT16x8_DIV_DEFINED
#endif
#if !defined(VUINT16x8_MOD_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_mod(vuint16x8 vec1, vuint16x8 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] % vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] % vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] % vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] % vec2.generic[7]) : 0);
	return vec1;
}
# define VUINT16x8_MOD_DEFINED
#endif
#if !defined(VUINT16x8_AVG_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_avg(vuint16x8 vec1, vuint16x8 vec2)
{
vec1.generic[0] = (vec1.generic[0] >> 1) + (vec2.generic[0] >> 1) + ((vec1.generic[0] | vec2.generic[0]) & 1);
vec1.generic[1] = (vec1.generic[1] >> 1) + (vec2.generic[1] >> 1) + ((vec1.generic[1] | vec2.generic[1]) & 1);
vec1.generic[2] = (vec1.generic[2] >> 1) + (vec2.generic[2] >> 1) + ((vec1.generic[2] | vec2.generic[2]) & 1);
vec1.generic[3] = (vec1.generic[3] >> 1) + (vec2.generic[3] >> 1) + ((vec1.generic[3] | vec2.generic[3]) & 1);
vec1.generic[4] = (vec1.generic[4] >> 1) + (vec2.generic[4] >> 1) + ((vec1.generic[4] | vec2.generic[4]) & 1);
vec1.generic[5] = (vec1.generic[5] >> 1) + (vec2.generic[5] >> 1) + ((vec1.generic[5] | vec2.generic[5]) & 1);
vec1.generic[6] = (vec1.generic[6] >> 1) + (vec2.generic[6] >> 1) + ((vec1.generic[6] | vec2.generic[6]) & 1);
vec1.generic[7] = (vec1.generic[7] >> 1) + (vec2.generic[7] >> 1) + ((vec1.generic[7] | vec2.generic[7]) & 1);
	return vec1;
}
# define VUINT16x8_AVG_DEFINED
#endif
#if !defined(VUINT16x8_AND_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_and(vuint16x8 vec1, vuint16x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] & vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] & vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] & vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] & vec2.generic[7]);
	return vec1;
}
# define VUINT16x8_AND_DEFINED
#endif
#if !defined(VUINT16x8_OR_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_or(vuint16x8 vec1, vuint16x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] | vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] | vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] | vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] | vec2.generic[7]);
	return vec1;
}
# define VUINT16x8_OR_DEFINED
#endif
#if !defined(VUINT16x8_XOR_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_xor(vuint16x8 vec1, vuint16x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] ^ vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] ^ vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] ^ vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] ^ vec2.generic[7]);
	return vec1;
}
# define VUINT16x8_XOR_DEFINED
#endif
#if !defined(VUINT16x8_NOT_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_not(vuint16x8 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	vec.generic[4] = ~vec.generic[4];
	vec.generic[5] = ~vec.generic[5];
	vec.generic[6] = ~vec.generic[6];
	vec.generic[7] = ~vec.generic[7];
	return vec;
}
# define VUINT16x8_NOT_DEFINED
#endif
#if !defined(VUINT16x8_CMPLT_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_cmplt(vuint16x8 vec1, vuint16x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] < vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] < vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] < vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] < vec2.generic[7]) ? 0xFF : 0, 2);
	return vec1;
}
# define VUINT16x8_CMPLT_DEFINED
#endif
#if !defined(VUINT16x8_CMPEQ_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_cmpeq(vuint16x8 vec1, vuint16x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] == vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] == vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] == vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] == vec2.generic[7]) ? 0xFF : 0, 2);
	return vec1;
}
# define VUINT16x8_CMPEQ_DEFINED
#endif
#if !defined(VUINT16x8_CMPGT_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_cmpgt(vuint16x8 vec1, vuint16x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] > vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] > vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] > vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] > vec2.generic[7]) ? 0xFF : 0, 2);
	return vec1;
}
# define VUINT16x8_CMPGT_DEFINED
#endif
#if !defined(VUINT16x8_CMPLE_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_cmple(vuint16x8 vec1, vuint16x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] <= vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] <= vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] <= vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] <= vec2.generic[7]) ? 0xFF : 0, 2);
	return vec1;
}
# define VUINT16x8_CMPLE_DEFINED
#endif
#if !defined(VUINT16x8_CMPGE_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_cmpge(vuint16x8 vec1, vuint16x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] >= vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] >= vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] >= vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] >= vec2.generic[7]) ? 0xFF : 0, 2);
	return vec1;
}
# define VUINT16x8_CMPGE_DEFINED
#endif
#if !defined(VUINT16x8_MIN_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_min(vuint16x8 vec1, vuint16x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] < vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] < vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] < vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] < vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	return vec1;
}
# define VUINT16x8_MIN_DEFINED
#endif
#if !defined(VUINT16x8_MAX_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_max(vuint16x8 vec1, vuint16x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] > vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] > vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] > vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] > vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	return vec1;
}
# define VUINT16x8_MAX_DEFINED
#endif
#if !defined(VUINT16x8_RSHIFT_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_rshift(vuint16x8 vec1, vuint16x8 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	vec1.generic[4] >>= vec2.generic[0];
	vec1.generic[5] >>= vec2.generic[0];
	vec1.generic[6] >>= vec2.generic[0];
	vec1.generic[7] >>= vec2.generic[0];
	return vec1;
}
# define VUINT16x8_RSHIFT_DEFINED
#endif
#if !defined(VUINT16x8_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_lrshift(vuint16x8 vec1, vuint16x8 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	vec1.generic[4] >>= vec2.generic[0];
	vec1.generic[5] >>= vec2.generic[0];
	vec1.generic[6] >>= vec2.generic[0];
	vec1.generic[7] >>= vec2.generic[0];
	return vec1;
}
# define VUINT16x8_LRSHIFT_DEFINED
#endif
#if !defined(VUINT16x8_LSHIFT_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_lshift(vuint16x8 vec1, vuint16x8 vec2)
{
	vec1.generic[0] <<= vec2.generic[0];
	vec1.generic[1] <<= vec2.generic[0];
	vec1.generic[2] <<= vec2.generic[0];
	vec1.generic[3] <<= vec2.generic[0];
	vec1.generic[4] <<= vec2.generic[0];
	vec1.generic[5] <<= vec2.generic[0];
	vec1.generic[6] <<= vec2.generic[0];
	vec1.generic[7] <<= vec2.generic[0];
	return vec1;
}
# define VUINT16x8_LSHIFT_DEFINED
#endif
#if !defined(VINT16x16_SPLAT_DEFINED)
VEC_FUNC_IMPL vint16x16 vint16x16_splat(vec_int16 x)
{
	vint16x16 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	vec.generic[4] = x;
	vec.generic[5] = x;
	vec.generic[6] = x;
	vec.generic[7] = x;
	vec.generic[8] = x;
	vec.generic[9] = x;
	vec.generic[10] = x;
	vec.generic[11] = x;
	vec.generic[12] = x;
	vec.generic[13] = x;
	vec.generic[14] = x;
	vec.generic[15] = x;
	return vec;
}
# define VINT16x16_SPLAT_DEFINED
#endif
#if !defined(VINT16x16_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vint16x16 vint16x16_load_aligned(const vec_int16 x[16])
{
	vint16x16 vec;
	memcpy(vec.generic, x, 32);
	return vec;
}
# define VINT16x16_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VINT16x16_LOAD_DEFINED)
VEC_FUNC_IMPL vint16x16 vint16x16_load(const vec_int16 x[16])
{
	vint16x16 vec;
	memcpy(vec.generic, x, 32);
	return vec;
}
# define VINT16x16_LOAD_DEFINED
#endif
#if !defined(VINT16x16_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vint16x16_store_aligned(vint16x16 vec, vec_int16 x[16])
{
	memcpy(x, vec.generic, 32);
}
# define VINT16x16_STORE_ALIGNED_DEFINED
#endif
#if !defined(VINT16x16_STORE_DEFINED)
VEC_FUNC_IMPL void vint16x16_store(vint16x16 vec, vec_int16 x[16])
{
	memcpy(x, vec.generic, 32);
}
# define VINT16x16_STORE_DEFINED
#endif
#if !defined(VINT16x16_ADD_DEFINED)
VEC_FUNC_IMPL vint16x16 vint16x16_add(vint16x16 vec1, vint16x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] + vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] + vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] + vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] + vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] + vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] + vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] + vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] + vec2.generic[15]);
	return vec1;
}
# define VINT16x16_ADD_DEFINED
#endif
#if !defined(VINT16x16_SUB_DEFINED)
VEC_FUNC_IMPL vint16x16 vint16x16_sub(vint16x16 vec1, vint16x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] - vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] - vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] - vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] - vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] - vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] - vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] - vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] - vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] - vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] - vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] - vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] - vec2.generic[15]);
	return vec1;
}
# define VINT16x16_SUB_DEFINED
#endif
#if !defined(VINT16x16_MUL_DEFINED)
VEC_FUNC_IMPL vint16x16 vint16x16_mul(vint16x16 vec1, vint16x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] * vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] * vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] * vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] * vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] * vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] * vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] * vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] * vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] * vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] * vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] * vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] * vec2.generic[15]);
	return vec1;
}
# define VINT16x16_MUL_DEFINED
#endif
#if !defined(VINT16x16_DIV_DEFINED)
VEC_FUNC_IMPL vint16x16 vint16x16_div(vint16x16 vec1, vint16x16 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] / vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] / vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] / vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] / vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? (vec1.generic[8] / vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? (vec1.generic[9] / vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? (vec1.generic[10] / vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? (vec1.generic[11] / vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? (vec1.generic[12] / vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? (vec1.generic[13] / vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? (vec1.generic[14] / vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? (vec1.generic[15] / vec2.generic[15]) : 0);
	return vec1;
}
# define VINT16x16_DIV_DEFINED
#endif
#if !defined(VINT16x16_MOD_DEFINED)
VEC_FUNC_IMPL vint16x16 vint16x16_mod(vint16x16 vec1, vint16x16 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] % vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] % vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] % vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] % vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? (vec1.generic[8] % vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? (vec1.generic[9] % vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? (vec1.generic[10] % vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? (vec1.generic[11] % vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? (vec1.generic[12] % vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? (vec1.generic[13] % vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? (vec1.generic[14] % vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? (vec1.generic[15] % vec2.generic[15]) : 0);
	return vec1;
}
# define VINT16x16_MOD_DEFINED
#endif
#if !defined(VINT16x16_AVG_DEFINED)
VEC_FUNC_IMPL vint16x16 vint16x16_avg(vint16x16 vec1, vint16x16 vec2)
{
	vec_int16 x_d_rem, y_d_rem, rem_d_quot, rem_d_rem;
	x_d_rem = (vec1.generic[0] % 2);
	y_d_rem = (vec2.generic[0] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[0] = ((vec1.generic[0] / 2) + (vec2.generic[0] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[1] % 2);
	y_d_rem = (vec2.generic[1] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[1] = ((vec1.generic[1] / 2) + (vec2.generic[1] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[2] % 2);
	y_d_rem = (vec2.generic[2] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[2] = ((vec1.generic[2] / 2) + (vec2.generic[2] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[3] % 2);
	y_d_rem = (vec2.generic[3] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[3] = ((vec1.generic[3] / 2) + (vec2.generic[3] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[4] % 2);
	y_d_rem = (vec2.generic[4] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[4] = ((vec1.generic[4] / 2) + (vec2.generic[4] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[5] % 2);
	y_d_rem = (vec2.generic[5] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[5] = ((vec1.generic[5] / 2) + (vec2.generic[5] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[6] % 2);
	y_d_rem = (vec2.generic[6] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[6] = ((vec1.generic[6] / 2) + (vec2.generic[6] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[7] % 2);
	y_d_rem = (vec2.generic[7] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[7] = ((vec1.generic[7] / 2) + (vec2.generic[7] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[8] % 2);
	y_d_rem = (vec2.generic[8] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[8] = ((vec1.generic[8] / 2) + (vec2.generic[8] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[9] % 2);
	y_d_rem = (vec2.generic[9] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[9] = ((vec1.generic[9] / 2) + (vec2.generic[9] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[10] % 2);
	y_d_rem = (vec2.generic[10] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[10] = ((vec1.generic[10] / 2) + (vec2.generic[10] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[11] % 2);
	y_d_rem = (vec2.generic[11] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[11] = ((vec1.generic[11] / 2) + (vec2.generic[11] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[12] % 2);
	y_d_rem = (vec2.generic[12] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[12] = ((vec1.generic[12] / 2) + (vec2.generic[12] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[13] % 2);
	y_d_rem = (vec2.generic[13] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[13] = ((vec1.generic[13] / 2) + (vec2.generic[13] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[14] % 2);
	y_d_rem = (vec2.generic[14] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[14] = ((vec1.generic[14] / 2) + (vec2.generic[14] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[15] % 2);
	y_d_rem = (vec2.generic[15] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[15] = ((vec1.generic[15] / 2) + (vec2.generic[15] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	return vec1;
}
# define VINT16x16_AVG_DEFINED
#endif
#if !defined(VINT16x16_AND_DEFINED)
VEC_FUNC_IMPL vint16x16 vint16x16_and(vint16x16 vec1, vint16x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] & vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] & vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] & vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] & vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] & vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] & vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] & vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] & vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] & vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] & vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] & vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] & vec2.generic[15]);
	return vec1;
}
# define VINT16x16_AND_DEFINED
#endif
#if !defined(VINT16x16_OR_DEFINED)
VEC_FUNC_IMPL vint16x16 vint16x16_or(vint16x16 vec1, vint16x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] | vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] | vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] | vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] | vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] | vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] | vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] | vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] | vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] | vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] | vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] | vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] | vec2.generic[15]);
	return vec1;
}
# define VINT16x16_OR_DEFINED
#endif
#if !defined(VINT16x16_XOR_DEFINED)
VEC_FUNC_IMPL vint16x16 vint16x16_xor(vint16x16 vec1, vint16x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] ^ vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] ^ vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] ^ vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] ^ vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] ^ vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] ^ vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] ^ vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] ^ vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] ^ vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] ^ vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] ^ vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] ^ vec2.generic[15]);
	return vec1;
}
# define VINT16x16_XOR_DEFINED
#endif
#if !defined(VINT16x16_NOT_DEFINED)
VEC_FUNC_IMPL vint16x16 vint16x16_not(vint16x16 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	vec.generic[4] = ~vec.generic[4];
	vec.generic[5] = ~vec.generic[5];
	vec.generic[6] = ~vec.generic[6];
	vec.generic[7] = ~vec.generic[7];
	vec.generic[8] = ~vec.generic[8];
	vec.generic[9] = ~vec.generic[9];
	vec.generic[10] = ~vec.generic[10];
	vec.generic[11] = ~vec.generic[11];
	vec.generic[12] = ~vec.generic[12];
	vec.generic[13] = ~vec.generic[13];
	vec.generic[14] = ~vec.generic[14];
	vec.generic[15] = ~vec.generic[15];
	return vec;
}
# define VINT16x16_NOT_DEFINED
#endif
#if !defined(VINT16x16_CMPLT_DEFINED)
VEC_FUNC_IMPL vint16x16 vint16x16_cmplt(vint16x16 vec1, vint16x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] < vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] < vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] < vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] < vec2.generic[7]) ? 0xFF : 0, 2);
	memset(&vec1.generic[8], (vec1.generic[8] < vec2.generic[8]) ? 0xFF : 0, 2);
	memset(&vec1.generic[9], (vec1.generic[9] < vec2.generic[9]) ? 0xFF : 0, 2);
	memset(&vec1.generic[10], (vec1.generic[10] < vec2.generic[10]) ? 0xFF : 0, 2);
	memset(&vec1.generic[11], (vec1.generic[11] < vec2.generic[11]) ? 0xFF : 0, 2);
	memset(&vec1.generic[12], (vec1.generic[12] < vec2.generic[12]) ? 0xFF : 0, 2);
	memset(&vec1.generic[13], (vec1.generic[13] < vec2.generic[13]) ? 0xFF : 0, 2);
	memset(&vec1.generic[14], (vec1.generic[14] < vec2.generic[14]) ? 0xFF : 0, 2);
	memset(&vec1.generic[15], (vec1.generic[15] < vec2.generic[15]) ? 0xFF : 0, 2);
	return vec1;
}
# define VINT16x16_CMPLT_DEFINED
#endif
#if !defined(VINT16x16_CMPEQ_DEFINED)
VEC_FUNC_IMPL vint16x16 vint16x16_cmpeq(vint16x16 vec1, vint16x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] == vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] == vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] == vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] == vec2.generic[7]) ? 0xFF : 0, 2);
	memset(&vec1.generic[8], (vec1.generic[8] == vec2.generic[8]) ? 0xFF : 0, 2);
	memset(&vec1.generic[9], (vec1.generic[9] == vec2.generic[9]) ? 0xFF : 0, 2);
	memset(&vec1.generic[10], (vec1.generic[10] == vec2.generic[10]) ? 0xFF : 0, 2);
	memset(&vec1.generic[11], (vec1.generic[11] == vec2.generic[11]) ? 0xFF : 0, 2);
	memset(&vec1.generic[12], (vec1.generic[12] == vec2.generic[12]) ? 0xFF : 0, 2);
	memset(&vec1.generic[13], (vec1.generic[13] == vec2.generic[13]) ? 0xFF : 0, 2);
	memset(&vec1.generic[14], (vec1.generic[14] == vec2.generic[14]) ? 0xFF : 0, 2);
	memset(&vec1.generic[15], (vec1.generic[15] == vec2.generic[15]) ? 0xFF : 0, 2);
	return vec1;
}
# define VINT16x16_CMPEQ_DEFINED
#endif
#if !defined(VINT16x16_CMPGT_DEFINED)
VEC_FUNC_IMPL vint16x16 vint16x16_cmpgt(vint16x16 vec1, vint16x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] > vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] > vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] > vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] > vec2.generic[7]) ? 0xFF : 0, 2);
	memset(&vec1.generic[8], (vec1.generic[8] > vec2.generic[8]) ? 0xFF : 0, 2);
	memset(&vec1.generic[9], (vec1.generic[9] > vec2.generic[9]) ? 0xFF : 0, 2);
	memset(&vec1.generic[10], (vec1.generic[10] > vec2.generic[10]) ? 0xFF : 0, 2);
	memset(&vec1.generic[11], (vec1.generic[11] > vec2.generic[11]) ? 0xFF : 0, 2);
	memset(&vec1.generic[12], (vec1.generic[12] > vec2.generic[12]) ? 0xFF : 0, 2);
	memset(&vec1.generic[13], (vec1.generic[13] > vec2.generic[13]) ? 0xFF : 0, 2);
	memset(&vec1.generic[14], (vec1.generic[14] > vec2.generic[14]) ? 0xFF : 0, 2);
	memset(&vec1.generic[15], (vec1.generic[15] > vec2.generic[15]) ? 0xFF : 0, 2);
	return vec1;
}
# define VINT16x16_CMPGT_DEFINED
#endif
#if !defined(VINT16x16_CMPLE_DEFINED)
VEC_FUNC_IMPL vint16x16 vint16x16_cmple(vint16x16 vec1, vint16x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] <= vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] <= vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] <= vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] <= vec2.generic[7]) ? 0xFF : 0, 2);
	memset(&vec1.generic[8], (vec1.generic[8] <= vec2.generic[8]) ? 0xFF : 0, 2);
	memset(&vec1.generic[9], (vec1.generic[9] <= vec2.generic[9]) ? 0xFF : 0, 2);
	memset(&vec1.generic[10], (vec1.generic[10] <= vec2.generic[10]) ? 0xFF : 0, 2);
	memset(&vec1.generic[11], (vec1.generic[11] <= vec2.generic[11]) ? 0xFF : 0, 2);
	memset(&vec1.generic[12], (vec1.generic[12] <= vec2.generic[12]) ? 0xFF : 0, 2);
	memset(&vec1.generic[13], (vec1.generic[13] <= vec2.generic[13]) ? 0xFF : 0, 2);
	memset(&vec1.generic[14], (vec1.generic[14] <= vec2.generic[14]) ? 0xFF : 0, 2);
	memset(&vec1.generic[15], (vec1.generic[15] <= vec2.generic[15]) ? 0xFF : 0, 2);
	return vec1;
}
# define VINT16x16_CMPLE_DEFINED
#endif
#if !defined(VINT16x16_CMPGE_DEFINED)
VEC_FUNC_IMPL vint16x16 vint16x16_cmpge(vint16x16 vec1, vint16x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] >= vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] >= vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] >= vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] >= vec2.generic[7]) ? 0xFF : 0, 2);
	memset(&vec1.generic[8], (vec1.generic[8] >= vec2.generic[8]) ? 0xFF : 0, 2);
	memset(&vec1.generic[9], (vec1.generic[9] >= vec2.generic[9]) ? 0xFF : 0, 2);
	memset(&vec1.generic[10], (vec1.generic[10] >= vec2.generic[10]) ? 0xFF : 0, 2);
	memset(&vec1.generic[11], (vec1.generic[11] >= vec2.generic[11]) ? 0xFF : 0, 2);
	memset(&vec1.generic[12], (vec1.generic[12] >= vec2.generic[12]) ? 0xFF : 0, 2);
	memset(&vec1.generic[13], (vec1.generic[13] >= vec2.generic[13]) ? 0xFF : 0, 2);
	memset(&vec1.generic[14], (vec1.generic[14] >= vec2.generic[14]) ? 0xFF : 0, 2);
	memset(&vec1.generic[15], (vec1.generic[15] >= vec2.generic[15]) ? 0xFF : 0, 2);
	return vec1;
}
# define VINT16x16_CMPGE_DEFINED
#endif
#if !defined(VINT16x16_MIN_DEFINED)
VEC_FUNC_IMPL vint16x16 vint16x16_min(vint16x16 vec1, vint16x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] < vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] < vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] < vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] < vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] < vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] < vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] < vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] < vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] < vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] < vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] < vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] < vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	return vec1;
}
# define VINT16x16_MIN_DEFINED
#endif
#if !defined(VINT16x16_MAX_DEFINED)
VEC_FUNC_IMPL vint16x16 vint16x16_max(vint16x16 vec1, vint16x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] > vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] > vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] > vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] > vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] > vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] > vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] > vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] > vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] > vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] > vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] > vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] > vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	return vec1;
}
# define VINT16x16_MAX_DEFINED
#endif
#if !defined(VINT16x16_RSHIFT_DEFINED)
VEC_FUNC_IMPL vint16x16 vint16x16_rshift(vint16x16 vec1, vuint16x16 vec2)
{
vec1.generic[0] = ((~vec1.generic[0]) >> vec2.generic[0]);
vec1.generic[1] = ((~vec1.generic[1]) >> vec2.generic[1]);
vec1.generic[2] = ((~vec1.generic[2]) >> vec2.generic[2]);
vec1.generic[3] = ((~vec1.generic[3]) >> vec2.generic[3]);
vec1.generic[4] = ((~vec1.generic[4]) >> vec2.generic[4]);
vec1.generic[5] = ((~vec1.generic[5]) >> vec2.generic[5]);
vec1.generic[6] = ((~vec1.generic[6]) >> vec2.generic[6]);
vec1.generic[7] = ((~vec1.generic[7]) >> vec2.generic[7]);
vec1.generic[8] = ((~vec1.generic[8]) >> vec2.generic[8]);
vec1.generic[9] = ((~vec1.generic[9]) >> vec2.generic[9]);
vec1.generic[10] = ((~vec1.generic[10]) >> vec2.generic[10]);
vec1.generic[11] = ((~vec1.generic[11]) >> vec2.generic[11]);
vec1.generic[12] = ((~vec1.generic[12]) >> vec2.generic[12]);
vec1.generic[13] = ((~vec1.generic[13]) >> vec2.generic[13]);
vec1.generic[14] = ((~vec1.generic[14]) >> vec2.generic[14]);
vec1.generic[15] = ((~vec1.generic[15]) >> vec2.generic[15]);
	return vec1;
}
# define VINT16x16_RSHIFT_DEFINED
#endif
#if !defined(VINT16x16_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vint16x16 vint16x16_lrshift(vint16x16 vec1, vuint16x16 vec2)
{
	union { vec_uint16 u; vec_int16 s; } x;

	x.s = vec1.generic[0];
	x.u >>= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u >>= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u >>= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u >>= vec2.generic[3];
	vec1.generic[3] = x.s;
	x.s = vec1.generic[4];
	x.u >>= vec2.generic[4];
	vec1.generic[4] = x.s;
	x.s = vec1.generic[5];
	x.u >>= vec2.generic[5];
	vec1.generic[5] = x.s;
	x.s = vec1.generic[6];
	x.u >>= vec2.generic[6];
	vec1.generic[6] = x.s;
	x.s = vec1.generic[7];
	x.u >>= vec2.generic[7];
	vec1.generic[7] = x.s;
	x.s = vec1.generic[8];
	x.u >>= vec2.generic[8];
	vec1.generic[8] = x.s;
	x.s = vec1.generic[9];
	x.u >>= vec2.generic[9];
	vec1.generic[9] = x.s;
	x.s = vec1.generic[10];
	x.u >>= vec2.generic[10];
	vec1.generic[10] = x.s;
	x.s = vec1.generic[11];
	x.u >>= vec2.generic[11];
	vec1.generic[11] = x.s;
	x.s = vec1.generic[12];
	x.u >>= vec2.generic[12];
	vec1.generic[12] = x.s;
	x.s = vec1.generic[13];
	x.u >>= vec2.generic[13];
	vec1.generic[13] = x.s;
	x.s = vec1.generic[14];
	x.u >>= vec2.generic[14];
	vec1.generic[14] = x.s;
	x.s = vec1.generic[15];
	x.u >>= vec2.generic[15];
	vec1.generic[15] = x.s;
	return vec1;
}
# define VINT16x16_LRSHIFT_DEFINED
#endif
#if !defined(VINT16x16_LSHIFT_DEFINED)
VEC_FUNC_IMPL vint16x16 vint16x16_lshift(vint16x16 vec1, vuint16x16 vec2)
{
	union { vec_uint16 u; vec_int16 s; } x;

	x.s = vec1.generic[0];
	x.u <<= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u <<= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u <<= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u <<= vec2.generic[3];
	vec1.generic[3] = x.s;
	x.s = vec1.generic[4];
	x.u <<= vec2.generic[4];
	vec1.generic[4] = x.s;
	x.s = vec1.generic[5];
	x.u <<= vec2.generic[5];
	vec1.generic[5] = x.s;
	x.s = vec1.generic[6];
	x.u <<= vec2.generic[6];
	vec1.generic[6] = x.s;
	x.s = vec1.generic[7];
	x.u <<= vec2.generic[7];
	vec1.generic[7] = x.s;
	x.s = vec1.generic[8];
	x.u <<= vec2.generic[8];
	vec1.generic[8] = x.s;
	x.s = vec1.generic[9];
	x.u <<= vec2.generic[9];
	vec1.generic[9] = x.s;
	x.s = vec1.generic[10];
	x.u <<= vec2.generic[10];
	vec1.generic[10] = x.s;
	x.s = vec1.generic[11];
	x.u <<= vec2.generic[11];
	vec1.generic[11] = x.s;
	x.s = vec1.generic[12];
	x.u <<= vec2.generic[12];
	vec1.generic[12] = x.s;
	x.s = vec1.generic[13];
	x.u <<= vec2.generic[13];
	vec1.generic[13] = x.s;
	x.s = vec1.generic[14];
	x.u <<= vec2.generic[14];
	vec1.generic[14] = x.s;
	x.s = vec1.generic[15];
	x.u <<= vec2.generic[15];
	vec1.generic[15] = x.s;
	return vec1;
}
# define VINT16x16_LSHIFT_DEFINED
#endif
#if !defined(VUINT16x16_SPLAT_DEFINED)
VEC_FUNC_IMPL vuint16x16 vuint16x16_splat(vec_uint16 x)
{
	vuint16x16 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	vec.generic[4] = x;
	vec.generic[5] = x;
	vec.generic[6] = x;
	vec.generic[7] = x;
	vec.generic[8] = x;
	vec.generic[9] = x;
	vec.generic[10] = x;
	vec.generic[11] = x;
	vec.generic[12] = x;
	vec.generic[13] = x;
	vec.generic[14] = x;
	vec.generic[15] = x;
	return vec;
}
# define VUINT16x16_SPLAT_DEFINED
#endif
#if !defined(VUINT16x16_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vuint16x16 vuint16x16_load_aligned(const vec_uint16 x[16])
{
	vuint16x16 vec;
	memcpy(vec.generic, x, 32);
	return vec;
}
# define VUINT16x16_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VUINT16x16_LOAD_DEFINED)
VEC_FUNC_IMPL vuint16x16 vuint16x16_load(const vec_uint16 x[16])
{
	vuint16x16 vec;
	memcpy(vec.generic, x, 32);
	return vec;
}
# define VUINT16x16_LOAD_DEFINED
#endif
#if !defined(VUINT16x16_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vuint16x16_store_aligned(vuint16x16 vec, vec_uint16 x[16])
{
	memcpy(x, vec.generic, 32);
}
# define VUINT16x16_STORE_ALIGNED_DEFINED
#endif
#if !defined(VUINT16x16_STORE_DEFINED)
VEC_FUNC_IMPL void vuint16x16_store(vuint16x16 vec, vec_uint16 x[16])
{
	memcpy(x, vec.generic, 32);
}
# define VUINT16x16_STORE_DEFINED
#endif
#if !defined(VUINT16x16_ADD_DEFINED)
VEC_FUNC_IMPL vuint16x16 vuint16x16_add(vuint16x16 vec1, vuint16x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] + vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] + vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] + vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] + vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] + vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] + vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] + vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] + vec2.generic[15]);
	return vec1;
}
# define VUINT16x16_ADD_DEFINED
#endif
#if !defined(VUINT16x16_SUB_DEFINED)
VEC_FUNC_IMPL vuint16x16 vuint16x16_sub(vuint16x16 vec1, vuint16x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] - vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] - vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] - vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] - vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] - vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] - vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] - vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] - vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] - vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] - vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] - vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] - vec2.generic[15]);
	return vec1;
}
# define VUINT16x16_SUB_DEFINED
#endif
#if !defined(VUINT16x16_MUL_DEFINED)
VEC_FUNC_IMPL vuint16x16 vuint16x16_mul(vuint16x16 vec1, vuint16x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] * vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] * vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] * vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] * vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] * vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] * vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] * vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] * vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] * vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] * vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] * vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] * vec2.generic[15]);
	return vec1;
}
# define VUINT16x16_MUL_DEFINED
#endif
#if !defined(VUINT16x16_DIV_DEFINED)
VEC_FUNC_IMPL vuint16x16 vuint16x16_div(vuint16x16 vec1, vuint16x16 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] / vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] / vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] / vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] / vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? (vec1.generic[8] / vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? (vec1.generic[9] / vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? (vec1.generic[10] / vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? (vec1.generic[11] / vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? (vec1.generic[12] / vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? (vec1.generic[13] / vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? (vec1.generic[14] / vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? (vec1.generic[15] / vec2.generic[15]) : 0);
	return vec1;
}
# define VUINT16x16_DIV_DEFINED
#endif
#if !defined(VUINT16x16_MOD_DEFINED)
VEC_FUNC_IMPL vuint16x16 vuint16x16_mod(vuint16x16 vec1, vuint16x16 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] % vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] % vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] % vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] % vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? (vec1.generic[8] % vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? (vec1.generic[9] % vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? (vec1.generic[10] % vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? (vec1.generic[11] % vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? (vec1.generic[12] % vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? (vec1.generic[13] % vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? (vec1.generic[14] % vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? (vec1.generic[15] % vec2.generic[15]) : 0);
	return vec1;
}
# define VUINT16x16_MOD_DEFINED
#endif
#if !defined(VUINT16x16_AVG_DEFINED)
VEC_FUNC_IMPL vuint16x16 vuint16x16_avg(vuint16x16 vec1, vuint16x16 vec2)
{
vec1.generic[0] = (vec1.generic[0] >> 1) + (vec2.generic[0] >> 1) + ((vec1.generic[0] | vec2.generic[0]) & 1);
vec1.generic[1] = (vec1.generic[1] >> 1) + (vec2.generic[1] >> 1) + ((vec1.generic[1] | vec2.generic[1]) & 1);
vec1.generic[2] = (vec1.generic[2] >> 1) + (vec2.generic[2] >> 1) + ((vec1.generic[2] | vec2.generic[2]) & 1);
vec1.generic[3] = (vec1.generic[3] >> 1) + (vec2.generic[3] >> 1) + ((vec1.generic[3] | vec2.generic[3]) & 1);
vec1.generic[4] = (vec1.generic[4] >> 1) + (vec2.generic[4] >> 1) + ((vec1.generic[4] | vec2.generic[4]) & 1);
vec1.generic[5] = (vec1.generic[5] >> 1) + (vec2.generic[5] >> 1) + ((vec1.generic[5] | vec2.generic[5]) & 1);
vec1.generic[6] = (vec1.generic[6] >> 1) + (vec2.generic[6] >> 1) + ((vec1.generic[6] | vec2.generic[6]) & 1);
vec1.generic[7] = (vec1.generic[7] >> 1) + (vec2.generic[7] >> 1) + ((vec1.generic[7] | vec2.generic[7]) & 1);
vec1.generic[8] = (vec1.generic[8] >> 1) + (vec2.generic[8] >> 1) + ((vec1.generic[8] | vec2.generic[8]) & 1);
vec1.generic[9] = (vec1.generic[9] >> 1) + (vec2.generic[9] >> 1) + ((vec1.generic[9] | vec2.generic[9]) & 1);
vec1.generic[10] = (vec1.generic[10] >> 1) + (vec2.generic[10] >> 1) + ((vec1.generic[10] | vec2.generic[10]) & 1);
vec1.generic[11] = (vec1.generic[11] >> 1) + (vec2.generic[11] >> 1) + ((vec1.generic[11] | vec2.generic[11]) & 1);
vec1.generic[12] = (vec1.generic[12] >> 1) + (vec2.generic[12] >> 1) + ((vec1.generic[12] | vec2.generic[12]) & 1);
vec1.generic[13] = (vec1.generic[13] >> 1) + (vec2.generic[13] >> 1) + ((vec1.generic[13] | vec2.generic[13]) & 1);
vec1.generic[14] = (vec1.generic[14] >> 1) + (vec2.generic[14] >> 1) + ((vec1.generic[14] | vec2.generic[14]) & 1);
vec1.generic[15] = (vec1.generic[15] >> 1) + (vec2.generic[15] >> 1) + ((vec1.generic[15] | vec2.generic[15]) & 1);
	return vec1;
}
# define VUINT16x16_AVG_DEFINED
#endif
#if !defined(VUINT16x16_AND_DEFINED)
VEC_FUNC_IMPL vuint16x16 vuint16x16_and(vuint16x16 vec1, vuint16x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] & vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] & vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] & vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] & vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] & vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] & vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] & vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] & vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] & vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] & vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] & vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] & vec2.generic[15]);
	return vec1;
}
# define VUINT16x16_AND_DEFINED
#endif
#if !defined(VUINT16x16_OR_DEFINED)
VEC_FUNC_IMPL vuint16x16 vuint16x16_or(vuint16x16 vec1, vuint16x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] | vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] | vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] | vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] | vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] | vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] | vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] | vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] | vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] | vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] | vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] | vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] | vec2.generic[15]);
	return vec1;
}
# define VUINT16x16_OR_DEFINED
#endif
#if !defined(VUINT16x16_XOR_DEFINED)
VEC_FUNC_IMPL vuint16x16 vuint16x16_xor(vuint16x16 vec1, vuint16x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] ^ vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] ^ vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] ^ vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] ^ vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] ^ vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] ^ vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] ^ vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] ^ vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] ^ vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] ^ vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] ^ vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] ^ vec2.generic[15]);
	return vec1;
}
# define VUINT16x16_XOR_DEFINED
#endif
#if !defined(VUINT16x16_NOT_DEFINED)
VEC_FUNC_IMPL vuint16x16 vuint16x16_not(vuint16x16 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	vec.generic[4] = ~vec.generic[4];
	vec.generic[5] = ~vec.generic[5];
	vec.generic[6] = ~vec.generic[6];
	vec.generic[7] = ~vec.generic[7];
	vec.generic[8] = ~vec.generic[8];
	vec.generic[9] = ~vec.generic[9];
	vec.generic[10] = ~vec.generic[10];
	vec.generic[11] = ~vec.generic[11];
	vec.generic[12] = ~vec.generic[12];
	vec.generic[13] = ~vec.generic[13];
	vec.generic[14] = ~vec.generic[14];
	vec.generic[15] = ~vec.generic[15];
	return vec;
}
# define VUINT16x16_NOT_DEFINED
#endif
#if !defined(VUINT16x16_CMPLT_DEFINED)
VEC_FUNC_IMPL vuint16x16 vuint16x16_cmplt(vuint16x16 vec1, vuint16x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] < vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] < vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] < vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] < vec2.generic[7]) ? 0xFF : 0, 2);
	memset(&vec1.generic[8], (vec1.generic[8] < vec2.generic[8]) ? 0xFF : 0, 2);
	memset(&vec1.generic[9], (vec1.generic[9] < vec2.generic[9]) ? 0xFF : 0, 2);
	memset(&vec1.generic[10], (vec1.generic[10] < vec2.generic[10]) ? 0xFF : 0, 2);
	memset(&vec1.generic[11], (vec1.generic[11] < vec2.generic[11]) ? 0xFF : 0, 2);
	memset(&vec1.generic[12], (vec1.generic[12] < vec2.generic[12]) ? 0xFF : 0, 2);
	memset(&vec1.generic[13], (vec1.generic[13] < vec2.generic[13]) ? 0xFF : 0, 2);
	memset(&vec1.generic[14], (vec1.generic[14] < vec2.generic[14]) ? 0xFF : 0, 2);
	memset(&vec1.generic[15], (vec1.generic[15] < vec2.generic[15]) ? 0xFF : 0, 2);
	return vec1;
}
# define VUINT16x16_CMPLT_DEFINED
#endif
#if !defined(VUINT16x16_CMPEQ_DEFINED)
VEC_FUNC_IMPL vuint16x16 vuint16x16_cmpeq(vuint16x16 vec1, vuint16x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] == vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] == vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] == vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] == vec2.generic[7]) ? 0xFF : 0, 2);
	memset(&vec1.generic[8], (vec1.generic[8] == vec2.generic[8]) ? 0xFF : 0, 2);
	memset(&vec1.generic[9], (vec1.generic[9] == vec2.generic[9]) ? 0xFF : 0, 2);
	memset(&vec1.generic[10], (vec1.generic[10] == vec2.generic[10]) ? 0xFF : 0, 2);
	memset(&vec1.generic[11], (vec1.generic[11] == vec2.generic[11]) ? 0xFF : 0, 2);
	memset(&vec1.generic[12], (vec1.generic[12] == vec2.generic[12]) ? 0xFF : 0, 2);
	memset(&vec1.generic[13], (vec1.generic[13] == vec2.generic[13]) ? 0xFF : 0, 2);
	memset(&vec1.generic[14], (vec1.generic[14] == vec2.generic[14]) ? 0xFF : 0, 2);
	memset(&vec1.generic[15], (vec1.generic[15] == vec2.generic[15]) ? 0xFF : 0, 2);
	return vec1;
}
# define VUINT16x16_CMPEQ_DEFINED
#endif
#if !defined(VUINT16x16_CMPGT_DEFINED)
VEC_FUNC_IMPL vuint16x16 vuint16x16_cmpgt(vuint16x16 vec1, vuint16x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] > vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] > vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] > vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] > vec2.generic[7]) ? 0xFF : 0, 2);
	memset(&vec1.generic[8], (vec1.generic[8] > vec2.generic[8]) ? 0xFF : 0, 2);
	memset(&vec1.generic[9], (vec1.generic[9] > vec2.generic[9]) ? 0xFF : 0, 2);
	memset(&vec1.generic[10], (vec1.generic[10] > vec2.generic[10]) ? 0xFF : 0, 2);
	memset(&vec1.generic[11], (vec1.generic[11] > vec2.generic[11]) ? 0xFF : 0, 2);
	memset(&vec1.generic[12], (vec1.generic[12] > vec2.generic[12]) ? 0xFF : 0, 2);
	memset(&vec1.generic[13], (vec1.generic[13] > vec2.generic[13]) ? 0xFF : 0, 2);
	memset(&vec1.generic[14], (vec1.generic[14] > vec2.generic[14]) ? 0xFF : 0, 2);
	memset(&vec1.generic[15], (vec1.generic[15] > vec2.generic[15]) ? 0xFF : 0, 2);
	return vec1;
}
# define VUINT16x16_CMPGT_DEFINED
#endif
#if !defined(VUINT16x16_CMPLE_DEFINED)
VEC_FUNC_IMPL vuint16x16 vuint16x16_cmple(vuint16x16 vec1, vuint16x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] <= vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] <= vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] <= vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] <= vec2.generic[7]) ? 0xFF : 0, 2);
	memset(&vec1.generic[8], (vec1.generic[8] <= vec2.generic[8]) ? 0xFF : 0, 2);
	memset(&vec1.generic[9], (vec1.generic[9] <= vec2.generic[9]) ? 0xFF : 0, 2);
	memset(&vec1.generic[10], (vec1.generic[10] <= vec2.generic[10]) ? 0xFF : 0, 2);
	memset(&vec1.generic[11], (vec1.generic[11] <= vec2.generic[11]) ? 0xFF : 0, 2);
	memset(&vec1.generic[12], (vec1.generic[12] <= vec2.generic[12]) ? 0xFF : 0, 2);
	memset(&vec1.generic[13], (vec1.generic[13] <= vec2.generic[13]) ? 0xFF : 0, 2);
	memset(&vec1.generic[14], (vec1.generic[14] <= vec2.generic[14]) ? 0xFF : 0, 2);
	memset(&vec1.generic[15], (vec1.generic[15] <= vec2.generic[15]) ? 0xFF : 0, 2);
	return vec1;
}
# define VUINT16x16_CMPLE_DEFINED
#endif
#if !defined(VUINT16x16_CMPGE_DEFINED)
VEC_FUNC_IMPL vuint16x16 vuint16x16_cmpge(vuint16x16 vec1, vuint16x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] >= vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] >= vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] >= vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] >= vec2.generic[7]) ? 0xFF : 0, 2);
	memset(&vec1.generic[8], (vec1.generic[8] >= vec2.generic[8]) ? 0xFF : 0, 2);
	memset(&vec1.generic[9], (vec1.generic[9] >= vec2.generic[9]) ? 0xFF : 0, 2);
	memset(&vec1.generic[10], (vec1.generic[10] >= vec2.generic[10]) ? 0xFF : 0, 2);
	memset(&vec1.generic[11], (vec1.generic[11] >= vec2.generic[11]) ? 0xFF : 0, 2);
	memset(&vec1.generic[12], (vec1.generic[12] >= vec2.generic[12]) ? 0xFF : 0, 2);
	memset(&vec1.generic[13], (vec1.generic[13] >= vec2.generic[13]) ? 0xFF : 0, 2);
	memset(&vec1.generic[14], (vec1.generic[14] >= vec2.generic[14]) ? 0xFF : 0, 2);
	memset(&vec1.generic[15], (vec1.generic[15] >= vec2.generic[15]) ? 0xFF : 0, 2);
	return vec1;
}
# define VUINT16x16_CMPGE_DEFINED
#endif
#if !defined(VUINT16x16_MIN_DEFINED)
VEC_FUNC_IMPL vuint16x16 vuint16x16_min(vuint16x16 vec1, vuint16x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] < vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] < vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] < vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] < vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] < vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] < vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] < vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] < vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] < vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] < vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] < vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] < vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	return vec1;
}
# define VUINT16x16_MIN_DEFINED
#endif
#if !defined(VUINT16x16_MAX_DEFINED)
VEC_FUNC_IMPL vuint16x16 vuint16x16_max(vuint16x16 vec1, vuint16x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] > vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] > vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] > vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] > vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] > vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] > vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] > vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] > vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] > vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] > vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] > vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] > vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	return vec1;
}
# define VUINT16x16_MAX_DEFINED
#endif
#if !defined(VUINT16x16_RSHIFT_DEFINED)
VEC_FUNC_IMPL vuint16x16 vuint16x16_rshift(vuint16x16 vec1, vuint16x16 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	vec1.generic[4] >>= vec2.generic[0];
	vec1.generic[5] >>= vec2.generic[0];
	vec1.generic[6] >>= vec2.generic[0];
	vec1.generic[7] >>= vec2.generic[0];
	vec1.generic[8] >>= vec2.generic[0];
	vec1.generic[9] >>= vec2.generic[0];
	vec1.generic[10] >>= vec2.generic[0];
	vec1.generic[11] >>= vec2.generic[0];
	vec1.generic[12] >>= vec2.generic[0];
	vec1.generic[13] >>= vec2.generic[0];
	vec1.generic[14] >>= vec2.generic[0];
	vec1.generic[15] >>= vec2.generic[0];
	return vec1;
}
# define VUINT16x16_RSHIFT_DEFINED
#endif
#if !defined(VUINT16x16_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vuint16x16 vuint16x16_lrshift(vuint16x16 vec1, vuint16x16 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	vec1.generic[4] >>= vec2.generic[0];
	vec1.generic[5] >>= vec2.generic[0];
	vec1.generic[6] >>= vec2.generic[0];
	vec1.generic[7] >>= vec2.generic[0];
	vec1.generic[8] >>= vec2.generic[0];
	vec1.generic[9] >>= vec2.generic[0];
	vec1.generic[10] >>= vec2.generic[0];
	vec1.generic[11] >>= vec2.generic[0];
	vec1.generic[12] >>= vec2.generic[0];
	vec1.generic[13] >>= vec2.generic[0];
	vec1.generic[14] >>= vec2.generic[0];
	vec1.generic[15] >>= vec2.generic[0];
	return vec1;
}
# define VUINT16x16_LRSHIFT_DEFINED
#endif
#if !defined(VUINT16x16_LSHIFT_DEFINED)
VEC_FUNC_IMPL vuint16x16 vuint16x16_lshift(vuint16x16 vec1, vuint16x16 vec2)
{
	vec1.generic[0] <<= vec2.generic[0];
	vec1.generic[1] <<= vec2.generic[0];
	vec1.generic[2] <<= vec2.generic[0];
	vec1.generic[3] <<= vec2.generic[0];
	vec1.generic[4] <<= vec2.generic[0];
	vec1.generic[5] <<= vec2.generic[0];
	vec1.generic[6] <<= vec2.generic[0];
	vec1.generic[7] <<= vec2.generic[0];
	vec1.generic[8] <<= vec2.generic[0];
	vec1.generic[9] <<= vec2.generic[0];
	vec1.generic[10] <<= vec2.generic[0];
	vec1.generic[11] <<= vec2.generic[0];
	vec1.generic[12] <<= vec2.generic[0];
	vec1.generic[13] <<= vec2.generic[0];
	vec1.generic[14] <<= vec2.generic[0];
	vec1.generic[15] <<= vec2.generic[0];
	return vec1;
}
# define VUINT16x16_LSHIFT_DEFINED
#endif
#if !defined(VINT16x32_SPLAT_DEFINED)
VEC_FUNC_IMPL vint16x32 vint16x32_splat(vec_int16 x)
{
	vint16x32 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	vec.generic[4] = x;
	vec.generic[5] = x;
	vec.generic[6] = x;
	vec.generic[7] = x;
	vec.generic[8] = x;
	vec.generic[9] = x;
	vec.generic[10] = x;
	vec.generic[11] = x;
	vec.generic[12] = x;
	vec.generic[13] = x;
	vec.generic[14] = x;
	vec.generic[15] = x;
	vec.generic[16] = x;
	vec.generic[17] = x;
	vec.generic[18] = x;
	vec.generic[19] = x;
	vec.generic[20] = x;
	vec.generic[21] = x;
	vec.generic[22] = x;
	vec.generic[23] = x;
	vec.generic[24] = x;
	vec.generic[25] = x;
	vec.generic[26] = x;
	vec.generic[27] = x;
	vec.generic[28] = x;
	vec.generic[29] = x;
	vec.generic[30] = x;
	vec.generic[31] = x;
	return vec;
}
# define VINT16x32_SPLAT_DEFINED
#endif
#if !defined(VINT16x32_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vint16x32 vint16x32_load_aligned(const vec_int16 x[32])
{
	vint16x32 vec;
	memcpy(vec.generic, x, 64);
	return vec;
}
# define VINT16x32_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VINT16x32_LOAD_DEFINED)
VEC_FUNC_IMPL vint16x32 vint16x32_load(const vec_int16 x[32])
{
	vint16x32 vec;
	memcpy(vec.generic, x, 64);
	return vec;
}
# define VINT16x32_LOAD_DEFINED
#endif
#if !defined(VINT16x32_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vint16x32_store_aligned(vint16x32 vec, vec_int16 x[32])
{
	memcpy(x, vec.generic, 64);
}
# define VINT16x32_STORE_ALIGNED_DEFINED
#endif
#if !defined(VINT16x32_STORE_DEFINED)
VEC_FUNC_IMPL void vint16x32_store(vint16x32 vec, vec_int16 x[32])
{
	memcpy(x, vec.generic, 64);
}
# define VINT16x32_STORE_DEFINED
#endif
#if !defined(VINT16x32_ADD_DEFINED)
VEC_FUNC_IMPL vint16x32 vint16x32_add(vint16x32 vec1, vint16x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] + vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] + vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] + vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] + vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] + vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] + vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] + vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] + vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] + vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] + vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] + vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] + vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] + vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] + vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] + vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] + vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] + vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] + vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] + vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] + vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] + vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] + vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] + vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] + vec2.generic[31]);
	return vec1;
}
# define VINT16x32_ADD_DEFINED
#endif
#if !defined(VINT16x32_SUB_DEFINED)
VEC_FUNC_IMPL vint16x32 vint16x32_sub(vint16x32 vec1, vint16x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] - vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] - vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] - vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] - vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] - vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] - vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] - vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] - vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] - vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] - vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] - vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] - vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] - vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] - vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] - vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] - vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] - vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] - vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] - vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] - vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] - vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] - vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] - vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] - vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] - vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] - vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] - vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] - vec2.generic[31]);
	return vec1;
}
# define VINT16x32_SUB_DEFINED
#endif
#if !defined(VINT16x32_MUL_DEFINED)
VEC_FUNC_IMPL vint16x32 vint16x32_mul(vint16x32 vec1, vint16x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] * vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] * vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] * vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] * vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] * vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] * vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] * vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] * vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] * vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] * vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] * vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] * vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] * vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] * vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] * vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] * vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] * vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] * vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] * vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] * vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] * vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] * vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] * vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] * vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] * vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] * vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] * vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] * vec2.generic[31]);
	return vec1;
}
# define VINT16x32_MUL_DEFINED
#endif
#if !defined(VINT16x32_DIV_DEFINED)
VEC_FUNC_IMPL vint16x32 vint16x32_div(vint16x32 vec1, vint16x32 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] / vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] / vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] / vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] / vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? (vec1.generic[8] / vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? (vec1.generic[9] / vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? (vec1.generic[10] / vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? (vec1.generic[11] / vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? (vec1.generic[12] / vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? (vec1.generic[13] / vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? (vec1.generic[14] / vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? (vec1.generic[15] / vec2.generic[15]) : 0);
	vec1.generic[16] = (vec2.generic[16] ? (vec1.generic[16] / vec2.generic[16]) : 0);
	vec1.generic[17] = (vec2.generic[17] ? (vec1.generic[17] / vec2.generic[17]) : 0);
	vec1.generic[18] = (vec2.generic[18] ? (vec1.generic[18] / vec2.generic[18]) : 0);
	vec1.generic[19] = (vec2.generic[19] ? (vec1.generic[19] / vec2.generic[19]) : 0);
	vec1.generic[20] = (vec2.generic[20] ? (vec1.generic[20] / vec2.generic[20]) : 0);
	vec1.generic[21] = (vec2.generic[21] ? (vec1.generic[21] / vec2.generic[21]) : 0);
	vec1.generic[22] = (vec2.generic[22] ? (vec1.generic[22] / vec2.generic[22]) : 0);
	vec1.generic[23] = (vec2.generic[23] ? (vec1.generic[23] / vec2.generic[23]) : 0);
	vec1.generic[24] = (vec2.generic[24] ? (vec1.generic[24] / vec2.generic[24]) : 0);
	vec1.generic[25] = (vec2.generic[25] ? (vec1.generic[25] / vec2.generic[25]) : 0);
	vec1.generic[26] = (vec2.generic[26] ? (vec1.generic[26] / vec2.generic[26]) : 0);
	vec1.generic[27] = (vec2.generic[27] ? (vec1.generic[27] / vec2.generic[27]) : 0);
	vec1.generic[28] = (vec2.generic[28] ? (vec1.generic[28] / vec2.generic[28]) : 0);
	vec1.generic[29] = (vec2.generic[29] ? (vec1.generic[29] / vec2.generic[29]) : 0);
	vec1.generic[30] = (vec2.generic[30] ? (vec1.generic[30] / vec2.generic[30]) : 0);
	vec1.generic[31] = (vec2.generic[31] ? (vec1.generic[31] / vec2.generic[31]) : 0);
	return vec1;
}
# define VINT16x32_DIV_DEFINED
#endif
#if !defined(VINT16x32_MOD_DEFINED)
VEC_FUNC_IMPL vint16x32 vint16x32_mod(vint16x32 vec1, vint16x32 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] % vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] % vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] % vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] % vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? (vec1.generic[8] % vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? (vec1.generic[9] % vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? (vec1.generic[10] % vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? (vec1.generic[11] % vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? (vec1.generic[12] % vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? (vec1.generic[13] % vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? (vec1.generic[14] % vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? (vec1.generic[15] % vec2.generic[15]) : 0);
	vec1.generic[16] = (vec2.generic[16] ? (vec1.generic[16] % vec2.generic[16]) : 0);
	vec1.generic[17] = (vec2.generic[17] ? (vec1.generic[17] % vec2.generic[17]) : 0);
	vec1.generic[18] = (vec2.generic[18] ? (vec1.generic[18] % vec2.generic[18]) : 0);
	vec1.generic[19] = (vec2.generic[19] ? (vec1.generic[19] % vec2.generic[19]) : 0);
	vec1.generic[20] = (vec2.generic[20] ? (vec1.generic[20] % vec2.generic[20]) : 0);
	vec1.generic[21] = (vec2.generic[21] ? (vec1.generic[21] % vec2.generic[21]) : 0);
	vec1.generic[22] = (vec2.generic[22] ? (vec1.generic[22] % vec2.generic[22]) : 0);
	vec1.generic[23] = (vec2.generic[23] ? (vec1.generic[23] % vec2.generic[23]) : 0);
	vec1.generic[24] = (vec2.generic[24] ? (vec1.generic[24] % vec2.generic[24]) : 0);
	vec1.generic[25] = (vec2.generic[25] ? (vec1.generic[25] % vec2.generic[25]) : 0);
	vec1.generic[26] = (vec2.generic[26] ? (vec1.generic[26] % vec2.generic[26]) : 0);
	vec1.generic[27] = (vec2.generic[27] ? (vec1.generic[27] % vec2.generic[27]) : 0);
	vec1.generic[28] = (vec2.generic[28] ? (vec1.generic[28] % vec2.generic[28]) : 0);
	vec1.generic[29] = (vec2.generic[29] ? (vec1.generic[29] % vec2.generic[29]) : 0);
	vec1.generic[30] = (vec2.generic[30] ? (vec1.generic[30] % vec2.generic[30]) : 0);
	vec1.generic[31] = (vec2.generic[31] ? (vec1.generic[31] % vec2.generic[31]) : 0);
	return vec1;
}
# define VINT16x32_MOD_DEFINED
#endif
#if !defined(VINT16x32_AVG_DEFINED)
VEC_FUNC_IMPL vint16x32 vint16x32_avg(vint16x32 vec1, vint16x32 vec2)
{
	vec_int16 x_d_rem, y_d_rem, rem_d_quot, rem_d_rem;
	x_d_rem = (vec1.generic[0] % 2);
	y_d_rem = (vec2.generic[0] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[0] = ((vec1.generic[0] / 2) + (vec2.generic[0] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[1] % 2);
	y_d_rem = (vec2.generic[1] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[1] = ((vec1.generic[1] / 2) + (vec2.generic[1] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[2] % 2);
	y_d_rem = (vec2.generic[2] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[2] = ((vec1.generic[2] / 2) + (vec2.generic[2] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[3] % 2);
	y_d_rem = (vec2.generic[3] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[3] = ((vec1.generic[3] / 2) + (vec2.generic[3] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[4] % 2);
	y_d_rem = (vec2.generic[4] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[4] = ((vec1.generic[4] / 2) + (vec2.generic[4] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[5] % 2);
	y_d_rem = (vec2.generic[5] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[5] = ((vec1.generic[5] / 2) + (vec2.generic[5] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[6] % 2);
	y_d_rem = (vec2.generic[6] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[6] = ((vec1.generic[6] / 2) + (vec2.generic[6] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[7] % 2);
	y_d_rem = (vec2.generic[7] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[7] = ((vec1.generic[7] / 2) + (vec2.generic[7] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[8] % 2);
	y_d_rem = (vec2.generic[8] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[8] = ((vec1.generic[8] / 2) + (vec2.generic[8] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[9] % 2);
	y_d_rem = (vec2.generic[9] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[9] = ((vec1.generic[9] / 2) + (vec2.generic[9] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[10] % 2);
	y_d_rem = (vec2.generic[10] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[10] = ((vec1.generic[10] / 2) + (vec2.generic[10] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[11] % 2);
	y_d_rem = (vec2.generic[11] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[11] = ((vec1.generic[11] / 2) + (vec2.generic[11] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[12] % 2);
	y_d_rem = (vec2.generic[12] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[12] = ((vec1.generic[12] / 2) + (vec2.generic[12] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[13] % 2);
	y_d_rem = (vec2.generic[13] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[13] = ((vec1.generic[13] / 2) + (vec2.generic[13] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[14] % 2);
	y_d_rem = (vec2.generic[14] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[14] = ((vec1.generic[14] / 2) + (vec2.generic[14] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[15] % 2);
	y_d_rem = (vec2.generic[15] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[15] = ((vec1.generic[15] / 2) + (vec2.generic[15] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[16] % 2);
	y_d_rem = (vec2.generic[16] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[16] = ((vec1.generic[16] / 2) + (vec2.generic[16] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[17] % 2);
	y_d_rem = (vec2.generic[17] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[17] = ((vec1.generic[17] / 2) + (vec2.generic[17] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[18] % 2);
	y_d_rem = (vec2.generic[18] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[18] = ((vec1.generic[18] / 2) + (vec2.generic[18] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[19] % 2);
	y_d_rem = (vec2.generic[19] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[19] = ((vec1.generic[19] / 2) + (vec2.generic[19] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[20] % 2);
	y_d_rem = (vec2.generic[20] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[20] = ((vec1.generic[20] / 2) + (vec2.generic[20] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[21] % 2);
	y_d_rem = (vec2.generic[21] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[21] = ((vec1.generic[21] / 2) + (vec2.generic[21] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[22] % 2);
	y_d_rem = (vec2.generic[22] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[22] = ((vec1.generic[22] / 2) + (vec2.generic[22] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[23] % 2);
	y_d_rem = (vec2.generic[23] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[23] = ((vec1.generic[23] / 2) + (vec2.generic[23] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[24] % 2);
	y_d_rem = (vec2.generic[24] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[24] = ((vec1.generic[24] / 2) + (vec2.generic[24] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[25] % 2);
	y_d_rem = (vec2.generic[25] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[25] = ((vec1.generic[25] / 2) + (vec2.generic[25] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[26] % 2);
	y_d_rem = (vec2.generic[26] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[26] = ((vec1.generic[26] / 2) + (vec2.generic[26] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[27] % 2);
	y_d_rem = (vec2.generic[27] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[27] = ((vec1.generic[27] / 2) + (vec2.generic[27] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[28] % 2);
	y_d_rem = (vec2.generic[28] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[28] = ((vec1.generic[28] / 2) + (vec2.generic[28] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[29] % 2);
	y_d_rem = (vec2.generic[29] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[29] = ((vec1.generic[29] / 2) + (vec2.generic[29] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[30] % 2);
	y_d_rem = (vec2.generic[30] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[30] = ((vec1.generic[30] / 2) + (vec2.generic[30] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[31] % 2);
	y_d_rem = (vec2.generic[31] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[31] = ((vec1.generic[31] / 2) + (vec2.generic[31] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	return vec1;
}
# define VINT16x32_AVG_DEFINED
#endif
#if !defined(VINT16x32_AND_DEFINED)
VEC_FUNC_IMPL vint16x32 vint16x32_and(vint16x32 vec1, vint16x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] & vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] & vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] & vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] & vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] & vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] & vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] & vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] & vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] & vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] & vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] & vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] & vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] & vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] & vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] & vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] & vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] & vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] & vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] & vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] & vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] & vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] & vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] & vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] & vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] & vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] & vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] & vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] & vec2.generic[31]);
	return vec1;
}
# define VINT16x32_AND_DEFINED
#endif
#if !defined(VINT16x32_OR_DEFINED)
VEC_FUNC_IMPL vint16x32 vint16x32_or(vint16x32 vec1, vint16x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] | vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] | vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] | vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] | vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] | vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] | vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] | vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] | vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] | vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] | vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] | vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] | vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] | vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] | vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] | vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] | vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] | vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] | vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] | vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] | vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] | vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] | vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] | vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] | vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] | vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] | vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] | vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] | vec2.generic[31]);
	return vec1;
}
# define VINT16x32_OR_DEFINED
#endif
#if !defined(VINT16x32_XOR_DEFINED)
VEC_FUNC_IMPL vint16x32 vint16x32_xor(vint16x32 vec1, vint16x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] ^ vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] ^ vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] ^ vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] ^ vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] ^ vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] ^ vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] ^ vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] ^ vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] ^ vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] ^ vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] ^ vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] ^ vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] ^ vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] ^ vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] ^ vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] ^ vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] ^ vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] ^ vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] ^ vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] ^ vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] ^ vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] ^ vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] ^ vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] ^ vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] ^ vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] ^ vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] ^ vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] ^ vec2.generic[31]);
	return vec1;
}
# define VINT16x32_XOR_DEFINED
#endif
#if !defined(VINT16x32_NOT_DEFINED)
VEC_FUNC_IMPL vint16x32 vint16x32_not(vint16x32 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	vec.generic[4] = ~vec.generic[4];
	vec.generic[5] = ~vec.generic[5];
	vec.generic[6] = ~vec.generic[6];
	vec.generic[7] = ~vec.generic[7];
	vec.generic[8] = ~vec.generic[8];
	vec.generic[9] = ~vec.generic[9];
	vec.generic[10] = ~vec.generic[10];
	vec.generic[11] = ~vec.generic[11];
	vec.generic[12] = ~vec.generic[12];
	vec.generic[13] = ~vec.generic[13];
	vec.generic[14] = ~vec.generic[14];
	vec.generic[15] = ~vec.generic[15];
	vec.generic[16] = ~vec.generic[16];
	vec.generic[17] = ~vec.generic[17];
	vec.generic[18] = ~vec.generic[18];
	vec.generic[19] = ~vec.generic[19];
	vec.generic[20] = ~vec.generic[20];
	vec.generic[21] = ~vec.generic[21];
	vec.generic[22] = ~vec.generic[22];
	vec.generic[23] = ~vec.generic[23];
	vec.generic[24] = ~vec.generic[24];
	vec.generic[25] = ~vec.generic[25];
	vec.generic[26] = ~vec.generic[26];
	vec.generic[27] = ~vec.generic[27];
	vec.generic[28] = ~vec.generic[28];
	vec.generic[29] = ~vec.generic[29];
	vec.generic[30] = ~vec.generic[30];
	vec.generic[31] = ~vec.generic[31];
	return vec;
}
# define VINT16x32_NOT_DEFINED
#endif
#if !defined(VINT16x32_CMPLT_DEFINED)
VEC_FUNC_IMPL vint16x32 vint16x32_cmplt(vint16x32 vec1, vint16x32 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] < vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] < vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] < vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] < vec2.generic[7]) ? 0xFF : 0, 2);
	memset(&vec1.generic[8], (vec1.generic[8] < vec2.generic[8]) ? 0xFF : 0, 2);
	memset(&vec1.generic[9], (vec1.generic[9] < vec2.generic[9]) ? 0xFF : 0, 2);
	memset(&vec1.generic[10], (vec1.generic[10] < vec2.generic[10]) ? 0xFF : 0, 2);
	memset(&vec1.generic[11], (vec1.generic[11] < vec2.generic[11]) ? 0xFF : 0, 2);
	memset(&vec1.generic[12], (vec1.generic[12] < vec2.generic[12]) ? 0xFF : 0, 2);
	memset(&vec1.generic[13], (vec1.generic[13] < vec2.generic[13]) ? 0xFF : 0, 2);
	memset(&vec1.generic[14], (vec1.generic[14] < vec2.generic[14]) ? 0xFF : 0, 2);
	memset(&vec1.generic[15], (vec1.generic[15] < vec2.generic[15]) ? 0xFF : 0, 2);
	memset(&vec1.generic[16], (vec1.generic[16] < vec2.generic[16]) ? 0xFF : 0, 2);
	memset(&vec1.generic[17], (vec1.generic[17] < vec2.generic[17]) ? 0xFF : 0, 2);
	memset(&vec1.generic[18], (vec1.generic[18] < vec2.generic[18]) ? 0xFF : 0, 2);
	memset(&vec1.generic[19], (vec1.generic[19] < vec2.generic[19]) ? 0xFF : 0, 2);
	memset(&vec1.generic[20], (vec1.generic[20] < vec2.generic[20]) ? 0xFF : 0, 2);
	memset(&vec1.generic[21], (vec1.generic[21] < vec2.generic[21]) ? 0xFF : 0, 2);
	memset(&vec1.generic[22], (vec1.generic[22] < vec2.generic[22]) ? 0xFF : 0, 2);
	memset(&vec1.generic[23], (vec1.generic[23] < vec2.generic[23]) ? 0xFF : 0, 2);
	memset(&vec1.generic[24], (vec1.generic[24] < vec2.generic[24]) ? 0xFF : 0, 2);
	memset(&vec1.generic[25], (vec1.generic[25] < vec2.generic[25]) ? 0xFF : 0, 2);
	memset(&vec1.generic[26], (vec1.generic[26] < vec2.generic[26]) ? 0xFF : 0, 2);
	memset(&vec1.generic[27], (vec1.generic[27] < vec2.generic[27]) ? 0xFF : 0, 2);
	memset(&vec1.generic[28], (vec1.generic[28] < vec2.generic[28]) ? 0xFF : 0, 2);
	memset(&vec1.generic[29], (vec1.generic[29] < vec2.generic[29]) ? 0xFF : 0, 2);
	memset(&vec1.generic[30], (vec1.generic[30] < vec2.generic[30]) ? 0xFF : 0, 2);
	memset(&vec1.generic[31], (vec1.generic[31] < vec2.generic[31]) ? 0xFF : 0, 2);
	return vec1;
}
# define VINT16x32_CMPLT_DEFINED
#endif
#if !defined(VINT16x32_CMPEQ_DEFINED)
VEC_FUNC_IMPL vint16x32 vint16x32_cmpeq(vint16x32 vec1, vint16x32 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] == vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] == vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] == vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] == vec2.generic[7]) ? 0xFF : 0, 2);
	memset(&vec1.generic[8], (vec1.generic[8] == vec2.generic[8]) ? 0xFF : 0, 2);
	memset(&vec1.generic[9], (vec1.generic[9] == vec2.generic[9]) ? 0xFF : 0, 2);
	memset(&vec1.generic[10], (vec1.generic[10] == vec2.generic[10]) ? 0xFF : 0, 2);
	memset(&vec1.generic[11], (vec1.generic[11] == vec2.generic[11]) ? 0xFF : 0, 2);
	memset(&vec1.generic[12], (vec1.generic[12] == vec2.generic[12]) ? 0xFF : 0, 2);
	memset(&vec1.generic[13], (vec1.generic[13] == vec2.generic[13]) ? 0xFF : 0, 2);
	memset(&vec1.generic[14], (vec1.generic[14] == vec2.generic[14]) ? 0xFF : 0, 2);
	memset(&vec1.generic[15], (vec1.generic[15] == vec2.generic[15]) ? 0xFF : 0, 2);
	memset(&vec1.generic[16], (vec1.generic[16] == vec2.generic[16]) ? 0xFF : 0, 2);
	memset(&vec1.generic[17], (vec1.generic[17] == vec2.generic[17]) ? 0xFF : 0, 2);
	memset(&vec1.generic[18], (vec1.generic[18] == vec2.generic[18]) ? 0xFF : 0, 2);
	memset(&vec1.generic[19], (vec1.generic[19] == vec2.generic[19]) ? 0xFF : 0, 2);
	memset(&vec1.generic[20], (vec1.generic[20] == vec2.generic[20]) ? 0xFF : 0, 2);
	memset(&vec1.generic[21], (vec1.generic[21] == vec2.generic[21]) ? 0xFF : 0, 2);
	memset(&vec1.generic[22], (vec1.generic[22] == vec2.generic[22]) ? 0xFF : 0, 2);
	memset(&vec1.generic[23], (vec1.generic[23] == vec2.generic[23]) ? 0xFF : 0, 2);
	memset(&vec1.generic[24], (vec1.generic[24] == vec2.generic[24]) ? 0xFF : 0, 2);
	memset(&vec1.generic[25], (vec1.generic[25] == vec2.generic[25]) ? 0xFF : 0, 2);
	memset(&vec1.generic[26], (vec1.generic[26] == vec2.generic[26]) ? 0xFF : 0, 2);
	memset(&vec1.generic[27], (vec1.generic[27] == vec2.generic[27]) ? 0xFF : 0, 2);
	memset(&vec1.generic[28], (vec1.generic[28] == vec2.generic[28]) ? 0xFF : 0, 2);
	memset(&vec1.generic[29], (vec1.generic[29] == vec2.generic[29]) ? 0xFF : 0, 2);
	memset(&vec1.generic[30], (vec1.generic[30] == vec2.generic[30]) ? 0xFF : 0, 2);
	memset(&vec1.generic[31], (vec1.generic[31] == vec2.generic[31]) ? 0xFF : 0, 2);
	return vec1;
}
# define VINT16x32_CMPEQ_DEFINED
#endif
#if !defined(VINT16x32_CMPGT_DEFINED)
VEC_FUNC_IMPL vint16x32 vint16x32_cmpgt(vint16x32 vec1, vint16x32 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] > vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] > vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] > vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] > vec2.generic[7]) ? 0xFF : 0, 2);
	memset(&vec1.generic[8], (vec1.generic[8] > vec2.generic[8]) ? 0xFF : 0, 2);
	memset(&vec1.generic[9], (vec1.generic[9] > vec2.generic[9]) ? 0xFF : 0, 2);
	memset(&vec1.generic[10], (vec1.generic[10] > vec2.generic[10]) ? 0xFF : 0, 2);
	memset(&vec1.generic[11], (vec1.generic[11] > vec2.generic[11]) ? 0xFF : 0, 2);
	memset(&vec1.generic[12], (vec1.generic[12] > vec2.generic[12]) ? 0xFF : 0, 2);
	memset(&vec1.generic[13], (vec1.generic[13] > vec2.generic[13]) ? 0xFF : 0, 2);
	memset(&vec1.generic[14], (vec1.generic[14] > vec2.generic[14]) ? 0xFF : 0, 2);
	memset(&vec1.generic[15], (vec1.generic[15] > vec2.generic[15]) ? 0xFF : 0, 2);
	memset(&vec1.generic[16], (vec1.generic[16] > vec2.generic[16]) ? 0xFF : 0, 2);
	memset(&vec1.generic[17], (vec1.generic[17] > vec2.generic[17]) ? 0xFF : 0, 2);
	memset(&vec1.generic[18], (vec1.generic[18] > vec2.generic[18]) ? 0xFF : 0, 2);
	memset(&vec1.generic[19], (vec1.generic[19] > vec2.generic[19]) ? 0xFF : 0, 2);
	memset(&vec1.generic[20], (vec1.generic[20] > vec2.generic[20]) ? 0xFF : 0, 2);
	memset(&vec1.generic[21], (vec1.generic[21] > vec2.generic[21]) ? 0xFF : 0, 2);
	memset(&vec1.generic[22], (vec1.generic[22] > vec2.generic[22]) ? 0xFF : 0, 2);
	memset(&vec1.generic[23], (vec1.generic[23] > vec2.generic[23]) ? 0xFF : 0, 2);
	memset(&vec1.generic[24], (vec1.generic[24] > vec2.generic[24]) ? 0xFF : 0, 2);
	memset(&vec1.generic[25], (vec1.generic[25] > vec2.generic[25]) ? 0xFF : 0, 2);
	memset(&vec1.generic[26], (vec1.generic[26] > vec2.generic[26]) ? 0xFF : 0, 2);
	memset(&vec1.generic[27], (vec1.generic[27] > vec2.generic[27]) ? 0xFF : 0, 2);
	memset(&vec1.generic[28], (vec1.generic[28] > vec2.generic[28]) ? 0xFF : 0, 2);
	memset(&vec1.generic[29], (vec1.generic[29] > vec2.generic[29]) ? 0xFF : 0, 2);
	memset(&vec1.generic[30], (vec1.generic[30] > vec2.generic[30]) ? 0xFF : 0, 2);
	memset(&vec1.generic[31], (vec1.generic[31] > vec2.generic[31]) ? 0xFF : 0, 2);
	return vec1;
}
# define VINT16x32_CMPGT_DEFINED
#endif
#if !defined(VINT16x32_CMPLE_DEFINED)
VEC_FUNC_IMPL vint16x32 vint16x32_cmple(vint16x32 vec1, vint16x32 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] <= vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] <= vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] <= vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] <= vec2.generic[7]) ? 0xFF : 0, 2);
	memset(&vec1.generic[8], (vec1.generic[8] <= vec2.generic[8]) ? 0xFF : 0, 2);
	memset(&vec1.generic[9], (vec1.generic[9] <= vec2.generic[9]) ? 0xFF : 0, 2);
	memset(&vec1.generic[10], (vec1.generic[10] <= vec2.generic[10]) ? 0xFF : 0, 2);
	memset(&vec1.generic[11], (vec1.generic[11] <= vec2.generic[11]) ? 0xFF : 0, 2);
	memset(&vec1.generic[12], (vec1.generic[12] <= vec2.generic[12]) ? 0xFF : 0, 2);
	memset(&vec1.generic[13], (vec1.generic[13] <= vec2.generic[13]) ? 0xFF : 0, 2);
	memset(&vec1.generic[14], (vec1.generic[14] <= vec2.generic[14]) ? 0xFF : 0, 2);
	memset(&vec1.generic[15], (vec1.generic[15] <= vec2.generic[15]) ? 0xFF : 0, 2);
	memset(&vec1.generic[16], (vec1.generic[16] <= vec2.generic[16]) ? 0xFF : 0, 2);
	memset(&vec1.generic[17], (vec1.generic[17] <= vec2.generic[17]) ? 0xFF : 0, 2);
	memset(&vec1.generic[18], (vec1.generic[18] <= vec2.generic[18]) ? 0xFF : 0, 2);
	memset(&vec1.generic[19], (vec1.generic[19] <= vec2.generic[19]) ? 0xFF : 0, 2);
	memset(&vec1.generic[20], (vec1.generic[20] <= vec2.generic[20]) ? 0xFF : 0, 2);
	memset(&vec1.generic[21], (vec1.generic[21] <= vec2.generic[21]) ? 0xFF : 0, 2);
	memset(&vec1.generic[22], (vec1.generic[22] <= vec2.generic[22]) ? 0xFF : 0, 2);
	memset(&vec1.generic[23], (vec1.generic[23] <= vec2.generic[23]) ? 0xFF : 0, 2);
	memset(&vec1.generic[24], (vec1.generic[24] <= vec2.generic[24]) ? 0xFF : 0, 2);
	memset(&vec1.generic[25], (vec1.generic[25] <= vec2.generic[25]) ? 0xFF : 0, 2);
	memset(&vec1.generic[26], (vec1.generic[26] <= vec2.generic[26]) ? 0xFF : 0, 2);
	memset(&vec1.generic[27], (vec1.generic[27] <= vec2.generic[27]) ? 0xFF : 0, 2);
	memset(&vec1.generic[28], (vec1.generic[28] <= vec2.generic[28]) ? 0xFF : 0, 2);
	memset(&vec1.generic[29], (vec1.generic[29] <= vec2.generic[29]) ? 0xFF : 0, 2);
	memset(&vec1.generic[30], (vec1.generic[30] <= vec2.generic[30]) ? 0xFF : 0, 2);
	memset(&vec1.generic[31], (vec1.generic[31] <= vec2.generic[31]) ? 0xFF : 0, 2);
	return vec1;
}
# define VINT16x32_CMPLE_DEFINED
#endif
#if !defined(VINT16x32_CMPGE_DEFINED)
VEC_FUNC_IMPL vint16x32 vint16x32_cmpge(vint16x32 vec1, vint16x32 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] >= vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] >= vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] >= vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] >= vec2.generic[7]) ? 0xFF : 0, 2);
	memset(&vec1.generic[8], (vec1.generic[8] >= vec2.generic[8]) ? 0xFF : 0, 2);
	memset(&vec1.generic[9], (vec1.generic[9] >= vec2.generic[9]) ? 0xFF : 0, 2);
	memset(&vec1.generic[10], (vec1.generic[10] >= vec2.generic[10]) ? 0xFF : 0, 2);
	memset(&vec1.generic[11], (vec1.generic[11] >= vec2.generic[11]) ? 0xFF : 0, 2);
	memset(&vec1.generic[12], (vec1.generic[12] >= vec2.generic[12]) ? 0xFF : 0, 2);
	memset(&vec1.generic[13], (vec1.generic[13] >= vec2.generic[13]) ? 0xFF : 0, 2);
	memset(&vec1.generic[14], (vec1.generic[14] >= vec2.generic[14]) ? 0xFF : 0, 2);
	memset(&vec1.generic[15], (vec1.generic[15] >= vec2.generic[15]) ? 0xFF : 0, 2);
	memset(&vec1.generic[16], (vec1.generic[16] >= vec2.generic[16]) ? 0xFF : 0, 2);
	memset(&vec1.generic[17], (vec1.generic[17] >= vec2.generic[17]) ? 0xFF : 0, 2);
	memset(&vec1.generic[18], (vec1.generic[18] >= vec2.generic[18]) ? 0xFF : 0, 2);
	memset(&vec1.generic[19], (vec1.generic[19] >= vec2.generic[19]) ? 0xFF : 0, 2);
	memset(&vec1.generic[20], (vec1.generic[20] >= vec2.generic[20]) ? 0xFF : 0, 2);
	memset(&vec1.generic[21], (vec1.generic[21] >= vec2.generic[21]) ? 0xFF : 0, 2);
	memset(&vec1.generic[22], (vec1.generic[22] >= vec2.generic[22]) ? 0xFF : 0, 2);
	memset(&vec1.generic[23], (vec1.generic[23] >= vec2.generic[23]) ? 0xFF : 0, 2);
	memset(&vec1.generic[24], (vec1.generic[24] >= vec2.generic[24]) ? 0xFF : 0, 2);
	memset(&vec1.generic[25], (vec1.generic[25] >= vec2.generic[25]) ? 0xFF : 0, 2);
	memset(&vec1.generic[26], (vec1.generic[26] >= vec2.generic[26]) ? 0xFF : 0, 2);
	memset(&vec1.generic[27], (vec1.generic[27] >= vec2.generic[27]) ? 0xFF : 0, 2);
	memset(&vec1.generic[28], (vec1.generic[28] >= vec2.generic[28]) ? 0xFF : 0, 2);
	memset(&vec1.generic[29], (vec1.generic[29] >= vec2.generic[29]) ? 0xFF : 0, 2);
	memset(&vec1.generic[30], (vec1.generic[30] >= vec2.generic[30]) ? 0xFF : 0, 2);
	memset(&vec1.generic[31], (vec1.generic[31] >= vec2.generic[31]) ? 0xFF : 0, 2);
	return vec1;
}
# define VINT16x32_CMPGE_DEFINED
#endif
#if !defined(VINT16x32_MIN_DEFINED)
VEC_FUNC_IMPL vint16x32 vint16x32_min(vint16x32 vec1, vint16x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] < vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] < vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] < vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] < vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] < vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] < vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] < vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] < vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] < vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] < vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] < vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] < vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] < vec2.generic[16]) ? (vec1.generic[16]) : (vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] < vec2.generic[17]) ? (vec1.generic[17]) : (vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] < vec2.generic[18]) ? (vec1.generic[18]) : (vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] < vec2.generic[19]) ? (vec1.generic[19]) : (vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] < vec2.generic[20]) ? (vec1.generic[20]) : (vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] < vec2.generic[21]) ? (vec1.generic[21]) : (vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] < vec2.generic[22]) ? (vec1.generic[22]) : (vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] < vec2.generic[23]) ? (vec1.generic[23]) : (vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] < vec2.generic[24]) ? (vec1.generic[24]) : (vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] < vec2.generic[25]) ? (vec1.generic[25]) : (vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] < vec2.generic[26]) ? (vec1.generic[26]) : (vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] < vec2.generic[27]) ? (vec1.generic[27]) : (vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] < vec2.generic[28]) ? (vec1.generic[28]) : (vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] < vec2.generic[29]) ? (vec1.generic[29]) : (vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] < vec2.generic[30]) ? (vec1.generic[30]) : (vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] < vec2.generic[31]) ? (vec1.generic[31]) : (vec2.generic[31]);
	return vec1;
}
# define VINT16x32_MIN_DEFINED
#endif
#if !defined(VINT16x32_MAX_DEFINED)
VEC_FUNC_IMPL vint16x32 vint16x32_max(vint16x32 vec1, vint16x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] > vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] > vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] > vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] > vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] > vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] > vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] > vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] > vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] > vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] > vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] > vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] > vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] > vec2.generic[16]) ? (vec1.generic[16]) : (vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] > vec2.generic[17]) ? (vec1.generic[17]) : (vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] > vec2.generic[18]) ? (vec1.generic[18]) : (vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] > vec2.generic[19]) ? (vec1.generic[19]) : (vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] > vec2.generic[20]) ? (vec1.generic[20]) : (vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] > vec2.generic[21]) ? (vec1.generic[21]) : (vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] > vec2.generic[22]) ? (vec1.generic[22]) : (vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] > vec2.generic[23]) ? (vec1.generic[23]) : (vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] > vec2.generic[24]) ? (vec1.generic[24]) : (vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] > vec2.generic[25]) ? (vec1.generic[25]) : (vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] > vec2.generic[26]) ? (vec1.generic[26]) : (vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] > vec2.generic[27]) ? (vec1.generic[27]) : (vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] > vec2.generic[28]) ? (vec1.generic[28]) : (vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] > vec2.generic[29]) ? (vec1.generic[29]) : (vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] > vec2.generic[30]) ? (vec1.generic[30]) : (vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] > vec2.generic[31]) ? (vec1.generic[31]) : (vec2.generic[31]);
	return vec1;
}
# define VINT16x32_MAX_DEFINED
#endif
#if !defined(VINT16x32_RSHIFT_DEFINED)
VEC_FUNC_IMPL vint16x32 vint16x32_rshift(vint16x32 vec1, vuint16x32 vec2)
{
vec1.generic[0] = ((~vec1.generic[0]) >> vec2.generic[0]);
vec1.generic[1] = ((~vec1.generic[1]) >> vec2.generic[1]);
vec1.generic[2] = ((~vec1.generic[2]) >> vec2.generic[2]);
vec1.generic[3] = ((~vec1.generic[3]) >> vec2.generic[3]);
vec1.generic[4] = ((~vec1.generic[4]) >> vec2.generic[4]);
vec1.generic[5] = ((~vec1.generic[5]) >> vec2.generic[5]);
vec1.generic[6] = ((~vec1.generic[6]) >> vec2.generic[6]);
vec1.generic[7] = ((~vec1.generic[7]) >> vec2.generic[7]);
vec1.generic[8] = ((~vec1.generic[8]) >> vec2.generic[8]);
vec1.generic[9] = ((~vec1.generic[9]) >> vec2.generic[9]);
vec1.generic[10] = ((~vec1.generic[10]) >> vec2.generic[10]);
vec1.generic[11] = ((~vec1.generic[11]) >> vec2.generic[11]);
vec1.generic[12] = ((~vec1.generic[12]) >> vec2.generic[12]);
vec1.generic[13] = ((~vec1.generic[13]) >> vec2.generic[13]);
vec1.generic[14] = ((~vec1.generic[14]) >> vec2.generic[14]);
vec1.generic[15] = ((~vec1.generic[15]) >> vec2.generic[15]);
vec1.generic[16] = ((~vec1.generic[16]) >> vec2.generic[16]);
vec1.generic[17] = ((~vec1.generic[17]) >> vec2.generic[17]);
vec1.generic[18] = ((~vec1.generic[18]) >> vec2.generic[18]);
vec1.generic[19] = ((~vec1.generic[19]) >> vec2.generic[19]);
vec1.generic[20] = ((~vec1.generic[20]) >> vec2.generic[20]);
vec1.generic[21] = ((~vec1.generic[21]) >> vec2.generic[21]);
vec1.generic[22] = ((~vec1.generic[22]) >> vec2.generic[22]);
vec1.generic[23] = ((~vec1.generic[23]) >> vec2.generic[23]);
vec1.generic[24] = ((~vec1.generic[24]) >> vec2.generic[24]);
vec1.generic[25] = ((~vec1.generic[25]) >> vec2.generic[25]);
vec1.generic[26] = ((~vec1.generic[26]) >> vec2.generic[26]);
vec1.generic[27] = ((~vec1.generic[27]) >> vec2.generic[27]);
vec1.generic[28] = ((~vec1.generic[28]) >> vec2.generic[28]);
vec1.generic[29] = ((~vec1.generic[29]) >> vec2.generic[29]);
vec1.generic[30] = ((~vec1.generic[30]) >> vec2.generic[30]);
vec1.generic[31] = ((~vec1.generic[31]) >> vec2.generic[31]);
	return vec1;
}
# define VINT16x32_RSHIFT_DEFINED
#endif
#if !defined(VINT16x32_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vint16x32 vint16x32_lrshift(vint16x32 vec1, vuint16x32 vec2)
{
	union { vec_uint16 u; vec_int16 s; } x;

	x.s = vec1.generic[0];
	x.u >>= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u >>= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u >>= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u >>= vec2.generic[3];
	vec1.generic[3] = x.s;
	x.s = vec1.generic[4];
	x.u >>= vec2.generic[4];
	vec1.generic[4] = x.s;
	x.s = vec1.generic[5];
	x.u >>= vec2.generic[5];
	vec1.generic[5] = x.s;
	x.s = vec1.generic[6];
	x.u >>= vec2.generic[6];
	vec1.generic[6] = x.s;
	x.s = vec1.generic[7];
	x.u >>= vec2.generic[7];
	vec1.generic[7] = x.s;
	x.s = vec1.generic[8];
	x.u >>= vec2.generic[8];
	vec1.generic[8] = x.s;
	x.s = vec1.generic[9];
	x.u >>= vec2.generic[9];
	vec1.generic[9] = x.s;
	x.s = vec1.generic[10];
	x.u >>= vec2.generic[10];
	vec1.generic[10] = x.s;
	x.s = vec1.generic[11];
	x.u >>= vec2.generic[11];
	vec1.generic[11] = x.s;
	x.s = vec1.generic[12];
	x.u >>= vec2.generic[12];
	vec1.generic[12] = x.s;
	x.s = vec1.generic[13];
	x.u >>= vec2.generic[13];
	vec1.generic[13] = x.s;
	x.s = vec1.generic[14];
	x.u >>= vec2.generic[14];
	vec1.generic[14] = x.s;
	x.s = vec1.generic[15];
	x.u >>= vec2.generic[15];
	vec1.generic[15] = x.s;
	x.s = vec1.generic[16];
	x.u >>= vec2.generic[16];
	vec1.generic[16] = x.s;
	x.s = vec1.generic[17];
	x.u >>= vec2.generic[17];
	vec1.generic[17] = x.s;
	x.s = vec1.generic[18];
	x.u >>= vec2.generic[18];
	vec1.generic[18] = x.s;
	x.s = vec1.generic[19];
	x.u >>= vec2.generic[19];
	vec1.generic[19] = x.s;
	x.s = vec1.generic[20];
	x.u >>= vec2.generic[20];
	vec1.generic[20] = x.s;
	x.s = vec1.generic[21];
	x.u >>= vec2.generic[21];
	vec1.generic[21] = x.s;
	x.s = vec1.generic[22];
	x.u >>= vec2.generic[22];
	vec1.generic[22] = x.s;
	x.s = vec1.generic[23];
	x.u >>= vec2.generic[23];
	vec1.generic[23] = x.s;
	x.s = vec1.generic[24];
	x.u >>= vec2.generic[24];
	vec1.generic[24] = x.s;
	x.s = vec1.generic[25];
	x.u >>= vec2.generic[25];
	vec1.generic[25] = x.s;
	x.s = vec1.generic[26];
	x.u >>= vec2.generic[26];
	vec1.generic[26] = x.s;
	x.s = vec1.generic[27];
	x.u >>= vec2.generic[27];
	vec1.generic[27] = x.s;
	x.s = vec1.generic[28];
	x.u >>= vec2.generic[28];
	vec1.generic[28] = x.s;
	x.s = vec1.generic[29];
	x.u >>= vec2.generic[29];
	vec1.generic[29] = x.s;
	x.s = vec1.generic[30];
	x.u >>= vec2.generic[30];
	vec1.generic[30] = x.s;
	x.s = vec1.generic[31];
	x.u >>= vec2.generic[31];
	vec1.generic[31] = x.s;
	return vec1;
}
# define VINT16x32_LRSHIFT_DEFINED
#endif
#if !defined(VINT16x32_LSHIFT_DEFINED)
VEC_FUNC_IMPL vint16x32 vint16x32_lshift(vint16x32 vec1, vuint16x32 vec2)
{
	union { vec_uint16 u; vec_int16 s; } x;

	x.s = vec1.generic[0];
	x.u <<= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u <<= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u <<= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u <<= vec2.generic[3];
	vec1.generic[3] = x.s;
	x.s = vec1.generic[4];
	x.u <<= vec2.generic[4];
	vec1.generic[4] = x.s;
	x.s = vec1.generic[5];
	x.u <<= vec2.generic[5];
	vec1.generic[5] = x.s;
	x.s = vec1.generic[6];
	x.u <<= vec2.generic[6];
	vec1.generic[6] = x.s;
	x.s = vec1.generic[7];
	x.u <<= vec2.generic[7];
	vec1.generic[7] = x.s;
	x.s = vec1.generic[8];
	x.u <<= vec2.generic[8];
	vec1.generic[8] = x.s;
	x.s = vec1.generic[9];
	x.u <<= vec2.generic[9];
	vec1.generic[9] = x.s;
	x.s = vec1.generic[10];
	x.u <<= vec2.generic[10];
	vec1.generic[10] = x.s;
	x.s = vec1.generic[11];
	x.u <<= vec2.generic[11];
	vec1.generic[11] = x.s;
	x.s = vec1.generic[12];
	x.u <<= vec2.generic[12];
	vec1.generic[12] = x.s;
	x.s = vec1.generic[13];
	x.u <<= vec2.generic[13];
	vec1.generic[13] = x.s;
	x.s = vec1.generic[14];
	x.u <<= vec2.generic[14];
	vec1.generic[14] = x.s;
	x.s = vec1.generic[15];
	x.u <<= vec2.generic[15];
	vec1.generic[15] = x.s;
	x.s = vec1.generic[16];
	x.u <<= vec2.generic[16];
	vec1.generic[16] = x.s;
	x.s = vec1.generic[17];
	x.u <<= vec2.generic[17];
	vec1.generic[17] = x.s;
	x.s = vec1.generic[18];
	x.u <<= vec2.generic[18];
	vec1.generic[18] = x.s;
	x.s = vec1.generic[19];
	x.u <<= vec2.generic[19];
	vec1.generic[19] = x.s;
	x.s = vec1.generic[20];
	x.u <<= vec2.generic[20];
	vec1.generic[20] = x.s;
	x.s = vec1.generic[21];
	x.u <<= vec2.generic[21];
	vec1.generic[21] = x.s;
	x.s = vec1.generic[22];
	x.u <<= vec2.generic[22];
	vec1.generic[22] = x.s;
	x.s = vec1.generic[23];
	x.u <<= vec2.generic[23];
	vec1.generic[23] = x.s;
	x.s = vec1.generic[24];
	x.u <<= vec2.generic[24];
	vec1.generic[24] = x.s;
	x.s = vec1.generic[25];
	x.u <<= vec2.generic[25];
	vec1.generic[25] = x.s;
	x.s = vec1.generic[26];
	x.u <<= vec2.generic[26];
	vec1.generic[26] = x.s;
	x.s = vec1.generic[27];
	x.u <<= vec2.generic[27];
	vec1.generic[27] = x.s;
	x.s = vec1.generic[28];
	x.u <<= vec2.generic[28];
	vec1.generic[28] = x.s;
	x.s = vec1.generic[29];
	x.u <<= vec2.generic[29];
	vec1.generic[29] = x.s;
	x.s = vec1.generic[30];
	x.u <<= vec2.generic[30];
	vec1.generic[30] = x.s;
	x.s = vec1.generic[31];
	x.u <<= vec2.generic[31];
	vec1.generic[31] = x.s;
	return vec1;
}
# define VINT16x32_LSHIFT_DEFINED
#endif
#if !defined(VUINT16x32_SPLAT_DEFINED)
VEC_FUNC_IMPL vuint16x32 vuint16x32_splat(vec_uint16 x)
{
	vuint16x32 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	vec.generic[4] = x;
	vec.generic[5] = x;
	vec.generic[6] = x;
	vec.generic[7] = x;
	vec.generic[8] = x;
	vec.generic[9] = x;
	vec.generic[10] = x;
	vec.generic[11] = x;
	vec.generic[12] = x;
	vec.generic[13] = x;
	vec.generic[14] = x;
	vec.generic[15] = x;
	vec.generic[16] = x;
	vec.generic[17] = x;
	vec.generic[18] = x;
	vec.generic[19] = x;
	vec.generic[20] = x;
	vec.generic[21] = x;
	vec.generic[22] = x;
	vec.generic[23] = x;
	vec.generic[24] = x;
	vec.generic[25] = x;
	vec.generic[26] = x;
	vec.generic[27] = x;
	vec.generic[28] = x;
	vec.generic[29] = x;
	vec.generic[30] = x;
	vec.generic[31] = x;
	return vec;
}
# define VUINT16x32_SPLAT_DEFINED
#endif
#if !defined(VUINT16x32_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vuint16x32 vuint16x32_load_aligned(const vec_uint16 x[32])
{
	vuint16x32 vec;
	memcpy(vec.generic, x, 64);
	return vec;
}
# define VUINT16x32_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VUINT16x32_LOAD_DEFINED)
VEC_FUNC_IMPL vuint16x32 vuint16x32_load(const vec_uint16 x[32])
{
	vuint16x32 vec;
	memcpy(vec.generic, x, 64);
	return vec;
}
# define VUINT16x32_LOAD_DEFINED
#endif
#if !defined(VUINT16x32_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vuint16x32_store_aligned(vuint16x32 vec, vec_uint16 x[32])
{
	memcpy(x, vec.generic, 64);
}
# define VUINT16x32_STORE_ALIGNED_DEFINED
#endif
#if !defined(VUINT16x32_STORE_DEFINED)
VEC_FUNC_IMPL void vuint16x32_store(vuint16x32 vec, vec_uint16 x[32])
{
	memcpy(x, vec.generic, 64);
}
# define VUINT16x32_STORE_DEFINED
#endif
#if !defined(VUINT16x32_ADD_DEFINED)
VEC_FUNC_IMPL vuint16x32 vuint16x32_add(vuint16x32 vec1, vuint16x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] + vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] + vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] + vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] + vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] + vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] + vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] + vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] + vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] + vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] + vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] + vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] + vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] + vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] + vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] + vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] + vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] + vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] + vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] + vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] + vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] + vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] + vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] + vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] + vec2.generic[31]);
	return vec1;
}
# define VUINT16x32_ADD_DEFINED
#endif
#if !defined(VUINT16x32_SUB_DEFINED)
VEC_FUNC_IMPL vuint16x32 vuint16x32_sub(vuint16x32 vec1, vuint16x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] - vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] - vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] - vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] - vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] - vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] - vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] - vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] - vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] - vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] - vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] - vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] - vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] - vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] - vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] - vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] - vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] - vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] - vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] - vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] - vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] - vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] - vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] - vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] - vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] - vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] - vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] - vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] - vec2.generic[31]);
	return vec1;
}
# define VUINT16x32_SUB_DEFINED
#endif
#if !defined(VUINT16x32_MUL_DEFINED)
VEC_FUNC_IMPL vuint16x32 vuint16x32_mul(vuint16x32 vec1, vuint16x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] * vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] * vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] * vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] * vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] * vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] * vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] * vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] * vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] * vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] * vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] * vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] * vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] * vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] * vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] * vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] * vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] * vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] * vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] * vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] * vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] * vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] * vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] * vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] * vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] * vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] * vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] * vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] * vec2.generic[31]);
	return vec1;
}
# define VUINT16x32_MUL_DEFINED
#endif
#if !defined(VUINT16x32_DIV_DEFINED)
VEC_FUNC_IMPL vuint16x32 vuint16x32_div(vuint16x32 vec1, vuint16x32 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] / vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] / vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] / vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] / vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? (vec1.generic[8] / vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? (vec1.generic[9] / vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? (vec1.generic[10] / vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? (vec1.generic[11] / vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? (vec1.generic[12] / vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? (vec1.generic[13] / vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? (vec1.generic[14] / vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? (vec1.generic[15] / vec2.generic[15]) : 0);
	vec1.generic[16] = (vec2.generic[16] ? (vec1.generic[16] / vec2.generic[16]) : 0);
	vec1.generic[17] = (vec2.generic[17] ? (vec1.generic[17] / vec2.generic[17]) : 0);
	vec1.generic[18] = (vec2.generic[18] ? (vec1.generic[18] / vec2.generic[18]) : 0);
	vec1.generic[19] = (vec2.generic[19] ? (vec1.generic[19] / vec2.generic[19]) : 0);
	vec1.generic[20] = (vec2.generic[20] ? (vec1.generic[20] / vec2.generic[20]) : 0);
	vec1.generic[21] = (vec2.generic[21] ? (vec1.generic[21] / vec2.generic[21]) : 0);
	vec1.generic[22] = (vec2.generic[22] ? (vec1.generic[22] / vec2.generic[22]) : 0);
	vec1.generic[23] = (vec2.generic[23] ? (vec1.generic[23] / vec2.generic[23]) : 0);
	vec1.generic[24] = (vec2.generic[24] ? (vec1.generic[24] / vec2.generic[24]) : 0);
	vec1.generic[25] = (vec2.generic[25] ? (vec1.generic[25] / vec2.generic[25]) : 0);
	vec1.generic[26] = (vec2.generic[26] ? (vec1.generic[26] / vec2.generic[26]) : 0);
	vec1.generic[27] = (vec2.generic[27] ? (vec1.generic[27] / vec2.generic[27]) : 0);
	vec1.generic[28] = (vec2.generic[28] ? (vec1.generic[28] / vec2.generic[28]) : 0);
	vec1.generic[29] = (vec2.generic[29] ? (vec1.generic[29] / vec2.generic[29]) : 0);
	vec1.generic[30] = (vec2.generic[30] ? (vec1.generic[30] / vec2.generic[30]) : 0);
	vec1.generic[31] = (vec2.generic[31] ? (vec1.generic[31] / vec2.generic[31]) : 0);
	return vec1;
}
# define VUINT16x32_DIV_DEFINED
#endif
#if !defined(VUINT16x32_MOD_DEFINED)
VEC_FUNC_IMPL vuint16x32 vuint16x32_mod(vuint16x32 vec1, vuint16x32 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] % vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] % vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] % vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] % vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? (vec1.generic[8] % vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? (vec1.generic[9] % vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? (vec1.generic[10] % vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? (vec1.generic[11] % vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? (vec1.generic[12] % vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? (vec1.generic[13] % vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? (vec1.generic[14] % vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? (vec1.generic[15] % vec2.generic[15]) : 0);
	vec1.generic[16] = (vec2.generic[16] ? (vec1.generic[16] % vec2.generic[16]) : 0);
	vec1.generic[17] = (vec2.generic[17] ? (vec1.generic[17] % vec2.generic[17]) : 0);
	vec1.generic[18] = (vec2.generic[18] ? (vec1.generic[18] % vec2.generic[18]) : 0);
	vec1.generic[19] = (vec2.generic[19] ? (vec1.generic[19] % vec2.generic[19]) : 0);
	vec1.generic[20] = (vec2.generic[20] ? (vec1.generic[20] % vec2.generic[20]) : 0);
	vec1.generic[21] = (vec2.generic[21] ? (vec1.generic[21] % vec2.generic[21]) : 0);
	vec1.generic[22] = (vec2.generic[22] ? (vec1.generic[22] % vec2.generic[22]) : 0);
	vec1.generic[23] = (vec2.generic[23] ? (vec1.generic[23] % vec2.generic[23]) : 0);
	vec1.generic[24] = (vec2.generic[24] ? (vec1.generic[24] % vec2.generic[24]) : 0);
	vec1.generic[25] = (vec2.generic[25] ? (vec1.generic[25] % vec2.generic[25]) : 0);
	vec1.generic[26] = (vec2.generic[26] ? (vec1.generic[26] % vec2.generic[26]) : 0);
	vec1.generic[27] = (vec2.generic[27] ? (vec1.generic[27] % vec2.generic[27]) : 0);
	vec1.generic[28] = (vec2.generic[28] ? (vec1.generic[28] % vec2.generic[28]) : 0);
	vec1.generic[29] = (vec2.generic[29] ? (vec1.generic[29] % vec2.generic[29]) : 0);
	vec1.generic[30] = (vec2.generic[30] ? (vec1.generic[30] % vec2.generic[30]) : 0);
	vec1.generic[31] = (vec2.generic[31] ? (vec1.generic[31] % vec2.generic[31]) : 0);
	return vec1;
}
# define VUINT16x32_MOD_DEFINED
#endif
#if !defined(VUINT16x32_AVG_DEFINED)
VEC_FUNC_IMPL vuint16x32 vuint16x32_avg(vuint16x32 vec1, vuint16x32 vec2)
{
vec1.generic[0] = (vec1.generic[0] >> 1) + (vec2.generic[0] >> 1) + ((vec1.generic[0] | vec2.generic[0]) & 1);
vec1.generic[1] = (vec1.generic[1] >> 1) + (vec2.generic[1] >> 1) + ((vec1.generic[1] | vec2.generic[1]) & 1);
vec1.generic[2] = (vec1.generic[2] >> 1) + (vec2.generic[2] >> 1) + ((vec1.generic[2] | vec2.generic[2]) & 1);
vec1.generic[3] = (vec1.generic[3] >> 1) + (vec2.generic[3] >> 1) + ((vec1.generic[3] | vec2.generic[3]) & 1);
vec1.generic[4] = (vec1.generic[4] >> 1) + (vec2.generic[4] >> 1) + ((vec1.generic[4] | vec2.generic[4]) & 1);
vec1.generic[5] = (vec1.generic[5] >> 1) + (vec2.generic[5] >> 1) + ((vec1.generic[5] | vec2.generic[5]) & 1);
vec1.generic[6] = (vec1.generic[6] >> 1) + (vec2.generic[6] >> 1) + ((vec1.generic[6] | vec2.generic[6]) & 1);
vec1.generic[7] = (vec1.generic[7] >> 1) + (vec2.generic[7] >> 1) + ((vec1.generic[7] | vec2.generic[7]) & 1);
vec1.generic[8] = (vec1.generic[8] >> 1) + (vec2.generic[8] >> 1) + ((vec1.generic[8] | vec2.generic[8]) & 1);
vec1.generic[9] = (vec1.generic[9] >> 1) + (vec2.generic[9] >> 1) + ((vec1.generic[9] | vec2.generic[9]) & 1);
vec1.generic[10] = (vec1.generic[10] >> 1) + (vec2.generic[10] >> 1) + ((vec1.generic[10] | vec2.generic[10]) & 1);
vec1.generic[11] = (vec1.generic[11] >> 1) + (vec2.generic[11] >> 1) + ((vec1.generic[11] | vec2.generic[11]) & 1);
vec1.generic[12] = (vec1.generic[12] >> 1) + (vec2.generic[12] >> 1) + ((vec1.generic[12] | vec2.generic[12]) & 1);
vec1.generic[13] = (vec1.generic[13] >> 1) + (vec2.generic[13] >> 1) + ((vec1.generic[13] | vec2.generic[13]) & 1);
vec1.generic[14] = (vec1.generic[14] >> 1) + (vec2.generic[14] >> 1) + ((vec1.generic[14] | vec2.generic[14]) & 1);
vec1.generic[15] = (vec1.generic[15] >> 1) + (vec2.generic[15] >> 1) + ((vec1.generic[15] | vec2.generic[15]) & 1);
vec1.generic[16] = (vec1.generic[16] >> 1) + (vec2.generic[16] >> 1) + ((vec1.generic[16] | vec2.generic[16]) & 1);
vec1.generic[17] = (vec1.generic[17] >> 1) + (vec2.generic[17] >> 1) + ((vec1.generic[17] | vec2.generic[17]) & 1);
vec1.generic[18] = (vec1.generic[18] >> 1) + (vec2.generic[18] >> 1) + ((vec1.generic[18] | vec2.generic[18]) & 1);
vec1.generic[19] = (vec1.generic[19] >> 1) + (vec2.generic[19] >> 1) + ((vec1.generic[19] | vec2.generic[19]) & 1);
vec1.generic[20] = (vec1.generic[20] >> 1) + (vec2.generic[20] >> 1) + ((vec1.generic[20] | vec2.generic[20]) & 1);
vec1.generic[21] = (vec1.generic[21] >> 1) + (vec2.generic[21] >> 1) + ((vec1.generic[21] | vec2.generic[21]) & 1);
vec1.generic[22] = (vec1.generic[22] >> 1) + (vec2.generic[22] >> 1) + ((vec1.generic[22] | vec2.generic[22]) & 1);
vec1.generic[23] = (vec1.generic[23] >> 1) + (vec2.generic[23] >> 1) + ((vec1.generic[23] | vec2.generic[23]) & 1);
vec1.generic[24] = (vec1.generic[24] >> 1) + (vec2.generic[24] >> 1) + ((vec1.generic[24] | vec2.generic[24]) & 1);
vec1.generic[25] = (vec1.generic[25] >> 1) + (vec2.generic[25] >> 1) + ((vec1.generic[25] | vec2.generic[25]) & 1);
vec1.generic[26] = (vec1.generic[26] >> 1) + (vec2.generic[26] >> 1) + ((vec1.generic[26] | vec2.generic[26]) & 1);
vec1.generic[27] = (vec1.generic[27] >> 1) + (vec2.generic[27] >> 1) + ((vec1.generic[27] | vec2.generic[27]) & 1);
vec1.generic[28] = (vec1.generic[28] >> 1) + (vec2.generic[28] >> 1) + ((vec1.generic[28] | vec2.generic[28]) & 1);
vec1.generic[29] = (vec1.generic[29] >> 1) + (vec2.generic[29] >> 1) + ((vec1.generic[29] | vec2.generic[29]) & 1);
vec1.generic[30] = (vec1.generic[30] >> 1) + (vec2.generic[30] >> 1) + ((vec1.generic[30] | vec2.generic[30]) & 1);
vec1.generic[31] = (vec1.generic[31] >> 1) + (vec2.generic[31] >> 1) + ((vec1.generic[31] | vec2.generic[31]) & 1);
	return vec1;
}
# define VUINT16x32_AVG_DEFINED
#endif
#if !defined(VUINT16x32_AND_DEFINED)
VEC_FUNC_IMPL vuint16x32 vuint16x32_and(vuint16x32 vec1, vuint16x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] & vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] & vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] & vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] & vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] & vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] & vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] & vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] & vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] & vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] & vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] & vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] & vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] & vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] & vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] & vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] & vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] & vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] & vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] & vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] & vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] & vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] & vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] & vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] & vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] & vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] & vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] & vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] & vec2.generic[31]);
	return vec1;
}
# define VUINT16x32_AND_DEFINED
#endif
#if !defined(VUINT16x32_OR_DEFINED)
VEC_FUNC_IMPL vuint16x32 vuint16x32_or(vuint16x32 vec1, vuint16x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] | vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] | vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] | vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] | vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] | vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] | vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] | vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] | vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] | vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] | vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] | vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] | vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] | vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] | vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] | vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] | vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] | vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] | vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] | vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] | vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] | vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] | vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] | vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] | vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] | vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] | vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] | vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] | vec2.generic[31]);
	return vec1;
}
# define VUINT16x32_OR_DEFINED
#endif
#if !defined(VUINT16x32_XOR_DEFINED)
VEC_FUNC_IMPL vuint16x32 vuint16x32_xor(vuint16x32 vec1, vuint16x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] ^ vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] ^ vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] ^ vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] ^ vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] ^ vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] ^ vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] ^ vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] ^ vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] ^ vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] ^ vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] ^ vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] ^ vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] ^ vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] ^ vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] ^ vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] ^ vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] ^ vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] ^ vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] ^ vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] ^ vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] ^ vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] ^ vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] ^ vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] ^ vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] ^ vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] ^ vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] ^ vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] ^ vec2.generic[31]);
	return vec1;
}
# define VUINT16x32_XOR_DEFINED
#endif
#if !defined(VUINT16x32_NOT_DEFINED)
VEC_FUNC_IMPL vuint16x32 vuint16x32_not(vuint16x32 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	vec.generic[4] = ~vec.generic[4];
	vec.generic[5] = ~vec.generic[5];
	vec.generic[6] = ~vec.generic[6];
	vec.generic[7] = ~vec.generic[7];
	vec.generic[8] = ~vec.generic[8];
	vec.generic[9] = ~vec.generic[9];
	vec.generic[10] = ~vec.generic[10];
	vec.generic[11] = ~vec.generic[11];
	vec.generic[12] = ~vec.generic[12];
	vec.generic[13] = ~vec.generic[13];
	vec.generic[14] = ~vec.generic[14];
	vec.generic[15] = ~vec.generic[15];
	vec.generic[16] = ~vec.generic[16];
	vec.generic[17] = ~vec.generic[17];
	vec.generic[18] = ~vec.generic[18];
	vec.generic[19] = ~vec.generic[19];
	vec.generic[20] = ~vec.generic[20];
	vec.generic[21] = ~vec.generic[21];
	vec.generic[22] = ~vec.generic[22];
	vec.generic[23] = ~vec.generic[23];
	vec.generic[24] = ~vec.generic[24];
	vec.generic[25] = ~vec.generic[25];
	vec.generic[26] = ~vec.generic[26];
	vec.generic[27] = ~vec.generic[27];
	vec.generic[28] = ~vec.generic[28];
	vec.generic[29] = ~vec.generic[29];
	vec.generic[30] = ~vec.generic[30];
	vec.generic[31] = ~vec.generic[31];
	return vec;
}
# define VUINT16x32_NOT_DEFINED
#endif
#if !defined(VUINT16x32_CMPLT_DEFINED)
VEC_FUNC_IMPL vuint16x32 vuint16x32_cmplt(vuint16x32 vec1, vuint16x32 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] < vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] < vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] < vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] < vec2.generic[7]) ? 0xFF : 0, 2);
	memset(&vec1.generic[8], (vec1.generic[8] < vec2.generic[8]) ? 0xFF : 0, 2);
	memset(&vec1.generic[9], (vec1.generic[9] < vec2.generic[9]) ? 0xFF : 0, 2);
	memset(&vec1.generic[10], (vec1.generic[10] < vec2.generic[10]) ? 0xFF : 0, 2);
	memset(&vec1.generic[11], (vec1.generic[11] < vec2.generic[11]) ? 0xFF : 0, 2);
	memset(&vec1.generic[12], (vec1.generic[12] < vec2.generic[12]) ? 0xFF : 0, 2);
	memset(&vec1.generic[13], (vec1.generic[13] < vec2.generic[13]) ? 0xFF : 0, 2);
	memset(&vec1.generic[14], (vec1.generic[14] < vec2.generic[14]) ? 0xFF : 0, 2);
	memset(&vec1.generic[15], (vec1.generic[15] < vec2.generic[15]) ? 0xFF : 0, 2);
	memset(&vec1.generic[16], (vec1.generic[16] < vec2.generic[16]) ? 0xFF : 0, 2);
	memset(&vec1.generic[17], (vec1.generic[17] < vec2.generic[17]) ? 0xFF : 0, 2);
	memset(&vec1.generic[18], (vec1.generic[18] < vec2.generic[18]) ? 0xFF : 0, 2);
	memset(&vec1.generic[19], (vec1.generic[19] < vec2.generic[19]) ? 0xFF : 0, 2);
	memset(&vec1.generic[20], (vec1.generic[20] < vec2.generic[20]) ? 0xFF : 0, 2);
	memset(&vec1.generic[21], (vec1.generic[21] < vec2.generic[21]) ? 0xFF : 0, 2);
	memset(&vec1.generic[22], (vec1.generic[22] < vec2.generic[22]) ? 0xFF : 0, 2);
	memset(&vec1.generic[23], (vec1.generic[23] < vec2.generic[23]) ? 0xFF : 0, 2);
	memset(&vec1.generic[24], (vec1.generic[24] < vec2.generic[24]) ? 0xFF : 0, 2);
	memset(&vec1.generic[25], (vec1.generic[25] < vec2.generic[25]) ? 0xFF : 0, 2);
	memset(&vec1.generic[26], (vec1.generic[26] < vec2.generic[26]) ? 0xFF : 0, 2);
	memset(&vec1.generic[27], (vec1.generic[27] < vec2.generic[27]) ? 0xFF : 0, 2);
	memset(&vec1.generic[28], (vec1.generic[28] < vec2.generic[28]) ? 0xFF : 0, 2);
	memset(&vec1.generic[29], (vec1.generic[29] < vec2.generic[29]) ? 0xFF : 0, 2);
	memset(&vec1.generic[30], (vec1.generic[30] < vec2.generic[30]) ? 0xFF : 0, 2);
	memset(&vec1.generic[31], (vec1.generic[31] < vec2.generic[31]) ? 0xFF : 0, 2);
	return vec1;
}
# define VUINT16x32_CMPLT_DEFINED
#endif
#if !defined(VUINT16x32_CMPEQ_DEFINED)
VEC_FUNC_IMPL vuint16x32 vuint16x32_cmpeq(vuint16x32 vec1, vuint16x32 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] == vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] == vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] == vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] == vec2.generic[7]) ? 0xFF : 0, 2);
	memset(&vec1.generic[8], (vec1.generic[8] == vec2.generic[8]) ? 0xFF : 0, 2);
	memset(&vec1.generic[9], (vec1.generic[9] == vec2.generic[9]) ? 0xFF : 0, 2);
	memset(&vec1.generic[10], (vec1.generic[10] == vec2.generic[10]) ? 0xFF : 0, 2);
	memset(&vec1.generic[11], (vec1.generic[11] == vec2.generic[11]) ? 0xFF : 0, 2);
	memset(&vec1.generic[12], (vec1.generic[12] == vec2.generic[12]) ? 0xFF : 0, 2);
	memset(&vec1.generic[13], (vec1.generic[13] == vec2.generic[13]) ? 0xFF : 0, 2);
	memset(&vec1.generic[14], (vec1.generic[14] == vec2.generic[14]) ? 0xFF : 0, 2);
	memset(&vec1.generic[15], (vec1.generic[15] == vec2.generic[15]) ? 0xFF : 0, 2);
	memset(&vec1.generic[16], (vec1.generic[16] == vec2.generic[16]) ? 0xFF : 0, 2);
	memset(&vec1.generic[17], (vec1.generic[17] == vec2.generic[17]) ? 0xFF : 0, 2);
	memset(&vec1.generic[18], (vec1.generic[18] == vec2.generic[18]) ? 0xFF : 0, 2);
	memset(&vec1.generic[19], (vec1.generic[19] == vec2.generic[19]) ? 0xFF : 0, 2);
	memset(&vec1.generic[20], (vec1.generic[20] == vec2.generic[20]) ? 0xFF : 0, 2);
	memset(&vec1.generic[21], (vec1.generic[21] == vec2.generic[21]) ? 0xFF : 0, 2);
	memset(&vec1.generic[22], (vec1.generic[22] == vec2.generic[22]) ? 0xFF : 0, 2);
	memset(&vec1.generic[23], (vec1.generic[23] == vec2.generic[23]) ? 0xFF : 0, 2);
	memset(&vec1.generic[24], (vec1.generic[24] == vec2.generic[24]) ? 0xFF : 0, 2);
	memset(&vec1.generic[25], (vec1.generic[25] == vec2.generic[25]) ? 0xFF : 0, 2);
	memset(&vec1.generic[26], (vec1.generic[26] == vec2.generic[26]) ? 0xFF : 0, 2);
	memset(&vec1.generic[27], (vec1.generic[27] == vec2.generic[27]) ? 0xFF : 0, 2);
	memset(&vec1.generic[28], (vec1.generic[28] == vec2.generic[28]) ? 0xFF : 0, 2);
	memset(&vec1.generic[29], (vec1.generic[29] == vec2.generic[29]) ? 0xFF : 0, 2);
	memset(&vec1.generic[30], (vec1.generic[30] == vec2.generic[30]) ? 0xFF : 0, 2);
	memset(&vec1.generic[31], (vec1.generic[31] == vec2.generic[31]) ? 0xFF : 0, 2);
	return vec1;
}
# define VUINT16x32_CMPEQ_DEFINED
#endif
#if !defined(VUINT16x32_CMPGT_DEFINED)
VEC_FUNC_IMPL vuint16x32 vuint16x32_cmpgt(vuint16x32 vec1, vuint16x32 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] > vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] > vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] > vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] > vec2.generic[7]) ? 0xFF : 0, 2);
	memset(&vec1.generic[8], (vec1.generic[8] > vec2.generic[8]) ? 0xFF : 0, 2);
	memset(&vec1.generic[9], (vec1.generic[9] > vec2.generic[9]) ? 0xFF : 0, 2);
	memset(&vec1.generic[10], (vec1.generic[10] > vec2.generic[10]) ? 0xFF : 0, 2);
	memset(&vec1.generic[11], (vec1.generic[11] > vec2.generic[11]) ? 0xFF : 0, 2);
	memset(&vec1.generic[12], (vec1.generic[12] > vec2.generic[12]) ? 0xFF : 0, 2);
	memset(&vec1.generic[13], (vec1.generic[13] > vec2.generic[13]) ? 0xFF : 0, 2);
	memset(&vec1.generic[14], (vec1.generic[14] > vec2.generic[14]) ? 0xFF : 0, 2);
	memset(&vec1.generic[15], (vec1.generic[15] > vec2.generic[15]) ? 0xFF : 0, 2);
	memset(&vec1.generic[16], (vec1.generic[16] > vec2.generic[16]) ? 0xFF : 0, 2);
	memset(&vec1.generic[17], (vec1.generic[17] > vec2.generic[17]) ? 0xFF : 0, 2);
	memset(&vec1.generic[18], (vec1.generic[18] > vec2.generic[18]) ? 0xFF : 0, 2);
	memset(&vec1.generic[19], (vec1.generic[19] > vec2.generic[19]) ? 0xFF : 0, 2);
	memset(&vec1.generic[20], (vec1.generic[20] > vec2.generic[20]) ? 0xFF : 0, 2);
	memset(&vec1.generic[21], (vec1.generic[21] > vec2.generic[21]) ? 0xFF : 0, 2);
	memset(&vec1.generic[22], (vec1.generic[22] > vec2.generic[22]) ? 0xFF : 0, 2);
	memset(&vec1.generic[23], (vec1.generic[23] > vec2.generic[23]) ? 0xFF : 0, 2);
	memset(&vec1.generic[24], (vec1.generic[24] > vec2.generic[24]) ? 0xFF : 0, 2);
	memset(&vec1.generic[25], (vec1.generic[25] > vec2.generic[25]) ? 0xFF : 0, 2);
	memset(&vec1.generic[26], (vec1.generic[26] > vec2.generic[26]) ? 0xFF : 0, 2);
	memset(&vec1.generic[27], (vec1.generic[27] > vec2.generic[27]) ? 0xFF : 0, 2);
	memset(&vec1.generic[28], (vec1.generic[28] > vec2.generic[28]) ? 0xFF : 0, 2);
	memset(&vec1.generic[29], (vec1.generic[29] > vec2.generic[29]) ? 0xFF : 0, 2);
	memset(&vec1.generic[30], (vec1.generic[30] > vec2.generic[30]) ? 0xFF : 0, 2);
	memset(&vec1.generic[31], (vec1.generic[31] > vec2.generic[31]) ? 0xFF : 0, 2);
	return vec1;
}
# define VUINT16x32_CMPGT_DEFINED
#endif
#if !defined(VUINT16x32_CMPLE_DEFINED)
VEC_FUNC_IMPL vuint16x32 vuint16x32_cmple(vuint16x32 vec1, vuint16x32 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] <= vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] <= vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] <= vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] <= vec2.generic[7]) ? 0xFF : 0, 2);
	memset(&vec1.generic[8], (vec1.generic[8] <= vec2.generic[8]) ? 0xFF : 0, 2);
	memset(&vec1.generic[9], (vec1.generic[9] <= vec2.generic[9]) ? 0xFF : 0, 2);
	memset(&vec1.generic[10], (vec1.generic[10] <= vec2.generic[10]) ? 0xFF : 0, 2);
	memset(&vec1.generic[11], (vec1.generic[11] <= vec2.generic[11]) ? 0xFF : 0, 2);
	memset(&vec1.generic[12], (vec1.generic[12] <= vec2.generic[12]) ? 0xFF : 0, 2);
	memset(&vec1.generic[13], (vec1.generic[13] <= vec2.generic[13]) ? 0xFF : 0, 2);
	memset(&vec1.generic[14], (vec1.generic[14] <= vec2.generic[14]) ? 0xFF : 0, 2);
	memset(&vec1.generic[15], (vec1.generic[15] <= vec2.generic[15]) ? 0xFF : 0, 2);
	memset(&vec1.generic[16], (vec1.generic[16] <= vec2.generic[16]) ? 0xFF : 0, 2);
	memset(&vec1.generic[17], (vec1.generic[17] <= vec2.generic[17]) ? 0xFF : 0, 2);
	memset(&vec1.generic[18], (vec1.generic[18] <= vec2.generic[18]) ? 0xFF : 0, 2);
	memset(&vec1.generic[19], (vec1.generic[19] <= vec2.generic[19]) ? 0xFF : 0, 2);
	memset(&vec1.generic[20], (vec1.generic[20] <= vec2.generic[20]) ? 0xFF : 0, 2);
	memset(&vec1.generic[21], (vec1.generic[21] <= vec2.generic[21]) ? 0xFF : 0, 2);
	memset(&vec1.generic[22], (vec1.generic[22] <= vec2.generic[22]) ? 0xFF : 0, 2);
	memset(&vec1.generic[23], (vec1.generic[23] <= vec2.generic[23]) ? 0xFF : 0, 2);
	memset(&vec1.generic[24], (vec1.generic[24] <= vec2.generic[24]) ? 0xFF : 0, 2);
	memset(&vec1.generic[25], (vec1.generic[25] <= vec2.generic[25]) ? 0xFF : 0, 2);
	memset(&vec1.generic[26], (vec1.generic[26] <= vec2.generic[26]) ? 0xFF : 0, 2);
	memset(&vec1.generic[27], (vec1.generic[27] <= vec2.generic[27]) ? 0xFF : 0, 2);
	memset(&vec1.generic[28], (vec1.generic[28] <= vec2.generic[28]) ? 0xFF : 0, 2);
	memset(&vec1.generic[29], (vec1.generic[29] <= vec2.generic[29]) ? 0xFF : 0, 2);
	memset(&vec1.generic[30], (vec1.generic[30] <= vec2.generic[30]) ? 0xFF : 0, 2);
	memset(&vec1.generic[31], (vec1.generic[31] <= vec2.generic[31]) ? 0xFF : 0, 2);
	return vec1;
}
# define VUINT16x32_CMPLE_DEFINED
#endif
#if !defined(VUINT16x32_CMPGE_DEFINED)
VEC_FUNC_IMPL vuint16x32 vuint16x32_cmpge(vuint16x32 vec1, vuint16x32 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 2);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 2);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 2);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 2);
	memset(&vec1.generic[4], (vec1.generic[4] >= vec2.generic[4]) ? 0xFF : 0, 2);
	memset(&vec1.generic[5], (vec1.generic[5] >= vec2.generic[5]) ? 0xFF : 0, 2);
	memset(&vec1.generic[6], (vec1.generic[6] >= vec2.generic[6]) ? 0xFF : 0, 2);
	memset(&vec1.generic[7], (vec1.generic[7] >= vec2.generic[7]) ? 0xFF : 0, 2);
	memset(&vec1.generic[8], (vec1.generic[8] >= vec2.generic[8]) ? 0xFF : 0, 2);
	memset(&vec1.generic[9], (vec1.generic[9] >= vec2.generic[9]) ? 0xFF : 0, 2);
	memset(&vec1.generic[10], (vec1.generic[10] >= vec2.generic[10]) ? 0xFF : 0, 2);
	memset(&vec1.generic[11], (vec1.generic[11] >= vec2.generic[11]) ? 0xFF : 0, 2);
	memset(&vec1.generic[12], (vec1.generic[12] >= vec2.generic[12]) ? 0xFF : 0, 2);
	memset(&vec1.generic[13], (vec1.generic[13] >= vec2.generic[13]) ? 0xFF : 0, 2);
	memset(&vec1.generic[14], (vec1.generic[14] >= vec2.generic[14]) ? 0xFF : 0, 2);
	memset(&vec1.generic[15], (vec1.generic[15] >= vec2.generic[15]) ? 0xFF : 0, 2);
	memset(&vec1.generic[16], (vec1.generic[16] >= vec2.generic[16]) ? 0xFF : 0, 2);
	memset(&vec1.generic[17], (vec1.generic[17] >= vec2.generic[17]) ? 0xFF : 0, 2);
	memset(&vec1.generic[18], (vec1.generic[18] >= vec2.generic[18]) ? 0xFF : 0, 2);
	memset(&vec1.generic[19], (vec1.generic[19] >= vec2.generic[19]) ? 0xFF : 0, 2);
	memset(&vec1.generic[20], (vec1.generic[20] >= vec2.generic[20]) ? 0xFF : 0, 2);
	memset(&vec1.generic[21], (vec1.generic[21] >= vec2.generic[21]) ? 0xFF : 0, 2);
	memset(&vec1.generic[22], (vec1.generic[22] >= vec2.generic[22]) ? 0xFF : 0, 2);
	memset(&vec1.generic[23], (vec1.generic[23] >= vec2.generic[23]) ? 0xFF : 0, 2);
	memset(&vec1.generic[24], (vec1.generic[24] >= vec2.generic[24]) ? 0xFF : 0, 2);
	memset(&vec1.generic[25], (vec1.generic[25] >= vec2.generic[25]) ? 0xFF : 0, 2);
	memset(&vec1.generic[26], (vec1.generic[26] >= vec2.generic[26]) ? 0xFF : 0, 2);
	memset(&vec1.generic[27], (vec1.generic[27] >= vec2.generic[27]) ? 0xFF : 0, 2);
	memset(&vec1.generic[28], (vec1.generic[28] >= vec2.generic[28]) ? 0xFF : 0, 2);
	memset(&vec1.generic[29], (vec1.generic[29] >= vec2.generic[29]) ? 0xFF : 0, 2);
	memset(&vec1.generic[30], (vec1.generic[30] >= vec2.generic[30]) ? 0xFF : 0, 2);
	memset(&vec1.generic[31], (vec1.generic[31] >= vec2.generic[31]) ? 0xFF : 0, 2);
	return vec1;
}
# define VUINT16x32_CMPGE_DEFINED
#endif
#if !defined(VUINT16x32_MIN_DEFINED)
VEC_FUNC_IMPL vuint16x32 vuint16x32_min(vuint16x32 vec1, vuint16x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] < vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] < vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] < vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] < vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] < vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] < vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] < vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] < vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] < vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] < vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] < vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] < vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] < vec2.generic[16]) ? (vec1.generic[16]) : (vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] < vec2.generic[17]) ? (vec1.generic[17]) : (vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] < vec2.generic[18]) ? (vec1.generic[18]) : (vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] < vec2.generic[19]) ? (vec1.generic[19]) : (vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] < vec2.generic[20]) ? (vec1.generic[20]) : (vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] < vec2.generic[21]) ? (vec1.generic[21]) : (vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] < vec2.generic[22]) ? (vec1.generic[22]) : (vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] < vec2.generic[23]) ? (vec1.generic[23]) : (vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] < vec2.generic[24]) ? (vec1.generic[24]) : (vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] < vec2.generic[25]) ? (vec1.generic[25]) : (vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] < vec2.generic[26]) ? (vec1.generic[26]) : (vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] < vec2.generic[27]) ? (vec1.generic[27]) : (vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] < vec2.generic[28]) ? (vec1.generic[28]) : (vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] < vec2.generic[29]) ? (vec1.generic[29]) : (vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] < vec2.generic[30]) ? (vec1.generic[30]) : (vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] < vec2.generic[31]) ? (vec1.generic[31]) : (vec2.generic[31]);
	return vec1;
}
# define VUINT16x32_MIN_DEFINED
#endif
#if !defined(VUINT16x32_MAX_DEFINED)
VEC_FUNC_IMPL vuint16x32 vuint16x32_max(vuint16x32 vec1, vuint16x32 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] > vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] > vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] > vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] > vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] > vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] > vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] > vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] > vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] > vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] > vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] > vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] > vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	vec1.generic[16] = (vec1.generic[16] > vec2.generic[16]) ? (vec1.generic[16]) : (vec2.generic[16]);
	vec1.generic[17] = (vec1.generic[17] > vec2.generic[17]) ? (vec1.generic[17]) : (vec2.generic[17]);
	vec1.generic[18] = (vec1.generic[18] > vec2.generic[18]) ? (vec1.generic[18]) : (vec2.generic[18]);
	vec1.generic[19] = (vec1.generic[19] > vec2.generic[19]) ? (vec1.generic[19]) : (vec2.generic[19]);
	vec1.generic[20] = (vec1.generic[20] > vec2.generic[20]) ? (vec1.generic[20]) : (vec2.generic[20]);
	vec1.generic[21] = (vec1.generic[21] > vec2.generic[21]) ? (vec1.generic[21]) : (vec2.generic[21]);
	vec1.generic[22] = (vec1.generic[22] > vec2.generic[22]) ? (vec1.generic[22]) : (vec2.generic[22]);
	vec1.generic[23] = (vec1.generic[23] > vec2.generic[23]) ? (vec1.generic[23]) : (vec2.generic[23]);
	vec1.generic[24] = (vec1.generic[24] > vec2.generic[24]) ? (vec1.generic[24]) : (vec2.generic[24]);
	vec1.generic[25] = (vec1.generic[25] > vec2.generic[25]) ? (vec1.generic[25]) : (vec2.generic[25]);
	vec1.generic[26] = (vec1.generic[26] > vec2.generic[26]) ? (vec1.generic[26]) : (vec2.generic[26]);
	vec1.generic[27] = (vec1.generic[27] > vec2.generic[27]) ? (vec1.generic[27]) : (vec2.generic[27]);
	vec1.generic[28] = (vec1.generic[28] > vec2.generic[28]) ? (vec1.generic[28]) : (vec2.generic[28]);
	vec1.generic[29] = (vec1.generic[29] > vec2.generic[29]) ? (vec1.generic[29]) : (vec2.generic[29]);
	vec1.generic[30] = (vec1.generic[30] > vec2.generic[30]) ? (vec1.generic[30]) : (vec2.generic[30]);
	vec1.generic[31] = (vec1.generic[31] > vec2.generic[31]) ? (vec1.generic[31]) : (vec2.generic[31]);
	return vec1;
}
# define VUINT16x32_MAX_DEFINED
#endif
#if !defined(VUINT16x32_RSHIFT_DEFINED)
VEC_FUNC_IMPL vuint16x32 vuint16x32_rshift(vuint16x32 vec1, vuint16x32 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	vec1.generic[4] >>= vec2.generic[0];
	vec1.generic[5] >>= vec2.generic[0];
	vec1.generic[6] >>= vec2.generic[0];
	vec1.generic[7] >>= vec2.generic[0];
	vec1.generic[8] >>= vec2.generic[0];
	vec1.generic[9] >>= vec2.generic[0];
	vec1.generic[10] >>= vec2.generic[0];
	vec1.generic[11] >>= vec2.generic[0];
	vec1.generic[12] >>= vec2.generic[0];
	vec1.generic[13] >>= vec2.generic[0];
	vec1.generic[14] >>= vec2.generic[0];
	vec1.generic[15] >>= vec2.generic[0];
	vec1.generic[16] >>= vec2.generic[0];
	vec1.generic[17] >>= vec2.generic[0];
	vec1.generic[18] >>= vec2.generic[0];
	vec1.generic[19] >>= vec2.generic[0];
	vec1.generic[20] >>= vec2.generic[0];
	vec1.generic[21] >>= vec2.generic[0];
	vec1.generic[22] >>= vec2.generic[0];
	vec1.generic[23] >>= vec2.generic[0];
	vec1.generic[24] >>= vec2.generic[0];
	vec1.generic[25] >>= vec2.generic[0];
	vec1.generic[26] >>= vec2.generic[0];
	vec1.generic[27] >>= vec2.generic[0];
	vec1.generic[28] >>= vec2.generic[0];
	vec1.generic[29] >>= vec2.generic[0];
	vec1.generic[30] >>= vec2.generic[0];
	vec1.generic[31] >>= vec2.generic[0];
	return vec1;
}
# define VUINT16x32_RSHIFT_DEFINED
#endif
#if !defined(VUINT16x32_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vuint16x32 vuint16x32_lrshift(vuint16x32 vec1, vuint16x32 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	vec1.generic[4] >>= vec2.generic[0];
	vec1.generic[5] >>= vec2.generic[0];
	vec1.generic[6] >>= vec2.generic[0];
	vec1.generic[7] >>= vec2.generic[0];
	vec1.generic[8] >>= vec2.generic[0];
	vec1.generic[9] >>= vec2.generic[0];
	vec1.generic[10] >>= vec2.generic[0];
	vec1.generic[11] >>= vec2.generic[0];
	vec1.generic[12] >>= vec2.generic[0];
	vec1.generic[13] >>= vec2.generic[0];
	vec1.generic[14] >>= vec2.generic[0];
	vec1.generic[15] >>= vec2.generic[0];
	vec1.generic[16] >>= vec2.generic[0];
	vec1.generic[17] >>= vec2.generic[0];
	vec1.generic[18] >>= vec2.generic[0];
	vec1.generic[19] >>= vec2.generic[0];
	vec1.generic[20] >>= vec2.generic[0];
	vec1.generic[21] >>= vec2.generic[0];
	vec1.generic[22] >>= vec2.generic[0];
	vec1.generic[23] >>= vec2.generic[0];
	vec1.generic[24] >>= vec2.generic[0];
	vec1.generic[25] >>= vec2.generic[0];
	vec1.generic[26] >>= vec2.generic[0];
	vec1.generic[27] >>= vec2.generic[0];
	vec1.generic[28] >>= vec2.generic[0];
	vec1.generic[29] >>= vec2.generic[0];
	vec1.generic[30] >>= vec2.generic[0];
	vec1.generic[31] >>= vec2.generic[0];
	return vec1;
}
# define VUINT16x32_LRSHIFT_DEFINED
#endif
#if !defined(VUINT16x32_LSHIFT_DEFINED)
VEC_FUNC_IMPL vuint16x32 vuint16x32_lshift(vuint16x32 vec1, vuint16x32 vec2)
{
	vec1.generic[0] <<= vec2.generic[0];
	vec1.generic[1] <<= vec2.generic[0];
	vec1.generic[2] <<= vec2.generic[0];
	vec1.generic[3] <<= vec2.generic[0];
	vec1.generic[4] <<= vec2.generic[0];
	vec1.generic[5] <<= vec2.generic[0];
	vec1.generic[6] <<= vec2.generic[0];
	vec1.generic[7] <<= vec2.generic[0];
	vec1.generic[8] <<= vec2.generic[0];
	vec1.generic[9] <<= vec2.generic[0];
	vec1.generic[10] <<= vec2.generic[0];
	vec1.generic[11] <<= vec2.generic[0];
	vec1.generic[12] <<= vec2.generic[0];
	vec1.generic[13] <<= vec2.generic[0];
	vec1.generic[14] <<= vec2.generic[0];
	vec1.generic[15] <<= vec2.generic[0];
	vec1.generic[16] <<= vec2.generic[0];
	vec1.generic[17] <<= vec2.generic[0];
	vec1.generic[18] <<= vec2.generic[0];
	vec1.generic[19] <<= vec2.generic[0];
	vec1.generic[20] <<= vec2.generic[0];
	vec1.generic[21] <<= vec2.generic[0];
	vec1.generic[22] <<= vec2.generic[0];
	vec1.generic[23] <<= vec2.generic[0];
	vec1.generic[24] <<= vec2.generic[0];
	vec1.generic[25] <<= vec2.generic[0];
	vec1.generic[26] <<= vec2.generic[0];
	vec1.generic[27] <<= vec2.generic[0];
	vec1.generic[28] <<= vec2.generic[0];
	vec1.generic[29] <<= vec2.generic[0];
	vec1.generic[30] <<= vec2.generic[0];
	vec1.generic[31] <<= vec2.generic[0];
	return vec1;
}
# define VUINT16x32_LSHIFT_DEFINED
#endif
#if !defined(VINT32x2_SPLAT_DEFINED)
VEC_FUNC_IMPL vint32x2 vint32x2_splat(vec_int32 x)
{
	vint32x2 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	return vec;
}
# define VINT32x2_SPLAT_DEFINED
#endif
#if !defined(VINT32x2_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vint32x2 vint32x2_load_aligned(const vec_int32 x[2])
{
	vint32x2 vec;
	memcpy(vec.generic, x, 8);
	return vec;
}
# define VINT32x2_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VINT32x2_LOAD_DEFINED)
VEC_FUNC_IMPL vint32x2 vint32x2_load(const vec_int32 x[2])
{
	vint32x2 vec;
	memcpy(vec.generic, x, 8);
	return vec;
}
# define VINT32x2_LOAD_DEFINED
#endif
#if !defined(VINT32x2_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vint32x2_store_aligned(vint32x2 vec, vec_int32 x[2])
{
	memcpy(x, vec.generic, 8);
}
# define VINT32x2_STORE_ALIGNED_DEFINED
#endif
#if !defined(VINT32x2_STORE_DEFINED)
VEC_FUNC_IMPL void vint32x2_store(vint32x2 vec, vec_int32 x[2])
{
	memcpy(x, vec.generic, 8);
}
# define VINT32x2_STORE_DEFINED
#endif
#if !defined(VINT32x2_ADD_DEFINED)
VEC_FUNC_IMPL vint32x2 vint32x2_add(vint32x2 vec1, vint32x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	return vec1;
}
# define VINT32x2_ADD_DEFINED
#endif
#if !defined(VINT32x2_SUB_DEFINED)
VEC_FUNC_IMPL vint32x2 vint32x2_sub(vint32x2 vec1, vint32x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	return vec1;
}
# define VINT32x2_SUB_DEFINED
#endif
#if !defined(VINT32x2_MUL_DEFINED)
VEC_FUNC_IMPL vint32x2 vint32x2_mul(vint32x2 vec1, vint32x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	return vec1;
}
# define VINT32x2_MUL_DEFINED
#endif
#if !defined(VINT32x2_DIV_DEFINED)
VEC_FUNC_IMPL vint32x2 vint32x2_div(vint32x2 vec1, vint32x2 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	return vec1;
}
# define VINT32x2_DIV_DEFINED
#endif
#if !defined(VINT32x2_MOD_DEFINED)
VEC_FUNC_IMPL vint32x2 vint32x2_mod(vint32x2 vec1, vint32x2 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	return vec1;
}
# define VINT32x2_MOD_DEFINED
#endif
#if !defined(VINT32x2_AVG_DEFINED)
VEC_FUNC_IMPL vint32x2 vint32x2_avg(vint32x2 vec1, vint32x2 vec2)
{
	vec_int32 x_d_rem, y_d_rem, rem_d_quot, rem_d_rem;
	x_d_rem = (vec1.generic[0] % 2);
	y_d_rem = (vec2.generic[0] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[0] = ((vec1.generic[0] / 2) + (vec2.generic[0] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[1] % 2);
	y_d_rem = (vec2.generic[1] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[1] = ((vec1.generic[1] / 2) + (vec2.generic[1] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	return vec1;
}
# define VINT32x2_AVG_DEFINED
#endif
#if !defined(VINT32x2_AND_DEFINED)
VEC_FUNC_IMPL vint32x2 vint32x2_and(vint32x2 vec1, vint32x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	return vec1;
}
# define VINT32x2_AND_DEFINED
#endif
#if !defined(VINT32x2_OR_DEFINED)
VEC_FUNC_IMPL vint32x2 vint32x2_or(vint32x2 vec1, vint32x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	return vec1;
}
# define VINT32x2_OR_DEFINED
#endif
#if !defined(VINT32x2_XOR_DEFINED)
VEC_FUNC_IMPL vint32x2 vint32x2_xor(vint32x2 vec1, vint32x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	return vec1;
}
# define VINT32x2_XOR_DEFINED
#endif
#if !defined(VINT32x2_NOT_DEFINED)
VEC_FUNC_IMPL vint32x2 vint32x2_not(vint32x2 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	return vec;
}
# define VINT32x2_NOT_DEFINED
#endif
#if !defined(VINT32x2_CMPLT_DEFINED)
VEC_FUNC_IMPL vint32x2 vint32x2_cmplt(vint32x2 vec1, vint32x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 4);
	return vec1;
}
# define VINT32x2_CMPLT_DEFINED
#endif
#if !defined(VINT32x2_CMPEQ_DEFINED)
VEC_FUNC_IMPL vint32x2 vint32x2_cmpeq(vint32x2 vec1, vint32x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 4);
	return vec1;
}
# define VINT32x2_CMPEQ_DEFINED
#endif
#if !defined(VINT32x2_CMPGT_DEFINED)
VEC_FUNC_IMPL vint32x2 vint32x2_cmpgt(vint32x2 vec1, vint32x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 4);
	return vec1;
}
# define VINT32x2_CMPGT_DEFINED
#endif
#if !defined(VINT32x2_CMPLE_DEFINED)
VEC_FUNC_IMPL vint32x2 vint32x2_cmple(vint32x2 vec1, vint32x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 4);
	return vec1;
}
# define VINT32x2_CMPLE_DEFINED
#endif
#if !defined(VINT32x2_CMPGE_DEFINED)
VEC_FUNC_IMPL vint32x2 vint32x2_cmpge(vint32x2 vec1, vint32x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 4);
	return vec1;
}
# define VINT32x2_CMPGE_DEFINED
#endif
#if !defined(VINT32x2_MIN_DEFINED)
VEC_FUNC_IMPL vint32x2 vint32x2_min(vint32x2 vec1, vint32x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	return vec1;
}
# define VINT32x2_MIN_DEFINED
#endif
#if !defined(VINT32x2_MAX_DEFINED)
VEC_FUNC_IMPL vint32x2 vint32x2_max(vint32x2 vec1, vint32x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	return vec1;
}
# define VINT32x2_MAX_DEFINED
#endif
#if !defined(VINT32x2_RSHIFT_DEFINED)
VEC_FUNC_IMPL vint32x2 vint32x2_rshift(vint32x2 vec1, vuint32x2 vec2)
{
vec1.generic[0] = ((~vec1.generic[0]) >> vec2.generic[0]);
vec1.generic[1] = ((~vec1.generic[1]) >> vec2.generic[1]);
	return vec1;
}
# define VINT32x2_RSHIFT_DEFINED
#endif
#if !defined(VINT32x2_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vint32x2 vint32x2_lrshift(vint32x2 vec1, vuint32x2 vec2)
{
	union { vec_uint32 u; vec_int32 s; } x;

	x.s = vec1.generic[0];
	x.u >>= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u >>= vec2.generic[1];
	vec1.generic[1] = x.s;
	return vec1;
}
# define VINT32x2_LRSHIFT_DEFINED
#endif
#if !defined(VINT32x2_LSHIFT_DEFINED)
VEC_FUNC_IMPL vint32x2 vint32x2_lshift(vint32x2 vec1, vuint32x2 vec2)
{
	union { vec_uint32 u; vec_int32 s; } x;

	x.s = vec1.generic[0];
	x.u <<= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u <<= vec2.generic[1];
	vec1.generic[1] = x.s;
	return vec1;
}
# define VINT32x2_LSHIFT_DEFINED
#endif
#if !defined(VUINT32x2_SPLAT_DEFINED)
VEC_FUNC_IMPL vuint32x2 vuint32x2_splat(vec_uint32 x)
{
	vuint32x2 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	return vec;
}
# define VUINT32x2_SPLAT_DEFINED
#endif
#if !defined(VUINT32x2_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vuint32x2 vuint32x2_load_aligned(const vec_uint32 x[2])
{
	vuint32x2 vec;
	memcpy(vec.generic, x, 8);
	return vec;
}
# define VUINT32x2_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VUINT32x2_LOAD_DEFINED)
VEC_FUNC_IMPL vuint32x2 vuint32x2_load(const vec_uint32 x[2])
{
	vuint32x2 vec;
	memcpy(vec.generic, x, 8);
	return vec;
}
# define VUINT32x2_LOAD_DEFINED
#endif
#if !defined(VUINT32x2_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vuint32x2_store_aligned(vuint32x2 vec, vec_uint32 x[2])
{
	memcpy(x, vec.generic, 8);
}
# define VUINT32x2_STORE_ALIGNED_DEFINED
#endif
#if !defined(VUINT32x2_STORE_DEFINED)
VEC_FUNC_IMPL void vuint32x2_store(vuint32x2 vec, vec_uint32 x[2])
{
	memcpy(x, vec.generic, 8);
}
# define VUINT32x2_STORE_DEFINED
#endif
#if !defined(VUINT32x2_ADD_DEFINED)
VEC_FUNC_IMPL vuint32x2 vuint32x2_add(vuint32x2 vec1, vuint32x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	return vec1;
}
# define VUINT32x2_ADD_DEFINED
#endif
#if !defined(VUINT32x2_SUB_DEFINED)
VEC_FUNC_IMPL vuint32x2 vuint32x2_sub(vuint32x2 vec1, vuint32x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	return vec1;
}
# define VUINT32x2_SUB_DEFINED
#endif
#if !defined(VUINT32x2_MUL_DEFINED)
VEC_FUNC_IMPL vuint32x2 vuint32x2_mul(vuint32x2 vec1, vuint32x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	return vec1;
}
# define VUINT32x2_MUL_DEFINED
#endif
#if !defined(VUINT32x2_DIV_DEFINED)
VEC_FUNC_IMPL vuint32x2 vuint32x2_div(vuint32x2 vec1, vuint32x2 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	return vec1;
}
# define VUINT32x2_DIV_DEFINED
#endif
#if !defined(VUINT32x2_MOD_DEFINED)
VEC_FUNC_IMPL vuint32x2 vuint32x2_mod(vuint32x2 vec1, vuint32x2 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	return vec1;
}
# define VUINT32x2_MOD_DEFINED
#endif
#if !defined(VUINT32x2_AVG_DEFINED)
VEC_FUNC_IMPL vuint32x2 vuint32x2_avg(vuint32x2 vec1, vuint32x2 vec2)
{
vec1.generic[0] = (vec1.generic[0] >> 1) + (vec2.generic[0] >> 1) + ((vec1.generic[0] | vec2.generic[0]) & 1);
vec1.generic[1] = (vec1.generic[1] >> 1) + (vec2.generic[1] >> 1) + ((vec1.generic[1] | vec2.generic[1]) & 1);
	return vec1;
}
# define VUINT32x2_AVG_DEFINED
#endif
#if !defined(VUINT32x2_AND_DEFINED)
VEC_FUNC_IMPL vuint32x2 vuint32x2_and(vuint32x2 vec1, vuint32x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	return vec1;
}
# define VUINT32x2_AND_DEFINED
#endif
#if !defined(VUINT32x2_OR_DEFINED)
VEC_FUNC_IMPL vuint32x2 vuint32x2_or(vuint32x2 vec1, vuint32x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	return vec1;
}
# define VUINT32x2_OR_DEFINED
#endif
#if !defined(VUINT32x2_XOR_DEFINED)
VEC_FUNC_IMPL vuint32x2 vuint32x2_xor(vuint32x2 vec1, vuint32x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	return vec1;
}
# define VUINT32x2_XOR_DEFINED
#endif
#if !defined(VUINT32x2_NOT_DEFINED)
VEC_FUNC_IMPL vuint32x2 vuint32x2_not(vuint32x2 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	return vec;
}
# define VUINT32x2_NOT_DEFINED
#endif
#if !defined(VUINT32x2_CMPLT_DEFINED)
VEC_FUNC_IMPL vuint32x2 vuint32x2_cmplt(vuint32x2 vec1, vuint32x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 4);
	return vec1;
}
# define VUINT32x2_CMPLT_DEFINED
#endif
#if !defined(VUINT32x2_CMPEQ_DEFINED)
VEC_FUNC_IMPL vuint32x2 vuint32x2_cmpeq(vuint32x2 vec1, vuint32x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 4);
	return vec1;
}
# define VUINT32x2_CMPEQ_DEFINED
#endif
#if !defined(VUINT32x2_CMPGT_DEFINED)
VEC_FUNC_IMPL vuint32x2 vuint32x2_cmpgt(vuint32x2 vec1, vuint32x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 4);
	return vec1;
}
# define VUINT32x2_CMPGT_DEFINED
#endif
#if !defined(VUINT32x2_CMPLE_DEFINED)
VEC_FUNC_IMPL vuint32x2 vuint32x2_cmple(vuint32x2 vec1, vuint32x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 4);
	return vec1;
}
# define VUINT32x2_CMPLE_DEFINED
#endif
#if !defined(VUINT32x2_CMPGE_DEFINED)
VEC_FUNC_IMPL vuint32x2 vuint32x2_cmpge(vuint32x2 vec1, vuint32x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 4);
	return vec1;
}
# define VUINT32x2_CMPGE_DEFINED
#endif
#if !defined(VUINT32x2_MIN_DEFINED)
VEC_FUNC_IMPL vuint32x2 vuint32x2_min(vuint32x2 vec1, vuint32x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	return vec1;
}
# define VUINT32x2_MIN_DEFINED
#endif
#if !defined(VUINT32x2_MAX_DEFINED)
VEC_FUNC_IMPL vuint32x2 vuint32x2_max(vuint32x2 vec1, vuint32x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	return vec1;
}
# define VUINT32x2_MAX_DEFINED
#endif
#if !defined(VUINT32x2_RSHIFT_DEFINED)
VEC_FUNC_IMPL vuint32x2 vuint32x2_rshift(vuint32x2 vec1, vuint32x2 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	return vec1;
}
# define VUINT32x2_RSHIFT_DEFINED
#endif
#if !defined(VUINT32x2_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vuint32x2 vuint32x2_lrshift(vuint32x2 vec1, vuint32x2 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	return vec1;
}
# define VUINT32x2_LRSHIFT_DEFINED
#endif
#if !defined(VUINT32x2_LSHIFT_DEFINED)
VEC_FUNC_IMPL vuint32x2 vuint32x2_lshift(vuint32x2 vec1, vuint32x2 vec2)
{
	vec1.generic[0] <<= vec2.generic[0];
	vec1.generic[1] <<= vec2.generic[0];
	return vec1;
}
# define VUINT32x2_LSHIFT_DEFINED
#endif
#if !defined(VINT32x4_SPLAT_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_splat(vec_int32 x)
{
	vint32x4 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	return vec;
}
# define VINT32x4_SPLAT_DEFINED
#endif
#if !defined(VINT32x4_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_load_aligned(const vec_int32 x[4])
{
	vint32x4 vec;
	memcpy(vec.generic, x, 16);
	return vec;
}
# define VINT32x4_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VINT32x4_LOAD_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_load(const vec_int32 x[4])
{
	vint32x4 vec;
	memcpy(vec.generic, x, 16);
	return vec;
}
# define VINT32x4_LOAD_DEFINED
#endif
#if !defined(VINT32x4_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vint32x4_store_aligned(vint32x4 vec, vec_int32 x[4])
{
	memcpy(x, vec.generic, 16);
}
# define VINT32x4_STORE_ALIGNED_DEFINED
#endif
#if !defined(VINT32x4_STORE_DEFINED)
VEC_FUNC_IMPL void vint32x4_store(vint32x4 vec, vec_int32 x[4])
{
	memcpy(x, vec.generic, 16);
}
# define VINT32x4_STORE_DEFINED
#endif
#if !defined(VINT32x4_ADD_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_add(vint32x4 vec1, vint32x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	return vec1;
}
# define VINT32x4_ADD_DEFINED
#endif
#if !defined(VINT32x4_SUB_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_sub(vint32x4 vec1, vint32x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	return vec1;
}
# define VINT32x4_SUB_DEFINED
#endif
#if !defined(VINT32x4_MUL_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_mul(vint32x4 vec1, vint32x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	return vec1;
}
# define VINT32x4_MUL_DEFINED
#endif
#if !defined(VINT32x4_DIV_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_div(vint32x4 vec1, vint32x4 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	return vec1;
}
# define VINT32x4_DIV_DEFINED
#endif
#if !defined(VINT32x4_MOD_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_mod(vint32x4 vec1, vint32x4 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	return vec1;
}
# define VINT32x4_MOD_DEFINED
#endif
#if !defined(VINT32x4_AVG_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_avg(vint32x4 vec1, vint32x4 vec2)
{
	vec_int32 x_d_rem, y_d_rem, rem_d_quot, rem_d_rem;
	x_d_rem = (vec1.generic[0] % 2);
	y_d_rem = (vec2.generic[0] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[0] = ((vec1.generic[0] / 2) + (vec2.generic[0] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[1] % 2);
	y_d_rem = (vec2.generic[1] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[1] = ((vec1.generic[1] / 2) + (vec2.generic[1] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[2] % 2);
	y_d_rem = (vec2.generic[2] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[2] = ((vec1.generic[2] / 2) + (vec2.generic[2] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[3] % 2);
	y_d_rem = (vec2.generic[3] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[3] = ((vec1.generic[3] / 2) + (vec2.generic[3] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	return vec1;
}
# define VINT32x4_AVG_DEFINED
#endif
#if !defined(VINT32x4_AND_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_and(vint32x4 vec1, vint32x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	return vec1;
}
# define VINT32x4_AND_DEFINED
#endif
#if !defined(VINT32x4_OR_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_or(vint32x4 vec1, vint32x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	return vec1;
}
# define VINT32x4_OR_DEFINED
#endif
#if !defined(VINT32x4_XOR_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_xor(vint32x4 vec1, vint32x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	return vec1;
}
# define VINT32x4_XOR_DEFINED
#endif
#if !defined(VINT32x4_NOT_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_not(vint32x4 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	return vec;
}
# define VINT32x4_NOT_DEFINED
#endif
#if !defined(VINT32x4_CMPLT_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_cmplt(vint32x4 vec1, vint32x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 4);
	return vec1;
}
# define VINT32x4_CMPLT_DEFINED
#endif
#if !defined(VINT32x4_CMPEQ_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_cmpeq(vint32x4 vec1, vint32x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 4);
	return vec1;
}
# define VINT32x4_CMPEQ_DEFINED
#endif
#if !defined(VINT32x4_CMPGT_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_cmpgt(vint32x4 vec1, vint32x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 4);
	return vec1;
}
# define VINT32x4_CMPGT_DEFINED
#endif
#if !defined(VINT32x4_CMPLE_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_cmple(vint32x4 vec1, vint32x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 4);
	return vec1;
}
# define VINT32x4_CMPLE_DEFINED
#endif
#if !defined(VINT32x4_CMPGE_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_cmpge(vint32x4 vec1, vint32x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 4);
	return vec1;
}
# define VINT32x4_CMPGE_DEFINED
#endif
#if !defined(VINT32x4_MIN_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_min(vint32x4 vec1, vint32x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	return vec1;
}
# define VINT32x4_MIN_DEFINED
#endif
#if !defined(VINT32x4_MAX_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_max(vint32x4 vec1, vint32x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	return vec1;
}
# define VINT32x4_MAX_DEFINED
#endif
#if !defined(VINT32x4_RSHIFT_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_rshift(vint32x4 vec1, vuint32x4 vec2)
{
vec1.generic[0] = ((~vec1.generic[0]) >> vec2.generic[0]);
vec1.generic[1] = ((~vec1.generic[1]) >> vec2.generic[1]);
vec1.generic[2] = ((~vec1.generic[2]) >> vec2.generic[2]);
vec1.generic[3] = ((~vec1.generic[3]) >> vec2.generic[3]);
	return vec1;
}
# define VINT32x4_RSHIFT_DEFINED
#endif
#if !defined(VINT32x4_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_lrshift(vint32x4 vec1, vuint32x4 vec2)
{
	union { vec_uint32 u; vec_int32 s; } x;

	x.s = vec1.generic[0];
	x.u >>= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u >>= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u >>= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u >>= vec2.generic[3];
	vec1.generic[3] = x.s;
	return vec1;
}
# define VINT32x4_LRSHIFT_DEFINED
#endif
#if !defined(VINT32x4_LSHIFT_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_lshift(vint32x4 vec1, vuint32x4 vec2)
{
	union { vec_uint32 u; vec_int32 s; } x;

	x.s = vec1.generic[0];
	x.u <<= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u <<= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u <<= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u <<= vec2.generic[3];
	vec1.generic[3] = x.s;
	return vec1;
}
# define VINT32x4_LSHIFT_DEFINED
#endif
#if !defined(VUINT32x4_SPLAT_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_splat(vec_uint32 x)
{
	vuint32x4 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	return vec;
}
# define VUINT32x4_SPLAT_DEFINED
#endif
#if !defined(VUINT32x4_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_load_aligned(const vec_uint32 x[4])
{
	vuint32x4 vec;
	memcpy(vec.generic, x, 16);
	return vec;
}
# define VUINT32x4_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VUINT32x4_LOAD_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_load(const vec_uint32 x[4])
{
	vuint32x4 vec;
	memcpy(vec.generic, x, 16);
	return vec;
}
# define VUINT32x4_LOAD_DEFINED
#endif
#if !defined(VUINT32x4_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vuint32x4_store_aligned(vuint32x4 vec, vec_uint32 x[4])
{
	memcpy(x, vec.generic, 16);
}
# define VUINT32x4_STORE_ALIGNED_DEFINED
#endif
#if !defined(VUINT32x4_STORE_DEFINED)
VEC_FUNC_IMPL void vuint32x4_store(vuint32x4 vec, vec_uint32 x[4])
{
	memcpy(x, vec.generic, 16);
}
# define VUINT32x4_STORE_DEFINED
#endif
#if !defined(VUINT32x4_ADD_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_add(vuint32x4 vec1, vuint32x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	return vec1;
}
# define VUINT32x4_ADD_DEFINED
#endif
#if !defined(VUINT32x4_SUB_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_sub(vuint32x4 vec1, vuint32x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	return vec1;
}
# define VUINT32x4_SUB_DEFINED
#endif
#if !defined(VUINT32x4_MUL_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_mul(vuint32x4 vec1, vuint32x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	return vec1;
}
# define VUINT32x4_MUL_DEFINED
#endif
#if !defined(VUINT32x4_DIV_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_div(vuint32x4 vec1, vuint32x4 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	return vec1;
}
# define VUINT32x4_DIV_DEFINED
#endif
#if !defined(VUINT32x4_MOD_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_mod(vuint32x4 vec1, vuint32x4 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	return vec1;
}
# define VUINT32x4_MOD_DEFINED
#endif
#if !defined(VUINT32x4_AVG_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_avg(vuint32x4 vec1, vuint32x4 vec2)
{
vec1.generic[0] = (vec1.generic[0] >> 1) + (vec2.generic[0] >> 1) + ((vec1.generic[0] | vec2.generic[0]) & 1);
vec1.generic[1] = (vec1.generic[1] >> 1) + (vec2.generic[1] >> 1) + ((vec1.generic[1] | vec2.generic[1]) & 1);
vec1.generic[2] = (vec1.generic[2] >> 1) + (vec2.generic[2] >> 1) + ((vec1.generic[2] | vec2.generic[2]) & 1);
vec1.generic[3] = (vec1.generic[3] >> 1) + (vec2.generic[3] >> 1) + ((vec1.generic[3] | vec2.generic[3]) & 1);
	return vec1;
}
# define VUINT32x4_AVG_DEFINED
#endif
#if !defined(VUINT32x4_AND_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_and(vuint32x4 vec1, vuint32x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	return vec1;
}
# define VUINT32x4_AND_DEFINED
#endif
#if !defined(VUINT32x4_OR_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_or(vuint32x4 vec1, vuint32x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	return vec1;
}
# define VUINT32x4_OR_DEFINED
#endif
#if !defined(VUINT32x4_XOR_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_xor(vuint32x4 vec1, vuint32x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	return vec1;
}
# define VUINT32x4_XOR_DEFINED
#endif
#if !defined(VUINT32x4_NOT_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_not(vuint32x4 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	return vec;
}
# define VUINT32x4_NOT_DEFINED
#endif
#if !defined(VUINT32x4_CMPLT_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_cmplt(vuint32x4 vec1, vuint32x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 4);
	return vec1;
}
# define VUINT32x4_CMPLT_DEFINED
#endif
#if !defined(VUINT32x4_CMPEQ_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_cmpeq(vuint32x4 vec1, vuint32x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 4);
	return vec1;
}
# define VUINT32x4_CMPEQ_DEFINED
#endif
#if !defined(VUINT32x4_CMPGT_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_cmpgt(vuint32x4 vec1, vuint32x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 4);
	return vec1;
}
# define VUINT32x4_CMPGT_DEFINED
#endif
#if !defined(VUINT32x4_CMPLE_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_cmple(vuint32x4 vec1, vuint32x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 4);
	return vec1;
}
# define VUINT32x4_CMPLE_DEFINED
#endif
#if !defined(VUINT32x4_CMPGE_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_cmpge(vuint32x4 vec1, vuint32x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 4);
	return vec1;
}
# define VUINT32x4_CMPGE_DEFINED
#endif
#if !defined(VUINT32x4_MIN_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_min(vuint32x4 vec1, vuint32x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	return vec1;
}
# define VUINT32x4_MIN_DEFINED
#endif
#if !defined(VUINT32x4_MAX_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_max(vuint32x4 vec1, vuint32x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	return vec1;
}
# define VUINT32x4_MAX_DEFINED
#endif
#if !defined(VUINT32x4_RSHIFT_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_rshift(vuint32x4 vec1, vuint32x4 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	return vec1;
}
# define VUINT32x4_RSHIFT_DEFINED
#endif
#if !defined(VUINT32x4_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_lrshift(vuint32x4 vec1, vuint32x4 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	return vec1;
}
# define VUINT32x4_LRSHIFT_DEFINED
#endif
#if !defined(VUINT32x4_LSHIFT_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_lshift(vuint32x4 vec1, vuint32x4 vec2)
{
	vec1.generic[0] <<= vec2.generic[0];
	vec1.generic[1] <<= vec2.generic[0];
	vec1.generic[2] <<= vec2.generic[0];
	vec1.generic[3] <<= vec2.generic[0];
	return vec1;
}
# define VUINT32x4_LSHIFT_DEFINED
#endif
#if !defined(VINT32x8_SPLAT_DEFINED)
VEC_FUNC_IMPL vint32x8 vint32x8_splat(vec_int32 x)
{
	vint32x8 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	vec.generic[4] = x;
	vec.generic[5] = x;
	vec.generic[6] = x;
	vec.generic[7] = x;
	return vec;
}
# define VINT32x8_SPLAT_DEFINED
#endif
#if !defined(VINT32x8_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vint32x8 vint32x8_load_aligned(const vec_int32 x[8])
{
	vint32x8 vec;
	memcpy(vec.generic, x, 32);
	return vec;
}
# define VINT32x8_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VINT32x8_LOAD_DEFINED)
VEC_FUNC_IMPL vint32x8 vint32x8_load(const vec_int32 x[8])
{
	vint32x8 vec;
	memcpy(vec.generic, x, 32);
	return vec;
}
# define VINT32x8_LOAD_DEFINED
#endif
#if !defined(VINT32x8_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vint32x8_store_aligned(vint32x8 vec, vec_int32 x[8])
{
	memcpy(x, vec.generic, 32);
}
# define VINT32x8_STORE_ALIGNED_DEFINED
#endif
#if !defined(VINT32x8_STORE_DEFINED)
VEC_FUNC_IMPL void vint32x8_store(vint32x8 vec, vec_int32 x[8])
{
	memcpy(x, vec.generic, 32);
}
# define VINT32x8_STORE_DEFINED
#endif
#if !defined(VINT32x8_ADD_DEFINED)
VEC_FUNC_IMPL vint32x8 vint32x8_add(vint32x8 vec1, vint32x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]);
	return vec1;
}
# define VINT32x8_ADD_DEFINED
#endif
#if !defined(VINT32x8_SUB_DEFINED)
VEC_FUNC_IMPL vint32x8 vint32x8_sub(vint32x8 vec1, vint32x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] - vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] - vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] - vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] - vec2.generic[7]);
	return vec1;
}
# define VINT32x8_SUB_DEFINED
#endif
#if !defined(VINT32x8_MUL_DEFINED)
VEC_FUNC_IMPL vint32x8 vint32x8_mul(vint32x8 vec1, vint32x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] * vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] * vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] * vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] * vec2.generic[7]);
	return vec1;
}
# define VINT32x8_MUL_DEFINED
#endif
#if !defined(VINT32x8_DIV_DEFINED)
VEC_FUNC_IMPL vint32x8 vint32x8_div(vint32x8 vec1, vint32x8 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] / vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] / vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] / vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] / vec2.generic[7]) : 0);
	return vec1;
}
# define VINT32x8_DIV_DEFINED
#endif
#if !defined(VINT32x8_MOD_DEFINED)
VEC_FUNC_IMPL vint32x8 vint32x8_mod(vint32x8 vec1, vint32x8 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] % vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] % vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] % vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] % vec2.generic[7]) : 0);
	return vec1;
}
# define VINT32x8_MOD_DEFINED
#endif
#if !defined(VINT32x8_AVG_DEFINED)
VEC_FUNC_IMPL vint32x8 vint32x8_avg(vint32x8 vec1, vint32x8 vec2)
{
	vec_int32 x_d_rem, y_d_rem, rem_d_quot, rem_d_rem;
	x_d_rem = (vec1.generic[0] % 2);
	y_d_rem = (vec2.generic[0] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[0] = ((vec1.generic[0] / 2) + (vec2.generic[0] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[1] % 2);
	y_d_rem = (vec2.generic[1] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[1] = ((vec1.generic[1] / 2) + (vec2.generic[1] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[2] % 2);
	y_d_rem = (vec2.generic[2] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[2] = ((vec1.generic[2] / 2) + (vec2.generic[2] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[3] % 2);
	y_d_rem = (vec2.generic[3] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[3] = ((vec1.generic[3] / 2) + (vec2.generic[3] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[4] % 2);
	y_d_rem = (vec2.generic[4] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[4] = ((vec1.generic[4] / 2) + (vec2.generic[4] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[5] % 2);
	y_d_rem = (vec2.generic[5] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[5] = ((vec1.generic[5] / 2) + (vec2.generic[5] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[6] % 2);
	y_d_rem = (vec2.generic[6] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[6] = ((vec1.generic[6] / 2) + (vec2.generic[6] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[7] % 2);
	y_d_rem = (vec2.generic[7] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[7] = ((vec1.generic[7] / 2) + (vec2.generic[7] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	return vec1;
}
# define VINT32x8_AVG_DEFINED
#endif
#if !defined(VINT32x8_AND_DEFINED)
VEC_FUNC_IMPL vint32x8 vint32x8_and(vint32x8 vec1, vint32x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] & vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] & vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] & vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] & vec2.generic[7]);
	return vec1;
}
# define VINT32x8_AND_DEFINED
#endif
#if !defined(VINT32x8_OR_DEFINED)
VEC_FUNC_IMPL vint32x8 vint32x8_or(vint32x8 vec1, vint32x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] | vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] | vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] | vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] | vec2.generic[7]);
	return vec1;
}
# define VINT32x8_OR_DEFINED
#endif
#if !defined(VINT32x8_XOR_DEFINED)
VEC_FUNC_IMPL vint32x8 vint32x8_xor(vint32x8 vec1, vint32x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] ^ vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] ^ vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] ^ vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] ^ vec2.generic[7]);
	return vec1;
}
# define VINT32x8_XOR_DEFINED
#endif
#if !defined(VINT32x8_NOT_DEFINED)
VEC_FUNC_IMPL vint32x8 vint32x8_not(vint32x8 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	vec.generic[4] = ~vec.generic[4];
	vec.generic[5] = ~vec.generic[5];
	vec.generic[6] = ~vec.generic[6];
	vec.generic[7] = ~vec.generic[7];
	return vec;
}
# define VINT32x8_NOT_DEFINED
#endif
#if !defined(VINT32x8_CMPLT_DEFINED)
VEC_FUNC_IMPL vint32x8 vint32x8_cmplt(vint32x8 vec1, vint32x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] < vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] < vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] < vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] < vec2.generic[7]) ? 0xFF : 0, 4);
	return vec1;
}
# define VINT32x8_CMPLT_DEFINED
#endif
#if !defined(VINT32x8_CMPEQ_DEFINED)
VEC_FUNC_IMPL vint32x8 vint32x8_cmpeq(vint32x8 vec1, vint32x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] == vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] == vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] == vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] == vec2.generic[7]) ? 0xFF : 0, 4);
	return vec1;
}
# define VINT32x8_CMPEQ_DEFINED
#endif
#if !defined(VINT32x8_CMPGT_DEFINED)
VEC_FUNC_IMPL vint32x8 vint32x8_cmpgt(vint32x8 vec1, vint32x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] > vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] > vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] > vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] > vec2.generic[7]) ? 0xFF : 0, 4);
	return vec1;
}
# define VINT32x8_CMPGT_DEFINED
#endif
#if !defined(VINT32x8_CMPLE_DEFINED)
VEC_FUNC_IMPL vint32x8 vint32x8_cmple(vint32x8 vec1, vint32x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] <= vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] <= vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] <= vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] <= vec2.generic[7]) ? 0xFF : 0, 4);
	return vec1;
}
# define VINT32x8_CMPLE_DEFINED
#endif
#if !defined(VINT32x8_CMPGE_DEFINED)
VEC_FUNC_IMPL vint32x8 vint32x8_cmpge(vint32x8 vec1, vint32x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] >= vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] >= vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] >= vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] >= vec2.generic[7]) ? 0xFF : 0, 4);
	return vec1;
}
# define VINT32x8_CMPGE_DEFINED
#endif
#if !defined(VINT32x8_MIN_DEFINED)
VEC_FUNC_IMPL vint32x8 vint32x8_min(vint32x8 vec1, vint32x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] < vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] < vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] < vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] < vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	return vec1;
}
# define VINT32x8_MIN_DEFINED
#endif
#if !defined(VINT32x8_MAX_DEFINED)
VEC_FUNC_IMPL vint32x8 vint32x8_max(vint32x8 vec1, vint32x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] > vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] > vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] > vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] > vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	return vec1;
}
# define VINT32x8_MAX_DEFINED
#endif
#if !defined(VINT32x8_RSHIFT_DEFINED)
VEC_FUNC_IMPL vint32x8 vint32x8_rshift(vint32x8 vec1, vuint32x8 vec2)
{
vec1.generic[0] = ((~vec1.generic[0]) >> vec2.generic[0]);
vec1.generic[1] = ((~vec1.generic[1]) >> vec2.generic[1]);
vec1.generic[2] = ((~vec1.generic[2]) >> vec2.generic[2]);
vec1.generic[3] = ((~vec1.generic[3]) >> vec2.generic[3]);
vec1.generic[4] = ((~vec1.generic[4]) >> vec2.generic[4]);
vec1.generic[5] = ((~vec1.generic[5]) >> vec2.generic[5]);
vec1.generic[6] = ((~vec1.generic[6]) >> vec2.generic[6]);
vec1.generic[7] = ((~vec1.generic[7]) >> vec2.generic[7]);
	return vec1;
}
# define VINT32x8_RSHIFT_DEFINED
#endif
#if !defined(VINT32x8_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vint32x8 vint32x8_lrshift(vint32x8 vec1, vuint32x8 vec2)
{
	union { vec_uint32 u; vec_int32 s; } x;

	x.s = vec1.generic[0];
	x.u >>= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u >>= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u >>= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u >>= vec2.generic[3];
	vec1.generic[3] = x.s;
	x.s = vec1.generic[4];
	x.u >>= vec2.generic[4];
	vec1.generic[4] = x.s;
	x.s = vec1.generic[5];
	x.u >>= vec2.generic[5];
	vec1.generic[5] = x.s;
	x.s = vec1.generic[6];
	x.u >>= vec2.generic[6];
	vec1.generic[6] = x.s;
	x.s = vec1.generic[7];
	x.u >>= vec2.generic[7];
	vec1.generic[7] = x.s;
	return vec1;
}
# define VINT32x8_LRSHIFT_DEFINED
#endif
#if !defined(VINT32x8_LSHIFT_DEFINED)
VEC_FUNC_IMPL vint32x8 vint32x8_lshift(vint32x8 vec1, vuint32x8 vec2)
{
	union { vec_uint32 u; vec_int32 s; } x;

	x.s = vec1.generic[0];
	x.u <<= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u <<= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u <<= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u <<= vec2.generic[3];
	vec1.generic[3] = x.s;
	x.s = vec1.generic[4];
	x.u <<= vec2.generic[4];
	vec1.generic[4] = x.s;
	x.s = vec1.generic[5];
	x.u <<= vec2.generic[5];
	vec1.generic[5] = x.s;
	x.s = vec1.generic[6];
	x.u <<= vec2.generic[6];
	vec1.generic[6] = x.s;
	x.s = vec1.generic[7];
	x.u <<= vec2.generic[7];
	vec1.generic[7] = x.s;
	return vec1;
}
# define VINT32x8_LSHIFT_DEFINED
#endif
#if !defined(VUINT32x8_SPLAT_DEFINED)
VEC_FUNC_IMPL vuint32x8 vuint32x8_splat(vec_uint32 x)
{
	vuint32x8 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	vec.generic[4] = x;
	vec.generic[5] = x;
	vec.generic[6] = x;
	vec.generic[7] = x;
	return vec;
}
# define VUINT32x8_SPLAT_DEFINED
#endif
#if !defined(VUINT32x8_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vuint32x8 vuint32x8_load_aligned(const vec_uint32 x[8])
{
	vuint32x8 vec;
	memcpy(vec.generic, x, 32);
	return vec;
}
# define VUINT32x8_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VUINT32x8_LOAD_DEFINED)
VEC_FUNC_IMPL vuint32x8 vuint32x8_load(const vec_uint32 x[8])
{
	vuint32x8 vec;
	memcpy(vec.generic, x, 32);
	return vec;
}
# define VUINT32x8_LOAD_DEFINED
#endif
#if !defined(VUINT32x8_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vuint32x8_store_aligned(vuint32x8 vec, vec_uint32 x[8])
{
	memcpy(x, vec.generic, 32);
}
# define VUINT32x8_STORE_ALIGNED_DEFINED
#endif
#if !defined(VUINT32x8_STORE_DEFINED)
VEC_FUNC_IMPL void vuint32x8_store(vuint32x8 vec, vec_uint32 x[8])
{
	memcpy(x, vec.generic, 32);
}
# define VUINT32x8_STORE_DEFINED
#endif
#if !defined(VUINT32x8_ADD_DEFINED)
VEC_FUNC_IMPL vuint32x8 vuint32x8_add(vuint32x8 vec1, vuint32x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]);
	return vec1;
}
# define VUINT32x8_ADD_DEFINED
#endif
#if !defined(VUINT32x8_SUB_DEFINED)
VEC_FUNC_IMPL vuint32x8 vuint32x8_sub(vuint32x8 vec1, vuint32x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] - vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] - vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] - vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] - vec2.generic[7]);
	return vec1;
}
# define VUINT32x8_SUB_DEFINED
#endif
#if !defined(VUINT32x8_MUL_DEFINED)
VEC_FUNC_IMPL vuint32x8 vuint32x8_mul(vuint32x8 vec1, vuint32x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] * vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] * vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] * vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] * vec2.generic[7]);
	return vec1;
}
# define VUINT32x8_MUL_DEFINED
#endif
#if !defined(VUINT32x8_DIV_DEFINED)
VEC_FUNC_IMPL vuint32x8 vuint32x8_div(vuint32x8 vec1, vuint32x8 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] / vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] / vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] / vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] / vec2.generic[7]) : 0);
	return vec1;
}
# define VUINT32x8_DIV_DEFINED
#endif
#if !defined(VUINT32x8_MOD_DEFINED)
VEC_FUNC_IMPL vuint32x8 vuint32x8_mod(vuint32x8 vec1, vuint32x8 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] % vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] % vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] % vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] % vec2.generic[7]) : 0);
	return vec1;
}
# define VUINT32x8_MOD_DEFINED
#endif
#if !defined(VUINT32x8_AVG_DEFINED)
VEC_FUNC_IMPL vuint32x8 vuint32x8_avg(vuint32x8 vec1, vuint32x8 vec2)
{
vec1.generic[0] = (vec1.generic[0] >> 1) + (vec2.generic[0] >> 1) + ((vec1.generic[0] | vec2.generic[0]) & 1);
vec1.generic[1] = (vec1.generic[1] >> 1) + (vec2.generic[1] >> 1) + ((vec1.generic[1] | vec2.generic[1]) & 1);
vec1.generic[2] = (vec1.generic[2] >> 1) + (vec2.generic[2] >> 1) + ((vec1.generic[2] | vec2.generic[2]) & 1);
vec1.generic[3] = (vec1.generic[3] >> 1) + (vec2.generic[3] >> 1) + ((vec1.generic[3] | vec2.generic[3]) & 1);
vec1.generic[4] = (vec1.generic[4] >> 1) + (vec2.generic[4] >> 1) + ((vec1.generic[4] | vec2.generic[4]) & 1);
vec1.generic[5] = (vec1.generic[5] >> 1) + (vec2.generic[5] >> 1) + ((vec1.generic[5] | vec2.generic[5]) & 1);
vec1.generic[6] = (vec1.generic[6] >> 1) + (vec2.generic[6] >> 1) + ((vec1.generic[6] | vec2.generic[6]) & 1);
vec1.generic[7] = (vec1.generic[7] >> 1) + (vec2.generic[7] >> 1) + ((vec1.generic[7] | vec2.generic[7]) & 1);
	return vec1;
}
# define VUINT32x8_AVG_DEFINED
#endif
#if !defined(VUINT32x8_AND_DEFINED)
VEC_FUNC_IMPL vuint32x8 vuint32x8_and(vuint32x8 vec1, vuint32x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] & vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] & vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] & vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] & vec2.generic[7]);
	return vec1;
}
# define VUINT32x8_AND_DEFINED
#endif
#if !defined(VUINT32x8_OR_DEFINED)
VEC_FUNC_IMPL vuint32x8 vuint32x8_or(vuint32x8 vec1, vuint32x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] | vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] | vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] | vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] | vec2.generic[7]);
	return vec1;
}
# define VUINT32x8_OR_DEFINED
#endif
#if !defined(VUINT32x8_XOR_DEFINED)
VEC_FUNC_IMPL vuint32x8 vuint32x8_xor(vuint32x8 vec1, vuint32x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] ^ vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] ^ vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] ^ vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] ^ vec2.generic[7]);
	return vec1;
}
# define VUINT32x8_XOR_DEFINED
#endif
#if !defined(VUINT32x8_NOT_DEFINED)
VEC_FUNC_IMPL vuint32x8 vuint32x8_not(vuint32x8 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	vec.generic[4] = ~vec.generic[4];
	vec.generic[5] = ~vec.generic[5];
	vec.generic[6] = ~vec.generic[6];
	vec.generic[7] = ~vec.generic[7];
	return vec;
}
# define VUINT32x8_NOT_DEFINED
#endif
#if !defined(VUINT32x8_CMPLT_DEFINED)
VEC_FUNC_IMPL vuint32x8 vuint32x8_cmplt(vuint32x8 vec1, vuint32x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] < vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] < vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] < vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] < vec2.generic[7]) ? 0xFF : 0, 4);
	return vec1;
}
# define VUINT32x8_CMPLT_DEFINED
#endif
#if !defined(VUINT32x8_CMPEQ_DEFINED)
VEC_FUNC_IMPL vuint32x8 vuint32x8_cmpeq(vuint32x8 vec1, vuint32x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] == vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] == vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] == vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] == vec2.generic[7]) ? 0xFF : 0, 4);
	return vec1;
}
# define VUINT32x8_CMPEQ_DEFINED
#endif
#if !defined(VUINT32x8_CMPGT_DEFINED)
VEC_FUNC_IMPL vuint32x8 vuint32x8_cmpgt(vuint32x8 vec1, vuint32x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] > vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] > vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] > vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] > vec2.generic[7]) ? 0xFF : 0, 4);
	return vec1;
}
# define VUINT32x8_CMPGT_DEFINED
#endif
#if !defined(VUINT32x8_CMPLE_DEFINED)
VEC_FUNC_IMPL vuint32x8 vuint32x8_cmple(vuint32x8 vec1, vuint32x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] <= vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] <= vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] <= vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] <= vec2.generic[7]) ? 0xFF : 0, 4);
	return vec1;
}
# define VUINT32x8_CMPLE_DEFINED
#endif
#if !defined(VUINT32x8_CMPGE_DEFINED)
VEC_FUNC_IMPL vuint32x8 vuint32x8_cmpge(vuint32x8 vec1, vuint32x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] >= vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] >= vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] >= vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] >= vec2.generic[7]) ? 0xFF : 0, 4);
	return vec1;
}
# define VUINT32x8_CMPGE_DEFINED
#endif
#if !defined(VUINT32x8_MIN_DEFINED)
VEC_FUNC_IMPL vuint32x8 vuint32x8_min(vuint32x8 vec1, vuint32x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] < vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] < vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] < vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] < vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	return vec1;
}
# define VUINT32x8_MIN_DEFINED
#endif
#if !defined(VUINT32x8_MAX_DEFINED)
VEC_FUNC_IMPL vuint32x8 vuint32x8_max(vuint32x8 vec1, vuint32x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] > vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] > vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] > vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] > vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	return vec1;
}
# define VUINT32x8_MAX_DEFINED
#endif
#if !defined(VUINT32x8_RSHIFT_DEFINED)
VEC_FUNC_IMPL vuint32x8 vuint32x8_rshift(vuint32x8 vec1, vuint32x8 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	vec1.generic[4] >>= vec2.generic[0];
	vec1.generic[5] >>= vec2.generic[0];
	vec1.generic[6] >>= vec2.generic[0];
	vec1.generic[7] >>= vec2.generic[0];
	return vec1;
}
# define VUINT32x8_RSHIFT_DEFINED
#endif
#if !defined(VUINT32x8_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vuint32x8 vuint32x8_lrshift(vuint32x8 vec1, vuint32x8 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	vec1.generic[4] >>= vec2.generic[0];
	vec1.generic[5] >>= vec2.generic[0];
	vec1.generic[6] >>= vec2.generic[0];
	vec1.generic[7] >>= vec2.generic[0];
	return vec1;
}
# define VUINT32x8_LRSHIFT_DEFINED
#endif
#if !defined(VUINT32x8_LSHIFT_DEFINED)
VEC_FUNC_IMPL vuint32x8 vuint32x8_lshift(vuint32x8 vec1, vuint32x8 vec2)
{
	vec1.generic[0] <<= vec2.generic[0];
	vec1.generic[1] <<= vec2.generic[0];
	vec1.generic[2] <<= vec2.generic[0];
	vec1.generic[3] <<= vec2.generic[0];
	vec1.generic[4] <<= vec2.generic[0];
	vec1.generic[5] <<= vec2.generic[0];
	vec1.generic[6] <<= vec2.generic[0];
	vec1.generic[7] <<= vec2.generic[0];
	return vec1;
}
# define VUINT32x8_LSHIFT_DEFINED
#endif
#if !defined(VINT32x16_SPLAT_DEFINED)
VEC_FUNC_IMPL vint32x16 vint32x16_splat(vec_int32 x)
{
	vint32x16 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	vec.generic[4] = x;
	vec.generic[5] = x;
	vec.generic[6] = x;
	vec.generic[7] = x;
	vec.generic[8] = x;
	vec.generic[9] = x;
	vec.generic[10] = x;
	vec.generic[11] = x;
	vec.generic[12] = x;
	vec.generic[13] = x;
	vec.generic[14] = x;
	vec.generic[15] = x;
	return vec;
}
# define VINT32x16_SPLAT_DEFINED
#endif
#if !defined(VINT32x16_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vint32x16 vint32x16_load_aligned(const vec_int32 x[16])
{
	vint32x16 vec;
	memcpy(vec.generic, x, 64);
	return vec;
}
# define VINT32x16_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VINT32x16_LOAD_DEFINED)
VEC_FUNC_IMPL vint32x16 vint32x16_load(const vec_int32 x[16])
{
	vint32x16 vec;
	memcpy(vec.generic, x, 64);
	return vec;
}
# define VINT32x16_LOAD_DEFINED
#endif
#if !defined(VINT32x16_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vint32x16_store_aligned(vint32x16 vec, vec_int32 x[16])
{
	memcpy(x, vec.generic, 64);
}
# define VINT32x16_STORE_ALIGNED_DEFINED
#endif
#if !defined(VINT32x16_STORE_DEFINED)
VEC_FUNC_IMPL void vint32x16_store(vint32x16 vec, vec_int32 x[16])
{
	memcpy(x, vec.generic, 64);
}
# define VINT32x16_STORE_DEFINED
#endif
#if !defined(VINT32x16_ADD_DEFINED)
VEC_FUNC_IMPL vint32x16 vint32x16_add(vint32x16 vec1, vint32x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] + vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] + vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] + vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] + vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] + vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] + vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] + vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] + vec2.generic[15]);
	return vec1;
}
# define VINT32x16_ADD_DEFINED
#endif
#if !defined(VINT32x16_SUB_DEFINED)
VEC_FUNC_IMPL vint32x16 vint32x16_sub(vint32x16 vec1, vint32x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] - vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] - vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] - vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] - vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] - vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] - vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] - vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] - vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] - vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] - vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] - vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] - vec2.generic[15]);
	return vec1;
}
# define VINT32x16_SUB_DEFINED
#endif
#if !defined(VINT32x16_MUL_DEFINED)
VEC_FUNC_IMPL vint32x16 vint32x16_mul(vint32x16 vec1, vint32x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] * vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] * vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] * vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] * vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] * vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] * vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] * vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] * vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] * vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] * vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] * vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] * vec2.generic[15]);
	return vec1;
}
# define VINT32x16_MUL_DEFINED
#endif
#if !defined(VINT32x16_DIV_DEFINED)
VEC_FUNC_IMPL vint32x16 vint32x16_div(vint32x16 vec1, vint32x16 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] / vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] / vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] / vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] / vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? (vec1.generic[8] / vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? (vec1.generic[9] / vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? (vec1.generic[10] / vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? (vec1.generic[11] / vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? (vec1.generic[12] / vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? (vec1.generic[13] / vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? (vec1.generic[14] / vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? (vec1.generic[15] / vec2.generic[15]) : 0);
	return vec1;
}
# define VINT32x16_DIV_DEFINED
#endif
#if !defined(VINT32x16_MOD_DEFINED)
VEC_FUNC_IMPL vint32x16 vint32x16_mod(vint32x16 vec1, vint32x16 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] % vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] % vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] % vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] % vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? (vec1.generic[8] % vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? (vec1.generic[9] % vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? (vec1.generic[10] % vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? (vec1.generic[11] % vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? (vec1.generic[12] % vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? (vec1.generic[13] % vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? (vec1.generic[14] % vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? (vec1.generic[15] % vec2.generic[15]) : 0);
	return vec1;
}
# define VINT32x16_MOD_DEFINED
#endif
#if !defined(VINT32x16_AVG_DEFINED)
VEC_FUNC_IMPL vint32x16 vint32x16_avg(vint32x16 vec1, vint32x16 vec2)
{
	vec_int32 x_d_rem, y_d_rem, rem_d_quot, rem_d_rem;
	x_d_rem = (vec1.generic[0] % 2);
	y_d_rem = (vec2.generic[0] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[0] = ((vec1.generic[0] / 2) + (vec2.generic[0] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[1] % 2);
	y_d_rem = (vec2.generic[1] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[1] = ((vec1.generic[1] / 2) + (vec2.generic[1] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[2] % 2);
	y_d_rem = (vec2.generic[2] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[2] = ((vec1.generic[2] / 2) + (vec2.generic[2] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[3] % 2);
	y_d_rem = (vec2.generic[3] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[3] = ((vec1.generic[3] / 2) + (vec2.generic[3] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[4] % 2);
	y_d_rem = (vec2.generic[4] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[4] = ((vec1.generic[4] / 2) + (vec2.generic[4] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[5] % 2);
	y_d_rem = (vec2.generic[5] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[5] = ((vec1.generic[5] / 2) + (vec2.generic[5] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[6] % 2);
	y_d_rem = (vec2.generic[6] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[6] = ((vec1.generic[6] / 2) + (vec2.generic[6] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[7] % 2);
	y_d_rem = (vec2.generic[7] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[7] = ((vec1.generic[7] / 2) + (vec2.generic[7] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[8] % 2);
	y_d_rem = (vec2.generic[8] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[8] = ((vec1.generic[8] / 2) + (vec2.generic[8] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[9] % 2);
	y_d_rem = (vec2.generic[9] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[9] = ((vec1.generic[9] / 2) + (vec2.generic[9] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[10] % 2);
	y_d_rem = (vec2.generic[10] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[10] = ((vec1.generic[10] / 2) + (vec2.generic[10] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[11] % 2);
	y_d_rem = (vec2.generic[11] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[11] = ((vec1.generic[11] / 2) + (vec2.generic[11] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[12] % 2);
	y_d_rem = (vec2.generic[12] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[12] = ((vec1.generic[12] / 2) + (vec2.generic[12] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[13] % 2);
	y_d_rem = (vec2.generic[13] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[13] = ((vec1.generic[13] / 2) + (vec2.generic[13] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[14] % 2);
	y_d_rem = (vec2.generic[14] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[14] = ((vec1.generic[14] / 2) + (vec2.generic[14] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[15] % 2);
	y_d_rem = (vec2.generic[15] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[15] = ((vec1.generic[15] / 2) + (vec2.generic[15] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	return vec1;
}
# define VINT32x16_AVG_DEFINED
#endif
#if !defined(VINT32x16_AND_DEFINED)
VEC_FUNC_IMPL vint32x16 vint32x16_and(vint32x16 vec1, vint32x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] & vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] & vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] & vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] & vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] & vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] & vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] & vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] & vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] & vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] & vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] & vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] & vec2.generic[15]);
	return vec1;
}
# define VINT32x16_AND_DEFINED
#endif
#if !defined(VINT32x16_OR_DEFINED)
VEC_FUNC_IMPL vint32x16 vint32x16_or(vint32x16 vec1, vint32x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] | vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] | vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] | vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] | vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] | vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] | vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] | vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] | vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] | vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] | vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] | vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] | vec2.generic[15]);
	return vec1;
}
# define VINT32x16_OR_DEFINED
#endif
#if !defined(VINT32x16_XOR_DEFINED)
VEC_FUNC_IMPL vint32x16 vint32x16_xor(vint32x16 vec1, vint32x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] ^ vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] ^ vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] ^ vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] ^ vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] ^ vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] ^ vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] ^ vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] ^ vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] ^ vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] ^ vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] ^ vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] ^ vec2.generic[15]);
	return vec1;
}
# define VINT32x16_XOR_DEFINED
#endif
#if !defined(VINT32x16_NOT_DEFINED)
VEC_FUNC_IMPL vint32x16 vint32x16_not(vint32x16 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	vec.generic[4] = ~vec.generic[4];
	vec.generic[5] = ~vec.generic[5];
	vec.generic[6] = ~vec.generic[6];
	vec.generic[7] = ~vec.generic[7];
	vec.generic[8] = ~vec.generic[8];
	vec.generic[9] = ~vec.generic[9];
	vec.generic[10] = ~vec.generic[10];
	vec.generic[11] = ~vec.generic[11];
	vec.generic[12] = ~vec.generic[12];
	vec.generic[13] = ~vec.generic[13];
	vec.generic[14] = ~vec.generic[14];
	vec.generic[15] = ~vec.generic[15];
	return vec;
}
# define VINT32x16_NOT_DEFINED
#endif
#if !defined(VINT32x16_CMPLT_DEFINED)
VEC_FUNC_IMPL vint32x16 vint32x16_cmplt(vint32x16 vec1, vint32x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] < vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] < vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] < vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] < vec2.generic[7]) ? 0xFF : 0, 4);
	memset(&vec1.generic[8], (vec1.generic[8] < vec2.generic[8]) ? 0xFF : 0, 4);
	memset(&vec1.generic[9], (vec1.generic[9] < vec2.generic[9]) ? 0xFF : 0, 4);
	memset(&vec1.generic[10], (vec1.generic[10] < vec2.generic[10]) ? 0xFF : 0, 4);
	memset(&vec1.generic[11], (vec1.generic[11] < vec2.generic[11]) ? 0xFF : 0, 4);
	memset(&vec1.generic[12], (vec1.generic[12] < vec2.generic[12]) ? 0xFF : 0, 4);
	memset(&vec1.generic[13], (vec1.generic[13] < vec2.generic[13]) ? 0xFF : 0, 4);
	memset(&vec1.generic[14], (vec1.generic[14] < vec2.generic[14]) ? 0xFF : 0, 4);
	memset(&vec1.generic[15], (vec1.generic[15] < vec2.generic[15]) ? 0xFF : 0, 4);
	return vec1;
}
# define VINT32x16_CMPLT_DEFINED
#endif
#if !defined(VINT32x16_CMPEQ_DEFINED)
VEC_FUNC_IMPL vint32x16 vint32x16_cmpeq(vint32x16 vec1, vint32x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] == vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] == vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] == vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] == vec2.generic[7]) ? 0xFF : 0, 4);
	memset(&vec1.generic[8], (vec1.generic[8] == vec2.generic[8]) ? 0xFF : 0, 4);
	memset(&vec1.generic[9], (vec1.generic[9] == vec2.generic[9]) ? 0xFF : 0, 4);
	memset(&vec1.generic[10], (vec1.generic[10] == vec2.generic[10]) ? 0xFF : 0, 4);
	memset(&vec1.generic[11], (vec1.generic[11] == vec2.generic[11]) ? 0xFF : 0, 4);
	memset(&vec1.generic[12], (vec1.generic[12] == vec2.generic[12]) ? 0xFF : 0, 4);
	memset(&vec1.generic[13], (vec1.generic[13] == vec2.generic[13]) ? 0xFF : 0, 4);
	memset(&vec1.generic[14], (vec1.generic[14] == vec2.generic[14]) ? 0xFF : 0, 4);
	memset(&vec1.generic[15], (vec1.generic[15] == vec2.generic[15]) ? 0xFF : 0, 4);
	return vec1;
}
# define VINT32x16_CMPEQ_DEFINED
#endif
#if !defined(VINT32x16_CMPGT_DEFINED)
VEC_FUNC_IMPL vint32x16 vint32x16_cmpgt(vint32x16 vec1, vint32x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] > vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] > vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] > vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] > vec2.generic[7]) ? 0xFF : 0, 4);
	memset(&vec1.generic[8], (vec1.generic[8] > vec2.generic[8]) ? 0xFF : 0, 4);
	memset(&vec1.generic[9], (vec1.generic[9] > vec2.generic[9]) ? 0xFF : 0, 4);
	memset(&vec1.generic[10], (vec1.generic[10] > vec2.generic[10]) ? 0xFF : 0, 4);
	memset(&vec1.generic[11], (vec1.generic[11] > vec2.generic[11]) ? 0xFF : 0, 4);
	memset(&vec1.generic[12], (vec1.generic[12] > vec2.generic[12]) ? 0xFF : 0, 4);
	memset(&vec1.generic[13], (vec1.generic[13] > vec2.generic[13]) ? 0xFF : 0, 4);
	memset(&vec1.generic[14], (vec1.generic[14] > vec2.generic[14]) ? 0xFF : 0, 4);
	memset(&vec1.generic[15], (vec1.generic[15] > vec2.generic[15]) ? 0xFF : 0, 4);
	return vec1;
}
# define VINT32x16_CMPGT_DEFINED
#endif
#if !defined(VINT32x16_CMPLE_DEFINED)
VEC_FUNC_IMPL vint32x16 vint32x16_cmple(vint32x16 vec1, vint32x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] <= vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] <= vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] <= vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] <= vec2.generic[7]) ? 0xFF : 0, 4);
	memset(&vec1.generic[8], (vec1.generic[8] <= vec2.generic[8]) ? 0xFF : 0, 4);
	memset(&vec1.generic[9], (vec1.generic[9] <= vec2.generic[9]) ? 0xFF : 0, 4);
	memset(&vec1.generic[10], (vec1.generic[10] <= vec2.generic[10]) ? 0xFF : 0, 4);
	memset(&vec1.generic[11], (vec1.generic[11] <= vec2.generic[11]) ? 0xFF : 0, 4);
	memset(&vec1.generic[12], (vec1.generic[12] <= vec2.generic[12]) ? 0xFF : 0, 4);
	memset(&vec1.generic[13], (vec1.generic[13] <= vec2.generic[13]) ? 0xFF : 0, 4);
	memset(&vec1.generic[14], (vec1.generic[14] <= vec2.generic[14]) ? 0xFF : 0, 4);
	memset(&vec1.generic[15], (vec1.generic[15] <= vec2.generic[15]) ? 0xFF : 0, 4);
	return vec1;
}
# define VINT32x16_CMPLE_DEFINED
#endif
#if !defined(VINT32x16_CMPGE_DEFINED)
VEC_FUNC_IMPL vint32x16 vint32x16_cmpge(vint32x16 vec1, vint32x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] >= vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] >= vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] >= vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] >= vec2.generic[7]) ? 0xFF : 0, 4);
	memset(&vec1.generic[8], (vec1.generic[8] >= vec2.generic[8]) ? 0xFF : 0, 4);
	memset(&vec1.generic[9], (vec1.generic[9] >= vec2.generic[9]) ? 0xFF : 0, 4);
	memset(&vec1.generic[10], (vec1.generic[10] >= vec2.generic[10]) ? 0xFF : 0, 4);
	memset(&vec1.generic[11], (vec1.generic[11] >= vec2.generic[11]) ? 0xFF : 0, 4);
	memset(&vec1.generic[12], (vec1.generic[12] >= vec2.generic[12]) ? 0xFF : 0, 4);
	memset(&vec1.generic[13], (vec1.generic[13] >= vec2.generic[13]) ? 0xFF : 0, 4);
	memset(&vec1.generic[14], (vec1.generic[14] >= vec2.generic[14]) ? 0xFF : 0, 4);
	memset(&vec1.generic[15], (vec1.generic[15] >= vec2.generic[15]) ? 0xFF : 0, 4);
	return vec1;
}
# define VINT32x16_CMPGE_DEFINED
#endif
#if !defined(VINT32x16_MIN_DEFINED)
VEC_FUNC_IMPL vint32x16 vint32x16_min(vint32x16 vec1, vint32x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] < vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] < vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] < vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] < vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] < vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] < vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] < vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] < vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] < vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] < vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] < vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] < vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	return vec1;
}
# define VINT32x16_MIN_DEFINED
#endif
#if !defined(VINT32x16_MAX_DEFINED)
VEC_FUNC_IMPL vint32x16 vint32x16_max(vint32x16 vec1, vint32x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] > vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] > vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] > vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] > vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] > vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] > vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] > vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] > vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] > vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] > vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] > vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] > vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	return vec1;
}
# define VINT32x16_MAX_DEFINED
#endif
#if !defined(VINT32x16_RSHIFT_DEFINED)
VEC_FUNC_IMPL vint32x16 vint32x16_rshift(vint32x16 vec1, vuint32x16 vec2)
{
vec1.generic[0] = ((~vec1.generic[0]) >> vec2.generic[0]);
vec1.generic[1] = ((~vec1.generic[1]) >> vec2.generic[1]);
vec1.generic[2] = ((~vec1.generic[2]) >> vec2.generic[2]);
vec1.generic[3] = ((~vec1.generic[3]) >> vec2.generic[3]);
vec1.generic[4] = ((~vec1.generic[4]) >> vec2.generic[4]);
vec1.generic[5] = ((~vec1.generic[5]) >> vec2.generic[5]);
vec1.generic[6] = ((~vec1.generic[6]) >> vec2.generic[6]);
vec1.generic[7] = ((~vec1.generic[7]) >> vec2.generic[7]);
vec1.generic[8] = ((~vec1.generic[8]) >> vec2.generic[8]);
vec1.generic[9] = ((~vec1.generic[9]) >> vec2.generic[9]);
vec1.generic[10] = ((~vec1.generic[10]) >> vec2.generic[10]);
vec1.generic[11] = ((~vec1.generic[11]) >> vec2.generic[11]);
vec1.generic[12] = ((~vec1.generic[12]) >> vec2.generic[12]);
vec1.generic[13] = ((~vec1.generic[13]) >> vec2.generic[13]);
vec1.generic[14] = ((~vec1.generic[14]) >> vec2.generic[14]);
vec1.generic[15] = ((~vec1.generic[15]) >> vec2.generic[15]);
	return vec1;
}
# define VINT32x16_RSHIFT_DEFINED
#endif
#if !defined(VINT32x16_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vint32x16 vint32x16_lrshift(vint32x16 vec1, vuint32x16 vec2)
{
	union { vec_uint32 u; vec_int32 s; } x;

	x.s = vec1.generic[0];
	x.u >>= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u >>= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u >>= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u >>= vec2.generic[3];
	vec1.generic[3] = x.s;
	x.s = vec1.generic[4];
	x.u >>= vec2.generic[4];
	vec1.generic[4] = x.s;
	x.s = vec1.generic[5];
	x.u >>= vec2.generic[5];
	vec1.generic[5] = x.s;
	x.s = vec1.generic[6];
	x.u >>= vec2.generic[6];
	vec1.generic[6] = x.s;
	x.s = vec1.generic[7];
	x.u >>= vec2.generic[7];
	vec1.generic[7] = x.s;
	x.s = vec1.generic[8];
	x.u >>= vec2.generic[8];
	vec1.generic[8] = x.s;
	x.s = vec1.generic[9];
	x.u >>= vec2.generic[9];
	vec1.generic[9] = x.s;
	x.s = vec1.generic[10];
	x.u >>= vec2.generic[10];
	vec1.generic[10] = x.s;
	x.s = vec1.generic[11];
	x.u >>= vec2.generic[11];
	vec1.generic[11] = x.s;
	x.s = vec1.generic[12];
	x.u >>= vec2.generic[12];
	vec1.generic[12] = x.s;
	x.s = vec1.generic[13];
	x.u >>= vec2.generic[13];
	vec1.generic[13] = x.s;
	x.s = vec1.generic[14];
	x.u >>= vec2.generic[14];
	vec1.generic[14] = x.s;
	x.s = vec1.generic[15];
	x.u >>= vec2.generic[15];
	vec1.generic[15] = x.s;
	return vec1;
}
# define VINT32x16_LRSHIFT_DEFINED
#endif
#if !defined(VINT32x16_LSHIFT_DEFINED)
VEC_FUNC_IMPL vint32x16 vint32x16_lshift(vint32x16 vec1, vuint32x16 vec2)
{
	union { vec_uint32 u; vec_int32 s; } x;

	x.s = vec1.generic[0];
	x.u <<= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u <<= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u <<= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u <<= vec2.generic[3];
	vec1.generic[3] = x.s;
	x.s = vec1.generic[4];
	x.u <<= vec2.generic[4];
	vec1.generic[4] = x.s;
	x.s = vec1.generic[5];
	x.u <<= vec2.generic[5];
	vec1.generic[5] = x.s;
	x.s = vec1.generic[6];
	x.u <<= vec2.generic[6];
	vec1.generic[6] = x.s;
	x.s = vec1.generic[7];
	x.u <<= vec2.generic[7];
	vec1.generic[7] = x.s;
	x.s = vec1.generic[8];
	x.u <<= vec2.generic[8];
	vec1.generic[8] = x.s;
	x.s = vec1.generic[9];
	x.u <<= vec2.generic[9];
	vec1.generic[9] = x.s;
	x.s = vec1.generic[10];
	x.u <<= vec2.generic[10];
	vec1.generic[10] = x.s;
	x.s = vec1.generic[11];
	x.u <<= vec2.generic[11];
	vec1.generic[11] = x.s;
	x.s = vec1.generic[12];
	x.u <<= vec2.generic[12];
	vec1.generic[12] = x.s;
	x.s = vec1.generic[13];
	x.u <<= vec2.generic[13];
	vec1.generic[13] = x.s;
	x.s = vec1.generic[14];
	x.u <<= vec2.generic[14];
	vec1.generic[14] = x.s;
	x.s = vec1.generic[15];
	x.u <<= vec2.generic[15];
	vec1.generic[15] = x.s;
	return vec1;
}
# define VINT32x16_LSHIFT_DEFINED
#endif
#if !defined(VUINT32x16_SPLAT_DEFINED)
VEC_FUNC_IMPL vuint32x16 vuint32x16_splat(vec_uint32 x)
{
	vuint32x16 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	vec.generic[4] = x;
	vec.generic[5] = x;
	vec.generic[6] = x;
	vec.generic[7] = x;
	vec.generic[8] = x;
	vec.generic[9] = x;
	vec.generic[10] = x;
	vec.generic[11] = x;
	vec.generic[12] = x;
	vec.generic[13] = x;
	vec.generic[14] = x;
	vec.generic[15] = x;
	return vec;
}
# define VUINT32x16_SPLAT_DEFINED
#endif
#if !defined(VUINT32x16_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vuint32x16 vuint32x16_load_aligned(const vec_uint32 x[16])
{
	vuint32x16 vec;
	memcpy(vec.generic, x, 64);
	return vec;
}
# define VUINT32x16_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VUINT32x16_LOAD_DEFINED)
VEC_FUNC_IMPL vuint32x16 vuint32x16_load(const vec_uint32 x[16])
{
	vuint32x16 vec;
	memcpy(vec.generic, x, 64);
	return vec;
}
# define VUINT32x16_LOAD_DEFINED
#endif
#if !defined(VUINT32x16_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vuint32x16_store_aligned(vuint32x16 vec, vec_uint32 x[16])
{
	memcpy(x, vec.generic, 64);
}
# define VUINT32x16_STORE_ALIGNED_DEFINED
#endif
#if !defined(VUINT32x16_STORE_DEFINED)
VEC_FUNC_IMPL void vuint32x16_store(vuint32x16 vec, vec_uint32 x[16])
{
	memcpy(x, vec.generic, 64);
}
# define VUINT32x16_STORE_DEFINED
#endif
#if !defined(VUINT32x16_ADD_DEFINED)
VEC_FUNC_IMPL vuint32x16 vuint32x16_add(vuint32x16 vec1, vuint32x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] + vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] + vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] + vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] + vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] + vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] + vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] + vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] + vec2.generic[15]);
	return vec1;
}
# define VUINT32x16_ADD_DEFINED
#endif
#if !defined(VUINT32x16_SUB_DEFINED)
VEC_FUNC_IMPL vuint32x16 vuint32x16_sub(vuint32x16 vec1, vuint32x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] - vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] - vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] - vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] - vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] - vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] - vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] - vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] - vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] - vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] - vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] - vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] - vec2.generic[15]);
	return vec1;
}
# define VUINT32x16_SUB_DEFINED
#endif
#if !defined(VUINT32x16_MUL_DEFINED)
VEC_FUNC_IMPL vuint32x16 vuint32x16_mul(vuint32x16 vec1, vuint32x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] * vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] * vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] * vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] * vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] * vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] * vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] * vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] * vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] * vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] * vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] * vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] * vec2.generic[15]);
	return vec1;
}
# define VUINT32x16_MUL_DEFINED
#endif
#if !defined(VUINT32x16_DIV_DEFINED)
VEC_FUNC_IMPL vuint32x16 vuint32x16_div(vuint32x16 vec1, vuint32x16 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] / vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] / vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] / vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] / vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? (vec1.generic[8] / vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? (vec1.generic[9] / vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? (vec1.generic[10] / vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? (vec1.generic[11] / vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? (vec1.generic[12] / vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? (vec1.generic[13] / vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? (vec1.generic[14] / vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? (vec1.generic[15] / vec2.generic[15]) : 0);
	return vec1;
}
# define VUINT32x16_DIV_DEFINED
#endif
#if !defined(VUINT32x16_MOD_DEFINED)
VEC_FUNC_IMPL vuint32x16 vuint32x16_mod(vuint32x16 vec1, vuint32x16 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] % vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] % vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] % vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] % vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? (vec1.generic[8] % vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? (vec1.generic[9] % vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? (vec1.generic[10] % vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? (vec1.generic[11] % vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? (vec1.generic[12] % vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? (vec1.generic[13] % vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? (vec1.generic[14] % vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? (vec1.generic[15] % vec2.generic[15]) : 0);
	return vec1;
}
# define VUINT32x16_MOD_DEFINED
#endif
#if !defined(VUINT32x16_AVG_DEFINED)
VEC_FUNC_IMPL vuint32x16 vuint32x16_avg(vuint32x16 vec1, vuint32x16 vec2)
{
vec1.generic[0] = (vec1.generic[0] >> 1) + (vec2.generic[0] >> 1) + ((vec1.generic[0] | vec2.generic[0]) & 1);
vec1.generic[1] = (vec1.generic[1] >> 1) + (vec2.generic[1] >> 1) + ((vec1.generic[1] | vec2.generic[1]) & 1);
vec1.generic[2] = (vec1.generic[2] >> 1) + (vec2.generic[2] >> 1) + ((vec1.generic[2] | vec2.generic[2]) & 1);
vec1.generic[3] = (vec1.generic[3] >> 1) + (vec2.generic[3] >> 1) + ((vec1.generic[3] | vec2.generic[3]) & 1);
vec1.generic[4] = (vec1.generic[4] >> 1) + (vec2.generic[4] >> 1) + ((vec1.generic[4] | vec2.generic[4]) & 1);
vec1.generic[5] = (vec1.generic[5] >> 1) + (vec2.generic[5] >> 1) + ((vec1.generic[5] | vec2.generic[5]) & 1);
vec1.generic[6] = (vec1.generic[6] >> 1) + (vec2.generic[6] >> 1) + ((vec1.generic[6] | vec2.generic[6]) & 1);
vec1.generic[7] = (vec1.generic[7] >> 1) + (vec2.generic[7] >> 1) + ((vec1.generic[7] | vec2.generic[7]) & 1);
vec1.generic[8] = (vec1.generic[8] >> 1) + (vec2.generic[8] >> 1) + ((vec1.generic[8] | vec2.generic[8]) & 1);
vec1.generic[9] = (vec1.generic[9] >> 1) + (vec2.generic[9] >> 1) + ((vec1.generic[9] | vec2.generic[9]) & 1);
vec1.generic[10] = (vec1.generic[10] >> 1) + (vec2.generic[10] >> 1) + ((vec1.generic[10] | vec2.generic[10]) & 1);
vec1.generic[11] = (vec1.generic[11] >> 1) + (vec2.generic[11] >> 1) + ((vec1.generic[11] | vec2.generic[11]) & 1);
vec1.generic[12] = (vec1.generic[12] >> 1) + (vec2.generic[12] >> 1) + ((vec1.generic[12] | vec2.generic[12]) & 1);
vec1.generic[13] = (vec1.generic[13] >> 1) + (vec2.generic[13] >> 1) + ((vec1.generic[13] | vec2.generic[13]) & 1);
vec1.generic[14] = (vec1.generic[14] >> 1) + (vec2.generic[14] >> 1) + ((vec1.generic[14] | vec2.generic[14]) & 1);
vec1.generic[15] = (vec1.generic[15] >> 1) + (vec2.generic[15] >> 1) + ((vec1.generic[15] | vec2.generic[15]) & 1);
	return vec1;
}
# define VUINT32x16_AVG_DEFINED
#endif
#if !defined(VUINT32x16_AND_DEFINED)
VEC_FUNC_IMPL vuint32x16 vuint32x16_and(vuint32x16 vec1, vuint32x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] & vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] & vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] & vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] & vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] & vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] & vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] & vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] & vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] & vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] & vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] & vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] & vec2.generic[15]);
	return vec1;
}
# define VUINT32x16_AND_DEFINED
#endif
#if !defined(VUINT32x16_OR_DEFINED)
VEC_FUNC_IMPL vuint32x16 vuint32x16_or(vuint32x16 vec1, vuint32x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] | vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] | vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] | vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] | vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] | vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] | vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] | vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] | vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] | vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] | vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] | vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] | vec2.generic[15]);
	return vec1;
}
# define VUINT32x16_OR_DEFINED
#endif
#if !defined(VUINT32x16_XOR_DEFINED)
VEC_FUNC_IMPL vuint32x16 vuint32x16_xor(vuint32x16 vec1, vuint32x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] ^ vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] ^ vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] ^ vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] ^ vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] ^ vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] ^ vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] ^ vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] ^ vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] ^ vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] ^ vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] ^ vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] ^ vec2.generic[15]);
	return vec1;
}
# define VUINT32x16_XOR_DEFINED
#endif
#if !defined(VUINT32x16_NOT_DEFINED)
VEC_FUNC_IMPL vuint32x16 vuint32x16_not(vuint32x16 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	vec.generic[4] = ~vec.generic[4];
	vec.generic[5] = ~vec.generic[5];
	vec.generic[6] = ~vec.generic[6];
	vec.generic[7] = ~vec.generic[7];
	vec.generic[8] = ~vec.generic[8];
	vec.generic[9] = ~vec.generic[9];
	vec.generic[10] = ~vec.generic[10];
	vec.generic[11] = ~vec.generic[11];
	vec.generic[12] = ~vec.generic[12];
	vec.generic[13] = ~vec.generic[13];
	vec.generic[14] = ~vec.generic[14];
	vec.generic[15] = ~vec.generic[15];
	return vec;
}
# define VUINT32x16_NOT_DEFINED
#endif
#if !defined(VUINT32x16_CMPLT_DEFINED)
VEC_FUNC_IMPL vuint32x16 vuint32x16_cmplt(vuint32x16 vec1, vuint32x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] < vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] < vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] < vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] < vec2.generic[7]) ? 0xFF : 0, 4);
	memset(&vec1.generic[8], (vec1.generic[8] < vec2.generic[8]) ? 0xFF : 0, 4);
	memset(&vec1.generic[9], (vec1.generic[9] < vec2.generic[9]) ? 0xFF : 0, 4);
	memset(&vec1.generic[10], (vec1.generic[10] < vec2.generic[10]) ? 0xFF : 0, 4);
	memset(&vec1.generic[11], (vec1.generic[11] < vec2.generic[11]) ? 0xFF : 0, 4);
	memset(&vec1.generic[12], (vec1.generic[12] < vec2.generic[12]) ? 0xFF : 0, 4);
	memset(&vec1.generic[13], (vec1.generic[13] < vec2.generic[13]) ? 0xFF : 0, 4);
	memset(&vec1.generic[14], (vec1.generic[14] < vec2.generic[14]) ? 0xFF : 0, 4);
	memset(&vec1.generic[15], (vec1.generic[15] < vec2.generic[15]) ? 0xFF : 0, 4);
	return vec1;
}
# define VUINT32x16_CMPLT_DEFINED
#endif
#if !defined(VUINT32x16_CMPEQ_DEFINED)
VEC_FUNC_IMPL vuint32x16 vuint32x16_cmpeq(vuint32x16 vec1, vuint32x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] == vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] == vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] == vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] == vec2.generic[7]) ? 0xFF : 0, 4);
	memset(&vec1.generic[8], (vec1.generic[8] == vec2.generic[8]) ? 0xFF : 0, 4);
	memset(&vec1.generic[9], (vec1.generic[9] == vec2.generic[9]) ? 0xFF : 0, 4);
	memset(&vec1.generic[10], (vec1.generic[10] == vec2.generic[10]) ? 0xFF : 0, 4);
	memset(&vec1.generic[11], (vec1.generic[11] == vec2.generic[11]) ? 0xFF : 0, 4);
	memset(&vec1.generic[12], (vec1.generic[12] == vec2.generic[12]) ? 0xFF : 0, 4);
	memset(&vec1.generic[13], (vec1.generic[13] == vec2.generic[13]) ? 0xFF : 0, 4);
	memset(&vec1.generic[14], (vec1.generic[14] == vec2.generic[14]) ? 0xFF : 0, 4);
	memset(&vec1.generic[15], (vec1.generic[15] == vec2.generic[15]) ? 0xFF : 0, 4);
	return vec1;
}
# define VUINT32x16_CMPEQ_DEFINED
#endif
#if !defined(VUINT32x16_CMPGT_DEFINED)
VEC_FUNC_IMPL vuint32x16 vuint32x16_cmpgt(vuint32x16 vec1, vuint32x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] > vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] > vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] > vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] > vec2.generic[7]) ? 0xFF : 0, 4);
	memset(&vec1.generic[8], (vec1.generic[8] > vec2.generic[8]) ? 0xFF : 0, 4);
	memset(&vec1.generic[9], (vec1.generic[9] > vec2.generic[9]) ? 0xFF : 0, 4);
	memset(&vec1.generic[10], (vec1.generic[10] > vec2.generic[10]) ? 0xFF : 0, 4);
	memset(&vec1.generic[11], (vec1.generic[11] > vec2.generic[11]) ? 0xFF : 0, 4);
	memset(&vec1.generic[12], (vec1.generic[12] > vec2.generic[12]) ? 0xFF : 0, 4);
	memset(&vec1.generic[13], (vec1.generic[13] > vec2.generic[13]) ? 0xFF : 0, 4);
	memset(&vec1.generic[14], (vec1.generic[14] > vec2.generic[14]) ? 0xFF : 0, 4);
	memset(&vec1.generic[15], (vec1.generic[15] > vec2.generic[15]) ? 0xFF : 0, 4);
	return vec1;
}
# define VUINT32x16_CMPGT_DEFINED
#endif
#if !defined(VUINT32x16_CMPLE_DEFINED)
VEC_FUNC_IMPL vuint32x16 vuint32x16_cmple(vuint32x16 vec1, vuint32x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] <= vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] <= vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] <= vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] <= vec2.generic[7]) ? 0xFF : 0, 4);
	memset(&vec1.generic[8], (vec1.generic[8] <= vec2.generic[8]) ? 0xFF : 0, 4);
	memset(&vec1.generic[9], (vec1.generic[9] <= vec2.generic[9]) ? 0xFF : 0, 4);
	memset(&vec1.generic[10], (vec1.generic[10] <= vec2.generic[10]) ? 0xFF : 0, 4);
	memset(&vec1.generic[11], (vec1.generic[11] <= vec2.generic[11]) ? 0xFF : 0, 4);
	memset(&vec1.generic[12], (vec1.generic[12] <= vec2.generic[12]) ? 0xFF : 0, 4);
	memset(&vec1.generic[13], (vec1.generic[13] <= vec2.generic[13]) ? 0xFF : 0, 4);
	memset(&vec1.generic[14], (vec1.generic[14] <= vec2.generic[14]) ? 0xFF : 0, 4);
	memset(&vec1.generic[15], (vec1.generic[15] <= vec2.generic[15]) ? 0xFF : 0, 4);
	return vec1;
}
# define VUINT32x16_CMPLE_DEFINED
#endif
#if !defined(VUINT32x16_CMPGE_DEFINED)
VEC_FUNC_IMPL vuint32x16 vuint32x16_cmpge(vuint32x16 vec1, vuint32x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] >= vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] >= vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] >= vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] >= vec2.generic[7]) ? 0xFF : 0, 4);
	memset(&vec1.generic[8], (vec1.generic[8] >= vec2.generic[8]) ? 0xFF : 0, 4);
	memset(&vec1.generic[9], (vec1.generic[9] >= vec2.generic[9]) ? 0xFF : 0, 4);
	memset(&vec1.generic[10], (vec1.generic[10] >= vec2.generic[10]) ? 0xFF : 0, 4);
	memset(&vec1.generic[11], (vec1.generic[11] >= vec2.generic[11]) ? 0xFF : 0, 4);
	memset(&vec1.generic[12], (vec1.generic[12] >= vec2.generic[12]) ? 0xFF : 0, 4);
	memset(&vec1.generic[13], (vec1.generic[13] >= vec2.generic[13]) ? 0xFF : 0, 4);
	memset(&vec1.generic[14], (vec1.generic[14] >= vec2.generic[14]) ? 0xFF : 0, 4);
	memset(&vec1.generic[15], (vec1.generic[15] >= vec2.generic[15]) ? 0xFF : 0, 4);
	return vec1;
}
# define VUINT32x16_CMPGE_DEFINED
#endif
#if !defined(VUINT32x16_MIN_DEFINED)
VEC_FUNC_IMPL vuint32x16 vuint32x16_min(vuint32x16 vec1, vuint32x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] < vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] < vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] < vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] < vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] < vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] < vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] < vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] < vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] < vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] < vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] < vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] < vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	return vec1;
}
# define VUINT32x16_MIN_DEFINED
#endif
#if !defined(VUINT32x16_MAX_DEFINED)
VEC_FUNC_IMPL vuint32x16 vuint32x16_max(vuint32x16 vec1, vuint32x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] > vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] > vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] > vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] > vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] > vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] > vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] > vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] > vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] > vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] > vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] > vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] > vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	return vec1;
}
# define VUINT32x16_MAX_DEFINED
#endif
#if !defined(VUINT32x16_RSHIFT_DEFINED)
VEC_FUNC_IMPL vuint32x16 vuint32x16_rshift(vuint32x16 vec1, vuint32x16 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	vec1.generic[4] >>= vec2.generic[0];
	vec1.generic[5] >>= vec2.generic[0];
	vec1.generic[6] >>= vec2.generic[0];
	vec1.generic[7] >>= vec2.generic[0];
	vec1.generic[8] >>= vec2.generic[0];
	vec1.generic[9] >>= vec2.generic[0];
	vec1.generic[10] >>= vec2.generic[0];
	vec1.generic[11] >>= vec2.generic[0];
	vec1.generic[12] >>= vec2.generic[0];
	vec1.generic[13] >>= vec2.generic[0];
	vec1.generic[14] >>= vec2.generic[0];
	vec1.generic[15] >>= vec2.generic[0];
	return vec1;
}
# define VUINT32x16_RSHIFT_DEFINED
#endif
#if !defined(VUINT32x16_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vuint32x16 vuint32x16_lrshift(vuint32x16 vec1, vuint32x16 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	vec1.generic[4] >>= vec2.generic[0];
	vec1.generic[5] >>= vec2.generic[0];
	vec1.generic[6] >>= vec2.generic[0];
	vec1.generic[7] >>= vec2.generic[0];
	vec1.generic[8] >>= vec2.generic[0];
	vec1.generic[9] >>= vec2.generic[0];
	vec1.generic[10] >>= vec2.generic[0];
	vec1.generic[11] >>= vec2.generic[0];
	vec1.generic[12] >>= vec2.generic[0];
	vec1.generic[13] >>= vec2.generic[0];
	vec1.generic[14] >>= vec2.generic[0];
	vec1.generic[15] >>= vec2.generic[0];
	return vec1;
}
# define VUINT32x16_LRSHIFT_DEFINED
#endif
#if !defined(VUINT32x16_LSHIFT_DEFINED)
VEC_FUNC_IMPL vuint32x16 vuint32x16_lshift(vuint32x16 vec1, vuint32x16 vec2)
{
	vec1.generic[0] <<= vec2.generic[0];
	vec1.generic[1] <<= vec2.generic[0];
	vec1.generic[2] <<= vec2.generic[0];
	vec1.generic[3] <<= vec2.generic[0];
	vec1.generic[4] <<= vec2.generic[0];
	vec1.generic[5] <<= vec2.generic[0];
	vec1.generic[6] <<= vec2.generic[0];
	vec1.generic[7] <<= vec2.generic[0];
	vec1.generic[8] <<= vec2.generic[0];
	vec1.generic[9] <<= vec2.generic[0];
	vec1.generic[10] <<= vec2.generic[0];
	vec1.generic[11] <<= vec2.generic[0];
	vec1.generic[12] <<= vec2.generic[0];
	vec1.generic[13] <<= vec2.generic[0];
	vec1.generic[14] <<= vec2.generic[0];
	vec1.generic[15] <<= vec2.generic[0];
	return vec1;
}
# define VUINT32x16_LSHIFT_DEFINED
#endif
#if !defined(VINT64x2_SPLAT_DEFINED)
VEC_FUNC_IMPL vint64x2 vint64x2_splat(vec_int64 x)
{
	vint64x2 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	return vec;
}
# define VINT64x2_SPLAT_DEFINED
#endif
#if !defined(VINT64x2_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vint64x2 vint64x2_load_aligned(const vec_int64 x[2])
{
	vint64x2 vec;
	memcpy(vec.generic, x, 16);
	return vec;
}
# define VINT64x2_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VINT64x2_LOAD_DEFINED)
VEC_FUNC_IMPL vint64x2 vint64x2_load(const vec_int64 x[2])
{
	vint64x2 vec;
	memcpy(vec.generic, x, 16);
	return vec;
}
# define VINT64x2_LOAD_DEFINED
#endif
#if !defined(VINT64x2_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vint64x2_store_aligned(vint64x2 vec, vec_int64 x[2])
{
	memcpy(x, vec.generic, 16);
}
# define VINT64x2_STORE_ALIGNED_DEFINED
#endif
#if !defined(VINT64x2_STORE_DEFINED)
VEC_FUNC_IMPL void vint64x2_store(vint64x2 vec, vec_int64 x[2])
{
	memcpy(x, vec.generic, 16);
}
# define VINT64x2_STORE_DEFINED
#endif
#if !defined(VINT64x2_ADD_DEFINED)
VEC_FUNC_IMPL vint64x2 vint64x2_add(vint64x2 vec1, vint64x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	return vec1;
}
# define VINT64x2_ADD_DEFINED
#endif
#if !defined(VINT64x2_SUB_DEFINED)
VEC_FUNC_IMPL vint64x2 vint64x2_sub(vint64x2 vec1, vint64x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	return vec1;
}
# define VINT64x2_SUB_DEFINED
#endif
#if !defined(VINT64x2_MUL_DEFINED)
VEC_FUNC_IMPL vint64x2 vint64x2_mul(vint64x2 vec1, vint64x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	return vec1;
}
# define VINT64x2_MUL_DEFINED
#endif
#if !defined(VINT64x2_DIV_DEFINED)
VEC_FUNC_IMPL vint64x2 vint64x2_div(vint64x2 vec1, vint64x2 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	return vec1;
}
# define VINT64x2_DIV_DEFINED
#endif
#if !defined(VINT64x2_MOD_DEFINED)
VEC_FUNC_IMPL vint64x2 vint64x2_mod(vint64x2 vec1, vint64x2 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	return vec1;
}
# define VINT64x2_MOD_DEFINED
#endif
#if !defined(VINT64x2_AVG_DEFINED)
VEC_FUNC_IMPL vint64x2 vint64x2_avg(vint64x2 vec1, vint64x2 vec2)
{
	vec_int64 x_d_rem, y_d_rem, rem_d_quot, rem_d_rem;
	x_d_rem = (vec1.generic[0] % 2);
	y_d_rem = (vec2.generic[0] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[0] = ((vec1.generic[0] / 2) + (vec2.generic[0] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[1] % 2);
	y_d_rem = (vec2.generic[1] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[1] = ((vec1.generic[1] / 2) + (vec2.generic[1] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	return vec1;
}
# define VINT64x2_AVG_DEFINED
#endif
#if !defined(VINT64x2_AND_DEFINED)
VEC_FUNC_IMPL vint64x2 vint64x2_and(vint64x2 vec1, vint64x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	return vec1;
}
# define VINT64x2_AND_DEFINED
#endif
#if !defined(VINT64x2_OR_DEFINED)
VEC_FUNC_IMPL vint64x2 vint64x2_or(vint64x2 vec1, vint64x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	return vec1;
}
# define VINT64x2_OR_DEFINED
#endif
#if !defined(VINT64x2_XOR_DEFINED)
VEC_FUNC_IMPL vint64x2 vint64x2_xor(vint64x2 vec1, vint64x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	return vec1;
}
# define VINT64x2_XOR_DEFINED
#endif
#if !defined(VINT64x2_NOT_DEFINED)
VEC_FUNC_IMPL vint64x2 vint64x2_not(vint64x2 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	return vec;
}
# define VINT64x2_NOT_DEFINED
#endif
#if !defined(VINT64x2_CMPLT_DEFINED)
VEC_FUNC_IMPL vint64x2 vint64x2_cmplt(vint64x2 vec1, vint64x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 8);
	return vec1;
}
# define VINT64x2_CMPLT_DEFINED
#endif
#if !defined(VINT64x2_CMPEQ_DEFINED)
VEC_FUNC_IMPL vint64x2 vint64x2_cmpeq(vint64x2 vec1, vint64x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 8);
	return vec1;
}
# define VINT64x2_CMPEQ_DEFINED
#endif
#if !defined(VINT64x2_CMPGT_DEFINED)
VEC_FUNC_IMPL vint64x2 vint64x2_cmpgt(vint64x2 vec1, vint64x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 8);
	return vec1;
}
# define VINT64x2_CMPGT_DEFINED
#endif
#if !defined(VINT64x2_CMPLE_DEFINED)
VEC_FUNC_IMPL vint64x2 vint64x2_cmple(vint64x2 vec1, vint64x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 8);
	return vec1;
}
# define VINT64x2_CMPLE_DEFINED
#endif
#if !defined(VINT64x2_CMPGE_DEFINED)
VEC_FUNC_IMPL vint64x2 vint64x2_cmpge(vint64x2 vec1, vint64x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 8);
	return vec1;
}
# define VINT64x2_CMPGE_DEFINED
#endif
#if !defined(VINT64x2_MIN_DEFINED)
VEC_FUNC_IMPL vint64x2 vint64x2_min(vint64x2 vec1, vint64x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	return vec1;
}
# define VINT64x2_MIN_DEFINED
#endif
#if !defined(VINT64x2_MAX_DEFINED)
VEC_FUNC_IMPL vint64x2 vint64x2_max(vint64x2 vec1, vint64x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	return vec1;
}
# define VINT64x2_MAX_DEFINED
#endif
#if !defined(VINT64x2_RSHIFT_DEFINED)
VEC_FUNC_IMPL vint64x2 vint64x2_rshift(vint64x2 vec1, vuint64x2 vec2)
{
vec1.generic[0] = ((~vec1.generic[0]) >> vec2.generic[0]);
vec1.generic[1] = ((~vec1.generic[1]) >> vec2.generic[1]);
	return vec1;
}
# define VINT64x2_RSHIFT_DEFINED
#endif
#if !defined(VINT64x2_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vint64x2 vint64x2_lrshift(vint64x2 vec1, vuint64x2 vec2)
{
	union { vec_uint64 u; vec_int64 s; } x;

	x.s = vec1.generic[0];
	x.u >>= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u >>= vec2.generic[1];
	vec1.generic[1] = x.s;
	return vec1;
}
# define VINT64x2_LRSHIFT_DEFINED
#endif
#if !defined(VINT64x2_LSHIFT_DEFINED)
VEC_FUNC_IMPL vint64x2 vint64x2_lshift(vint64x2 vec1, vuint64x2 vec2)
{
	union { vec_uint64 u; vec_int64 s; } x;

	x.s = vec1.generic[0];
	x.u <<= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u <<= vec2.generic[1];
	vec1.generic[1] = x.s;
	return vec1;
}
# define VINT64x2_LSHIFT_DEFINED
#endif
#if !defined(VUINT64x2_SPLAT_DEFINED)
VEC_FUNC_IMPL vuint64x2 vuint64x2_splat(vec_uint64 x)
{
	vuint64x2 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	return vec;
}
# define VUINT64x2_SPLAT_DEFINED
#endif
#if !defined(VUINT64x2_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vuint64x2 vuint64x2_load_aligned(const vec_uint64 x[2])
{
	vuint64x2 vec;
	memcpy(vec.generic, x, 16);
	return vec;
}
# define VUINT64x2_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VUINT64x2_LOAD_DEFINED)
VEC_FUNC_IMPL vuint64x2 vuint64x2_load(const vec_uint64 x[2])
{
	vuint64x2 vec;
	memcpy(vec.generic, x, 16);
	return vec;
}
# define VUINT64x2_LOAD_DEFINED
#endif
#if !defined(VUINT64x2_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vuint64x2_store_aligned(vuint64x2 vec, vec_uint64 x[2])
{
	memcpy(x, vec.generic, 16);
}
# define VUINT64x2_STORE_ALIGNED_DEFINED
#endif
#if !defined(VUINT64x2_STORE_DEFINED)
VEC_FUNC_IMPL void vuint64x2_store(vuint64x2 vec, vec_uint64 x[2])
{
	memcpy(x, vec.generic, 16);
}
# define VUINT64x2_STORE_DEFINED
#endif
#if !defined(VUINT64x2_ADD_DEFINED)
VEC_FUNC_IMPL vuint64x2 vuint64x2_add(vuint64x2 vec1, vuint64x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	return vec1;
}
# define VUINT64x2_ADD_DEFINED
#endif
#if !defined(VUINT64x2_SUB_DEFINED)
VEC_FUNC_IMPL vuint64x2 vuint64x2_sub(vuint64x2 vec1, vuint64x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	return vec1;
}
# define VUINT64x2_SUB_DEFINED
#endif
#if !defined(VUINT64x2_MUL_DEFINED)
VEC_FUNC_IMPL vuint64x2 vuint64x2_mul(vuint64x2 vec1, vuint64x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	return vec1;
}
# define VUINT64x2_MUL_DEFINED
#endif
#if !defined(VUINT64x2_DIV_DEFINED)
VEC_FUNC_IMPL vuint64x2 vuint64x2_div(vuint64x2 vec1, vuint64x2 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	return vec1;
}
# define VUINT64x2_DIV_DEFINED
#endif
#if !defined(VUINT64x2_MOD_DEFINED)
VEC_FUNC_IMPL vuint64x2 vuint64x2_mod(vuint64x2 vec1, vuint64x2 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	return vec1;
}
# define VUINT64x2_MOD_DEFINED
#endif
#if !defined(VUINT64x2_AVG_DEFINED)
VEC_FUNC_IMPL vuint64x2 vuint64x2_avg(vuint64x2 vec1, vuint64x2 vec2)
{
vec1.generic[0] = (vec1.generic[0] >> 1) + (vec2.generic[0] >> 1) + ((vec1.generic[0] | vec2.generic[0]) & 1);
vec1.generic[1] = (vec1.generic[1] >> 1) + (vec2.generic[1] >> 1) + ((vec1.generic[1] | vec2.generic[1]) & 1);
	return vec1;
}
# define VUINT64x2_AVG_DEFINED
#endif
#if !defined(VUINT64x2_AND_DEFINED)
VEC_FUNC_IMPL vuint64x2 vuint64x2_and(vuint64x2 vec1, vuint64x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	return vec1;
}
# define VUINT64x2_AND_DEFINED
#endif
#if !defined(VUINT64x2_OR_DEFINED)
VEC_FUNC_IMPL vuint64x2 vuint64x2_or(vuint64x2 vec1, vuint64x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	return vec1;
}
# define VUINT64x2_OR_DEFINED
#endif
#if !defined(VUINT64x2_XOR_DEFINED)
VEC_FUNC_IMPL vuint64x2 vuint64x2_xor(vuint64x2 vec1, vuint64x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	return vec1;
}
# define VUINT64x2_XOR_DEFINED
#endif
#if !defined(VUINT64x2_NOT_DEFINED)
VEC_FUNC_IMPL vuint64x2 vuint64x2_not(vuint64x2 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	return vec;
}
# define VUINT64x2_NOT_DEFINED
#endif
#if !defined(VUINT64x2_CMPLT_DEFINED)
VEC_FUNC_IMPL vuint64x2 vuint64x2_cmplt(vuint64x2 vec1, vuint64x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 8);
	return vec1;
}
# define VUINT64x2_CMPLT_DEFINED
#endif
#if !defined(VUINT64x2_CMPEQ_DEFINED)
VEC_FUNC_IMPL vuint64x2 vuint64x2_cmpeq(vuint64x2 vec1, vuint64x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 8);
	return vec1;
}
# define VUINT64x2_CMPEQ_DEFINED
#endif
#if !defined(VUINT64x2_CMPGT_DEFINED)
VEC_FUNC_IMPL vuint64x2 vuint64x2_cmpgt(vuint64x2 vec1, vuint64x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 8);
	return vec1;
}
# define VUINT64x2_CMPGT_DEFINED
#endif
#if !defined(VUINT64x2_CMPLE_DEFINED)
VEC_FUNC_IMPL vuint64x2 vuint64x2_cmple(vuint64x2 vec1, vuint64x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 8);
	return vec1;
}
# define VUINT64x2_CMPLE_DEFINED
#endif
#if !defined(VUINT64x2_CMPGE_DEFINED)
VEC_FUNC_IMPL vuint64x2 vuint64x2_cmpge(vuint64x2 vec1, vuint64x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 8);
	return vec1;
}
# define VUINT64x2_CMPGE_DEFINED
#endif
#if !defined(VUINT64x2_MIN_DEFINED)
VEC_FUNC_IMPL vuint64x2 vuint64x2_min(vuint64x2 vec1, vuint64x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	return vec1;
}
# define VUINT64x2_MIN_DEFINED
#endif
#if !defined(VUINT64x2_MAX_DEFINED)
VEC_FUNC_IMPL vuint64x2 vuint64x2_max(vuint64x2 vec1, vuint64x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	return vec1;
}
# define VUINT64x2_MAX_DEFINED
#endif
#if !defined(VUINT64x2_RSHIFT_DEFINED)
VEC_FUNC_IMPL vuint64x2 vuint64x2_rshift(vuint64x2 vec1, vuint64x2 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	return vec1;
}
# define VUINT64x2_RSHIFT_DEFINED
#endif
#if !defined(VUINT64x2_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vuint64x2 vuint64x2_lrshift(vuint64x2 vec1, vuint64x2 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	return vec1;
}
# define VUINT64x2_LRSHIFT_DEFINED
#endif
#if !defined(VUINT64x2_LSHIFT_DEFINED)
VEC_FUNC_IMPL vuint64x2 vuint64x2_lshift(vuint64x2 vec1, vuint64x2 vec2)
{
	vec1.generic[0] <<= vec2.generic[0];
	vec1.generic[1] <<= vec2.generic[0];
	return vec1;
}
# define VUINT64x2_LSHIFT_DEFINED
#endif
#if !defined(VINT64x4_SPLAT_DEFINED)
VEC_FUNC_IMPL vint64x4 vint64x4_splat(vec_int64 x)
{
	vint64x4 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	return vec;
}
# define VINT64x4_SPLAT_DEFINED
#endif
#if !defined(VINT64x4_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vint64x4 vint64x4_load_aligned(const vec_int64 x[4])
{
	vint64x4 vec;
	memcpy(vec.generic, x, 32);
	return vec;
}
# define VINT64x4_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VINT64x4_LOAD_DEFINED)
VEC_FUNC_IMPL vint64x4 vint64x4_load(const vec_int64 x[4])
{
	vint64x4 vec;
	memcpy(vec.generic, x, 32);
	return vec;
}
# define VINT64x4_LOAD_DEFINED
#endif
#if !defined(VINT64x4_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vint64x4_store_aligned(vint64x4 vec, vec_int64 x[4])
{
	memcpy(x, vec.generic, 32);
}
# define VINT64x4_STORE_ALIGNED_DEFINED
#endif
#if !defined(VINT64x4_STORE_DEFINED)
VEC_FUNC_IMPL void vint64x4_store(vint64x4 vec, vec_int64 x[4])
{
	memcpy(x, vec.generic, 32);
}
# define VINT64x4_STORE_DEFINED
#endif
#if !defined(VINT64x4_ADD_DEFINED)
VEC_FUNC_IMPL vint64x4 vint64x4_add(vint64x4 vec1, vint64x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	return vec1;
}
# define VINT64x4_ADD_DEFINED
#endif
#if !defined(VINT64x4_SUB_DEFINED)
VEC_FUNC_IMPL vint64x4 vint64x4_sub(vint64x4 vec1, vint64x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	return vec1;
}
# define VINT64x4_SUB_DEFINED
#endif
#if !defined(VINT64x4_MUL_DEFINED)
VEC_FUNC_IMPL vint64x4 vint64x4_mul(vint64x4 vec1, vint64x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	return vec1;
}
# define VINT64x4_MUL_DEFINED
#endif
#if !defined(VINT64x4_DIV_DEFINED)
VEC_FUNC_IMPL vint64x4 vint64x4_div(vint64x4 vec1, vint64x4 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	return vec1;
}
# define VINT64x4_DIV_DEFINED
#endif
#if !defined(VINT64x4_MOD_DEFINED)
VEC_FUNC_IMPL vint64x4 vint64x4_mod(vint64x4 vec1, vint64x4 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	return vec1;
}
# define VINT64x4_MOD_DEFINED
#endif
#if !defined(VINT64x4_AVG_DEFINED)
VEC_FUNC_IMPL vint64x4 vint64x4_avg(vint64x4 vec1, vint64x4 vec2)
{
	vec_int64 x_d_rem, y_d_rem, rem_d_quot, rem_d_rem;
	x_d_rem = (vec1.generic[0] % 2);
	y_d_rem = (vec2.generic[0] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[0] = ((vec1.generic[0] / 2) + (vec2.generic[0] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[1] % 2);
	y_d_rem = (vec2.generic[1] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[1] = ((vec1.generic[1] / 2) + (vec2.generic[1] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[2] % 2);
	y_d_rem = (vec2.generic[2] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[2] = ((vec1.generic[2] / 2) + (vec2.generic[2] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[3] % 2);
	y_d_rem = (vec2.generic[3] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[3] = ((vec1.generic[3] / 2) + (vec2.generic[3] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	return vec1;
}
# define VINT64x4_AVG_DEFINED
#endif
#if !defined(VINT64x4_AND_DEFINED)
VEC_FUNC_IMPL vint64x4 vint64x4_and(vint64x4 vec1, vint64x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	return vec1;
}
# define VINT64x4_AND_DEFINED
#endif
#if !defined(VINT64x4_OR_DEFINED)
VEC_FUNC_IMPL vint64x4 vint64x4_or(vint64x4 vec1, vint64x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	return vec1;
}
# define VINT64x4_OR_DEFINED
#endif
#if !defined(VINT64x4_XOR_DEFINED)
VEC_FUNC_IMPL vint64x4 vint64x4_xor(vint64x4 vec1, vint64x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	return vec1;
}
# define VINT64x4_XOR_DEFINED
#endif
#if !defined(VINT64x4_NOT_DEFINED)
VEC_FUNC_IMPL vint64x4 vint64x4_not(vint64x4 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	return vec;
}
# define VINT64x4_NOT_DEFINED
#endif
#if !defined(VINT64x4_CMPLT_DEFINED)
VEC_FUNC_IMPL vint64x4 vint64x4_cmplt(vint64x4 vec1, vint64x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 8);
	return vec1;
}
# define VINT64x4_CMPLT_DEFINED
#endif
#if !defined(VINT64x4_CMPEQ_DEFINED)
VEC_FUNC_IMPL vint64x4 vint64x4_cmpeq(vint64x4 vec1, vint64x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 8);
	return vec1;
}
# define VINT64x4_CMPEQ_DEFINED
#endif
#if !defined(VINT64x4_CMPGT_DEFINED)
VEC_FUNC_IMPL vint64x4 vint64x4_cmpgt(vint64x4 vec1, vint64x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 8);
	return vec1;
}
# define VINT64x4_CMPGT_DEFINED
#endif
#if !defined(VINT64x4_CMPLE_DEFINED)
VEC_FUNC_IMPL vint64x4 vint64x4_cmple(vint64x4 vec1, vint64x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 8);
	return vec1;
}
# define VINT64x4_CMPLE_DEFINED
#endif
#if !defined(VINT64x4_CMPGE_DEFINED)
VEC_FUNC_IMPL vint64x4 vint64x4_cmpge(vint64x4 vec1, vint64x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 8);
	return vec1;
}
# define VINT64x4_CMPGE_DEFINED
#endif
#if !defined(VINT64x4_MIN_DEFINED)
VEC_FUNC_IMPL vint64x4 vint64x4_min(vint64x4 vec1, vint64x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	return vec1;
}
# define VINT64x4_MIN_DEFINED
#endif
#if !defined(VINT64x4_MAX_DEFINED)
VEC_FUNC_IMPL vint64x4 vint64x4_max(vint64x4 vec1, vint64x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	return vec1;
}
# define VINT64x4_MAX_DEFINED
#endif
#if !defined(VINT64x4_RSHIFT_DEFINED)
VEC_FUNC_IMPL vint64x4 vint64x4_rshift(vint64x4 vec1, vuint64x4 vec2)
{
vec1.generic[0] = ((~vec1.generic[0]) >> vec2.generic[0]);
vec1.generic[1] = ((~vec1.generic[1]) >> vec2.generic[1]);
vec1.generic[2] = ((~vec1.generic[2]) >> vec2.generic[2]);
vec1.generic[3] = ((~vec1.generic[3]) >> vec2.generic[3]);
	return vec1;
}
# define VINT64x4_RSHIFT_DEFINED
#endif
#if !defined(VINT64x4_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vint64x4 vint64x4_lrshift(vint64x4 vec1, vuint64x4 vec2)
{
	union { vec_uint64 u; vec_int64 s; } x;

	x.s = vec1.generic[0];
	x.u >>= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u >>= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u >>= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u >>= vec2.generic[3];
	vec1.generic[3] = x.s;
	return vec1;
}
# define VINT64x4_LRSHIFT_DEFINED
#endif
#if !defined(VINT64x4_LSHIFT_DEFINED)
VEC_FUNC_IMPL vint64x4 vint64x4_lshift(vint64x4 vec1, vuint64x4 vec2)
{
	union { vec_uint64 u; vec_int64 s; } x;

	x.s = vec1.generic[0];
	x.u <<= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u <<= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u <<= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u <<= vec2.generic[3];
	vec1.generic[3] = x.s;
	return vec1;
}
# define VINT64x4_LSHIFT_DEFINED
#endif
#if !defined(VUINT64x4_SPLAT_DEFINED)
VEC_FUNC_IMPL vuint64x4 vuint64x4_splat(vec_uint64 x)
{
	vuint64x4 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	return vec;
}
# define VUINT64x4_SPLAT_DEFINED
#endif
#if !defined(VUINT64x4_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vuint64x4 vuint64x4_load_aligned(const vec_uint64 x[4])
{
	vuint64x4 vec;
	memcpy(vec.generic, x, 32);
	return vec;
}
# define VUINT64x4_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VUINT64x4_LOAD_DEFINED)
VEC_FUNC_IMPL vuint64x4 vuint64x4_load(const vec_uint64 x[4])
{
	vuint64x4 vec;
	memcpy(vec.generic, x, 32);
	return vec;
}
# define VUINT64x4_LOAD_DEFINED
#endif
#if !defined(VUINT64x4_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vuint64x4_store_aligned(vuint64x4 vec, vec_uint64 x[4])
{
	memcpy(x, vec.generic, 32);
}
# define VUINT64x4_STORE_ALIGNED_DEFINED
#endif
#if !defined(VUINT64x4_STORE_DEFINED)
VEC_FUNC_IMPL void vuint64x4_store(vuint64x4 vec, vec_uint64 x[4])
{
	memcpy(x, vec.generic, 32);
}
# define VUINT64x4_STORE_DEFINED
#endif
#if !defined(VUINT64x4_ADD_DEFINED)
VEC_FUNC_IMPL vuint64x4 vuint64x4_add(vuint64x4 vec1, vuint64x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	return vec1;
}
# define VUINT64x4_ADD_DEFINED
#endif
#if !defined(VUINT64x4_SUB_DEFINED)
VEC_FUNC_IMPL vuint64x4 vuint64x4_sub(vuint64x4 vec1, vuint64x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	return vec1;
}
# define VUINT64x4_SUB_DEFINED
#endif
#if !defined(VUINT64x4_MUL_DEFINED)
VEC_FUNC_IMPL vuint64x4 vuint64x4_mul(vuint64x4 vec1, vuint64x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	return vec1;
}
# define VUINT64x4_MUL_DEFINED
#endif
#if !defined(VUINT64x4_DIV_DEFINED)
VEC_FUNC_IMPL vuint64x4 vuint64x4_div(vuint64x4 vec1, vuint64x4 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	return vec1;
}
# define VUINT64x4_DIV_DEFINED
#endif
#if !defined(VUINT64x4_MOD_DEFINED)
VEC_FUNC_IMPL vuint64x4 vuint64x4_mod(vuint64x4 vec1, vuint64x4 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	return vec1;
}
# define VUINT64x4_MOD_DEFINED
#endif
#if !defined(VUINT64x4_AVG_DEFINED)
VEC_FUNC_IMPL vuint64x4 vuint64x4_avg(vuint64x4 vec1, vuint64x4 vec2)
{
vec1.generic[0] = (vec1.generic[0] >> 1) + (vec2.generic[0] >> 1) + ((vec1.generic[0] | vec2.generic[0]) & 1);
vec1.generic[1] = (vec1.generic[1] >> 1) + (vec2.generic[1] >> 1) + ((vec1.generic[1] | vec2.generic[1]) & 1);
vec1.generic[2] = (vec1.generic[2] >> 1) + (vec2.generic[2] >> 1) + ((vec1.generic[2] | vec2.generic[2]) & 1);
vec1.generic[3] = (vec1.generic[3] >> 1) + (vec2.generic[3] >> 1) + ((vec1.generic[3] | vec2.generic[3]) & 1);
	return vec1;
}
# define VUINT64x4_AVG_DEFINED
#endif
#if !defined(VUINT64x4_AND_DEFINED)
VEC_FUNC_IMPL vuint64x4 vuint64x4_and(vuint64x4 vec1, vuint64x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	return vec1;
}
# define VUINT64x4_AND_DEFINED
#endif
#if !defined(VUINT64x4_OR_DEFINED)
VEC_FUNC_IMPL vuint64x4 vuint64x4_or(vuint64x4 vec1, vuint64x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	return vec1;
}
# define VUINT64x4_OR_DEFINED
#endif
#if !defined(VUINT64x4_XOR_DEFINED)
VEC_FUNC_IMPL vuint64x4 vuint64x4_xor(vuint64x4 vec1, vuint64x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	return vec1;
}
# define VUINT64x4_XOR_DEFINED
#endif
#if !defined(VUINT64x4_NOT_DEFINED)
VEC_FUNC_IMPL vuint64x4 vuint64x4_not(vuint64x4 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	return vec;
}
# define VUINT64x4_NOT_DEFINED
#endif
#if !defined(VUINT64x4_CMPLT_DEFINED)
VEC_FUNC_IMPL vuint64x4 vuint64x4_cmplt(vuint64x4 vec1, vuint64x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 8);
	return vec1;
}
# define VUINT64x4_CMPLT_DEFINED
#endif
#if !defined(VUINT64x4_CMPEQ_DEFINED)
VEC_FUNC_IMPL vuint64x4 vuint64x4_cmpeq(vuint64x4 vec1, vuint64x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 8);
	return vec1;
}
# define VUINT64x4_CMPEQ_DEFINED
#endif
#if !defined(VUINT64x4_CMPGT_DEFINED)
VEC_FUNC_IMPL vuint64x4 vuint64x4_cmpgt(vuint64x4 vec1, vuint64x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 8);
	return vec1;
}
# define VUINT64x4_CMPGT_DEFINED
#endif
#if !defined(VUINT64x4_CMPLE_DEFINED)
VEC_FUNC_IMPL vuint64x4 vuint64x4_cmple(vuint64x4 vec1, vuint64x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 8);
	return vec1;
}
# define VUINT64x4_CMPLE_DEFINED
#endif
#if !defined(VUINT64x4_CMPGE_DEFINED)
VEC_FUNC_IMPL vuint64x4 vuint64x4_cmpge(vuint64x4 vec1, vuint64x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 8);
	return vec1;
}
# define VUINT64x4_CMPGE_DEFINED
#endif
#if !defined(VUINT64x4_MIN_DEFINED)
VEC_FUNC_IMPL vuint64x4 vuint64x4_min(vuint64x4 vec1, vuint64x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	return vec1;
}
# define VUINT64x4_MIN_DEFINED
#endif
#if !defined(VUINT64x4_MAX_DEFINED)
VEC_FUNC_IMPL vuint64x4 vuint64x4_max(vuint64x4 vec1, vuint64x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	return vec1;
}
# define VUINT64x4_MAX_DEFINED
#endif
#if !defined(VUINT64x4_RSHIFT_DEFINED)
VEC_FUNC_IMPL vuint64x4 vuint64x4_rshift(vuint64x4 vec1, vuint64x4 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	return vec1;
}
# define VUINT64x4_RSHIFT_DEFINED
#endif
#if !defined(VUINT64x4_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vuint64x4 vuint64x4_lrshift(vuint64x4 vec1, vuint64x4 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	return vec1;
}
# define VUINT64x4_LRSHIFT_DEFINED
#endif
#if !defined(VUINT64x4_LSHIFT_DEFINED)
VEC_FUNC_IMPL vuint64x4 vuint64x4_lshift(vuint64x4 vec1, vuint64x4 vec2)
{
	vec1.generic[0] <<= vec2.generic[0];
	vec1.generic[1] <<= vec2.generic[0];
	vec1.generic[2] <<= vec2.generic[0];
	vec1.generic[3] <<= vec2.generic[0];
	return vec1;
}
# define VUINT64x4_LSHIFT_DEFINED
#endif
#if !defined(VINT64x8_SPLAT_DEFINED)
VEC_FUNC_IMPL vint64x8 vint64x8_splat(vec_int64 x)
{
	vint64x8 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	vec.generic[4] = x;
	vec.generic[5] = x;
	vec.generic[6] = x;
	vec.generic[7] = x;
	return vec;
}
# define VINT64x8_SPLAT_DEFINED
#endif
#if !defined(VINT64x8_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vint64x8 vint64x8_load_aligned(const vec_int64 x[8])
{
	vint64x8 vec;
	memcpy(vec.generic, x, 64);
	return vec;
}
# define VINT64x8_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VINT64x8_LOAD_DEFINED)
VEC_FUNC_IMPL vint64x8 vint64x8_load(const vec_int64 x[8])
{
	vint64x8 vec;
	memcpy(vec.generic, x, 64);
	return vec;
}
# define VINT64x8_LOAD_DEFINED
#endif
#if !defined(VINT64x8_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vint64x8_store_aligned(vint64x8 vec, vec_int64 x[8])
{
	memcpy(x, vec.generic, 64);
}
# define VINT64x8_STORE_ALIGNED_DEFINED
#endif
#if !defined(VINT64x8_STORE_DEFINED)
VEC_FUNC_IMPL void vint64x8_store(vint64x8 vec, vec_int64 x[8])
{
	memcpy(x, vec.generic, 64);
}
# define VINT64x8_STORE_DEFINED
#endif
#if !defined(VINT64x8_ADD_DEFINED)
VEC_FUNC_IMPL vint64x8 vint64x8_add(vint64x8 vec1, vint64x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]);
	return vec1;
}
# define VINT64x8_ADD_DEFINED
#endif
#if !defined(VINT64x8_SUB_DEFINED)
VEC_FUNC_IMPL vint64x8 vint64x8_sub(vint64x8 vec1, vint64x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] - vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] - vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] - vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] - vec2.generic[7]);
	return vec1;
}
# define VINT64x8_SUB_DEFINED
#endif
#if !defined(VINT64x8_MUL_DEFINED)
VEC_FUNC_IMPL vint64x8 vint64x8_mul(vint64x8 vec1, vint64x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] * vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] * vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] * vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] * vec2.generic[7]);
	return vec1;
}
# define VINT64x8_MUL_DEFINED
#endif
#if !defined(VINT64x8_DIV_DEFINED)
VEC_FUNC_IMPL vint64x8 vint64x8_div(vint64x8 vec1, vint64x8 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] / vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] / vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] / vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] / vec2.generic[7]) : 0);
	return vec1;
}
# define VINT64x8_DIV_DEFINED
#endif
#if !defined(VINT64x8_MOD_DEFINED)
VEC_FUNC_IMPL vint64x8 vint64x8_mod(vint64x8 vec1, vint64x8 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] % vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] % vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] % vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] % vec2.generic[7]) : 0);
	return vec1;
}
# define VINT64x8_MOD_DEFINED
#endif
#if !defined(VINT64x8_AVG_DEFINED)
VEC_FUNC_IMPL vint64x8 vint64x8_avg(vint64x8 vec1, vint64x8 vec2)
{
	vec_int64 x_d_rem, y_d_rem, rem_d_quot, rem_d_rem;
	x_d_rem = (vec1.generic[0] % 2);
	y_d_rem = (vec2.generic[0] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[0] = ((vec1.generic[0] / 2) + (vec2.generic[0] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[1] % 2);
	y_d_rem = (vec2.generic[1] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[1] = ((vec1.generic[1] / 2) + (vec2.generic[1] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[2] % 2);
	y_d_rem = (vec2.generic[2] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[2] = ((vec1.generic[2] / 2) + (vec2.generic[2] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[3] % 2);
	y_d_rem = (vec2.generic[3] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[3] = ((vec1.generic[3] / 2) + (vec2.generic[3] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[4] % 2);
	y_d_rem = (vec2.generic[4] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[4] = ((vec1.generic[4] / 2) + (vec2.generic[4] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[5] % 2);
	y_d_rem = (vec2.generic[5] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[5] = ((vec1.generic[5] / 2) + (vec2.generic[5] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[6] % 2);
	y_d_rem = (vec2.generic[6] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[6] = ((vec1.generic[6] / 2) + (vec2.generic[6] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	x_d_rem = (vec1.generic[7] % 2);
	y_d_rem = (vec2.generic[7] % 2);
	rem_d_quot = ((x_d_rem + y_d_rem) / 2);
	rem_d_rem = ((x_d_rem + y_d_rem) % 2);

	vec1.generic[7] = ((vec1.generic[7] / 2) + (vec2.generic[7] / 2)) + (rem_d_quot) + (rem_d_rem == 1);
	return vec1;
}
# define VINT64x8_AVG_DEFINED
#endif
#if !defined(VINT64x8_AND_DEFINED)
VEC_FUNC_IMPL vint64x8 vint64x8_and(vint64x8 vec1, vint64x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] & vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] & vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] & vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] & vec2.generic[7]);
	return vec1;
}
# define VINT64x8_AND_DEFINED
#endif
#if !defined(VINT64x8_OR_DEFINED)
VEC_FUNC_IMPL vint64x8 vint64x8_or(vint64x8 vec1, vint64x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] | vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] | vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] | vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] | vec2.generic[7]);
	return vec1;
}
# define VINT64x8_OR_DEFINED
#endif
#if !defined(VINT64x8_XOR_DEFINED)
VEC_FUNC_IMPL vint64x8 vint64x8_xor(vint64x8 vec1, vint64x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] ^ vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] ^ vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] ^ vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] ^ vec2.generic[7]);
	return vec1;
}
# define VINT64x8_XOR_DEFINED
#endif
#if !defined(VINT64x8_NOT_DEFINED)
VEC_FUNC_IMPL vint64x8 vint64x8_not(vint64x8 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	vec.generic[4] = ~vec.generic[4];
	vec.generic[5] = ~vec.generic[5];
	vec.generic[6] = ~vec.generic[6];
	vec.generic[7] = ~vec.generic[7];
	return vec;
}
# define VINT64x8_NOT_DEFINED
#endif
#if !defined(VINT64x8_CMPLT_DEFINED)
VEC_FUNC_IMPL vint64x8 vint64x8_cmplt(vint64x8 vec1, vint64x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 8);
	memset(&vec1.generic[4], (vec1.generic[4] < vec2.generic[4]) ? 0xFF : 0, 8);
	memset(&vec1.generic[5], (vec1.generic[5] < vec2.generic[5]) ? 0xFF : 0, 8);
	memset(&vec1.generic[6], (vec1.generic[6] < vec2.generic[6]) ? 0xFF : 0, 8);
	memset(&vec1.generic[7], (vec1.generic[7] < vec2.generic[7]) ? 0xFF : 0, 8);
	return vec1;
}
# define VINT64x8_CMPLT_DEFINED
#endif
#if !defined(VINT64x8_CMPEQ_DEFINED)
VEC_FUNC_IMPL vint64x8 vint64x8_cmpeq(vint64x8 vec1, vint64x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 8);
	memset(&vec1.generic[4], (vec1.generic[4] == vec2.generic[4]) ? 0xFF : 0, 8);
	memset(&vec1.generic[5], (vec1.generic[5] == vec2.generic[5]) ? 0xFF : 0, 8);
	memset(&vec1.generic[6], (vec1.generic[6] == vec2.generic[6]) ? 0xFF : 0, 8);
	memset(&vec1.generic[7], (vec1.generic[7] == vec2.generic[7]) ? 0xFF : 0, 8);
	return vec1;
}
# define VINT64x8_CMPEQ_DEFINED
#endif
#if !defined(VINT64x8_CMPGT_DEFINED)
VEC_FUNC_IMPL vint64x8 vint64x8_cmpgt(vint64x8 vec1, vint64x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 8);
	memset(&vec1.generic[4], (vec1.generic[4] > vec2.generic[4]) ? 0xFF : 0, 8);
	memset(&vec1.generic[5], (vec1.generic[5] > vec2.generic[5]) ? 0xFF : 0, 8);
	memset(&vec1.generic[6], (vec1.generic[6] > vec2.generic[6]) ? 0xFF : 0, 8);
	memset(&vec1.generic[7], (vec1.generic[7] > vec2.generic[7]) ? 0xFF : 0, 8);
	return vec1;
}
# define VINT64x8_CMPGT_DEFINED
#endif
#if !defined(VINT64x8_CMPLE_DEFINED)
VEC_FUNC_IMPL vint64x8 vint64x8_cmple(vint64x8 vec1, vint64x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 8);
	memset(&vec1.generic[4], (vec1.generic[4] <= vec2.generic[4]) ? 0xFF : 0, 8);
	memset(&vec1.generic[5], (vec1.generic[5] <= vec2.generic[5]) ? 0xFF : 0, 8);
	memset(&vec1.generic[6], (vec1.generic[6] <= vec2.generic[6]) ? 0xFF : 0, 8);
	memset(&vec1.generic[7], (vec1.generic[7] <= vec2.generic[7]) ? 0xFF : 0, 8);
	return vec1;
}
# define VINT64x8_CMPLE_DEFINED
#endif
#if !defined(VINT64x8_CMPGE_DEFINED)
VEC_FUNC_IMPL vint64x8 vint64x8_cmpge(vint64x8 vec1, vint64x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 8);
	memset(&vec1.generic[4], (vec1.generic[4] >= vec2.generic[4]) ? 0xFF : 0, 8);
	memset(&vec1.generic[5], (vec1.generic[5] >= vec2.generic[5]) ? 0xFF : 0, 8);
	memset(&vec1.generic[6], (vec1.generic[6] >= vec2.generic[6]) ? 0xFF : 0, 8);
	memset(&vec1.generic[7], (vec1.generic[7] >= vec2.generic[7]) ? 0xFF : 0, 8);
	return vec1;
}
# define VINT64x8_CMPGE_DEFINED
#endif
#if !defined(VINT64x8_MIN_DEFINED)
VEC_FUNC_IMPL vint64x8 vint64x8_min(vint64x8 vec1, vint64x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] < vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] < vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] < vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] < vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	return vec1;
}
# define VINT64x8_MIN_DEFINED
#endif
#if !defined(VINT64x8_MAX_DEFINED)
VEC_FUNC_IMPL vint64x8 vint64x8_max(vint64x8 vec1, vint64x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] > vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] > vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] > vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] > vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	return vec1;
}
# define VINT64x8_MAX_DEFINED
#endif
#if !defined(VINT64x8_RSHIFT_DEFINED)
VEC_FUNC_IMPL vint64x8 vint64x8_rshift(vint64x8 vec1, vuint64x8 vec2)
{
vec1.generic[0] = ((~vec1.generic[0]) >> vec2.generic[0]);
vec1.generic[1] = ((~vec1.generic[1]) >> vec2.generic[1]);
vec1.generic[2] = ((~vec1.generic[2]) >> vec2.generic[2]);
vec1.generic[3] = ((~vec1.generic[3]) >> vec2.generic[3]);
vec1.generic[4] = ((~vec1.generic[4]) >> vec2.generic[4]);
vec1.generic[5] = ((~vec1.generic[5]) >> vec2.generic[5]);
vec1.generic[6] = ((~vec1.generic[6]) >> vec2.generic[6]);
vec1.generic[7] = ((~vec1.generic[7]) >> vec2.generic[7]);
	return vec1;
}
# define VINT64x8_RSHIFT_DEFINED
#endif
#if !defined(VINT64x8_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vint64x8 vint64x8_lrshift(vint64x8 vec1, vuint64x8 vec2)
{
	union { vec_uint64 u; vec_int64 s; } x;

	x.s = vec1.generic[0];
	x.u >>= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u >>= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u >>= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u >>= vec2.generic[3];
	vec1.generic[3] = x.s;
	x.s = vec1.generic[4];
	x.u >>= vec2.generic[4];
	vec1.generic[4] = x.s;
	x.s = vec1.generic[5];
	x.u >>= vec2.generic[5];
	vec1.generic[5] = x.s;
	x.s = vec1.generic[6];
	x.u >>= vec2.generic[6];
	vec1.generic[6] = x.s;
	x.s = vec1.generic[7];
	x.u >>= vec2.generic[7];
	vec1.generic[7] = x.s;
	return vec1;
}
# define VINT64x8_LRSHIFT_DEFINED
#endif
#if !defined(VINT64x8_LSHIFT_DEFINED)
VEC_FUNC_IMPL vint64x8 vint64x8_lshift(vint64x8 vec1, vuint64x8 vec2)
{
	union { vec_uint64 u; vec_int64 s; } x;

	x.s = vec1.generic[0];
	x.u <<= vec2.generic[0];
	vec1.generic[0] = x.s;
	x.s = vec1.generic[1];
	x.u <<= vec2.generic[1];
	vec1.generic[1] = x.s;
	x.s = vec1.generic[2];
	x.u <<= vec2.generic[2];
	vec1.generic[2] = x.s;
	x.s = vec1.generic[3];
	x.u <<= vec2.generic[3];
	vec1.generic[3] = x.s;
	x.s = vec1.generic[4];
	x.u <<= vec2.generic[4];
	vec1.generic[4] = x.s;
	x.s = vec1.generic[5];
	x.u <<= vec2.generic[5];
	vec1.generic[5] = x.s;
	x.s = vec1.generic[6];
	x.u <<= vec2.generic[6];
	vec1.generic[6] = x.s;
	x.s = vec1.generic[7];
	x.u <<= vec2.generic[7];
	vec1.generic[7] = x.s;
	return vec1;
}
# define VINT64x8_LSHIFT_DEFINED
#endif
#if !defined(VUINT64x8_SPLAT_DEFINED)
VEC_FUNC_IMPL vuint64x8 vuint64x8_splat(vec_uint64 x)
{
	vuint64x8 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	vec.generic[4] = x;
	vec.generic[5] = x;
	vec.generic[6] = x;
	vec.generic[7] = x;
	return vec;
}
# define VUINT64x8_SPLAT_DEFINED
#endif
#if !defined(VUINT64x8_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vuint64x8 vuint64x8_load_aligned(const vec_uint64 x[8])
{
	vuint64x8 vec;
	memcpy(vec.generic, x, 64);
	return vec;
}
# define VUINT64x8_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VUINT64x8_LOAD_DEFINED)
VEC_FUNC_IMPL vuint64x8 vuint64x8_load(const vec_uint64 x[8])
{
	vuint64x8 vec;
	memcpy(vec.generic, x, 64);
	return vec;
}
# define VUINT64x8_LOAD_DEFINED
#endif
#if !defined(VUINT64x8_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vuint64x8_store_aligned(vuint64x8 vec, vec_uint64 x[8])
{
	memcpy(x, vec.generic, 64);
}
# define VUINT64x8_STORE_ALIGNED_DEFINED
#endif
#if !defined(VUINT64x8_STORE_DEFINED)
VEC_FUNC_IMPL void vuint64x8_store(vuint64x8 vec, vec_uint64 x[8])
{
	memcpy(x, vec.generic, 64);
}
# define VUINT64x8_STORE_DEFINED
#endif
#if !defined(VUINT64x8_ADD_DEFINED)
VEC_FUNC_IMPL vuint64x8 vuint64x8_add(vuint64x8 vec1, vuint64x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]);
	return vec1;
}
# define VUINT64x8_ADD_DEFINED
#endif
#if !defined(VUINT64x8_SUB_DEFINED)
VEC_FUNC_IMPL vuint64x8 vuint64x8_sub(vuint64x8 vec1, vuint64x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] - vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] - vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] - vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] - vec2.generic[7]);
	return vec1;
}
# define VUINT64x8_SUB_DEFINED
#endif
#if !defined(VUINT64x8_MUL_DEFINED)
VEC_FUNC_IMPL vuint64x8 vuint64x8_mul(vuint64x8 vec1, vuint64x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] * vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] * vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] * vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] * vec2.generic[7]);
	return vec1;
}
# define VUINT64x8_MUL_DEFINED
#endif
#if !defined(VUINT64x8_DIV_DEFINED)
VEC_FUNC_IMPL vuint64x8 vuint64x8_div(vuint64x8 vec1, vuint64x8 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] / vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] / vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] / vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] / vec2.generic[7]) : 0);
	return vec1;
}
# define VUINT64x8_DIV_DEFINED
#endif
#if !defined(VUINT64x8_MOD_DEFINED)
VEC_FUNC_IMPL vuint64x8 vuint64x8_mod(vuint64x8 vec1, vuint64x8 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] % vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] % vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] % vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] % vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] % vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] % vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] % vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] % vec2.generic[7]) : 0);
	return vec1;
}
# define VUINT64x8_MOD_DEFINED
#endif
#if !defined(VUINT64x8_AVG_DEFINED)
VEC_FUNC_IMPL vuint64x8 vuint64x8_avg(vuint64x8 vec1, vuint64x8 vec2)
{
vec1.generic[0] = (vec1.generic[0] >> 1) + (vec2.generic[0] >> 1) + ((vec1.generic[0] | vec2.generic[0]) & 1);
vec1.generic[1] = (vec1.generic[1] >> 1) + (vec2.generic[1] >> 1) + ((vec1.generic[1] | vec2.generic[1]) & 1);
vec1.generic[2] = (vec1.generic[2] >> 1) + (vec2.generic[2] >> 1) + ((vec1.generic[2] | vec2.generic[2]) & 1);
vec1.generic[3] = (vec1.generic[3] >> 1) + (vec2.generic[3] >> 1) + ((vec1.generic[3] | vec2.generic[3]) & 1);
vec1.generic[4] = (vec1.generic[4] >> 1) + (vec2.generic[4] >> 1) + ((vec1.generic[4] | vec2.generic[4]) & 1);
vec1.generic[5] = (vec1.generic[5] >> 1) + (vec2.generic[5] >> 1) + ((vec1.generic[5] | vec2.generic[5]) & 1);
vec1.generic[6] = (vec1.generic[6] >> 1) + (vec2.generic[6] >> 1) + ((vec1.generic[6] | vec2.generic[6]) & 1);
vec1.generic[7] = (vec1.generic[7] >> 1) + (vec2.generic[7] >> 1) + ((vec1.generic[7] | vec2.generic[7]) & 1);
	return vec1;
}
# define VUINT64x8_AVG_DEFINED
#endif
#if !defined(VUINT64x8_AND_DEFINED)
VEC_FUNC_IMPL vuint64x8 vuint64x8_and(vuint64x8 vec1, vuint64x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] & vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] & vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] & vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] & vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] & vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] & vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] & vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] & vec2.generic[7]);
	return vec1;
}
# define VUINT64x8_AND_DEFINED
#endif
#if !defined(VUINT64x8_OR_DEFINED)
VEC_FUNC_IMPL vuint64x8 vuint64x8_or(vuint64x8 vec1, vuint64x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] | vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] | vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] | vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] | vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] | vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] | vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] | vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] | vec2.generic[7]);
	return vec1;
}
# define VUINT64x8_OR_DEFINED
#endif
#if !defined(VUINT64x8_XOR_DEFINED)
VEC_FUNC_IMPL vuint64x8 vuint64x8_xor(vuint64x8 vec1, vuint64x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] ^ vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] ^ vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] ^ vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] ^ vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] ^ vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] ^ vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] ^ vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] ^ vec2.generic[7]);
	return vec1;
}
# define VUINT64x8_XOR_DEFINED
#endif
#if !defined(VUINT64x8_NOT_DEFINED)
VEC_FUNC_IMPL vuint64x8 vuint64x8_not(vuint64x8 vec)
{
	vec.generic[0] = ~vec.generic[0];
	vec.generic[1] = ~vec.generic[1];
	vec.generic[2] = ~vec.generic[2];
	vec.generic[3] = ~vec.generic[3];
	vec.generic[4] = ~vec.generic[4];
	vec.generic[5] = ~vec.generic[5];
	vec.generic[6] = ~vec.generic[6];
	vec.generic[7] = ~vec.generic[7];
	return vec;
}
# define VUINT64x8_NOT_DEFINED
#endif
#if !defined(VUINT64x8_CMPLT_DEFINED)
VEC_FUNC_IMPL vuint64x8 vuint64x8_cmplt(vuint64x8 vec1, vuint64x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 8);
	memset(&vec1.generic[4], (vec1.generic[4] < vec2.generic[4]) ? 0xFF : 0, 8);
	memset(&vec1.generic[5], (vec1.generic[5] < vec2.generic[5]) ? 0xFF : 0, 8);
	memset(&vec1.generic[6], (vec1.generic[6] < vec2.generic[6]) ? 0xFF : 0, 8);
	memset(&vec1.generic[7], (vec1.generic[7] < vec2.generic[7]) ? 0xFF : 0, 8);
	return vec1;
}
# define VUINT64x8_CMPLT_DEFINED
#endif
#if !defined(VUINT64x8_CMPEQ_DEFINED)
VEC_FUNC_IMPL vuint64x8 vuint64x8_cmpeq(vuint64x8 vec1, vuint64x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 8);
	memset(&vec1.generic[4], (vec1.generic[4] == vec2.generic[4]) ? 0xFF : 0, 8);
	memset(&vec1.generic[5], (vec1.generic[5] == vec2.generic[5]) ? 0xFF : 0, 8);
	memset(&vec1.generic[6], (vec1.generic[6] == vec2.generic[6]) ? 0xFF : 0, 8);
	memset(&vec1.generic[7], (vec1.generic[7] == vec2.generic[7]) ? 0xFF : 0, 8);
	return vec1;
}
# define VUINT64x8_CMPEQ_DEFINED
#endif
#if !defined(VUINT64x8_CMPGT_DEFINED)
VEC_FUNC_IMPL vuint64x8 vuint64x8_cmpgt(vuint64x8 vec1, vuint64x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 8);
	memset(&vec1.generic[4], (vec1.generic[4] > vec2.generic[4]) ? 0xFF : 0, 8);
	memset(&vec1.generic[5], (vec1.generic[5] > vec2.generic[5]) ? 0xFF : 0, 8);
	memset(&vec1.generic[6], (vec1.generic[6] > vec2.generic[6]) ? 0xFF : 0, 8);
	memset(&vec1.generic[7], (vec1.generic[7] > vec2.generic[7]) ? 0xFF : 0, 8);
	return vec1;
}
# define VUINT64x8_CMPGT_DEFINED
#endif
#if !defined(VUINT64x8_CMPLE_DEFINED)
VEC_FUNC_IMPL vuint64x8 vuint64x8_cmple(vuint64x8 vec1, vuint64x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 8);
	memset(&vec1.generic[4], (vec1.generic[4] <= vec2.generic[4]) ? 0xFF : 0, 8);
	memset(&vec1.generic[5], (vec1.generic[5] <= vec2.generic[5]) ? 0xFF : 0, 8);
	memset(&vec1.generic[6], (vec1.generic[6] <= vec2.generic[6]) ? 0xFF : 0, 8);
	memset(&vec1.generic[7], (vec1.generic[7] <= vec2.generic[7]) ? 0xFF : 0, 8);
	return vec1;
}
# define VUINT64x8_CMPLE_DEFINED
#endif
#if !defined(VUINT64x8_CMPGE_DEFINED)
VEC_FUNC_IMPL vuint64x8 vuint64x8_cmpge(vuint64x8 vec1, vuint64x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 8);
	memset(&vec1.generic[4], (vec1.generic[4] >= vec2.generic[4]) ? 0xFF : 0, 8);
	memset(&vec1.generic[5], (vec1.generic[5] >= vec2.generic[5]) ? 0xFF : 0, 8);
	memset(&vec1.generic[6], (vec1.generic[6] >= vec2.generic[6]) ? 0xFF : 0, 8);
	memset(&vec1.generic[7], (vec1.generic[7] >= vec2.generic[7]) ? 0xFF : 0, 8);
	return vec1;
}
# define VUINT64x8_CMPGE_DEFINED
#endif
#if !defined(VUINT64x8_MIN_DEFINED)
VEC_FUNC_IMPL vuint64x8 vuint64x8_min(vuint64x8 vec1, vuint64x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] < vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] < vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] < vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] < vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	return vec1;
}
# define VUINT64x8_MIN_DEFINED
#endif
#if !defined(VUINT64x8_MAX_DEFINED)
VEC_FUNC_IMPL vuint64x8 vuint64x8_max(vuint64x8 vec1, vuint64x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] > vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] > vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] > vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] > vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	return vec1;
}
# define VUINT64x8_MAX_DEFINED
#endif
#if !defined(VUINT64x8_RSHIFT_DEFINED)
VEC_FUNC_IMPL vuint64x8 vuint64x8_rshift(vuint64x8 vec1, vuint64x8 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	vec1.generic[4] >>= vec2.generic[0];
	vec1.generic[5] >>= vec2.generic[0];
	vec1.generic[6] >>= vec2.generic[0];
	vec1.generic[7] >>= vec2.generic[0];
	return vec1;
}
# define VUINT64x8_RSHIFT_DEFINED
#endif
#if !defined(VUINT64x8_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vuint64x8 vuint64x8_lrshift(vuint64x8 vec1, vuint64x8 vec2)
{
	vec1.generic[0] >>= vec2.generic[0];
	vec1.generic[1] >>= vec2.generic[0];
	vec1.generic[2] >>= vec2.generic[0];
	vec1.generic[3] >>= vec2.generic[0];
	vec1.generic[4] >>= vec2.generic[0];
	vec1.generic[5] >>= vec2.generic[0];
	vec1.generic[6] >>= vec2.generic[0];
	vec1.generic[7] >>= vec2.generic[0];
	return vec1;
}
# define VUINT64x8_LRSHIFT_DEFINED
#endif
#if !defined(VUINT64x8_LSHIFT_DEFINED)
VEC_FUNC_IMPL vuint64x8 vuint64x8_lshift(vuint64x8 vec1, vuint64x8 vec2)
{
	vec1.generic[0] <<= vec2.generic[0];
	vec1.generic[1] <<= vec2.generic[0];
	vec1.generic[2] <<= vec2.generic[0];
	vec1.generic[3] <<= vec2.generic[0];
	vec1.generic[4] <<= vec2.generic[0];
	vec1.generic[5] <<= vec2.generic[0];
	vec1.generic[6] <<= vec2.generic[0];
	vec1.generic[7] <<= vec2.generic[0];
	return vec1;
}
# define VUINT64x8_LSHIFT_DEFINED
#endif
#if !defined(VF32x2_SPLAT_DEFINED)
VEC_FUNC_IMPL vf32x2 vf32x2_splat(vec_f32 x)
{
	vf32x2 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	return vec;
}
# define VF32x2_SPLAT_DEFINED
#endif
#if !defined(VF32x2_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vf32x2 vf32x2_load_aligned(const vec_f32 x[2])
{
	vf32x2 vec;
	memcpy(vec.generic, x, 8);
	return vec;
}
# define VF32x2_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VF32x2_LOAD_DEFINED)
VEC_FUNC_IMPL vf32x2 vf32x2_load(const vec_f32 x[2])
{
	vf32x2 vec;
	memcpy(vec.generic, x, 8);
	return vec;
}
# define VF32x2_LOAD_DEFINED
#endif
#if !defined(VF32x2_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vf32x2_store_aligned(vf32x2 vec, vec_f32 x[2])
{
	memcpy(x, vec.generic, 8);
}
# define VF32x2_STORE_ALIGNED_DEFINED
#endif
#if !defined(VF32x2_STORE_DEFINED)
VEC_FUNC_IMPL void vf32x2_store(vf32x2 vec, vec_f32 x[2])
{
	memcpy(x, vec.generic, 8);
}
# define VF32x2_STORE_DEFINED
#endif
#if !defined(VF32x2_ADD_DEFINED)
VEC_FUNC_IMPL vf32x2 vf32x2_add(vf32x2 vec1, vf32x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	return vec1;
}
# define VF32x2_ADD_DEFINED
#endif
#if !defined(VF32x2_SUB_DEFINED)
VEC_FUNC_IMPL vf32x2 vf32x2_sub(vf32x2 vec1, vf32x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	return vec1;
}
# define VF32x2_SUB_DEFINED
#endif
#if !defined(VF32x2_MUL_DEFINED)
VEC_FUNC_IMPL vf32x2 vf32x2_mul(vf32x2 vec1, vf32x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	return vec1;
}
# define VF32x2_MUL_DEFINED
#endif
#if !defined(VF32x2_DIV_DEFINED)
VEC_FUNC_IMPL vf32x2 vf32x2_div(vf32x2 vec1, vf32x2 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	return vec1;
}
# define VF32x2_DIV_DEFINED
#endif
#if !defined(VF32x2_MOD_DEFINED)
VEC_FUNC_IMPL vf32x2 vf32x2_mod(vf32x2 vec1, vf32x2 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? fmod(vec1.generic[0], vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? fmod(vec1.generic[1], vec2.generic[1]) : 0);
	return vec1;
}
# define VF32x2_MOD_DEFINED
#endif
#if !defined(VF32x2_AVG_DEFINED)
VEC_FUNC_IMPL vf32x2 vf32x2_avg(vf32x2 vec1, vf32x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]) / 2;
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]) / 2;
	return vec1;
}
# define VF32x2_AVG_DEFINED
#endif
#if !defined(VF32x2_CMPLT_DEFINED)
VEC_FUNC_IMPL vf32x2 vf32x2_cmplt(vf32x2 vec1, vf32x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 4);
	return vec1;
}
# define VF32x2_CMPLT_DEFINED
#endif
#if !defined(VF32x2_CMPEQ_DEFINED)
VEC_FUNC_IMPL vf32x2 vf32x2_cmpeq(vf32x2 vec1, vf32x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 4);
	return vec1;
}
# define VF32x2_CMPEQ_DEFINED
#endif
#if !defined(VF32x2_CMPGT_DEFINED)
VEC_FUNC_IMPL vf32x2 vf32x2_cmpgt(vf32x2 vec1, vf32x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 4);
	return vec1;
}
# define VF32x2_CMPGT_DEFINED
#endif
#if !defined(VF32x2_CMPLE_DEFINED)
VEC_FUNC_IMPL vf32x2 vf32x2_cmple(vf32x2 vec1, vf32x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 4);
	return vec1;
}
# define VF32x2_CMPLE_DEFINED
#endif
#if !defined(VF32x2_CMPGE_DEFINED)
VEC_FUNC_IMPL vf32x2 vf32x2_cmpge(vf32x2 vec1, vf32x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 4);
	return vec1;
}
# define VF32x2_CMPGE_DEFINED
#endif
#if !defined(VF32x2_MIN_DEFINED)
VEC_FUNC_IMPL vf32x2 vf32x2_min(vf32x2 vec1, vf32x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	return vec1;
}
# define VF32x2_MIN_DEFINED
#endif
#if !defined(VF32x2_MAX_DEFINED)
VEC_FUNC_IMPL vf32x2 vf32x2_max(vf32x2 vec1, vf32x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	return vec1;
}
# define VF32x2_MAX_DEFINED
#endif
#if !defined(VF32x4_SPLAT_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_splat(vec_f32 x)
{
	vf32x4 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	return vec;
}
# define VF32x4_SPLAT_DEFINED
#endif
#if !defined(VF32x4_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_load_aligned(const vec_f32 x[4])
{
	vf32x4 vec;
	memcpy(vec.generic, x, 16);
	return vec;
}
# define VF32x4_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VF32x4_LOAD_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_load(const vec_f32 x[4])
{
	vf32x4 vec;
	memcpy(vec.generic, x, 16);
	return vec;
}
# define VF32x4_LOAD_DEFINED
#endif
#if !defined(VF32x4_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vf32x4_store_aligned(vf32x4 vec, vec_f32 x[4])
{
	memcpy(x, vec.generic, 16);
}
# define VF32x4_STORE_ALIGNED_DEFINED
#endif
#if !defined(VF32x4_STORE_DEFINED)
VEC_FUNC_IMPL void vf32x4_store(vf32x4 vec, vec_f32 x[4])
{
	memcpy(x, vec.generic, 16);
}
# define VF32x4_STORE_DEFINED
#endif
#if !defined(VF32x4_ADD_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_add(vf32x4 vec1, vf32x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	return vec1;
}
# define VF32x4_ADD_DEFINED
#endif
#if !defined(VF32x4_SUB_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_sub(vf32x4 vec1, vf32x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	return vec1;
}
# define VF32x4_SUB_DEFINED
#endif
#if !defined(VF32x4_MUL_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_mul(vf32x4 vec1, vf32x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	return vec1;
}
# define VF32x4_MUL_DEFINED
#endif
#if !defined(VF32x4_DIV_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_div(vf32x4 vec1, vf32x4 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	return vec1;
}
# define VF32x4_DIV_DEFINED
#endif
#if !defined(VF32x4_MOD_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_mod(vf32x4 vec1, vf32x4 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? fmod(vec1.generic[0], vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? fmod(vec1.generic[1], vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? fmod(vec1.generic[2], vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? fmod(vec1.generic[3], vec2.generic[3]) : 0);
	return vec1;
}
# define VF32x4_MOD_DEFINED
#endif
#if !defined(VF32x4_AVG_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_avg(vf32x4 vec1, vf32x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]) / 2;
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]) / 2;
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]) / 2;
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]) / 2;
	return vec1;
}
# define VF32x4_AVG_DEFINED
#endif
#if !defined(VF32x4_CMPLT_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_cmplt(vf32x4 vec1, vf32x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 4);
	return vec1;
}
# define VF32x4_CMPLT_DEFINED
#endif
#if !defined(VF32x4_CMPEQ_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_cmpeq(vf32x4 vec1, vf32x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 4);
	return vec1;
}
# define VF32x4_CMPEQ_DEFINED
#endif
#if !defined(VF32x4_CMPGT_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_cmpgt(vf32x4 vec1, vf32x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 4);
	return vec1;
}
# define VF32x4_CMPGT_DEFINED
#endif
#if !defined(VF32x4_CMPLE_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_cmple(vf32x4 vec1, vf32x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 4);
	return vec1;
}
# define VF32x4_CMPLE_DEFINED
#endif
#if !defined(VF32x4_CMPGE_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_cmpge(vf32x4 vec1, vf32x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 4);
	return vec1;
}
# define VF32x4_CMPGE_DEFINED
#endif
#if !defined(VF32x4_MIN_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_min(vf32x4 vec1, vf32x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	return vec1;
}
# define VF32x4_MIN_DEFINED
#endif
#if !defined(VF32x4_MAX_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_max(vf32x4 vec1, vf32x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	return vec1;
}
# define VF32x4_MAX_DEFINED
#endif
#if !defined(VF32x8_SPLAT_DEFINED)
VEC_FUNC_IMPL vf32x8 vf32x8_splat(vec_f32 x)
{
	vf32x8 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	vec.generic[4] = x;
	vec.generic[5] = x;
	vec.generic[6] = x;
	vec.generic[7] = x;
	return vec;
}
# define VF32x8_SPLAT_DEFINED
#endif
#if !defined(VF32x8_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vf32x8 vf32x8_load_aligned(const vec_f32 x[8])
{
	vf32x8 vec;
	memcpy(vec.generic, x, 32);
	return vec;
}
# define VF32x8_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VF32x8_LOAD_DEFINED)
VEC_FUNC_IMPL vf32x8 vf32x8_load(const vec_f32 x[8])
{
	vf32x8 vec;
	memcpy(vec.generic, x, 32);
	return vec;
}
# define VF32x8_LOAD_DEFINED
#endif
#if !defined(VF32x8_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vf32x8_store_aligned(vf32x8 vec, vec_f32 x[8])
{
	memcpy(x, vec.generic, 32);
}
# define VF32x8_STORE_ALIGNED_DEFINED
#endif
#if !defined(VF32x8_STORE_DEFINED)
VEC_FUNC_IMPL void vf32x8_store(vf32x8 vec, vec_f32 x[8])
{
	memcpy(x, vec.generic, 32);
}
# define VF32x8_STORE_DEFINED
#endif
#if !defined(VF32x8_ADD_DEFINED)
VEC_FUNC_IMPL vf32x8 vf32x8_add(vf32x8 vec1, vf32x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]);
	return vec1;
}
# define VF32x8_ADD_DEFINED
#endif
#if !defined(VF32x8_SUB_DEFINED)
VEC_FUNC_IMPL vf32x8 vf32x8_sub(vf32x8 vec1, vf32x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] - vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] - vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] - vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] - vec2.generic[7]);
	return vec1;
}
# define VF32x8_SUB_DEFINED
#endif
#if !defined(VF32x8_MUL_DEFINED)
VEC_FUNC_IMPL vf32x8 vf32x8_mul(vf32x8 vec1, vf32x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] * vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] * vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] * vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] * vec2.generic[7]);
	return vec1;
}
# define VF32x8_MUL_DEFINED
#endif
#if !defined(VF32x8_DIV_DEFINED)
VEC_FUNC_IMPL vf32x8 vf32x8_div(vf32x8 vec1, vf32x8 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] / vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] / vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] / vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] / vec2.generic[7]) : 0);
	return vec1;
}
# define VF32x8_DIV_DEFINED
#endif
#if !defined(VF32x8_MOD_DEFINED)
VEC_FUNC_IMPL vf32x8 vf32x8_mod(vf32x8 vec1, vf32x8 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? fmod(vec1.generic[0], vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? fmod(vec1.generic[1], vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? fmod(vec1.generic[2], vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? fmod(vec1.generic[3], vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? fmod(vec1.generic[4], vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? fmod(vec1.generic[5], vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? fmod(vec1.generic[6], vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? fmod(vec1.generic[7], vec2.generic[7]) : 0);
	return vec1;
}
# define VF32x8_MOD_DEFINED
#endif
#if !defined(VF32x8_AVG_DEFINED)
VEC_FUNC_IMPL vf32x8 vf32x8_avg(vf32x8 vec1, vf32x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]) / 2;
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]) / 2;
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]) / 2;
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]) / 2;
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]) / 2;
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]) / 2;
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]) / 2;
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]) / 2;
	return vec1;
}
# define VF32x8_AVG_DEFINED
#endif
#if !defined(VF32x8_CMPLT_DEFINED)
VEC_FUNC_IMPL vf32x8 vf32x8_cmplt(vf32x8 vec1, vf32x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] < vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] < vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] < vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] < vec2.generic[7]) ? 0xFF : 0, 4);
	return vec1;
}
# define VF32x8_CMPLT_DEFINED
#endif
#if !defined(VF32x8_CMPEQ_DEFINED)
VEC_FUNC_IMPL vf32x8 vf32x8_cmpeq(vf32x8 vec1, vf32x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] == vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] == vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] == vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] == vec2.generic[7]) ? 0xFF : 0, 4);
	return vec1;
}
# define VF32x8_CMPEQ_DEFINED
#endif
#if !defined(VF32x8_CMPGT_DEFINED)
VEC_FUNC_IMPL vf32x8 vf32x8_cmpgt(vf32x8 vec1, vf32x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] > vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] > vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] > vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] > vec2.generic[7]) ? 0xFF : 0, 4);
	return vec1;
}
# define VF32x8_CMPGT_DEFINED
#endif
#if !defined(VF32x8_CMPLE_DEFINED)
VEC_FUNC_IMPL vf32x8 vf32x8_cmple(vf32x8 vec1, vf32x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] <= vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] <= vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] <= vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] <= vec2.generic[7]) ? 0xFF : 0, 4);
	return vec1;
}
# define VF32x8_CMPLE_DEFINED
#endif
#if !defined(VF32x8_CMPGE_DEFINED)
VEC_FUNC_IMPL vf32x8 vf32x8_cmpge(vf32x8 vec1, vf32x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] >= vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] >= vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] >= vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] >= vec2.generic[7]) ? 0xFF : 0, 4);
	return vec1;
}
# define VF32x8_CMPGE_DEFINED
#endif
#if !defined(VF32x8_MIN_DEFINED)
VEC_FUNC_IMPL vf32x8 vf32x8_min(vf32x8 vec1, vf32x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] < vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] < vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] < vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] < vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	return vec1;
}
# define VF32x8_MIN_DEFINED
#endif
#if !defined(VF32x8_MAX_DEFINED)
VEC_FUNC_IMPL vf32x8 vf32x8_max(vf32x8 vec1, vf32x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] > vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] > vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] > vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] > vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	return vec1;
}
# define VF32x8_MAX_DEFINED
#endif
#if !defined(VF32x16_SPLAT_DEFINED)
VEC_FUNC_IMPL vf32x16 vf32x16_splat(vec_f32 x)
{
	vf32x16 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	vec.generic[4] = x;
	vec.generic[5] = x;
	vec.generic[6] = x;
	vec.generic[7] = x;
	vec.generic[8] = x;
	vec.generic[9] = x;
	vec.generic[10] = x;
	vec.generic[11] = x;
	vec.generic[12] = x;
	vec.generic[13] = x;
	vec.generic[14] = x;
	vec.generic[15] = x;
	return vec;
}
# define VF32x16_SPLAT_DEFINED
#endif
#if !defined(VF32x16_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vf32x16 vf32x16_load_aligned(const vec_f32 x[16])
{
	vf32x16 vec;
	memcpy(vec.generic, x, 64);
	return vec;
}
# define VF32x16_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VF32x16_LOAD_DEFINED)
VEC_FUNC_IMPL vf32x16 vf32x16_load(const vec_f32 x[16])
{
	vf32x16 vec;
	memcpy(vec.generic, x, 64);
	return vec;
}
# define VF32x16_LOAD_DEFINED
#endif
#if !defined(VF32x16_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vf32x16_store_aligned(vf32x16 vec, vec_f32 x[16])
{
	memcpy(x, vec.generic, 64);
}
# define VF32x16_STORE_ALIGNED_DEFINED
#endif
#if !defined(VF32x16_STORE_DEFINED)
VEC_FUNC_IMPL void vf32x16_store(vf32x16 vec, vec_f32 x[16])
{
	memcpy(x, vec.generic, 64);
}
# define VF32x16_STORE_DEFINED
#endif
#if !defined(VF32x16_ADD_DEFINED)
VEC_FUNC_IMPL vf32x16 vf32x16_add(vf32x16 vec1, vf32x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] + vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] + vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] + vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] + vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] + vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] + vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] + vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] + vec2.generic[15]);
	return vec1;
}
# define VF32x16_ADD_DEFINED
#endif
#if !defined(VF32x16_SUB_DEFINED)
VEC_FUNC_IMPL vf32x16 vf32x16_sub(vf32x16 vec1, vf32x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] - vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] - vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] - vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] - vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] - vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] - vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] - vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] - vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] - vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] - vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] - vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] - vec2.generic[15]);
	return vec1;
}
# define VF32x16_SUB_DEFINED
#endif
#if !defined(VF32x16_MUL_DEFINED)
VEC_FUNC_IMPL vf32x16 vf32x16_mul(vf32x16 vec1, vf32x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] * vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] * vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] * vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] * vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] * vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] * vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] * vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] * vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] * vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] * vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] * vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] * vec2.generic[15]);
	return vec1;
}
# define VF32x16_MUL_DEFINED
#endif
#if !defined(VF32x16_DIV_DEFINED)
VEC_FUNC_IMPL vf32x16 vf32x16_div(vf32x16 vec1, vf32x16 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] / vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] / vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] / vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] / vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? (vec1.generic[8] / vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? (vec1.generic[9] / vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? (vec1.generic[10] / vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? (vec1.generic[11] / vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? (vec1.generic[12] / vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? (vec1.generic[13] / vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? (vec1.generic[14] / vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? (vec1.generic[15] / vec2.generic[15]) : 0);
	return vec1;
}
# define VF32x16_DIV_DEFINED
#endif
#if !defined(VF32x16_MOD_DEFINED)
VEC_FUNC_IMPL vf32x16 vf32x16_mod(vf32x16 vec1, vf32x16 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? fmod(vec1.generic[0], vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? fmod(vec1.generic[1], vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? fmod(vec1.generic[2], vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? fmod(vec1.generic[3], vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? fmod(vec1.generic[4], vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? fmod(vec1.generic[5], vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? fmod(vec1.generic[6], vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? fmod(vec1.generic[7], vec2.generic[7]) : 0);
	vec1.generic[8] = (vec2.generic[8] ? fmod(vec1.generic[8], vec2.generic[8]) : 0);
	vec1.generic[9] = (vec2.generic[9] ? fmod(vec1.generic[9], vec2.generic[9]) : 0);
	vec1.generic[10] = (vec2.generic[10] ? fmod(vec1.generic[10], vec2.generic[10]) : 0);
	vec1.generic[11] = (vec2.generic[11] ? fmod(vec1.generic[11], vec2.generic[11]) : 0);
	vec1.generic[12] = (vec2.generic[12] ? fmod(vec1.generic[12], vec2.generic[12]) : 0);
	vec1.generic[13] = (vec2.generic[13] ? fmod(vec1.generic[13], vec2.generic[13]) : 0);
	vec1.generic[14] = (vec2.generic[14] ? fmod(vec1.generic[14], vec2.generic[14]) : 0);
	vec1.generic[15] = (vec2.generic[15] ? fmod(vec1.generic[15], vec2.generic[15]) : 0);
	return vec1;
}
# define VF32x16_MOD_DEFINED
#endif
#if !defined(VF32x16_AVG_DEFINED)
VEC_FUNC_IMPL vf32x16 vf32x16_avg(vf32x16 vec1, vf32x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]) / 2;
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]) / 2;
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]) / 2;
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]) / 2;
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]) / 2;
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]) / 2;
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]) / 2;
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]) / 2;
	vec1.generic[8] = (vec1.generic[8] + vec2.generic[8]) / 2;
	vec1.generic[9] = (vec1.generic[9] + vec2.generic[9]) / 2;
	vec1.generic[10] = (vec1.generic[10] + vec2.generic[10]) / 2;
	vec1.generic[11] = (vec1.generic[11] + vec2.generic[11]) / 2;
	vec1.generic[12] = (vec1.generic[12] + vec2.generic[12]) / 2;
	vec1.generic[13] = (vec1.generic[13] + vec2.generic[13]) / 2;
	vec1.generic[14] = (vec1.generic[14] + vec2.generic[14]) / 2;
	vec1.generic[15] = (vec1.generic[15] + vec2.generic[15]) / 2;
	return vec1;
}
# define VF32x16_AVG_DEFINED
#endif
#if !defined(VF32x16_CMPLT_DEFINED)
VEC_FUNC_IMPL vf32x16 vf32x16_cmplt(vf32x16 vec1, vf32x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] < vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] < vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] < vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] < vec2.generic[7]) ? 0xFF : 0, 4);
	memset(&vec1.generic[8], (vec1.generic[8] < vec2.generic[8]) ? 0xFF : 0, 4);
	memset(&vec1.generic[9], (vec1.generic[9] < vec2.generic[9]) ? 0xFF : 0, 4);
	memset(&vec1.generic[10], (vec1.generic[10] < vec2.generic[10]) ? 0xFF : 0, 4);
	memset(&vec1.generic[11], (vec1.generic[11] < vec2.generic[11]) ? 0xFF : 0, 4);
	memset(&vec1.generic[12], (vec1.generic[12] < vec2.generic[12]) ? 0xFF : 0, 4);
	memset(&vec1.generic[13], (vec1.generic[13] < vec2.generic[13]) ? 0xFF : 0, 4);
	memset(&vec1.generic[14], (vec1.generic[14] < vec2.generic[14]) ? 0xFF : 0, 4);
	memset(&vec1.generic[15], (vec1.generic[15] < vec2.generic[15]) ? 0xFF : 0, 4);
	return vec1;
}
# define VF32x16_CMPLT_DEFINED
#endif
#if !defined(VF32x16_CMPEQ_DEFINED)
VEC_FUNC_IMPL vf32x16 vf32x16_cmpeq(vf32x16 vec1, vf32x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] == vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] == vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] == vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] == vec2.generic[7]) ? 0xFF : 0, 4);
	memset(&vec1.generic[8], (vec1.generic[8] == vec2.generic[8]) ? 0xFF : 0, 4);
	memset(&vec1.generic[9], (vec1.generic[9] == vec2.generic[9]) ? 0xFF : 0, 4);
	memset(&vec1.generic[10], (vec1.generic[10] == vec2.generic[10]) ? 0xFF : 0, 4);
	memset(&vec1.generic[11], (vec1.generic[11] == vec2.generic[11]) ? 0xFF : 0, 4);
	memset(&vec1.generic[12], (vec1.generic[12] == vec2.generic[12]) ? 0xFF : 0, 4);
	memset(&vec1.generic[13], (vec1.generic[13] == vec2.generic[13]) ? 0xFF : 0, 4);
	memset(&vec1.generic[14], (vec1.generic[14] == vec2.generic[14]) ? 0xFF : 0, 4);
	memset(&vec1.generic[15], (vec1.generic[15] == vec2.generic[15]) ? 0xFF : 0, 4);
	return vec1;
}
# define VF32x16_CMPEQ_DEFINED
#endif
#if !defined(VF32x16_CMPGT_DEFINED)
VEC_FUNC_IMPL vf32x16 vf32x16_cmpgt(vf32x16 vec1, vf32x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] > vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] > vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] > vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] > vec2.generic[7]) ? 0xFF : 0, 4);
	memset(&vec1.generic[8], (vec1.generic[8] > vec2.generic[8]) ? 0xFF : 0, 4);
	memset(&vec1.generic[9], (vec1.generic[9] > vec2.generic[9]) ? 0xFF : 0, 4);
	memset(&vec1.generic[10], (vec1.generic[10] > vec2.generic[10]) ? 0xFF : 0, 4);
	memset(&vec1.generic[11], (vec1.generic[11] > vec2.generic[11]) ? 0xFF : 0, 4);
	memset(&vec1.generic[12], (vec1.generic[12] > vec2.generic[12]) ? 0xFF : 0, 4);
	memset(&vec1.generic[13], (vec1.generic[13] > vec2.generic[13]) ? 0xFF : 0, 4);
	memset(&vec1.generic[14], (vec1.generic[14] > vec2.generic[14]) ? 0xFF : 0, 4);
	memset(&vec1.generic[15], (vec1.generic[15] > vec2.generic[15]) ? 0xFF : 0, 4);
	return vec1;
}
# define VF32x16_CMPGT_DEFINED
#endif
#if !defined(VF32x16_CMPLE_DEFINED)
VEC_FUNC_IMPL vf32x16 vf32x16_cmple(vf32x16 vec1, vf32x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] <= vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] <= vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] <= vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] <= vec2.generic[7]) ? 0xFF : 0, 4);
	memset(&vec1.generic[8], (vec1.generic[8] <= vec2.generic[8]) ? 0xFF : 0, 4);
	memset(&vec1.generic[9], (vec1.generic[9] <= vec2.generic[9]) ? 0xFF : 0, 4);
	memset(&vec1.generic[10], (vec1.generic[10] <= vec2.generic[10]) ? 0xFF : 0, 4);
	memset(&vec1.generic[11], (vec1.generic[11] <= vec2.generic[11]) ? 0xFF : 0, 4);
	memset(&vec1.generic[12], (vec1.generic[12] <= vec2.generic[12]) ? 0xFF : 0, 4);
	memset(&vec1.generic[13], (vec1.generic[13] <= vec2.generic[13]) ? 0xFF : 0, 4);
	memset(&vec1.generic[14], (vec1.generic[14] <= vec2.generic[14]) ? 0xFF : 0, 4);
	memset(&vec1.generic[15], (vec1.generic[15] <= vec2.generic[15]) ? 0xFF : 0, 4);
	return vec1;
}
# define VF32x16_CMPLE_DEFINED
#endif
#if !defined(VF32x16_CMPGE_DEFINED)
VEC_FUNC_IMPL vf32x16 vf32x16_cmpge(vf32x16 vec1, vf32x16 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 4);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 4);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 4);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 4);
	memset(&vec1.generic[4], (vec1.generic[4] >= vec2.generic[4]) ? 0xFF : 0, 4);
	memset(&vec1.generic[5], (vec1.generic[5] >= vec2.generic[5]) ? 0xFF : 0, 4);
	memset(&vec1.generic[6], (vec1.generic[6] >= vec2.generic[6]) ? 0xFF : 0, 4);
	memset(&vec1.generic[7], (vec1.generic[7] >= vec2.generic[7]) ? 0xFF : 0, 4);
	memset(&vec1.generic[8], (vec1.generic[8] >= vec2.generic[8]) ? 0xFF : 0, 4);
	memset(&vec1.generic[9], (vec1.generic[9] >= vec2.generic[9]) ? 0xFF : 0, 4);
	memset(&vec1.generic[10], (vec1.generic[10] >= vec2.generic[10]) ? 0xFF : 0, 4);
	memset(&vec1.generic[11], (vec1.generic[11] >= vec2.generic[11]) ? 0xFF : 0, 4);
	memset(&vec1.generic[12], (vec1.generic[12] >= vec2.generic[12]) ? 0xFF : 0, 4);
	memset(&vec1.generic[13], (vec1.generic[13] >= vec2.generic[13]) ? 0xFF : 0, 4);
	memset(&vec1.generic[14], (vec1.generic[14] >= vec2.generic[14]) ? 0xFF : 0, 4);
	memset(&vec1.generic[15], (vec1.generic[15] >= vec2.generic[15]) ? 0xFF : 0, 4);
	return vec1;
}
# define VF32x16_CMPGE_DEFINED
#endif
#if !defined(VF32x16_MIN_DEFINED)
VEC_FUNC_IMPL vf32x16 vf32x16_min(vf32x16 vec1, vf32x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] < vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] < vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] < vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] < vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] < vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] < vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] < vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] < vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] < vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] < vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] < vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] < vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	return vec1;
}
# define VF32x16_MIN_DEFINED
#endif
#if !defined(VF32x16_MAX_DEFINED)
VEC_FUNC_IMPL vf32x16 vf32x16_max(vf32x16 vec1, vf32x16 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] > vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] > vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] > vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] > vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	vec1.generic[8] = (vec1.generic[8] > vec2.generic[8]) ? (vec1.generic[8]) : (vec2.generic[8]);
	vec1.generic[9] = (vec1.generic[9] > vec2.generic[9]) ? (vec1.generic[9]) : (vec2.generic[9]);
	vec1.generic[10] = (vec1.generic[10] > vec2.generic[10]) ? (vec1.generic[10]) : (vec2.generic[10]);
	vec1.generic[11] = (vec1.generic[11] > vec2.generic[11]) ? (vec1.generic[11]) : (vec2.generic[11]);
	vec1.generic[12] = (vec1.generic[12] > vec2.generic[12]) ? (vec1.generic[12]) : (vec2.generic[12]);
	vec1.generic[13] = (vec1.generic[13] > vec2.generic[13]) ? (vec1.generic[13]) : (vec2.generic[13]);
	vec1.generic[14] = (vec1.generic[14] > vec2.generic[14]) ? (vec1.generic[14]) : (vec2.generic[14]);
	vec1.generic[15] = (vec1.generic[15] > vec2.generic[15]) ? (vec1.generic[15]) : (vec2.generic[15]);
	return vec1;
}
# define VF32x16_MAX_DEFINED
#endif
#if !defined(VF64x2_SPLAT_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_splat(vec_f64 x)
{
	vf64x2 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	return vec;
}
# define VF64x2_SPLAT_DEFINED
#endif
#if !defined(VF64x2_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_load_aligned(const vec_f64 x[2])
{
	vf64x2 vec;
	memcpy(vec.generic, x, 16);
	return vec;
}
# define VF64x2_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VF64x2_LOAD_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_load(const vec_f64 x[2])
{
	vf64x2 vec;
	memcpy(vec.generic, x, 16);
	return vec;
}
# define VF64x2_LOAD_DEFINED
#endif
#if !defined(VF64x2_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vf64x2_store_aligned(vf64x2 vec, vec_f64 x[2])
{
	memcpy(x, vec.generic, 16);
}
# define VF64x2_STORE_ALIGNED_DEFINED
#endif
#if !defined(VF64x2_STORE_DEFINED)
VEC_FUNC_IMPL void vf64x2_store(vf64x2 vec, vec_f64 x[2])
{
	memcpy(x, vec.generic, 16);
}
# define VF64x2_STORE_DEFINED
#endif
#if !defined(VF64x2_ADD_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_add(vf64x2 vec1, vf64x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	return vec1;
}
# define VF64x2_ADD_DEFINED
#endif
#if !defined(VF64x2_SUB_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_sub(vf64x2 vec1, vf64x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	return vec1;
}
# define VF64x2_SUB_DEFINED
#endif
#if !defined(VF64x2_MUL_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_mul(vf64x2 vec1, vf64x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	return vec1;
}
# define VF64x2_MUL_DEFINED
#endif
#if !defined(VF64x2_DIV_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_div(vf64x2 vec1, vf64x2 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	return vec1;
}
# define VF64x2_DIV_DEFINED
#endif
#if !defined(VF64x2_MOD_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_mod(vf64x2 vec1, vf64x2 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? fmod(vec1.generic[0], vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? fmod(vec1.generic[1], vec2.generic[1]) : 0);
	return vec1;
}
# define VF64x2_MOD_DEFINED
#endif
#if !defined(VF64x2_AVG_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_avg(vf64x2 vec1, vf64x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]) / 2;
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]) / 2;
	return vec1;
}
# define VF64x2_AVG_DEFINED
#endif
#if !defined(VF64x2_CMPLT_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_cmplt(vf64x2 vec1, vf64x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 8);
	return vec1;
}
# define VF64x2_CMPLT_DEFINED
#endif
#if !defined(VF64x2_CMPEQ_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_cmpeq(vf64x2 vec1, vf64x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 8);
	return vec1;
}
# define VF64x2_CMPEQ_DEFINED
#endif
#if !defined(VF64x2_CMPGT_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_cmpgt(vf64x2 vec1, vf64x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 8);
	return vec1;
}
# define VF64x2_CMPGT_DEFINED
#endif
#if !defined(VF64x2_CMPLE_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_cmple(vf64x2 vec1, vf64x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 8);
	return vec1;
}
# define VF64x2_CMPLE_DEFINED
#endif
#if !defined(VF64x2_CMPGE_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_cmpge(vf64x2 vec1, vf64x2 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 8);
	return vec1;
}
# define VF64x2_CMPGE_DEFINED
#endif
#if !defined(VF64x2_MIN_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_min(vf64x2 vec1, vf64x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	return vec1;
}
# define VF64x2_MIN_DEFINED
#endif
#if !defined(VF64x2_MAX_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_max(vf64x2 vec1, vf64x2 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	return vec1;
}
# define VF64x2_MAX_DEFINED
#endif
#if !defined(VF64x4_SPLAT_DEFINED)
VEC_FUNC_IMPL vf64x4 vf64x4_splat(vec_f64 x)
{
	vf64x4 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	return vec;
}
# define VF64x4_SPLAT_DEFINED
#endif
#if !defined(VF64x4_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vf64x4 vf64x4_load_aligned(const vec_f64 x[4])
{
	vf64x4 vec;
	memcpy(vec.generic, x, 32);
	return vec;
}
# define VF64x4_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VF64x4_LOAD_DEFINED)
VEC_FUNC_IMPL vf64x4 vf64x4_load(const vec_f64 x[4])
{
	vf64x4 vec;
	memcpy(vec.generic, x, 32);
	return vec;
}
# define VF64x4_LOAD_DEFINED
#endif
#if !defined(VF64x4_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vf64x4_store_aligned(vf64x4 vec, vec_f64 x[4])
{
	memcpy(x, vec.generic, 32);
}
# define VF64x4_STORE_ALIGNED_DEFINED
#endif
#if !defined(VF64x4_STORE_DEFINED)
VEC_FUNC_IMPL void vf64x4_store(vf64x4 vec, vec_f64 x[4])
{
	memcpy(x, vec.generic, 32);
}
# define VF64x4_STORE_DEFINED
#endif
#if !defined(VF64x4_ADD_DEFINED)
VEC_FUNC_IMPL vf64x4 vf64x4_add(vf64x4 vec1, vf64x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	return vec1;
}
# define VF64x4_ADD_DEFINED
#endif
#if !defined(VF64x4_SUB_DEFINED)
VEC_FUNC_IMPL vf64x4 vf64x4_sub(vf64x4 vec1, vf64x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	return vec1;
}
# define VF64x4_SUB_DEFINED
#endif
#if !defined(VF64x4_MUL_DEFINED)
VEC_FUNC_IMPL vf64x4 vf64x4_mul(vf64x4 vec1, vf64x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	return vec1;
}
# define VF64x4_MUL_DEFINED
#endif
#if !defined(VF64x4_DIV_DEFINED)
VEC_FUNC_IMPL vf64x4 vf64x4_div(vf64x4 vec1, vf64x4 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	return vec1;
}
# define VF64x4_DIV_DEFINED
#endif
#if !defined(VF64x4_MOD_DEFINED)
VEC_FUNC_IMPL vf64x4 vf64x4_mod(vf64x4 vec1, vf64x4 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? fmod(vec1.generic[0], vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? fmod(vec1.generic[1], vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? fmod(vec1.generic[2], vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? fmod(vec1.generic[3], vec2.generic[3]) : 0);
	return vec1;
}
# define VF64x4_MOD_DEFINED
#endif
#if !defined(VF64x4_AVG_DEFINED)
VEC_FUNC_IMPL vf64x4 vf64x4_avg(vf64x4 vec1, vf64x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]) / 2;
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]) / 2;
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]) / 2;
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]) / 2;
	return vec1;
}
# define VF64x4_AVG_DEFINED
#endif
#if !defined(VF64x4_CMPLT_DEFINED)
VEC_FUNC_IMPL vf64x4 vf64x4_cmplt(vf64x4 vec1, vf64x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 8);
	return vec1;
}
# define VF64x4_CMPLT_DEFINED
#endif
#if !defined(VF64x4_CMPEQ_DEFINED)
VEC_FUNC_IMPL vf64x4 vf64x4_cmpeq(vf64x4 vec1, vf64x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 8);
	return vec1;
}
# define VF64x4_CMPEQ_DEFINED
#endif
#if !defined(VF64x4_CMPGT_DEFINED)
VEC_FUNC_IMPL vf64x4 vf64x4_cmpgt(vf64x4 vec1, vf64x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 8);
	return vec1;
}
# define VF64x4_CMPGT_DEFINED
#endif
#if !defined(VF64x4_CMPLE_DEFINED)
VEC_FUNC_IMPL vf64x4 vf64x4_cmple(vf64x4 vec1, vf64x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 8);
	return vec1;
}
# define VF64x4_CMPLE_DEFINED
#endif
#if !defined(VF64x4_CMPGE_DEFINED)
VEC_FUNC_IMPL vf64x4 vf64x4_cmpge(vf64x4 vec1, vf64x4 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 8);
	return vec1;
}
# define VF64x4_CMPGE_DEFINED
#endif
#if !defined(VF64x4_MIN_DEFINED)
VEC_FUNC_IMPL vf64x4 vf64x4_min(vf64x4 vec1, vf64x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	return vec1;
}
# define VF64x4_MIN_DEFINED
#endif
#if !defined(VF64x4_MAX_DEFINED)
VEC_FUNC_IMPL vf64x4 vf64x4_max(vf64x4 vec1, vf64x4 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	return vec1;
}
# define VF64x4_MAX_DEFINED
#endif
#if !defined(VF64x8_SPLAT_DEFINED)
VEC_FUNC_IMPL vf64x8 vf64x8_splat(vec_f64 x)
{
	vf64x8 vec;
	vec.generic[0] = x;
	vec.generic[1] = x;
	vec.generic[2] = x;
	vec.generic[3] = x;
	vec.generic[4] = x;
	vec.generic[5] = x;
	vec.generic[6] = x;
	vec.generic[7] = x;
	return vec;
}
# define VF64x8_SPLAT_DEFINED
#endif
#if !defined(VF64x8_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vf64x8 vf64x8_load_aligned(const vec_f64 x[8])
{
	vf64x8 vec;
	memcpy(vec.generic, x, 64);
	return vec;
}
# define VF64x8_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VF64x8_LOAD_DEFINED)
VEC_FUNC_IMPL vf64x8 vf64x8_load(const vec_f64 x[8])
{
	vf64x8 vec;
	memcpy(vec.generic, x, 64);
	return vec;
}
# define VF64x8_LOAD_DEFINED
#endif
#if !defined(VF64x8_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vf64x8_store_aligned(vf64x8 vec, vec_f64 x[8])
{
	memcpy(x, vec.generic, 64);
}
# define VF64x8_STORE_ALIGNED_DEFINED
#endif
#if !defined(VF64x8_STORE_DEFINED)
VEC_FUNC_IMPL void vf64x8_store(vf64x8 vec, vec_f64 x[8])
{
	memcpy(x, vec.generic, 64);
}
# define VF64x8_STORE_DEFINED
#endif
#if !defined(VF64x8_ADD_DEFINED)
VEC_FUNC_IMPL vf64x8 vf64x8_add(vf64x8 vec1, vf64x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]);
	return vec1;
}
# define VF64x8_ADD_DEFINED
#endif
#if !defined(VF64x8_SUB_DEFINED)
VEC_FUNC_IMPL vf64x8 vf64x8_sub(vf64x8 vec1, vf64x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] - vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] - vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] - vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] - vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] - vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] - vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] - vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] - vec2.generic[7]);
	return vec1;
}
# define VF64x8_SUB_DEFINED
#endif
#if !defined(VF64x8_MUL_DEFINED)
VEC_FUNC_IMPL vf64x8 vf64x8_mul(vf64x8 vec1, vf64x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] * vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] * vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] * vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] * vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] * vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] * vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] * vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] * vec2.generic[7]);
	return vec1;
}
# define VF64x8_MUL_DEFINED
#endif
#if !defined(VF64x8_DIV_DEFINED)
VEC_FUNC_IMPL vf64x8 vf64x8_div(vf64x8 vec1, vf64x8 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? (vec1.generic[0] / vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? (vec1.generic[1] / vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? (vec1.generic[2] / vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? (vec1.generic[3] / vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? (vec1.generic[4] / vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? (vec1.generic[5] / vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? (vec1.generic[6] / vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? (vec1.generic[7] / vec2.generic[7]) : 0);
	return vec1;
}
# define VF64x8_DIV_DEFINED
#endif
#if !defined(VF64x8_MOD_DEFINED)
VEC_FUNC_IMPL vf64x8 vf64x8_mod(vf64x8 vec1, vf64x8 vec2)
{
	vec1.generic[0] = (vec2.generic[0] ? fmod(vec1.generic[0], vec2.generic[0]) : 0);
	vec1.generic[1] = (vec2.generic[1] ? fmod(vec1.generic[1], vec2.generic[1]) : 0);
	vec1.generic[2] = (vec2.generic[2] ? fmod(vec1.generic[2], vec2.generic[2]) : 0);
	vec1.generic[3] = (vec2.generic[3] ? fmod(vec1.generic[3], vec2.generic[3]) : 0);
	vec1.generic[4] = (vec2.generic[4] ? fmod(vec1.generic[4], vec2.generic[4]) : 0);
	vec1.generic[5] = (vec2.generic[5] ? fmod(vec1.generic[5], vec2.generic[5]) : 0);
	vec1.generic[6] = (vec2.generic[6] ? fmod(vec1.generic[6], vec2.generic[6]) : 0);
	vec1.generic[7] = (vec2.generic[7] ? fmod(vec1.generic[7], vec2.generic[7]) : 0);
	return vec1;
}
# define VF64x8_MOD_DEFINED
#endif
#if !defined(VF64x8_AVG_DEFINED)
VEC_FUNC_IMPL vf64x8 vf64x8_avg(vf64x8 vec1, vf64x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] + vec2.generic[0]) / 2;
	vec1.generic[1] = (vec1.generic[1] + vec2.generic[1]) / 2;
	vec1.generic[2] = (vec1.generic[2] + vec2.generic[2]) / 2;
	vec1.generic[3] = (vec1.generic[3] + vec2.generic[3]) / 2;
	vec1.generic[4] = (vec1.generic[4] + vec2.generic[4]) / 2;
	vec1.generic[5] = (vec1.generic[5] + vec2.generic[5]) / 2;
	vec1.generic[6] = (vec1.generic[6] + vec2.generic[6]) / 2;
	vec1.generic[7] = (vec1.generic[7] + vec2.generic[7]) / 2;
	return vec1;
}
# define VF64x8_AVG_DEFINED
#endif
#if !defined(VF64x8_CMPLT_DEFINED)
VEC_FUNC_IMPL vf64x8 vf64x8_cmplt(vf64x8 vec1, vf64x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] < vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] < vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] < vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] < vec2.generic[3]) ? 0xFF : 0, 8);
	memset(&vec1.generic[4], (vec1.generic[4] < vec2.generic[4]) ? 0xFF : 0, 8);
	memset(&vec1.generic[5], (vec1.generic[5] < vec2.generic[5]) ? 0xFF : 0, 8);
	memset(&vec1.generic[6], (vec1.generic[6] < vec2.generic[6]) ? 0xFF : 0, 8);
	memset(&vec1.generic[7], (vec1.generic[7] < vec2.generic[7]) ? 0xFF : 0, 8);
	return vec1;
}
# define VF64x8_CMPLT_DEFINED
#endif
#if !defined(VF64x8_CMPEQ_DEFINED)
VEC_FUNC_IMPL vf64x8 vf64x8_cmpeq(vf64x8 vec1, vf64x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] == vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] == vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] == vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] == vec2.generic[3]) ? 0xFF : 0, 8);
	memset(&vec1.generic[4], (vec1.generic[4] == vec2.generic[4]) ? 0xFF : 0, 8);
	memset(&vec1.generic[5], (vec1.generic[5] == vec2.generic[5]) ? 0xFF : 0, 8);
	memset(&vec1.generic[6], (vec1.generic[6] == vec2.generic[6]) ? 0xFF : 0, 8);
	memset(&vec1.generic[7], (vec1.generic[7] == vec2.generic[7]) ? 0xFF : 0, 8);
	return vec1;
}
# define VF64x8_CMPEQ_DEFINED
#endif
#if !defined(VF64x8_CMPGT_DEFINED)
VEC_FUNC_IMPL vf64x8 vf64x8_cmpgt(vf64x8 vec1, vf64x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] > vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] > vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] > vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] > vec2.generic[3]) ? 0xFF : 0, 8);
	memset(&vec1.generic[4], (vec1.generic[4] > vec2.generic[4]) ? 0xFF : 0, 8);
	memset(&vec1.generic[5], (vec1.generic[5] > vec2.generic[5]) ? 0xFF : 0, 8);
	memset(&vec1.generic[6], (vec1.generic[6] > vec2.generic[6]) ? 0xFF : 0, 8);
	memset(&vec1.generic[7], (vec1.generic[7] > vec2.generic[7]) ? 0xFF : 0, 8);
	return vec1;
}
# define VF64x8_CMPGT_DEFINED
#endif
#if !defined(VF64x8_CMPLE_DEFINED)
VEC_FUNC_IMPL vf64x8 vf64x8_cmple(vf64x8 vec1, vf64x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] <= vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] <= vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] <= vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] <= vec2.generic[3]) ? 0xFF : 0, 8);
	memset(&vec1.generic[4], (vec1.generic[4] <= vec2.generic[4]) ? 0xFF : 0, 8);
	memset(&vec1.generic[5], (vec1.generic[5] <= vec2.generic[5]) ? 0xFF : 0, 8);
	memset(&vec1.generic[6], (vec1.generic[6] <= vec2.generic[6]) ? 0xFF : 0, 8);
	memset(&vec1.generic[7], (vec1.generic[7] <= vec2.generic[7]) ? 0xFF : 0, 8);
	return vec1;
}
# define VF64x8_CMPLE_DEFINED
#endif
#if !defined(VF64x8_CMPGE_DEFINED)
VEC_FUNC_IMPL vf64x8 vf64x8_cmpge(vf64x8 vec1, vf64x8 vec2)
{
	memset(&vec1.generic[0], (vec1.generic[0] >= vec2.generic[0]) ? 0xFF : 0, 8);
	memset(&vec1.generic[1], (vec1.generic[1] >= vec2.generic[1]) ? 0xFF : 0, 8);
	memset(&vec1.generic[2], (vec1.generic[2] >= vec2.generic[2]) ? 0xFF : 0, 8);
	memset(&vec1.generic[3], (vec1.generic[3] >= vec2.generic[3]) ? 0xFF : 0, 8);
	memset(&vec1.generic[4], (vec1.generic[4] >= vec2.generic[4]) ? 0xFF : 0, 8);
	memset(&vec1.generic[5], (vec1.generic[5] >= vec2.generic[5]) ? 0xFF : 0, 8);
	memset(&vec1.generic[6], (vec1.generic[6] >= vec2.generic[6]) ? 0xFF : 0, 8);
	memset(&vec1.generic[7], (vec1.generic[7] >= vec2.generic[7]) ? 0xFF : 0, 8);
	return vec1;
}
# define VF64x8_CMPGE_DEFINED
#endif
#if !defined(VF64x8_MIN_DEFINED)
VEC_FUNC_IMPL vf64x8 vf64x8_min(vf64x8 vec1, vf64x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] < vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] < vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] < vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] < vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] < vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] < vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] < vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] < vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	return vec1;
}
# define VF64x8_MIN_DEFINED
#endif
#if !defined(VF64x8_MAX_DEFINED)
VEC_FUNC_IMPL vf64x8 vf64x8_max(vf64x8 vec1, vf64x8 vec2)
{
	vec1.generic[0] = (vec1.generic[0] > vec2.generic[0]) ? (vec1.generic[0]) : (vec2.generic[0]);
	vec1.generic[1] = (vec1.generic[1] > vec2.generic[1]) ? (vec1.generic[1]) : (vec2.generic[1]);
	vec1.generic[2] = (vec1.generic[2] > vec2.generic[2]) ? (vec1.generic[2]) : (vec2.generic[2]);
	vec1.generic[3] = (vec1.generic[3] > vec2.generic[3]) ? (vec1.generic[3]) : (vec2.generic[3]);
	vec1.generic[4] = (vec1.generic[4] > vec2.generic[4]) ? (vec1.generic[4]) : (vec2.generic[4]);
	vec1.generic[5] = (vec1.generic[5] > vec2.generic[5]) ? (vec1.generic[5]) : (vec2.generic[5]);
	vec1.generic[6] = (vec1.generic[6] > vec2.generic[6]) ? (vec1.generic[6]) : (vec2.generic[6]);
	vec1.generic[7] = (vec1.generic[7] > vec2.generic[7]) ? (vec1.generic[7]) : (vec2.generic[7]);
	return vec1;
}
# define VF64x8_MAX_DEFINED
#endif
