/**
 * vec - a tiny SIMD vector library in C99
 * 
 * Copyright (c) 2024 Paper
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
**/

#ifndef VEC_IMPL_FALLBACK_H_
#define VEC_IMPL_FALLBACK_H_

#include "vec/vec.h"

#define VEC_DEFINE_FALLBACK_OPERATIONS_SIGN(sign, csign, bits, size) \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_fallback_splat(vec_##sign##int##bits x); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_fallback_load(const vec_##sign##int##bits in[size]); \
	void v##sign##int##bits##x##size##_fallback_store(v##sign##int##bits##x##size vec, vec_##sign##int##bits out[size]); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_fallback_add(v##sign##int##bits##x##size vec1, v##sign##int##bits##x##size vec2); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_fallback_sub(v##sign##int##bits##x##size vec1, v##sign##int##bits##x##size vec2); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_fallback_mul(v##sign##int##bits##x##size vec1, v##sign##int##bits##x##size vec2); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_fallback_div(v##sign##int##bits##x##size vec1, v##sign##int##bits##x##size vec2); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_fallback_avg(v##sign##int##bits##x##size vec1, v##sign##int##bits##x##size vec2); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_fallback_and(v##sign##int##bits##x##size vec1, v##sign##int##bits##x##size vec2); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_fallback_or(v##sign##int##bits##x##size vec1, v##sign##int##bits##x##size vec2); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_fallback_xor(v##sign##int##bits##x##size vec1, v##sign##int##bits##x##size vec2); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_fallback_not(v##sign##int##bits##x##size vec); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_fallback_cmplt(v##sign##int##bits##x##size vec1, v##sign##int##bits##x##size vec2); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_fallback_cmple(v##sign##int##bits##x##size vec1, v##sign##int##bits##x##size vec2); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_fallback_cmpeq(v##sign##int##bits##x##size vec1, v##sign##int##bits##x##size vec2); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_fallback_cmpge(v##sign##int##bits##x##size vec1, v##sign##int##bits##x##size vec2); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_fallback_cmpgt(v##sign##int##bits##x##size vec1, v##sign##int##bits##x##size vec2); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_fallback_lshift(v##sign##int##bits##x##size vec1, vuint##bits##x##size vec2); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_fallback_rshift(v##sign##int##bits##x##size vec1, vuint##bits##x##size vec2); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_fallback_lrshift(v##sign##int##bits##x##size vec1, vuint##bits##x##size vec2);

#define VEC_DEFINE_FALLBACK_OPERATIONS(bits, size) \
	VEC_DEFINE_FALLBACK_OPERATIONS_SIGN( ,  , bits, size) \
	VEC_DEFINE_FALLBACK_OPERATIONS_SIGN(u, U, bits, size)

// 16-bit
VEC_DEFINE_FALLBACK_OPERATIONS(8, 2)

// 32-bit
VEC_DEFINE_FALLBACK_OPERATIONS(8, 4)
VEC_DEFINE_FALLBACK_OPERATIONS(16, 2)

// 64-bit
VEC_DEFINE_FALLBACK_OPERATIONS(8, 8)
VEC_DEFINE_FALLBACK_OPERATIONS(16, 4)
VEC_DEFINE_FALLBACK_OPERATIONS(32, 2)

// 128-bit
VEC_DEFINE_FALLBACK_OPERATIONS(8, 16)
VEC_DEFINE_FALLBACK_OPERATIONS(16, 8)
VEC_DEFINE_FALLBACK_OPERATIONS(32, 4)
VEC_DEFINE_FALLBACK_OPERATIONS(64, 2)

// 256-bit
VEC_DEFINE_FALLBACK_OPERATIONS(8, 32)
VEC_DEFINE_FALLBACK_OPERATIONS(16, 16)
VEC_DEFINE_FALLBACK_OPERATIONS(32, 8)
VEC_DEFINE_FALLBACK_OPERATIONS(64, 4)

// 512-bit
VEC_DEFINE_FALLBACK_OPERATIONS(8, 64)
VEC_DEFINE_FALLBACK_OPERATIONS(16, 32)
VEC_DEFINE_FALLBACK_OPERATIONS(32, 16)
VEC_DEFINE_FALLBACK_OPERATIONS(64, 8)

#undef VEC_DEFINE_FALLBACK_OPERATIONS
#undef VEC_DEFINE_FALLBACK_OPERATIONS_SIGN

#endif /* VEC_IMPL_FALLBACK_H_ */
