/**
 * vec - a tiny SIMD vector library in C99
 * 
 * Copyright (c) 2024 Paper
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
**/

#ifndef VEC_IMPL_X86_SSE2_H_
#define VEC_IMPL_X86_SSE2_H_

#include "vec/vec.h"

// These are only extern because the SSE 4.1 translation unit needs to access it.
#define VEC_DEFINE_SSE2_OPERATIONS_SIGN(sign, csign, bits, size) \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_sse2_splat(vec_##sign##int##bits x); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_sse2_load_aligned(const vec_##sign##int##bits in[size]); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_sse2_load(const vec_##sign##int##bits in[size]); \
	void v##sign##int##bits##x##size##_sse2_store_aligned(v##sign##int##bits##x##size vec, vec_##sign##int##bits out[size]); \
	void v##sign##int##bits##x##size##_sse2_store(v##sign##int##bits##x##size vec, vec_##sign##int##bits out[size]); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_sse2_add(v##sign##int##bits##x##size vec1, v##sign##int##bits##x##size vec2); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_sse2_sub(v##sign##int##bits##x##size vec1, v##sign##int##bits##x##size vec2); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_sse2_mul(v##sign##int##bits##x##size vec1, v##sign##int##bits##x##size vec2); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_sse2_and(v##sign##int##bits##x##size vec1, v##sign##int##bits##x##size vec2); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_sse2_or(v##sign##int##bits##x##size vec1, v##sign##int##bits##x##size vec2); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_sse2_xor(v##sign##int##bits##x##size vec1, v##sign##int##bits##x##size vec2); \
	v##sign##int##bits##x##size v##sign##int##bits##x##size##_sse2_cmpeq(v##sign##int##bits##x##size vec1, v##sign##int##bits##x##size vec2);

#define VEC_DEFINE_SSE2_OPERATIONS(bits, size) \
	VEC_DEFINE_SSE2_OPERATIONS_SIGN( ,  , bits, size) \
	VEC_DEFINE_SSE2_OPERATIONS_SIGN(u, U, bits, size)

VEC_DEFINE_SSE2_OPERATIONS(8, 16)
VEC_DEFINE_SSE2_OPERATIONS(16, 8)
VEC_DEFINE_SSE2_OPERATIONS(32, 4)
VEC_DEFINE_SSE2_OPERATIONS(64, 2)

#undef VEC_DEFINE_SSE2_OPERATIONS
#undef VEC_DEFINE_SSE2_OPERATIONS_SIGN

extern const vint8x16_impl vint8x16_impl_sse2;
extern const vint16x8_impl vint16x8_impl_sse2;
extern const vint32x4_impl vint32x4_impl_sse2;
extern const vint64x2_impl vint64x2_impl_sse2;
extern const vuint8x16_impl vuint8x16_impl_sse2;
extern const vuint16x8_impl vuint16x8_impl_sse2;
extern const vuint32x4_impl vuint32x4_impl_sse2;
extern const vuint64x2_impl vuint64x2_impl_sse2;

#endif /* VEC_IMPL_X86_SSE2_H_ */
