/**
 * vec - a tiny SIMD vector library in C99
 * 
 * Copyright (c) 2024-2025 Paper
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
**/

/* This file is automatically generated! Do not edit it directly!
 * Edit the code that generates it in utils/gengeneric.c  --paper */

#ifndef VEC_IMPL_DOUBLE_H_
#define VEC_IMPL_DOUBLE_H_

#define VEC_DOUBLE_SPLAT(sign, bits, size, halfsize) \
	VEC_FUNC_IMPL v##sign##int##bits##x##size v##sign##int##bits##x##size##_splat(vec_##sign##int##bits x) \
	{ \
		v##sign##int##bits##x##size vec; \
	\
		vec.generic[0] = v##sign##int##bits##x##halfsize##_splat(x); \
		vec.generic[1] = v##sign##int##bits##x##halfsize##_splat(x); \
	\
		return vec; \
	}

#define VEC_DOUBLE_LOAD_EX(name, sign, bits, size, halfsize) \
	VEC_FUNC_IMPL v##sign##int##bits##x##size v##sign##int##bits##x##size##_##name(const vec_##sign##int##bits x[size]) \
	{ \
		v##sign##int##bits##x##size vec; \
	\
		vec.generic[0] = v##sign##int##bits##x##halfsize##_##name(x); \
		vec.generic[1] = v##sign##int##bits##x##halfsize##_##name(x + halfsize); \
	\
		return vec; \
	}

#define VEC_DOUBLE_LOAD(sign, bits, size, halfsize) VEC_DOUBLE_LOAD_EX(load, sign, bits, size, halfsize)
#define VEC_DOUBLE_LOAD_ALIGNED(sign, bits, size, halfsize) VEC_DOUBLE_LOAD_EX(load_aligned, sign, bits, size, halfsize)

#define VEC_DOUBLE_STORE_EX(name, sign, bits, size, halfsize) \
	VEC_FUNC_IMPL void v##sign##int##bits##x##size##_##name(v##sign##int##bits##x##size vec, vec_##sign##int##bits x[size]) \
	{ \
		v##sign##int##bits##x##halfsize##_##name(vec.generic[0], x); \
		v##sign##int##bits##x##halfsize##_##name(vec.generic[1], x + halfsize); \
	}

#define VEC_DOUBLE_STORE(sign, bits, size, halfsize) VEC_DOUBLE_STORE_EX(store, sign, bits, size, halfsize)
#define VEC_DOUBLE_STORE_ALIGNED(sign, bits, size, halfsize) VEC_DOUBLE_STORE_EX(store_aligned, sign, bits, size, halfsize)

#define VEC_DOUBLE_OP(name, sign, bits, size, halfsize, secondsign) \
	VEC_FUNC_IMPL v##sign##int##bits##x##size v##sign##int##bits##x##size##_##name(v##sign##int##bits##x##size vec1, v##secondsign##int##bits##x##size vec2) \
	{ \
		vec1.generic[0] = v##sign##int##bits##x##halfsize##_##name(vec1.generic[0], vec2.generic[0]); \
		vec1.generic[1] = v##sign##int##bits##x##halfsize##_##name(vec1.generic[1], vec2.generic[1]); \
	\
		return vec1; \
	}

#define VEC_DOUBLE_ADD(sign, bits, size, halfsize) VEC_DOUBLE_OP(add, sign, bits, size, halfsize, sign)
#define VEC_DOUBLE_SUB(sign, bits, size, halfsize) VEC_DOUBLE_OP(sub, sign, bits, size, halfsize, sign)
#define VEC_DOUBLE_MUL(sign, bits, size, halfsize) VEC_DOUBLE_OP(mul, sign, bits, size, halfsize, sign)
#define VEC_DOUBLE_DIV(sign, bits, size, halfsize) VEC_DOUBLE_OP(div, sign, bits, size, halfsize, sign)
#define VEC_DOUBLE_MOD(sign, bits, size, halfsize) VEC_DOUBLE_OP(mod, sign, bits, size, halfsize, sign)
#define VEC_DOUBLE_AVG(sign, bits, size, halfsize) VEC_DOUBLE_OP(avg, sign, bits, size, halfsize, sign)
#define VEC_DOUBLE_LSHIFT(sign, bits, size, halfsize) VEC_DOUBLE_OP(lshift, sign, bits, size, halfsize, u)
#define VEC_DOUBLE_RSHIFT(sign, bits, size, halfsize) VEC_DOUBLE_OP(rshift, sign, bits, size, halfsize, u)
#define VEC_DOUBLE_LRSHIFT(sign, bits, size, halfsize) VEC_DOUBLE_OP(lrshift, sign, bits, size, halfsize, u)
#define VEC_DOUBLE_AND(sign, bits, size, halfsize) VEC_DOUBLE_OP(and, sign, bits, size, halfsize, sign)
#define VEC_DOUBLE_OR(sign, bits, size, halfsize) VEC_DOUBLE_OP(or, sign, bits, size, halfsize, sign)
#define VEC_DOUBLE_XOR(sign, bits, size, halfsize) VEC_DOUBLE_OP(xor, sign, bits, size, halfsize, sign)
#define VEC_DOUBLE_MIN(sign, bits, size, halfsize) VEC_DOUBLE_OP(min, sign, bits, size, halfsize, sign)
#define VEC_DOUBLE_MAX(sign, bits, size, halfsize) VEC_DOUBLE_OP(max, sign, bits, size, halfsize, sign)
#define VEC_DOUBLE_CMPLT(sign, bits, size, halfsize) VEC_DOUBLE_OP(cmplt, sign, bits, size, halfsize, sign)
#define VEC_DOUBLE_CMPLE(sign, bits, size, halfsize) VEC_DOUBLE_OP(cmple, sign, bits, size, halfsize, sign)
#define VEC_DOUBLE_CMPEQ(sign, bits, size, halfsize) VEC_DOUBLE_OP(cmpeq, sign, bits, size, halfsize, sign)
#define VEC_DOUBLE_CMPGE(sign, bits, size, halfsize) VEC_DOUBLE_OP(cmpge, sign, bits, size, halfsize, sign)
#define VEC_DOUBLE_CMPGT(sign, bits, size, halfsize) VEC_DOUBLE_OP(cmpgt, sign, bits, size, halfsize, sign)

#define VEC_DOUBLE_NOT(sign, bits, size, halfsize) \
	VEC_FUNC_IMPL v##sign##int##bits##x##size v##sign##int##bits##x##size##_not(v##sign##int##bits##x##size vec) \
	{ \
		vec.generic[0] = v##sign##int##bits##x##halfsize##_not(vec.generic[0]); \
		vec.generic[1] = v##sign##int##bits##x##halfsize##_not(vec.generic[1]); \
	\
		return vec; \
	}

#endif /* VEC_IMPL_DOUBLE_H_ */ 

/* ------------------------------------------------------------------------ */
/* PREPROCESSOR HELL INCOMING */



/* vuint8x4 */

#if !defined(VINT8x4_SPLAT_DEFINED) && defined(VINT8x2_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(/* nothing */, 8, 4, 2)
# define VINT8x4_SPLAT_DEFINED
#endif

#if !defined(VINT8x4_LOAD_ALIGNED_DEFINED) && defined(VINT8x2_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(/* nothing */, 8, 4, 2)
# define VINT8x4_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VINT8x4_LOAD_DEFINED) && defined(VINT8x2_LOAD_DEFINED)
VEC_DOUBLE_LOAD(/* nothing */, 8, 4, 2)
# define VINT8x4_LOAD_DEFINED
#endif

#if !defined(VINT8x4_STORE_ALIGNED_DEFINED) && defined(VINT8x2_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(/* nothing */, 8, 4, 2)
# define VINT8x4_STORE_ALIGNED_DEFINED
#endif

#if !defined(VINT8x4_STORE_DEFINED) && defined(VINT8x2_STORE_DEFINED)
VEC_DOUBLE_STORE(/* nothing */, 8, 4, 2)
# define VINT8x4_STORE_DEFINED
#endif

#if !defined(VINT8x4_ADD_DEFINED) && defined(VINT8x2_ADD_DEFINED)
VEC_DOUBLE_ADD(/* nothing */, 8, 4, 2)
# define VINT8x4_ADD_DEFINED
#endif

#if !defined(VINT8x4_SUB_DEFINED) && defined(VINT8x2_SUB_DEFINED)
VEC_DOUBLE_SUB(/* nothing */, 8, 4, 2)
# define VINT8x4_SUB_DEFINED
#endif

#if !defined(VINT8x4_MUL_DEFINED) && defined(VINT8x2_MUL_DEFINED)
VEC_DOUBLE_MUL(/* nothing */, 8, 4, 2)
# define VINT8x4_MUL_DEFINED
#endif

#if !defined(VINT8x4_DIV_DEFINED) && defined(VINT8x2_DIV_DEFINED)
VEC_DOUBLE_DIV(/* nothing */, 8, 4, 2)
# define VINT8x4_DIV_DEFINED
#endif

#if !defined(VINT8x4_MOD_DEFINED) && defined(VINT8x2_MOD_DEFINED)
VEC_DOUBLE_MOD(/* nothing */, 8, 4, 2)
# define VINT8x4_MOD_DEFINED
#endif

#if !defined(VINT8x4_AVG_DEFINED) && defined(VINT8x2_AVG_DEFINED)
VEC_DOUBLE_AVG(/* nothing */, 8, 4, 2)
# define VINT8x4_AVG_DEFINED
#endif

#if !defined(VINT8x4_AND_DEFINED) && defined(VINT8x2_AND_DEFINED)
VEC_DOUBLE_AND(/* nothing */, 8, 4, 2)
# define VINT8x4_AND_DEFINED
#endif

#if !defined(VINT8x4_OR_DEFINED) && defined(VINT8x2_OR_DEFINED)
VEC_DOUBLE_OR(/* nothing */, 8, 4, 2)
# define VINT8x4_OR_DEFINED
#endif

#if !defined(VINT8x4_XOR_DEFINED) && defined(VINT8x2_XOR_DEFINED)
VEC_DOUBLE_XOR(/* nothing */, 8, 4, 2)
# define VINT8x4_XOR_DEFINED
#endif

#if !defined(VINT8x4_NOT_DEFINED) && defined(VINT8x2_NOT_DEFINED)
VEC_DOUBLE_NOT(/* nothing */, 8, 4, 2)
# define VINT8x4_NOT_DEFINED
#endif

#if !defined(VINT8x4_CMPLT_DEFINED) && defined(VINT8x2_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(/* nothing */, 8, 4, 2)
# define VINT8x4_CMPLT_DEFINED
#endif

#if !defined(VINT8x4_CMPEQ_DEFINED) && defined(VINT8x2_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(/* nothing */, 8, 4, 2)
# define VINT8x4_CMPEQ_DEFINED
#endif

#if !defined(VINT8x4_CMPGT_DEFINED) && defined(VINT8x2_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(/* nothing */, 8, 4, 2)
# define VINT8x4_CMPGT_DEFINED
#endif

#if !defined(VINT8x4_CMPLE_DEFINED) && defined(VINT8x2_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(/* nothing */, 8, 4, 2)
# define VINT8x4_CMPLE_DEFINED
#endif

#if !defined(VINT8x4_CMPGE_DEFINED) && defined(VINT8x2_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(/* nothing */, 8, 4, 2)
# define VINT8x4_CMPGE_DEFINED
#endif

#if !defined(VINT8x4_MIN_DEFINED) && defined(VINT8x2_MIN_DEFINED)
VEC_DOUBLE_MIN(/* nothing */, 8, 4, 2)
# define VINT8x4_MIN_DEFINED
#endif

#if !defined(VINT8x4_MAX_DEFINED) && defined(VINT8x2_MAX_DEFINED)
VEC_DOUBLE_MAX(/* nothing */, 8, 4, 2)
# define VINT8x4_MAX_DEFINED
#endif

#if !defined(VINT8x4_RSHIFT_DEFINED) && defined(VINT8x2_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(/* nothing */, 8, 4, 2)
# define VINT8x4_RSHIFT_DEFINED
#endif

#if !defined(VINT8x4_LRSHIFT_DEFINED) && defined(VINT8x2_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(/* nothing */, 8, 4, 2)
# define VINT8x4_LRSHIFT_DEFINED
#endif

#if !defined(VINT8x4_LSHIFT_DEFINED) && defined(VINT8x2_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(/* nothing */, 8, 4, 2)
# define VINT8x4_LSHIFT_DEFINED
#endif



/* vint8x4 */

#if !defined(VUINT8x4_SPLAT_DEFINED) && defined(VUINT8x2_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(u, 8, 4, 2)
# define VUINT8x4_SPLAT_DEFINED
#endif

#if !defined(VUINT8x4_LOAD_ALIGNED_DEFINED) && defined(VUINT8x2_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(u, 8, 4, 2)
# define VUINT8x4_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VUINT8x4_LOAD_DEFINED) && defined(VUINT8x2_LOAD_DEFINED)
VEC_DOUBLE_LOAD(u, 8, 4, 2)
# define VUINT8x4_LOAD_DEFINED
#endif

#if !defined(VUINT8x4_STORE_ALIGNED_DEFINED) && defined(VUINT8x2_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(u, 8, 4, 2)
# define VUINT8x4_STORE_ALIGNED_DEFINED
#endif

#if !defined(VUINT8x4_STORE_DEFINED) && defined(VUINT8x2_STORE_DEFINED)
VEC_DOUBLE_STORE(u, 8, 4, 2)
# define VUINT8x4_STORE_DEFINED
#endif

#if !defined(VUINT8x4_ADD_DEFINED) && defined(VUINT8x2_ADD_DEFINED)
VEC_DOUBLE_ADD(u, 8, 4, 2)
# define VUINT8x4_ADD_DEFINED
#endif

#if !defined(VUINT8x4_SUB_DEFINED) && defined(VUINT8x2_SUB_DEFINED)
VEC_DOUBLE_SUB(u, 8, 4, 2)
# define VUINT8x4_SUB_DEFINED
#endif

#if !defined(VUINT8x4_MUL_DEFINED) && defined(VUINT8x2_MUL_DEFINED)
VEC_DOUBLE_MUL(u, 8, 4, 2)
# define VUINT8x4_MUL_DEFINED
#endif

#if !defined(VUINT8x4_DIV_DEFINED) && defined(VUINT8x2_DIV_DEFINED)
VEC_DOUBLE_DIV(u, 8, 4, 2)
# define VUINT8x4_DIV_DEFINED
#endif

#if !defined(VUINT8x4_MOD_DEFINED) && defined(VUINT8x2_MOD_DEFINED)
VEC_DOUBLE_MOD(u, 8, 4, 2)
# define VUINT8x4_MOD_DEFINED
#endif

#if !defined(VUINT8x4_AVG_DEFINED) && defined(VUINT8x2_AVG_DEFINED)
VEC_DOUBLE_AVG(u, 8, 4, 2)
# define VUINT8x4_AVG_DEFINED
#endif

#if !defined(VUINT8x4_AND_DEFINED) && defined(VUINT8x2_AND_DEFINED)
VEC_DOUBLE_AND(u, 8, 4, 2)
# define VUINT8x4_AND_DEFINED
#endif

#if !defined(VUINT8x4_OR_DEFINED) && defined(VUINT8x2_OR_DEFINED)
VEC_DOUBLE_OR(u, 8, 4, 2)
# define VUINT8x4_OR_DEFINED
#endif

#if !defined(VUINT8x4_XOR_DEFINED) && defined(VUINT8x2_XOR_DEFINED)
VEC_DOUBLE_XOR(u, 8, 4, 2)
# define VUINT8x4_XOR_DEFINED
#endif

#if !defined(VUINT8x4_NOT_DEFINED) && defined(VUINT8x2_NOT_DEFINED)
VEC_DOUBLE_NOT(u, 8, 4, 2)
# define VUINT8x4_NOT_DEFINED
#endif

#if !defined(VUINT8x4_CMPLT_DEFINED) && defined(VUINT8x2_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(u, 8, 4, 2)
# define VUINT8x4_CMPLT_DEFINED
#endif

#if !defined(VUINT8x4_CMPEQ_DEFINED) && defined(VUINT8x2_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(u, 8, 4, 2)
# define VUINT8x4_CMPEQ_DEFINED
#endif

#if !defined(VUINT8x4_CMPGT_DEFINED) && defined(VUINT8x2_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(u, 8, 4, 2)
# define VUINT8x4_CMPGT_DEFINED
#endif

#if !defined(VUINT8x4_CMPLE_DEFINED) && defined(VUINT8x2_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(u, 8, 4, 2)
# define VUINT8x4_CMPLE_DEFINED
#endif

#if !defined(VUINT8x4_CMPGE_DEFINED) && defined(VUINT8x2_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(u, 8, 4, 2)
# define VUINT8x4_CMPGE_DEFINED
#endif

#if !defined(VUINT8x4_MIN_DEFINED) && defined(VUINT8x2_MIN_DEFINED)
VEC_DOUBLE_MIN(u, 8, 4, 2)
# define VUINT8x4_MIN_DEFINED
#endif

#if !defined(VUINT8x4_MAX_DEFINED) && defined(VUINT8x2_MAX_DEFINED)
VEC_DOUBLE_MAX(u, 8, 4, 2)
# define VUINT8x4_MAX_DEFINED
#endif

#if !defined(VUINT8x4_RSHIFT_DEFINED) && defined(VUINT8x2_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(u, 8, 4, 2)
# define VUINT8x4_RSHIFT_DEFINED
#endif

#if !defined(VUINT8x4_LRSHIFT_DEFINED) && defined(VUINT8x2_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(u, 8, 4, 2)
# define VUINT8x4_LRSHIFT_DEFINED
#endif

#if !defined(VUINT8x4_LSHIFT_DEFINED) && defined(VUINT8x2_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(u, 8, 4, 2)
# define VUINT8x4_LSHIFT_DEFINED
#endif



/* vuint8x8 */

#if !defined(VINT8x8_SPLAT_DEFINED) && defined(VINT8x4_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(/* nothing */, 8, 8, 4)
# define VINT8x8_SPLAT_DEFINED
#endif

#if !defined(VINT8x8_LOAD_ALIGNED_DEFINED) && defined(VINT8x4_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(/* nothing */, 8, 8, 4)
# define VINT8x8_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VINT8x8_LOAD_DEFINED) && defined(VINT8x4_LOAD_DEFINED)
VEC_DOUBLE_LOAD(/* nothing */, 8, 8, 4)
# define VINT8x8_LOAD_DEFINED
#endif

#if !defined(VINT8x8_STORE_ALIGNED_DEFINED) && defined(VINT8x4_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(/* nothing */, 8, 8, 4)
# define VINT8x8_STORE_ALIGNED_DEFINED
#endif

#if !defined(VINT8x8_STORE_DEFINED) && defined(VINT8x4_STORE_DEFINED)
VEC_DOUBLE_STORE(/* nothing */, 8, 8, 4)
# define VINT8x8_STORE_DEFINED
#endif

#if !defined(VINT8x8_ADD_DEFINED) && defined(VINT8x4_ADD_DEFINED)
VEC_DOUBLE_ADD(/* nothing */, 8, 8, 4)
# define VINT8x8_ADD_DEFINED
#endif

#if !defined(VINT8x8_SUB_DEFINED) && defined(VINT8x4_SUB_DEFINED)
VEC_DOUBLE_SUB(/* nothing */, 8, 8, 4)
# define VINT8x8_SUB_DEFINED
#endif

#if !defined(VINT8x8_MUL_DEFINED) && defined(VINT8x4_MUL_DEFINED)
VEC_DOUBLE_MUL(/* nothing */, 8, 8, 4)
# define VINT8x8_MUL_DEFINED
#endif

#if !defined(VINT8x8_DIV_DEFINED) && defined(VINT8x4_DIV_DEFINED)
VEC_DOUBLE_DIV(/* nothing */, 8, 8, 4)
# define VINT8x8_DIV_DEFINED
#endif

#if !defined(VINT8x8_MOD_DEFINED) && defined(VINT8x4_MOD_DEFINED)
VEC_DOUBLE_MOD(/* nothing */, 8, 8, 4)
# define VINT8x8_MOD_DEFINED
#endif

#if !defined(VINT8x8_AVG_DEFINED) && defined(VINT8x4_AVG_DEFINED)
VEC_DOUBLE_AVG(/* nothing */, 8, 8, 4)
# define VINT8x8_AVG_DEFINED
#endif

#if !defined(VINT8x8_AND_DEFINED) && defined(VINT8x4_AND_DEFINED)
VEC_DOUBLE_AND(/* nothing */, 8, 8, 4)
# define VINT8x8_AND_DEFINED
#endif

#if !defined(VINT8x8_OR_DEFINED) && defined(VINT8x4_OR_DEFINED)
VEC_DOUBLE_OR(/* nothing */, 8, 8, 4)
# define VINT8x8_OR_DEFINED
#endif

#if !defined(VINT8x8_XOR_DEFINED) && defined(VINT8x4_XOR_DEFINED)
VEC_DOUBLE_XOR(/* nothing */, 8, 8, 4)
# define VINT8x8_XOR_DEFINED
#endif

#if !defined(VINT8x8_NOT_DEFINED) && defined(VINT8x4_NOT_DEFINED)
VEC_DOUBLE_NOT(/* nothing */, 8, 8, 4)
# define VINT8x8_NOT_DEFINED
#endif

#if !defined(VINT8x8_CMPLT_DEFINED) && defined(VINT8x4_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(/* nothing */, 8, 8, 4)
# define VINT8x8_CMPLT_DEFINED
#endif

#if !defined(VINT8x8_CMPEQ_DEFINED) && defined(VINT8x4_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(/* nothing */, 8, 8, 4)
# define VINT8x8_CMPEQ_DEFINED
#endif

#if !defined(VINT8x8_CMPGT_DEFINED) && defined(VINT8x4_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(/* nothing */, 8, 8, 4)
# define VINT8x8_CMPGT_DEFINED
#endif

#if !defined(VINT8x8_CMPLE_DEFINED) && defined(VINT8x4_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(/* nothing */, 8, 8, 4)
# define VINT8x8_CMPLE_DEFINED
#endif

#if !defined(VINT8x8_CMPGE_DEFINED) && defined(VINT8x4_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(/* nothing */, 8, 8, 4)
# define VINT8x8_CMPGE_DEFINED
#endif

#if !defined(VINT8x8_MIN_DEFINED) && defined(VINT8x4_MIN_DEFINED)
VEC_DOUBLE_MIN(/* nothing */, 8, 8, 4)
# define VINT8x8_MIN_DEFINED
#endif

#if !defined(VINT8x8_MAX_DEFINED) && defined(VINT8x4_MAX_DEFINED)
VEC_DOUBLE_MAX(/* nothing */, 8, 8, 4)
# define VINT8x8_MAX_DEFINED
#endif

#if !defined(VINT8x8_RSHIFT_DEFINED) && defined(VINT8x4_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(/* nothing */, 8, 8, 4)
# define VINT8x8_RSHIFT_DEFINED
#endif

#if !defined(VINT8x8_LRSHIFT_DEFINED) && defined(VINT8x4_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(/* nothing */, 8, 8, 4)
# define VINT8x8_LRSHIFT_DEFINED
#endif

#if !defined(VINT8x8_LSHIFT_DEFINED) && defined(VINT8x4_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(/* nothing */, 8, 8, 4)
# define VINT8x8_LSHIFT_DEFINED
#endif



/* vint8x8 */

#if !defined(VUINT8x8_SPLAT_DEFINED) && defined(VUINT8x4_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(u, 8, 8, 4)
# define VUINT8x8_SPLAT_DEFINED
#endif

#if !defined(VUINT8x8_LOAD_ALIGNED_DEFINED) && defined(VUINT8x4_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(u, 8, 8, 4)
# define VUINT8x8_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VUINT8x8_LOAD_DEFINED) && defined(VUINT8x4_LOAD_DEFINED)
VEC_DOUBLE_LOAD(u, 8, 8, 4)
# define VUINT8x8_LOAD_DEFINED
#endif

#if !defined(VUINT8x8_STORE_ALIGNED_DEFINED) && defined(VUINT8x4_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(u, 8, 8, 4)
# define VUINT8x8_STORE_ALIGNED_DEFINED
#endif

#if !defined(VUINT8x8_STORE_DEFINED) && defined(VUINT8x4_STORE_DEFINED)
VEC_DOUBLE_STORE(u, 8, 8, 4)
# define VUINT8x8_STORE_DEFINED
#endif

#if !defined(VUINT8x8_ADD_DEFINED) && defined(VUINT8x4_ADD_DEFINED)
VEC_DOUBLE_ADD(u, 8, 8, 4)
# define VUINT8x8_ADD_DEFINED
#endif

#if !defined(VUINT8x8_SUB_DEFINED) && defined(VUINT8x4_SUB_DEFINED)
VEC_DOUBLE_SUB(u, 8, 8, 4)
# define VUINT8x8_SUB_DEFINED
#endif

#if !defined(VUINT8x8_MUL_DEFINED) && defined(VUINT8x4_MUL_DEFINED)
VEC_DOUBLE_MUL(u, 8, 8, 4)
# define VUINT8x8_MUL_DEFINED
#endif

#if !defined(VUINT8x8_DIV_DEFINED) && defined(VUINT8x4_DIV_DEFINED)
VEC_DOUBLE_DIV(u, 8, 8, 4)
# define VUINT8x8_DIV_DEFINED
#endif

#if !defined(VUINT8x8_MOD_DEFINED) && defined(VUINT8x4_MOD_DEFINED)
VEC_DOUBLE_MOD(u, 8, 8, 4)
# define VUINT8x8_MOD_DEFINED
#endif

#if !defined(VUINT8x8_AVG_DEFINED) && defined(VUINT8x4_AVG_DEFINED)
VEC_DOUBLE_AVG(u, 8, 8, 4)
# define VUINT8x8_AVG_DEFINED
#endif

#if !defined(VUINT8x8_AND_DEFINED) && defined(VUINT8x4_AND_DEFINED)
VEC_DOUBLE_AND(u, 8, 8, 4)
# define VUINT8x8_AND_DEFINED
#endif

#if !defined(VUINT8x8_OR_DEFINED) && defined(VUINT8x4_OR_DEFINED)
VEC_DOUBLE_OR(u, 8, 8, 4)
# define VUINT8x8_OR_DEFINED
#endif

#if !defined(VUINT8x8_XOR_DEFINED) && defined(VUINT8x4_XOR_DEFINED)
VEC_DOUBLE_XOR(u, 8, 8, 4)
# define VUINT8x8_XOR_DEFINED
#endif

#if !defined(VUINT8x8_NOT_DEFINED) && defined(VUINT8x4_NOT_DEFINED)
VEC_DOUBLE_NOT(u, 8, 8, 4)
# define VUINT8x8_NOT_DEFINED
#endif

#if !defined(VUINT8x8_CMPLT_DEFINED) && defined(VUINT8x4_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(u, 8, 8, 4)
# define VUINT8x8_CMPLT_DEFINED
#endif

#if !defined(VUINT8x8_CMPEQ_DEFINED) && defined(VUINT8x4_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(u, 8, 8, 4)
# define VUINT8x8_CMPEQ_DEFINED
#endif

#if !defined(VUINT8x8_CMPGT_DEFINED) && defined(VUINT8x4_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(u, 8, 8, 4)
# define VUINT8x8_CMPGT_DEFINED
#endif

#if !defined(VUINT8x8_CMPLE_DEFINED) && defined(VUINT8x4_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(u, 8, 8, 4)
# define VUINT8x8_CMPLE_DEFINED
#endif

#if !defined(VUINT8x8_CMPGE_DEFINED) && defined(VUINT8x4_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(u, 8, 8, 4)
# define VUINT8x8_CMPGE_DEFINED
#endif

#if !defined(VUINT8x8_MIN_DEFINED) && defined(VUINT8x4_MIN_DEFINED)
VEC_DOUBLE_MIN(u, 8, 8, 4)
# define VUINT8x8_MIN_DEFINED
#endif

#if !defined(VUINT8x8_MAX_DEFINED) && defined(VUINT8x4_MAX_DEFINED)
VEC_DOUBLE_MAX(u, 8, 8, 4)
# define VUINT8x8_MAX_DEFINED
#endif

#if !defined(VUINT8x8_RSHIFT_DEFINED) && defined(VUINT8x4_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(u, 8, 8, 4)
# define VUINT8x8_RSHIFT_DEFINED
#endif

#if !defined(VUINT8x8_LRSHIFT_DEFINED) && defined(VUINT8x4_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(u, 8, 8, 4)
# define VUINT8x8_LRSHIFT_DEFINED
#endif

#if !defined(VUINT8x8_LSHIFT_DEFINED) && defined(VUINT8x4_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(u, 8, 8, 4)
# define VUINT8x8_LSHIFT_DEFINED
#endif



/* vuint8x16 */

#if !defined(VINT8x16_SPLAT_DEFINED) && defined(VINT8x8_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(/* nothing */, 8, 16, 8)
# define VINT8x16_SPLAT_DEFINED
#endif

#if !defined(VINT8x16_LOAD_ALIGNED_DEFINED) && defined(VINT8x8_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(/* nothing */, 8, 16, 8)
# define VINT8x16_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VINT8x16_LOAD_DEFINED) && defined(VINT8x8_LOAD_DEFINED)
VEC_DOUBLE_LOAD(/* nothing */, 8, 16, 8)
# define VINT8x16_LOAD_DEFINED
#endif

#if !defined(VINT8x16_STORE_ALIGNED_DEFINED) && defined(VINT8x8_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(/* nothing */, 8, 16, 8)
# define VINT8x16_STORE_ALIGNED_DEFINED
#endif

#if !defined(VINT8x16_STORE_DEFINED) && defined(VINT8x8_STORE_DEFINED)
VEC_DOUBLE_STORE(/* nothing */, 8, 16, 8)
# define VINT8x16_STORE_DEFINED
#endif

#if !defined(VINT8x16_ADD_DEFINED) && defined(VINT8x8_ADD_DEFINED)
VEC_DOUBLE_ADD(/* nothing */, 8, 16, 8)
# define VINT8x16_ADD_DEFINED
#endif

#if !defined(VINT8x16_SUB_DEFINED) && defined(VINT8x8_SUB_DEFINED)
VEC_DOUBLE_SUB(/* nothing */, 8, 16, 8)
# define VINT8x16_SUB_DEFINED
#endif

#if !defined(VINT8x16_MUL_DEFINED) && defined(VINT8x8_MUL_DEFINED)
VEC_DOUBLE_MUL(/* nothing */, 8, 16, 8)
# define VINT8x16_MUL_DEFINED
#endif

#if !defined(VINT8x16_DIV_DEFINED) && defined(VINT8x8_DIV_DEFINED)
VEC_DOUBLE_DIV(/* nothing */, 8, 16, 8)
# define VINT8x16_DIV_DEFINED
#endif

#if !defined(VINT8x16_MOD_DEFINED) && defined(VINT8x8_MOD_DEFINED)
VEC_DOUBLE_MOD(/* nothing */, 8, 16, 8)
# define VINT8x16_MOD_DEFINED
#endif

#if !defined(VINT8x16_AVG_DEFINED) && defined(VINT8x8_AVG_DEFINED)
VEC_DOUBLE_AVG(/* nothing */, 8, 16, 8)
# define VINT8x16_AVG_DEFINED
#endif

#if !defined(VINT8x16_AND_DEFINED) && defined(VINT8x8_AND_DEFINED)
VEC_DOUBLE_AND(/* nothing */, 8, 16, 8)
# define VINT8x16_AND_DEFINED
#endif

#if !defined(VINT8x16_OR_DEFINED) && defined(VINT8x8_OR_DEFINED)
VEC_DOUBLE_OR(/* nothing */, 8, 16, 8)
# define VINT8x16_OR_DEFINED
#endif

#if !defined(VINT8x16_XOR_DEFINED) && defined(VINT8x8_XOR_DEFINED)
VEC_DOUBLE_XOR(/* nothing */, 8, 16, 8)
# define VINT8x16_XOR_DEFINED
#endif

#if !defined(VINT8x16_NOT_DEFINED) && defined(VINT8x8_NOT_DEFINED)
VEC_DOUBLE_NOT(/* nothing */, 8, 16, 8)
# define VINT8x16_NOT_DEFINED
#endif

#if !defined(VINT8x16_CMPLT_DEFINED) && defined(VINT8x8_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(/* nothing */, 8, 16, 8)
# define VINT8x16_CMPLT_DEFINED
#endif

#if !defined(VINT8x16_CMPEQ_DEFINED) && defined(VINT8x8_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(/* nothing */, 8, 16, 8)
# define VINT8x16_CMPEQ_DEFINED
#endif

#if !defined(VINT8x16_CMPGT_DEFINED) && defined(VINT8x8_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(/* nothing */, 8, 16, 8)
# define VINT8x16_CMPGT_DEFINED
#endif

#if !defined(VINT8x16_CMPLE_DEFINED) && defined(VINT8x8_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(/* nothing */, 8, 16, 8)
# define VINT8x16_CMPLE_DEFINED
#endif

#if !defined(VINT8x16_CMPGE_DEFINED) && defined(VINT8x8_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(/* nothing */, 8, 16, 8)
# define VINT8x16_CMPGE_DEFINED
#endif

#if !defined(VINT8x16_MIN_DEFINED) && defined(VINT8x8_MIN_DEFINED)
VEC_DOUBLE_MIN(/* nothing */, 8, 16, 8)
# define VINT8x16_MIN_DEFINED
#endif

#if !defined(VINT8x16_MAX_DEFINED) && defined(VINT8x8_MAX_DEFINED)
VEC_DOUBLE_MAX(/* nothing */, 8, 16, 8)
# define VINT8x16_MAX_DEFINED
#endif

#if !defined(VINT8x16_RSHIFT_DEFINED) && defined(VINT8x8_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(/* nothing */, 8, 16, 8)
# define VINT8x16_RSHIFT_DEFINED
#endif

#if !defined(VINT8x16_LRSHIFT_DEFINED) && defined(VINT8x8_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(/* nothing */, 8, 16, 8)
# define VINT8x16_LRSHIFT_DEFINED
#endif

#if !defined(VINT8x16_LSHIFT_DEFINED) && defined(VINT8x8_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(/* nothing */, 8, 16, 8)
# define VINT8x16_LSHIFT_DEFINED
#endif



/* vint8x16 */

#if !defined(VUINT8x16_SPLAT_DEFINED) && defined(VUINT8x8_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(u, 8, 16, 8)
# define VUINT8x16_SPLAT_DEFINED
#endif

#if !defined(VUINT8x16_LOAD_ALIGNED_DEFINED) && defined(VUINT8x8_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(u, 8, 16, 8)
# define VUINT8x16_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VUINT8x16_LOAD_DEFINED) && defined(VUINT8x8_LOAD_DEFINED)
VEC_DOUBLE_LOAD(u, 8, 16, 8)
# define VUINT8x16_LOAD_DEFINED
#endif

#if !defined(VUINT8x16_STORE_ALIGNED_DEFINED) && defined(VUINT8x8_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(u, 8, 16, 8)
# define VUINT8x16_STORE_ALIGNED_DEFINED
#endif

#if !defined(VUINT8x16_STORE_DEFINED) && defined(VUINT8x8_STORE_DEFINED)
VEC_DOUBLE_STORE(u, 8, 16, 8)
# define VUINT8x16_STORE_DEFINED
#endif

#if !defined(VUINT8x16_ADD_DEFINED) && defined(VUINT8x8_ADD_DEFINED)
VEC_DOUBLE_ADD(u, 8, 16, 8)
# define VUINT8x16_ADD_DEFINED
#endif

#if !defined(VUINT8x16_SUB_DEFINED) && defined(VUINT8x8_SUB_DEFINED)
VEC_DOUBLE_SUB(u, 8, 16, 8)
# define VUINT8x16_SUB_DEFINED
#endif

#if !defined(VUINT8x16_MUL_DEFINED) && defined(VUINT8x8_MUL_DEFINED)
VEC_DOUBLE_MUL(u, 8, 16, 8)
# define VUINT8x16_MUL_DEFINED
#endif

#if !defined(VUINT8x16_DIV_DEFINED) && defined(VUINT8x8_DIV_DEFINED)
VEC_DOUBLE_DIV(u, 8, 16, 8)
# define VUINT8x16_DIV_DEFINED
#endif

#if !defined(VUINT8x16_MOD_DEFINED) && defined(VUINT8x8_MOD_DEFINED)
VEC_DOUBLE_MOD(u, 8, 16, 8)
# define VUINT8x16_MOD_DEFINED
#endif

#if !defined(VUINT8x16_AVG_DEFINED) && defined(VUINT8x8_AVG_DEFINED)
VEC_DOUBLE_AVG(u, 8, 16, 8)
# define VUINT8x16_AVG_DEFINED
#endif

#if !defined(VUINT8x16_AND_DEFINED) && defined(VUINT8x8_AND_DEFINED)
VEC_DOUBLE_AND(u, 8, 16, 8)
# define VUINT8x16_AND_DEFINED
#endif

#if !defined(VUINT8x16_OR_DEFINED) && defined(VUINT8x8_OR_DEFINED)
VEC_DOUBLE_OR(u, 8, 16, 8)
# define VUINT8x16_OR_DEFINED
#endif

#if !defined(VUINT8x16_XOR_DEFINED) && defined(VUINT8x8_XOR_DEFINED)
VEC_DOUBLE_XOR(u, 8, 16, 8)
# define VUINT8x16_XOR_DEFINED
#endif

#if !defined(VUINT8x16_NOT_DEFINED) && defined(VUINT8x8_NOT_DEFINED)
VEC_DOUBLE_NOT(u, 8, 16, 8)
# define VUINT8x16_NOT_DEFINED
#endif

#if !defined(VUINT8x16_CMPLT_DEFINED) && defined(VUINT8x8_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(u, 8, 16, 8)
# define VUINT8x16_CMPLT_DEFINED
#endif

#if !defined(VUINT8x16_CMPEQ_DEFINED) && defined(VUINT8x8_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(u, 8, 16, 8)
# define VUINT8x16_CMPEQ_DEFINED
#endif

#if !defined(VUINT8x16_CMPGT_DEFINED) && defined(VUINT8x8_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(u, 8, 16, 8)
# define VUINT8x16_CMPGT_DEFINED
#endif

#if !defined(VUINT8x16_CMPLE_DEFINED) && defined(VUINT8x8_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(u, 8, 16, 8)
# define VUINT8x16_CMPLE_DEFINED
#endif

#if !defined(VUINT8x16_CMPGE_DEFINED) && defined(VUINT8x8_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(u, 8, 16, 8)
# define VUINT8x16_CMPGE_DEFINED
#endif

#if !defined(VUINT8x16_MIN_DEFINED) && defined(VUINT8x8_MIN_DEFINED)
VEC_DOUBLE_MIN(u, 8, 16, 8)
# define VUINT8x16_MIN_DEFINED
#endif

#if !defined(VUINT8x16_MAX_DEFINED) && defined(VUINT8x8_MAX_DEFINED)
VEC_DOUBLE_MAX(u, 8, 16, 8)
# define VUINT8x16_MAX_DEFINED
#endif

#if !defined(VUINT8x16_RSHIFT_DEFINED) && defined(VUINT8x8_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(u, 8, 16, 8)
# define VUINT8x16_RSHIFT_DEFINED
#endif

#if !defined(VUINT8x16_LRSHIFT_DEFINED) && defined(VUINT8x8_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(u, 8, 16, 8)
# define VUINT8x16_LRSHIFT_DEFINED
#endif

#if !defined(VUINT8x16_LSHIFT_DEFINED) && defined(VUINT8x8_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(u, 8, 16, 8)
# define VUINT8x16_LSHIFT_DEFINED
#endif



/* vuint8x32 */

#if !defined(VINT8x32_SPLAT_DEFINED) && defined(VINT8x16_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(/* nothing */, 8, 32, 16)
# define VINT8x32_SPLAT_DEFINED
#endif

#if !defined(VINT8x32_LOAD_ALIGNED_DEFINED) && defined(VINT8x16_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(/* nothing */, 8, 32, 16)
# define VINT8x32_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VINT8x32_LOAD_DEFINED) && defined(VINT8x16_LOAD_DEFINED)
VEC_DOUBLE_LOAD(/* nothing */, 8, 32, 16)
# define VINT8x32_LOAD_DEFINED
#endif

#if !defined(VINT8x32_STORE_ALIGNED_DEFINED) && defined(VINT8x16_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(/* nothing */, 8, 32, 16)
# define VINT8x32_STORE_ALIGNED_DEFINED
#endif

#if !defined(VINT8x32_STORE_DEFINED) && defined(VINT8x16_STORE_DEFINED)
VEC_DOUBLE_STORE(/* nothing */, 8, 32, 16)
# define VINT8x32_STORE_DEFINED
#endif

#if !defined(VINT8x32_ADD_DEFINED) && defined(VINT8x16_ADD_DEFINED)
VEC_DOUBLE_ADD(/* nothing */, 8, 32, 16)
# define VINT8x32_ADD_DEFINED
#endif

#if !defined(VINT8x32_SUB_DEFINED) && defined(VINT8x16_SUB_DEFINED)
VEC_DOUBLE_SUB(/* nothing */, 8, 32, 16)
# define VINT8x32_SUB_DEFINED
#endif

#if !defined(VINT8x32_MUL_DEFINED) && defined(VINT8x16_MUL_DEFINED)
VEC_DOUBLE_MUL(/* nothing */, 8, 32, 16)
# define VINT8x32_MUL_DEFINED
#endif

#if !defined(VINT8x32_DIV_DEFINED) && defined(VINT8x16_DIV_DEFINED)
VEC_DOUBLE_DIV(/* nothing */, 8, 32, 16)
# define VINT8x32_DIV_DEFINED
#endif

#if !defined(VINT8x32_MOD_DEFINED) && defined(VINT8x16_MOD_DEFINED)
VEC_DOUBLE_MOD(/* nothing */, 8, 32, 16)
# define VINT8x32_MOD_DEFINED
#endif

#if !defined(VINT8x32_AVG_DEFINED) && defined(VINT8x16_AVG_DEFINED)
VEC_DOUBLE_AVG(/* nothing */, 8, 32, 16)
# define VINT8x32_AVG_DEFINED
#endif

#if !defined(VINT8x32_AND_DEFINED) && defined(VINT8x16_AND_DEFINED)
VEC_DOUBLE_AND(/* nothing */, 8, 32, 16)
# define VINT8x32_AND_DEFINED
#endif

#if !defined(VINT8x32_OR_DEFINED) && defined(VINT8x16_OR_DEFINED)
VEC_DOUBLE_OR(/* nothing */, 8, 32, 16)
# define VINT8x32_OR_DEFINED
#endif

#if !defined(VINT8x32_XOR_DEFINED) && defined(VINT8x16_XOR_DEFINED)
VEC_DOUBLE_XOR(/* nothing */, 8, 32, 16)
# define VINT8x32_XOR_DEFINED
#endif

#if !defined(VINT8x32_NOT_DEFINED) && defined(VINT8x16_NOT_DEFINED)
VEC_DOUBLE_NOT(/* nothing */, 8, 32, 16)
# define VINT8x32_NOT_DEFINED
#endif

#if !defined(VINT8x32_CMPLT_DEFINED) && defined(VINT8x16_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(/* nothing */, 8, 32, 16)
# define VINT8x32_CMPLT_DEFINED
#endif

#if !defined(VINT8x32_CMPEQ_DEFINED) && defined(VINT8x16_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(/* nothing */, 8, 32, 16)
# define VINT8x32_CMPEQ_DEFINED
#endif

#if !defined(VINT8x32_CMPGT_DEFINED) && defined(VINT8x16_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(/* nothing */, 8, 32, 16)
# define VINT8x32_CMPGT_DEFINED
#endif

#if !defined(VINT8x32_CMPLE_DEFINED) && defined(VINT8x16_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(/* nothing */, 8, 32, 16)
# define VINT8x32_CMPLE_DEFINED
#endif

#if !defined(VINT8x32_CMPGE_DEFINED) && defined(VINT8x16_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(/* nothing */, 8, 32, 16)
# define VINT8x32_CMPGE_DEFINED
#endif

#if !defined(VINT8x32_MIN_DEFINED) && defined(VINT8x16_MIN_DEFINED)
VEC_DOUBLE_MIN(/* nothing */, 8, 32, 16)
# define VINT8x32_MIN_DEFINED
#endif

#if !defined(VINT8x32_MAX_DEFINED) && defined(VINT8x16_MAX_DEFINED)
VEC_DOUBLE_MAX(/* nothing */, 8, 32, 16)
# define VINT8x32_MAX_DEFINED
#endif

#if !defined(VINT8x32_RSHIFT_DEFINED) && defined(VINT8x16_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(/* nothing */, 8, 32, 16)
# define VINT8x32_RSHIFT_DEFINED
#endif

#if !defined(VINT8x32_LRSHIFT_DEFINED) && defined(VINT8x16_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(/* nothing */, 8, 32, 16)
# define VINT8x32_LRSHIFT_DEFINED
#endif

#if !defined(VINT8x32_LSHIFT_DEFINED) && defined(VINT8x16_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(/* nothing */, 8, 32, 16)
# define VINT8x32_LSHIFT_DEFINED
#endif



/* vint8x32 */

#if !defined(VUINT8x32_SPLAT_DEFINED) && defined(VUINT8x16_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(u, 8, 32, 16)
# define VUINT8x32_SPLAT_DEFINED
#endif

#if !defined(VUINT8x32_LOAD_ALIGNED_DEFINED) && defined(VUINT8x16_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(u, 8, 32, 16)
# define VUINT8x32_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VUINT8x32_LOAD_DEFINED) && defined(VUINT8x16_LOAD_DEFINED)
VEC_DOUBLE_LOAD(u, 8, 32, 16)
# define VUINT8x32_LOAD_DEFINED
#endif

#if !defined(VUINT8x32_STORE_ALIGNED_DEFINED) && defined(VUINT8x16_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(u, 8, 32, 16)
# define VUINT8x32_STORE_ALIGNED_DEFINED
#endif

#if !defined(VUINT8x32_STORE_DEFINED) && defined(VUINT8x16_STORE_DEFINED)
VEC_DOUBLE_STORE(u, 8, 32, 16)
# define VUINT8x32_STORE_DEFINED
#endif

#if !defined(VUINT8x32_ADD_DEFINED) && defined(VUINT8x16_ADD_DEFINED)
VEC_DOUBLE_ADD(u, 8, 32, 16)
# define VUINT8x32_ADD_DEFINED
#endif

#if !defined(VUINT8x32_SUB_DEFINED) && defined(VUINT8x16_SUB_DEFINED)
VEC_DOUBLE_SUB(u, 8, 32, 16)
# define VUINT8x32_SUB_DEFINED
#endif

#if !defined(VUINT8x32_MUL_DEFINED) && defined(VUINT8x16_MUL_DEFINED)
VEC_DOUBLE_MUL(u, 8, 32, 16)
# define VUINT8x32_MUL_DEFINED
#endif

#if !defined(VUINT8x32_DIV_DEFINED) && defined(VUINT8x16_DIV_DEFINED)
VEC_DOUBLE_DIV(u, 8, 32, 16)
# define VUINT8x32_DIV_DEFINED
#endif

#if !defined(VUINT8x32_MOD_DEFINED) && defined(VUINT8x16_MOD_DEFINED)
VEC_DOUBLE_MOD(u, 8, 32, 16)
# define VUINT8x32_MOD_DEFINED
#endif

#if !defined(VUINT8x32_AVG_DEFINED) && defined(VUINT8x16_AVG_DEFINED)
VEC_DOUBLE_AVG(u, 8, 32, 16)
# define VUINT8x32_AVG_DEFINED
#endif

#if !defined(VUINT8x32_AND_DEFINED) && defined(VUINT8x16_AND_DEFINED)
VEC_DOUBLE_AND(u, 8, 32, 16)
# define VUINT8x32_AND_DEFINED
#endif

#if !defined(VUINT8x32_OR_DEFINED) && defined(VUINT8x16_OR_DEFINED)
VEC_DOUBLE_OR(u, 8, 32, 16)
# define VUINT8x32_OR_DEFINED
#endif

#if !defined(VUINT8x32_XOR_DEFINED) && defined(VUINT8x16_XOR_DEFINED)
VEC_DOUBLE_XOR(u, 8, 32, 16)
# define VUINT8x32_XOR_DEFINED
#endif

#if !defined(VUINT8x32_NOT_DEFINED) && defined(VUINT8x16_NOT_DEFINED)
VEC_DOUBLE_NOT(u, 8, 32, 16)
# define VUINT8x32_NOT_DEFINED
#endif

#if !defined(VUINT8x32_CMPLT_DEFINED) && defined(VUINT8x16_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(u, 8, 32, 16)
# define VUINT8x32_CMPLT_DEFINED
#endif

#if !defined(VUINT8x32_CMPEQ_DEFINED) && defined(VUINT8x16_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(u, 8, 32, 16)
# define VUINT8x32_CMPEQ_DEFINED
#endif

#if !defined(VUINT8x32_CMPGT_DEFINED) && defined(VUINT8x16_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(u, 8, 32, 16)
# define VUINT8x32_CMPGT_DEFINED
#endif

#if !defined(VUINT8x32_CMPLE_DEFINED) && defined(VUINT8x16_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(u, 8, 32, 16)
# define VUINT8x32_CMPLE_DEFINED
#endif

#if !defined(VUINT8x32_CMPGE_DEFINED) && defined(VUINT8x16_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(u, 8, 32, 16)
# define VUINT8x32_CMPGE_DEFINED
#endif

#if !defined(VUINT8x32_MIN_DEFINED) && defined(VUINT8x16_MIN_DEFINED)
VEC_DOUBLE_MIN(u, 8, 32, 16)
# define VUINT8x32_MIN_DEFINED
#endif

#if !defined(VUINT8x32_MAX_DEFINED) && defined(VUINT8x16_MAX_DEFINED)
VEC_DOUBLE_MAX(u, 8, 32, 16)
# define VUINT8x32_MAX_DEFINED
#endif

#if !defined(VUINT8x32_RSHIFT_DEFINED) && defined(VUINT8x16_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(u, 8, 32, 16)
# define VUINT8x32_RSHIFT_DEFINED
#endif

#if !defined(VUINT8x32_LRSHIFT_DEFINED) && defined(VUINT8x16_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(u, 8, 32, 16)
# define VUINT8x32_LRSHIFT_DEFINED
#endif

#if !defined(VUINT8x32_LSHIFT_DEFINED) && defined(VUINT8x16_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(u, 8, 32, 16)
# define VUINT8x32_LSHIFT_DEFINED
#endif



/* vuint8x64 */

#if !defined(VINT8x64_SPLAT_DEFINED) && defined(VINT8x32_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(/* nothing */, 8, 64, 32)
# define VINT8x64_SPLAT_DEFINED
#endif

#if !defined(VINT8x64_LOAD_ALIGNED_DEFINED) && defined(VINT8x32_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(/* nothing */, 8, 64, 32)
# define VINT8x64_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VINT8x64_LOAD_DEFINED) && defined(VINT8x32_LOAD_DEFINED)
VEC_DOUBLE_LOAD(/* nothing */, 8, 64, 32)
# define VINT8x64_LOAD_DEFINED
#endif

#if !defined(VINT8x64_STORE_ALIGNED_DEFINED) && defined(VINT8x32_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(/* nothing */, 8, 64, 32)
# define VINT8x64_STORE_ALIGNED_DEFINED
#endif

#if !defined(VINT8x64_STORE_DEFINED) && defined(VINT8x32_STORE_DEFINED)
VEC_DOUBLE_STORE(/* nothing */, 8, 64, 32)
# define VINT8x64_STORE_DEFINED
#endif

#if !defined(VINT8x64_ADD_DEFINED) && defined(VINT8x32_ADD_DEFINED)
VEC_DOUBLE_ADD(/* nothing */, 8, 64, 32)
# define VINT8x64_ADD_DEFINED
#endif

#if !defined(VINT8x64_SUB_DEFINED) && defined(VINT8x32_SUB_DEFINED)
VEC_DOUBLE_SUB(/* nothing */, 8, 64, 32)
# define VINT8x64_SUB_DEFINED
#endif

#if !defined(VINT8x64_MUL_DEFINED) && defined(VINT8x32_MUL_DEFINED)
VEC_DOUBLE_MUL(/* nothing */, 8, 64, 32)
# define VINT8x64_MUL_DEFINED
#endif

#if !defined(VINT8x64_DIV_DEFINED) && defined(VINT8x32_DIV_DEFINED)
VEC_DOUBLE_DIV(/* nothing */, 8, 64, 32)
# define VINT8x64_DIV_DEFINED
#endif

#if !defined(VINT8x64_MOD_DEFINED) && defined(VINT8x32_MOD_DEFINED)
VEC_DOUBLE_MOD(/* nothing */, 8, 64, 32)
# define VINT8x64_MOD_DEFINED
#endif

#if !defined(VINT8x64_AVG_DEFINED) && defined(VINT8x32_AVG_DEFINED)
VEC_DOUBLE_AVG(/* nothing */, 8, 64, 32)
# define VINT8x64_AVG_DEFINED
#endif

#if !defined(VINT8x64_AND_DEFINED) && defined(VINT8x32_AND_DEFINED)
VEC_DOUBLE_AND(/* nothing */, 8, 64, 32)
# define VINT8x64_AND_DEFINED
#endif

#if !defined(VINT8x64_OR_DEFINED) && defined(VINT8x32_OR_DEFINED)
VEC_DOUBLE_OR(/* nothing */, 8, 64, 32)
# define VINT8x64_OR_DEFINED
#endif

#if !defined(VINT8x64_XOR_DEFINED) && defined(VINT8x32_XOR_DEFINED)
VEC_DOUBLE_XOR(/* nothing */, 8, 64, 32)
# define VINT8x64_XOR_DEFINED
#endif

#if !defined(VINT8x64_NOT_DEFINED) && defined(VINT8x32_NOT_DEFINED)
VEC_DOUBLE_NOT(/* nothing */, 8, 64, 32)
# define VINT8x64_NOT_DEFINED
#endif

#if !defined(VINT8x64_CMPLT_DEFINED) && defined(VINT8x32_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(/* nothing */, 8, 64, 32)
# define VINT8x64_CMPLT_DEFINED
#endif

#if !defined(VINT8x64_CMPEQ_DEFINED) && defined(VINT8x32_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(/* nothing */, 8, 64, 32)
# define VINT8x64_CMPEQ_DEFINED
#endif

#if !defined(VINT8x64_CMPGT_DEFINED) && defined(VINT8x32_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(/* nothing */, 8, 64, 32)
# define VINT8x64_CMPGT_DEFINED
#endif

#if !defined(VINT8x64_CMPLE_DEFINED) && defined(VINT8x32_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(/* nothing */, 8, 64, 32)
# define VINT8x64_CMPLE_DEFINED
#endif

#if !defined(VINT8x64_CMPGE_DEFINED) && defined(VINT8x32_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(/* nothing */, 8, 64, 32)
# define VINT8x64_CMPGE_DEFINED
#endif

#if !defined(VINT8x64_MIN_DEFINED) && defined(VINT8x32_MIN_DEFINED)
VEC_DOUBLE_MIN(/* nothing */, 8, 64, 32)
# define VINT8x64_MIN_DEFINED
#endif

#if !defined(VINT8x64_MAX_DEFINED) && defined(VINT8x32_MAX_DEFINED)
VEC_DOUBLE_MAX(/* nothing */, 8, 64, 32)
# define VINT8x64_MAX_DEFINED
#endif

#if !defined(VINT8x64_RSHIFT_DEFINED) && defined(VINT8x32_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(/* nothing */, 8, 64, 32)
# define VINT8x64_RSHIFT_DEFINED
#endif

#if !defined(VINT8x64_LRSHIFT_DEFINED) && defined(VINT8x32_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(/* nothing */, 8, 64, 32)
# define VINT8x64_LRSHIFT_DEFINED
#endif

#if !defined(VINT8x64_LSHIFT_DEFINED) && defined(VINT8x32_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(/* nothing */, 8, 64, 32)
# define VINT8x64_LSHIFT_DEFINED
#endif



/* vint8x64 */

#if !defined(VUINT8x64_SPLAT_DEFINED) && defined(VUINT8x32_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(u, 8, 64, 32)
# define VUINT8x64_SPLAT_DEFINED
#endif

#if !defined(VUINT8x64_LOAD_ALIGNED_DEFINED) && defined(VUINT8x32_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(u, 8, 64, 32)
# define VUINT8x64_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VUINT8x64_LOAD_DEFINED) && defined(VUINT8x32_LOAD_DEFINED)
VEC_DOUBLE_LOAD(u, 8, 64, 32)
# define VUINT8x64_LOAD_DEFINED
#endif

#if !defined(VUINT8x64_STORE_ALIGNED_DEFINED) && defined(VUINT8x32_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(u, 8, 64, 32)
# define VUINT8x64_STORE_ALIGNED_DEFINED
#endif

#if !defined(VUINT8x64_STORE_DEFINED) && defined(VUINT8x32_STORE_DEFINED)
VEC_DOUBLE_STORE(u, 8, 64, 32)
# define VUINT8x64_STORE_DEFINED
#endif

#if !defined(VUINT8x64_ADD_DEFINED) && defined(VUINT8x32_ADD_DEFINED)
VEC_DOUBLE_ADD(u, 8, 64, 32)
# define VUINT8x64_ADD_DEFINED
#endif

#if !defined(VUINT8x64_SUB_DEFINED) && defined(VUINT8x32_SUB_DEFINED)
VEC_DOUBLE_SUB(u, 8, 64, 32)
# define VUINT8x64_SUB_DEFINED
#endif

#if !defined(VUINT8x64_MUL_DEFINED) && defined(VUINT8x32_MUL_DEFINED)
VEC_DOUBLE_MUL(u, 8, 64, 32)
# define VUINT8x64_MUL_DEFINED
#endif

#if !defined(VUINT8x64_DIV_DEFINED) && defined(VUINT8x32_DIV_DEFINED)
VEC_DOUBLE_DIV(u, 8, 64, 32)
# define VUINT8x64_DIV_DEFINED
#endif

#if !defined(VUINT8x64_MOD_DEFINED) && defined(VUINT8x32_MOD_DEFINED)
VEC_DOUBLE_MOD(u, 8, 64, 32)
# define VUINT8x64_MOD_DEFINED
#endif

#if !defined(VUINT8x64_AVG_DEFINED) && defined(VUINT8x32_AVG_DEFINED)
VEC_DOUBLE_AVG(u, 8, 64, 32)
# define VUINT8x64_AVG_DEFINED
#endif

#if !defined(VUINT8x64_AND_DEFINED) && defined(VUINT8x32_AND_DEFINED)
VEC_DOUBLE_AND(u, 8, 64, 32)
# define VUINT8x64_AND_DEFINED
#endif

#if !defined(VUINT8x64_OR_DEFINED) && defined(VUINT8x32_OR_DEFINED)
VEC_DOUBLE_OR(u, 8, 64, 32)
# define VUINT8x64_OR_DEFINED
#endif

#if !defined(VUINT8x64_XOR_DEFINED) && defined(VUINT8x32_XOR_DEFINED)
VEC_DOUBLE_XOR(u, 8, 64, 32)
# define VUINT8x64_XOR_DEFINED
#endif

#if !defined(VUINT8x64_NOT_DEFINED) && defined(VUINT8x32_NOT_DEFINED)
VEC_DOUBLE_NOT(u, 8, 64, 32)
# define VUINT8x64_NOT_DEFINED
#endif

#if !defined(VUINT8x64_CMPLT_DEFINED) && defined(VUINT8x32_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(u, 8, 64, 32)
# define VUINT8x64_CMPLT_DEFINED
#endif

#if !defined(VUINT8x64_CMPEQ_DEFINED) && defined(VUINT8x32_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(u, 8, 64, 32)
# define VUINT8x64_CMPEQ_DEFINED
#endif

#if !defined(VUINT8x64_CMPGT_DEFINED) && defined(VUINT8x32_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(u, 8, 64, 32)
# define VUINT8x64_CMPGT_DEFINED
#endif

#if !defined(VUINT8x64_CMPLE_DEFINED) && defined(VUINT8x32_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(u, 8, 64, 32)
# define VUINT8x64_CMPLE_DEFINED
#endif

#if !defined(VUINT8x64_CMPGE_DEFINED) && defined(VUINT8x32_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(u, 8, 64, 32)
# define VUINT8x64_CMPGE_DEFINED
#endif

#if !defined(VUINT8x64_MIN_DEFINED) && defined(VUINT8x32_MIN_DEFINED)
VEC_DOUBLE_MIN(u, 8, 64, 32)
# define VUINT8x64_MIN_DEFINED
#endif

#if !defined(VUINT8x64_MAX_DEFINED) && defined(VUINT8x32_MAX_DEFINED)
VEC_DOUBLE_MAX(u, 8, 64, 32)
# define VUINT8x64_MAX_DEFINED
#endif

#if !defined(VUINT8x64_RSHIFT_DEFINED) && defined(VUINT8x32_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(u, 8, 64, 32)
# define VUINT8x64_RSHIFT_DEFINED
#endif

#if !defined(VUINT8x64_LRSHIFT_DEFINED) && defined(VUINT8x32_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(u, 8, 64, 32)
# define VUINT8x64_LRSHIFT_DEFINED
#endif

#if !defined(VUINT8x64_LSHIFT_DEFINED) && defined(VUINT8x32_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(u, 8, 64, 32)
# define VUINT8x64_LSHIFT_DEFINED
#endif



/* vuint16x4 */

#if !defined(VINT16x4_SPLAT_DEFINED) && defined(VINT16x2_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(/* nothing */, 16, 4, 2)
# define VINT16x4_SPLAT_DEFINED
#endif

#if !defined(VINT16x4_LOAD_ALIGNED_DEFINED) && defined(VINT16x2_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(/* nothing */, 16, 4, 2)
# define VINT16x4_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VINT16x4_LOAD_DEFINED) && defined(VINT16x2_LOAD_DEFINED)
VEC_DOUBLE_LOAD(/* nothing */, 16, 4, 2)
# define VINT16x4_LOAD_DEFINED
#endif

#if !defined(VINT16x4_STORE_ALIGNED_DEFINED) && defined(VINT16x2_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(/* nothing */, 16, 4, 2)
# define VINT16x4_STORE_ALIGNED_DEFINED
#endif

#if !defined(VINT16x4_STORE_DEFINED) && defined(VINT16x2_STORE_DEFINED)
VEC_DOUBLE_STORE(/* nothing */, 16, 4, 2)
# define VINT16x4_STORE_DEFINED
#endif

#if !defined(VINT16x4_ADD_DEFINED) && defined(VINT16x2_ADD_DEFINED)
VEC_DOUBLE_ADD(/* nothing */, 16, 4, 2)
# define VINT16x4_ADD_DEFINED
#endif

#if !defined(VINT16x4_SUB_DEFINED) && defined(VINT16x2_SUB_DEFINED)
VEC_DOUBLE_SUB(/* nothing */, 16, 4, 2)
# define VINT16x4_SUB_DEFINED
#endif

#if !defined(VINT16x4_MUL_DEFINED) && defined(VINT16x2_MUL_DEFINED)
VEC_DOUBLE_MUL(/* nothing */, 16, 4, 2)
# define VINT16x4_MUL_DEFINED
#endif

#if !defined(VINT16x4_DIV_DEFINED) && defined(VINT16x2_DIV_DEFINED)
VEC_DOUBLE_DIV(/* nothing */, 16, 4, 2)
# define VINT16x4_DIV_DEFINED
#endif

#if !defined(VINT16x4_MOD_DEFINED) && defined(VINT16x2_MOD_DEFINED)
VEC_DOUBLE_MOD(/* nothing */, 16, 4, 2)
# define VINT16x4_MOD_DEFINED
#endif

#if !defined(VINT16x4_AVG_DEFINED) && defined(VINT16x2_AVG_DEFINED)
VEC_DOUBLE_AVG(/* nothing */, 16, 4, 2)
# define VINT16x4_AVG_DEFINED
#endif

#if !defined(VINT16x4_AND_DEFINED) && defined(VINT16x2_AND_DEFINED)
VEC_DOUBLE_AND(/* nothing */, 16, 4, 2)
# define VINT16x4_AND_DEFINED
#endif

#if !defined(VINT16x4_OR_DEFINED) && defined(VINT16x2_OR_DEFINED)
VEC_DOUBLE_OR(/* nothing */, 16, 4, 2)
# define VINT16x4_OR_DEFINED
#endif

#if !defined(VINT16x4_XOR_DEFINED) && defined(VINT16x2_XOR_DEFINED)
VEC_DOUBLE_XOR(/* nothing */, 16, 4, 2)
# define VINT16x4_XOR_DEFINED
#endif

#if !defined(VINT16x4_NOT_DEFINED) && defined(VINT16x2_NOT_DEFINED)
VEC_DOUBLE_NOT(/* nothing */, 16, 4, 2)
# define VINT16x4_NOT_DEFINED
#endif

#if !defined(VINT16x4_CMPLT_DEFINED) && defined(VINT16x2_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(/* nothing */, 16, 4, 2)
# define VINT16x4_CMPLT_DEFINED
#endif

#if !defined(VINT16x4_CMPEQ_DEFINED) && defined(VINT16x2_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(/* nothing */, 16, 4, 2)
# define VINT16x4_CMPEQ_DEFINED
#endif

#if !defined(VINT16x4_CMPGT_DEFINED) && defined(VINT16x2_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(/* nothing */, 16, 4, 2)
# define VINT16x4_CMPGT_DEFINED
#endif

#if !defined(VINT16x4_CMPLE_DEFINED) && defined(VINT16x2_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(/* nothing */, 16, 4, 2)
# define VINT16x4_CMPLE_DEFINED
#endif

#if !defined(VINT16x4_CMPGE_DEFINED) && defined(VINT16x2_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(/* nothing */, 16, 4, 2)
# define VINT16x4_CMPGE_DEFINED
#endif

#if !defined(VINT16x4_MIN_DEFINED) && defined(VINT16x2_MIN_DEFINED)
VEC_DOUBLE_MIN(/* nothing */, 16, 4, 2)
# define VINT16x4_MIN_DEFINED
#endif

#if !defined(VINT16x4_MAX_DEFINED) && defined(VINT16x2_MAX_DEFINED)
VEC_DOUBLE_MAX(/* nothing */, 16, 4, 2)
# define VINT16x4_MAX_DEFINED
#endif

#if !defined(VINT16x4_RSHIFT_DEFINED) && defined(VINT16x2_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(/* nothing */, 16, 4, 2)
# define VINT16x4_RSHIFT_DEFINED
#endif

#if !defined(VINT16x4_LRSHIFT_DEFINED) && defined(VINT16x2_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(/* nothing */, 16, 4, 2)
# define VINT16x4_LRSHIFT_DEFINED
#endif

#if !defined(VINT16x4_LSHIFT_DEFINED) && defined(VINT16x2_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(/* nothing */, 16, 4, 2)
# define VINT16x4_LSHIFT_DEFINED
#endif



/* vint16x4 */

#if !defined(VUINT16x4_SPLAT_DEFINED) && defined(VUINT16x2_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(u, 16, 4, 2)
# define VUINT16x4_SPLAT_DEFINED
#endif

#if !defined(VUINT16x4_LOAD_ALIGNED_DEFINED) && defined(VUINT16x2_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(u, 16, 4, 2)
# define VUINT16x4_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VUINT16x4_LOAD_DEFINED) && defined(VUINT16x2_LOAD_DEFINED)
VEC_DOUBLE_LOAD(u, 16, 4, 2)
# define VUINT16x4_LOAD_DEFINED
#endif

#if !defined(VUINT16x4_STORE_ALIGNED_DEFINED) && defined(VUINT16x2_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(u, 16, 4, 2)
# define VUINT16x4_STORE_ALIGNED_DEFINED
#endif

#if !defined(VUINT16x4_STORE_DEFINED) && defined(VUINT16x2_STORE_DEFINED)
VEC_DOUBLE_STORE(u, 16, 4, 2)
# define VUINT16x4_STORE_DEFINED
#endif

#if !defined(VUINT16x4_ADD_DEFINED) && defined(VUINT16x2_ADD_DEFINED)
VEC_DOUBLE_ADD(u, 16, 4, 2)
# define VUINT16x4_ADD_DEFINED
#endif

#if !defined(VUINT16x4_SUB_DEFINED) && defined(VUINT16x2_SUB_DEFINED)
VEC_DOUBLE_SUB(u, 16, 4, 2)
# define VUINT16x4_SUB_DEFINED
#endif

#if !defined(VUINT16x4_MUL_DEFINED) && defined(VUINT16x2_MUL_DEFINED)
VEC_DOUBLE_MUL(u, 16, 4, 2)
# define VUINT16x4_MUL_DEFINED
#endif

#if !defined(VUINT16x4_DIV_DEFINED) && defined(VUINT16x2_DIV_DEFINED)
VEC_DOUBLE_DIV(u, 16, 4, 2)
# define VUINT16x4_DIV_DEFINED
#endif

#if !defined(VUINT16x4_MOD_DEFINED) && defined(VUINT16x2_MOD_DEFINED)
VEC_DOUBLE_MOD(u, 16, 4, 2)
# define VUINT16x4_MOD_DEFINED
#endif

#if !defined(VUINT16x4_AVG_DEFINED) && defined(VUINT16x2_AVG_DEFINED)
VEC_DOUBLE_AVG(u, 16, 4, 2)
# define VUINT16x4_AVG_DEFINED
#endif

#if !defined(VUINT16x4_AND_DEFINED) && defined(VUINT16x2_AND_DEFINED)
VEC_DOUBLE_AND(u, 16, 4, 2)
# define VUINT16x4_AND_DEFINED
#endif

#if !defined(VUINT16x4_OR_DEFINED) && defined(VUINT16x2_OR_DEFINED)
VEC_DOUBLE_OR(u, 16, 4, 2)
# define VUINT16x4_OR_DEFINED
#endif

#if !defined(VUINT16x4_XOR_DEFINED) && defined(VUINT16x2_XOR_DEFINED)
VEC_DOUBLE_XOR(u, 16, 4, 2)
# define VUINT16x4_XOR_DEFINED
#endif

#if !defined(VUINT16x4_NOT_DEFINED) && defined(VUINT16x2_NOT_DEFINED)
VEC_DOUBLE_NOT(u, 16, 4, 2)
# define VUINT16x4_NOT_DEFINED
#endif

#if !defined(VUINT16x4_CMPLT_DEFINED) && defined(VUINT16x2_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(u, 16, 4, 2)
# define VUINT16x4_CMPLT_DEFINED
#endif

#if !defined(VUINT16x4_CMPEQ_DEFINED) && defined(VUINT16x2_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(u, 16, 4, 2)
# define VUINT16x4_CMPEQ_DEFINED
#endif

#if !defined(VUINT16x4_CMPGT_DEFINED) && defined(VUINT16x2_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(u, 16, 4, 2)
# define VUINT16x4_CMPGT_DEFINED
#endif

#if !defined(VUINT16x4_CMPLE_DEFINED) && defined(VUINT16x2_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(u, 16, 4, 2)
# define VUINT16x4_CMPLE_DEFINED
#endif

#if !defined(VUINT16x4_CMPGE_DEFINED) && defined(VUINT16x2_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(u, 16, 4, 2)
# define VUINT16x4_CMPGE_DEFINED
#endif

#if !defined(VUINT16x4_MIN_DEFINED) && defined(VUINT16x2_MIN_DEFINED)
VEC_DOUBLE_MIN(u, 16, 4, 2)
# define VUINT16x4_MIN_DEFINED
#endif

#if !defined(VUINT16x4_MAX_DEFINED) && defined(VUINT16x2_MAX_DEFINED)
VEC_DOUBLE_MAX(u, 16, 4, 2)
# define VUINT16x4_MAX_DEFINED
#endif

#if !defined(VUINT16x4_RSHIFT_DEFINED) && defined(VUINT16x2_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(u, 16, 4, 2)
# define VUINT16x4_RSHIFT_DEFINED
#endif

#if !defined(VUINT16x4_LRSHIFT_DEFINED) && defined(VUINT16x2_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(u, 16, 4, 2)
# define VUINT16x4_LRSHIFT_DEFINED
#endif

#if !defined(VUINT16x4_LSHIFT_DEFINED) && defined(VUINT16x2_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(u, 16, 4, 2)
# define VUINT16x4_LSHIFT_DEFINED
#endif



/* vuint16x8 */

#if !defined(VINT16x8_SPLAT_DEFINED) && defined(VINT16x4_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(/* nothing */, 16, 8, 4)
# define VINT16x8_SPLAT_DEFINED
#endif

#if !defined(VINT16x8_LOAD_ALIGNED_DEFINED) && defined(VINT16x4_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(/* nothing */, 16, 8, 4)
# define VINT16x8_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VINT16x8_LOAD_DEFINED) && defined(VINT16x4_LOAD_DEFINED)
VEC_DOUBLE_LOAD(/* nothing */, 16, 8, 4)
# define VINT16x8_LOAD_DEFINED
#endif

#if !defined(VINT16x8_STORE_ALIGNED_DEFINED) && defined(VINT16x4_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(/* nothing */, 16, 8, 4)
# define VINT16x8_STORE_ALIGNED_DEFINED
#endif

#if !defined(VINT16x8_STORE_DEFINED) && defined(VINT16x4_STORE_DEFINED)
VEC_DOUBLE_STORE(/* nothing */, 16, 8, 4)
# define VINT16x8_STORE_DEFINED
#endif

#if !defined(VINT16x8_ADD_DEFINED) && defined(VINT16x4_ADD_DEFINED)
VEC_DOUBLE_ADD(/* nothing */, 16, 8, 4)
# define VINT16x8_ADD_DEFINED
#endif

#if !defined(VINT16x8_SUB_DEFINED) && defined(VINT16x4_SUB_DEFINED)
VEC_DOUBLE_SUB(/* nothing */, 16, 8, 4)
# define VINT16x8_SUB_DEFINED
#endif

#if !defined(VINT16x8_MUL_DEFINED) && defined(VINT16x4_MUL_DEFINED)
VEC_DOUBLE_MUL(/* nothing */, 16, 8, 4)
# define VINT16x8_MUL_DEFINED
#endif

#if !defined(VINT16x8_DIV_DEFINED) && defined(VINT16x4_DIV_DEFINED)
VEC_DOUBLE_DIV(/* nothing */, 16, 8, 4)
# define VINT16x8_DIV_DEFINED
#endif

#if !defined(VINT16x8_MOD_DEFINED) && defined(VINT16x4_MOD_DEFINED)
VEC_DOUBLE_MOD(/* nothing */, 16, 8, 4)
# define VINT16x8_MOD_DEFINED
#endif

#if !defined(VINT16x8_AVG_DEFINED) && defined(VINT16x4_AVG_DEFINED)
VEC_DOUBLE_AVG(/* nothing */, 16, 8, 4)
# define VINT16x8_AVG_DEFINED
#endif

#if !defined(VINT16x8_AND_DEFINED) && defined(VINT16x4_AND_DEFINED)
VEC_DOUBLE_AND(/* nothing */, 16, 8, 4)
# define VINT16x8_AND_DEFINED
#endif

#if !defined(VINT16x8_OR_DEFINED) && defined(VINT16x4_OR_DEFINED)
VEC_DOUBLE_OR(/* nothing */, 16, 8, 4)
# define VINT16x8_OR_DEFINED
#endif

#if !defined(VINT16x8_XOR_DEFINED) && defined(VINT16x4_XOR_DEFINED)
VEC_DOUBLE_XOR(/* nothing */, 16, 8, 4)
# define VINT16x8_XOR_DEFINED
#endif

#if !defined(VINT16x8_NOT_DEFINED) && defined(VINT16x4_NOT_DEFINED)
VEC_DOUBLE_NOT(/* nothing */, 16, 8, 4)
# define VINT16x8_NOT_DEFINED
#endif

#if !defined(VINT16x8_CMPLT_DEFINED) && defined(VINT16x4_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(/* nothing */, 16, 8, 4)
# define VINT16x8_CMPLT_DEFINED
#endif

#if !defined(VINT16x8_CMPEQ_DEFINED) && defined(VINT16x4_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(/* nothing */, 16, 8, 4)
# define VINT16x8_CMPEQ_DEFINED
#endif

#if !defined(VINT16x8_CMPGT_DEFINED) && defined(VINT16x4_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(/* nothing */, 16, 8, 4)
# define VINT16x8_CMPGT_DEFINED
#endif

#if !defined(VINT16x8_CMPLE_DEFINED) && defined(VINT16x4_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(/* nothing */, 16, 8, 4)
# define VINT16x8_CMPLE_DEFINED
#endif

#if !defined(VINT16x8_CMPGE_DEFINED) && defined(VINT16x4_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(/* nothing */, 16, 8, 4)
# define VINT16x8_CMPGE_DEFINED
#endif

#if !defined(VINT16x8_MIN_DEFINED) && defined(VINT16x4_MIN_DEFINED)
VEC_DOUBLE_MIN(/* nothing */, 16, 8, 4)
# define VINT16x8_MIN_DEFINED
#endif

#if !defined(VINT16x8_MAX_DEFINED) && defined(VINT16x4_MAX_DEFINED)
VEC_DOUBLE_MAX(/* nothing */, 16, 8, 4)
# define VINT16x8_MAX_DEFINED
#endif

#if !defined(VINT16x8_RSHIFT_DEFINED) && defined(VINT16x4_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(/* nothing */, 16, 8, 4)
# define VINT16x8_RSHIFT_DEFINED
#endif

#if !defined(VINT16x8_LRSHIFT_DEFINED) && defined(VINT16x4_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(/* nothing */, 16, 8, 4)
# define VINT16x8_LRSHIFT_DEFINED
#endif

#if !defined(VINT16x8_LSHIFT_DEFINED) && defined(VINT16x4_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(/* nothing */, 16, 8, 4)
# define VINT16x8_LSHIFT_DEFINED
#endif



/* vint16x8 */

#if !defined(VUINT16x8_SPLAT_DEFINED) && defined(VUINT16x4_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(u, 16, 8, 4)
# define VUINT16x8_SPLAT_DEFINED
#endif

#if !defined(VUINT16x8_LOAD_ALIGNED_DEFINED) && defined(VUINT16x4_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(u, 16, 8, 4)
# define VUINT16x8_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VUINT16x8_LOAD_DEFINED) && defined(VUINT16x4_LOAD_DEFINED)
VEC_DOUBLE_LOAD(u, 16, 8, 4)
# define VUINT16x8_LOAD_DEFINED
#endif

#if !defined(VUINT16x8_STORE_ALIGNED_DEFINED) && defined(VUINT16x4_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(u, 16, 8, 4)
# define VUINT16x8_STORE_ALIGNED_DEFINED
#endif

#if !defined(VUINT16x8_STORE_DEFINED) && defined(VUINT16x4_STORE_DEFINED)
VEC_DOUBLE_STORE(u, 16, 8, 4)
# define VUINT16x8_STORE_DEFINED
#endif

#if !defined(VUINT16x8_ADD_DEFINED) && defined(VUINT16x4_ADD_DEFINED)
VEC_DOUBLE_ADD(u, 16, 8, 4)
# define VUINT16x8_ADD_DEFINED
#endif

#if !defined(VUINT16x8_SUB_DEFINED) && defined(VUINT16x4_SUB_DEFINED)
VEC_DOUBLE_SUB(u, 16, 8, 4)
# define VUINT16x8_SUB_DEFINED
#endif

#if !defined(VUINT16x8_MUL_DEFINED) && defined(VUINT16x4_MUL_DEFINED)
VEC_DOUBLE_MUL(u, 16, 8, 4)
# define VUINT16x8_MUL_DEFINED
#endif

#if !defined(VUINT16x8_DIV_DEFINED) && defined(VUINT16x4_DIV_DEFINED)
VEC_DOUBLE_DIV(u, 16, 8, 4)
# define VUINT16x8_DIV_DEFINED
#endif

#if !defined(VUINT16x8_MOD_DEFINED) && defined(VUINT16x4_MOD_DEFINED)
VEC_DOUBLE_MOD(u, 16, 8, 4)
# define VUINT16x8_MOD_DEFINED
#endif

#if !defined(VUINT16x8_AVG_DEFINED) && defined(VUINT16x4_AVG_DEFINED)
VEC_DOUBLE_AVG(u, 16, 8, 4)
# define VUINT16x8_AVG_DEFINED
#endif

#if !defined(VUINT16x8_AND_DEFINED) && defined(VUINT16x4_AND_DEFINED)
VEC_DOUBLE_AND(u, 16, 8, 4)
# define VUINT16x8_AND_DEFINED
#endif

#if !defined(VUINT16x8_OR_DEFINED) && defined(VUINT16x4_OR_DEFINED)
VEC_DOUBLE_OR(u, 16, 8, 4)
# define VUINT16x8_OR_DEFINED
#endif

#if !defined(VUINT16x8_XOR_DEFINED) && defined(VUINT16x4_XOR_DEFINED)
VEC_DOUBLE_XOR(u, 16, 8, 4)
# define VUINT16x8_XOR_DEFINED
#endif

#if !defined(VUINT16x8_NOT_DEFINED) && defined(VUINT16x4_NOT_DEFINED)
VEC_DOUBLE_NOT(u, 16, 8, 4)
# define VUINT16x8_NOT_DEFINED
#endif

#if !defined(VUINT16x8_CMPLT_DEFINED) && defined(VUINT16x4_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(u, 16, 8, 4)
# define VUINT16x8_CMPLT_DEFINED
#endif

#if !defined(VUINT16x8_CMPEQ_DEFINED) && defined(VUINT16x4_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(u, 16, 8, 4)
# define VUINT16x8_CMPEQ_DEFINED
#endif

#if !defined(VUINT16x8_CMPGT_DEFINED) && defined(VUINT16x4_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(u, 16, 8, 4)
# define VUINT16x8_CMPGT_DEFINED
#endif

#if !defined(VUINT16x8_CMPLE_DEFINED) && defined(VUINT16x4_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(u, 16, 8, 4)
# define VUINT16x8_CMPLE_DEFINED
#endif

#if !defined(VUINT16x8_CMPGE_DEFINED) && defined(VUINT16x4_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(u, 16, 8, 4)
# define VUINT16x8_CMPGE_DEFINED
#endif

#if !defined(VUINT16x8_MIN_DEFINED) && defined(VUINT16x4_MIN_DEFINED)
VEC_DOUBLE_MIN(u, 16, 8, 4)
# define VUINT16x8_MIN_DEFINED
#endif

#if !defined(VUINT16x8_MAX_DEFINED) && defined(VUINT16x4_MAX_DEFINED)
VEC_DOUBLE_MAX(u, 16, 8, 4)
# define VUINT16x8_MAX_DEFINED
#endif

#if !defined(VUINT16x8_RSHIFT_DEFINED) && defined(VUINT16x4_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(u, 16, 8, 4)
# define VUINT16x8_RSHIFT_DEFINED
#endif

#if !defined(VUINT16x8_LRSHIFT_DEFINED) && defined(VUINT16x4_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(u, 16, 8, 4)
# define VUINT16x8_LRSHIFT_DEFINED
#endif

#if !defined(VUINT16x8_LSHIFT_DEFINED) && defined(VUINT16x4_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(u, 16, 8, 4)
# define VUINT16x8_LSHIFT_DEFINED
#endif



/* vuint16x16 */

#if !defined(VINT16x16_SPLAT_DEFINED) && defined(VINT16x8_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(/* nothing */, 16, 16, 8)
# define VINT16x16_SPLAT_DEFINED
#endif

#if !defined(VINT16x16_LOAD_ALIGNED_DEFINED) && defined(VINT16x8_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(/* nothing */, 16, 16, 8)
# define VINT16x16_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VINT16x16_LOAD_DEFINED) && defined(VINT16x8_LOAD_DEFINED)
VEC_DOUBLE_LOAD(/* nothing */, 16, 16, 8)
# define VINT16x16_LOAD_DEFINED
#endif

#if !defined(VINT16x16_STORE_ALIGNED_DEFINED) && defined(VINT16x8_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(/* nothing */, 16, 16, 8)
# define VINT16x16_STORE_ALIGNED_DEFINED
#endif

#if !defined(VINT16x16_STORE_DEFINED) && defined(VINT16x8_STORE_DEFINED)
VEC_DOUBLE_STORE(/* nothing */, 16, 16, 8)
# define VINT16x16_STORE_DEFINED
#endif

#if !defined(VINT16x16_ADD_DEFINED) && defined(VINT16x8_ADD_DEFINED)
VEC_DOUBLE_ADD(/* nothing */, 16, 16, 8)
# define VINT16x16_ADD_DEFINED
#endif

#if !defined(VINT16x16_SUB_DEFINED) && defined(VINT16x8_SUB_DEFINED)
VEC_DOUBLE_SUB(/* nothing */, 16, 16, 8)
# define VINT16x16_SUB_DEFINED
#endif

#if !defined(VINT16x16_MUL_DEFINED) && defined(VINT16x8_MUL_DEFINED)
VEC_DOUBLE_MUL(/* nothing */, 16, 16, 8)
# define VINT16x16_MUL_DEFINED
#endif

#if !defined(VINT16x16_DIV_DEFINED) && defined(VINT16x8_DIV_DEFINED)
VEC_DOUBLE_DIV(/* nothing */, 16, 16, 8)
# define VINT16x16_DIV_DEFINED
#endif

#if !defined(VINT16x16_MOD_DEFINED) && defined(VINT16x8_MOD_DEFINED)
VEC_DOUBLE_MOD(/* nothing */, 16, 16, 8)
# define VINT16x16_MOD_DEFINED
#endif

#if !defined(VINT16x16_AVG_DEFINED) && defined(VINT16x8_AVG_DEFINED)
VEC_DOUBLE_AVG(/* nothing */, 16, 16, 8)
# define VINT16x16_AVG_DEFINED
#endif

#if !defined(VINT16x16_AND_DEFINED) && defined(VINT16x8_AND_DEFINED)
VEC_DOUBLE_AND(/* nothing */, 16, 16, 8)
# define VINT16x16_AND_DEFINED
#endif

#if !defined(VINT16x16_OR_DEFINED) && defined(VINT16x8_OR_DEFINED)
VEC_DOUBLE_OR(/* nothing */, 16, 16, 8)
# define VINT16x16_OR_DEFINED
#endif

#if !defined(VINT16x16_XOR_DEFINED) && defined(VINT16x8_XOR_DEFINED)
VEC_DOUBLE_XOR(/* nothing */, 16, 16, 8)
# define VINT16x16_XOR_DEFINED
#endif

#if !defined(VINT16x16_NOT_DEFINED) && defined(VINT16x8_NOT_DEFINED)
VEC_DOUBLE_NOT(/* nothing */, 16, 16, 8)
# define VINT16x16_NOT_DEFINED
#endif

#if !defined(VINT16x16_CMPLT_DEFINED) && defined(VINT16x8_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(/* nothing */, 16, 16, 8)
# define VINT16x16_CMPLT_DEFINED
#endif

#if !defined(VINT16x16_CMPEQ_DEFINED) && defined(VINT16x8_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(/* nothing */, 16, 16, 8)
# define VINT16x16_CMPEQ_DEFINED
#endif

#if !defined(VINT16x16_CMPGT_DEFINED) && defined(VINT16x8_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(/* nothing */, 16, 16, 8)
# define VINT16x16_CMPGT_DEFINED
#endif

#if !defined(VINT16x16_CMPLE_DEFINED) && defined(VINT16x8_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(/* nothing */, 16, 16, 8)
# define VINT16x16_CMPLE_DEFINED
#endif

#if !defined(VINT16x16_CMPGE_DEFINED) && defined(VINT16x8_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(/* nothing */, 16, 16, 8)
# define VINT16x16_CMPGE_DEFINED
#endif

#if !defined(VINT16x16_MIN_DEFINED) && defined(VINT16x8_MIN_DEFINED)
VEC_DOUBLE_MIN(/* nothing */, 16, 16, 8)
# define VINT16x16_MIN_DEFINED
#endif

#if !defined(VINT16x16_MAX_DEFINED) && defined(VINT16x8_MAX_DEFINED)
VEC_DOUBLE_MAX(/* nothing */, 16, 16, 8)
# define VINT16x16_MAX_DEFINED
#endif

#if !defined(VINT16x16_RSHIFT_DEFINED) && defined(VINT16x8_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(/* nothing */, 16, 16, 8)
# define VINT16x16_RSHIFT_DEFINED
#endif

#if !defined(VINT16x16_LRSHIFT_DEFINED) && defined(VINT16x8_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(/* nothing */, 16, 16, 8)
# define VINT16x16_LRSHIFT_DEFINED
#endif

#if !defined(VINT16x16_LSHIFT_DEFINED) && defined(VINT16x8_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(/* nothing */, 16, 16, 8)
# define VINT16x16_LSHIFT_DEFINED
#endif



/* vint16x16 */

#if !defined(VUINT16x16_SPLAT_DEFINED) && defined(VUINT16x8_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(u, 16, 16, 8)
# define VUINT16x16_SPLAT_DEFINED
#endif

#if !defined(VUINT16x16_LOAD_ALIGNED_DEFINED) && defined(VUINT16x8_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(u, 16, 16, 8)
# define VUINT16x16_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VUINT16x16_LOAD_DEFINED) && defined(VUINT16x8_LOAD_DEFINED)
VEC_DOUBLE_LOAD(u, 16, 16, 8)
# define VUINT16x16_LOAD_DEFINED
#endif

#if !defined(VUINT16x16_STORE_ALIGNED_DEFINED) && defined(VUINT16x8_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(u, 16, 16, 8)
# define VUINT16x16_STORE_ALIGNED_DEFINED
#endif

#if !defined(VUINT16x16_STORE_DEFINED) && defined(VUINT16x8_STORE_DEFINED)
VEC_DOUBLE_STORE(u, 16, 16, 8)
# define VUINT16x16_STORE_DEFINED
#endif

#if !defined(VUINT16x16_ADD_DEFINED) && defined(VUINT16x8_ADD_DEFINED)
VEC_DOUBLE_ADD(u, 16, 16, 8)
# define VUINT16x16_ADD_DEFINED
#endif

#if !defined(VUINT16x16_SUB_DEFINED) && defined(VUINT16x8_SUB_DEFINED)
VEC_DOUBLE_SUB(u, 16, 16, 8)
# define VUINT16x16_SUB_DEFINED
#endif

#if !defined(VUINT16x16_MUL_DEFINED) && defined(VUINT16x8_MUL_DEFINED)
VEC_DOUBLE_MUL(u, 16, 16, 8)
# define VUINT16x16_MUL_DEFINED
#endif

#if !defined(VUINT16x16_DIV_DEFINED) && defined(VUINT16x8_DIV_DEFINED)
VEC_DOUBLE_DIV(u, 16, 16, 8)
# define VUINT16x16_DIV_DEFINED
#endif

#if !defined(VUINT16x16_MOD_DEFINED) && defined(VUINT16x8_MOD_DEFINED)
VEC_DOUBLE_MOD(u, 16, 16, 8)
# define VUINT16x16_MOD_DEFINED
#endif

#if !defined(VUINT16x16_AVG_DEFINED) && defined(VUINT16x8_AVG_DEFINED)
VEC_DOUBLE_AVG(u, 16, 16, 8)
# define VUINT16x16_AVG_DEFINED
#endif

#if !defined(VUINT16x16_AND_DEFINED) && defined(VUINT16x8_AND_DEFINED)
VEC_DOUBLE_AND(u, 16, 16, 8)
# define VUINT16x16_AND_DEFINED
#endif

#if !defined(VUINT16x16_OR_DEFINED) && defined(VUINT16x8_OR_DEFINED)
VEC_DOUBLE_OR(u, 16, 16, 8)
# define VUINT16x16_OR_DEFINED
#endif

#if !defined(VUINT16x16_XOR_DEFINED) && defined(VUINT16x8_XOR_DEFINED)
VEC_DOUBLE_XOR(u, 16, 16, 8)
# define VUINT16x16_XOR_DEFINED
#endif

#if !defined(VUINT16x16_NOT_DEFINED) && defined(VUINT16x8_NOT_DEFINED)
VEC_DOUBLE_NOT(u, 16, 16, 8)
# define VUINT16x16_NOT_DEFINED
#endif

#if !defined(VUINT16x16_CMPLT_DEFINED) && defined(VUINT16x8_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(u, 16, 16, 8)
# define VUINT16x16_CMPLT_DEFINED
#endif

#if !defined(VUINT16x16_CMPEQ_DEFINED) && defined(VUINT16x8_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(u, 16, 16, 8)
# define VUINT16x16_CMPEQ_DEFINED
#endif

#if !defined(VUINT16x16_CMPGT_DEFINED) && defined(VUINT16x8_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(u, 16, 16, 8)
# define VUINT16x16_CMPGT_DEFINED
#endif

#if !defined(VUINT16x16_CMPLE_DEFINED) && defined(VUINT16x8_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(u, 16, 16, 8)
# define VUINT16x16_CMPLE_DEFINED
#endif

#if !defined(VUINT16x16_CMPGE_DEFINED) && defined(VUINT16x8_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(u, 16, 16, 8)
# define VUINT16x16_CMPGE_DEFINED
#endif

#if !defined(VUINT16x16_MIN_DEFINED) && defined(VUINT16x8_MIN_DEFINED)
VEC_DOUBLE_MIN(u, 16, 16, 8)
# define VUINT16x16_MIN_DEFINED
#endif

#if !defined(VUINT16x16_MAX_DEFINED) && defined(VUINT16x8_MAX_DEFINED)
VEC_DOUBLE_MAX(u, 16, 16, 8)
# define VUINT16x16_MAX_DEFINED
#endif

#if !defined(VUINT16x16_RSHIFT_DEFINED) && defined(VUINT16x8_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(u, 16, 16, 8)
# define VUINT16x16_RSHIFT_DEFINED
#endif

#if !defined(VUINT16x16_LRSHIFT_DEFINED) && defined(VUINT16x8_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(u, 16, 16, 8)
# define VUINT16x16_LRSHIFT_DEFINED
#endif

#if !defined(VUINT16x16_LSHIFT_DEFINED) && defined(VUINT16x8_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(u, 16, 16, 8)
# define VUINT16x16_LSHIFT_DEFINED
#endif



/* vuint16x32 */

#if !defined(VINT16x32_SPLAT_DEFINED) && defined(VINT16x16_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(/* nothing */, 16, 32, 16)
# define VINT16x32_SPLAT_DEFINED
#endif

#if !defined(VINT16x32_LOAD_ALIGNED_DEFINED) && defined(VINT16x16_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(/* nothing */, 16, 32, 16)
# define VINT16x32_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VINT16x32_LOAD_DEFINED) && defined(VINT16x16_LOAD_DEFINED)
VEC_DOUBLE_LOAD(/* nothing */, 16, 32, 16)
# define VINT16x32_LOAD_DEFINED
#endif

#if !defined(VINT16x32_STORE_ALIGNED_DEFINED) && defined(VINT16x16_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(/* nothing */, 16, 32, 16)
# define VINT16x32_STORE_ALIGNED_DEFINED
#endif

#if !defined(VINT16x32_STORE_DEFINED) && defined(VINT16x16_STORE_DEFINED)
VEC_DOUBLE_STORE(/* nothing */, 16, 32, 16)
# define VINT16x32_STORE_DEFINED
#endif

#if !defined(VINT16x32_ADD_DEFINED) && defined(VINT16x16_ADD_DEFINED)
VEC_DOUBLE_ADD(/* nothing */, 16, 32, 16)
# define VINT16x32_ADD_DEFINED
#endif

#if !defined(VINT16x32_SUB_DEFINED) && defined(VINT16x16_SUB_DEFINED)
VEC_DOUBLE_SUB(/* nothing */, 16, 32, 16)
# define VINT16x32_SUB_DEFINED
#endif

#if !defined(VINT16x32_MUL_DEFINED) && defined(VINT16x16_MUL_DEFINED)
VEC_DOUBLE_MUL(/* nothing */, 16, 32, 16)
# define VINT16x32_MUL_DEFINED
#endif

#if !defined(VINT16x32_DIV_DEFINED) && defined(VINT16x16_DIV_DEFINED)
VEC_DOUBLE_DIV(/* nothing */, 16, 32, 16)
# define VINT16x32_DIV_DEFINED
#endif

#if !defined(VINT16x32_MOD_DEFINED) && defined(VINT16x16_MOD_DEFINED)
VEC_DOUBLE_MOD(/* nothing */, 16, 32, 16)
# define VINT16x32_MOD_DEFINED
#endif

#if !defined(VINT16x32_AVG_DEFINED) && defined(VINT16x16_AVG_DEFINED)
VEC_DOUBLE_AVG(/* nothing */, 16, 32, 16)
# define VINT16x32_AVG_DEFINED
#endif

#if !defined(VINT16x32_AND_DEFINED) && defined(VINT16x16_AND_DEFINED)
VEC_DOUBLE_AND(/* nothing */, 16, 32, 16)
# define VINT16x32_AND_DEFINED
#endif

#if !defined(VINT16x32_OR_DEFINED) && defined(VINT16x16_OR_DEFINED)
VEC_DOUBLE_OR(/* nothing */, 16, 32, 16)
# define VINT16x32_OR_DEFINED
#endif

#if !defined(VINT16x32_XOR_DEFINED) && defined(VINT16x16_XOR_DEFINED)
VEC_DOUBLE_XOR(/* nothing */, 16, 32, 16)
# define VINT16x32_XOR_DEFINED
#endif

#if !defined(VINT16x32_NOT_DEFINED) && defined(VINT16x16_NOT_DEFINED)
VEC_DOUBLE_NOT(/* nothing */, 16, 32, 16)
# define VINT16x32_NOT_DEFINED
#endif

#if !defined(VINT16x32_CMPLT_DEFINED) && defined(VINT16x16_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(/* nothing */, 16, 32, 16)
# define VINT16x32_CMPLT_DEFINED
#endif

#if !defined(VINT16x32_CMPEQ_DEFINED) && defined(VINT16x16_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(/* nothing */, 16, 32, 16)
# define VINT16x32_CMPEQ_DEFINED
#endif

#if !defined(VINT16x32_CMPGT_DEFINED) && defined(VINT16x16_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(/* nothing */, 16, 32, 16)
# define VINT16x32_CMPGT_DEFINED
#endif

#if !defined(VINT16x32_CMPLE_DEFINED) && defined(VINT16x16_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(/* nothing */, 16, 32, 16)
# define VINT16x32_CMPLE_DEFINED
#endif

#if !defined(VINT16x32_CMPGE_DEFINED) && defined(VINT16x16_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(/* nothing */, 16, 32, 16)
# define VINT16x32_CMPGE_DEFINED
#endif

#if !defined(VINT16x32_MIN_DEFINED) && defined(VINT16x16_MIN_DEFINED)
VEC_DOUBLE_MIN(/* nothing */, 16, 32, 16)
# define VINT16x32_MIN_DEFINED
#endif

#if !defined(VINT16x32_MAX_DEFINED) && defined(VINT16x16_MAX_DEFINED)
VEC_DOUBLE_MAX(/* nothing */, 16, 32, 16)
# define VINT16x32_MAX_DEFINED
#endif

#if !defined(VINT16x32_RSHIFT_DEFINED) && defined(VINT16x16_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(/* nothing */, 16, 32, 16)
# define VINT16x32_RSHIFT_DEFINED
#endif

#if !defined(VINT16x32_LRSHIFT_DEFINED) && defined(VINT16x16_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(/* nothing */, 16, 32, 16)
# define VINT16x32_LRSHIFT_DEFINED
#endif

#if !defined(VINT16x32_LSHIFT_DEFINED) && defined(VINT16x16_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(/* nothing */, 16, 32, 16)
# define VINT16x32_LSHIFT_DEFINED
#endif



/* vint16x32 */

#if !defined(VUINT16x32_SPLAT_DEFINED) && defined(VUINT16x16_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(u, 16, 32, 16)
# define VUINT16x32_SPLAT_DEFINED
#endif

#if !defined(VUINT16x32_LOAD_ALIGNED_DEFINED) && defined(VUINT16x16_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(u, 16, 32, 16)
# define VUINT16x32_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VUINT16x32_LOAD_DEFINED) && defined(VUINT16x16_LOAD_DEFINED)
VEC_DOUBLE_LOAD(u, 16, 32, 16)
# define VUINT16x32_LOAD_DEFINED
#endif

#if !defined(VUINT16x32_STORE_ALIGNED_DEFINED) && defined(VUINT16x16_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(u, 16, 32, 16)
# define VUINT16x32_STORE_ALIGNED_DEFINED
#endif

#if !defined(VUINT16x32_STORE_DEFINED) && defined(VUINT16x16_STORE_DEFINED)
VEC_DOUBLE_STORE(u, 16, 32, 16)
# define VUINT16x32_STORE_DEFINED
#endif

#if !defined(VUINT16x32_ADD_DEFINED) && defined(VUINT16x16_ADD_DEFINED)
VEC_DOUBLE_ADD(u, 16, 32, 16)
# define VUINT16x32_ADD_DEFINED
#endif

#if !defined(VUINT16x32_SUB_DEFINED) && defined(VUINT16x16_SUB_DEFINED)
VEC_DOUBLE_SUB(u, 16, 32, 16)
# define VUINT16x32_SUB_DEFINED
#endif

#if !defined(VUINT16x32_MUL_DEFINED) && defined(VUINT16x16_MUL_DEFINED)
VEC_DOUBLE_MUL(u, 16, 32, 16)
# define VUINT16x32_MUL_DEFINED
#endif

#if !defined(VUINT16x32_DIV_DEFINED) && defined(VUINT16x16_DIV_DEFINED)
VEC_DOUBLE_DIV(u, 16, 32, 16)
# define VUINT16x32_DIV_DEFINED
#endif

#if !defined(VUINT16x32_MOD_DEFINED) && defined(VUINT16x16_MOD_DEFINED)
VEC_DOUBLE_MOD(u, 16, 32, 16)
# define VUINT16x32_MOD_DEFINED
#endif

#if !defined(VUINT16x32_AVG_DEFINED) && defined(VUINT16x16_AVG_DEFINED)
VEC_DOUBLE_AVG(u, 16, 32, 16)
# define VUINT16x32_AVG_DEFINED
#endif

#if !defined(VUINT16x32_AND_DEFINED) && defined(VUINT16x16_AND_DEFINED)
VEC_DOUBLE_AND(u, 16, 32, 16)
# define VUINT16x32_AND_DEFINED
#endif

#if !defined(VUINT16x32_OR_DEFINED) && defined(VUINT16x16_OR_DEFINED)
VEC_DOUBLE_OR(u, 16, 32, 16)
# define VUINT16x32_OR_DEFINED
#endif

#if !defined(VUINT16x32_XOR_DEFINED) && defined(VUINT16x16_XOR_DEFINED)
VEC_DOUBLE_XOR(u, 16, 32, 16)
# define VUINT16x32_XOR_DEFINED
#endif

#if !defined(VUINT16x32_NOT_DEFINED) && defined(VUINT16x16_NOT_DEFINED)
VEC_DOUBLE_NOT(u, 16, 32, 16)
# define VUINT16x32_NOT_DEFINED
#endif

#if !defined(VUINT16x32_CMPLT_DEFINED) && defined(VUINT16x16_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(u, 16, 32, 16)
# define VUINT16x32_CMPLT_DEFINED
#endif

#if !defined(VUINT16x32_CMPEQ_DEFINED) && defined(VUINT16x16_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(u, 16, 32, 16)
# define VUINT16x32_CMPEQ_DEFINED
#endif

#if !defined(VUINT16x32_CMPGT_DEFINED) && defined(VUINT16x16_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(u, 16, 32, 16)
# define VUINT16x32_CMPGT_DEFINED
#endif

#if !defined(VUINT16x32_CMPLE_DEFINED) && defined(VUINT16x16_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(u, 16, 32, 16)
# define VUINT16x32_CMPLE_DEFINED
#endif

#if !defined(VUINT16x32_CMPGE_DEFINED) && defined(VUINT16x16_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(u, 16, 32, 16)
# define VUINT16x32_CMPGE_DEFINED
#endif

#if !defined(VUINT16x32_MIN_DEFINED) && defined(VUINT16x16_MIN_DEFINED)
VEC_DOUBLE_MIN(u, 16, 32, 16)
# define VUINT16x32_MIN_DEFINED
#endif

#if !defined(VUINT16x32_MAX_DEFINED) && defined(VUINT16x16_MAX_DEFINED)
VEC_DOUBLE_MAX(u, 16, 32, 16)
# define VUINT16x32_MAX_DEFINED
#endif

#if !defined(VUINT16x32_RSHIFT_DEFINED) && defined(VUINT16x16_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(u, 16, 32, 16)
# define VUINT16x32_RSHIFT_DEFINED
#endif

#if !defined(VUINT16x32_LRSHIFT_DEFINED) && defined(VUINT16x16_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(u, 16, 32, 16)
# define VUINT16x32_LRSHIFT_DEFINED
#endif

#if !defined(VUINT16x32_LSHIFT_DEFINED) && defined(VUINT16x16_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(u, 16, 32, 16)
# define VUINT16x32_LSHIFT_DEFINED
#endif



/* vuint32x4 */

#if !defined(VINT32x4_SPLAT_DEFINED) && defined(VINT32x2_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(/* nothing */, 32, 4, 2)
# define VINT32x4_SPLAT_DEFINED
#endif

#if !defined(VINT32x4_LOAD_ALIGNED_DEFINED) && defined(VINT32x2_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(/* nothing */, 32, 4, 2)
# define VINT32x4_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VINT32x4_LOAD_DEFINED) && defined(VINT32x2_LOAD_DEFINED)
VEC_DOUBLE_LOAD(/* nothing */, 32, 4, 2)
# define VINT32x4_LOAD_DEFINED
#endif

#if !defined(VINT32x4_STORE_ALIGNED_DEFINED) && defined(VINT32x2_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(/* nothing */, 32, 4, 2)
# define VINT32x4_STORE_ALIGNED_DEFINED
#endif

#if !defined(VINT32x4_STORE_DEFINED) && defined(VINT32x2_STORE_DEFINED)
VEC_DOUBLE_STORE(/* nothing */, 32, 4, 2)
# define VINT32x4_STORE_DEFINED
#endif

#if !defined(VINT32x4_ADD_DEFINED) && defined(VINT32x2_ADD_DEFINED)
VEC_DOUBLE_ADD(/* nothing */, 32, 4, 2)
# define VINT32x4_ADD_DEFINED
#endif

#if !defined(VINT32x4_SUB_DEFINED) && defined(VINT32x2_SUB_DEFINED)
VEC_DOUBLE_SUB(/* nothing */, 32, 4, 2)
# define VINT32x4_SUB_DEFINED
#endif

#if !defined(VINT32x4_MUL_DEFINED) && defined(VINT32x2_MUL_DEFINED)
VEC_DOUBLE_MUL(/* nothing */, 32, 4, 2)
# define VINT32x4_MUL_DEFINED
#endif

#if !defined(VINT32x4_DIV_DEFINED) && defined(VINT32x2_DIV_DEFINED)
VEC_DOUBLE_DIV(/* nothing */, 32, 4, 2)
# define VINT32x4_DIV_DEFINED
#endif

#if !defined(VINT32x4_MOD_DEFINED) && defined(VINT32x2_MOD_DEFINED)
VEC_DOUBLE_MOD(/* nothing */, 32, 4, 2)
# define VINT32x4_MOD_DEFINED
#endif

#if !defined(VINT32x4_AVG_DEFINED) && defined(VINT32x2_AVG_DEFINED)
VEC_DOUBLE_AVG(/* nothing */, 32, 4, 2)
# define VINT32x4_AVG_DEFINED
#endif

#if !defined(VINT32x4_AND_DEFINED) && defined(VINT32x2_AND_DEFINED)
VEC_DOUBLE_AND(/* nothing */, 32, 4, 2)
# define VINT32x4_AND_DEFINED
#endif

#if !defined(VINT32x4_OR_DEFINED) && defined(VINT32x2_OR_DEFINED)
VEC_DOUBLE_OR(/* nothing */, 32, 4, 2)
# define VINT32x4_OR_DEFINED
#endif

#if !defined(VINT32x4_XOR_DEFINED) && defined(VINT32x2_XOR_DEFINED)
VEC_DOUBLE_XOR(/* nothing */, 32, 4, 2)
# define VINT32x4_XOR_DEFINED
#endif

#if !defined(VINT32x4_NOT_DEFINED) && defined(VINT32x2_NOT_DEFINED)
VEC_DOUBLE_NOT(/* nothing */, 32, 4, 2)
# define VINT32x4_NOT_DEFINED
#endif

#if !defined(VINT32x4_CMPLT_DEFINED) && defined(VINT32x2_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(/* nothing */, 32, 4, 2)
# define VINT32x4_CMPLT_DEFINED
#endif

#if !defined(VINT32x4_CMPEQ_DEFINED) && defined(VINT32x2_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(/* nothing */, 32, 4, 2)
# define VINT32x4_CMPEQ_DEFINED
#endif

#if !defined(VINT32x4_CMPGT_DEFINED) && defined(VINT32x2_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(/* nothing */, 32, 4, 2)
# define VINT32x4_CMPGT_DEFINED
#endif

#if !defined(VINT32x4_CMPLE_DEFINED) && defined(VINT32x2_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(/* nothing */, 32, 4, 2)
# define VINT32x4_CMPLE_DEFINED
#endif

#if !defined(VINT32x4_CMPGE_DEFINED) && defined(VINT32x2_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(/* nothing */, 32, 4, 2)
# define VINT32x4_CMPGE_DEFINED
#endif

#if !defined(VINT32x4_MIN_DEFINED) && defined(VINT32x2_MIN_DEFINED)
VEC_DOUBLE_MIN(/* nothing */, 32, 4, 2)
# define VINT32x4_MIN_DEFINED
#endif

#if !defined(VINT32x4_MAX_DEFINED) && defined(VINT32x2_MAX_DEFINED)
VEC_DOUBLE_MAX(/* nothing */, 32, 4, 2)
# define VINT32x4_MAX_DEFINED
#endif

#if !defined(VINT32x4_RSHIFT_DEFINED) && defined(VINT32x2_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(/* nothing */, 32, 4, 2)
# define VINT32x4_RSHIFT_DEFINED
#endif

#if !defined(VINT32x4_LRSHIFT_DEFINED) && defined(VINT32x2_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(/* nothing */, 32, 4, 2)
# define VINT32x4_LRSHIFT_DEFINED
#endif

#if !defined(VINT32x4_LSHIFT_DEFINED) && defined(VINT32x2_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(/* nothing */, 32, 4, 2)
# define VINT32x4_LSHIFT_DEFINED
#endif



/* vint32x4 */

#if !defined(VUINT32x4_SPLAT_DEFINED) && defined(VUINT32x2_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(u, 32, 4, 2)
# define VUINT32x4_SPLAT_DEFINED
#endif

#if !defined(VUINT32x4_LOAD_ALIGNED_DEFINED) && defined(VUINT32x2_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(u, 32, 4, 2)
# define VUINT32x4_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VUINT32x4_LOAD_DEFINED) && defined(VUINT32x2_LOAD_DEFINED)
VEC_DOUBLE_LOAD(u, 32, 4, 2)
# define VUINT32x4_LOAD_DEFINED
#endif

#if !defined(VUINT32x4_STORE_ALIGNED_DEFINED) && defined(VUINT32x2_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(u, 32, 4, 2)
# define VUINT32x4_STORE_ALIGNED_DEFINED
#endif

#if !defined(VUINT32x4_STORE_DEFINED) && defined(VUINT32x2_STORE_DEFINED)
VEC_DOUBLE_STORE(u, 32, 4, 2)
# define VUINT32x4_STORE_DEFINED
#endif

#if !defined(VUINT32x4_ADD_DEFINED) && defined(VUINT32x2_ADD_DEFINED)
VEC_DOUBLE_ADD(u, 32, 4, 2)
# define VUINT32x4_ADD_DEFINED
#endif

#if !defined(VUINT32x4_SUB_DEFINED) && defined(VUINT32x2_SUB_DEFINED)
VEC_DOUBLE_SUB(u, 32, 4, 2)
# define VUINT32x4_SUB_DEFINED
#endif

#if !defined(VUINT32x4_MUL_DEFINED) && defined(VUINT32x2_MUL_DEFINED)
VEC_DOUBLE_MUL(u, 32, 4, 2)
# define VUINT32x4_MUL_DEFINED
#endif

#if !defined(VUINT32x4_DIV_DEFINED) && defined(VUINT32x2_DIV_DEFINED)
VEC_DOUBLE_DIV(u, 32, 4, 2)
# define VUINT32x4_DIV_DEFINED
#endif

#if !defined(VUINT32x4_MOD_DEFINED) && defined(VUINT32x2_MOD_DEFINED)
VEC_DOUBLE_MOD(u, 32, 4, 2)
# define VUINT32x4_MOD_DEFINED
#endif

#if !defined(VUINT32x4_AVG_DEFINED) && defined(VUINT32x2_AVG_DEFINED)
VEC_DOUBLE_AVG(u, 32, 4, 2)
# define VUINT32x4_AVG_DEFINED
#endif

#if !defined(VUINT32x4_AND_DEFINED) && defined(VUINT32x2_AND_DEFINED)
VEC_DOUBLE_AND(u, 32, 4, 2)
# define VUINT32x4_AND_DEFINED
#endif

#if !defined(VUINT32x4_OR_DEFINED) && defined(VUINT32x2_OR_DEFINED)
VEC_DOUBLE_OR(u, 32, 4, 2)
# define VUINT32x4_OR_DEFINED
#endif

#if !defined(VUINT32x4_XOR_DEFINED) && defined(VUINT32x2_XOR_DEFINED)
VEC_DOUBLE_XOR(u, 32, 4, 2)
# define VUINT32x4_XOR_DEFINED
#endif

#if !defined(VUINT32x4_NOT_DEFINED) && defined(VUINT32x2_NOT_DEFINED)
VEC_DOUBLE_NOT(u, 32, 4, 2)
# define VUINT32x4_NOT_DEFINED
#endif

#if !defined(VUINT32x4_CMPLT_DEFINED) && defined(VUINT32x2_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(u, 32, 4, 2)
# define VUINT32x4_CMPLT_DEFINED
#endif

#if !defined(VUINT32x4_CMPEQ_DEFINED) && defined(VUINT32x2_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(u, 32, 4, 2)
# define VUINT32x4_CMPEQ_DEFINED
#endif

#if !defined(VUINT32x4_CMPGT_DEFINED) && defined(VUINT32x2_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(u, 32, 4, 2)
# define VUINT32x4_CMPGT_DEFINED
#endif

#if !defined(VUINT32x4_CMPLE_DEFINED) && defined(VUINT32x2_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(u, 32, 4, 2)
# define VUINT32x4_CMPLE_DEFINED
#endif

#if !defined(VUINT32x4_CMPGE_DEFINED) && defined(VUINT32x2_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(u, 32, 4, 2)
# define VUINT32x4_CMPGE_DEFINED
#endif

#if !defined(VUINT32x4_MIN_DEFINED) && defined(VUINT32x2_MIN_DEFINED)
VEC_DOUBLE_MIN(u, 32, 4, 2)
# define VUINT32x4_MIN_DEFINED
#endif

#if !defined(VUINT32x4_MAX_DEFINED) && defined(VUINT32x2_MAX_DEFINED)
VEC_DOUBLE_MAX(u, 32, 4, 2)
# define VUINT32x4_MAX_DEFINED
#endif

#if !defined(VUINT32x4_RSHIFT_DEFINED) && defined(VUINT32x2_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(u, 32, 4, 2)
# define VUINT32x4_RSHIFT_DEFINED
#endif

#if !defined(VUINT32x4_LRSHIFT_DEFINED) && defined(VUINT32x2_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(u, 32, 4, 2)
# define VUINT32x4_LRSHIFT_DEFINED
#endif

#if !defined(VUINT32x4_LSHIFT_DEFINED) && defined(VUINT32x2_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(u, 32, 4, 2)
# define VUINT32x4_LSHIFT_DEFINED
#endif



/* vuint32x8 */

#if !defined(VINT32x8_SPLAT_DEFINED) && defined(VINT32x4_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(/* nothing */, 32, 8, 4)
# define VINT32x8_SPLAT_DEFINED
#endif

#if !defined(VINT32x8_LOAD_ALIGNED_DEFINED) && defined(VINT32x4_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(/* nothing */, 32, 8, 4)
# define VINT32x8_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VINT32x8_LOAD_DEFINED) && defined(VINT32x4_LOAD_DEFINED)
VEC_DOUBLE_LOAD(/* nothing */, 32, 8, 4)
# define VINT32x8_LOAD_DEFINED
#endif

#if !defined(VINT32x8_STORE_ALIGNED_DEFINED) && defined(VINT32x4_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(/* nothing */, 32, 8, 4)
# define VINT32x8_STORE_ALIGNED_DEFINED
#endif

#if !defined(VINT32x8_STORE_DEFINED) && defined(VINT32x4_STORE_DEFINED)
VEC_DOUBLE_STORE(/* nothing */, 32, 8, 4)
# define VINT32x8_STORE_DEFINED
#endif

#if !defined(VINT32x8_ADD_DEFINED) && defined(VINT32x4_ADD_DEFINED)
VEC_DOUBLE_ADD(/* nothing */, 32, 8, 4)
# define VINT32x8_ADD_DEFINED
#endif

#if !defined(VINT32x8_SUB_DEFINED) && defined(VINT32x4_SUB_DEFINED)
VEC_DOUBLE_SUB(/* nothing */, 32, 8, 4)
# define VINT32x8_SUB_DEFINED
#endif

#if !defined(VINT32x8_MUL_DEFINED) && defined(VINT32x4_MUL_DEFINED)
VEC_DOUBLE_MUL(/* nothing */, 32, 8, 4)
# define VINT32x8_MUL_DEFINED
#endif

#if !defined(VINT32x8_DIV_DEFINED) && defined(VINT32x4_DIV_DEFINED)
VEC_DOUBLE_DIV(/* nothing */, 32, 8, 4)
# define VINT32x8_DIV_DEFINED
#endif

#if !defined(VINT32x8_MOD_DEFINED) && defined(VINT32x4_MOD_DEFINED)
VEC_DOUBLE_MOD(/* nothing */, 32, 8, 4)
# define VINT32x8_MOD_DEFINED
#endif

#if !defined(VINT32x8_AVG_DEFINED) && defined(VINT32x4_AVG_DEFINED)
VEC_DOUBLE_AVG(/* nothing */, 32, 8, 4)
# define VINT32x8_AVG_DEFINED
#endif

#if !defined(VINT32x8_AND_DEFINED) && defined(VINT32x4_AND_DEFINED)
VEC_DOUBLE_AND(/* nothing */, 32, 8, 4)
# define VINT32x8_AND_DEFINED
#endif

#if !defined(VINT32x8_OR_DEFINED) && defined(VINT32x4_OR_DEFINED)
VEC_DOUBLE_OR(/* nothing */, 32, 8, 4)
# define VINT32x8_OR_DEFINED
#endif

#if !defined(VINT32x8_XOR_DEFINED) && defined(VINT32x4_XOR_DEFINED)
VEC_DOUBLE_XOR(/* nothing */, 32, 8, 4)
# define VINT32x8_XOR_DEFINED
#endif

#if !defined(VINT32x8_NOT_DEFINED) && defined(VINT32x4_NOT_DEFINED)
VEC_DOUBLE_NOT(/* nothing */, 32, 8, 4)
# define VINT32x8_NOT_DEFINED
#endif

#if !defined(VINT32x8_CMPLT_DEFINED) && defined(VINT32x4_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(/* nothing */, 32, 8, 4)
# define VINT32x8_CMPLT_DEFINED
#endif

#if !defined(VINT32x8_CMPEQ_DEFINED) && defined(VINT32x4_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(/* nothing */, 32, 8, 4)
# define VINT32x8_CMPEQ_DEFINED
#endif

#if !defined(VINT32x8_CMPGT_DEFINED) && defined(VINT32x4_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(/* nothing */, 32, 8, 4)
# define VINT32x8_CMPGT_DEFINED
#endif

#if !defined(VINT32x8_CMPLE_DEFINED) && defined(VINT32x4_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(/* nothing */, 32, 8, 4)
# define VINT32x8_CMPLE_DEFINED
#endif

#if !defined(VINT32x8_CMPGE_DEFINED) && defined(VINT32x4_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(/* nothing */, 32, 8, 4)
# define VINT32x8_CMPGE_DEFINED
#endif

#if !defined(VINT32x8_MIN_DEFINED) && defined(VINT32x4_MIN_DEFINED)
VEC_DOUBLE_MIN(/* nothing */, 32, 8, 4)
# define VINT32x8_MIN_DEFINED
#endif

#if !defined(VINT32x8_MAX_DEFINED) && defined(VINT32x4_MAX_DEFINED)
VEC_DOUBLE_MAX(/* nothing */, 32, 8, 4)
# define VINT32x8_MAX_DEFINED
#endif

#if !defined(VINT32x8_RSHIFT_DEFINED) && defined(VINT32x4_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(/* nothing */, 32, 8, 4)
# define VINT32x8_RSHIFT_DEFINED
#endif

#if !defined(VINT32x8_LRSHIFT_DEFINED) && defined(VINT32x4_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(/* nothing */, 32, 8, 4)
# define VINT32x8_LRSHIFT_DEFINED
#endif

#if !defined(VINT32x8_LSHIFT_DEFINED) && defined(VINT32x4_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(/* nothing */, 32, 8, 4)
# define VINT32x8_LSHIFT_DEFINED
#endif



/* vint32x8 */

#if !defined(VUINT32x8_SPLAT_DEFINED) && defined(VUINT32x4_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(u, 32, 8, 4)
# define VUINT32x8_SPLAT_DEFINED
#endif

#if !defined(VUINT32x8_LOAD_ALIGNED_DEFINED) && defined(VUINT32x4_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(u, 32, 8, 4)
# define VUINT32x8_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VUINT32x8_LOAD_DEFINED) && defined(VUINT32x4_LOAD_DEFINED)
VEC_DOUBLE_LOAD(u, 32, 8, 4)
# define VUINT32x8_LOAD_DEFINED
#endif

#if !defined(VUINT32x8_STORE_ALIGNED_DEFINED) && defined(VUINT32x4_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(u, 32, 8, 4)
# define VUINT32x8_STORE_ALIGNED_DEFINED
#endif

#if !defined(VUINT32x8_STORE_DEFINED) && defined(VUINT32x4_STORE_DEFINED)
VEC_DOUBLE_STORE(u, 32, 8, 4)
# define VUINT32x8_STORE_DEFINED
#endif

#if !defined(VUINT32x8_ADD_DEFINED) && defined(VUINT32x4_ADD_DEFINED)
VEC_DOUBLE_ADD(u, 32, 8, 4)
# define VUINT32x8_ADD_DEFINED
#endif

#if !defined(VUINT32x8_SUB_DEFINED) && defined(VUINT32x4_SUB_DEFINED)
VEC_DOUBLE_SUB(u, 32, 8, 4)
# define VUINT32x8_SUB_DEFINED
#endif

#if !defined(VUINT32x8_MUL_DEFINED) && defined(VUINT32x4_MUL_DEFINED)
VEC_DOUBLE_MUL(u, 32, 8, 4)
# define VUINT32x8_MUL_DEFINED
#endif

#if !defined(VUINT32x8_DIV_DEFINED) && defined(VUINT32x4_DIV_DEFINED)
VEC_DOUBLE_DIV(u, 32, 8, 4)
# define VUINT32x8_DIV_DEFINED
#endif

#if !defined(VUINT32x8_MOD_DEFINED) && defined(VUINT32x4_MOD_DEFINED)
VEC_DOUBLE_MOD(u, 32, 8, 4)
# define VUINT32x8_MOD_DEFINED
#endif

#if !defined(VUINT32x8_AVG_DEFINED) && defined(VUINT32x4_AVG_DEFINED)
VEC_DOUBLE_AVG(u, 32, 8, 4)
# define VUINT32x8_AVG_DEFINED
#endif

#if !defined(VUINT32x8_AND_DEFINED) && defined(VUINT32x4_AND_DEFINED)
VEC_DOUBLE_AND(u, 32, 8, 4)
# define VUINT32x8_AND_DEFINED
#endif

#if !defined(VUINT32x8_OR_DEFINED) && defined(VUINT32x4_OR_DEFINED)
VEC_DOUBLE_OR(u, 32, 8, 4)
# define VUINT32x8_OR_DEFINED
#endif

#if !defined(VUINT32x8_XOR_DEFINED) && defined(VUINT32x4_XOR_DEFINED)
VEC_DOUBLE_XOR(u, 32, 8, 4)
# define VUINT32x8_XOR_DEFINED
#endif

#if !defined(VUINT32x8_NOT_DEFINED) && defined(VUINT32x4_NOT_DEFINED)
VEC_DOUBLE_NOT(u, 32, 8, 4)
# define VUINT32x8_NOT_DEFINED
#endif

#if !defined(VUINT32x8_CMPLT_DEFINED) && defined(VUINT32x4_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(u, 32, 8, 4)
# define VUINT32x8_CMPLT_DEFINED
#endif

#if !defined(VUINT32x8_CMPEQ_DEFINED) && defined(VUINT32x4_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(u, 32, 8, 4)
# define VUINT32x8_CMPEQ_DEFINED
#endif

#if !defined(VUINT32x8_CMPGT_DEFINED) && defined(VUINT32x4_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(u, 32, 8, 4)
# define VUINT32x8_CMPGT_DEFINED
#endif

#if !defined(VUINT32x8_CMPLE_DEFINED) && defined(VUINT32x4_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(u, 32, 8, 4)
# define VUINT32x8_CMPLE_DEFINED
#endif

#if !defined(VUINT32x8_CMPGE_DEFINED) && defined(VUINT32x4_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(u, 32, 8, 4)
# define VUINT32x8_CMPGE_DEFINED
#endif

#if !defined(VUINT32x8_MIN_DEFINED) && defined(VUINT32x4_MIN_DEFINED)
VEC_DOUBLE_MIN(u, 32, 8, 4)
# define VUINT32x8_MIN_DEFINED
#endif

#if !defined(VUINT32x8_MAX_DEFINED) && defined(VUINT32x4_MAX_DEFINED)
VEC_DOUBLE_MAX(u, 32, 8, 4)
# define VUINT32x8_MAX_DEFINED
#endif

#if !defined(VUINT32x8_RSHIFT_DEFINED) && defined(VUINT32x4_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(u, 32, 8, 4)
# define VUINT32x8_RSHIFT_DEFINED
#endif

#if !defined(VUINT32x8_LRSHIFT_DEFINED) && defined(VUINT32x4_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(u, 32, 8, 4)
# define VUINT32x8_LRSHIFT_DEFINED
#endif

#if !defined(VUINT32x8_LSHIFT_DEFINED) && defined(VUINT32x4_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(u, 32, 8, 4)
# define VUINT32x8_LSHIFT_DEFINED
#endif



/* vuint32x16 */

#if !defined(VINT32x16_SPLAT_DEFINED) && defined(VINT32x8_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(/* nothing */, 32, 16, 8)
# define VINT32x16_SPLAT_DEFINED
#endif

#if !defined(VINT32x16_LOAD_ALIGNED_DEFINED) && defined(VINT32x8_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(/* nothing */, 32, 16, 8)
# define VINT32x16_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VINT32x16_LOAD_DEFINED) && defined(VINT32x8_LOAD_DEFINED)
VEC_DOUBLE_LOAD(/* nothing */, 32, 16, 8)
# define VINT32x16_LOAD_DEFINED
#endif

#if !defined(VINT32x16_STORE_ALIGNED_DEFINED) && defined(VINT32x8_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(/* nothing */, 32, 16, 8)
# define VINT32x16_STORE_ALIGNED_DEFINED
#endif

#if !defined(VINT32x16_STORE_DEFINED) && defined(VINT32x8_STORE_DEFINED)
VEC_DOUBLE_STORE(/* nothing */, 32, 16, 8)
# define VINT32x16_STORE_DEFINED
#endif

#if !defined(VINT32x16_ADD_DEFINED) && defined(VINT32x8_ADD_DEFINED)
VEC_DOUBLE_ADD(/* nothing */, 32, 16, 8)
# define VINT32x16_ADD_DEFINED
#endif

#if !defined(VINT32x16_SUB_DEFINED) && defined(VINT32x8_SUB_DEFINED)
VEC_DOUBLE_SUB(/* nothing */, 32, 16, 8)
# define VINT32x16_SUB_DEFINED
#endif

#if !defined(VINT32x16_MUL_DEFINED) && defined(VINT32x8_MUL_DEFINED)
VEC_DOUBLE_MUL(/* nothing */, 32, 16, 8)
# define VINT32x16_MUL_DEFINED
#endif

#if !defined(VINT32x16_DIV_DEFINED) && defined(VINT32x8_DIV_DEFINED)
VEC_DOUBLE_DIV(/* nothing */, 32, 16, 8)
# define VINT32x16_DIV_DEFINED
#endif

#if !defined(VINT32x16_MOD_DEFINED) && defined(VINT32x8_MOD_DEFINED)
VEC_DOUBLE_MOD(/* nothing */, 32, 16, 8)
# define VINT32x16_MOD_DEFINED
#endif

#if !defined(VINT32x16_AVG_DEFINED) && defined(VINT32x8_AVG_DEFINED)
VEC_DOUBLE_AVG(/* nothing */, 32, 16, 8)
# define VINT32x16_AVG_DEFINED
#endif

#if !defined(VINT32x16_AND_DEFINED) && defined(VINT32x8_AND_DEFINED)
VEC_DOUBLE_AND(/* nothing */, 32, 16, 8)
# define VINT32x16_AND_DEFINED
#endif

#if !defined(VINT32x16_OR_DEFINED) && defined(VINT32x8_OR_DEFINED)
VEC_DOUBLE_OR(/* nothing */, 32, 16, 8)
# define VINT32x16_OR_DEFINED
#endif

#if !defined(VINT32x16_XOR_DEFINED) && defined(VINT32x8_XOR_DEFINED)
VEC_DOUBLE_XOR(/* nothing */, 32, 16, 8)
# define VINT32x16_XOR_DEFINED
#endif

#if !defined(VINT32x16_NOT_DEFINED) && defined(VINT32x8_NOT_DEFINED)
VEC_DOUBLE_NOT(/* nothing */, 32, 16, 8)
# define VINT32x16_NOT_DEFINED
#endif

#if !defined(VINT32x16_CMPLT_DEFINED) && defined(VINT32x8_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(/* nothing */, 32, 16, 8)
# define VINT32x16_CMPLT_DEFINED
#endif

#if !defined(VINT32x16_CMPEQ_DEFINED) && defined(VINT32x8_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(/* nothing */, 32, 16, 8)
# define VINT32x16_CMPEQ_DEFINED
#endif

#if !defined(VINT32x16_CMPGT_DEFINED) && defined(VINT32x8_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(/* nothing */, 32, 16, 8)
# define VINT32x16_CMPGT_DEFINED
#endif

#if !defined(VINT32x16_CMPLE_DEFINED) && defined(VINT32x8_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(/* nothing */, 32, 16, 8)
# define VINT32x16_CMPLE_DEFINED
#endif

#if !defined(VINT32x16_CMPGE_DEFINED) && defined(VINT32x8_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(/* nothing */, 32, 16, 8)
# define VINT32x16_CMPGE_DEFINED
#endif

#if !defined(VINT32x16_MIN_DEFINED) && defined(VINT32x8_MIN_DEFINED)
VEC_DOUBLE_MIN(/* nothing */, 32, 16, 8)
# define VINT32x16_MIN_DEFINED
#endif

#if !defined(VINT32x16_MAX_DEFINED) && defined(VINT32x8_MAX_DEFINED)
VEC_DOUBLE_MAX(/* nothing */, 32, 16, 8)
# define VINT32x16_MAX_DEFINED
#endif

#if !defined(VINT32x16_RSHIFT_DEFINED) && defined(VINT32x8_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(/* nothing */, 32, 16, 8)
# define VINT32x16_RSHIFT_DEFINED
#endif

#if !defined(VINT32x16_LRSHIFT_DEFINED) && defined(VINT32x8_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(/* nothing */, 32, 16, 8)
# define VINT32x16_LRSHIFT_DEFINED
#endif

#if !defined(VINT32x16_LSHIFT_DEFINED) && defined(VINT32x8_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(/* nothing */, 32, 16, 8)
# define VINT32x16_LSHIFT_DEFINED
#endif



/* vint32x16 */

#if !defined(VUINT32x16_SPLAT_DEFINED) && defined(VUINT32x8_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(u, 32, 16, 8)
# define VUINT32x16_SPLAT_DEFINED
#endif

#if !defined(VUINT32x16_LOAD_ALIGNED_DEFINED) && defined(VUINT32x8_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(u, 32, 16, 8)
# define VUINT32x16_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VUINT32x16_LOAD_DEFINED) && defined(VUINT32x8_LOAD_DEFINED)
VEC_DOUBLE_LOAD(u, 32, 16, 8)
# define VUINT32x16_LOAD_DEFINED
#endif

#if !defined(VUINT32x16_STORE_ALIGNED_DEFINED) && defined(VUINT32x8_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(u, 32, 16, 8)
# define VUINT32x16_STORE_ALIGNED_DEFINED
#endif

#if !defined(VUINT32x16_STORE_DEFINED) && defined(VUINT32x8_STORE_DEFINED)
VEC_DOUBLE_STORE(u, 32, 16, 8)
# define VUINT32x16_STORE_DEFINED
#endif

#if !defined(VUINT32x16_ADD_DEFINED) && defined(VUINT32x8_ADD_DEFINED)
VEC_DOUBLE_ADD(u, 32, 16, 8)
# define VUINT32x16_ADD_DEFINED
#endif

#if !defined(VUINT32x16_SUB_DEFINED) && defined(VUINT32x8_SUB_DEFINED)
VEC_DOUBLE_SUB(u, 32, 16, 8)
# define VUINT32x16_SUB_DEFINED
#endif

#if !defined(VUINT32x16_MUL_DEFINED) && defined(VUINT32x8_MUL_DEFINED)
VEC_DOUBLE_MUL(u, 32, 16, 8)
# define VUINT32x16_MUL_DEFINED
#endif

#if !defined(VUINT32x16_DIV_DEFINED) && defined(VUINT32x8_DIV_DEFINED)
VEC_DOUBLE_DIV(u, 32, 16, 8)
# define VUINT32x16_DIV_DEFINED
#endif

#if !defined(VUINT32x16_MOD_DEFINED) && defined(VUINT32x8_MOD_DEFINED)
VEC_DOUBLE_MOD(u, 32, 16, 8)
# define VUINT32x16_MOD_DEFINED
#endif

#if !defined(VUINT32x16_AVG_DEFINED) && defined(VUINT32x8_AVG_DEFINED)
VEC_DOUBLE_AVG(u, 32, 16, 8)
# define VUINT32x16_AVG_DEFINED
#endif

#if !defined(VUINT32x16_AND_DEFINED) && defined(VUINT32x8_AND_DEFINED)
VEC_DOUBLE_AND(u, 32, 16, 8)
# define VUINT32x16_AND_DEFINED
#endif

#if !defined(VUINT32x16_OR_DEFINED) && defined(VUINT32x8_OR_DEFINED)
VEC_DOUBLE_OR(u, 32, 16, 8)
# define VUINT32x16_OR_DEFINED
#endif

#if !defined(VUINT32x16_XOR_DEFINED) && defined(VUINT32x8_XOR_DEFINED)
VEC_DOUBLE_XOR(u, 32, 16, 8)
# define VUINT32x16_XOR_DEFINED
#endif

#if !defined(VUINT32x16_NOT_DEFINED) && defined(VUINT32x8_NOT_DEFINED)
VEC_DOUBLE_NOT(u, 32, 16, 8)
# define VUINT32x16_NOT_DEFINED
#endif

#if !defined(VUINT32x16_CMPLT_DEFINED) && defined(VUINT32x8_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(u, 32, 16, 8)
# define VUINT32x16_CMPLT_DEFINED
#endif

#if !defined(VUINT32x16_CMPEQ_DEFINED) && defined(VUINT32x8_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(u, 32, 16, 8)
# define VUINT32x16_CMPEQ_DEFINED
#endif

#if !defined(VUINT32x16_CMPGT_DEFINED) && defined(VUINT32x8_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(u, 32, 16, 8)
# define VUINT32x16_CMPGT_DEFINED
#endif

#if !defined(VUINT32x16_CMPLE_DEFINED) && defined(VUINT32x8_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(u, 32, 16, 8)
# define VUINT32x16_CMPLE_DEFINED
#endif

#if !defined(VUINT32x16_CMPGE_DEFINED) && defined(VUINT32x8_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(u, 32, 16, 8)
# define VUINT32x16_CMPGE_DEFINED
#endif

#if !defined(VUINT32x16_MIN_DEFINED) && defined(VUINT32x8_MIN_DEFINED)
VEC_DOUBLE_MIN(u, 32, 16, 8)
# define VUINT32x16_MIN_DEFINED
#endif

#if !defined(VUINT32x16_MAX_DEFINED) && defined(VUINT32x8_MAX_DEFINED)
VEC_DOUBLE_MAX(u, 32, 16, 8)
# define VUINT32x16_MAX_DEFINED
#endif

#if !defined(VUINT32x16_RSHIFT_DEFINED) && defined(VUINT32x8_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(u, 32, 16, 8)
# define VUINT32x16_RSHIFT_DEFINED
#endif

#if !defined(VUINT32x16_LRSHIFT_DEFINED) && defined(VUINT32x8_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(u, 32, 16, 8)
# define VUINT32x16_LRSHIFT_DEFINED
#endif

#if !defined(VUINT32x16_LSHIFT_DEFINED) && defined(VUINT32x8_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(u, 32, 16, 8)
# define VUINT32x16_LSHIFT_DEFINED
#endif



/* vuint64x4 */

#if !defined(VINT64x4_SPLAT_DEFINED) && defined(VINT64x2_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(/* nothing */, 64, 4, 2)
# define VINT64x4_SPLAT_DEFINED
#endif

#if !defined(VINT64x4_LOAD_ALIGNED_DEFINED) && defined(VINT64x2_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(/* nothing */, 64, 4, 2)
# define VINT64x4_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VINT64x4_LOAD_DEFINED) && defined(VINT64x2_LOAD_DEFINED)
VEC_DOUBLE_LOAD(/* nothing */, 64, 4, 2)
# define VINT64x4_LOAD_DEFINED
#endif

#if !defined(VINT64x4_STORE_ALIGNED_DEFINED) && defined(VINT64x2_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(/* nothing */, 64, 4, 2)
# define VINT64x4_STORE_ALIGNED_DEFINED
#endif

#if !defined(VINT64x4_STORE_DEFINED) && defined(VINT64x2_STORE_DEFINED)
VEC_DOUBLE_STORE(/* nothing */, 64, 4, 2)
# define VINT64x4_STORE_DEFINED
#endif

#if !defined(VINT64x4_ADD_DEFINED) && defined(VINT64x2_ADD_DEFINED)
VEC_DOUBLE_ADD(/* nothing */, 64, 4, 2)
# define VINT64x4_ADD_DEFINED
#endif

#if !defined(VINT64x4_SUB_DEFINED) && defined(VINT64x2_SUB_DEFINED)
VEC_DOUBLE_SUB(/* nothing */, 64, 4, 2)
# define VINT64x4_SUB_DEFINED
#endif

#if !defined(VINT64x4_MUL_DEFINED) && defined(VINT64x2_MUL_DEFINED)
VEC_DOUBLE_MUL(/* nothing */, 64, 4, 2)
# define VINT64x4_MUL_DEFINED
#endif

#if !defined(VINT64x4_DIV_DEFINED) && defined(VINT64x2_DIV_DEFINED)
VEC_DOUBLE_DIV(/* nothing */, 64, 4, 2)
# define VINT64x4_DIV_DEFINED
#endif

#if !defined(VINT64x4_MOD_DEFINED) && defined(VINT64x2_MOD_DEFINED)
VEC_DOUBLE_MOD(/* nothing */, 64, 4, 2)
# define VINT64x4_MOD_DEFINED
#endif

#if !defined(VINT64x4_AVG_DEFINED) && defined(VINT64x2_AVG_DEFINED)
VEC_DOUBLE_AVG(/* nothing */, 64, 4, 2)
# define VINT64x4_AVG_DEFINED
#endif

#if !defined(VINT64x4_AND_DEFINED) && defined(VINT64x2_AND_DEFINED)
VEC_DOUBLE_AND(/* nothing */, 64, 4, 2)
# define VINT64x4_AND_DEFINED
#endif

#if !defined(VINT64x4_OR_DEFINED) && defined(VINT64x2_OR_DEFINED)
VEC_DOUBLE_OR(/* nothing */, 64, 4, 2)
# define VINT64x4_OR_DEFINED
#endif

#if !defined(VINT64x4_XOR_DEFINED) && defined(VINT64x2_XOR_DEFINED)
VEC_DOUBLE_XOR(/* nothing */, 64, 4, 2)
# define VINT64x4_XOR_DEFINED
#endif

#if !defined(VINT64x4_NOT_DEFINED) && defined(VINT64x2_NOT_DEFINED)
VEC_DOUBLE_NOT(/* nothing */, 64, 4, 2)
# define VINT64x4_NOT_DEFINED
#endif

#if !defined(VINT64x4_CMPLT_DEFINED) && defined(VINT64x2_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(/* nothing */, 64, 4, 2)
# define VINT64x4_CMPLT_DEFINED
#endif

#if !defined(VINT64x4_CMPEQ_DEFINED) && defined(VINT64x2_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(/* nothing */, 64, 4, 2)
# define VINT64x4_CMPEQ_DEFINED
#endif

#if !defined(VINT64x4_CMPGT_DEFINED) && defined(VINT64x2_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(/* nothing */, 64, 4, 2)
# define VINT64x4_CMPGT_DEFINED
#endif

#if !defined(VINT64x4_CMPLE_DEFINED) && defined(VINT64x2_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(/* nothing */, 64, 4, 2)
# define VINT64x4_CMPLE_DEFINED
#endif

#if !defined(VINT64x4_CMPGE_DEFINED) && defined(VINT64x2_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(/* nothing */, 64, 4, 2)
# define VINT64x4_CMPGE_DEFINED
#endif

#if !defined(VINT64x4_MIN_DEFINED) && defined(VINT64x2_MIN_DEFINED)
VEC_DOUBLE_MIN(/* nothing */, 64, 4, 2)
# define VINT64x4_MIN_DEFINED
#endif

#if !defined(VINT64x4_MAX_DEFINED) && defined(VINT64x2_MAX_DEFINED)
VEC_DOUBLE_MAX(/* nothing */, 64, 4, 2)
# define VINT64x4_MAX_DEFINED
#endif

#if !defined(VINT64x4_RSHIFT_DEFINED) && defined(VINT64x2_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(/* nothing */, 64, 4, 2)
# define VINT64x4_RSHIFT_DEFINED
#endif

#if !defined(VINT64x4_LRSHIFT_DEFINED) && defined(VINT64x2_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(/* nothing */, 64, 4, 2)
# define VINT64x4_LRSHIFT_DEFINED
#endif

#if !defined(VINT64x4_LSHIFT_DEFINED) && defined(VINT64x2_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(/* nothing */, 64, 4, 2)
# define VINT64x4_LSHIFT_DEFINED
#endif



/* vint64x4 */

#if !defined(VUINT64x4_SPLAT_DEFINED) && defined(VUINT64x2_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(u, 64, 4, 2)
# define VUINT64x4_SPLAT_DEFINED
#endif

#if !defined(VUINT64x4_LOAD_ALIGNED_DEFINED) && defined(VUINT64x2_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(u, 64, 4, 2)
# define VUINT64x4_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VUINT64x4_LOAD_DEFINED) && defined(VUINT64x2_LOAD_DEFINED)
VEC_DOUBLE_LOAD(u, 64, 4, 2)
# define VUINT64x4_LOAD_DEFINED
#endif

#if !defined(VUINT64x4_STORE_ALIGNED_DEFINED) && defined(VUINT64x2_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(u, 64, 4, 2)
# define VUINT64x4_STORE_ALIGNED_DEFINED
#endif

#if !defined(VUINT64x4_STORE_DEFINED) && defined(VUINT64x2_STORE_DEFINED)
VEC_DOUBLE_STORE(u, 64, 4, 2)
# define VUINT64x4_STORE_DEFINED
#endif

#if !defined(VUINT64x4_ADD_DEFINED) && defined(VUINT64x2_ADD_DEFINED)
VEC_DOUBLE_ADD(u, 64, 4, 2)
# define VUINT64x4_ADD_DEFINED
#endif

#if !defined(VUINT64x4_SUB_DEFINED) && defined(VUINT64x2_SUB_DEFINED)
VEC_DOUBLE_SUB(u, 64, 4, 2)
# define VUINT64x4_SUB_DEFINED
#endif

#if !defined(VUINT64x4_MUL_DEFINED) && defined(VUINT64x2_MUL_DEFINED)
VEC_DOUBLE_MUL(u, 64, 4, 2)
# define VUINT64x4_MUL_DEFINED
#endif

#if !defined(VUINT64x4_DIV_DEFINED) && defined(VUINT64x2_DIV_DEFINED)
VEC_DOUBLE_DIV(u, 64, 4, 2)
# define VUINT64x4_DIV_DEFINED
#endif

#if !defined(VUINT64x4_MOD_DEFINED) && defined(VUINT64x2_MOD_DEFINED)
VEC_DOUBLE_MOD(u, 64, 4, 2)
# define VUINT64x4_MOD_DEFINED
#endif

#if !defined(VUINT64x4_AVG_DEFINED) && defined(VUINT64x2_AVG_DEFINED)
VEC_DOUBLE_AVG(u, 64, 4, 2)
# define VUINT64x4_AVG_DEFINED
#endif

#if !defined(VUINT64x4_AND_DEFINED) && defined(VUINT64x2_AND_DEFINED)
VEC_DOUBLE_AND(u, 64, 4, 2)
# define VUINT64x4_AND_DEFINED
#endif

#if !defined(VUINT64x4_OR_DEFINED) && defined(VUINT64x2_OR_DEFINED)
VEC_DOUBLE_OR(u, 64, 4, 2)
# define VUINT64x4_OR_DEFINED
#endif

#if !defined(VUINT64x4_XOR_DEFINED) && defined(VUINT64x2_XOR_DEFINED)
VEC_DOUBLE_XOR(u, 64, 4, 2)
# define VUINT64x4_XOR_DEFINED
#endif

#if !defined(VUINT64x4_NOT_DEFINED) && defined(VUINT64x2_NOT_DEFINED)
VEC_DOUBLE_NOT(u, 64, 4, 2)
# define VUINT64x4_NOT_DEFINED
#endif

#if !defined(VUINT64x4_CMPLT_DEFINED) && defined(VUINT64x2_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(u, 64, 4, 2)
# define VUINT64x4_CMPLT_DEFINED
#endif

#if !defined(VUINT64x4_CMPEQ_DEFINED) && defined(VUINT64x2_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(u, 64, 4, 2)
# define VUINT64x4_CMPEQ_DEFINED
#endif

#if !defined(VUINT64x4_CMPGT_DEFINED) && defined(VUINT64x2_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(u, 64, 4, 2)
# define VUINT64x4_CMPGT_DEFINED
#endif

#if !defined(VUINT64x4_CMPLE_DEFINED) && defined(VUINT64x2_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(u, 64, 4, 2)
# define VUINT64x4_CMPLE_DEFINED
#endif

#if !defined(VUINT64x4_CMPGE_DEFINED) && defined(VUINT64x2_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(u, 64, 4, 2)
# define VUINT64x4_CMPGE_DEFINED
#endif

#if !defined(VUINT64x4_MIN_DEFINED) && defined(VUINT64x2_MIN_DEFINED)
VEC_DOUBLE_MIN(u, 64, 4, 2)
# define VUINT64x4_MIN_DEFINED
#endif

#if !defined(VUINT64x4_MAX_DEFINED) && defined(VUINT64x2_MAX_DEFINED)
VEC_DOUBLE_MAX(u, 64, 4, 2)
# define VUINT64x4_MAX_DEFINED
#endif

#if !defined(VUINT64x4_RSHIFT_DEFINED) && defined(VUINT64x2_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(u, 64, 4, 2)
# define VUINT64x4_RSHIFT_DEFINED
#endif

#if !defined(VUINT64x4_LRSHIFT_DEFINED) && defined(VUINT64x2_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(u, 64, 4, 2)
# define VUINT64x4_LRSHIFT_DEFINED
#endif

#if !defined(VUINT64x4_LSHIFT_DEFINED) && defined(VUINT64x2_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(u, 64, 4, 2)
# define VUINT64x4_LSHIFT_DEFINED
#endif



/* vuint64x8 */

#if !defined(VINT64x8_SPLAT_DEFINED) && defined(VINT64x4_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(/* nothing */, 64, 8, 4)
# define VINT64x8_SPLAT_DEFINED
#endif

#if !defined(VINT64x8_LOAD_ALIGNED_DEFINED) && defined(VINT64x4_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(/* nothing */, 64, 8, 4)
# define VINT64x8_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VINT64x8_LOAD_DEFINED) && defined(VINT64x4_LOAD_DEFINED)
VEC_DOUBLE_LOAD(/* nothing */, 64, 8, 4)
# define VINT64x8_LOAD_DEFINED
#endif

#if !defined(VINT64x8_STORE_ALIGNED_DEFINED) && defined(VINT64x4_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(/* nothing */, 64, 8, 4)
# define VINT64x8_STORE_ALIGNED_DEFINED
#endif

#if !defined(VINT64x8_STORE_DEFINED) && defined(VINT64x4_STORE_DEFINED)
VEC_DOUBLE_STORE(/* nothing */, 64, 8, 4)
# define VINT64x8_STORE_DEFINED
#endif

#if !defined(VINT64x8_ADD_DEFINED) && defined(VINT64x4_ADD_DEFINED)
VEC_DOUBLE_ADD(/* nothing */, 64, 8, 4)
# define VINT64x8_ADD_DEFINED
#endif

#if !defined(VINT64x8_SUB_DEFINED) && defined(VINT64x4_SUB_DEFINED)
VEC_DOUBLE_SUB(/* nothing */, 64, 8, 4)
# define VINT64x8_SUB_DEFINED
#endif

#if !defined(VINT64x8_MUL_DEFINED) && defined(VINT64x4_MUL_DEFINED)
VEC_DOUBLE_MUL(/* nothing */, 64, 8, 4)
# define VINT64x8_MUL_DEFINED
#endif

#if !defined(VINT64x8_DIV_DEFINED) && defined(VINT64x4_DIV_DEFINED)
VEC_DOUBLE_DIV(/* nothing */, 64, 8, 4)
# define VINT64x8_DIV_DEFINED
#endif

#if !defined(VINT64x8_MOD_DEFINED) && defined(VINT64x4_MOD_DEFINED)
VEC_DOUBLE_MOD(/* nothing */, 64, 8, 4)
# define VINT64x8_MOD_DEFINED
#endif

#if !defined(VINT64x8_AVG_DEFINED) && defined(VINT64x4_AVG_DEFINED)
VEC_DOUBLE_AVG(/* nothing */, 64, 8, 4)
# define VINT64x8_AVG_DEFINED
#endif

#if !defined(VINT64x8_AND_DEFINED) && defined(VINT64x4_AND_DEFINED)
VEC_DOUBLE_AND(/* nothing */, 64, 8, 4)
# define VINT64x8_AND_DEFINED
#endif

#if !defined(VINT64x8_OR_DEFINED) && defined(VINT64x4_OR_DEFINED)
VEC_DOUBLE_OR(/* nothing */, 64, 8, 4)
# define VINT64x8_OR_DEFINED
#endif

#if !defined(VINT64x8_XOR_DEFINED) && defined(VINT64x4_XOR_DEFINED)
VEC_DOUBLE_XOR(/* nothing */, 64, 8, 4)
# define VINT64x8_XOR_DEFINED
#endif

#if !defined(VINT64x8_NOT_DEFINED) && defined(VINT64x4_NOT_DEFINED)
VEC_DOUBLE_NOT(/* nothing */, 64, 8, 4)
# define VINT64x8_NOT_DEFINED
#endif

#if !defined(VINT64x8_CMPLT_DEFINED) && defined(VINT64x4_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(/* nothing */, 64, 8, 4)
# define VINT64x8_CMPLT_DEFINED
#endif

#if !defined(VINT64x8_CMPEQ_DEFINED) && defined(VINT64x4_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(/* nothing */, 64, 8, 4)
# define VINT64x8_CMPEQ_DEFINED
#endif

#if !defined(VINT64x8_CMPGT_DEFINED) && defined(VINT64x4_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(/* nothing */, 64, 8, 4)
# define VINT64x8_CMPGT_DEFINED
#endif

#if !defined(VINT64x8_CMPLE_DEFINED) && defined(VINT64x4_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(/* nothing */, 64, 8, 4)
# define VINT64x8_CMPLE_DEFINED
#endif

#if !defined(VINT64x8_CMPGE_DEFINED) && defined(VINT64x4_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(/* nothing */, 64, 8, 4)
# define VINT64x8_CMPGE_DEFINED
#endif

#if !defined(VINT64x8_MIN_DEFINED) && defined(VINT64x4_MIN_DEFINED)
VEC_DOUBLE_MIN(/* nothing */, 64, 8, 4)
# define VINT64x8_MIN_DEFINED
#endif

#if !defined(VINT64x8_MAX_DEFINED) && defined(VINT64x4_MAX_DEFINED)
VEC_DOUBLE_MAX(/* nothing */, 64, 8, 4)
# define VINT64x8_MAX_DEFINED
#endif

#if !defined(VINT64x8_RSHIFT_DEFINED) && defined(VINT64x4_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(/* nothing */, 64, 8, 4)
# define VINT64x8_RSHIFT_DEFINED
#endif

#if !defined(VINT64x8_LRSHIFT_DEFINED) && defined(VINT64x4_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(/* nothing */, 64, 8, 4)
# define VINT64x8_LRSHIFT_DEFINED
#endif

#if !defined(VINT64x8_LSHIFT_DEFINED) && defined(VINT64x4_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(/* nothing */, 64, 8, 4)
# define VINT64x8_LSHIFT_DEFINED
#endif



/* vint64x8 */

#if !defined(VUINT64x8_SPLAT_DEFINED) && defined(VUINT64x4_SPLAT_DEFINED)
VEC_DOUBLE_SPLAT(u, 64, 8, 4)
# define VUINT64x8_SPLAT_DEFINED
#endif

#if !defined(VUINT64x8_LOAD_ALIGNED_DEFINED) && defined(VUINT64x4_LOAD_ALIGNED_DEFINED)
VEC_DOUBLE_LOAD_ALIGNED(u, 64, 8, 4)
# define VUINT64x8_LOAD_ALIGNED_DEFINED
#endif

#if !defined(VUINT64x8_LOAD_DEFINED) && defined(VUINT64x4_LOAD_DEFINED)
VEC_DOUBLE_LOAD(u, 64, 8, 4)
# define VUINT64x8_LOAD_DEFINED
#endif

#if !defined(VUINT64x8_STORE_ALIGNED_DEFINED) && defined(VUINT64x4_STORE_ALIGNED_DEFINED)
VEC_DOUBLE_STORE_ALIGNED(u, 64, 8, 4)
# define VUINT64x8_STORE_ALIGNED_DEFINED
#endif

#if !defined(VUINT64x8_STORE_DEFINED) && defined(VUINT64x4_STORE_DEFINED)
VEC_DOUBLE_STORE(u, 64, 8, 4)
# define VUINT64x8_STORE_DEFINED
#endif

#if !defined(VUINT64x8_ADD_DEFINED) && defined(VUINT64x4_ADD_DEFINED)
VEC_DOUBLE_ADD(u, 64, 8, 4)
# define VUINT64x8_ADD_DEFINED
#endif

#if !defined(VUINT64x8_SUB_DEFINED) && defined(VUINT64x4_SUB_DEFINED)
VEC_DOUBLE_SUB(u, 64, 8, 4)
# define VUINT64x8_SUB_DEFINED
#endif

#if !defined(VUINT64x8_MUL_DEFINED) && defined(VUINT64x4_MUL_DEFINED)
VEC_DOUBLE_MUL(u, 64, 8, 4)
# define VUINT64x8_MUL_DEFINED
#endif

#if !defined(VUINT64x8_DIV_DEFINED) && defined(VUINT64x4_DIV_DEFINED)
VEC_DOUBLE_DIV(u, 64, 8, 4)
# define VUINT64x8_DIV_DEFINED
#endif

#if !defined(VUINT64x8_MOD_DEFINED) && defined(VUINT64x4_MOD_DEFINED)
VEC_DOUBLE_MOD(u, 64, 8, 4)
# define VUINT64x8_MOD_DEFINED
#endif

#if !defined(VUINT64x8_AVG_DEFINED) && defined(VUINT64x4_AVG_DEFINED)
VEC_DOUBLE_AVG(u, 64, 8, 4)
# define VUINT64x8_AVG_DEFINED
#endif

#if !defined(VUINT64x8_AND_DEFINED) && defined(VUINT64x4_AND_DEFINED)
VEC_DOUBLE_AND(u, 64, 8, 4)
# define VUINT64x8_AND_DEFINED
#endif

#if !defined(VUINT64x8_OR_DEFINED) && defined(VUINT64x4_OR_DEFINED)
VEC_DOUBLE_OR(u, 64, 8, 4)
# define VUINT64x8_OR_DEFINED
#endif

#if !defined(VUINT64x8_XOR_DEFINED) && defined(VUINT64x4_XOR_DEFINED)
VEC_DOUBLE_XOR(u, 64, 8, 4)
# define VUINT64x8_XOR_DEFINED
#endif

#if !defined(VUINT64x8_NOT_DEFINED) && defined(VUINT64x4_NOT_DEFINED)
VEC_DOUBLE_NOT(u, 64, 8, 4)
# define VUINT64x8_NOT_DEFINED
#endif

#if !defined(VUINT64x8_CMPLT_DEFINED) && defined(VUINT64x4_CMPLT_DEFINED)
VEC_DOUBLE_CMPLT(u, 64, 8, 4)
# define VUINT64x8_CMPLT_DEFINED
#endif

#if !defined(VUINT64x8_CMPEQ_DEFINED) && defined(VUINT64x4_CMPEQ_DEFINED)
VEC_DOUBLE_CMPEQ(u, 64, 8, 4)
# define VUINT64x8_CMPEQ_DEFINED
#endif

#if !defined(VUINT64x8_CMPGT_DEFINED) && defined(VUINT64x4_CMPGT_DEFINED)
VEC_DOUBLE_CMPGT(u, 64, 8, 4)
# define VUINT64x8_CMPGT_DEFINED
#endif

#if !defined(VUINT64x8_CMPLE_DEFINED) && defined(VUINT64x4_CMPLE_DEFINED)
VEC_DOUBLE_CMPLE(u, 64, 8, 4)
# define VUINT64x8_CMPLE_DEFINED
#endif

#if !defined(VUINT64x8_CMPGE_DEFINED) && defined(VUINT64x4_CMPGE_DEFINED)
VEC_DOUBLE_CMPGE(u, 64, 8, 4)
# define VUINT64x8_CMPGE_DEFINED
#endif

#if !defined(VUINT64x8_MIN_DEFINED) && defined(VUINT64x4_MIN_DEFINED)
VEC_DOUBLE_MIN(u, 64, 8, 4)
# define VUINT64x8_MIN_DEFINED
#endif

#if !defined(VUINT64x8_MAX_DEFINED) && defined(VUINT64x4_MAX_DEFINED)
VEC_DOUBLE_MAX(u, 64, 8, 4)
# define VUINT64x8_MAX_DEFINED
#endif

#if !defined(VUINT64x8_RSHIFT_DEFINED) && defined(VUINT64x4_RSHIFT_DEFINED)
VEC_DOUBLE_RSHIFT(u, 64, 8, 4)
# define VUINT64x8_RSHIFT_DEFINED
#endif

#if !defined(VUINT64x8_LRSHIFT_DEFINED) && defined(VUINT64x4_LRSHIFT_DEFINED)
VEC_DOUBLE_LRSHIFT(u, 64, 8, 4)
# define VUINT64x8_LRSHIFT_DEFINED
#endif

#if !defined(VUINT64x8_LSHIFT_DEFINED) && defined(VUINT64x4_LSHIFT_DEFINED)
VEC_DOUBLE_LSHIFT(u, 64, 8, 4)
# define VUINT64x8_LSHIFT_DEFINED
#endif


