/**
 * vec - a tiny SIMD vector library in C99
 * 
 * Copyright (c) 2024 Paper
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
**/

// Sure, this can be a public API.

#ifndef VEC_CPU_H_
#define VEC_CPU_H_

#include "vec/vec.h"

enum {
	VEC_CPU_HAS_ALTIVEC = (1 << 0),
	VEC_CPU_HAS_ALTIVEC_VSX = (1 << 1),
	VEC_CPU_HAS_MMX = (1 << 2),
	VEC_CPU_HAS_SSE = (1 << 3),
	VEC_CPU_HAS_SSE2 = (1 << 4),
	VEC_CPU_HAS_SSE3 = (1 << 5),
	VEC_CPU_HAS_SSE41 = (1 << 6),
	VEC_CPU_HAS_SSE42 = (1 << 7),
	VEC_CPU_HAS_AVX = (1 << 8),
	VEC_CPU_HAS_AVX2 = (1 << 9),
	VEC_CPU_HAS_AVX512F = (1 << 10),
	VEC_CPU_HAS_NEON = (1 << 11),
	VEC_CPU_HAS_AVX512BW = (1 << 12),
	VEC_CPU_HAS_AVX512DQ = (1 << 13),
};

// NOT thread-safe.
vec_uint32 vec_get_CPU_features(void);

#endif /* VEC_CPU_H_ */
