/**
 * vec - a tiny SIMD vector library in plain C99
 * 
 * Copyright (c) 2024 Paper
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
**/

/* Generic array-based implementation. */

#ifndef VEC_IMPL_GENERIC_H_
#define VEC_IMPL_GENERIC_H_

#include "vec/vec.h"

// 16-bit
extern const vint8x2_impl    vint8x2_impl_generic;
extern const vuint8x2_impl   vuint8x2_impl_generic;

// 32-bit
extern const vint8x4_impl    vint8x4_impl_generic;
extern const vuint8x4_impl   vuint8x4_impl_generic;
extern const vint16x2_impl   vint16x2_impl_generic;
extern const vuint16x2_impl  vuint16x2_impl_generic;

// 64-bit
extern const vint8x8_impl    vint8x8_impl_generic;
extern const vuint8x8_impl   vuint8x8_impl_generic;
extern const vint16x4_impl   vint16x4_impl_generic;
extern const vuint16x4_impl  vuint16x4_impl_generic;
extern const vint32x2_impl   vint32x2_impl_generic;
extern const vuint32x2_impl  vuint32x2_impl_generic;

// 128-bit
extern const vint8x16_impl   vint8x16_impl_generic;
extern const vuint8x16_impl  vuint8x16_impl_generic;
extern const vint16x8_impl   vint16x8_impl_generic;
extern const vuint16x8_impl  vuint16x8_impl_generic;
extern const vint32x4_impl   vint32x4_impl_generic;
extern const vuint32x4_impl  vuint32x4_impl_generic;
extern const vint64x2_impl   vint64x2_impl_generic;
extern const vuint64x2_impl  vuint64x2_impl_generic;

// 256-bit
extern const vint8x32_impl   vint8x32_impl_generic;
extern const vuint8x32_impl  vuint8x32_impl_generic;
extern const vint16x16_impl  vint16x16_impl_generic;
extern const vuint16x16_impl vuint16x16_impl_generic;
extern const vint32x8_impl   vint32x8_impl_generic;
extern const vuint32x8_impl  vuint32x8_impl_generic;
extern const vint64x4_impl   vint64x4_impl_generic;
extern const vuint64x4_impl  vuint64x4_impl_generic;

// 512-bit
extern const vint8x64_impl   vint8x64_impl_generic;
extern const vuint8x64_impl  vuint8x64_impl_generic;
extern const vint16x32_impl  vint16x32_impl_generic;
extern const vuint16x32_impl vuint16x32_impl_generic;
extern const vint32x16_impl  vint32x16_impl_generic;
extern const vuint32x16_impl vuint32x16_impl_generic;
extern const vint64x8_impl   vint64x8_impl_generic;
extern const vuint64x8_impl  vuint64x8_impl_generic;

#endif /* VEC_IMPL_GENERIC_H_ */
