/**
 * vec - a tiny SIMD vector library in C99
 * 
 * Copyright (c) 2024-2025 Paper
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
**/

/* This file is automatically generated! Do not edit it directly!
 * Edit the code that generates it in utils/genvsx.c  --paper */

/* ------------------------------------------------------------------------ */
/* PREPROCESSOR HELL INCOMING */

#if !defined(VINT8x16_SPLAT_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_splat(vec_int8 x)
{
	vint8x16 vec;
	vec.altivec = vec_splats(x);
	return vec;
}
# define VINT8x16_SPLAT_DEFINED
#endif
#if !defined(VINT8x16_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_load_aligned(const vec_int8 x[16])
{
	vint8x16 vec;
	vec.altivec = vec_ld(0, x);
	return vec;
}
# define VINT8x16_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VINT8x16_LOAD_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_load(const vec_int8 x[16])
{
	vint8x16 vec;
	vec.altivec = vec_perm(vec_ld(0, x), vec_ld(16, x), vec_lvsl(0, x));
	return vec;
}
# define VINT8x16_LOAD_DEFINED
#endif
#if !defined(VINT8x16_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vint8x16_store_aligned(vint8x16 vec, vec_int8 x[16])
{
	vec_st(vec.altivec, 0, x);
}
# define VINT8x16_STORE_ALIGNED_DEFINED
#endif
#if !defined(VINT8x16_ADD_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_add(vint8x16 vec1, vint8x16 vec2)
{
	vint8x16 vec;
	vec.altivec = (vector signed char)vec_add(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT8x16_ADD_DEFINED
#endif
#if !defined(VINT8x16_SUB_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_sub(vint8x16 vec1, vint8x16 vec2)
{
	vint8x16 vec;
	vec.altivec = (vector signed char)vec_sub(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT8x16_SUB_DEFINED
#endif
#if !defined(VINT8x16_MUL_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_mul(vint8x16 vec1, vint8x16 vec2)
{
	vint8x16 vec;
	vec.altivec = (vector signed char)vec_mul(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT8x16_MUL_DEFINED
#endif
#if !defined(VINT8x16_AVG_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_avg(vint8x16 vec1, vint8x16 vec2)
{
	vint8x16 vec;
	vec.altivec = (vector signed char)vec_avg(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT8x16_AVG_DEFINED
#endif
#if !defined(VINT8x16_AND_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_and(vint8x16 vec1, vint8x16 vec2)
{
	vint8x16 vec;
	vec.altivec = (vector signed char)vec_and(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT8x16_AND_DEFINED
#endif
#if !defined(VINT8x16_OR_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_or(vint8x16 vec1, vint8x16 vec2)
{
	vint8x16 vec;
	vec.altivec = (vector signed char)vec_or(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT8x16_OR_DEFINED
#endif
#if !defined(VINT8x16_XOR_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_xor(vint8x16 vec1, vint8x16 vec2)
{
	vint8x16 vec;
	vec.altivec = (vector signed char)vec_xor(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT8x16_XOR_DEFINED
#endif
#if !defined(VINT8x16_CMPLT_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_cmplt(vint8x16 vec1, vint8x16 vec2)
{
	vint8x16 vec;
	vec.altivec = (vector signed char)vec_cmplt(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT8x16_CMPLT_DEFINED
#endif
#if !defined(VINT8x16_CMPEQ_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_cmpeq(vint8x16 vec1, vint8x16 vec2)
{
	vint8x16 vec;
	vec.altivec = (vector signed char)vec_cmpeq(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT8x16_CMPEQ_DEFINED
#endif
#if !defined(VINT8x16_CMPGT_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_cmpgt(vint8x16 vec1, vint8x16 vec2)
{
	vint8x16 vec;
	vec.altivec = (vector signed char)vec_cmpgt(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT8x16_CMPGT_DEFINED
#endif
#if !defined(VINT8x16_CMPLE_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_cmple(vint8x16 vec1, vint8x16 vec2)
{
	vint8x16 vec;
	vec.altivec = (vector signed char)vec_cmple(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT8x16_CMPLE_DEFINED
#endif
#if !defined(VINT8x16_CMPGE_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_cmpge(vint8x16 vec1, vint8x16 vec2)
{
	vint8x16 vec;
	vec.altivec = (vector signed char)vec_cmpge(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT8x16_CMPGE_DEFINED
#endif
#if !defined(VINT8x16_MIN_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_min(vint8x16 vec1, vint8x16 vec2)
{
	vint8x16 vec;
	vec.altivec = (vector signed char)vec_min(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT8x16_MIN_DEFINED
#endif
#if !defined(VINT8x16_MAX_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_max(vint8x16 vec1, vint8x16 vec2)
{
	vint8x16 vec;
	vec.altivec = (vector signed char)vec_max(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT8x16_MAX_DEFINED
#endif
#if !defined(VINT8x16_RSHIFT_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_rshift(vint8x16 vec1, vuint8x16 vec2)
{
	vint8x16 vec;
	vec.altivec = vec_sra(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT8x16_RSHIFT_DEFINED
#endif
#if !defined(VINT8x16_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_lrshift(vint8x16 vec1, vuint8x16 vec2)
{
	vint8x16 vec;
	vec.altivec = (vector signed char)vec_sr(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT8x16_LRSHIFT_DEFINED
#endif
#if !defined(VINT8x16_LSHIFT_DEFINED)
VEC_FUNC_IMPL vint8x16 vint8x16_lshift(vint8x16 vec1, vuint8x16 vec2)
{
	vint8x16 vec;
	vec.altivec = (vector signed char)vec_sl(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT8x16_LSHIFT_DEFINED
#endif
#if !defined(VUINT8x16_SPLAT_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_splat(vec_uint8 x)
{
	vuint8x16 vec;
	vec.altivec = vec_splats(x);
	return vec;
}
# define VUINT8x16_SPLAT_DEFINED
#endif
#if !defined(VUINT8x16_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_load_aligned(const vec_uint8 x[16])
{
	vuint8x16 vec;
	vec.altivec = vec_ld(0, x);
	return vec;
}
# define VUINT8x16_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VUINT8x16_LOAD_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_load(const vec_uint8 x[16])
{
	vuint8x16 vec;
	vec.altivec = vec_perm(vec_ld(0, x), vec_ld(16, x), vec_lvsl(0, x));
	return vec;
}
# define VUINT8x16_LOAD_DEFINED
#endif
#if !defined(VUINT8x16_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vuint8x16_store_aligned(vuint8x16 vec, vec_uint8 x[16])
{
	vec_st(vec.altivec, 0, x);
}
# define VUINT8x16_STORE_ALIGNED_DEFINED
#endif
#if !defined(VUINT8x16_ADD_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_add(vuint8x16 vec1, vuint8x16 vec2)
{
	vuint8x16 vec;
	vec.altivec = (vector unsigned char)vec_add(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT8x16_ADD_DEFINED
#endif
#if !defined(VUINT8x16_SUB_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_sub(vuint8x16 vec1, vuint8x16 vec2)
{
	vuint8x16 vec;
	vec.altivec = (vector unsigned char)vec_sub(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT8x16_SUB_DEFINED
#endif
#if !defined(VUINT8x16_MUL_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_mul(vuint8x16 vec1, vuint8x16 vec2)
{
	vuint8x16 vec;
	vec.altivec = (vector unsigned char)vec_mul(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT8x16_MUL_DEFINED
#endif
#if !defined(VUINT8x16_AVG_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_avg(vuint8x16 vec1, vuint8x16 vec2)
{
	vuint8x16 vec;
	vec.altivec = (vector unsigned char)vec_avg(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT8x16_AVG_DEFINED
#endif
#if !defined(VUINT8x16_AND_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_and(vuint8x16 vec1, vuint8x16 vec2)
{
	vuint8x16 vec;
	vec.altivec = (vector unsigned char)vec_and(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT8x16_AND_DEFINED
#endif
#if !defined(VUINT8x16_OR_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_or(vuint8x16 vec1, vuint8x16 vec2)
{
	vuint8x16 vec;
	vec.altivec = (vector unsigned char)vec_or(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT8x16_OR_DEFINED
#endif
#if !defined(VUINT8x16_XOR_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_xor(vuint8x16 vec1, vuint8x16 vec2)
{
	vuint8x16 vec;
	vec.altivec = (vector unsigned char)vec_xor(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT8x16_XOR_DEFINED
#endif
#if !defined(VUINT8x16_CMPLT_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_cmplt(vuint8x16 vec1, vuint8x16 vec2)
{
	vuint8x16 vec;
	vec.altivec = (vector unsigned char)vec_cmplt(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT8x16_CMPLT_DEFINED
#endif
#if !defined(VUINT8x16_CMPEQ_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_cmpeq(vuint8x16 vec1, vuint8x16 vec2)
{
	vuint8x16 vec;
	vec.altivec = (vector unsigned char)vec_cmpeq(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT8x16_CMPEQ_DEFINED
#endif
#if !defined(VUINT8x16_CMPGT_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_cmpgt(vuint8x16 vec1, vuint8x16 vec2)
{
	vuint8x16 vec;
	vec.altivec = (vector unsigned char)vec_cmpgt(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT8x16_CMPGT_DEFINED
#endif
#if !defined(VUINT8x16_CMPLE_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_cmple(vuint8x16 vec1, vuint8x16 vec2)
{
	vuint8x16 vec;
	vec.altivec = (vector unsigned char)vec_cmple(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT8x16_CMPLE_DEFINED
#endif
#if !defined(VUINT8x16_CMPGE_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_cmpge(vuint8x16 vec1, vuint8x16 vec2)
{
	vuint8x16 vec;
	vec.altivec = (vector unsigned char)vec_cmpge(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT8x16_CMPGE_DEFINED
#endif
#if !defined(VUINT8x16_MIN_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_min(vuint8x16 vec1, vuint8x16 vec2)
{
	vuint8x16 vec;
	vec.altivec = (vector unsigned char)vec_min(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT8x16_MIN_DEFINED
#endif
#if !defined(VUINT8x16_MAX_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_max(vuint8x16 vec1, vuint8x16 vec2)
{
	vuint8x16 vec;
	vec.altivec = (vector unsigned char)vec_max(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT8x16_MAX_DEFINED
#endif
#if !defined(VUINT8x16_RSHIFT_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_rshift(vuint8x16 vec1, vuint8x16 vec2)
{
	vuint8x16 vec;
	vec.altivec = vec_sr(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT8x16_RSHIFT_DEFINED
#endif
#if !defined(VUINT8x16_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_lrshift(vuint8x16 vec1, vuint8x16 vec2)
{
	vuint8x16 vec;
	vec.altivec = (vector unsigned char)vec_sr(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT8x16_LRSHIFT_DEFINED
#endif
#if !defined(VUINT8x16_LSHIFT_DEFINED)
VEC_FUNC_IMPL vuint8x16 vuint8x16_lshift(vuint8x16 vec1, vuint8x16 vec2)
{
	vuint8x16 vec;
	vec.altivec = (vector unsigned char)vec_sl(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT8x16_LSHIFT_DEFINED
#endif
#if !defined(VINT16x8_SPLAT_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_splat(vec_int16 x)
{
	vint16x8 vec;
	vec.altivec = vec_splats(x);
	return vec;
}
# define VINT16x8_SPLAT_DEFINED
#endif
#if !defined(VINT16x8_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_load_aligned(const vec_int16 x[8])
{
	vint16x8 vec;
	vec.altivec = vec_ld(0, x);
	return vec;
}
# define VINT16x8_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VINT16x8_LOAD_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_load(const vec_int16 x[8])
{
	vint16x8 vec;
	vec.altivec = vec_perm(vec_ld(0, x), vec_ld(16, x), vec_lvsl(0, x));
	return vec;
}
# define VINT16x8_LOAD_DEFINED
#endif
#if !defined(VINT16x8_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vint16x8_store_aligned(vint16x8 vec, vec_int16 x[8])
{
	vec_st(vec.altivec, 0, x);
}
# define VINT16x8_STORE_ALIGNED_DEFINED
#endif
#if !defined(VINT16x8_ADD_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_add(vint16x8 vec1, vint16x8 vec2)
{
	vint16x8 vec;
	vec.altivec = (vector signed short)vec_add(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT16x8_ADD_DEFINED
#endif
#if !defined(VINT16x8_SUB_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_sub(vint16x8 vec1, vint16x8 vec2)
{
	vint16x8 vec;
	vec.altivec = (vector signed short)vec_sub(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT16x8_SUB_DEFINED
#endif
#if !defined(VINT16x8_MUL_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_mul(vint16x8 vec1, vint16x8 vec2)
{
	vint16x8 vec;
	vec.altivec = (vector signed short)vec_mul(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT16x8_MUL_DEFINED
#endif
#if !defined(VINT16x8_AVG_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_avg(vint16x8 vec1, vint16x8 vec2)
{
	vint16x8 vec;
	vec.altivec = (vector signed short)vec_avg(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT16x8_AVG_DEFINED
#endif
#if !defined(VINT16x8_AND_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_and(vint16x8 vec1, vint16x8 vec2)
{
	vint16x8 vec;
	vec.altivec = (vector signed short)vec_and(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT16x8_AND_DEFINED
#endif
#if !defined(VINT16x8_OR_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_or(vint16x8 vec1, vint16x8 vec2)
{
	vint16x8 vec;
	vec.altivec = (vector signed short)vec_or(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT16x8_OR_DEFINED
#endif
#if !defined(VINT16x8_XOR_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_xor(vint16x8 vec1, vint16x8 vec2)
{
	vint16x8 vec;
	vec.altivec = (vector signed short)vec_xor(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT16x8_XOR_DEFINED
#endif
#if !defined(VINT16x8_CMPLT_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_cmplt(vint16x8 vec1, vint16x8 vec2)
{
	vint16x8 vec;
	vec.altivec = (vector signed short)vec_cmplt(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT16x8_CMPLT_DEFINED
#endif
#if !defined(VINT16x8_CMPEQ_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_cmpeq(vint16x8 vec1, vint16x8 vec2)
{
	vint16x8 vec;
	vec.altivec = (vector signed short)vec_cmpeq(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT16x8_CMPEQ_DEFINED
#endif
#if !defined(VINT16x8_CMPGT_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_cmpgt(vint16x8 vec1, vint16x8 vec2)
{
	vint16x8 vec;
	vec.altivec = (vector signed short)vec_cmpgt(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT16x8_CMPGT_DEFINED
#endif
#if !defined(VINT16x8_CMPLE_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_cmple(vint16x8 vec1, vint16x8 vec2)
{
	vint16x8 vec;
	vec.altivec = (vector signed short)vec_cmple(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT16x8_CMPLE_DEFINED
#endif
#if !defined(VINT16x8_CMPGE_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_cmpge(vint16x8 vec1, vint16x8 vec2)
{
	vint16x8 vec;
	vec.altivec = (vector signed short)vec_cmpge(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT16x8_CMPGE_DEFINED
#endif
#if !defined(VINT16x8_MIN_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_min(vint16x8 vec1, vint16x8 vec2)
{
	vint16x8 vec;
	vec.altivec = (vector signed short)vec_min(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT16x8_MIN_DEFINED
#endif
#if !defined(VINT16x8_MAX_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_max(vint16x8 vec1, vint16x8 vec2)
{
	vint16x8 vec;
	vec.altivec = (vector signed short)vec_max(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT16x8_MAX_DEFINED
#endif
#if !defined(VINT16x8_RSHIFT_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_rshift(vint16x8 vec1, vuint16x8 vec2)
{
	vint16x8 vec;
	vec.altivec = vec_sra(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT16x8_RSHIFT_DEFINED
#endif
#if !defined(VINT16x8_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_lrshift(vint16x8 vec1, vuint16x8 vec2)
{
	vint16x8 vec;
	vec.altivec = (vector signed short)vec_sr(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT16x8_LRSHIFT_DEFINED
#endif
#if !defined(VINT16x8_LSHIFT_DEFINED)
VEC_FUNC_IMPL vint16x8 vint16x8_lshift(vint16x8 vec1, vuint16x8 vec2)
{
	vint16x8 vec;
	vec.altivec = (vector signed short)vec_sl(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT16x8_LSHIFT_DEFINED
#endif
#if !defined(VUINT16x8_SPLAT_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_splat(vec_uint16 x)
{
	vuint16x8 vec;
	vec.altivec = vec_splats(x);
	return vec;
}
# define VUINT16x8_SPLAT_DEFINED
#endif
#if !defined(VUINT16x8_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_load_aligned(const vec_uint16 x[8])
{
	vuint16x8 vec;
	vec.altivec = vec_ld(0, x);
	return vec;
}
# define VUINT16x8_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VUINT16x8_LOAD_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_load(const vec_uint16 x[8])
{
	vuint16x8 vec;
	vec.altivec = vec_perm(vec_ld(0, x), vec_ld(16, x), vec_lvsl(0, x));
	return vec;
}
# define VUINT16x8_LOAD_DEFINED
#endif
#if !defined(VUINT16x8_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vuint16x8_store_aligned(vuint16x8 vec, vec_uint16 x[8])
{
	vec_st(vec.altivec, 0, x);
}
# define VUINT16x8_STORE_ALIGNED_DEFINED
#endif
#if !defined(VUINT16x8_ADD_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_add(vuint16x8 vec1, vuint16x8 vec2)
{
	vuint16x8 vec;
	vec.altivec = (vector unsigned short)vec_add(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT16x8_ADD_DEFINED
#endif
#if !defined(VUINT16x8_SUB_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_sub(vuint16x8 vec1, vuint16x8 vec2)
{
	vuint16x8 vec;
	vec.altivec = (vector unsigned short)vec_sub(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT16x8_SUB_DEFINED
#endif
#if !defined(VUINT16x8_MUL_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_mul(vuint16x8 vec1, vuint16x8 vec2)
{
	vuint16x8 vec;
	vec.altivec = (vector unsigned short)vec_mul(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT16x8_MUL_DEFINED
#endif
#if !defined(VUINT16x8_AVG_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_avg(vuint16x8 vec1, vuint16x8 vec2)
{
	vuint16x8 vec;
	vec.altivec = (vector unsigned short)vec_avg(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT16x8_AVG_DEFINED
#endif
#if !defined(VUINT16x8_AND_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_and(vuint16x8 vec1, vuint16x8 vec2)
{
	vuint16x8 vec;
	vec.altivec = (vector unsigned short)vec_and(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT16x8_AND_DEFINED
#endif
#if !defined(VUINT16x8_OR_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_or(vuint16x8 vec1, vuint16x8 vec2)
{
	vuint16x8 vec;
	vec.altivec = (vector unsigned short)vec_or(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT16x8_OR_DEFINED
#endif
#if !defined(VUINT16x8_XOR_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_xor(vuint16x8 vec1, vuint16x8 vec2)
{
	vuint16x8 vec;
	vec.altivec = (vector unsigned short)vec_xor(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT16x8_XOR_DEFINED
#endif
#if !defined(VUINT16x8_CMPLT_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_cmplt(vuint16x8 vec1, vuint16x8 vec2)
{
	vuint16x8 vec;
	vec.altivec = (vector unsigned short)vec_cmplt(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT16x8_CMPLT_DEFINED
#endif
#if !defined(VUINT16x8_CMPEQ_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_cmpeq(vuint16x8 vec1, vuint16x8 vec2)
{
	vuint16x8 vec;
	vec.altivec = (vector unsigned short)vec_cmpeq(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT16x8_CMPEQ_DEFINED
#endif
#if !defined(VUINT16x8_CMPGT_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_cmpgt(vuint16x8 vec1, vuint16x8 vec2)
{
	vuint16x8 vec;
	vec.altivec = (vector unsigned short)vec_cmpgt(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT16x8_CMPGT_DEFINED
#endif
#if !defined(VUINT16x8_CMPLE_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_cmple(vuint16x8 vec1, vuint16x8 vec2)
{
	vuint16x8 vec;
	vec.altivec = (vector unsigned short)vec_cmple(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT16x8_CMPLE_DEFINED
#endif
#if !defined(VUINT16x8_CMPGE_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_cmpge(vuint16x8 vec1, vuint16x8 vec2)
{
	vuint16x8 vec;
	vec.altivec = (vector unsigned short)vec_cmpge(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT16x8_CMPGE_DEFINED
#endif
#if !defined(VUINT16x8_MIN_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_min(vuint16x8 vec1, vuint16x8 vec2)
{
	vuint16x8 vec;
	vec.altivec = (vector unsigned short)vec_min(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT16x8_MIN_DEFINED
#endif
#if !defined(VUINT16x8_MAX_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_max(vuint16x8 vec1, vuint16x8 vec2)
{
	vuint16x8 vec;
	vec.altivec = (vector unsigned short)vec_max(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT16x8_MAX_DEFINED
#endif
#if !defined(VUINT16x8_RSHIFT_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_rshift(vuint16x8 vec1, vuint16x8 vec2)
{
	vuint16x8 vec;
	vec.altivec = vec_sr(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT16x8_RSHIFT_DEFINED
#endif
#if !defined(VUINT16x8_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_lrshift(vuint16x8 vec1, vuint16x8 vec2)
{
	vuint16x8 vec;
	vec.altivec = (vector unsigned short)vec_sr(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT16x8_LRSHIFT_DEFINED
#endif
#if !defined(VUINT16x8_LSHIFT_DEFINED)
VEC_FUNC_IMPL vuint16x8 vuint16x8_lshift(vuint16x8 vec1, vuint16x8 vec2)
{
	vuint16x8 vec;
	vec.altivec = (vector unsigned short)vec_sl(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT16x8_LSHIFT_DEFINED
#endif
#if !defined(VINT32x4_SPLAT_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_splat(vec_int32 x)
{
	vint32x4 vec;
	vec.altivec = vec_splats(x);
	return vec;
}
# define VINT32x4_SPLAT_DEFINED
#endif
#if !defined(VINT32x4_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_load_aligned(const vec_int32 x[4])
{
	vint32x4 vec;
	vec.altivec = vec_ld(0, x);
	return vec;
}
# define VINT32x4_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VINT32x4_LOAD_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_load(const vec_int32 x[4])
{
	vint32x4 vec;
	vec.altivec = vec_perm(vec_ld(0, x), vec_ld(16, x), vec_lvsl(0, x));
	return vec;
}
# define VINT32x4_LOAD_DEFINED
#endif
#if !defined(VINT32x4_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vint32x4_store_aligned(vint32x4 vec, vec_int32 x[4])
{
	vec_st(vec.altivec, 0, x);
}
# define VINT32x4_STORE_ALIGNED_DEFINED
#endif
#if !defined(VINT32x4_ADD_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_add(vint32x4 vec1, vint32x4 vec2)
{
	vint32x4 vec;
	vec.altivec = (vector signed int)vec_add(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT32x4_ADD_DEFINED
#endif
#if !defined(VINT32x4_SUB_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_sub(vint32x4 vec1, vint32x4 vec2)
{
	vint32x4 vec;
	vec.altivec = (vector signed int)vec_sub(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT32x4_SUB_DEFINED
#endif
#if !defined(VINT32x4_MUL_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_mul(vint32x4 vec1, vint32x4 vec2)
{
	vint32x4 vec;
	vec.altivec = (vector signed int)vec_mul(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT32x4_MUL_DEFINED
#endif
#if !defined(VINT32x4_AVG_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_avg(vint32x4 vec1, vint32x4 vec2)
{
	vint32x4 vec;
	vec.altivec = (vector signed int)vec_avg(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT32x4_AVG_DEFINED
#endif
#if !defined(VINT32x4_AND_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_and(vint32x4 vec1, vint32x4 vec2)
{
	vint32x4 vec;
	vec.altivec = (vector signed int)vec_and(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT32x4_AND_DEFINED
#endif
#if !defined(VINT32x4_OR_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_or(vint32x4 vec1, vint32x4 vec2)
{
	vint32x4 vec;
	vec.altivec = (vector signed int)vec_or(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT32x4_OR_DEFINED
#endif
#if !defined(VINT32x4_XOR_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_xor(vint32x4 vec1, vint32x4 vec2)
{
	vint32x4 vec;
	vec.altivec = (vector signed int)vec_xor(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT32x4_XOR_DEFINED
#endif
#if !defined(VINT32x4_CMPLT_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_cmplt(vint32x4 vec1, vint32x4 vec2)
{
	vint32x4 vec;
	vec.altivec = (vector signed int)vec_cmplt(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT32x4_CMPLT_DEFINED
#endif
#if !defined(VINT32x4_CMPEQ_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_cmpeq(vint32x4 vec1, vint32x4 vec2)
{
	vint32x4 vec;
	vec.altivec = (vector signed int)vec_cmpeq(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT32x4_CMPEQ_DEFINED
#endif
#if !defined(VINT32x4_CMPGT_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_cmpgt(vint32x4 vec1, vint32x4 vec2)
{
	vint32x4 vec;
	vec.altivec = (vector signed int)vec_cmpgt(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT32x4_CMPGT_DEFINED
#endif
#if !defined(VINT32x4_CMPLE_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_cmple(vint32x4 vec1, vint32x4 vec2)
{
	vint32x4 vec;
	vec.altivec = (vector signed int)vec_cmple(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT32x4_CMPLE_DEFINED
#endif
#if !defined(VINT32x4_CMPGE_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_cmpge(vint32x4 vec1, vint32x4 vec2)
{
	vint32x4 vec;
	vec.altivec = (vector signed int)vec_cmpge(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT32x4_CMPGE_DEFINED
#endif
#if !defined(VINT32x4_MIN_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_min(vint32x4 vec1, vint32x4 vec2)
{
	vint32x4 vec;
	vec.altivec = (vector signed int)vec_min(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT32x4_MIN_DEFINED
#endif
#if !defined(VINT32x4_MAX_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_max(vint32x4 vec1, vint32x4 vec2)
{
	vint32x4 vec;
	vec.altivec = (vector signed int)vec_max(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT32x4_MAX_DEFINED
#endif
#if !defined(VINT32x4_RSHIFT_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_rshift(vint32x4 vec1, vuint32x4 vec2)
{
	vint32x4 vec;
	vec.altivec = vec_sra(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT32x4_RSHIFT_DEFINED
#endif
#if !defined(VINT32x4_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_lrshift(vint32x4 vec1, vuint32x4 vec2)
{
	vint32x4 vec;
	vec.altivec = (vector signed int)vec_sr(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT32x4_LRSHIFT_DEFINED
#endif
#if !defined(VINT32x4_LSHIFT_DEFINED)
VEC_FUNC_IMPL vint32x4 vint32x4_lshift(vint32x4 vec1, vuint32x4 vec2)
{
	vint32x4 vec;
	vec.altivec = (vector signed int)vec_sl(vec1.altivec, vec2.altivec);
	return vec;
}
# define VINT32x4_LSHIFT_DEFINED
#endif
#if !defined(VUINT32x4_SPLAT_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_splat(vec_uint32 x)
{
	vuint32x4 vec;
	vec.altivec = vec_splats(x);
	return vec;
}
# define VUINT32x4_SPLAT_DEFINED
#endif
#if !defined(VUINT32x4_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_load_aligned(const vec_uint32 x[4])
{
	vuint32x4 vec;
	vec.altivec = vec_ld(0, x);
	return vec;
}
# define VUINT32x4_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VUINT32x4_LOAD_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_load(const vec_uint32 x[4])
{
	vuint32x4 vec;
	vec.altivec = vec_perm(vec_ld(0, x), vec_ld(16, x), vec_lvsl(0, x));
	return vec;
}
# define VUINT32x4_LOAD_DEFINED
#endif
#if !defined(VUINT32x4_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vuint32x4_store_aligned(vuint32x4 vec, vec_uint32 x[4])
{
	vec_st(vec.altivec, 0, x);
}
# define VUINT32x4_STORE_ALIGNED_DEFINED
#endif
#if !defined(VUINT32x4_ADD_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_add(vuint32x4 vec1, vuint32x4 vec2)
{
	vuint32x4 vec;
	vec.altivec = (vector unsigned int)vec_add(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT32x4_ADD_DEFINED
#endif
#if !defined(VUINT32x4_SUB_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_sub(vuint32x4 vec1, vuint32x4 vec2)
{
	vuint32x4 vec;
	vec.altivec = (vector unsigned int)vec_sub(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT32x4_SUB_DEFINED
#endif
#if !defined(VUINT32x4_MUL_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_mul(vuint32x4 vec1, vuint32x4 vec2)
{
	vuint32x4 vec;
	vec.altivec = (vector unsigned int)vec_mul(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT32x4_MUL_DEFINED
#endif
#if !defined(VUINT32x4_AVG_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_avg(vuint32x4 vec1, vuint32x4 vec2)
{
	vuint32x4 vec;
	vec.altivec = (vector unsigned int)vec_avg(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT32x4_AVG_DEFINED
#endif
#if !defined(VUINT32x4_AND_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_and(vuint32x4 vec1, vuint32x4 vec2)
{
	vuint32x4 vec;
	vec.altivec = (vector unsigned int)vec_and(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT32x4_AND_DEFINED
#endif
#if !defined(VUINT32x4_OR_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_or(vuint32x4 vec1, vuint32x4 vec2)
{
	vuint32x4 vec;
	vec.altivec = (vector unsigned int)vec_or(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT32x4_OR_DEFINED
#endif
#if !defined(VUINT32x4_XOR_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_xor(vuint32x4 vec1, vuint32x4 vec2)
{
	vuint32x4 vec;
	vec.altivec = (vector unsigned int)vec_xor(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT32x4_XOR_DEFINED
#endif
#if !defined(VUINT32x4_CMPLT_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_cmplt(vuint32x4 vec1, vuint32x4 vec2)
{
	vuint32x4 vec;
	vec.altivec = (vector unsigned int)vec_cmplt(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT32x4_CMPLT_DEFINED
#endif
#if !defined(VUINT32x4_CMPEQ_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_cmpeq(vuint32x4 vec1, vuint32x4 vec2)
{
	vuint32x4 vec;
	vec.altivec = (vector unsigned int)vec_cmpeq(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT32x4_CMPEQ_DEFINED
#endif
#if !defined(VUINT32x4_CMPGT_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_cmpgt(vuint32x4 vec1, vuint32x4 vec2)
{
	vuint32x4 vec;
	vec.altivec = (vector unsigned int)vec_cmpgt(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT32x4_CMPGT_DEFINED
#endif
#if !defined(VUINT32x4_CMPLE_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_cmple(vuint32x4 vec1, vuint32x4 vec2)
{
	vuint32x4 vec;
	vec.altivec = (vector unsigned int)vec_cmple(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT32x4_CMPLE_DEFINED
#endif
#if !defined(VUINT32x4_CMPGE_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_cmpge(vuint32x4 vec1, vuint32x4 vec2)
{
	vuint32x4 vec;
	vec.altivec = (vector unsigned int)vec_cmpge(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT32x4_CMPGE_DEFINED
#endif
#if !defined(VUINT32x4_MIN_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_min(vuint32x4 vec1, vuint32x4 vec2)
{
	vuint32x4 vec;
	vec.altivec = (vector unsigned int)vec_min(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT32x4_MIN_DEFINED
#endif
#if !defined(VUINT32x4_MAX_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_max(vuint32x4 vec1, vuint32x4 vec2)
{
	vuint32x4 vec;
	vec.altivec = (vector unsigned int)vec_max(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT32x4_MAX_DEFINED
#endif
#if !defined(VUINT32x4_RSHIFT_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_rshift(vuint32x4 vec1, vuint32x4 vec2)
{
	vuint32x4 vec;
	vec.altivec = vec_sr(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT32x4_RSHIFT_DEFINED
#endif
#if !defined(VUINT32x4_LRSHIFT_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_lrshift(vuint32x4 vec1, vuint32x4 vec2)
{
	vuint32x4 vec;
	vec.altivec = (vector unsigned int)vec_sr(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT32x4_LRSHIFT_DEFINED
#endif
#if !defined(VUINT32x4_LSHIFT_DEFINED)
VEC_FUNC_IMPL vuint32x4 vuint32x4_lshift(vuint32x4 vec1, vuint32x4 vec2)
{
	vuint32x4 vec;
	vec.altivec = (vector unsigned int)vec_sl(vec1.altivec, vec2.altivec);
	return vec;
}
# define VUINT32x4_LSHIFT_DEFINED
#endif
#if !defined(VF32x4_SPLAT_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_splat(vec_f32 x)
{
	vf32x4 vec;
	vec.altivec = vec_splats(x);
	return vec;
}
# define VF32x4_SPLAT_DEFINED
#endif
#if !defined(VF32x4_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_load_aligned(const vec_f32 x[4])
{
	vf32x4 vec;
	vec.altivec = vec_ld(0, x);
	return vec;
}
# define VF32x4_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VF32x4_LOAD_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_load(const vec_f32 x[4])
{
	vf32x4 vec;
	vec.altivec = vec_perm(vec_ld(0, x), vec_ld(16, x), vec_lvsl(0, x));
	return vec;
}
# define VF32x4_LOAD_DEFINED
#endif
#if !defined(VF32x4_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vf32x4_store_aligned(vf32x4 vec, vec_f32 x[4])
{
	vec_st(vec.altivec, 0, x);
}
# define VF32x4_STORE_ALIGNED_DEFINED
#endif
#if !defined(VF32x4_ADD_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_add(vf32x4 vec1, vf32x4 vec2)
{
	vf32x4 vec;
	vec.altivec = (vector float)vec_add(vec1.altivec, vec2.altivec);
	return vec;
}
# define VF32x4_ADD_DEFINED
#endif
#if !defined(VF32x4_SUB_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_sub(vf32x4 vec1, vf32x4 vec2)
{
	vf32x4 vec;
	vec.altivec = (vector float)vec_sub(vec1.altivec, vec2.altivec);
	return vec;
}
# define VF32x4_SUB_DEFINED
#endif
#if !defined(VF32x4_MUL_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_mul(vf32x4 vec1, vf32x4 vec2)
{
	vf32x4 vec;
	vec.altivec = (vector float)vec_mul(vec1.altivec, vec2.altivec);
	return vec;
}
# define VF32x4_MUL_DEFINED
#endif
#if !defined(VF32x4_DIV_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_div(vf32x4 vec1, vf32x4 vec2)
{
	vf32x4 vec;
	vec.altivec = (vector float)vec_div(vec1.altivec, vec2.altivec);
	return vec;
}
# define VF32x4_DIV_DEFINED
#endif
#if !defined(VF32x4_CMPLT_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_cmplt(vf32x4 vec1, vf32x4 vec2)
{
	vf32x4 vec;
	vec.altivec = (vector float)vec_cmplt(vec1.altivec, vec2.altivec);
	return vec;
}
# define VF32x4_CMPLT_DEFINED
#endif
#if !defined(VF32x4_CMPEQ_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_cmpeq(vf32x4 vec1, vf32x4 vec2)
{
	vf32x4 vec;
	vec.altivec = (vector float)vec_cmpeq(vec1.altivec, vec2.altivec);
	return vec;
}
# define VF32x4_CMPEQ_DEFINED
#endif
#if !defined(VF32x4_CMPGT_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_cmpgt(vf32x4 vec1, vf32x4 vec2)
{
	vf32x4 vec;
	vec.altivec = (vector float)vec_cmpgt(vec1.altivec, vec2.altivec);
	return vec;
}
# define VF32x4_CMPGT_DEFINED
#endif
#if !defined(VF32x4_CMPLE_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_cmple(vf32x4 vec1, vf32x4 vec2)
{
	vf32x4 vec;
	vec.altivec = (vector float)vec_cmple(vec1.altivec, vec2.altivec);
	return vec;
}
# define VF32x4_CMPLE_DEFINED
#endif
#if !defined(VF32x4_CMPGE_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_cmpge(vf32x4 vec1, vf32x4 vec2)
{
	vf32x4 vec;
	vec.altivec = (vector float)vec_cmpge(vec1.altivec, vec2.altivec);
	return vec;
}
# define VF32x4_CMPGE_DEFINED
#endif
#if !defined(VF32x4_MIN_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_min(vf32x4 vec1, vf32x4 vec2)
{
	vf32x4 vec;
	vec.altivec = (vector float)vec_min(vec1.altivec, vec2.altivec);
	return vec;
}
# define VF32x4_MIN_DEFINED
#endif
#if !defined(VF32x4_MAX_DEFINED)
VEC_FUNC_IMPL vf32x4 vf32x4_max(vf32x4 vec1, vf32x4 vec2)
{
	vf32x4 vec;
	vec.altivec = (vector float)vec_max(vec1.altivec, vec2.altivec);
	return vec;
}
# define VF32x4_MAX_DEFINED
#endif
#if !defined(VF64x2_SPLAT_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_splat(vec_f64 x)
{
	vf64x2 vec;
	vec.altivec = vec_splats(x);
	return vec;
}
# define VF64x2_SPLAT_DEFINED
#endif
#if !defined(VF64x2_LOAD_ALIGNED_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_load_aligned(const vec_f64 x[2])
{
	vf64x2 vec;
	vec.altivec = vec_ld(0, x);
	return vec;
}
# define VF64x2_LOAD_ALIGNED_DEFINED
#endif
#if !defined(VF64x2_LOAD_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_load(const vec_f64 x[2])
{
	vf64x2 vec;
	vec.altivec = vec_perm(vec_ld(0, x), vec_ld(16, x), vec_lvsl(0, x));
	return vec;
}
# define VF64x2_LOAD_DEFINED
#endif
#if !defined(VF64x2_STORE_ALIGNED_DEFINED)
VEC_FUNC_IMPL void vf64x2_store_aligned(vf64x2 vec, vec_f64 x[2])
{
	vec_st(vec.altivec, 0, x);
}
# define VF64x2_STORE_ALIGNED_DEFINED
#endif
#if !defined(VF64x2_ADD_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_add(vf64x2 vec1, vf64x2 vec2)
{
	vf64x2 vec;
	vec.altivec = (vector double)vec_add(vec1.altivec, vec2.altivec);
	return vec;
}
# define VF64x2_ADD_DEFINED
#endif
#if !defined(VF64x2_SUB_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_sub(vf64x2 vec1, vf64x2 vec2)
{
	vf64x2 vec;
	vec.altivec = (vector double)vec_sub(vec1.altivec, vec2.altivec);
	return vec;
}
# define VF64x2_SUB_DEFINED
#endif
#if !defined(VF64x2_MUL_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_mul(vf64x2 vec1, vf64x2 vec2)
{
	vf64x2 vec;
	vec.altivec = (vector double)vec_mul(vec1.altivec, vec2.altivec);
	return vec;
}
# define VF64x2_MUL_DEFINED
#endif
#if !defined(VF64x2_DIV_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_div(vf64x2 vec1, vf64x2 vec2)
{
	vf64x2 vec;
	vec.altivec = (vector double)vec_div(vec1.altivec, vec2.altivec);
	return vec;
}
# define VF64x2_DIV_DEFINED
#endif
#if !defined(VF64x2_CMPLT_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_cmplt(vf64x2 vec1, vf64x2 vec2)
{
	vf64x2 vec;
	vec.altivec = (vector double)vec_cmplt(vec1.altivec, vec2.altivec);
	return vec;
}
# define VF64x2_CMPLT_DEFINED
#endif
#if !defined(VF64x2_CMPEQ_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_cmpeq(vf64x2 vec1, vf64x2 vec2)
{
	vf64x2 vec;
	vec.altivec = (vector double)vec_cmpeq(vec1.altivec, vec2.altivec);
	return vec;
}
# define VF64x2_CMPEQ_DEFINED
#endif
#if !defined(VF64x2_CMPGT_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_cmpgt(vf64x2 vec1, vf64x2 vec2)
{
	vf64x2 vec;
	vec.altivec = (vector double)vec_cmpgt(vec1.altivec, vec2.altivec);
	return vec;
}
# define VF64x2_CMPGT_DEFINED
#endif
#if !defined(VF64x2_CMPLE_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_cmple(vf64x2 vec1, vf64x2 vec2)
{
	vf64x2 vec;
	vec.altivec = (vector double)vec_cmple(vec1.altivec, vec2.altivec);
	return vec;
}
# define VF64x2_CMPLE_DEFINED
#endif
#if !defined(VF64x2_CMPGE_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_cmpge(vf64x2 vec1, vf64x2 vec2)
{
	vf64x2 vec;
	vec.altivec = (vector double)vec_cmpge(vec1.altivec, vec2.altivec);
	return vec;
}
# define VF64x2_CMPGE_DEFINED
#endif
#if !defined(VF64x2_MIN_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_min(vf64x2 vec1, vf64x2 vec2)
{
	vf64x2 vec;
	vec.altivec = (vector double)vec_min(vec1.altivec, vec2.altivec);
	return vec;
}
# define VF64x2_MIN_DEFINED
#endif
#if !defined(VF64x2_MAX_DEFINED)
VEC_FUNC_IMPL vf64x2 vf64x2_max(vf64x2 vec1, vf64x2 vec2)
{
	vf64x2 vec;
	vec.altivec = (vector double)vec_max(vec1.altivec, vec2.altivec);
	return vec;
}
# define VF64x2_MAX_DEFINED
#endif
