/**
 * vec - a tiny SIMD vector library in C99
 * 
 * Copyright (c) 2024-2025 Paper
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
**/

#ifndef VEC_IMPL_X86_SSE3_H_
#define VEC_IMPL_X86_SSE3_H_

/* SSE3 provides a slightly more optimized load function */

#define VEC_SSE3_LOAD(sign, bits, size) \
	VEC_FUNC_IMPL v##sign##int##bits##x##size v##sign##int##bits##x##size##_load(const vec_##sign##int##bits in[size]) \
	{ \
		v##sign##int##bits##x##size vec; \
		vec.sse = _mm_lddqu_si128((const __m128i *)in); \
		return vec; \
	}

/* ------------------------------------------------------------------------ */
/* vint8x16 */

#ifndef VINT8x16_LOAD_DEFINED
VEC_SSE3_LOAD(/* nothing */, 8, 16)
# define VINT8x16_LOAD_DEFINED
#endif

/* ------------------------------------------------------------------------ */
/* vuint8x16 */

#ifndef VUINT8x16_LOAD_DEFINED
VEC_SSE3_LOAD(u, 8, 16)
# define VUINT8x16_LOAD_DEFINED
#endif

/* ------------------------------------------------------------------------ */
/* vint16x8 */

#ifndef VINT16x8_LOAD_DEFINED
VEC_SSE3_LOAD(/* nothing */, 16, 8)
# define VINT16x8_LOAD_DEFINED
#endif

/* ------------------------------------------------------------------------ */
/* vuint32x4 */

#ifndef VUINT16x8_LOAD_DEFINED
VEC_SSE3_LOAD(u, 16, 8)
# define VUINT16x8_LOAD_DEFINED
#endif

/* ------------------------------------------------------------------------ */
/* vint32x4 */

#ifndef VINT32x4_LOAD_DEFINED
VEC_SSE3_LOAD(/* nothing */, 32, 4)
# define VINT32x4_LOAD_DEFINED
#endif

/* ------------------------------------------------------------------------ */
/* vuint32x4 */

#ifndef VUINT32x4_LOAD_DEFINED
VEC_SSE3_LOAD(u, 32, 4)
# define VUINT32x4_LOAD_DEFINED
#endif

/* ------------------------------------------------------------------------ */
/* vint64x2 */

#ifndef VINT64x2_LOAD_DEFINED
VEC_SSE3_LOAD(/* nothing */, 64, 2)
# define VINT64x2_LOAD_DEFINED
#endif

/* ------------------------------------------------------------------------ */
/* vuint64x2 */

#ifndef VUINT64x2_LOAD_DEFINED
VEC_SSE3_LOAD(u, 64, 2)
# define VUINT64x2_LOAD_DEFINED
#endif

#endif /* VEC_IMPL_X86_SSE3_H_ */
