#include "vec/defs.h"

#define DEFINE_VARIANT(type, bits) \
	extern void test_benchmark_sample_minmax_##type##bits##_impl(vec_##type##bits *smpl, \
		uint32_t length, vec_##type##bits *pmin, vec_##type##bits *pmax) \
	{ \
		vec_##type##bits min = *pmin; \
		vec_##type##bits max = *pmax; \
	\
		while (length--) { \
			if (*smpl < min) min = *smpl; \
			if (*smpl > max) max = *smpl; \
	\
			smpl++; \
		} \
	\
		*pmin = min; \
		*pmax = max; \
	}

DEFINE_VARIANT(int, 8)
DEFINE_VARIANT(uint, 8)
DEFINE_VARIANT(int, 16)
DEFINE_VARIANT(uint, 16)
DEFINE_VARIANT(int, 32)
DEFINE_VARIANT(uint, 32)
DEFINE_VARIANT(f, 32)
DEFINE_VARIANT(int, 64)
DEFINE_VARIANT(uint, 64)
DEFINE_VARIANT(f, 64)
