#define CREATE_TEST(type, print, bits, size, op, equiv) \
	static int test_compare_v##type##bits##x##size##_##op(v##type##bits##x##size a, v##type##bits##x##size b) \
	{ \
		vec_##type##bits orig_a[size], orig_b[size], orig_c[size]; \
	\
		v##type##bits##x##size c = v##type##bits##x##size##_##op(a, b); \
	\
		v##type##bits##x##size##_store(a, orig_a); \
		v##type##bits##x##size##_store(b, orig_b); \
		v##type##bits##x##size##_store(c, orig_c); \
	\
		for (int i = 0; i < size; i++) { \
			uint##bits##_t res = (((equiv) ? UINT##bits##_MAX : 0)); \
			if (memcmp(&res, orig_c + i, sizeof(res))) { \
				fprintf(stderr, "v" #type #bits "x" #size "_" #op " test FAILED at index %d: (" #equiv ") [%d] does not equal result [%" print "]!\n", i, equiv, orig_c[i]); \
				print_v##type##bits##x##size(stderr,a); \
				print_v##type##bits##x##size(stderr,b); \
				print_v##type##bits##x##size(stderr,c); \
				fprintf(stderr, "\n"); \
				return 1; \
			} \
		} \
	\
		return 0; \
	}

#define CREATE_TESTS_SIGN(type, print, bits, size) \
	CREATE_TEST(type, print, bits, size, cmplt, orig_a[i] < orig_b[i]) \
	CREATE_TEST(type, print, bits, size, cmpgt, orig_a[i] > orig_b[i]) \
	CREATE_TEST(type, print, bits, size, cmpeq, orig_a[i] == orig_b[i]) \
	CREATE_TEST(type, print, bits, size, cmple, orig_a[i] <= orig_b[i]) \
	CREATE_TEST(type, print, bits, size, cmpge, orig_a[i] >= orig_b[i])

#define CREATE_TESTS_INT(bits, size) \
	CREATE_TESTS_SIGN(int,  PRI##d##bits, bits, size) \
	CREATE_TESTS_SIGN(uint, PRI##u##bits, bits, size)

#define CREATE_TESTS_FLOAT(bits, size) \
	CREATE_TESTS_SIGN(f, "f", bits, size)

CREATE_TESTS_INT(8, 2)

CREATE_TESTS_INT(8, 4)
CREATE_TESTS_INT(16, 2)

CREATE_TESTS_INT(8, 8)
CREATE_TESTS_INT(16, 4)
CREATE_TESTS_INT(32, 2)

CREATE_TESTS_INT(8, 16)
CREATE_TESTS_INT(16, 8)
CREATE_TESTS_INT(32, 4)
CREATE_TESTS_INT(64, 2)

CREATE_TESTS_INT(8, 32)
CREATE_TESTS_INT(16, 16)
CREATE_TESTS_INT(32, 8)
CREATE_TESTS_INT(64, 4)

CREATE_TESTS_INT(8, 64)
CREATE_TESTS_INT(16, 32)
CREATE_TESTS_INT(32, 16)
CREATE_TESTS_INT(64, 8)

CREATE_TESTS_FLOAT(32, 2)
CREATE_TESTS_FLOAT(32, 4)
CREATE_TESTS_FLOAT(32, 8)
CREATE_TESTS_FLOAT(32, 16)

CREATE_TESTS_FLOAT(64, 2)
CREATE_TESTS_FLOAT(64, 4)
CREATE_TESTS_FLOAT(64, 8)

#undef CREATE_TESTS_SIGN
#undef CREATE_TESTS_INT
#undef CREATE_TESTS_FLOAT
#undef CREATE_TEST

static int test_compare(void)
{
	int ret = 0;

#define RUN_TESTS_SIGN(shorttype, type, bits, size) \
	for (size_t i = 0U; i < ARRAY_SIZE(testval##shorttype##bits); i++) { \
		const v##type##bits##x##size a = vtest##shorttype##bits##x##size(i); \
		for (size_t j = 0U; j < ARRAY_SIZE(testval##shorttype##bits); j++) { \
			const v##type##bits##x##size b = vtest##shorttype##bits##x##size(j); \
			ret |= test_compare_v##type##bits##x##size##_cmplt(a, b); \
			ret |= test_compare_v##type##bits##x##size##_cmpgt(a, b); \
			ret |= test_compare_v##type##bits##x##size##_cmpeq(a, b); \
			ret |= test_compare_v##type##bits##x##size##_cmple(a, b); \
			ret |= test_compare_v##type##bits##x##size##_cmpge(a, b); \
		} \
	}

#define RUN_TESTS(bits, size) \
	RUN_TESTS_SIGN( , int, bits, size) \
	RUN_TESTS_SIGN(u, uint, bits, size)

#define RUN_TESTS_FLOAT(bits, size) \
	RUN_TESTS_SIGN(f, f, bits, size)

	RUN_TESTS(8, 2)

	RUN_TESTS(8, 4)
	RUN_TESTS(16, 2)

	RUN_TESTS(8, 8)
	RUN_TESTS(16, 4)
	RUN_TESTS(32, 2)

	RUN_TESTS(8, 16)
	RUN_TESTS(16, 8)
	RUN_TESTS(32, 4)
	RUN_TESTS(64, 2)

	RUN_TESTS(8, 32)
	RUN_TESTS(16, 16)
	RUN_TESTS(32, 8)
	RUN_TESTS(64, 4)

	RUN_TESTS(8, 64)
	RUN_TESTS(16, 32)
	RUN_TESTS(32, 16)
	RUN_TESTS(64, 8)

	RUN_TESTS_FLOAT(32, 2)
	RUN_TESTS_FLOAT(32, 4)
	RUN_TESTS_FLOAT(32, 8)
	RUN_TESTS_FLOAT(32, 16)

	RUN_TESTS_FLOAT(64, 2)
	RUN_TESTS_FLOAT(64, 4)
	RUN_TESTS_FLOAT(64, 8)

#undef RUN_TESTS_SIGN
#undef RUN_TESTS_FLOAT
#undef RUN_TESTS

	return ret;
}
