/**
 * vec - a tiny SIMD vector library in C99
 * 
 * Copyright (c) 2024 Paper
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
**/

#ifndef VEC_IMPL_X86_SSE41_H_
#define VEC_IMPL_X86_SSE41_H_

#define VEC_SSE41_DEFINE_OPERATIONS(sign) \
	static v##sign##int32x4 v##sign##int32x4_sse41_mul(v##sign##int32x4 vec1, v##sign##int32x4 vec2) \
	{ \
		return (v##sign##int32x4){ .sse = _mm_mullo_epi32(vec1.sse, vec2.sse) }; \
	} \
	\
	static v##sign##int32x4_impl v##sign##int32x4_impl_sse41 = { \
		.load_aligned  = v##sign##int32x4_sse2_load_aligned, \
		.load          = v##sign##int32x4_sse2_load, \
		.store_aligned = v##sign##int32x4_sse2_store_aligned, \
		.store         = v##sign##int32x4_sse2_store, \
		.add           = v##sign##int32x4_sse2_add, \
		.sub           = v##sign##int32x4_sse2_sub, \
		.mul           = v##sign##int32x4_sse41_mul, \
		.and           = v##sign##int32x4_sse2_and, \
		.or            = v##sign##int32x4_sse2_or, \
		.xor           = v##sign##int32x4_sse2_xor, \
		.lshift        = v##sign##int32x4_sse2_lshift, \
		.rshift        = v##sign##int32x4_sse2_rshift, \
		.lrshift       = v##sign##int32x4_sse2_lrshift, \
	};

VEC_SSE41_DEFINE_OPERATIONS()
VEC_SSE41_DEFINE_OPERATIONS(u)

#undef VEC_SSE41_DEFINE_OPERATIONS

#endif /* VEC_IMPL_X86_SSE41_H_ */
