/**
 * vec - a tiny SIMD vector library in C99
 * 
 * Copyright (c) 2024 Paper
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
**/

#include "vec/impl/x86/sse41.h"
#include "vec/impl/x86/sse2.h"
#include "vec/impl/generic.h"

#include <immintrin.h>

// SSE 4.1 provides a real _mm_mullo_epi32
#define VEC_SSE41_DEFINE_OPERATIONS(sign) \
	union v##sign##int32x4_impl_data { \
		v##sign##int32x4 vec; \
		__m128i sse; \
	}; \
	\
	static v##sign##int32x4 v##sign##int32x4_sse41_mul(v##sign##int32x4 vec1, v##sign##int32x4 vec2) \
	{ \
		union v##sign##int32x4_impl_data *vec1d = (union v##sign##int32x4_impl_data *)&vec1; \
		union v##sign##int32x4_impl_data *vec2d = (union v##sign##int32x4_impl_data *)&vec2; \
	\
		vec1d->sse = _mm_mullo_epi32(vec1d->sse, vec2d->sse); \
		return vec1d->vec; \
	} \
	\
	const v##sign##int32x4_impl v##sign##int32x4_impl_sse41 = { \
		v##sign##int32x4_generic_splat, \
		v##sign##int32x4_sse2_load_aligned, \
		v##sign##int32x4_sse2_load, \
		v##sign##int32x4_sse2_store_aligned, \
		v##sign##int32x4_sse2_store, \
		v##sign##int32x4_sse2_add, \
		v##sign##int32x4_sse2_sub, \
		v##sign##int32x4_sse41_mul, \
		v##sign##int32x4_generic_div, \
		v##sign##int32x4_generic_avg, \
		v##sign##int32x4_sse2_and, \
		v##sign##int32x4_sse2_or, \
		v##sign##int32x4_sse2_xor, \
		v##sign##int32x4_generic_not, \
		v##sign##int32x4_generic_lshift, \
		v##sign##int32x4_generic_rshift, \
		v##sign##int32x4_generic_lrshift, \
		v##sign##int32x4_generic_cmplt, \
		v##sign##int32x4_generic_cmple, \
		v##sign##int32x4_sse2_cmpeq, \
		v##sign##int32x4_generic_cmpge, \
		v##sign##int32x4_generic_cmpgt, \
	};

VEC_SSE41_DEFINE_OPERATIONS()
VEC_SSE41_DEFINE_OPERATIONS(u)
