#define CREATE_TEST(sign, psign, bits, size, op, equiv) \
	static int test_arith_v##sign##int##bits##x##size##_##op(v##sign##int##bits##x##size a, v##sign##int##bits##x##size b) \
	{ \
		sign##int##bits##_t orig_a[size], orig_b[size], orig_c[size]; \
	\
		v##sign##int##bits##x##size c = v##sign##int##bits##x##size##_##op(a, b); \
	\
		v##sign##int##bits##x##size##_store(a, orig_a); \
		v##sign##int##bits##x##size##_store(b, orig_b); \
		v##sign##int##bits##x##size##_store(c, orig_c); \
	\
		for (int i = 0; i < size; i++) { \
			if ((sign##int##bits##_t)(equiv) != orig_c[i]) { \
				fprintf(stderr, "v" #sign "int" #bits "x" #size "_" #op " test FAILED at index %d: (" #equiv ") [%" PRI ## psign ## bits "] does not equal result [%" PRI ## psign ## bits "]!\n", i, equiv, orig_c[i]); \
				print_v##sign##int##bits##x##size(stderr,a); \
				print_v##sign##int##bits##x##size(stderr,b); \
				print_v##sign##int##bits##x##size(stderr,c); \
				fprintf(stderr, "\n"); \
				return 1; \
			} \
		} \
	\
		return 0; \
	}

#define CREATE_TEST_SHIFT(sign, psign, bits, size, op, equiv) \
	static int test_arith_v##sign##int##bits##x##size##_##op(v##sign##int##bits##x##size a, vuint##bits##x##size b) \
	{ \
		sign##int##bits##_t orig_a[size], orig_c[size]; \
		uint##bits##_t orig_b[size]; \
	\
		v##sign##int##bits##x##size c = v##sign##int##bits##x##size##_##op(a, b); \
	\
		v##sign##int##bits##x##size##_store(a, orig_a); \
		vuint##bits##x##size##_store(b, orig_b); \
		v##sign##int##bits##x##size##_store(c, orig_c); \
	\
		for (int i = 0; i < size; i++) { \
			if ((sign##int##bits##_t)(equiv) != orig_c[i]) { \
				fprintf(stderr, "v" #sign "int" #bits "x" #size "_" #op " test FAILED at index %d: (" #equiv ") [%" PRI ## psign ## bits "] does not equal result [%" PRI ## psign ## bits "]!\n", i, equiv, orig_c[i]); \
				print_v##sign##int##bits##x##size(stderr,a); \
				print_vuint##bits##x##size(stderr,b); \
				print_v##sign##int##bits##x##size(stderr,c); \
				fprintf(stderr, "\n"); \
				return 1; \
			} \
		} \
	\
		return 0; \
	}

#define CREATE_TESTS(sign, psign, bits, size) \
	CREATE_TEST(sign, psign, bits, size, add, orig_a[i] + orig_b[i]) \
	CREATE_TEST(sign, psign, bits, size, sub, orig_a[i] - orig_b[i]) \
	CREATE_TEST(sign, psign, bits, size, mul, orig_a[i] * orig_b[i]) \
	CREATE_TEST(sign, psign, bits, size, div, (orig_b[i]) ? (orig_a[i] / orig_b[i]) : 0) \
	CREATE_TEST(sign, psign, bits, size, and, orig_a[i] & orig_b[i]) \
	CREATE_TEST(sign, psign, bits, size, or,  orig_a[i] | orig_b[i]) \
	CREATE_TEST(sign, psign, bits, size, xor, orig_a[i] ^ orig_b[i]) \
	CREATE_TEST(sign, psign, bits, size, avg, (orig_a[i] * orig_b[i]) / 2) \
	CREATE_TEST_SHIFT(sign, psign, bits, size, rshift, vec_##sign##rshift(orig_a[i], orig_b[i])) \
	CREATE_TEST_SHIFT(sign, psign, bits, size, lshift, vec_##sign##lshift(orig_a[i], orig_b[i])) \
	CREATE_TEST_SHIFT(sign, psign, bits, size, lrshift, vec_##sign##lrshift(orig_a[i], orig_b[i]))

#define CREATE_TESTS_2(bits, size) \
	CREATE_TESTS(, d, bits, size) \
	CREATE_TESTS(u, u, bits, size)

CREATE_TESTS_2(8, 16)
CREATE_TESTS_2(16, 8)
CREATE_TESTS_2(32, 4)
CREATE_TESTS_2(64, 2)

#undef CREATE_TESTS_2
#undef CREATE_TESTS
#undef CREATE_TEST

static int test_arith(void)
{
	int ret = 0;

#define RUN_TESTS(sign, bits, size) \
	for (size_t i = 0U; i < ARRAY_SIZE(testval##sign##bits); i++) { \
		const v##sign##int##bits##x##size a = vtest##sign##bits##x##size(i); \
		for (size_t j = 0U; j < ARRAY_SIZE(testval##sign##bits); j++) { \
			const v##sign##int##bits##x##size b = vtest##sign##bits##x##size(j); \
			ret |= test_arith_v##sign##int##bits##x##size##_add(a, b); \
			ret |= test_arith_v##sign##int##bits##x##size##_sub(a, b); \
			ret |= test_arith_v##sign##int##bits##x##size##_mul(a, b); \
			ret |= test_arith_v##sign##int##bits##x##size##_div(a, b); \
			ret |= test_arith_v##sign##int##bits##x##size##_and(a, b); \
			ret |= test_arith_v##sign##int##bits##x##size##_or(a, b); \
			ret |= test_arith_v##sign##int##bits##x##size##_xor(a, b); \
		} \
	} \
	\
	for (size_t i = 0U; i < ARRAY_SIZE(testval##sign##bits); i++) { \
		const v##sign##int##bits##x##size a = vtest##sign##bits##x##size(i); \
		for (size_t j = 0U; j < ARRAY_SIZE(testvalu##bits); j++) { \
			const vuint##bits##x##size b = vtestu##bits##x##size(j); \
			ret |= test_arith_v##sign##int##bits##x##size##_rshift(a, b); \
			ret |= test_arith_v##sign##int##bits##x##size##_lshift(a, b); \
			ret |= test_arith_v##sign##int##bits##x##size##_lrshift(a, b); \
		} \
	}

#define RUN_TESTS_2(bits, size) \
	RUN_TESTS(, bits, size) \
	RUN_TESTS(u, bits, size)

	RUN_TESTS_2(8, 16)
	RUN_TESTS_2(16, 8)
	RUN_TESTS_2(32, 4)
	RUN_TESTS_2(64, 2)

#undef RUN_TESTS_2
#undef RUN_TESTS

	return ret;
}