#include <stdio.h>
#include <stdint.h>
#include <dpmi.h>
#include <go32.h>
#include <sys/farptr.h>
#include <stdlib.h>
#include <string.h>
#include <inttypes.h>
#include <dos.h>

#include "vbe.h"

int main(void)
{
	uint8_t *framebuffer;
	struct vbe vbe;
	int x, y;

	framebuffer = malloc(640 * 400);

	vbe_init(&vbe, 640, 400);

	{
		for (x = 0; x < 640; x++)
			for (y = 0; y < 400; y++)
				framebuffer[(y * 640) + x] = vbe_rgb(&vbe, (x + 10), (y + 10), 0xFF);

		vbe_blit(&vbe, framebuffer);
	}

	delay(5000);

	free(framebuffer);

	vbe_quit(&vbe);

	printf("vbe.bpp: %d", vbe.bpp);

	return 0;
}
