/*
 * wcc -- a shitty sockchat client
 *
 * Copyright (c) 2025 Paper
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#ifndef WCC_FLASHII_H_
#define WCC_FLASHII_H_

#include <stdint.h>

/* opaque type */
struct flashii;

struct flashii_msg {
	int64_t timestamp; /* UNIX timestamp */
	char *id; /* user ID of the author */
	char *body; /* message body; sanitized. this is HTML/BBcode */
	char *msg_id; /* message ID (lol) */

#define FLASHII_MSG_FLAG_BOLD (0x01)
#define FLASHII_MSG_FLAG_CURSIVE (0x02) /* AKA italics */
#define FLASHII_MSG_FLAG_UNDERLINE (0x04)
#define FLASHII_MSG_FLAG_COLON (0x08)
#define FLASHII_MSG_FLAG_PRIVATE (0x10) /* private message */
	uint32_t flags;
};

typedef void (*flashii_msg_recv_spec)(struct flashii *fls, struct flashii_msg *msg);

struct flashii_user {
	char *id;
	char *name;
	/* char *color; -- dont care */
	/* (?) perms; -- dont care */
	int32_t visible;
};

typedef void (*flashii_user_recv_spec)(struct flashii *fls, struct flashii_user *user);

struct flashii *flashii_init(const char *protocol, const char *address,
	uint16_t port, flashii_msg_recv_spec msg_recv,
	flashii_user_recv_spec user_recv);
void flashii_work(struct flashii *fls, int noblock);
int flashii_send_message(struct flashii *fls, const char *msg);
/* TODO flashii_quit */

#endif /* WCC_FLASHII_H_ */
